/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _SETTINGSDIALOG_H_
#define _SETTINGSDIALOG_H_

#include <qpushbutton.h>
#include <qstring.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>

#include "rcdatei.h"
#include "mysqlinterface.h"

class settingsdialog : public QWidget
  {
    Q_OBJECT
  public:
    settingsdialog(QWidget *);
    ~settingsdialog();
    bool vervollstaendigen;
    bool mysql;
    void start();
    KIconLoader *loader;
    QGroupBox *settingsgroupbox;
    QGroupBox *filtergroupbox;
    QGroupBox *filtergroupbox2;
    QGroupBox *pathgroupbox;
    QGroupBox *kyamogroupbox;
    //tagger
    QLineEdit *readingpathledit;
    QPushButton *readingpathbutton;
    QLineEdit *destinationpathledit;
    QPushButton *destinationpathbutton;
    QLineEdit *rejectpathledit;
    QPushButton *rejectpathbutton;
    QLineEdit *temppathledit;
    QPushButton *temppathbutton;
    //Filtersystem
    QComboBox *filterbox;
    QPushButton *directorybutton;
    QPushButton *yearbutton;
    QPushButton *artistbutton;
    QPushButton *songbutton;
    QPushButton *trackbutton;
    QPushButton *albumbutton;
    QPushButton *genrebutton;
    //kyamo
    QCheckBox *autocompletionbox;
    QCheckBox *mysqlbox;
    QCheckBox *deletebox;
    QCheckBox *overwritebox;
    QCheckBox *betterbox;
  private:
  public slots:
    //pathslots
    void getreadingpath();
    void setreadingpath();
    void getdestinationpath();
    void setdestinationpath();
    void getrejectpath();
    void setrejectpath();
    void gettemppath();
    void settemppath();
    //filter slots
    void dirslashslot();
    void yearslot();
    void artistslot();
    void songslot();
    void trackslot();
    void albumslot();
    void genreslot();
    void savefilter(const QString &);
    //k-yamo slots
    void vervollstaendigenwechsel();
    void mysqlwechsel();
    void deleteslot();
    void overwriteslot();
    void betterslot();
  signals:
    void verzeichniswechsel();
    void vervollstaendigensignal(bool);
    void mysqlsignal();
  };

#endif //_SETTINGSDIALOG_H_
