/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "rcdatei.h"


void rcdatei::load()
{
    import=FALSE;
    QString buffer;
    QFile *settingsfile=new QFile(QString("%1/.k-yamo.rc").arg(QDir::homeDirPath()));
    //If Settingsfile exists, read out all values, and set the right variables
    //init bitrate with zero, so we can check for it later
    //set some defaultvalues for encoders
    encodingengine=0;//Set encoder to lame,till we read the right one
    lamebitrate=128;
    gogobitrate=128;
    bladeencbitrate=128;
    oggencbitrate=128;
    oggencvbr=FALSE;
    verbose=TRUE;
    lameexe=QString("/usr/bin/lame");
    lameoptions=QString("-ms");
    gogoexe=QString("/usr/bin/gogo");
    gogooptions=QString("-ms");
    bladeencexe=QString("/usr/bin/bladeenc");
    bladeencoptions=QString("-nogap -prio=NORMAL");
    oggencexe=QString("/usr/bin/oggenc");
    playertype=0;//0=mplayer,more to follow someday
    mplayerexe=QString("/usr/bin/mplayer");
    tagversion=0;
    freedbsupport=0;
    musicbrainzsupport=0;
    databasetype=0;
    //Set picturename,picturesize, and pictureformat to standard values
    picturename="cover";
    picturesize=75;
    pictureformat="bmp";
    savepicture=FALSE;
    if(settingsfile->open(IO_ReadOnly))
    {
        QTextStream readsettings(settingsfile);
        readsettings.setEncoding(QTextStream::UnicodeUTF8);
        while(!readsettings.atEnd())
        {
            bool ok;
            buffer=readsettings.readLine();
            if (buffer.contains("mysql="))
            {
                buffer=buffer.remove("mysql=");
                databasetype=buffer.toInt(&ok,2);
            }
            if (buffer.contains("databasetype="))
            {
                buffer=buffer.remove("databasetype=");
                databasetype=buffer.toInt(&ok,10);
            }
            if (buffer.contains("verbose="))
            {
                buffer=buffer.remove("verbose=");
                verbose=buffer.toInt(&ok,2);
            }
            if (buffer.contains("savepicture="))
            {
                buffer=buffer.remove("savepicture=");
                savepicture=buffer.toInt(&ok,2);
            }
            if (buffer.contains("picturesize="))
            {
                buffer=buffer.remove("picturesize=");
                picturesize=buffer.toInt(&ok,10);
            }
            if (buffer.contains("pictureformat="))
            {
                pictureformat=(buffer.remove("pictureformat="));
            }
            if (buffer.contains("picturename="))
            {
                picturename=(buffer.remove("picturename="));
            }
            if (buffer.contains("autocompletion="))
            {
                buffer=buffer.remove("autocompletion=");
                autocomplete=buffer.toInt(&ok,2);
            }
            if (buffer.contains("recursive="))
            {
                // We have an old settingsfile, so we import it, and write new one
                import=TRUE;
            }
            if (buffer.contains("delete="))
            {
                buffer=buffer.remove("delete=");
                remove
                    =buffer.toInt(&ok,2);
            }
            if (buffer.contains("overwrite="))
            {
                buffer=buffer.remove("overwrite=");
                overwrite=buffer.toInt(&ok,2);
            }
            if (buffer.contains("better="))
            {
                buffer=buffer.remove("better=");
                better=buffer.toInt(&ok,2);
            }
            if (buffer.contains("filter="))
                filter=(buffer.remove("filter="));
            if (buffer.contains("reading_dir="))
                reading_dir=(buffer.remove("reading_dir="));
            if (buffer.contains("destination_dir="))
                destination_dir=(buffer.remove("destination_dir="));
            if (buffer.contains("reject_dir="))
                reject_dir=(buffer.remove("reject_dir="));
            if (buffer.contains("mp3_dir="))
                mp3_dir=(buffer.remove("mp3_dir="));
            if(buffer.contains("lamebitrate="))
            {
                buffer=buffer.remove("lamebitrate=");
                lamebitrate=buffer.toInt();
            }
            if(buffer.contains("gogobitrate="))
            {
                buffer=buffer.remove("gogobitrate=");
                gogobitrate=buffer.toInt();
            }
            if(buffer.contains("bladeencbitrate="))
            {
                buffer=buffer.remove("bladeencbitrate=");
                bladeencbitrate=buffer.toInt();
            }
            if(buffer.contains("oggencbitrate="))
            {
                buffer=buffer.remove("oggencbitrate=");
                oggencbitrate=buffer.toInt();
            }
            if(buffer.contains("oggencvbr="))
            {
                buffer=buffer.remove("oggencvbr=");
                oggencvbr=buffer.toInt(&ok,2);
            }
            if (buffer.contains("bitrate="))
            {
                buffer=buffer.remove("bitrate=");
                //set all encodingbitrates to that value on first run
                lamebitrate=buffer.toInt();
                gogobitrate=lamebitrate;
                if (lamebitrate)
                {
                    oggencbitrate=lamebitrate;
                    bladeencbitrate=lamebitrate;
                }
                else
                {
                    bladeencbitrate=128;
                    oggencbitrate=128;
                }
            }
            if (buffer.contains("lameexe="))
                lameexe=buffer.remove("lameexe=");
            if (buffer.contains("lameoptions="))
                lameoptions=buffer.remove("lameoptions=");
            if (buffer.contains("gogoexe="))
                gogoexe=buffer.remove("gogoexe=");
            if (buffer.contains("gogooptions="))
                gogooptions=buffer.remove("gogooptions=");
            if (buffer.contains("bladeencexe="))
                bladeencexe=buffer.remove("bladeencexe=");
            if (buffer.contains("bladeencoptions="))
                bladeencoptions=buffer.remove("bladeencoptions=");
            if (buffer.contains("oggencexe="))
                oggencexe=buffer.remove("oggencexe=");
            if (buffer.contains("oggencoptions="))
                oggencoptions=buffer.remove("oggencoptions=");
            if(buffer.contains("encodingengine="))
            {
                buffer=buffer.remove("encodingengine=");
                encodingengine=buffer.toInt();
            }
            if (buffer.contains("freedbserver="))
                freedbservername=buffer.remove("freedbserver=");
            if (buffer.contains("freedblogin="))
                freedbloginname=(buffer.remove("freedblogin="));
            if (buffer.contains("tagversion="))
            {
                buffer=buffer.remove("tagversion=");
                tagversion=buffer.toInt();
            }
            if (buffer.contains("freedbsupport="))
            {
                buffer=buffer.remove("freedbsupport=");
                freedbsupport=buffer.toInt(&ok,2);
            }
            if (buffer.contains("musicbrainzsupport="))
            {
                buffer=buffer.remove("musicbrainzsupport=");
                musicbrainzsupport=buffer.toInt(&ok,2);
            }
            if (buffer.contains("playertype="))
            {
                buffer=buffer.remove("playertype=");
                playertype=buffer.toInt(&ok,10);
            }
            if (buffer.contains("mplayerexe="))
            {
                mplayerexe=buffer.remove("mplayerexe=");
        cerr<<"mplayer :"<<mplayerexe;
        }
        }
        if (import)
        {
            //set readingdir, if we didn't set it till now
            if (reading_dir.isEmpty())
                reading_dir=QString(QDir::homeDirPath()+"/");
            //set mp3dir, if we didn't set it till now
            if (mp3_dir.isEmpty())
                mp3_dir=QString(QDir::homeDirPath()+"/");
            //set freedbstuff if it isn already set up
            if (freedbservername.isEmpty())
            {
                freedbservername="freedb.freedb.org";
                freedbloginname="anonymous";
            }
        }
        //Set tagversion for firsttimeusers of 0.3
        if (!tagversion)
            tagversion=3;//ID3v2.3 and ID3v1 with taglib
    }
    else
    {
        reading_dir=QString(QDir::homeDirPath()+"/");
        destination_dir=QString(QDir::homeDirPath()+"/");
        reject_dir=QString(QDir::homeDirPath()+"/");
        mp3_dir=QString(QDir::homeDirPath()+"/");
        filter="#GENRE#/#BAND#/#ALBUM#/#TRACK#-#SONG#";
        autocomplete=TRUE;
        remove
            =FALSE;
        overwrite=FALSE;
        better=FALSE;
        databasetype=0;//Database off
        tagversion=3;//ID3v2.3 and ID3v1 with taglib
        freedbservername="freddb.freedb.org";
        freedbloginname="anonymous";
        save();
    }
    delete settingsfile;
}

void rcdatei::save()
{
    QFile *settingsfile=new QFile(QString("%1/.k-yamo.rc").arg(QDir::homeDirPath()));
    //Falls Settingsdatei existiert, Werte ausreadsettings und in Variablen schieben
    if(settingsfile->open(IO_WriteOnly))
    {
        QTextStream writesettings(settingsfile);
        writesettings.setEncoding(QTextStream::UnicodeUTF8);
        writesettings<<"reading_dir="<<reading_dir<<"\n";
        writesettings<<"destination_dir="<<destination_dir<<"\n";
        writesettings<<"reject_dir="<<reject_dir<<"\n";
        writesettings<<"mp3_dir="<<mp3_dir<<"\n";
        writesettings<<"filter="<<filter<<"\n";
        writesettings<<"autocompletion="<<QString::number(autocomplete)<<"\n";
        writesettings<<"delete="<<QString::number(remove
                                                 )<<"\n";
        writesettings<<"overwrite="<<QString::number(overwrite)<<"\n";
        writesettings<<"better="<<QString::number(better)<<"\n";
        writesettings<<"databasetype="<<QString::number(databasetype)<<"\n";
        writesettings<<"lamebitrate="<<QString::number(lamebitrate)<<"\n";
        writesettings<<"gogobitrate="<<QString::number(gogobitrate)<<"\n";
        writesettings<<"bladeencbitrate="<<QString::number(bladeencbitrate)<<"\n";
        writesettings<<"oggencbitrate="<<QString::number(oggencbitrate)<<"\n";
        writesettings<<"oggencvbr="<<QString::number(oggencvbr)<<"\n";
        writesettings<<"encodingengine="<<QString::number(encodingengine)<<"\n";
        writesettings<<"lameexe="<<lameexe<<"\n";
        writesettings<<"lameoptions="<<lameoptions<<"\n";
        writesettings<<"gogoexe="<<gogoexe<<"\n";
        writesettings<<"gogooptions="<<gogooptions<<"\n";
        writesettings<<"bladeencexe="<<bladeencexe<<"\n";
        writesettings<<"bladeencoptions="<<bladeencoptions<<"\n";
        writesettings<<"oggencexe="<<oggencexe<<"\n";
        writesettings<<"oggencoptions="<<oggencoptions<<"\n";
        writesettings<<"freedbserver="<<freedbservername<<"\n";
        writesettings<<"freedblogin="<<freedbloginname<<"\n";
        writesettings<<"freedbsupport="<<QString::number(freedbsupport)<<"\n";
        writesettings<<"musicbrainzsupport="<<QString::number(musicbrainzsupport)<<"\n";
        writesettings<<"tagversion="<<QString::number(tagversion)<<"\n";
        writesettings<<"savepicture="<<QString::number(savepicture)<<"\n";
        writesettings<<"picturesize="<<QString::number(picturesize)<<"\n";
        writesettings<<"picturename="<<picturename<<"\n";
        writesettings<<"pictureformat="<<pictureformat<<"\n";
        writesettings<<"playertype="<<QString::number(playertype)<<"\n";
        writesettings<<"mplayerexe="<<mplayerexe<<"\n";
        writesettings<<"verbose="<<QString::number(verbose)<<"\n";
        settingsfile->close();
    }
    delete settingsfile;
}
