/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


using namespace std;

#ifndef _TAGDIALOG_H_
#define _TAGDIALOG_H_

#include <iostream>

#include <qfiledialog.h>
#include <qdir.h>
#include <qmessagebox.h>
#include <qgroupbox.h>
#include <qvbox.h>
#include <qsplitter.h>
#include <qsize.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qstatusbar.h>
#include <qptrlist.h>
#include <qstring.h>
#include <qtooltip.h>
#include <klocale.h>
#include <kiconloader.h>
#include <qpopupmenu.h>

#include "verzeichnis.h"
#include "databasewrapper.h"
#include "rcdatei.h"
#include "progress.h"
#include "coverfinder2.h"
#include "cleanup.h"
#include "fileselector.h"
#include "tagguesser.h"
#include "tagenginewrapper.h"
#include "playerinterface.h"

class flexiblecontext;

class tagdialog : public QWidget
{
    Q_OBJECT
    friend class tableiste;
    friend class flexiblecontext;
private:
    QWidget *motherwidget;
    KIconLoader *loader;
    QStatusBar *infozeile;
    QBoxLayout *mainlayout;
    QBoxLayout *tagdialoglayout;
    QSplitter *splitteraufteilung;
    QGroupBox *hauptbox;
    QGroupBox *gruppegroupbox;
    QGroupBox *albumgroupbox;
    QGroupBox *titelgroupbox;
    QGroupBox *genregroupbox;
    QGroupBox *jahrgroupbox;
    QGroupBox *covergroupbox;
    QVBox *covercontrols;
    QPushButton *loadcoverbutton;
    QPushButton *removecoverbutton;
    QLabel *artistlabel;
    QLabel *albumlabel;
    QLabel *tracklabel;
    QLabel *genrelabel;
    QLabel *yearlabel;
    QComboBox *artistbox;
    QComboBox *albumbox;
    QComboBox *trackbox;
    QComboBox *genrebox;
    fileselector *auswahlbaum;
    QString aktuelledatei;
    QSpinBox *tracknumberbox;
    QSpinBox *yearbox;
    QPushButton *speichernknopf;
    QPushButton *cleanupbutton;
    QPushButton *guessbutton;
    QPushButton *findcoverbutton;
    QLabel *coverlabel;
    QPixmap frontcover;
    QString coverfile;
    bool singleselect;
    bool bandabbruch;
    bool albumabbruch;
    bool titelabbruch;
    bool genreabbruch;
    bool jahrabbruch;
    bool nummerabbruch;
    long itemcounter;
    bool rescan;
    bool nopicture;
    QPtrList<QListViewItem> auswahlliste;
    flexiblecontext *taggercontext;
    coverfinder2 *coverdialog;
    void getselectionlist();
public:
    tagdialog(QWidget *);
    ~tagdialog();
    bool tagschanged;
public slots:
    void listboxholen();
    void setvervollstaendigen(bool);
    void boxenholen();
    void databasechangeslot();
    void imageDropped(QImage);
private slots:
    void eingabensperren();
    void eingabenfreigebensingle();
    void eingabenfreigebenmulti();
    void artistChanged();
    void albumChanged();
    void trackChanged();
    void genreChanged();
    void tracknumberChanged(int);
    void yearChanged();
    void tagupdate(QListViewItem *);
    void multitagupdate();
    void rekursivtag(QListViewItem *);
    void tagschreiben();
    void changeselectedtags();
    void cleanupslot();
    void guessslot();
    void bildladen();
    void removecoverslot();
    void savemodified();
    void showcontext(QListViewItem *,const QPoint &);
    void dirchange(QListViewItem *);
    void checkmousebutton(int,QListViewItem *);
    void findcoverslot();
    void coverupdate(QImage);
    void coverabort();
    void appendsongslot();
    void startnewsongslot();
    void renamefileslot();
    void deleteslot();
};

//A flexible class, for showing usefull contextmenus for the listviewitems
class flexiblecontext : public QPopupMenu
{
    Q_OBJECT
public:
    flexiblecontext(tagdialog *,const QString);
    ~flexiblecontext();
    tagdialog *parent;
    QListViewItem *currentobject;
    void filemenu(QListViewItem *);
    void dirmenu(QListViewItem *);
    void nonselectedmenu();
public slots:
    void setdir();
    void dirup();
    void renamedir();
signals:
    void readnewdir();
    void guesssignal();
};

#endif // _TAGDIALOG_H_
