(*
 * lablgtksourceview, OCaml binding for the GtkSourceView text widget
 *
 * Copyright (C) 2005  Stefano Zacchiroli <zack@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *)

open Gtk

(** {2 GtkSourceLanguage} *)

class source_language_signals:
  ([> Gtk_sourceview.source_language ] as 'b) obj ->
  object ('a)
    inherit ['b] GObj.gobject_signals
    method tag_style_changed: callback:(string -> unit) -> GtkSignal.id
  end

class source_language:
  Gtk_sourceview.source_language obj ->
  object
    method as_source_language: Gtk_sourceview.source_language obj
    method connect: source_language_signals
    method get_escape_char: Glib.unichar
    method get_name: string
    method get_section: string
    method misc: GObj.gobject_ops
  end

(** {2 GtkSourceLanguagesManager} *)

class source_languages_manager:
  Gtk_sourceview.source_languages_manager obj ->
  object
    method get_oid: int
    method as_source_languages_manager:
      Gtk_sourceview.source_languages_manager obj
    method get_language_from_mime_type: string -> source_language option
    method lang_files_dirs: string list
  end

val source_languages_manager:
(*   ?lang_files_dirs:string list -> *)
  unit ->
    source_languages_manager

val source_language_from_file:
  ?languages_manager:source_languages_manager -> string ->
    source_language option

(** {2 GtkSourceBuffer} *)

class source_buffer_signals:
  ([> Gtk_sourceview.source_buffer ] as 'b) obj ->
  object ('a)
    inherit GText.buffer_signals
    method can_redo: callback:(bool -> unit) -> GtkSignal.id
    method can_undo: callback:(bool -> unit) -> GtkSignal.id
    method highlight_updated:
      callback:(Gtk.text_iter -> Gtk.text_iter -> unit) -> GtkSignal.id
    method marker_updated: callback:(Gtk.text_iter -> unit) -> GtkSignal.id
  end

class source_buffer:
  Gtk_sourceview.source_buffer obj ->
  object
    inherit GText.buffer_skel
    method connect: source_buffer_signals
    method misc: GObj.gobject_ops
    method check_brackets: bool
    method set_check_brackets: bool -> unit
(*     method set_bracket_match_style: tag_style -> unit *)
    method highlight: bool
    method set_highlight: bool -> unit
    method max_undo_levels: int
    method set_max_undo_levels: int -> unit
    method language: source_language option
    method set_language: source_language -> unit
    method escape_char: Glib.unichar
    method set_escape_char: Glib.unichar -> unit
    method can_undo: bool
    method can_redo: bool
    method undo: unit -> unit
    method redo: unit -> unit
    method begin_not_undoable_action: unit -> unit
    method end_not_undoable_action: unit -> unit
(*     method create_marker: name:char -> typ:char -> source_marker *)
(*     method move_marker: source_marker -> Gtext.text_iter -> unit *)
(*     method delete_marker: source_marker -> unit *)
(*     method get_marker: name:char -> source_marker *)
(*     method get_markers_in_region:
      start:text_iter -> stop:text_iter -> source_marker list *)
(*     method get_first_marker: unit -> source_marker *)
(*     method get_last_marker: unit -> source_marker *)
(*     method get_iter_at_marker: ... *)
(*     method get_next_marker: unit -> source_marker *)
(*     method get_prev_marker: unit -> source_marker *)
  end

val source_buffer:
  ?language:source_language ->
(*   ?tag_table:source_tag_table -> *)
  ?text:string ->
  ?check_brackets:bool ->
  ?escape_char:int ->
  ?highlight:bool ->
  ?max_undo_levels:int ->
  unit ->
    source_buffer

(** {2 GtkSourceView} *)

class source_view_signals:
  ([> Gtk_sourceview.source_view ] as 'b) obj ->
  object ('a)
    inherit GText.view_signals
    method redo: callback:(unit -> unit) -> GtkSignal.id
    method undo: callback:(unit -> unit) -> GtkSignal.id
  end

class source_view:
  Gtk_sourceview.source_view obj ->
  object
    inherit GText.view_skel
    val obj: Gtk_sourceview.source_view obj
    method connect: source_view_signals
    method source_buffer: source_buffer
    method set_show_line_numbers: bool -> unit
    method show_line_numbers: bool
    method set_show_line_markers: bool -> unit
    method show_line_markers: bool
    method set_tabs_width: int -> unit
    method tabs_width: int
    method set_auto_indent: bool -> unit
    method auto_indent: bool
    method set_insert_spaces_instead_of_tabs: bool -> unit
    method insert_spaces_instead_of_tabs: bool
    method set_show_margin: bool -> unit
    method show_margin: bool
    method set_margin: int -> unit
    method margin: int
(*     method set_marker_pixbuf: GdkPixbuf.pixbuf -> unit *)
(*     method marker_pixbuf: GdkPixbuf.pixbuf *)
    method set_smart_home_end: bool -> unit
    method smart_home_end: bool
  end

val source_view:
  ?source_buffer:source_buffer ->
  ?auto_indent:bool ->
  ?insert_spaces_instead_of_tabs:bool ->
  ?margin:int ->
  ?show_line_markers:bool ->
  ?show_line_numbers:bool ->
  ?show_margin:bool ->
  ?smart_home_end:bool ->
  ?tabs_width:int ->
  ?editable:bool ->
  ?cursor_visible:bool ->
  ?justification:GtkEnums.justification ->
  ?wrap_mode:GtkEnums.wrap_mode ->
  ?border_width:int ->
  ?width:int ->
  ?height:int ->
  ?packing:(GObj.widget -> unit) ->
  ?show:bool ->
  unit ->
    source_view

(** {2 Misc} *)

val find_matching_bracket: GText.iter -> GText.iter option

