/*
 * lablgtksourceview, OCaml binding for the GtkSourceView text widget
 *
 * Copyright (C) 2005  Stefano Zacchiroli <zack@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <assert.h>

#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourcelanguagesmanager.h>

#include <caml/mlvalues.h>
#include <caml/alloc.h>
#include <caml/memory.h>
#include <caml/callback.h>
#include <caml/fail.h>
#include <caml/custom.h>
#include <caml/callback.h>

#include <wrappers.h>
#include <ml_glib.h>
#include <ml_gdk.h>
#include <ml_gtk.h>
#include <ml_gobject.h>
#include <ml_gdkpixbuf.h>
#include <ml_pango.h>
#include <gtk_tags.h>
#include <gdk_tags.h>

CAMLprim value ml_gtk_source_language_init(value unit)
{	/* Since these are declared const, must force gcc to call them! */
    GType t = gtk_source_language_get_type();
    return Val_GType(t);
}

CAMLprim value ml_gtk_source_languages_manager_init(value unit)
{	/* Since these are declared const, must force gcc to call them! */
    GType t = gtk_source_languages_manager_get_type();
    return Val_GType(t);
}

CAMLprim value ml_gtk_source_buffer_init(value unit)
{	/* Since these are declared const, must force gcc to call them! */
    GType t = gtk_source_buffer_get_type();
    return Val_GType(t);
}

CAMLprim value ml_gtk_source_view_init(value unit)
{	/* Since these are declared const, must force gcc to call them! */
    GType t = gtk_source_view_get_type();
    return Val_GType(t);
}

static gpointer string_val(value v)
{
	return String_val(v);
}

GSList *ml_gslist_of_string_list(value list)
{
	GSList_val(list, string_val);
}

/* CAMLprim value
ml_gtk_source_languages_manager_set_lang_files_dirs(GObject *obj, value list)
{
	GSList *gslist = ml_gslist_of_string_list(list);
	g_object_set_property(obj, "lang-files-dirs", gslist);
	return Val_unit;
} */

#define GtkSourceLanguage_val(val) check_cast(GTK_SOURCE_LANGUAGE,val)
#define GtkSourceLanguagesManager_val(val)\
	check_cast(GTK_SOURCE_LANGUAGES_MANAGER,val)
#define GtkSourceTagTable_val(val) check_cast(GTK_SOURCE_TAG_TABLE,val)
#define GtkSourceBuffer_val(val) check_cast(GTK_SOURCE_BUFFER,val)
#define GtkSourceView_val(val) check_cast(GTK_SOURCE_VIEW,val)
#define GtkTextIter_val(val) ((GtkTextIter*)MLPointer_val(val))
#define Val_option_GtkAny(v) Val_option(v,Val_GtkAny)
#define string_list_of_GSList(l) Val_GSList(l, (value_in) Val_string)
/* #define GSList_of_string_list(l) GSList_val(l, String_val) */
/* #define GSList_of_string_list(l) GSList_val(l, ml_string_val) */

ML_2 (_gtk_source_language_new_from_file, String_val,
		GtkSourceLanguagesManager_val, Val_option_GtkAny)
ML_1 (gtk_source_language_get_name, GtkSourceLanguage_val, Val_string)
ML_1 (gtk_source_language_get_section, GtkSourceLanguage_val, Val_string)
ML_1 (gtk_source_language_get_escape_char, GtkSourceLanguage_val, Val_int)

ML_0 (gtk_source_languages_manager_new, Val_GtkAny_sink)
ML_2 (gtk_source_languages_manager_get_language_from_mime_type,
		GtkSourceLanguagesManager_val, String_val,
		Val_option_GtkAny)
ML_1 (gtk_source_languages_manager_get_lang_files_dirs,
		GtkSourceLanguagesManager_val, string_list_of_GSList)

/* ML_0 (gtk_source_buffer_new, GtkSourceTagTable_val, Val_GtkAny_sink) */
/* ML_1 (gtk_source_buffer_new_with_language, GtkSourceLanguage_val,
		Val_GtkAny_sink) */
ML_1 (gtk_source_buffer_can_undo, GtkSourceBuffer_val, Val_bool)
ML_1 (gtk_source_buffer_can_redo, GtkSourceBuffer_val, Val_bool)
ML_1 (gtk_source_buffer_undo, GtkSourceBuffer_val, Unit)
ML_1 (gtk_source_buffer_redo, GtkSourceBuffer_val, Unit)
ML_1 (gtk_source_buffer_begin_not_undoable_action, GtkSourceBuffer_val, Unit)
ML_1 (gtk_source_buffer_end_not_undoable_action, GtkSourceBuffer_val, Unit)

ML_0 (gtk_source_view_new, Val_GtkWidget_sink)
ML_1 (gtk_source_view_new_with_buffer, GtkSourceBuffer_val, Val_GtkWidget_sink)

ML_1 (gtk_source_iter_find_matching_bracket, GtkTextIter_val, Val_bool)

