#!/bin/bash
# build LabPlot .rpm package on Fedora Core 3 x86_64
# Stefan Gerlach, 10.01.05

LVERSION=1.5.0
SPEC=LabPlot.FC-3.x86_64.spec

export CFLAGS="-O2"
export CXXFLAGS="-O2"
ARCH=i386
################################
DIR=LabPlot-"$LVERSION"
SRC=LabPlot-"$LVERSION".tar.gz

if [ ! -f "$SRC" ] ; then
	echo "$SRC not found!"
	exit
fi

if [ ! -f "$SPEC" ] ; then
	echo "$SPEC not found!"
	exit
fi

echo "%_topdir /tmp/build" > ~/.rpmmacros

mkdir -p /tmp/build/{SOURCES,SPECS,RPMS,SRPMS,BUILD} 

cp $SRC /tmp/build/SOURCES
cp $SPEC /tmp/build/SPECS

cd /tmp/build/SPECS/

rpmbuild -ba --buildroot /tmp/LabPlot $SPEC

