//LabPlot : CorrelationListDialog.cc

#include <kdebug.h>
#include "CorrelationListDialog.h"

#if HAVE_GSL
#include <gsl/gsl_errno.h>
#include <gsl/gsl_fft_real.h>
#include <gsl/gsl_fft_halfcomplex.h>
#endif
	
CorrelationListDialog::CorrelationListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	kdDebug()<<"CorrelationListDialog()"<<endl;
	setCaption(i18n("Correlation Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE) {
		styletab = surfaceStyle(tw,true);
	}
	else {
		styletab = simpleStyle(tw, style, symbol);
	}

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

int CorrelationListDialog::apply_clicked() {
	kdDebug()<<"CorrelationListDialog::apply_clicked()"<<endl;
	Graph2D *g=0;
	if(s)
		g = s->getGraph2D();
	else if(p) {
		GraphList *gl = p->getPlot(p->API())->getGraphList();
		int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
		GRAPHType st = gl->getStruct(item);

		if (st == GRAPH2D)
			g = gl->getGraph2D(item);
	}
	if(g != 0) {
		int n=g->Number();
		Point *data = g->Data();
		LRange xrange = g->Range(0);
		QString label = g->Label();

#if HAVE_GSL
		// TODO
#endif
	}

	if(p) updateList();

	return 0;
}
