//LabPlot : DifferencesListDialog.cc

#include "DifferencesListDialog.h"

#ifdef HAVE_GSL
// TODO : diff using gsl
#endif

using namespace std;

DifferencesListDialog::DifferencesListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	setCaption(i18n("Differences Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

int DifferencesListDialog::apply_clicked() {
	kdDebug()<<" DifferencesListDialog::apply_clicked()"<<endl;

	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		// add column if needed
		bool empty=true;
		for(int i=0;i<table->numRows();i++) {
			if(table->text(i,table->numCols()-1).length()>0) {
				empty =false;
			}
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = 0;i<table->numRows()-1;i++) {
			// insert into last column
			table->setText(i,newcol,QString::number(table->text(i+1,col).toDouble()-table->text(i,col).toDouble()));
		}
		return 0;
	}
	
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType st = gl->getStruct(item);
	
	Style *style=0;
	Symbol *symbol=0;
	if(st != GRAPHM) {
		style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->Data();

		for (int i = 0;i<nx-1;i++) {
			double x=(a[i].X()+a[i+1].X())/2;
			double y=(a[i+1].Y()-a[i].Y())/(a[i+1].X()-a[i].X());

			ptr[i].setPoint(x,y);
		}

		mw->calculateRanges2D(ptr,nx-1,&xmin,&xmax,&ymin,&ymax);

		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("differences of")+QString(" ")+g->Label());

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,nx-1);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		int nx = g->Number();
		Point3D *ptr = new Point3D[nx];
		Point3D *a = g->Data();

		for (int i = 0;i<nx-1;i++) {
			double x=(a[i].X()+a[i+1].X())/2;
			double y=(a[i+1].Y()-a[i].Y())/(a[i+1].X()-a[i].X());
			double z=a[i].Z();

			ptr[i].setPoint(x,y,z);
		}
		
		mw->calculateRanges3D(ptr,nx-1,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax);

		LRange range[3];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);

		QString fun = QString(i18n("differences of")+QString(" ")+g->Label());

		Graph3D *ng = new Graph3D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,nx-1,1);
		ng->setNumberX((int)(g->NX()-1));
		ng->setNumberY((int)(g->NY()));
		mw->addGraph3D(ng,sheetcb->currentItem(),type);
	}
	else if (st == GRAPH4D) {
		Graph4D *g = gl->getGraph4D(item);
		int nx = g->Number();
		Point4D *ptr = new Point4D[nx];
		Point4D *a = g->Data();

		for (int i = 0;i<nx-1;i++) {
			double x=(a[i].X()+a[i+1].X())/2;
			double y=(a[i+1].Y()-a[i].Y())/(a[i+1].X()-a[i].X());
			double z=a[i].Z(), t=a[i].T();

			ptr[i].setPoint(x,y,z,t);
		}

		mw->calculateRanges4D(ptr,nx-1,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax,&tmin,&tmax);
		
		LRange range[4];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		range[3] = LRange(tmin,tmax);

		QString fun = QString(i18n("differences of")+QString(" ")+g->Label());

		Graph4D *ng = new Graph4D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,nx-1,g->GType());
		mw->addGraph4D(ng,sheetcb->currentItem());
	}

	updateList();

	return 0;
}
