//LabPlot : ExplorerDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "ExplorerDialog.h"
#include "Plot2DSimple.h"
#include "Plot2DSurface.h"
#include "Plot3D.h"
#include "PlotPie.h"
#include "PlotPolar.h"
#include "PlotTernary.h"
#include "PlotQWT3D.h"

ExplorerDialog::ExplorerDialog(MainWin *mw, const char *name)
	: Dialog(mw, name)
{
	kdDebug()<<"Explorer Dialog"<<endl;
	setCaption(i18n("Project Explorer"));

	lv = new QListView(vbox,0);
	lv->addColumn(i18n("Object"));
	lv->addColumn(i18n("Type"));
	lv->addColumn(i18n("Info"));
	lv->setRootIsDecorated( true );

	for (int i=0;i<lv->columns();i++)
		lv->setColumnAlignment(i,Qt::AlignHCenter);

	menu = new QPopupMenu( lv );
       	menu->insertItem( i18n( "Delete" ) );
	connect(lv, SIGNAL( contextMenuRequested( QListViewItem *, const QPoint& , int ) ),
		this, SLOT( rmouse( QListViewItem *, const QPoint &, int ) ) );

	initlist();

	QObject::connect(ok,SIGNAL(clicked()),SLOT(reject()));
	apply->hide();
	cancel->hide();
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(400,300);
}

void ExplorerDialog::initlist() {
	kdDebug()<<"ExplorerDialog::initlist()"<<endl;
	QWorkspace *ws = mw->getWorkspace();
	QWidgetList list = ws->windowList();

	int nrs=0,nrw=0;
	for (unsigned int i = 0; i < list.count(); ++i ) {
		kdDebug()<<" LIST : Sheet "<<i<<endl;
		QListViewItem *lvisheet = new QListViewItem(lv);
		lvisheet->setOpen(true);
		if(((Spreadsheet *) list.at(i))->getWidgetType() == WSPREADSHEET ) {
			Spreadsheet *ss =  ((Spreadsheet *) list.at(i));
			lvisheet->setText(0,ss->Title());
			lvisheet->setText(1,"Spreadsheet");
			lvisheet->setText(2,ss->Info().join(" "));
		}
		else {
			Worksheet *ws =  ((Worksheet *) list.at(i));
			lvisheet->setText(0,ws->Title());
			lvisheet->setText(1,"Worksheet");
			lvisheet->setText(2,ws->Info().join(" "));
			
			for (unsigned int j=0;j<ws->NrPlots();j++) {
				QListViewItem *lviplot = new QListViewItem(lvisheet);
				lviplot->setOpen(true);
				lviplot->setText(0,"Plot "+QString::number(j+1));
				Plot *plot = ws->getPlot(j);
	
				QString ptype;
				QStringList info;
				switch(plot->Type()) {
				case P2D: ptype=i18n("2 D"); 
						info = ((Plot2DSimple *)plot)->Info();
						break;
				case PSURFACE: ptype=i18n("SURFACE"); 
						info = ((Plot2DSurface *)plot)->Info();
						break;
				case P3D: ptype=i18n("3 D"); 
						info = ((Plot2DSurface *)plot)->Info();
						break;
				case PPIE: ptype=i18n("PIE");
						info = ((PlotPie *)plot)->Info();
						break;
				case PPOLAR: ptype=i18n("POLAR");
						info = ((PlotPolar *)plot)->Info();
						break;
				case PTERNARY: ptype=i18n("TERNARY");
						info = ((PlotTernary *)plot)->Info();
						break;
				case PQWT3D: ptype=i18n("QWT 3D");
						info = ((PlotQWT3D *)plot)->Info();
						break;
				default:break;
				}
				lviplot->setText(1,ptype);
				lviplot->setText(2,info.join(" "));
				
				// list of graphs
				kdDebug()<<"getting list of graphs for plot "<<j<<" of type "<<ptype<<endl;
				GraphList *graphlist = plot->getGraphList();
				for(unsigned int k=0;k<graphlist->Number();k++) {
					QListViewItem *lvigraph = new QListViewItem(lviplot);
					lvigraph->setOpen(true);
					lvigraph->setText(0,"Graph "+QString::number(k+1));
					Graph *graph = graphlist->getGraph(k);
					QString gtype;
					switch (graphlist->getStruct(k) ) {
					case GRAPH2D: gtype=i18n("2 D"); 
						info = ((Graph2D *) graph)->Info();
						break;
					case GRAPH3D: gtype=i18n("3 D"); 
						info = ((Graph3D *) graph)->Info();
						break;
					case GRAPHM: gtype=i18n("MATRIX"); 
						info = ((GraphM *) graph)->Info();
						break;
					case GRAPH4D: gtype=i18n("4 D"); 
						info = ((Graph4D *) graph)->Info();
						break;
					case GRAPHIMAGE: gtype=i18n("IMAGE"); 
						info = ((GraphIMAGE *) graph)->Info();
						break;
					default:
						break;
					}
					lvigraph->setText(1,gtype);
					lvigraph->setText(2,info.join(" "));
				}
			}
		}
	}
	for (int i=0;i<lv->columns();i++)
		lv->setColumnAlignment(i,Qt::AlignHCenter);
}

//! context menu
void ExplorerDialog::rmouse(QListViewItem *item, const QPoint & point, int ) {
	kdDebug()<<"ExplorerDialog::rmouse() : "<<item<<' '<<point.x()<<'/'<<point.y()<<endl;
	// TODO
	//if( item )
        //	menu->popup( point );
}
