//LabPlot : FilterMAGICK.cc

#include <klocale.h>
#include <kdebug.h>
#include <ktempfile.h>
#include "FilterMAGICK.h"

FilterMAGICK::FilterMAGICK(QString filename)
	: filename(filename)
{
#ifdef HAVE_MAGICK
	if(filename.length()>0) {
		try {
			fileok=true;
			image.read(filename.latin1());
		}
		catch (Exception &e) {
			fileok=false;
			kdDebug() << "Image read : Caught exception: "<<endl;
			kdDebug() << e.what() << endl;
		}
		try {
			kdDebug()<<" FORMAT : "<<image.format().c_str()<<endl;
			if (image.format() == "Text" ) {
				fileok=false;
			}
		}
		catch (Exception &e) {
			fileok=false;
			kdDebug() << "Image format : Caught exception: " << e.what() << endl;
		}
	}
#else
	fileok=false;
#endif
}

//! return image as QPixmap
#ifdef HAVE_MAGICK
QPixmap FilterMAGICK::Pixmap() {
	KTempFile *tmpfile = new KTempFile(QString::null,".bmp");
	tmpfile->setAutoDelete(true);
	QString tmpname = tmpfile->name();

	// save image as bmp (tmp file)
	image.magick( "BMP" );
	image.write(tmpname.latin1());
	
	// read tmp file into pixmap
	QPixmap pm(width(),height());
	pm.load(tmpname);
	
	return pm;
}
#endif
