//LabPlot : Graph.h

#ifndef GRAPH_H
#define GRAPH_H

#include <qstring.h>
#include <qstringlist.h>
#include <klocale.h>
#include "LRange.h"
#include "Style.h"
#include "Symbol.h"
#include "AnnotateValues.h"
#include "plottypes.h"
#include "source.h"

class Graph
{
public:
	Graph(QString n="", QString label="", LSource src=SFUNCTION, PType t=P2D, Style *st=0, 
			Symbol *sy=0,int nr=0, bool s=true);
	virtual ~Graph() {}
	void openGraph(QTextStream *t,int version);
	void saveGraph(QTextStream *t);
	QString Name() { return name; }
	QString Label() { return label; }
	void setLabel(QString l) { label=l; }
	LSource Source() { return source; }
	void setSource(LSource s) { source=s; }
	int ReadAs() { return readas; }
	void setReadAs(int r) { readas = r; }
	PType Type() { return type; }
	Style *getStyle() { return style; }
	void setStyle(Style *s) { style = s; }
	Symbol *getSymbol() { return symbol; }
	void setSymbol(Symbol *s) { symbol = s; }
	int Number() { return number; }
	void setNumber(int n) { number = n; }
	bool isShown() { return shown; }
	void setShown(bool b) { shown = b; }
	AnnotateValues getAnnotateValues() { return av; }
	void setAnnotateValues(AnnotateValues a) { av=a;}
	QString FitFunction() { return fitfunction; }
	void setFitFunction(QString f) { fitfunction=f; }
	
protected:
	QString name, label;	// name and label (plotted name)
	LSource source;
	int readas;		// selected read as for data
	PType type;		// plot type of a graph
	Style *style;
	Symbol *symbol;
	int number;
	bool shown;		// shown/hidden
	AnnotateValues av;
	QString fitfunction;
};

#endif // GRAPH_H
