//LabPlot : Graph2D.h

#ifndef GRAPH2D_H
#define GRAPH2D_H

#include <qstringlist.h>
#include <qtextstream.h>
#include <qprogressdialog.h>
#include <kdebug.h>
#include "Graph.h"
#include "Point.h"

class Graph2D: public Graph
{
public:
	Graph2D(QString n="", QString l="",LRange r[2]=0, LSource src=SFUNCTION, PType t=P2D, Style *st=0, 
		Symbol *sy=0, Point *p=0, int nr=0, bool b=true);
	LRange Range(int i) { return range[i]; }
	void setRange(LRange *r) { range[0]=r[0];range[1]=r[1]; }
	Point *Data() { return ptr; }
	QStringList Info();	
	void save(QTextStream *t, QProgressDialog *progress);
	void open(QTextStream *t, int version, QProgressDialog *progress);
private:
	Point *ptr;
	LRange *range;
};

#endif // GRAPH2D_H
