//LabPlot : GraphList.h

#ifndef GRAPHLIST_H
#define GRAPHLIST_H

#include <qtextstream.h>
#include "Graph2D.h"
#include "Graph3D.h"
#include "GraphM.h"
#include "Graph4D.h"
#include "GraphIMAGE.h"
#include "graphtypes.h"

#define MAX_NR 200	// maximum number of graphs of one type

class GraphList {
public:
	GraphList();
	void clear();
	int addGraph2D(Graph2D *g);
	int addGraph3D(Graph3D *g);
	int addGraphM(GraphM *g);
	int addGraph4D(Graph4D *g);
	int addGraphIMAGE(GraphIMAGE *g);
	int delGraph(unsigned int index);
	GRAPHType getStruct(int index);	
	int Index(int index);	
	Graph *getGraph(unsigned int index);
	Graph2D *getGraph2D(int index);
	Graph3D *getGraph3D(int index);
	GraphM *getGraphM(int index);
	Graph4D *getGraph4D(int index);
	GraphIMAGE *getGraphIMAGE(int index);
	unsigned int Number() { return nr2D+nr3D+nrM+nrGRASS+nr4D+nrIMAGE; }
	unsigned int isNotFull() { return 7*MAX_NR-nr2D-nr3D-nrM-nrGRASS-nr4D-nrIMAGE; }
private:
	unsigned int nr2D, nr3D, nrM, nrGRASS, nr4D, nrIMAGE;		// number of graphs
	Graph2D list2D[MAX_NR];
	Graph3D list3D[MAX_NR];
	GraphM listM[MAX_NR];
	Graph4D list4D[MAX_NR];
	GraphIMAGE listIMAGE[MAX_NR];
	int id[7*MAX_NR];	// ID s   (0,1,-1,-1,-1,-1,...,2,4,-1,-1,...,3,-1,-1,-1,...)
};

#endif //GRAPHLIST_H
