//LabPlot : ImportOPJ.cc

#include <stdio.h>
#include <math.h>

#include <qstring.h>
#include <qregexp.h>
#include <kdebug.h>
#include "ImportOPJ.h"

ImportOPJ::ImportOPJ(MainWin *mw, QString filename) 
	: mw(mw),filename(filename) 
{}

/* File Structure :
filepre +
	+ pre + head + data	col A
	+ pre + head + data	col B
*/
int ImportOPJ::import() {
	kdDebug()<<"ImportOPJ::import() : "<<filename<<endl;

	FILE *f;
	if((f=fopen(filename.latin1(),"r")) == NULL ) {
		kdDebug()<<"	COULD NOT OPEN FILE "<<filename<<endl;
		return -1;
	}

	// check version from header
	char header[17];
	header[16]=0;
	fread(&header,16,1,f);
	printf("	[header : %s]\n",header);

	short version=0;
	fseek(f,0x8,SEEK_SET);		// ??? 8 
	fread(&version,2,1,f);
	printf("	[version = %d]\n",version);	

	int FILEPRE=0x3e;		// file header
	int PRE=0x62;			// pre column 
	int HEAD=0x33;		// column header
	int NEW_COL=0x83;	// value for new column
	int NEW_SPREAD=0x51;	// value for new spreadsheet
	int COL_SIZE=0x2c;		// value of col size
	if(version==13622) {
		kdDebug()<<"FOUND PROJECT VERSION 7.0"<<endl;
		version=70;
		NEW_COL=0x73;
		NEW_SPREAD=0x11;
		HEAD=0x23;
		COL_SIZE=0x1c;
	}
	else if(version==13879) {
		kdDebug()<<"FOUND PROJECT VERSION 7.5"<<endl;
		version=75;
	}
	else {
		kdDebug()<<"FOUND UNKNOWN PROJECT VERSION"<<endl;
		return -2;
	}
	
	// find column
	fseek(f,FILEPRE + 0x05,SEEK_SET);
	int col_found;
	fread(&col_found,4,1,f);
	printf("	[column found = 0x%X (0x%X : YES) @ 0x%X]\n",col_found,NEW_COL,FILEPRE + 0x05);

	int current_col=0, spread=0, nr=0, POS=FILEPRE, DATA=0;
	double a;
	int valuesize=10;
	char name[25];
	Spreadsheet *s[255];	// spreadsheets
	int nr_cols[255];		// nr of cols per spreadsheet
	while(col_found == NEW_COL) {
		// PRE HEADER
		fseek(f,POS + 0x21,SEEK_SET);
		char new_spread;
		fread(&new_spread,1,1,f);
		printf("	[new spreadsheet = 0x%X (0x%X : YES) @ 0x%X]\n",new_spread,NEW_SPREAD,POS + 0x21);
		if(new_spread == NEW_SPREAD) {
			current_col=1;
			s[spread] = mw->newSpreadsheet();
			spread++;
			printf("	SPREADSHEET %d\n",spread);
		}
		else {
			int cols = s[spread-1]->Table()->numCols();
			current_col++;
			
			nr_cols[spread-1]=current_col;
			
			if(cols<current_col)
				s[spread-1]->Table()->setNumCols(cols+1);
		}
			
		// COLUMN HEADER
		// TODO : data isn't the same for all spreads !
		printf("	[column header @ 0x%X]\n",POS);
		fseek(f,POS + PRE,SEEK_SET);
		fread(&name,25,1,f);
		printf("		COLUMN %d (%s) @ 0x%X ",current_col, name,POS+PRE);
		QString title(name);
		s[spread-1]->setColumnTitle(current_col-1,title.replace(QRegExp(".*_"),""));
		
		// SIZE of column
		fseek(f,POS+PRE+COL_SIZE,SEEK_SET);
		fread(&nr,4,1,f);
		nr /= valuesize;
		printf("	[number of rows = %d @ 0x%X]\n",nr,POS+PRE+COL_SIZE);
		if(current_col==1)
			s[spread-1]->Table()->setNumRows(nr);

		// DATA
		fseek(f,POS+PRE+HEAD,SEEK_SET);
		for (int i=0;i<nr;i++) {
			fread(&a,valuesize,1,f);
			if(fabs(a)<1.0e-100) a=0;
			printf("%g ",a);
			s[spread-1]->Table()->setText(i,current_col-1,QString::number(a));
		}
		printf("\n");

		DATA = valuesize*nr - 1;
		fseek(f,POS + PRE + DATA + HEAD + 0x05,SEEK_SET);
		fread(&col_found,4,1,f);
		printf("	[column found = 0x%X (0x%X : YES)]\n",col_found,NEW_COL);
		
		POS += (DATA + HEAD + PRE);
	}

	POS-=1;
	printf("		[position @ 0x%X]\n",POS);
	
	// SPREADSHEET 1
	// HEADER
	fseek(f,POS + 0x12,SEEK_SET);
	fread(&name,25,1,f);
	printf("\n	SPREADSHEET 1 NAME : %s	(@ 0x%X) has %d columns\n",name,POS + 0x12,nr_cols[0]);

	fseek(f,POS + 0x55,SEEK_SET);
	fread(&name,7,1,f);
	printf("		%s [ORIGIN]	(@ 0x%X)\n",name,POS + 0x55);
	
	/* LAYER A section */
	int LAYER = POS + 0x4AB;
	
// 	// seek for "L"ayerInfoStorage to find layer section	: only 7.5 
	LAYER -= 0x99;
	char c;
	int jump=0;
	do {
		LAYER += 0x99;
		fseek(f,LAYER+0x53, SEEK_SET);
		fread(&c,1,1,f);
		jump++;
	} while(c!='L' && jump<10);		// no inf loop

	if(jump==10) {
		printf("		LAYER section not found !\nGiving up.");
		return -3;
	}

	printf("		[LAYER @ 0x%X]\n",LAYER);

	// COLUMN Types
	// TODO : 7.0 : A @ 0x680
	int ATYPE = 0xCE, COL_JUMP=0x1F2;
	for (int i=0;i<nr_cols[0];i++) {
		fseek(f,LAYER+ATYPE+i*COL_JUMP+1, SEEK_SET);
		fread(&c,1,1,f);
		if(c==0x41+i) {
			fseek(f,LAYER+ATYPE+i*COL_JUMP, SEEK_SET);
			fread(&c,1,1,f);
			QString type;
			switch(c) {
			case 3: type="X"; break;
			case 0: type="Y"; break;
			case 5: type="Z"; break;
			case 6: type="DX"; break;
			case 2: type="DY"; break;
			case 4: type="LABEL"; break;
			}
			s[0]->setColumnType(i,type);
			printf("		COLUMN %c type = %s (@ 0x%X)\n",0x41+i,type.latin1(),LAYER+ATYPE+i*COL_JUMP);
		}
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	// SPREADSHEET 2,3,...
	// TODO
	
	if(spread>=2) {
		POS=0x3474;
		if(version==70)
			POS=0x3008;
		// HEADER
			
		fseek(f,POS+0x11,SEEK_SET);
		fread(&name,25,1,f);
		printf("	SPREADSHEET 2 NAME : %s	(@ 0x%X)\n",name,POS + 0x11);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	// TODO : GRAPHS
/*	int graph = 0x2fc1;
	int pre_graph = 0x12;
	fseek(f,graph + pre_graph,SEEK_SET);
	fread(&name,25,1,f);
	printf("GRAPH : %s\n",name);

	fseek(f,graph + pre_graph + 0x43, SEEK_SET);
	fread(&name,25,1,f);
	printf("TYPE : %s\n",name);

	fseek(f,graph + pre_graph + 0x2b3, SEEK_SET);
	fread(&name,25,1,f);
	printf("Y AXIS TITLE : %s\n",name);
	fseek(f,graph + pre_graph + 0x38d, SEEK_SET);
	fread(&name,25,1,f);
	printf("X AXIS TITLE : %s\n",name);

	fseek(f,graph + pre_graph + 0xadb, SEEK_SET);
	fread(&name,25,1,f);
	printf("LEGEND : %s\n",name);
*/

	return 0;
}
