//LabPlot: Legend.cc

#include <math.h>
#include <iostream>
#include <qbrush.h>
#include <qcolor.h>
#include <kdebug.h>
#include "Legend.h"
#include "GraphList.h"

using namespace std;

Legend::Legend() {
	f = QFont(QString("Adobe Times"),8);
	e = true;
	border = true;
	x = 0.7;
	y = 0.05;
	namelength=0;
	orientation=0;
	ticlabellength=0;
}

void Legend::draw( QPainter *p, PType type, GraphList *graphlist, Point pos, Point size,int w, int h) {
	kdDebug()<<"Legend::draw()"<<endl;

	x1 = x2 = (int) ((x*size.X()+pos.X())*w);
	y1 = y2 = (int) ((y*size.Y()+pos.Y())*h);

	namelength=0;	// reset namelength for legend box

	// set point size
	int tmppointsize = f.pointSize();
	QFont tmpfont = f;
	//kdDebug()<<"Setting font size to "<<(int) (f.pointSize()*size.X())<<endl;
	tmpfont.setPointSize((int)(f.pointSize()*size.X()));
	p->setFont(tmpfont);
	QFontMetrics fm = p->fontMetrics();

	int number=0;	// number of shown graphs
	int nr_graphs = graphlist->Number();
	for (int i = 0;i < nr_graphs;i++) {
		Graph *g = graphlist->getGraph(i);
		if(g->isShown() == false)
			continue;
		
		QString name = g->Label();
		Style *style = g->getStyle();

		QPen pen( style->Color(), style->Width(),(Qt::PenStyle) style->PenStyle() );
		// EPS BUG
		p->setPen(pen);

		if (type == PSURFACE) {
			namelength  =  fm.width(name);
			if(namelength<8)	// minimum width
				namelength=8;
			p->setPen(Qt::black);
			if(orientation)
				p->drawText((int)(x1+70*size.X()),(int)(y1+size.Y()*(20*number+20)), name);
			else
				p->drawText((int)(x1+10*size.X()),(int)(y1+size.Y()*(20*number+20)), name);

			if(orientation) {
				x2 = (int) (x1+size.X()*(20+125+10));
				y2 = (int) (y1+40*size.Y()*nr_graphs+namelength+5);
			}
			else {
				y2 = (int) (y1+size.Y()*(40*nr_graphs+125+10));
//				kdDebug()<<"	NL "<<namelength<<" | TLL "<<ticlabellength<<endl;
				x2 = (int) (x1+40*size.X()+fmax(namelength-20*size.X(),ticlabellength)+5);
			}
		}
		else {
			int tmpy = (int)(y1+size.X()*(20*number+15));
			namelength < fm.width(name) ? namelength = fm.width(name) :0;

			if(style->Type() != 1)		// 1 == NoCurve
				p->drawLine((int)(x1+5*size.X()),tmpy,(int)(x1+35*size.X()),tmpy);
				
			g->getSymbol()->draw(p,(int)(x1+20*size.X()),tmpy);
			p->drawText((int)(x1+40*size.X()),tmpy+tmpfont.pointSize()/2, name);

			x2 = (int) (x1+40*size.X()+namelength+5);
			y2 = (int) (y1+size.X()*(20*(number+1)+10));
		}
		number++;

	}
	
	p->setBrush(QBrush::NoBrush);
	if (border)
		p->drawRect(x1,y1,x2-x1,y2-y1);

	// reset font point size
	//kdDebug()<<"Resetting font size to "<<tmppointsize<<endl;
	tmpfont.setPointSize(tmppointsize);
	p->setFont(tmpfont);
}

//! calculate if point x,y is inside the legend box (for mouse event)
bool Legend::inside(int X, int Y) {
	kdDebug()<<"x1/x2 y1/y2 "<<x1<<'/'<<x2<<' '<<y1<<'/'<<y2<<endl;
	kdDebug()<<"x/y "<<x<<' '<<y<<endl;
	if (X>x1 && X<x2 && Y>y1 && Y<y2)
		return true;
	else
		return false;
}

void Legend::save(QTextStream *t) {
	*t<<x<<' '<<y<<endl;
	*t<<f.family()<<endl;
	*t<<f.pointSize()<<' '<<f.weight()<<' '<<f.italic()<<endl;
	*t<<e<<' '<<border<<endl;
	*t<<orientation<<endl;
}

void Legend::open(QTextStream *t, int version) {
	kdDebug()<<"Legend::open()"<<endl;
	QString family;
	int pointsize, weight, italic, tmp;

	*t>>x>>y;

	if(version > 3) {
		t->readLine();
		family=t->readLine();
		*t>>pointsize>>weight>>italic;
	}
	else {
		*t>>family>>pointsize>>weight>>italic;
	}
	f = QFont(family,pointsize,weight,italic);
	
	if (version > 4) {
		int en, be;
		*t>>en>>be;
		e = en;
		border = be;
	}
	if(version > 20) {
		*t>>tmp;
		orientation = (bool)tmp;
	}

	kdDebug()<<"Legend : "<<x<<' '<<y<<endl;
	kdDebug()<<"         "<<family<<' '<<pointsize<<endl;
}
