//LabPlot : ListDialog.h

#ifndef LISTDIALOG_H
#define LISTDIALOG_H

// for all list dialogs
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <math.h>

#include <qtextstream.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "GraphListView.h"
#include "Dialog.h"

/*! main class for all list dialogs */
class ListDialog : public Dialog
{
	Q_OBJECT
public:
	ListDialog(MainWin *mw, const char *name);
	void updateList();
	void updateSheetList();
	// needed from Spreadsheet => public
public slots:
	void Menu(QListViewItem *, const QPoint& pos, int) { menu->popup(pos); }
	void updateRange(int axis=0);
	void toggleShown();
	void deleteGraph();
	void changeGraph();
	void dumpGraph();
	void editGraph();
	void exportGraph() { dumpGraph(); }
	void openSpreadsheet();
	void statGraph();
	void setDifferentColor();
	void setDifferentSymbol();
	void setDifferentWidth();
	void setDifferentStyle();
 	void setBlackWhite();
	void mask(int how, int n);
	void toggleMask();
	void unMask();
	void nthMask();
	void firstMask();
	void Clone();

	void selectItem(int i);					//!< select item
	int Apply() { return apply_clicked(); }
protected:
	class GraphListView *lv;
	QPopupMenu *menu;
	PType type;
	KLineEdit *ale, *ble;
protected slots:
	void ok_clicked() { if ( apply_clicked() == 0) accept(); }
	virtual int apply_clicked() = 0;
};

#endif // LISTDIALOG_H
