//LabPlot : MainWin.h

#ifndef MAINWIN_H
#define MAINWIN_H

#include <qstring.h>
#include <qfont.h>
#include <qlistbox.h>
#include <qworkspace.h>
#include <qtoolbutton.h>
#include <qsignalmapper.h>
#include <qdragobject.h>
#include <qtimer.h>
#include <kapp.h>
#include <kmainwindow.h>
#include <kparts/mainwindow.h>
#include <kaction.h>
#include <kkeydialog.h>
#include <kstatusbar.h>
#include <kstandarddirs.h>
#include <kmenubar.h>
#include "GraphList.h"
#include "Spreadsheet.h"
#include "Worksheet.h"
#include "Project.h"

#ifdef HAVE_QSA
#include <qsproject.h>
#include <qsinterpreter.h>
#ifdef HAVE_QSA_IDE
#include <qsworkbench.h>
#endif
#endif

#define PROJECT_VERSION 21

extern "C" double parse(char[]);
extern "C" int parse_errors();

class Worksheet;
class Spreadsheet;
class Plot;
class Plot2DSimple;

class MainWin
	: public KParts::MainWindow
{
	Q_OBJECT
private:
	void readConfig();
	void enableAutosave(bool as);
	void newDialog(bool d, PType type);		//!< interface to all data and function dialogs
	Plot *newPlot(PType type=P2D);			//!< interface to all new plot functions
	QWorkspace* ws;	
	QString filename;
	KParts::ReadOnlyPart* gvpart;
	QPopupMenu *spreadsheetpopup;
	QSignalMapper *sm, *smg;			// signal mapper for sheets and graphs
	KConfig *config;
	KRecentFilesAction* recent;
	KAction *configureAction, *project_action, *explorer_action;
	KAction *import_action, *importopj_action, *export_image, *export_svg, *export_pic, *export_ps, *export_eps, *export_pdf;
	KAction	*export_pstoedit, *export_ImageMagick, *print_action, *save_action, *save_as;
	KAction *graph_list, *plot_list, *clear_action, *close_action, *worksheet_action, *plot_action, *arrange, *overlay;
	KAction *deleteplot, *qwt3d_plot, *qwt3d_func, *qwt3d_data;
	KAction *evaluate, *operations, *imagepro;
	KAction *smooth, *prune, *average, *compress, *periodic, *seasonal, *hist, *peak;
	KAction *interpolation, *differences, *integration, *regression, *fft, *convolution, *wavelet, *hankel, *fit;
	KAction *axes, *title_action, *legend, *objects;
	KAction *asx, *asy, *asz, *asall, *maglens, *panzoom, *sl, *sr, *su, *sd, *sxu, *sxd, *syu, *syd, *szu, *szd;
	KAction *zoomin, *zoomout, *maskplot;
	KAction *baseline, *region, *label, *line, *rect, *ellipse, *image;
	KAction *ideAction, *scriptAction;
	KToggleAction *menubar, *toolbar, *sidetoolbar, *analysistoolbar, *drawingtoolbar, *statusbar;
	KToggleAction *printpreview, *togglespeedmode, *toggledatamode;
	bool printpreviewchecked;	// needed for print preview
	Project *project;
	QTimer *autosaveTimer;
	bool autosave;
	long autosaveinterval;
	bool modified;
	bool speedmode, datamode;
	int speedmodevalue;
	QFont defaultfont;
	int nr_w, nr_s;
#ifdef HAVE_QSA
	QSProject *qsproject;
#ifdef HAVE_QSA_IDE
	QSWorkbench *ide;
#endif
#endif
	bool is_fullscreen;
private slots:
	void closeWin();
	void setWinFocus(int i) { (ws->windowList()).at(i)->setFocus(); }
	void SpreadsheetMenu();
	
	void configure();
	void configureKeys() { KKeyDialog::configure(actionCollection(), this, true); }
	void configureToolbars();
	void saveSettings();
	void setAutosaveInterval(long interval) { autosaveinterval=interval;}

	void openIDE();
	void reportBug();
	void exampleAxesLabel() { openfile(locate("data", QString("LabPlot/axeslabel.lpl.gz"))); }
	void exampleAnalysis() { openfile(locate("data", QString("LabPlot/analysis.lpl.gz"))); }
	void exampleSurface() { openfile(locate("data", QString("LabPlot/surface.lpl.gz"))); }
	void example3d() { openfile(locate("data", QString("LabPlot/3d.lpl.gz"))); }
	void exampleRydberg() { openfile(locate("data", QString("LabPlot/rydberg.lpl.gz"))); }
	void exampleLog() { openfile(locate("data", QString("LabPlot/log.lpl.gz"))); }
	void exampleFFT() { openfile(locate("data", QString("LabPlot/fft.lpl.gz"))); }
	void exampleObjects() { openfile(locate("data", QString("LabPlot/objects.lpl.gz"))); }
	void exampleHist() { openfile(locate("data", QString("LabPlot/hist.lpl.gz"))); }
	void exampleFit() { openfile(locate("data", QString("LabPlot/fit.lpl.gz"))); }
	void exampleImage() { openfile(locate("data", QString("LabPlot/image.lpl.gz"))); }
	void examplePie() { openfile(locate("data", QString("LabPlot/pie.lpl.gz"))); }
	void exampleExponentialFit() { openfile(locate("data", QString("LabPlot/exponential_fit.lpl.gz"))); }
	void exampleMultiplot() { openfile(locate("data", QString("LabPlot/multiplot.lpl.gz"))); }
	void exampleSurface2() { openfile(locate("data", QString("LabPlot/surface2.lpl.gz"))); }
	void examplePolar() { openfile(locate("data", QString("LabPlot/polar.lpl.gz"))); }
	void exampleTernary() { openfile(locate("data", QString("LabPlot/ternary.lpl.gz"))); }
	void exampleAudio() { openfile(locate("data", QString("LabPlot/audio.lpl.gz"))); }
	void exampleQWT() { openfile(locate("data", QString("LabPlot/qwt.lpl.gz"))); }
	void exampleBar() { openfile(locate("data", QString("LabPlot/bar.lpl.gz"))); }
	void exampleLogfit() { openfile(locate("data", QString("LabPlot/logfit.lpl.gz"))); }
	void exampleMarker() { openfile(locate("data", QString("LabPlot/marker.lpl.gz"))); }
	void exampleSurfaceStyle() { openfile(locate("data", QString("LabPlot/surfacestyle.lpl.gz"))); }
	void exampleTeXLabel() { openfile(locate("data", QString("LabPlot/texlabel.lpl.gz"))); }
public slots:
	void open(QString fn=0);							//!< open the LabPlot project file fn (*.lpl)
	void New();									//!< open new project 
	void save(QString fn=0);							//!< save LabPlot project to file fn
	void saveAs(QString fn=0);						//!< save LabPlot project to file fn
	void projectInfo();								// TODO : project info dialog
	void projectExplorer();							// TODO : project explorer
	void importData(QString fn,int filter=0);	//!< import data from file fn with filter filter into active(or new) spreadsheet
	void importDialog();							//!< open dialog for importing data into spreadsheet
	void importOPJ(QString fn=0);					//!< importing opj project
	void exportPlot(QString fn=0, QString f=0);			//!< export plot to file fn in image format f
	void exportPS(QString fn=0);					//!< export plot to file fn in PS format
	void exportEPS(QString fn=0);					//!< export plot to file fn in EPS format
	void exportPDF(QString fn=0);					//!< export plot to file fn in PDF format
	void exportSVG(QString fn=0);					//!< export plot to file fn in SVG format
	void exportPIC(QString fn=0);						//!< export plot to file fn in PIC format
	void exportPstoEdit(QString fn=i18n("out.pdf"),int f=4, int s=5, double sc=1.0, double r=0.0);
												//!< export to file fn with format f and papersize s 
												//!< using scale sc and rotation r via pstoedit
	void exportPstoEditDialog();						//!< open dialog for exporting via pstoedit
	void exportImageMagick(QString fn=i18n("out.8bim"), int f=0, int sx=800, int sy=600, double r=0.0);
												//!< export to file fn with format f and size sx,sy with rotation
												//!< using ImageMagick 
	void exportImageMagickDialog();					//!< open dialog for exporting via ImageMagick
	void print();									// TODO : print dialog
	void printPreview();								//!< open/close printpreview
	void graphDialog();								//!< open graphlist dialog
	void plotDialog();								//!< open plotlist dialog

	void clear();									//!< clear the active worksheet
	void deletePlot();								//!< delete active plot
	void loadScript(QString fn=0);						//!< load script from file fn
	void Environment();								//!< show information about environment
	void aboutKDE();								//!< about KDE
	void exit() {modified=false; close(); }				//!< close without saving
	void toggleFullScreen();							//!< toggle full screen
	void toggleMenuBar();							//!< toggle menu bar
	void toggleToolBar();							//!< toggle tool bar
	void toggleSideToolBar();						//!< toggle side tool bar
	void toggleAnalysisToolBar();						//!< toggle analysis tool bar
	void toggleDrawingToolBar();						//!< toggle drawing tool bar
	void toggleStatusBar();							//!< toggle status bar
	bool speedMode() { return speedmode; }					//!< return if speed mode is selected
	void setSpeedMode(bool s) { speedmode = s; }				//!< set speed mode
	void toggleSpeedMode();							//!< toggle speed mode
	int speedModeValue() { return speedmodevalue; }				//!< return speed mode value
	void setSpeedModeValue(int s) { speedmodevalue=s; }			//!< set speed mode value
	bool dataMode() { return datamode; }					//!< return if data mode is selected
	void setDataMode(bool d) { datamode = d; }				//!< set data mode
	QFont defaultFont() { return defaultfont; }
	void setDefaultFont(QFont f) { defaultfont=f; }
	
	void newPlot(int type) { newPlot((PType) type); }	//!< interface to all new plot functions
	Plot2DSimple* new2DPlot() { return (Plot2DSimple *) newPlot(P2D); }
	void newSurfacePlot() { newPlot(PSURFACE); }
	void new3DPlot() { newPlot(P3D); }
	void newPiePlot() { newPlot(PPIE); }
	void newPolarPlot() { newPlot(PPOLAR); }
	void newTernaryPlot() { newPlot(PTERNARY); }
	void newQWT3DPlot() { newPlot(PQWT3D); }

	void new2DData() { newDialog(0,P2D); }			//!< open new 2d data dialog
	void newSData() { newDialog(0,PSURFACE); }		//!< open new surface data dialog
	void new3DData() { newDialog(0,P3D); }			//!< open new 3d data dialog
	void newPieData() { newDialog(0,PPIE); }			//!< open new pie data dialog
	void newPolarData() { newDialog(0,PPOLAR); }		//!< open new polar data dialog
	void newTernaryData() { newDialog(0,PTERNARY); }	//!< open new ternary data dialog
	void newQWT3DData() { newDialog(0,PQWT3D); }		//!< open new QWT 3D data dialog
	void new2DFunction() { newDialog(1,P2D);  }		//!< open new 2d function dialog
	void new3DFunction() {newDialog(1,P3D); }			//!< open new 3d function dialog
	void newQWT3DFunction() {newDialog(1,PQWT3D); }		//!< open new 3d qwt function dialog
	void newSFunction() { newDialog(1,PSURFACE); }	//!< open new surface function dialog
	void newPolarFunction() {newDialog(1,PPOLAR); }	//!< open new polar function dialog

	Style* newStyle() { return new Style(); }		//!< create new Style	: Wrapper for QSA
	Symbol* newSymbol() { return new Symbol(); }		//!< create new Symbol	: Wrapper for QSA
	void lDebug(QString s) { kdDebug()<<s<<endl; }		//!< wrapper for debug messages
	
	void evaluateDialog();							// TODO 
	void operationsDialog();
	void smoothDialog();
	void averageDialog();
	void compressDialog();
	void pruneDialog();
	void periodicDialog();
	void seasonalDialog();
	void histDialog();
	void peakDialog();
	void interpolationDialog();
	void differencesDialog();
	void integrationDialog();
	void regressionDialog();
	void fftDialog();
	void convolutionDialog();
	void waveletDialog();
	void hankelDialog();
	void fitDialog();
	void imageDialog();

	void arrangeDialog();							// TODO
	void overlayDialog();
	void worksheetDialog();
	void plotSettingsDialog();
	void axesDialog();
	void titleDialog();							// TODO
	void legendDialog();
	void objectDialog();

	void autoScaleX();					//!< auto scale x axis in current plot
	void autoScaleY();					//!< auto scale y axis in current plot
	void autoScaleZ();					//!< auto scale z axis in current plot
	void autoScaleAll();					//!< auto scale all axes in current plot
	void shiftLeft();					//!< shift current plot to the left
	void shiftRight();					//!< shift current plot to the right
	void shiftUp();						//!< shift current plot up
	void shiftDown();					//!< shift current plot down
	void scaleXUp();					//!< scale x axis of current plot up
	void scaleXDown();					//!< scale x axis of current plot down
	void scaleYUp();					//!< scale y axis of current plot up
	void scaleYDown();					//!< scale y axis of current plot down
	void scaleZUp();					//!< scale z axis of current plot up
	void scaleZDown();					//!< scale z axis of current plot down
	void zoomIn();
	void zoomOut();
	void toggleDataMode();

// no script functions
	void open(const KURL& url);

	void magLens();
	void panZoom();
	void maskPlot();

	void defineRegion();
	void defineBaseline();
	void defineLine();
	void defineLabel();
	void defineRect();
	void defineEllipse();
	void defineImage();
	
	void setActiveSheet(int i);	// called from signal mapper (sheet list)
	void changeGraph(int i);		// called from signal mapper (graph list)
	Spreadsheet* newSpreadsheet();
	Worksheet* newWorksheet();
	Worksheet* activeWorksheet();
	Spreadsheet* activeSpreadsheet();
	void updateGraphList();
	void updateSheetList();
public:
	MainWin(const char *name,const char *filen,bool is_part=false);
	void replot();
	void openfile(QString file);
	void message(QString msg) {statusBar()->message(msg); }
	KConfig* Config() { return config; }
	int defining_region, defining_line, defining_rect, defining_ellipse;	// value = 0-not,1-left,2-right line
	int defining_maglens,defining_panzoom, defining_mask;			// dto.
	bool defining_baseline,defining_label,defining_image;
	QString last_2dfunction, last_3dfunction, last_filename;		// function, filename of last input
	int last_readas, last_nrpointsx, last_nrpointsy;	
	double last_xmin, last_xmax, last_ymin, last_ymax;			// readas, nrpoints and range of last input
	
	Project *getProject() { return project; }
	void setProject(Project *p) { project=p; }
#ifdef HAVE_QSA
	QSProject *getQSProject() { return qsproject; }
#endif
	void readScript(QString name);
	QWorkspace *getWorkspace() { return ws; }
	void deleteActiveSheet();
	void setModified() {modified = true;}
	int NrSpreadsheets() { return nr_s; }
	int NrWorksheets() { return nr_w; }
	Worksheet *addWorksheet(PType type, int sheet);				// add a new worksheet if needed (function/data dialog)
	int addGraph2D(Graph2D *g, int item, PType type=P2D);		// add Graph2D to widget item in workspace
	int addGraph3D(Graph3D *g, int item, PType type=P3D);		// add Graph3D to widget item in workspace
	int addGraph4D(Graph4D *g, int item);						// add Graph4D to widget item in workspace
	int addGraphM(GraphM *g, int item, PType type=PSURFACE);	// add GraphM to widget item in workspace
	int addGraphIMAGE(GraphIMAGE *g, int item);				// add GraphIMAGE to widget item in workspace
	void calculateRanges2D(Point *a, int n, double *xmin, double *xmax,
		double *ymin, double *ymax);
	void calculateRanges3D(Point3D *a, int n, double *xmin, double *xmax,
		double *ymin, double *ymax, double *zmin, double *zmax);
	void calculateRanges4D(Point4D *a, int n, double *xmin, double *xmax,
		double *ymin, double *ymax, double *zmin, double *zmax, double *tmin, double *tmax);
	QString parseExpression(QString tmp, double value, int j);	// parse expression
	double formatLabel(QString value,int item);
protected:
	void resizeEvent(QResizeEvent *e) { this->resize(e->size()); }
	void dragEnterEvent(QDragEnterEvent *e) { e->accept(QTextDrag::canDecode(e)); }
	void dropEvent(QDropEvent *e);
	void closeEvent(QCloseEvent *e);
	void mouseDoubleClickEvent(QMouseEvent *e) { e->pos(); if(!menuBar()->isVisible()) menuBar()->show(); }

};

#endif // MAINWIN_H
