//LabPlot : PeakListDialog.h

#ifndef PEAKLISTDIALOG_H
#define PEAKLISTDIALOG_H

#include "ListDialog.h"

class PeakListDialog : public ListDialog
{
	Q_OBJECT
public:
	PeakListDialog(MainWin *mw, const char *name);
public slots:
	void setThreshold(double t) { thresholdle->setText(QString::number(t)); }	//!< set threshold for peaks
	void setAccuracy(double a) { accuracyle->setText(QString::number(a)); }	//!< set accurary for peaks
	void searchNegative(bool n=true) { negativecb->setChecked(n); }		//!< search for negative peaks
private:
	KLineEdit *thresholdle, *accuracyle;
	QCheckBox *negativecb;
private slots:
	int apply_clicked();
};

#endif // PEAKLISTDIALOG_H
