//LabPlot : SpreadsheetValuesDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include "SpreadsheetValuesDialog.h"

SpreadsheetValuesDialog::SpreadsheetValuesDialog(MainWin *mw, QTable *t, const char *name)
	: Dialog(mw, name), table(t)
{
	setCaption(QString("Spreadsheet")+i18n(" : ")+QString(name));

	QHBox *hb = new QHBox(vbox);

	// use selected range / max range
	int min=1,max = table->numRows();
	QTableSelection sel = table->selection(table->currentSelection());
	if (sel.isActive()) {
		min = sel.topRow()+1;
		max = sel.bottomRow()+1;
	}
	new QLabel(i18n("Range : "),hb);
	ale =  new KLineEdit(QString::number(min),hb);
	ale->setValidator(new QIntValidator(ale));
	new QLabel(i18n(" to "),hb);
	ble =  new KLineEdit(QString::number(max),hb);
	ble->setValidator(new QIntValidator(ble));
	
	hb = new QHBox(vbox);
	new QLabel(i18n(" Expression (sin(a+b), ...) : "),hb);
	
	hb = new QHBox(vbox);
	funcombo = new KComboBox(hb);
	int col = table->currentColumn();
	KConfig *config = mw->Config();
	config->setGroup( "Spreadsheet" );
	QString fun = config->readEntry(QString("expression%1").arg(col),"sin(a)");
	funcombo->insertItem(fun);		// active fun
	for(int i=0;i<200;i++) {		// 100 columns+100 others
		if(i==col) continue;		// already in first item
		QString entry = config->readEntry(QString("expression%1").arg(i),"");
		if(entry.length()>0)
			funcombo->insertItem(entry);
        }
	funcombo->setEditable(true);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	
	setMinimumWidth(2*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void SpreadsheetValuesDialog::apply_clicked() {
	QString expr = funcombo->currentText();
	int col = table->currentColumn();

	// save expression in config with empty header
	KConfig *config = mw->Config();
	config->setGroup( "Spreadsheet" );
	QString fun = config->readEntry(QString("expression%1").arg(col),"");
	kdDebug()<<"	Saving entry "<<expr<<endl;
	int entry=col;
	if(fun.length()>0) {	// use entry>100
		entry=100;
		fun = config->readEntry(QString("expression%1").arg(entry),"");
	}
	bool expr_found=false;	// check for already saved entries
	for(int i=0;i<=entry;i++) {	// check in 0..100
		fun = config->readEntry(QString("expression%1").arg(i),"");
		
		if(fun==expr) 	// already saved
			expr_found=true;
	}
	while(fun.length()>0 && !expr_found) {	// find empty entry > 100
		fun = config->readEntry(QString("expression%1").arg(++entry),"");
		//kdDebug()<<"	CHECKING entry "<<entry<<" = "<<fun<<endl;
		
		if(fun==expr) 	// already saved
			expr_found=true;
	}
	if(!expr_found) {
		kdDebug()<<"	Saved as "<<entry<<endl;
		config->writeEntry(QString("expression%1").arg(entry),expr);
	}
	else {
		kdDebug()<<"	Entry already saved"<<endl;
	}

	for(int i=ale->text().toInt();i<=ble->text().toInt();i++) {
		QString tmp(expr.lower());
//		kdDebug()<<"	APPLYING EXPR "<<tmp<<endl;
		
		// replace a,b,c,d,...
		for(int j=0;j<table->numCols();j++) {
//			kdDebug()<<"	VALUESTRING = "<< table->text(i-1,j)<<endl;
//			printf("\tVALUE = %.15e\n",table->text(i-1,j).toDouble());		// kdDebug() only shows 6 digits of a double !
			tmp = mw->parseExpression(tmp,table->text(i-1,j).toDouble(),j);
		}
		
//		kdDebug()<<"	PARSE EXPR "<<tmp<<endl;
		double result = parse((char *) tmp.latin1());
//		printf("\tRESULT = %.15e\n",result);
			
		if(parse_errors()>0) {
			KMessageBox::error(mw, i18n("Parse Error!\n Please check the given function."));
			return;
		}

		table->setText(i-1,col,QString::number(result,'g',15));
	}
}
