//LabPlot : Symbol.h

#ifndef SYMBOL_H
#define SYMBOL_H

#include <qcolor.h>
#include "symbols.h"

class Symbol {
public:
	Symbol(SType t=SNONE, QColor c="blue", int s=5, FType f=FNONE, QColor fc="red", int b=1);
	void save(QTextStream *t);
	void open(QTextStream *t,int version);
	void draw(QPainter *p,int X, int Y);
	SType Type() { return type; }
	void setType(SType t) { type = t; }
	QColor Color() { return color; }
	void setColor(QString c) {color = QColor(c); }
	void setColor(QColor c) {color = c; }
	int Size() { return size; }
	void setSize(int s) { size = s; }
	FType Fill() { return fill; }
	void setFill(FType f) { fill = f; }
	QColor FillColor() { return fillcolor; }
	void setFillColor(QString fc) { fillcolor = QColor(fc); }
	void setFillColor(QColor fc) { fillcolor = fc; }
	int Brush() { return brush;}
	void setBrush(int b) { brush = b; }
private:
	SType type;
	QColor color;
	int size;
	FType fill;
	QColor fillcolor;
	int brush;
};

#endif //SYMBOL_H
