//LabPlot : RInterface.cc


#ifdef HAVE_R
extern "C" {
#include <R.h>
#include <Rinternals.h>
#include <Rdefines.h>
extern int Rf_initEmbeddedR(int argc, char *argv[]);
}
#endif

#include <ktempfile.h>
#include <kdebug.h>
#include "RInterface.h"
#include "testsitems.h"

RInterface::RInterface() {
#ifdef HAVE_R
	char *argv[]={"R"};
	Rf_initEmbeddedR(1, argv);
#endif
	// default args
	mu=0.0;
	alt=0;
	paired=false;
	equal=false;
	conf_level=0.95;
	correct=true;
	conf_int=false;
	ratio=1.0;
}

// eval command which return a single results
double RInterface::evalCommand(char *cmd, double *data, int size) {
#ifdef HAVE_R
	SEXP e, val, arg;

	PROTECT(arg = NEW_NUMERIC(size));
	for(int i=0;i<size;i++)
		NUMERIC_DATA(arg)[i] = data[i];

	PROTECT(e = allocVector(LANGSXP, 2));
	SETCAR(e, Rf_install(cmd));
	SETCAR(CDR(e), arg);

	// eval
	PROTECT(val = eval(e, R_GlobalEnv));
	double v = REAL(val)[0];
	if(strcmp(cmd,"length") == 0)
		v = (double) INTEGER(val)[0];

	// printf("RESULT = %g\n", v);
	return v;

	UNPROTECT(3);
#endif
}

// eval command and putting results into data
void RInterface::evalCommandList(char *cmd, double *data, int size) {
#ifdef HAVE_R
	SEXP e, val, arg;

	PROTECT(arg = NEW_NUMERIC(size));
	for(int i=0;i<size;i++)
		NUMERIC_DATA(arg)[i] = data[i];

	PROTECT(e = allocVector(LANGSXP, 2));
	SETCAR(e, Rf_install(cmd));
	SETCAR(CDR(e), arg);

	// eval
	PROTECT(val = eval(e, R_GlobalEnv));

	for(int i=0;i<size;i++)
		data[i] = REAL(val)[i];

	UNPROTECT(3);
#endif
}

// eval command and returning n-th result
double RInterface::evalCommandValue(char *cmd, double *data, int size,int n) {
#ifdef HAVE_R
	SEXP e, val, arg;

	PROTECT(arg = NEW_NUMERIC(size));
	for(int i=0;i<size;i++)
		NUMERIC_DATA(arg)[i] = data[i];

	PROTECT(e = allocVector(LANGSXP, 2));
	SETCAR(e, Rf_install(cmd));
	SETCAR(CDR(e), arg);

	// eval
	PROTECT(val = eval(e, R_GlobalEnv));

	return 	REAL(val)[n];

	UNPROTECT(3);
#endif
}

// convert SEXP val to a char* and put it into buf
// we must use void* here because RInterface.h can not contain SEXP
void RInterface::getVal(void* val, char *buf) {
#ifdef HAVE_R
	// we redirect stdout to a file to get the result
	KTempFile *tmpfile = new KTempFile(QString::null,".R");
	tmpfile->setAutoDelete(true);
	FILE *tmpout = freopen(tmpfile->name(),"w+",stdout);
	Rf_PrintValue((SEXP)val);
	fclose(tmpout);

	tmpout = fopen(tmpfile->name(),"r+");
	int i=0;
	while(!feof(tmpout))
		fscanf(tmpout,"%c",&buf[i++]);
	buf[i-1]='-';
	buf[i]='\0';
	fclose(tmpout);
#endif
}

// eval one sample test
void RInterface::evalTest(RTESTS test, double *data, int size, char *buf) {
	kdDebug()<<"RInterface::evalTest() : One Sample"<<endl;
#ifdef HAVE_R
	SEXP e, val, arg;

	PROTECT(arg = NEW_NUMERIC(size));
	for(int i=0;i<size;i++)
		NUMERIC_DATA(arg)[i] = data[i];

	// test
	if(test == T_T)
		PROTECT(e = allocVector(LANGSXP, 5));
	else if(test == T_WILCOX)
		PROTECT(e = allocVector(LANGSXP, 7));
       	SETCAR(e, Rf_install(tests_test[test]));
	SETCAR(CDR(e), arg);

	// options
	SEXP option;
	SETCAR(CDR(CDR(e)), option = NEW_NUMERIC(1));
	DOUBLE_DATA(option)[0] = mu;
	SET_TAG(CDR(CDR(e)), Rf_install("mu"));

	SETCAR(CDR(CDR(CDR(e))), option = NEW_CHARACTER(1));
	switch(alt) {
	case 0: SET_STRING_ELT(option, 0, mkChar("two.sided")); break;
	case 1: SET_STRING_ELT(option, 0, mkChar("less")); break;
	case 2: SET_STRING_ELT(option, 0, mkChar("greater")); break;
	}
	SET_TAG(CDR(CDR(CDR(e))), Rf_install("alternative"));

	SETCAR(CDR(CDR(CDR(CDR(e)))), option = NEW_NUMERIC(1));
	DOUBLE_DATA(option)[0] = conf_level;
	SET_TAG(CDR(CDR(CDR(CDR(e)))), Rf_install("conf.level"));

	if(test == T_WILCOX) {
		SETCAR(CDR(CDR(CDR(CDR(CDR(e))))), option = NEW_LOGICAL(1));
		LOGICAL_DATA(option)[0] = correct;
		SET_TAG(CDR(CDR(CDR(CDR(CDR(e))))), Rf_install("correct"));
		SETCAR(CDR(CDR(CDR(CDR(CDR(CDR(e)))))), option = NEW_LOGICAL(1));
		LOGICAL_DATA(option)[0] = conf_int;
		SET_TAG(CDR(CDR(CDR(CDR(CDR(CDR(e)))))), Rf_install("conf.int"));
	}

	// eval
	// print for testing (first time only : stdout)
	Rf_PrintValue(e);
	PROTECT(val = eval(e, R_GlobalEnv));

	getVal((void *)val,buf);

	UNPROTECT(3);
#endif
}

// eval two sample test	with one allowed option
void RInterface::evalTest(RTESTS test, double *data1, double *data2, int size, char *buf) {
	kdDebug()<<"RInterface::evalTest() : Two Samples"<<endl;
#ifdef HAVE_R
	SEXP e, val, arg1, arg2;

	PROTECT(arg1 = NEW_NUMERIC(size));
	PROTECT(arg2 = NEW_NUMERIC(size));
	for(int i=0;i<size;i++) {
		NUMERIC_DATA(arg1)[i] = data1[i];
		NUMERIC_DATA(arg2)[i] = data2[i];
	}

	if(test == T_T)
		PROTECT(e = allocVector(LANGSXP, 8));
	else if(test == T_WILCOX)
		PROTECT(e = allocVector(LANGSXP, 9));
	else if(test == T_F)
		PROTECT(e = allocVector(LANGSXP, 6));
	else if(test == T_KS)
		PROTECT(e = allocVector(LANGSXP, 4));
	else if(test == T_ANSARI)
		PROTECT(e = allocVector(LANGSXP, 5));
	SETCAR(e, Rf_install(tests_test[test]));
	SETCAR(CDR(e), arg1);
	SETCAR(CDR(CDR(e)), arg2);

	// options
	SEXP option;
	SETCAR(CDR(CDR(CDR(e))), option = NEW_CHARACTER(1));
	switch(alt) {
		case 0: SET_STRING_ELT(option, 0, mkChar("two.sided")); break;
		case 1: SET_STRING_ELT(option, 0, mkChar("less")); break;
		case 2: SET_STRING_ELT(option, 0, mkChar("greater")); break;
	}
	SET_TAG(CDR(CDR(CDR(e))), Rf_install("alternative"));

	if(test != T_KS) {
		SETCAR(CDR(CDR(CDR(CDR(e)))), option = NEW_NUMERIC(1));
		DOUBLE_DATA(option)[0] = conf_level;
		SET_TAG(CDR(CDR(CDR(CDR(e)))), Rf_install("conf.level"));
	}
	if(test == T_F) {
		SETCAR(CDR(CDR(CDR(CDR(CDR(e))))), option = NEW_NUMERIC(1));
		DOUBLE_DATA(option)[0] = ratio;
		SET_TAG(CDR(CDR(CDR(CDR(CDR(e))))), Rf_install("ratio"));
	}
/*	this doesn't work
	if(test == T_ANSARI) {
		SETCAR(CDR(CDR(CDR(CDR(CDR(e))))), option = NEW_LOGICAL(1));
		LOGICAL_DATA(option)[0] = conf_int;
		SET_TAG(CDR(CDR(CDR(CDR(CDR(e))))), Rf_install("conf.int"));
	}*/
	if(test == T_T || test == T_WILCOX) {
		SETCAR(CDR(CDR(CDR(CDR(CDR(e))))), option = NEW_NUMERIC(1));
		DOUBLE_DATA(option)[0] = mu;
		SET_TAG(CDR(CDR(CDR(CDR(CDR(e))))), Rf_install("mu"));
		SETCAR(CDR(CDR(CDR(CDR(CDR(CDR(e)))))), option = NEW_LOGICAL(1));
		LOGICAL_DATA(option)[0] = paired;
		SET_TAG(CDR(CDR(CDR(CDR(CDR(CDR(e)))))), Rf_install("paired"));
	}
	if(test == T_T) {
		SETCAR(CDR(CDR(CDR(CDR(CDR(CDR(CDR(e))))))), option = NEW_LOGICAL(1));
		LOGICAL_DATA(option)[0] = equal;
		SET_TAG(CDR(CDR(CDR(CDR(CDR(CDR(CDR(e))))))), Rf_install("var.equal"));
	}
	if(test == T_WILCOX) {
		SETCAR(CDR(CDR(CDR(CDR(CDR(CDR(CDR(e))))))), option = NEW_LOGICAL(1));
		LOGICAL_DATA(option)[0] = conf_int;
		SET_TAG(CDR(CDR(CDR(CDR(CDR(CDR(CDR(e))))))), Rf_install("conf.int"));
		SETCAR(CDR(CDR(CDR(CDR(CDR(CDR(CDR(CDR(e)))))))), option = NEW_LOGICAL(1));
		LOGICAL_DATA(option)[0] = correct;
		SET_TAG(CDR(CDR(CDR(CDR(CDR(CDR(CDR(CDR(e)))))))), Rf_install("correct"));
	}

	// eval
	// print for testing (first time only : stdout)
	Rf_PrintValue(e);
	PROTECT(val = eval(e, R_GlobalEnv));

	getVal((void *)val,buf);

	UNPROTECT(4);
#endif
}
