//LabPlot : TestsRListDialog.cc

#include "TestsRListDialog.h"
#include "tests.h"
#include "testsitems.h"

TestsRListDialog::TestsRListDialog(MainWin *m, const char *name)
	: ListDialog(m, name)
{
	kdDebug()<<"TestsRListDialog()"<<endl;
	setCaption(i18n("Tests R Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "TestsR" );

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	testlabel = new QLabel("",hb);
	testcb = new KComboBox(hb);

	hb = new QHBox(tab1);
	pairedcb = new QCheckBox(i18n("Paired"),hb);
	pairedcb->setChecked(config->readBoolEntry("Paired",false));
	equalcb = new QCheckBox(i18n("Equal Variances"),hb);
	equalcb->setChecked(config->readBoolEntry("Equal",false));
	hb = new QHBox(tab1);
	mulabel = new QLabel(i18n("mu : "),hb);
	mule = new KLineEdit(QString::number(config->readDoubleNumEntry("mu",0.0)),hb);
	mule->setValidator(new QDoubleValidator(mule));
	ratiolabel = new QLabel(i18n("Ratio : "),hb);
	ratiole = new KLineEdit(QString::number(config->readDoubleNumEntry("Ratio",1.0)),hb);
	ratiole->setValidator(new QDoubleValidator(ratiole));
	hb = new QHBox(tab1);
	new QLabel(i18n("Alternative : "),hb);
	altcb = new KComboBox(hb);
	QStringList tlist;
	tlist << i18n("two.sided") << i18n("less") << i18n("greater");
	altcb->insertStringList(tlist);
	altcb->setCurrentItem(config->readNumEntry("Alternative",0));
	hb = new QHBox(tab1);
	conflabel = new QLabel(i18n("Confidence Level : "),hb);
	confle = new KLineEdit(QString::number(config->readDoubleNumEntry("ConfLevel",0.95)),hb);
	confle->setValidator(new QDoubleValidator(confle));
	hb = new QHBox(tab1);
	correctcb = new QCheckBox(i18n("Continuity Correction"),hb);
	correctcb->setChecked(config->readBoolEntry("Correction",true));
	confcb = new QCheckBox(i18n("Confidence Interval"),hb);
	confcb->setChecked(config->readBoolEntry("Confidence",false));

	updateDialog();
	updateOptions(0);

	// textview with results
	infote = new QTextEdit(vbox);

	tw->addTab(tab1,i18n("Parameter"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(2.0*minimumSize());
}

void TestsRListDialog::updateDialog() {
	KConfig *config = mw->Config();
	config->setGroup( "TestsR" );

	// fill combobox with tests
	testcb->clear();
	if(s != 0) {
		int i=0;
		if(s->selectedColumns() == 1) {
			testlabel->setText(i18n("One sample Test : "));
			// only first two tests are one sample tests
			testcb->insertItem(i18n(tests_typeitems[0]));
			testcb->insertItem(i18n(tests_typeitems[1]));
		}
		else {
			testlabel->setText(i18n("Two sample Test : "));
			while(tests_typeitems[i] != 0) testcb->insertItem(i18n(tests_typeitems[i++]));
		}
       		testcb->setCurrentItem(config->readNumEntry("Test",0));
	}

	QObject::connect(testcb,SIGNAL(activated(int)),SLOT(updateOptions(int)));
}

// update options when selected test changes
void TestsRListDialog::updateOptions(int item) {
	pairedcb->hide();
	equalcb->hide();
	mulabel->hide();
	mule->hide();
	altcb->hide();
	conflabel->hide();
	confle->hide();
	correctcb->hide();
	confcb->hide();
	ratiolabel->hide();
	ratiole->hide();

	switch(item) {
	case T_T :
		if(s && s->selectedColumns() > 1) {
			pairedcb->show();
			equalcb->show();
		}
		mulabel->show();
		mule->show();
		altcb->show();
		conflabel->show();
		confle->show();
		break;
	case T_WILCOX :
		if(s && s->selectedColumns() > 1)
			pairedcb->show();
		mulabel->show();
		mule->show();
		altcb->show();
		conflabel->show();
		confle->show();
		correctcb->show();
		confcb->show();
		break;
	case T_F:
		ratiolabel->show();
		ratiole->show();
		altcb->show();
		conflabel->show();
		confle->show();
		break;
	case T_KS:
		altcb->show();
		break;
	case T_ANSARI:
		altcb->show();
		conflabel->show();
		confle->show();
		// this doesn't work
//		confcb->show();
		break;
	}
}

void TestsRListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "TestsR" );

	config->writeEntry("Test",testcb->currentItem());
	config->writeEntry("Paired",pairedcb->isChecked());
	config->writeEntry("Equal",equalcb->isChecked());
	config->writeEntry("mu",mule->text().toDouble());
	config->writeEntry("Alternative",mule->text().toDouble());
	config->writeEntry("ConfLevel",confle->text().toDouble());
	config->writeEntry("Correction",correctcb->isChecked());
	config->writeEntry("Confidence",confcb->isChecked());
	config->writeEntry("Ratio",ratiole->text().toDouble());
}

int TestsRListDialog::apply_clicked() {
	kdDebug()<<"TestsRListDialog::apply_clicked()"<<endl;
	RInterface *rif = mw->getRInterface();

	if(s) {
		QTable *table = s->Table();

		// find first one or two selected columns
		int indexa=-1, indexb=-1;
		for(int i=0;i<table->numCols();i++) {
			if(table->isColumnSelected(i) && indexa==-1) {
				indexa=i;
				continue;
			}
			if(table->isColumnSelected(i) && indexb==-1)
				indexb=i;
		}
		kdDebug()<<"	Selected columns : "<<indexa<<' '<<indexb<<endl;

		if(indexa==-1) {
			kdDebug()<<"	no column selected!"<<endl;
			KMessageBox::error( this,i18n("No Column selected."));
			return -1;
		}

		// set options
		rif->setPaired(pairedcb->isChecked());
		rif->setEqual(equalcb->isChecked());
		rif->setMu(mule->text().toDouble());
		rif->setAlternative(altcb->currentItem());
		rif->setConfLevel(confle->text().toDouble());
		rif->setCorrect(correctcb->isChecked());
		rif->setConfInt(confcb->isChecked());
		rif->setRatio(ratiole->text().toDouble());

		char buf[10000];
		int N = table->numRows();
		if(indexb == -1) {	// one sample test
			double *data = new double[N];
			for(int j=0;j < N;j++)
				data[j] = table->text(j,indexa).toDouble();

			rif->evalTest((RTESTS) testcb->currentItem(),data,N,buf);
		}
		else {	// two sample test
			double *data1 = new double[N];
			double *data2 = new double[N];
			for(int j=0;j < N;j++) {
				data1[j] = table->text(j,indexa).toDouble();
				data2[j] = table->text(j,indexb).toDouble();
			}

			rif->evalTest((RTESTS) testcb->currentItem(),data1,data2,N,buf);
		}
		infote->append(buf);

		return 0;
	}

	return 0;
}
