# !Nihongo,Japanese!  -*-coding: euc-jp;-*-
#
#
#
#
#   language-env
#
#   This file is a part of the Debian language-env package.
#   Language Support File for Japanese
#
# Copyright (C) 1998-2003 Tomohiro KUBOTA
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# On Debian GNU/Linux systems, the complete text of the GNU General
# Public License can be found in `/usr/share/common-licenses/GPL'.



# This is needed to check Canna and Wnn.
use Socket;

# This is needed to support UTF-8.
use Text::Iconv;

# ---------------------------------------------------
# isNC()
# ---------------------------------------------------
sub isNC($$$)
{
	my ($KANJI, $TTY, $TERM, $DISPLAY, $THIS, $OPT, $OPT_N, $a, $CHARMAP);
	$TTY = `/usr/bin/tty`;
	$TERM = $ENV{TERM};
	$DISPLAY = $ENV{DISPLAY};
	$THIS = $_[0];
	$OPT = $_[1];
	$OPT_N = $_[2];
	$UTF8 = 0;
	$CHARMAP = `/usr/bin/locale charmap`; chomp($CHARMAP);
	$euc2utf8 = Text::Iconv->new("EUC-JP", "UTF-8");

	if ($DISPLAY ne '' && $ENV{WINDOWID} ne '' && &executable("xprop")) {
		$a = system("/usr/bin/X11/xprop -id $ENV{WINDOWID} &> /dev/null");
		if ($a == 0) {$WM = `/usr/bin/X11/xprop -id $ENV{WINDOWID}`;}
		else {$WM = ""; $DISPLAY = "";}
	}
	
	if ($TERM eq 'kon' || $TERM eq 'kterm') {
		$KANJI=1;
	} elsif ($TERM eq 'jfbterm' || $TERM eq 'mlterm' || $TERM eq 'xterm') {
		$KANJI=1000;
	} elsif ($DISPLAY ne '' && $TERM eq 'rxvt' && $WM =~ /krxvt/) {
		$KANJI=1;
	} elsif ($DISPLAY ne '' && &executable("kterm") && !$OPT_N) {
		exec("kterm -km euc -e $THIS -N -C $OPT");
	} elsif ($DISPLAY ne '' && &executable("krxvt") && !$OPT_N) {
		exec("krxvt -km euc -e $THIS -N -C $OPT");
	} elsif ($DISPLAY ne '' && &executable("mlterm") && !$OPT_N) {
		exec("mlterm -E EUCJP -e $THIS -N -C $OPT");
	} else {
		$a = "ʸɤޤ\n";
		if ($CHARMAP eq 'UTF-8') {
			print STDERR &sourceset2utf8($a);
		} else {
			print STDERR &sourceset2eucjp($a);
		}
		print STDERR "UE NO BUNSYOU (KANJI) GA YOMEMASUKA? [y/N] ";
		$a = <>;
		if ($a =~ /y|Y/) {
			if ($CHARMAP eq 'UTF-8') {$KANJI=2;}
			else {$KANJI=1;}
		} elsif ($TTY =~ m!/dev/tty[0-9]+! && &executable("kon") 
		  && !$OPT_N) {
			print STDERR "\"KON\" WO JIKKOU SHIMASUKA? [Y/n] ";
			$a = <>;
			exec("kon -e $THIS -N -C $OPT") if ($a !~ /n|N/);
			$KANJI=0;
		} elsif ($TTY =~ m!/dev/tty[0-9]+! && &executable("jfbterm") 
		  && !$OPT_N) {
			print STDERR "\"jfbterm\" WO JIKKOU SHIMASUKA? [Y/n] ";
			$a = <>;
			exec("jfbterm -e $THIS -N -C $OPT") if ($a !~ /n|N/);
			$KANJI=0;
		} else {
			$KANJI=0;
		}
	}
	if ($KANJI == 1000) {
		if ($CHARMAP eq 'UTF-8') {$KANJI=2;}
		elsif ($CHARMAP eq 'EUC-JP') {$KANJI=1;}
		else {$KANJI=0;}
	}
	$KANJIMODE = $KANJI;
}

sub executable($)
{
	my($WHICH);
	$WHICH = '/usr/bin/which';
	if (system("$WHICH $_[0] >/dev/null")==0) {return 1;}
	return 0;
}


# ---------------------------------------------------
# initialize()
# ---------------------------------------------------
sub initialize()
{
	&check_im("Canna", 5680, "/tmp/.iroha_unix/IROHA");
	&check_im("Wnn", 22273, "");
	&check_im("SKK", 1178, "");
	&check_im("Anthy", 0, "");
	&check_im("PRIME", 0, "");

	# ---------- select default input method ----------
	$m = 0;
	foreach $i ("Canna", "Wnn", "SKK", "Anthy", "PRIME") {
		$m += $Sub::IM_EXIST{$i};
		if ($Sub::IM_EXIST{$i}) {$def = $i;}
	}
	if ($m == 1) {
		$Sub::IM_DEFAULT = $def;
	} else {
		if ($Sub::IM_EXIST{"PRIME"}) {
			$d = 5;
		} elsif ($Sub::IM_EXIST{"Anthy"}) {
			$d = 4;
		} elsif ($Sub::IM_EXIST{"SKK"}) {
			$d = 3;
		} elsif ($Sub::IM_EXIST{"Wnn"}) {
			$d = 2;
		} elsif ($Sub::IM_EXIST{"Canna"}) {
			$d = 1;
		} else {
			$d = 1;
		}
		$dd = &Sub::select(
			"KANJI HENKAN NIHA DORE WO TSUKAI MASUKA ".
			"1=Canna 2=Wnn 3=SKK 4=Anthy 5=PRIME 6=none ",
			"ѴˤϤɤȤޤ ".
			"1=Canna 2=Wnn 3=SKK 4=Anthy 5=PRIME 6=ʤ ", 6, $d);
		if ($dd == 1) {$Sub::IM_DEFAULT = "Canna";}
		if ($dd == 2) {$Sub::IM_DEFAULT = "Wnn";}
		if ($dd == 3) {$Sub::IM_DEFAULT = "SKK";}
		if ($dd == 4) {$Sub::IM_DEFAULT = "Anthy";}
		if ($dd == 5) {$Sub::IM_DEFAULT = "PRIME";}
		if ($dd == 6) {$Sub::IM_DEFAULT = "";}
	}
	$Sub::EXTENDED =
	    &Sub::yesno("NIHONGO NIHA KANKEINO NAI " .
			"SAMAZAMANA SETTEIWO OKONAI MASUKA",
			"ܸˤϴطΤʤ͡Ԥޤ");

	if ($Sub::IM_DEFAULT eq "Canna") {
		if (!$IM_EXIST{"Canna"}) {
			&Sub::addlist("canna");
		}
	} elsif ($Sub::IM_DEFAULT eq "Wnn") {
		if (!$IM_EXIST{"Wnn"}) {
			if (!&Sub::isinstalled("wnn")) {
				&Sub::addlist("freewnn-jserver");
			}
		}
	} elsif ($Sub::IM_DEFAULT eq "SKK") {
		if (!$IM_EXIST{"SKK"}) {
			if (!&Sub::isinstalled("skkserv")) {
				&Sub::addlist("dbskkd-cdb");
			}
			if (!&Sub::isinstalled("skk")) {
				&Sub::addlist("ddskk");
			}
		}
		system("/usr/bin/touch ~/.skk-jisyo");
	} elsif ($Sub::IM_DEFAULT eq "Anthy") {
		if (!$IM_EXIST{"Anthy"}) {
			&Sub::addlist("anthy");
			&Sub::addlist("uim-xim");
		}
	} elsif ($Sub::IM_DEFAULT eq "PRIME") {
		if (!$IM_EXIST{"PRIME"}) {
			&Sub::addlist("prime");
			&Sub::addlist("uim-xim");
		}
	}

	# ---------- add required packages ----------
	if ($ENV{'HOSTTYPE'} =~ /i?86/) {&Sub::addlist("kon2");}
	&Sub::addlist("ja-trans");
#	&Sub::addlist("locale-ja");  not used since woody
	&Sub::addlist("locales");
	&Sub::addlist("manpages-ja");
#	&Sub::addlist("dpkg-doc-ja");
	if (&Sub::isinstalled("less")) {&Sub::addlist("jless");}
#	if (&Sub::isinstalled("groff")) {&Sub::addlist("jgroff");}
#	if (&Sub::isinstalled("fvwm2")) {&Sub::addlist("fvwm2-ja");}
#	if (&Sub::isinstalled("fvwm95")) {&Sub::addlist("fvwm95-ja");}
#	if (&Sub::isinstalled("afterstep")) {&Sub::addlist("afterstep-i18n");}
	if (&Sub::isinstalled("tcsh")) {&Sub::addlist("tcsh-kanji");}
#	if (&Sub::isinstalled("dvi2tty")) {&Sub::addlist("dvi2tty-ja");}
#	if (&Sub::isinstalled("mutt")) {&Sub::addlist("mutt-ja");}
	if (&Sub::isinstalled("slrn")) {&Sub::addlist("slrn-ja");}
#	if (&Sub::isinstalled("tgif")) {&Sub::addlist("tgif-ja");}
	if (&Sub::isinstalled("xjed")) {&Sub::addlist("xjed-ja");}
	if (&Sub::isinstalled("xterm")) {&Sub::addlist("kterm");}
	if (&Sub::isinstalled("xterm")) {
		&Sub::addlist("kterm");
		&Sub::addlist("xutils");
	}
	if (&Sub::isinstalled("rxvt")) {&Sub::addlist("rxvt-beta");}
	if (&Sub::isinstalled("nethack")) {&Sub::addlist("jnethack");}
	if (&Sub::isinstalled("doc-debian")) {&Sub::addlist("doc-debian-ja");}
	if (&Sub::isinstalled("apt-howto")) {&Sub::addlist("apt-howto-ja");}
	if (&Sub::isinstalled("doc-linux-text")) {
		&Sub::addlist("doc-linux-ja-text");
	}
	if (&Sub::isinstalled("doc-linux-html")) {
		&Sub::addlist("doc-linux-ja-html");
	}
	if (&Sub::isinstalled("vim")) {
		&Sub::addlist("jvim-canna");
	}
	if (&Sub::isinstalled("nvi") && !&Sub::isinstalled("nvi-m17n") && 
	 !&Sub::isinstalled("nvi-m17n-canna")) {
		if ($Sub::IM_DEFAULT eq "Canna") {
			&Sub::addlist("nvi-m17n-canna");
		} else {
			&Sub::addlist("nvi-m17n");
		}
	}
	if (&Sub::isinstalled("xserver-.*")) {
#		&Sub::addlist("xfonts-cjk");    not used since woody
		&Sub::addlist("xbase-clients"); # xprop in .bashrc/.cshrc
		if ($Sub::IM_DEFAULT eq "SKK") {
			&Sub::addlist("skkinput");
		} elsif ($Sub::IM_DEFAULT eq "Canna") {
			if (!&Sub::isinstalled("kinput2.*canna.*")) {
				&Sub::addlist("kinput2-canna");
			}
		} elsif ($Sub::IM_DEFAULT eq "Wnn") {
			if (!&Sub::isinstalled("kinput2.*wnn.*")) {
				&Sub::addlist("kinput2-wnn");
			}
		}
	}
}

# This function is not not needed for every languages.
# only for Japanese. 
sub check_im($$$)
{
	my ($im, $port, $remote, $unix_tmp);
	$im = $_[0];
	$port = $_[1];
	$unix_tmp = $_[2];

	if($im eq "PRIME") {
		&Sub::disp("PRIME GA UGOITE ", "PRIME ư");
		if(-f "/usr/bin/prime") {
			&Sub::disp("IMASU.\n","ޤ\n");
			$Sub::IM_EXIST{$im} = 1;
		} else {
			&Sub::disp("IMASEN.\n","ޤ\n");
			$Sub::IM_EXIST{$im} = 0;
		}
		$Sub::IM_HOST{$im} = "";
		return;
	}

	if($im eq "Anthy") {
		&Sub::disp("Anthy GA UGOITE ", "Anthy ư");
		if(-f "/usr/bin/anthy-agent") {
			&Sub::disp("IMASU.\n","ޤ\n");
			$Sub::IM_EXIST{$im} = 1;
		} else {
			&Sub::disp("IMASEN.\n","ޤ\n");
			$Sub::IM_EXIST{$im} = 0;
		}
		$Sub::IM_HOST{$im} = "";
		return;
	}
	
	&Sub::disp("$im server GA UGOITE ", "$im Сư");
	if ($unix_tmp ne "" && socket(S,PF_UNIX,SOCK_STREAM,0) &&
	    connect(S, sockaddr_un($unix_tmp))) {
		$Sub::IM_EXIST{$im} = 1;
		$Sub::IM_HOST{$im} = "";
		close(S);
		&Sub::disp("IMASU.\n","ޤ\n");
		return;
	}
	$proto = getprotobyname("tcp");
	$in_addr = (gethostbyname("localhost"))[4];
	$addr = sockaddr_in($port, $in_addr);
	if (socket(S,AF_INET,SOCK_STREAM,$proto) && connect(S, $addr)) {
		$Sub::IM_EXIST{$im} = 1;
		$Sub::IM_HOST{$im} = "";
		close(S);
		&Sub::disp("IMASU.\n","ޤ\n");
	} else {
		$Sub::IM_EXIST{$im} = 0;
		$Sub::IM_HOST{$im} = "";
		&Sub::disp("IMASEN.\n","ޤ\n");
		$remote = &Sub::noyes(
			"network NO DOKOKA BETSUNO computer DE " . 
			"$im server GA UGOITE IMASUKA",
			"ͥåȥΤɤ̤Υԥ塼 " .
			"$im СưƤޤ");
		if ($remote) {
			$Sub::IM_HOST{$im} = &Sub::ask(
				"SONO host MEI WO NYUURYOKU SHITE KUDASAI",
				"Υۥ̾ϤƤ");
			$Sub::IM_EXIST{$im} = 1;
		}
	}
}

# ---------------------------------------------------
# sourceset2displayset()
# ---------------------------------------------------
sub sourceset2displayset ($)
{
	my ($a, $b, $r);
	$a = $_[0];
	if ($KANJIMODE == 2) {return &sourceset2utf8($a);}
	$r = "";
	while (length($a) != 0) {
		$a =~ /^([\0-\177]*)(.*)/s;
		$b = $1; $a = $2;
		$r .= $b;

		if (length($a) != 0) {
			$a =~ /^([\200-\377]*)(.*)/s;
			$b = $1; $a = $2;
			$b =~ tr|\200-\377|\0-\177|;
			$r .= "\x1b\$B" . $b . "\x1b(B";
		}
	}
	$r;
}

sub sourceset2eucjp($)
{
	my ($a);
	$a = $_[0];
	$a;
}

sub sourceset2utf8($)
{
	my ($a, $r);
	$a = $_[0];
	$r = $euc2utf8->convert($a);
	$r;
}


# ---------------------------------------------------
# analcode()
# ---------------------------------------------------
sub analcode($)
{
	my ($c1, $c2, $string, $k);
	$string = $_[0];
	if ($string =~ /\x1b\$B/) {return 'JIS';}
	if ($string =~ /\x1b\(B/) {return 'JIS';}

	$k = 0;
	for $c (split(//,$string)) {
		$a = unpack("C", $c);
		if ($k) {
			return 'SJIS' if ($a<0xa0);
			$k = 0;
		} else {
			return 'SJIS' if ($a>0x80 && $a<0xa0);
			$k = 1 if ($a>0x80);
		}
	}
	return 'EUC';
}

# ---------------------------------------------------
# convcode()
# ---------------------------------------------------
sub convcode($$)
{
	$string = $_[0];
	$tocode = $_[1];

	# fromcode  EUC-JP ˷ޤäƤ!
	$fromcode = &analcode($string);
	if ($fromcode eq $tocode) {return $string;}
	if ($tocode eq 'JIS') {
		return sourceset2displayset($string);
	}
	if ($tocode eq 'SJIS') {
		return _euc2sjis($string);
	}
	return $string;
}

sub _euc2sjis($)
{
	my ($string);
	$string = $_[0];
	$r = "";
	$k = 0;
	for $c (split(//,$string)) {
		$a = unpack("C", $c);
		if (!$k) {
			if ($a>0x7f) {
				$c0 = $c;
				$a0 = $a;
				$k = 1;
			} else {
				$r .= $c;
			}
			next;
		}
		$a &= 0x7f;
		$a0 &= 0x7f;
		if ($a0 & 1) {
			if ($a < 0x60)   {$a += 0x1f;}
			else             {$a += 0x20;}
		} else {
					  $a += 0x7e;
		}
		if ($a0 < 0x5f) {
					  $a0 = ($a0+0xe1)>>1;
		} else {
					  $a0 = ($a0+0x161)>>1;
		}
		$r .= pack("C",$a0) . pack("C",$a);
		$k = 0;
	}
	return $r;
}

sub _sjis2euc($)
{
	my($string, $r);
	$string = $_[0];
	$r = "";
	$k = 0;
	for $c (split(//,$string)) {
		$a = unpack("C", $c);
		if (!$k) {
			if ($a>=0xa0 && $a<=0xdf) {
				$r .= pack("C", 0x8e);
			} elsif ($a >= 0x81) {
				$k = 1;
				$c0 = $c;
				$a0 = $a;
			} else {
				$r .= $c;
			}
			next;
		}
		if ($a0 <= 0x9f) {
			if ($a<0x9f) {
				$r .= pack("C", $a0*2-0xe1);
			} else {
				$r .= pack("C", $a0*2-0xe0);
			}
		} else {
			if ($a<0x9f) {
				$r .= pack("C", $a0*2-0x161);
			} else {
				$r .= pack("C", $a0*2-0x160);
			}
		}
		if ($a < 0x7f) {
			$r .= pack("C", $a-0x1f);
		} elsif ($a < 0x9f) {
			$r .= pack("C", $a-0x20);
		} else {
			$r .= pack("C", $a-0x7e);
		}
		$k = 0;
			
	}
	return $r;
}

# ---------------------------------------------------
# messages in Japanese
# ---------------------------------------------------

%messages = (

# msgid
"\nPush [Enter] key to End.\n" =>
# msgstr (in ASCII)
"\n[Enter] key WO OSUTO KONO set-language-env HA SYUURYOU SHIMASU.\n\000" .
# msgstr (in native character set: EUC-JP)
"\n[Enter] 򲡤Ƥλޤ\n",

# msgid
"Now obtaining package list...\n" =>
# msgstr (in ASCII)
"package ICHIRAN WO SYUTOKU SHITE IMASU...\n\000" .
# msgstr (in native character set: EUC-JP)
"ѥåƤޤ...\n" ,

# msgid
"Do setting? " =>
# msgstr (in ASCII)
"SETTEI WO OKONAI MASUKA \000" .
# msgstr (in native character set: EUC-JP)
"Ԥޤ " ,

# msgid
"Setting is not done.\n" =>
# msgstr (in ASCII)
"SETTEI SHIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"ꤷޤ\n" ,

# msgid
"Do setting...\n" =>
# msgstr (in ASCII)
"SETTEI SHIMASU ...\n\000" .
# msgstr (in native character set: EUC-JP)
"ꤷޤ...\n" ,

# msgid
"Cannot read \"%s\".\n" =>
# msgstr (in ASCII)
"\"%s\" WO YOMEMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"\"%s\"  ɤޤ\n" ,

#msgid
"Making a new file \"%s\"...\n" =>
# msgstr (in ASCII)
"ATARASHII file \"%s\" WO TSUKURIMASU...\n\000" .
# msgstr (in native character set: EUC-JP)
"ե \"%s\" ޤ...\n" ,

# msgid
"Cannot open \"%s\".\n" =>
# msgstr (in ASCII)
"\"%s\" WO open DEKIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"\"%s\" 򥪡ץǤޤ\n" ,

# msgid
"Cannot write to \"%s\".\n" =>
# msgstr (in ASCII)
"\"%s\" NI KAKIKOMI GA DEKIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"\"%s\" ˽񤭹ߤǤޤ\n" ,

# msgid
"Cannot lock \"%s\".\n" =>
# msgstr (in ASCII)
"\"%s\" WO lock DEKIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"\"%s\" åǤޤ\n" ,

# msgid
"Cannot close \"%s\".\n" =>
# msgstr (in ASCII)
"\"%s\" WO close DEKIMASEN.\n\000" .
# msgstr (in native character set: EUC-JP)
"\"%s\" 򥯥Ǥޤ\n" ,

# msgid
"Install the following packages.\n" =>
# msgstr (in ASCII)
"IKA NI SHIMESU package WO install SHITE KUDASAI.\n\000" .
# msgstr (in native character set: EUC-JP)
"ʲ˼ѥå򥤥󥹥ȡ뤷Ʋ\n" ,

# msgid
"   Setting is now done.  To activate these settings,\n".
"logout and login.\n".
"   Read each dotfile and confirm the modification.\n".
"If you don't like the setting, modify directly or\n".
"add overriding setting after 'language-env end' line.\n".
"   Read /usr/share/doc/language-env/README.* for detail.\n" =>
# msgstr (in ASCII)
"   SETTEI GA SYUURYOU SHIMASHIA. SETTEI WO YUUKOU NI\n" .
"SURUNIHA, ICHIDO logout SHITEKARA, FUTATABI login SHITE\n" .
"KUDASAI.\n" .
"   SOREZORE NO dotfile WO YONDE, DONOYOUNI HENKOU SARETAKA,\n" .
"KAKUNIN SHITE KUDASAI. KINI IRANAI SETTEI HA, CHOKUSETSU\n" .
"HENKOU SURUKA, 'language-env end' IKOU NO GYOU NI SAI-SETTEI\n" .
"WO KAKI-KUWAETE KUDASAI.\n" .
"   KUWASIKUHA, /usr/share/doc/language-env/README.ja.eucJP.gz WO\n" .
" SANSYOU SHITE KUDASAI.\n\000" .
# msgstr (in native character set: EUC-JP)
"  ꤬λޤͭˤˤϡ٥\n" .
"ƤƤӥ󤷤Ƥ\n" .
"  줾ΥɥåȥեɤǡɤΤ褦ѹ줿\n" .
"ǧƤʤϡľѹ뤫\n" .
"'language-env end' ʹߤιԤ˺񤭲äƤ\n" .
"  ܤ /usr/share/doc/language-env/README.ja.eucJP.gz \n" .
"ȤƲ\n" ,

# msgid
"Usage: set-language-env [options]\n".
"  -l language : Specify language (otherwise choose from menu)\n".
"  -h          : This help message\n".
"  -v          : 'verbose mode'\n".
"  -s          : Display list of supported languages and exit\n".
"  -r          : Remove all settings\n".
"  -N          : Never fork another set-language-env (for internal use)\n".
"  -c          : Don't use native character set (for internal use)\n".
"  -C          : Use native character set (for internal use)\n".
"  -E          : Setting for /etc/skel directory (root user only)\n" =>
# msgstr (in ASCII)
"Tsukaikata: set-language-env [options]\n" .
"  -l GENGO : GENGO WO SHITEI SURU (NAKEREBA menu KARA ERABU)\n" .
"  -h       : KONO help message\n" .
"  -v       : 'verbose mode'\n" .
"  -s       : support SARETE IRU GENGO NO ICHIRAN WO HYOUJI SHITE\n" .
"             SYUURYOU SURU\n" .
"  -r       : SUBETE NO setting WO TORINOZOKU\n" .
"  -N       : BETSU NO set-language-env WO fork SHINAI (NAIBU DE SHIYOU SURU)\n" .
"  -c       : GENGO NO MOJI (KANJI NADO) WO TSUKAWANAI (NAIBU DE SHIYOU SURU)\n" .
"  -C       : GENGO NO MOJI (KANJI NADO) WO TSUKAU (NAIBU DE SHIYOU SURU)\n".
"  -E       : /etc/skel directory WO SETTEI SURU (root user NOMI)\n\000".
# msgstr (in native character set: EUC-JP)
"Ȥ: set-language-env [ץ]\n" .
"  -l   : ꤹ (ʤХ˥塼)\n" .
"  -h       : Υإץå\n" .
"  -v       : ¹Իξܤɽ\n" .
"  -s       : ݡȤƤΰɽƽλ\n" .
"  -r       : Ƥõ\n".
"  -N       : ̤ set-language-env  fork ʤ (ǻѤ)\n".
"  -c       : 줴Ȥʸ (ʤ) Ȥʤ (ǻѤ)\n".
"  -C       : 줴Ȥʸ (ʤ) Ȥ (ǻѤ)\n".
"  -E       : /etc/skel ǥ쥯ȥꤹ (롼ȥ桼Τ)\n" ,

# msgid
"Install the following locales.\n" =>
# msgstr1 (ASCII)
"IKA NO locale WO install SHITE KUDASAI.\n\000".
# msgstr2 (in Native Character Set)
"ʲΥ򥤥󥹥ȡ뤷Ƥ\n" ,

# msgid
"(Edit /etc/locale.gen and invoke locale-gen)\n" =>
# msgstr1 (ASCII)
"(/etc/locale.gen WO HENSYUU SHITE, locale-gen WO JIKKOU SURU.)\n\000".
# msgstr2 (in Native Character Set)
"(/etc/locale.gen Խlocale-gen ¹Ԥ)\n" ,

# msgid
"" =>
# msgstr1 (ASCII)
"\000".
# msgstr2 (in Native Character Set)
""

);

$yes_upper = "Y";
$yes_lower = "y";
$no_upper = "N";
$no_lower = "n";
$need_locale = "ja_JP.eucJP(ja_JP.EUC-JP!EUC-JP)";
