#! /bin/bash

test -f /usr/sbin/laptop_mode || exit 0

# Automatically disable laptop mode when the battery almost runs out.

BATT_INFO=/proc/acpi/battery/$2/state

MINIMUM_BATTERY_MINUTES=7
ACPI_WITHOUT_AC_EVENTS=0

if [ -f /etc/laptop-mode/laptop-mode.conf ] ; then
	. /etc/laptop-mode/laptop-mode.conf
fi

if [ $ACPI_WITHOUT_AC_EVENTS -ne 0 ] ; then
	/etc/acpi/actions/lm_ac_adapter.sh
fi

if [[ -f /proc/sys/vm/laptop_mode ]]
then
   LM=`cat /proc/sys/vm/laptop_mode`
   if [[ $LM -gt 0 ]]
   then
     if [[ -f $BATT_INFO ]]
     then
        ACTION="`cat $BATT_INFO | grep charging | cut -c 26-`"
        if [[ ACTION -eq "discharging" ]]
        then
		PRESENT_RATE=`cat $BATT_INFO | grep "present rate:" | sed  "s/.* \([0-9][0-9]* \).*/\1/" `
		REMAINING=`cat $BATT_INFO | grep "remaining capacity:" | sed  "s/.* \([0-9][0-9]* \).*/\1/" `
		if [[ $PRESENT_RATE -ne 0 ]] ; then
			if (($REMAINING * 60 / $PRESENT_RATE < $MINIMUM_BATTERY_MINUTES))
			then
				/usr/sbin/laptop_mode stop
			fi
		fi
	fi
     else
        logger -p daemon.warning "You are using laptop mode and your battery interface $BATT_INFO is missing. This may lead to loss of data when the battery runs out. Check kernel ACPI support and /proc/acpi/battery folder, and edit /etc/acpi/lm_battery.sh to set BATT_INFO to the correct path."
     fi
   fi
fi
