#! /bin/bash

# If your distribution puts this in other locations, please adjust the values of
# these variables before installing!
INIT_D=/etc/init.d
MAN_D=/usr/local/man/man8

if [ "`whoami`" != "root" ] ; then
	echo "You need to be root to install the laptop mode tools."
	exit 10
fi

if [ ! -f /proc/sys/vm/laptop_mode ] ; then
	echo "Warning: the kernel you are running does not support laptop mode."
fi

INSTALL="install -o root -g root"

mkdir -p /etc/laptop-mode

if [ -f /etc/laptop-mode/laptop-mode.conf ] ; then
	echo "Not reinstalling configuration file: /etc/laptop-mode/laptop-mode.conf exists."
elif ( ! $INSTALL -m 600 etc/laptop-mode/laptop-mode.conf /etc/laptop-mode ) ; then
	echo "$0: Failed to install configuration file in /etc/laptop-mode/laptop-mode.conf. Installation failed."
	exit 12
fi

if [ -f /etc/default/laptop-mode ] ; then
        echo "Found old configuration file in /etc/default/laptop-mode. Moving to the new location."
	if ( ! mv /etc/default/laptop-mode /etc/laptop-mode/laptop-mode.conf ) ; then
		echo "$0: Failed to move old configuration file to new location."
		exit 20
	fi
fi
if [ -f /etc/sysconfig/laptop-mode ] ; then
        echo "Found old configuration file in /etc/sysconfig/laptop-mode. Moving to the new location."
	if ( ! mv /etc/sysconfig/laptop-mode /etc/laptop-mode/laptop-mode.conf ) ; then
		echo "$0: Failed to move old configuration file to new location."
		exit 21
	fi
fi

if ( ! $INSTALL -m 700 usr/sbin/laptop_mode /usr/sbin ) ; then
	echo "$0: Failed to install /usr/sbin/laptop_mode. Installation failed."
	exit 11
fi

if ( ! $INSTALL -m 700 usr/sbin/lm-syslog-setup /usr/sbin ) ; then
	echo "$0: Failed to install /usr/sbin/lm-syslog-setup. installation failed."
	exit 25
fi

ACPI_DONE=0
if [ -d /etc/acpi ] ; then
	mkdir -p /etc/acpi/actions
	mkdir -p /etc/acpi/events
	
	# Remove the old action scripts, but not the olddd event files. Apparently, Gentoo handles
	# its speedfreq using /etc/acpi/events/battery, and we were using that too. Simply removing
	# the scripts and leaving the event files will hopefully cause acpid to notice that the
	# files don't exist and leave it at that.
	rm -f /etc/acpi/actions/battery.sh /etc/acpi/actions/ac.sh
	
	if ( ! $INSTALL -m 700 etc/acpi/actions/* /etc/acpi/actions ) ; then
		echo "$0: Failed to install ACPI action scripts in /etc/acpi/actions. Installation failed."
		exit 13
	fi
	if ( ! $INSTALL -m 600 etc/acpi/events/* /etc/acpi/events ) ; then
		echo "$0: Failed to install ACPI event file in /etc/acpi/events. Installation failed."
		exit 14
	fi
	echo "Installed ACPI support."
	ACPI_DONE=1
fi

APM_DONE=0
if [ -d /etc/apm ] ; then
	mkdir -p /etc/apm/event.d
	if ( ! $INSTALL -m 700 etc/apm/event.d/* /etc/apm/event.d ) ; then
		echo "$0: Failed to install APM event script in /etc/apm/event.d. Installation failed."
		exit 15
	fi
	echo "Installed APM support."
	APM_DONE=1
fi

if [ $APM_DONE -eq 0 -a $ACPI_DONE -eq 0 ] ; then
	echo "Neither APM nor ACPI daemons were found. Laptop mode will not start automatically."
	echo "Install either acpid or apmd (depending on what your laptop supports) and reinstall."
fi

if [ -d $INIT_D ] ; then
  if ( ! $INSTALL -m 700 etc/init.d/laptop-mode $INIT_D ) ; then
    echo "$0: failed to install init script in $INIT_D. Installation failed."
    exit 16
  fi
  if [ -f /etc/rcS.d/S99laptop_mode ] ; then    
    # Old symlink.
    rm $RCS_D/S99laptop-mode
  fi
  if [ -e "`which update-rc.d`" ] ; then
    if ( ! update-rc.d laptop-mode defaults ) ; then
      echo "$0: update-rc.d failed, laptop mode will not be initialized at bootup."
      exit 17
    fi
  elif [ -e "`which chkconfig`" ] ; then
    if ( ! chkconfig laptop-mode on ) ; then
      echo "$0: chkconfig failed, laptop mode will not be initialized at bootup."
      exit 30
    fi
  fi
else
  echo "Directory $INIT_D not found: not installing script to initialize"
  echo "laptop mode at boot time."
fi

if ( ! mkdir -p $MAN_D ) ; then
  echo "$0: Could not create directory $MAN_D. Installation failed."
  exit 22
fi
if ( ! cp man/* $MAN_D ) ; then
  echo "$0: Could not copy manual pages to $MAN_D. Installation failed."
  exit 23
fi

if [ -e "`which invoke-rc.d`" ] ; then
	# Debian uses invoke-rc.d
	RCPROG=invoke-rc.d
	INITSCRIPT=laptop-mode
elif [ -e "`which service`" ] ; then
	# RedHat uses service
	RCPROG=service
	INITSCRIPT=laptop-mode
else
	# Any other -- we start it ourselves.
	RCPROG=
	INITSCRIPT=/etc/init.d/laptop-mode
fi

if ( ! $RCPROG $INITSCRIPT start ) ; then
	echo "$0: Could not start laptop mode init script /etc/init.d/laptop-mode."
	exit 24
fi

echo "Installation complete."
