/* -*-C-*-

$Id: utils.c,v 1.1 2003/06/12 05:30:49 cph Exp $

Copyright 2000,2001,2002,2003 Massachusetts Institute of Technology

This file is part of autonet.

Autonet is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Autonet is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with autonet; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <syslog.h>
#include <sys/types.h>

#include "utils.h"

void
run_in_background (const char * pid_file)
{
  pid_t pid = (fork ());
  if (pid < 0)
    {
      syslog ((LOG_DAEMON | LOG_INFO), "Unable to start child process: %s",
	      (strerror (errno)));
      exit (1);
    }
  else if (pid > 0)
    {
      if (pid_file != 0)
	{
	  FILE * s = (fopen (pid_file, "w"));
	  if (s == 0)
	    syslog ((LOG_DAEMON | LOG_INFO), "Unable to open PID file: %s",
		    (strerror (errno)));
	  else
	    {
	      fprintf (s, "%d\n", pid);
	      fclose (s);
	      syslog ((LOG_DAEMON | LOG_INFO), "PID file written: %s",
		      pid_file);
	    }
	}
      exit (0);
    }
  close (0);
  close (1);
  close (2);
  setsid ();
}

void *
xmalloc (unsigned long n_bytes)
{
  void * p = (malloc (n_bytes));
  if (p == 0)
    {
      syslog (LOG_DEBUG, "Unable to allocate %lu bytes.\n", n_bytes);
      exit (1);
    }
  return (p);
}

void *
xrealloc (void * p1, unsigned long n_bytes)
{
  void * p2 = (realloc (p1, n_bytes));
  if (p2 == 0)
    {
      syslog (LOG_DEBUG, "Unable to reallocate %lu bytes.\n", n_bytes);
      exit (1);
    }
  return (p2);
}

char *
copy_string (const char * string)
{
  char * result = (xmalloc ((strlen (string)) + 1));
  strcpy (result, string);
  return (result);
}

void
log_perror (const char * string)
{
  syslog (LOG_DEBUG, "%s: %s", string, (strerror (errno)));
}

void
log_error (const char * string)
{
  syslog (LOG_DEBUG, "%s", string);
}
