#!/usr/bin/perl

### Copyrihgt (C) 2004,2005 Dohyun Kim <nomosnomos at gmail.com>
###
### -------------------------------------------------------------------
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###   
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
### -------------------------------------------------------------------
###
### TODO: how to distinguish malformed utf8 string in IND file?
###
### 2004/12/28 initial release
### 2004/12/30 added some $ist_* variables, including $ist_actual
### 2005/01/06 adjust to PrerenderUnicode hacking by Karnes
### 2005/01/22 dhucs 1.5
### 2005/02/01 minor bug fix.
### 2005/02/22 minor bug fix.
### 2005/07/04 allow break before oparen.

use 5.8.0;
use strict;
use Getopt::Std;
use utf8;

#@ARGV == 0 and die "
#makeindex wapper script for dhucs (a.k.a. hangul-ucs) package.
#Usage: $0 [makeindex options]\n
#";

@ARGV == 0 and die "
No .idx file specified.\n
makeindex wrapper script for dhucs (a.k.a. hangul-ucs) package. v2.1\n
  Copyright (C) 2005 Dohyun Kim\n
This is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.\n
Usage: $0 [makeindex options] idx_filename\n
";

print "
This is makeindex-dhucs, a makeindex wrapper for dhucs. version 2.1\n
";

###
### Many thanks to Jinsuk Kim, http://www.jinsuk.pe.kr
###
my( @hanja_to_hangul,
    @hanjacompat_to_hangul,
    @hanjaextA_to_hangul
    );
&initialize_var;

###
### parse options
###
my (%args,
    @IDXfiles, 
    $istfile, 
    $indfile, 
    $logfile, 
    $idx0
    );
getopts('cgilo:p:qrs:t:LT',\%args);
@IDXfiles = @ARGV or die "idx file is not defined!\n";

if($args{s}) {
    $istfile = $args{s};
    $istfile =~ s/(\.ist)?$/\.ist/;
}

$idx0 = $IDXfiles[0];
$idx0 =~s/\.idx$//;

$indfile = $args{o} || $idx0;
$indfile =~ /(\..+?)$/ or $indfile .= ".ind";

$logfile = $args{t} || $idx0;
$logfile =~ /(\..+?)$/ or $logfile .= ".ilg";

foreach my $file (@IDXfiles) {
    $file =~ /(\..+?)$/ or $file .= ".idx";
}

###
### read .ist file
###
my $ist_heading_flag = 0;
my $ist_heading_prefix = '';
my $ist_heading_suffix = '';
my $ist_group_skip = '\indexspace';
my $ist_item_0 = '\item ';
my $ist_delim_0 = ', ';
my $ist_keyword = '\indexentry';
my $ist_actual = '@';
my $ist_encap = '|';
my $ist_level = '!';
my $ist_quote = '"';
my $ist_arg_open = '{';
my $ist_arg_close = '}';

if($istfile) {
    $istfile = `kpsewhich $istfile`;
    chomp $istfile;
    open IST,"<:utf8",$istfile or die "$args{s} : $!\n";
    while (<IST>) {
        s/\%.*//;
        s/\\n\b//g;
        s/\\\\/\\/g;
        if(/headings_flag\s+(.+)/){ $ist_heading_flag=$1; }
        elsif(/heading_prefix\s+"(.*)"/){ $ist_heading_prefix=$1; }
        elsif(/heading_suffix\s+"(.*)"/){ $ist_heading_suffix=$1; }
        elsif(/group_skip\s+"(.*)"/){ $ist_group_skip=$1; }
        elsif(/item_0\s+"(.*)"/){ $ist_item_0=$1; }
        elsif(/delim_0\s+"(.*)"/){ $ist_delim_0=$1; }
        elsif(/keyword\s+"(.*)"/){ $ist_keyword=$1; }
        elsif(/actual\s+'(.*)'/){ $ist_actual=$1; }
        elsif(/encap\s+'(.*)'/){ $ist_encap=$1; }
        elsif(/level\s+'(.*)'/){ $ist_level=$1; }
        elsif(/quote\s+'(.*)'/){ $ist_quote=$1; }
        elsif(/arg_open\s+'(.*)'/){ $ist_arg_open=$1; }
        elsif(/arg_close\s+'(.*)'/){ $ist_arg_close=$1; }
    }
    close IST;
}

# prepare to run makeindex
my $makeindexoption = "-i -o $indfile -t $logfile";
foreach ('c','l','q','r','L','g','T') {
    $makeindexoption .= " -$_" if $args{$_};
}
$makeindexoption .= " -s $istfile" if $args{s};
$makeindexoption .= " -p $args{p}" if $args{p};

###
### read .idx files
###
my (@idxarr,
    %idxhash
    );
foreach my $file(@IDXfiles) {
    open IDX,"<:utf8",$file or die "$file : $!\n";
    while (<IDX>) {
        s/\\BreakBeforeAsciiOParen\s*\{\d*?\}//g;
        s/\^\^([0-9a-f]{2})/pack "U0C", hex $1/ge;
        s/\\unihangulchar\s*\{(\d+)\}/chr $1/ge;
        s/\\unichar\s*\{(\d+)\}/chr $1/ge;
        s/\\begingroup\s*\\let\s*\\relax\s*\\relax\s*\\endgroup\s*//g;
        s/\?\?\\dhucsPrerenderUnicode\s*\{(.*?)\}/$1/g;
        if (/\Q$ist_keyword\E\s*\Q$ist_arg_open\E 
            (.*?[^\Q$ist_quote\E])
            (\Q$ist_arg_close$ist_arg_open\E.+\Q$ist_arg_close\E)
            $/x) {
            my($c,$post) = ($1,$2);
            my @cex = split /(?<!\Q$ist_quote\E)\Q$ist_encap/,$c;
            for(my $i=$#cex; $i>0; $i--) {
                $post = $ist_encap.$cex[$i].$post;
            }
            my @cex = split /(?<!\Q$ist_quote\E)\Q$ist_level/,$cex[0];
            for (@cex) {
                if(/[^\Q$ist_quote\E]\Q$ist_actual/) {
                    s{(.*[^\Q$ist_quote\E])\Q$ist_actual\E(.+)}
                        {hanja_to_hangul($1).$ist_actual.$2}e;
                }
                elsif(/^[\x{80}-\x{FFFF}]/) {
                    s/(.+)/hanja_to_hangul($1).$ist_actual.$1/e;
                }
                s/^([\x{80}-\x{33FF}\x{FB00}-\x{FFFF}])/symbolize_first($1)/e;
                if(/(.*[^\Q$ist_quote\E])\Q$ist_actual\E(.+)/) {# and
                    $idxhash{$2} = $1; # for grouping routine
                }
            }
            $c = join $ist_level,@cex;
            push @idxarr,"$ist_keyword$ist_arg_open$c$post\n";
        } 
    }
    close IDX;
}

###
### run makeindex
###
open(MAKE,"| makeindex $makeindexoption") or die "Cannot fork: $!\n";
binmode MAKE,":utf8";
print MAKE @idxarr;
close MAKE;
$? >> 8 and die "\nmakeindex failed!\n";

###
### read .ind file and grouping hangul items
###
my @indarr;
my $cho = -1;
open IND,"<:utf8",$indfile or die "$indfile : $!\n";
while(<IND>) {
    if($ist_heading_flag and /\Q$ist_heading_prefix\E/) {
        push @indarr,$_ if
        /\Q$ist_heading_prefix\E.+?\Q$ist_heading_suffix\E/; 
    }
    elsif(/\Q$ist_group_skip\E/) {
        push @indarr,$_ if $cho < 0;
    }
    elsif(/\Q$ist_item_0\E(.+?)(\Q$ist_delim_0\E|$)/) {
        if($idxhash{$1} =~ /^([\x{AC00}-\x{D7A3}])/) {
            my $first = int((ord($1) - 0xac00) / (21 * 28));
            if($first != $cho) {
                my $tmp = '';
                $tmp .= "\n\n$ist_group_skip\n" if $cho >= 0;
                $tmp .= $ist_heading_prefix."\\hindexhead{$first}".
                        $ist_heading_suffix."\n\n"
                    if($ist_heading_flag);
                $tmp .= $_;
                push @indarr,$tmp;
                $cho = $first;
            }
            else {
                push @indarr,$_;
            }
        }
        else {
            push @indarr,$_;
        }
    }
    else {
        push @indarr,$_;
    }
}
close IND;

open IND,">:utf8",$indfile or die "$indfile : $!\n";
print IND @indarr;
close IND;

########## SUBROUTINES ##########

sub symbolize_first {
    my $first = shift;
    my $symfirst = '';
    for(unpack("U0C*", $first)) {
        $symfirst .= sprintf "^^%02x",$_;
    }
    return $symfirst;
}

sub hanja_to_hangul {
    my $hj = shift;
    $hj =~ s/([\x{3400}-\x{4DB5}])/chr $hanjaextA_to_hangul[ord($1)-0x3400]/ge;
    $hj =~ s/([\x{4E00}-\x{9FA5}])/chr $hanja_to_hangul[ord($1)-0x4E00]/ge;
    $hj =~ s/([\x{F900}-\x{FA2D}])/chr $hanjacompat_to_hangul[ord($1)-0xF900]/ge;
    return $hj;
}

sub initialize_var {
    ### thanks to Jinsuk Kim, http://www.jinsuk.pe.kr
    @hanja_to_hangul = (
    # 0x4E00 #
    0xC77C,0xC815,0xAD50,0xCE60,0xC0C1,0xD558,0xBA74,0xB9CC,
    0xC7A5,0xC0BC,0xC0C1,0xD558,0xAE30,0xBD80,0xC5EC,0xBA74,
    0xAC1C,0xCD95,0xCD95,0xC804,0xCC28,0xBE44,0xC138,0xC138,
    0xAD6C,0xBCD1,0xC5C5,0xCD1D,0xB3D9,0xC0AC,0xC2B9,0xC8FC,
    0xAD6C,0xB7C9,0xC8FC,0xC720,0xB7C9,0xC5C4,0xBCD1,0xC0C1,
    0xACE4,0xAD6C,0xAC1C,0xC544,0xC7A5,0xC911,0xADF9,0xAC1C,
    0xBD09,0xAD00,0xACF6,0xCC2C,0xC784,0xCC29,0xC8FC,0xD558,
    0xD658,0xB2E8,0xC704,0xC8FC,0xC815,0xB824,0xAC70,0xBCC4,
    0xBD88,0xC774,0xC608,0xB0B4,0xC624,0xAD6C,0xAD6C,0xD0C1,
    0xC694,0xC758,0xD638,0xC9C0,0xC624,0xC0AC,0xD638,0xD54D,
    0xC545,0xC74C,0xBCD1,0xD401,0xAD50,0xD638,0xAD34,0xC2B9,
    0xC2B9,0xC744,0xC740,0xC57C,0xBA00,0xAD6C,0xAC78,0xC57C,
    0xC2B5,0xD5A5,0xAC1C,0xADDC,0xD560,0xD640,0xC11C,0xB458,
    0xC2DC,0xACC4,0xB0AD,0xAC08,0xAC78,0xB3CC,0xBB20,0xC62C,
    0xB9E4,0xB780,0xCC30,0xC720,0xC124,0xC5FC,0xBCFC,0xC0B4,
    0xB098,0xAC74,0xC194,0xC5BC,0xC904,0xC798,0xAC74,0xCE58,
    # 0x4E80 #
    0xAD6C,0xAC74,0xB780,0xB9B0,0xC758,0xAD90,0xB8CC,0xB9C8,
    0xC5EC,0xC7C1,0xC0AC,0xC0AC,0xC774,0xCD09,0xC6B0,0xC6B0,
    0xC6B8,0xC6B4,0xD638,0xAE30,0xC624,0xC815,0xC0AC,0xC138,
    0xAE0D,0xAE0D,0xC544,0xC0AC,0xC544,0xC81C,0xC544,0xADF9,
    0xB450,0xB9DD,0xD56D,0xB300,0xAD50,0xD574,0xC5ED,0xC0B0,
    0xD615,0xBB34,0xB780,0xD5A5,0xACBD,0xC815,0xB7C9,0xD5A5,
    0xACBD,0xC57C,0xCE5C,0xBC15,0xC6B0,0xC124,0xB2E8,0xB834,
    0xD0C0,0xBBF8,0xC778,0xC778,0xC9D1,0xB77C,0xB9DD,0xC5B5,
    0xC2ED,0xC778,0xB975,0xC815,0xCE21,0xBD80,0xBD80,0xAD6C,
    0xD314,0xC7A5,0xAE08,0xAC1C,0xBE59,0xC789,0xC885,0xBD88,
    0xC0B0,0xB95C,0xC5B4,0xCC3D,0xC790,0xC0AC,0xD0C0,0xC7A5,
    0xBD80,0xC120,0xD5CC,0xD0C1,0xD64D,0xB3D9,0xC778,0xCC9C,
    0xD55C,0xD758,0xC791,0xB300,0xB839,0xC774,0xCD08,0xC7A5,
    0xC0BC,0xC0C1,0xC758,0xBB34,0xBB38,0xC778,0xAC00,0xCD08,
    0xC559,0xAC80,0xC911,0xBE44,0xC6D4,0xC624,0xAC74,0xAC1C,
    0xC694,0xBD09,0xCC3D,0xC784,0xC655,0xBE48,0xC800,0xBC29,
    # 0x4F00 #
    0xC885,0xAE30,0xD328,0xC5EC,0xC870,0xB3C8,0xBB38,0xC5ED,
    0xC2EC,0xD56D,0xC774,0xAE09,0xC560,0xC624,0xAE30,0xBCF5,
    0xBC8C,0xD734,0xADFC,0xBC30,0xCE68,0xBD80,0xB178,0xC911,
    0xC6B0,0xD654,0xD68C,0xAD6C,0xC26C,0xC804,0xC0B0,0xC704,
    0xC804,0xAC70,0xC544,0xD604,0xC0C1,0xCC3D,0xB95C,0xCC3D,
    0xC21C,0xC2E0,0xC704,0xC800,0xD0DD,0xD604,0xB178,0xBC31,
    0xACE0,0xB2C8,0xD0C1,0xC124,0xBC18,0xD601,0xB839,0xC8FC,
    0xC2E0,0xC800,0xC0AC,0xD33D,0xC0AC,0xAC00,0xBE44,0xC774,
    0xC0AC,0xC774,0xC815,0xC804,0xAC10,0xB9E4,0xB2E8,0xC800,
    0xD3EC,0xAD6C,0xD53C,0xC18C,0xCC28,0xC704,0xC800,0xC8FC,
    0xC88C,0xC6B0,0xC559,0xBD84,0xC810,0xD558,0xD544,0xD0C0,
    0xC0AC,0xC5EC,0xC77C,0xBD88,0xC791,0xAD6C,0xB155,0xD241,
    0xB2C8,0xD5CC,0xAC70,0xC6A9,0xC640,0xCCA8,0xC11D,0xCE74,
    0xD3EC,0xD328,0xD68C,0xAC01,0xB8CC,0xD56D,0xD569,0xC591,
    0xBC31,0xBC95,0xBA85,0xAC00,0xC774,0xBCD1,0xAE38,0xD55C,
    0xAD04,0xADA4,0xC804,0xC870,0xAD50,0xCC28,0xC77C,0xC0AC,
    # 0x4F80 #
    0xD615,0xC2E0,0xD0C1,0xAC04,0xC9C8,0xD574,0xB798,0xC774,
    0xCE58,0xACFC,0xAD11,0xB840,0xC74C,0xC2DC,0xBBF8,0xC8FC,
    0xD601,0xC720,0xC548,0xB960,0xBAA8,0xC774,0xB95C,0xB3D9,
    0xCC28,0xCE59,0xC21C,0xACF5,0xC8FC,0xC758,0xC5EC,0xCC9C,
    0xD611,0xAC00,0xC7AC,0xB824,0xACE0,0xC694,0xC815,0xCE21,
    0xAD50,0xCF8C,0xC81C,0xB155,0xB18D,0xC9C4,0xBAA8,0xD6C4,
    0xAD70,0xC815,0xC9C4,0xC88C,0xCD94,0xCE68,0xB824,0xAD6D,
    0xB450,0xC815,0xC2EC,0xD0C8,0xBC1C,0xB0A8,0xD6A8,0xD3B8,
    0xD1F4,0xC6B0,0xACC4,0xCD09,0xC544,0xAD6C,0xC11C,0xAD11,
    0xACE1,0xC624,0xC900,0xC74D,0xBCF4,0xB7C9,0xC870,0xC18C,
    0xB9AC,0xC6A9,0xD754,0xACBD,0xD604,0xC0BC,0xBC30,0xC18D,
    0xBD80,0xD76C,0xB9AC,0xBA74,0xBE59,0xBCF4,0xC720,0xC0AC,
    0xD611,0xC2E0,0xC218,0xC624,0xC81C,0xAC70,0xC8FC,0xC9C0,
    0xC5C4,0xB7C9,0xB824,0xB798,0xB9AC,0xAC80,0xC218,0xBD80,
    0xD654,0xAD6C,0xD6A8,0xBC30,0xCC9C,0xD45C,0xC219,0xBE44,
    0xBD09,0xC544,0xC5C4,0xBE44,0xC8FD,0xD754,0xBE44,0xCE58,
    # 0x5000 #
    0xCC3D,0xC9C0,0xBCD1,0xAD6C,0xD6A8,0xC26C,0xB7C9,0xC6D0,
    0xB798,0xCC3D,0xC885,0xAC1C,0xAD00,0xBC30,0xC804,0xC219,
    0xC219,0xBB38,0xB3C4,0xB2F4,0xAD74,0xC218,0xD589,0xBD95,
    0xB2F9,0xD6C4,0xC758,0xAE30,0xCC99,0xAC04,0xACBD,0xCC28,
    0xD734,0xCC3D,0xCCA9,0xBC29,0xCE58,0xACF5,0xAD8C,0xC885,
    0xAC70,0xCC9C,0xC608,0xB95C,0xD0C1,0xC65C,0xB77C,0xC1A1,
    0xB989,0xD63C,0xB3D9,0xC0AC,0xBD84,0xBB34,0xAD6C,0xB2C8,
    0xCC44,0xAC80,0xCC44,0xC57C,0xCE58,0xC0AC,0xACBD,0xCCA9,
    0xC601,0xCE6D,0xC804,0xC5B8,0xB09C,0xB3D9,0xC900,0xAC00,
    0xAC8C,0xC704,0xC6B0,0xBCD1,0xC57C,0xC81C,0xC678,0xD3B8,
    0xC548,0xD48D,0xD0D5,0xC545,0xC545,0xD574,0xCC28,0xC131,
    0xAC04,0xC81C,0xC8FC,0xC0BD,0xC815,0xBC30,0xC5FD,0xD669,
    0xC694,0xB2F4,0xCD08,0xC5FC,0xC720,0xAC74,0xC11C,0xCC28,
    0xCC28,0xBD80,0xD54D,0xCE58,0xCD1D,0xBA74,0xC9D1,0xC758,
    0xC124,0xC21C,0xC2DC,0xB2E8,0xCE21,0xC815,0xC6B0,0xD22C,
    0xD22C,0xBE44,0xCC30,0xB8E8,0xCCA9,0xC704,0xBD84,0xC0C1,
    # 0x5080 #
    0xAD34,0xC218,0xCE58,0xC18C,0xD560,0xBD80,0xC6D0,0xC6A9,
    0xB960,0xB179,0xC6D0,0xAC15,0xB9C8,0xBC29,0xC804,0xB2F9,
    0xD638,0xAC78,0xD61C,0xC120,0xACB8,0xAC01,0xCC3D,0xCD95,
    0xC0B0,0xBE44,0xD6A8,0xC6A9,0xC694,0xD0D1,0xC0AC,0xC559,
    0xBC8C,0xBCD1,0xAC00,0xD0DC,0xC7AC,0xB2F9,0xACE8,0xBE48,
    0xC800,0xB098,0xCC38,0xB8B0,0xCD5C,0xC6A9,0xC870,0xCD1D,
    0xBD95,0xC885,0xC624,0xC804,0xAD6C,0xCC44,0xCC99,0xC0C1,
    0xC0C1,0xACBD,0xC81C,0xC0AC,0xD55C,0xC7A5,0xACBD,0xC5B8,
    0xC81C,0xC124,0xB8E8,0xBE44,0xD45C,0xADFC,0xB828,0xB959,
    0xB9CC,0xCCA8,0xC120,0xD0D0,0xC6C5,0xB3D9,0xC120,0xC0C1,
    0xC120,0xAD50,0xAD70,0xD1F4,0xC900,0xBCF5,0xD76C,0xB85C,
    0xCC3D,0xAD11,0xB8CC,0xAE30,0xB4F1,0xC794,0xC704,0xAE30,
    0xBC88,0xD61C,0xCC9C,0xCC38,0xD0C4,0xC694,0xCD94,0xC2B9,
    0xBD84,0xD55C,0xACB0,0xC545,0xCD08,0xCC38,0xB3D9,0xB9B0,
    0xBD81,0xACE0,0xC120,0xC18D,0xD55C,0xAC15,0xBBFC,0xC5FD,
    0xAE08,0xAC00,0xCD08,0xBCBD,0xD48D,0xCD94,0xC560,0xC0AC,
    # 0x5100 #
    0xC758,0xC900,0xB18D,0xCC9C,0xC5B5,0xB2F9,0xACBD,0xD604,
    0xCF8C,0xAC80,0xCD08,0xB2F4,0xAD50,0xC0AC,0xC7AC,0xCC2C,
    0xBE48,0xC555,0xC720,0xB300,0xC8FC,0xC81C,0xB78C,0xC758,
    0xC9C4,0xACAC,0xB9F9,0xBB34,0xB155,0xACBD,0xC774,0xC0C1,
    0xB835,0xB8B0,0xB824,0xAD11,0xD3EC,0xC721,0xD45C,0xCC2C,
    0xC9C8,0xC0AC,0xC6B0,0xD638,0xCE5C,0xCE24,0xB825,0xB4F1,
    0xC704,0xB871,0xC800,0xCC38,0xC219,0xC219,0xD734,0xB824,
    0xB77C,0xCC2C,0xB098,0xB2F9,0xC5C4,0xB798,0xB0AD,0xC778,
    0xC62C,0xC724,0xC7A0,0xC6D0,0xD615,0xCDA9,0xC870,0xD749,
    0xC120,0xAD11,0xD0DC,0xADF9,0xD0DC,0xBA74,0xD1A0,0xC7A5,
    0xC544,0xD0DC,0xC544,0xCE68,0xD1A0,0xC2DC,0xC5F0,0xC5F0,
    0xC2DC,0xC2ED,0xB2F9,0xCC9C,0xB450,0xBD84,0xBAA8,0xC2E0,
    0xB450,0xBC31,0xAE0D,0xB9AC,0xD669,0xC785,0xB9DD,0xB0B4,
    0xC804,0xB7C9,0xC720,0xD314,0xACF5,0xB959,0xD61C,0xD55C,
    0xB780,0xACF5,0xCC9C,0xC18C,0xD765,0xBCD1,0xAE30,0xAD6C,
    0xC804,0xC790,0xBFD0,0xC591,0xACB8,0xC218,0xAE30,0xC608,
    # 0x5180 #
    0xAE30,0xCC9C,0xACBD,0xBAA8,0xC5FC,0xB0B4,0xC5D4,0xBB18,
    0xAC15,0xC5FC,0xCC45,0xACBD,0xCC45,0xC7AC,0xACFC,0xACBD,
    0xBAA8,0xC8FC,0xBAA8,0xAD6C,0xD6C4,0xBA74,0xBA71,0xC6A9,
    0xC720,0xC0AC,0xAC10,0xAD70,0xB18D,0xC758,0xBBF8,0xC11D,
    0xAD00,0xBABD,0xCD1D,0xCDE8,0xC6D0,0xBA85,0xAD6C,0xB9BC,
    0xBD80,0xC0AC,0xBA71,0xBE59,0xB3D9,0xD0DC,0xAC15,0xD48D,
    0xBE59,0xD638,0xCDA9,0xACB0,0xD638,0xD669,0xC57C,0xB7AD,
    0xBC18,0xBD88,0xBBFC,0xB3D9,0xC2B9,0xB82C,0xD611,0xCCA8,
    0xC815,0xC218,0xB9E4,0xB3C4,0xCC98,0xACE0,0xC900,0xC1A1,
    0xC815,0xB7C9,0xCCAD,0xC870,0xB989,0xB3D9,0xAE08,0xAC10,
    0xC778,0xC8FC,0xC758,0xB960,0xCC3D,0xBA85,0xC900,0xCD5C,
    0xC2DC,0xD0C1,0xAE08,0xB984,0xB984,0xC751,0xD76C,0xB3C5,
    0xADA4,0xBC94,0xBC94,0xBC94,0xBD09,0xAC70,0xCC98,0xADA4,
    0xD48D,0xBAA9,0xC9C0,0xBD80,0xD48D,0xBE59,0xD48D,0xAC1C,
    0xD669,0xAC1C,0xAC10,0xB4F1,0xBE59,0xAC10,0xD749,0xAD34,
    0xCCA0,0xC694,0xCD9C,0xACA9,0xB2F9,0xD568,0xD568,0xCC29,
    # 0x5200 #
    0xB3C4,0xC870,0xB3C4,0xC778,0xC778,0xCC3D,0xBD84,0xC808,
    0xC608,0xAE30,0xAC04,0xCC9C,0xCD0C,0xCD94,0xBB38,0xAE30,
    0xB2E8,0xD615,0xD654,0xC644,0xACB0,0xB9AC,0xC6D4,0xB82C,
    0xB958,0xCE59,0xAC15,0xCC3D,0xBD88,0xCD08,0xCC98,0xC870,
    0xC0B0,0xBBFC,0xB839,0xC885,0xD310,0xBCC4,0xAC81,0xAC81,
    0xD3EC,0xB9AC,0xC0B0,0xBCC4,0xC794,0xACBD,0xAD04,0xAE0D,
    0xB3C4,0xCC3D,0xADDC,0xACE0,0xD0C0,0xC774,0xC81C,0xC1C4,
    0xAD8C,0xCC30,0xC790,0xAC01,0xAC81,0xD68C,0xC790,0xADC0,
    0xAC1C,0xD0C0,0xC81C,0xCCB4,0xACBD,0xB450,0xB77C,0xCE59,
    0xC5F0,0xC88C,0xC0AD,0xADF9,0xB784,0xC804,0xCC30,0xCC3D,
    0xACFC,0xAC80,0xCC29,0xB9AC,0xCC99,0xBE44,0xBD80,0xC794,
    0xAE30,0xCC3D,0xC0AC,0xAC15,0xC644,0xBC15,0xAE30,0xCCA0,
    0xACBD,0xC12C,0xD0C1,0xAC80,0xC81C,0xBC15,0xC5C4,0xADF9,
    0xAD35,0xC789,0xC804,0xD0C1,0xB2E8,0xC625,0xACFC,0xBD80,
    0xC789,0xAC80,0xD560,0xB2F5,0xAC1C,0xCC3D,0xCC9C,0xC0B0,
    0xC804,0xB959,0xB9AC,0xBD80,0xC0BC,0xD45C,0xAD6C,0xCD08,
    # 0x5280 #
    0xAD04,0xCD08,0xADA4,0xD68D,0xCC28,0xD0C1,0xB834,0xADF9,
    0xBCBD,0xB958,0xD68C,0xCD08,0xADC0,0xAC80,0xAC80,0xB2F9,
    0xD655,0xC81C,0xAC80,0xC758,0xAC80,0xC9C8,0xCC38,0xCC2C,
    0xB9C8,0xB9AC,0xCD09,0xB825,0xC54C,0xAD8C,0xD310,0xACF5,
    0xAC00,0xBB34,0xB9E4,0xB82C,0xADFC,0xAC31,0xD611,0xC9C0,
    0xB3D9,0xC870,0xB178,0xAC81,0xAD6C,0xCD08,0xC77C,0xC800,
    0xB9C9,0xB824,0xACBD,0xB85C,0xB85C,0xAD8C,0xAD6C,0xC591,
    0xC65C,0xD6A8,0xBB34,0xAD11,0xD560,0xB82C,0xD575,0xD575,
    0xADF9,0xACBD,0xACE0,0xBC1C,0xBBFC,0xCE59,0xB791,0xC6A9,
    0xC6A9,0xBA74,0xADF9,0xD6C8,0xAD8C,0xACBD,0xB959,0xBD80,
    0xB9F9,0xB798,0xB975,0xAC1C,0xBA74,0xB3D9,0xC6B1,0xC6B1,
    0xAC10,0xBB34,0xC608,0xD6C8,0xC639,0xC2B9,0xB85C,0xBAA8,
    0xB959,0xD45C,0xC138,0xC801,0xADFC,0xAC15,0xCD08,0xAD8C,
    0xC591,0xC608,0xAC39,0xBC88,0xAD8C,0xB3D9,0xAC70,0xB2E8,
    0xD611,0xB9E4,0xD6C8,0xD6C8,0xB824,0xB824,0xCCA0,0xC591,
    0xAD8C,0xD3EC,0xC791,0xADE0,0xAD6C,0xBB38,0xAD6C,0xBB3C,
    # 0x5300 #
    0xADE0,0xBB38,0xB0B4,0xAC1C,0xAC1C,0xD3EC,0xCD1D,0xC11D,
    0xD749,0xD3C9,0xAD6D,0xB3C4,0xD569,0xD3EC,0xC555,0xD3EC,
    0xBCF5,0xAD81,0xB2F5,0xAD6C,0xAD81,0xBE44,0xD654,0xBD81,
    0xB1CC,0xC2DC,0xBC29,0xAD6C,0xC774,0xC7A1,0xC7A5,0xAC15,
    0xC7A5,0xAD11,0xD640,0xAC11,0xACE1,0xBCC0,0xADA4,0xD611,
    0xC7A5,0xAD11,0xBE44,0xD640,0xC720,0xADA4,0xADA4,0xD68C,
    0xB2E8,0xADA4,0xB834,0xB834,0xC0B0,0xB3C5,0xAD6C,0xAC70,
    0xD61C,0xD544,0xAD6C,0xC758,0xC554,0xC5B8,0xD3B8,0xB2C9,
    0xAD6C,0xC2ED,0xC2E0,0xCC9C,0xC785,0xC0BD,0xC878,0xC2B9,
    0xC624,0xD6FC,0xBC18,0xC138,0xC2ED,0xB9CC,0xD654,0xD611,
    0xB9CC,0xBE44,0xC878,0xD0C1,0xD611,0xB2E8,0xB9E4,0xB0A8,
    0xB2E8,0xC9D1,0xBC15,0xC194,0xBCF5,0xAD00,0xBCC0,0xACC4,
    0xC810,0xC7A1,0xB85C,0xC720,0xB85C,0xC11C,0xAD18,0xC640,
    0xC124,0xC808,0xC808,0xC704,0xC559,0xACF5,0xCE58,0xBB18,
    0xC778,0xC704,0xC18C,0xC989,0xAC01,0xB780,0xCE58,0xAD8C,
    0xC0AC,0xD73C,0xADFC,0xAC01,0xC62C,0xC989,0xC545,0xACBD,
    # 0x5380 #
    0xC2AC,0xC0B0,0xC5C4,0xCCA8,0xC561,0xCCAD,0xB825,0xCC45,
    0xC5C4,0xB824,0xC544,0xC555,0xC5FC,0xC0AC,0xC9C0,0xCC28,
    0xB871,0xC573,0xAC11,0xC560,0xC9C8,0xCE21,0xBC29,0xC81C,
    0xB9AC,0xC0AC,0xD6C4,0xCCAD,0xC218,0xC870,0xBE44,0xC6D0,
    0xCE21,0xC6D0,0xC0C1,0xC5FC,0xB825,0xAD90,0xD558,0xC804,
    0xC8FC,0xAD6C,0xADFC,0xC624,0xADA4,0xC5FC,0xC2DC,0xB825,
    0xCC3D,0xAC10,0xB824,0xC5C4,0xC5FC,0xC6D0,0xC0AC,0xAD49,
    0xB9B0,0xAD6C,0xAC70,0xAC70,0xBA70,0xB8E8,0xC8FC,0xD604,
    0xC804,0xCC38,0xCC38,0xCC38,0xCC38,0xCC38,0xC560,0xCCB4,
    0xC6B0,0xCC28,0xAE09,0xC6B0,0xC30D,0xBC18,0xC218,0xCF8C,
    0xBC1C,0xBC1C,0xC57D,0xC0AC,0xC219,0xCCA0,0xCDE8,0xC218,
    0xBCC0,0xC11C,0xAC00,0xBC18,0xC218,0xACE0,0xC704,0xC218,
    0xCCA9,0xC608,0xCD1D,0xAD6C,0xACE0,0xAD6C,0xB839,0xAD18,
    0xB3C4,0xACE0,0xC9C0,0xADDC,0xC18C,0xD314,0xC815,0xAC00,
    0xD0DC,0xC9C8,0xC0AC,0xC6B0,0xAD6C,0xD30C,0xD611,0xD638,
    0xC0AC,0xC6B0,0xCC99,0xB825,0xC870,0xAE30,0xB8CC,0xD64D,
    # 0x5400 #
    0xB9C8,0xC6B0,0xB9DD,0xD758,0xAC01,0xD6E4,0xC694,0xC790,
    0xD569,0xAE38,0xC801,0xCD0C,0xB3D9,0xBA85,0xD6C4,0xB9AC,
    0xD1A0,0xD5A5,0xD0C0,0xD601,0xC57C,0xB824,0xC544,0xB9C8,
    0xC6B0,0xD654,0xC758,0xAD70,0xCD94,0xB9B0,0xD0C4,0xC74C,
    0xD3D0,0xD544,0xC2EC,0xC2EC,0xAC1C,0xBD80,0xBD80,0xD30C,
    0xB454,0xBD84,0xC640,0xD568,0xC740,0xD56D,0xC804,0xACC4,
    0xD6A1,0xC9C0,0xC2E0,0xC624,0xC624,0xCD08,0xB20C,0xD608,
    0xD761,0xCDE8,0xB450,0xBB38,0xD6C4,0xD6C4,0xC624,0xACE0,
    0xD558,0xADE0,0xB824,0xC560,0xACA9,0xB9E4,0xB9E4,0xACC4,
    0xC815,0xC624,0xACE0,0xBD80,0xADDC,0xD6C4,0xCC99,0xC2B9,
    0xB20C,0xD0C4,0xBB34,0xC608,0xD0DC,0xAD6C,0xB825,0xD328,
    0xC6D0,0xAD18,0xAE30,0xCC3D,0xC624,0xC561,0xC2DC,0xD604,
    0xBCF8,0xBB38,0xB2C8,0xBB34,0xB839,0xC5FC,0xC720,0xC800,
    0xC8FC,0xAE30,0xC8FC,0xCCA9,0xD76C,0xC608,0xAE30,0xD3C9,
    0xC790,0xACE0,0xC790,0xBBF8,0xAD6C,0xAC00,0xB178,0xD569,
    0xBE44,0xC77C,0xD6A8,0xC2E0,0xD638,0xBA85,0xB2EC,0xAC70,
    # 0x5480 #
    0xC800,0xAC10,0xC7A1,0xD0C0,0xB3CC,0xBD80,0xD3EC,0xD544,
    0xBD88,0xC559,0xD654,0xC0AC,0xD654,0xD574,0xAD6C,0xC601,
    0xBD80,0xD0C0,0xC8FC,0xC640,0xC7A1,0xACE0,0xAC00,0xC88C,
    0xD3EC,0xB871,0xB3D9,0xB155,0xD0C0,0xC0AC,0xD604,0xD68D,
    0xC9D1,0xC774,0xC545,0xAD49,0xD0C0,0xD76C,0xC774,0xB82C,
    0xC790,0xBBF8,0xBBF8,0xC9C0,0xAD50,0xAE38,0xC8FC,0xAC01,
    0xC21C,0xCC30,0xC18C,0xD574,0xD68C,0xACFC,0xC2DC,0xB3C4,
    0xD568,0xC54C,0xD6E4,0xD734,0xAD18,0xC778,0xB85C,0xC774,
    0xC560,0xD488,0xC2E0,0xB3D9,0xD64D,0xD749,0xCE58,0xC640,
    0xD569,0xC7AC,0xC721,0xC9C0,0xACE0,0xD5A5,0xC560,0xADFC,
    0xAD11,0xC544,0xB2EC,0xD6A8,0xD544,0xD670,0xB144,0xD654,
    0xD589,0xCF8C,0xD0C0,0xBFD0,0xC81C,0xB18D,0xBAA8,0xC57D,
    0xD638,0xC6D0,0xB871,0xD22C,0xBC29,0xAC00,0xC544,0xD558,
    0xCD08,0xB9AC,0xB098,0xC871,0xD558,0xACE1,0xD6A8,0xD604,
    0xB85C,0xBC1C,0xCCA0,0xCC30,0xB7C9,0xD314,0xB9C8,0xB82C,
    0xC1E0,0xBD80,0xD3EC,0xD55C,0xD615,0xACBD,0xC124,0xAC00,
    # 0x5500 #
    0xC720,0xC5B8,0xACE1,0xACE1,0xD328,0xD568,0xC0AC,0xC9C4,
    0xC74D,0xC560,0xACB9,0xB3C4,0xB2E8,0xC644,0xB9AC,0xD76C,
    0xB2F9,0xC11C,0xC8FC,0xCC28,0xC624,0xC870,0xC544,0xB450,
    0xACC4,0xC801,0xCE68,0xB9C8,0xB9D0,0xD64D,0xB450,0xAC83,
    0xB85C,0xB7C9,0xC1C4,0xC870,0xD658,0xB7AD,0xC0AC,0xC989,
    0xC800,0xC640,0xBD09,0xAE08,0xD638,0xAE30,0xC218,0xC720,
    0xC1B0,0xCC3D,0xC560,0xB824,0xAC15,0xC554,0xCC28,0xC721,
    0xC810,0xC5B4,0xC804,0xB798,0xC0BD,0xC11D,0xD0C0,0xD640,
    0xC560,0xC870,0xB204,0xC2B5,0xD0C1,0xD0C1,0xC0C1,0xC801,
    0xD589,0xB78C,0xC544,0xAD50,0xAC15,0xD1A4,0xC624,0xBB38,
    0xCD40,0xC7A1,0xD640,0xACC4,0xACC4,0xB3C4,0xB2F4,0xB2F4,
    0xC644,0xC790,0xBE44,0xCD40,0xCCA0,0xD654,0xC544,0xACC4,
    0xCCA0,0xBC30,0xB7C9,0xD568,0xBE44,0xC0AC,0xB78D,0xCC45,
    0xC815,0xAD18,0xBC15,0xC790,0xC0C9,0xC804,0xAD50,0xAD35,
    0xB77C,0xC554,0xC801,0xAD8C,0xD0C4,0xD30C,0xC815,0xB791,
    0xC18C,0xAC70,0xB2F9,0xC2DC,0xC81C,0xC554,0xCD94,0xB2F4,
    # 0x5580 #
    0xAC1D,0xC639,0xC704,0xB0A8,0xC120,0xC721,0xCCA0,0xB77C,
    0xAC1C,0xD6C4,0xD568,0xCCA9,0xC8FC,0xC7AC,0xAD18,0xC57C,
    0xC6B1,0xC74C,0xC7A0,0xC694,0xC545,0xBA74,0xD638,0xC6B4,
    0xCC9C,0xD6FC,0xD658,0xD658,0xD76C,0xAC08,0xC989,0xC704,
    0xC885,0xC704,0xC0BD,0xD6C4,0xD669,0xB3C4,0xB151,0xD6E4,
    0xB7C9,0xC720,0xC0C1,0xB07D,0xAD50,0xC5B8,0xB2E8,0xBD84,
    0xC2DD,0xB9AC,0xC57D,0xC0AC,0xC704,0xBB18,0xC601,0xBD84,
    0xD3FF,0xADDC,0xACC4,0xC720,0xAE09,0xB8E8,0xACE1,0xC18C,
    0xD559,0xC81C,0xC694,0xD559,0xC0AC,0xD6C4,0xCC3D,0xC0C9,
    0xC639,0xC18C,0xD64D,0xD611,0xC775,0xC0AD,0xB9C8,0xCC28,
    0xD560,0xD569,0xD0D1,0xC0C1,0xC9C4,0xC695,0xC218,0xC648,
    0xACC4,0xBC29,0xC624,0xACB8,0xAE30,0xACA9,0xC790,0xCC28,
    0xB77D,0xC639,0xC62C,0xC0AC,0xCE58,0xD638,0xC0C9,0xB95C,
    0xD574,0xC1C4,0xC9C4,0xC12D,0xD558,0xC9D3,0xC1C4,0xC740,
    0xAC1C,0xB098,0xB2E4,0xC560,0xAC15,0xD1B5,0xD544,0xC624,
    0xC624,0xB828,0xCD5C,0xCC28,0xB9C9,0xC218,0xC8FC,0xD0D0,
    # 0x5600 #
    0xC801,0xC7A1,0xAD50,0xCDA9,0xAD50,0xAC1C,0xD0C4,0xC0BC,
    0xC870,0xAC00,0xC560,0xD6A8,0xD45C,0xB8E8,0xC54C,0xD558,
    0xAD50,0xD638,0xD61C,0xAD35,0xAD6C,0xC5B8,0xCC45,0xC0C1,
    0xD5C8,0xD30C,0xB4DD,0xB9C8,0xB9C8,0xACE1,0xB975,0xB3C4,
    0xC54C,0xB2F9,0xC57C,0xBD95,0xC575,0xC0AC,0xAD50,0xBC00,
    0xC18C,0xD654,0xB9E4,0xC5F0,0xCD5C,0xD33D,0xB85C,0xC18C,
    0xAE30,0xCD09,0xC870,0xADC0,0xCDE8,0xD6A8,0xC2DC,0xD638,
    0xBB34,0xB8CC,0xAD50,0xD76C,0xCD95,0xD0C4,0xB2F4,0xBB35,
    0xC190,0xC624,0xC900,0xBC88,0xB07D,0xC704,0xCC38,0xB2F9,
    0xCD95,0xB2F4,0xC728,0xD1A4,0xC7C1,0xCD08,0xC5F4,0xD761,
    0xAE30,0xD638,0xB828,0xD5C8,0xB4F1,0xC704,0xC74C,0xBC15,
    0xAD90,0xAE08,0xC2EC,0xAD50,0xB85C,0xC0AC,0xC5C4,0xC751,
    0xB2EC,0xCCA8,0xC624,0xC8FC,0xAE08,0xB18D,0xD670,0xD670,
    0xAE30,0xC545,0xC870,0xD76C,0xC11C,0xAD50,0xC5F0,0xC560,
    0xC639,0xAC39,0xCF8C,0xC6B0,0xBD84,0xB3C4,0xAC08,0xD760,
    0xD1A4,0xB2F9,0xC2E0,0xC0C8,0xBCBD,0xBE44,0xC74C,0xCDE8,
    # 0x5680 #
    0xB155,0xC801,0xB78C,0xD0D1,0xD68D,0xC720,0xD6A8,0xD558,
    0xC5FD,0xB3CC,0xBE44,0xC8FC,0xC81C,0xC9C4,0xD638,0xCCB4,
    0xC0C1,0xD6C8,0xB9C8,0xCC30,0xCCB4,0xB85C,0xD61C,0xBC15,
    0xC6B0,0xAD50,0xC740,0xD559,0xBB35,0xD6A1,0xCCA0,0xB9AC,
    0xB958,0xD61C,0xB0AD,0xD6A8,0xB9C8,0xC5F0,0xB825,0xB85C,
    0xB871,0xBD80,0xB2F4,0xCE5C,0xBE48,0xBE44,0xD5A5,0xD559,
    0xB9C8,0xD76C,0xD0C0,0xACE1,0xC5C4,0xCC38,0xC575,0xC591,
    0xC810,0xB77C,0xC218,0xD6A8,0xC791,0xCCA0,0xD6E4,0xD68D,
    0xC804,0xC12D,0xD6A8,0xC7A1,0xB9AC,0xCC9C,0xCC44,0xB824,
    0xC608,0xB77C,0xB0AD,0xCC2C,0xC18C,0xD76C,0xC99D,0xAC04,
    0xC798,0xCD09,0xB780,0xC124,0xB0AD,0xB78C,0xB77C,0xAD6D,
    0xD68C,0xC778,0xC218,0xC0AC,0xC778,0xAC74,0xD68C,0xC2E0,
    0xC778,0xB2D9,0xB2E8,0xB2E8,0xB3C8,0xAC15,0xC5F0,0xACBD,
    0xD3B8,0xC6B4,0xCC3D,0xD640,0xD68C,0xC644,0xC640,0xAD6D,
    0xACE4,0xCC3D,0xC704,0xB3C4,0xC704,0xB95C,0xAD6D,0xADE0,
    0xC77C,0xB839,0xACE0,0xAD6D,0xD0DC,0xAD6D,0xB3C4,0xC720,
    # 0x5700 #
    0xAD6D,0xC740,0xD63C,0xD3EC,0xC5B4,0xD568,0xC6D0,0xB95C,
    0xAD8C,0xC5B4,0xCCAD,0xAD6D,0xCC9C,0xC704,0xC6D0,0xAD8C,
    0xACE0,0xD3EC,0xC6D0,0xC6D0,0xC555,0xC11C,0xB3C4,0xB3C4,
    0xB2E8,0xB7B5,0xADA4,0xC5ED,0xC6D0,0xB780,0xB780,0xD1A0,
    0xC54C,0xD1A0,0xC815,0xACE8,0xBC15,0xB85D,0xC785,0xC555,
    0xC7AC,0xC6B0,0xC744,0xC624,0xC624,0xADDC,0xBE44,0xC774,
    0xC9C0,0xCC9C,0xCC9C,0xC218,0xC791,0xD0D5,0xACB9,0xD558,
    0xC0B0,0xAD11,0xC7A5,0xAE30,0xB148,0xBAB0,0xAE09,0xAC08,
    0xC9C0,0xC9C0,0xD310,0xD6C8,0xC5ED,0xAE08,0xB9E4,0xADE0,
    0xAC31,0xB454,0xBC29,0xBD84,0xBD84,0xB2E8,0xAC10,0xBC30,
    0xC88C,0xAC31,0xBE44,0xD615,0xC9C0,0xACBD,0xAE30,0xAD34,
    0xC9C0,0xACBD,0xACAC,0xB2E8,0xB825,0xD30C,0xC624,0xBD84,
    0xCD94,0xD30C,0xBC18,0xB2F9,0xACE4,0xC800,0xD0C4,0xCC99,
    0xC774,0xAC10,0xD3C9,0xC810,0xACFC,0xB2C8,0xB300,0xBC30,
    0xACBD,0xC559,0xBD88,0xC694,0xB959,0xAD6C,0xBAA9,0xAC00,
    0xAD6C,0xD608,0xBC1C,0xC9C0,0xD0C1,0xB839,0xC800,0xBD80,
    # 0x5780 #
    0xD638,0xCE58,0xC218,0xB784,0xB871,0xB871,0xB85C,0xC694,
    0xB300,0xD3EC,0xBBFC,0xD615,0xB3D9,0xAC8C,0xACA9,0xB960,
    0xC790,0xCE58,0xB8E8,0xD574,0xC778,0xD6C4,0xD1F4,0xC870,
    0xBCF5,0xAD11,0xC694,0xD0C0,0xD0C0,0xADA4,0xD0C0,0xC591,
    0xC740,0xBC8C,0xAD6C,0xC6D0,0xC9C8,0xD611,0xC740,0xC0C1,
    0xC218,0xC545,0xBCD1,0xC810,0xD64D,0xC544,0xACFC,0xB2EC,
    0xC694,0xB2F9,0xAC1C,0xD589,0xB1CC,0xC548,0xC131,0xD604,
    0xC644,0xBC29,0xBD80,0xD30C,0xC5ED,0xC740,0xD55C,0xC11C,
    0xC218,0xC7A0,0xACBD,0xC560,0xBD09,0xBC29,0xAC01,0xC6A9,
    0xC900,0xD611,0xC9C0,0xB9E4,0xB791,0xD604,0xC131,0xC5F0,
    0xCE68,0xCCA0,0xB784,0xB784,0xD3EC,0xC815,0xD654,0xBCF4,
    0xC2DC,0xD6C8,0xACFC,0xACBD,0xC57C,0xB150,0xC81C,0xC5ED,
    0xBD80,0xC624,0xAD8C,0xC1C4,0xBE44,0xC815,0xC644,0xAD6C,
    0xB95C,0xC815,0xACF5,0xCD1D,0xB3D9,0xD0DC,0xB2C8,0xC554,
    0xCC44,0xC219,0xBD09,0xAC10,0xC2DD,0xD0C0,0xC608,0xC9D1,
    0xC5ED,0xBC30,0xAE30,0xC900,0xAE30,0xC18C,0xCD94,0xB2F4,
    # 0x5800 #
    0xAD74,0xACFC,0xB2F9,0xACE4,0xC608,0xACAC,0xD1F4,0xADFC,
    0xAC15,0xC721,0xC545,0xBD95,0xACE0,0xD1A0,0xB989,0xBC29,
    0xC560,0xCC38,0xACE4,0xC548,0xC2EC,0xD0C0,0xB1CC,0xB3CC,
    0xC2B9,0xC778,0xD63C,0xBCBD,0xB828,0xACFC,0xCCA9,0xC804,
    0xD6C4,0xBCF4,0xBCF4,0xC6B0,0xC81C,0xBB34,0xACC4,0xC5F0,
    0xC54C,0xAE0D,0xAC10,0xC885,0xC720,0xD669,0xC545,0xC694,
    0xC5B8,0xBCF4,0xC990,0xBBF8,0xC7A5,0xB3C4,0xD0C0,0xC554,
    0xD48D,0xC885,0xACC4,0xC9C4,0xD589,0xAC15,0xCD98,0xAC10,
    0xBCD1,0xB8E8,0xD56D,0xD669,0xBC29,0xB2E8,0xB9CC,0xC120,
    0xAE30,0xCC99,0xAD34,0xC601,0xD0D1,0xC2B9,0xC6A9,0xAC1C,
    0xC18C,0xC18C,0xC2DC,0xBA71,0xD0D1,0xC639,0xC790,0xB3C4,
    0xB2F9,0xACE0,0xCD1D,0xB960,0xBD09,0xBC29,0xC0C8,0xC7A5,
    0xD1F4,0xC804,0xC624,0xC815,0xD6C8,0xAC1D,0xC9C4,0xC560,
    0xACF5,0xC5FC,0xAC10,0xC804,0xC6D0,0xC628,0xC0AC,0xB958,
    0xD574,0xB791,0xC7A5,0xBD09,0xBD95,0xC9C4,0xB85D,0xB85C,
    0xC6B0,0xCC38,0xB9E4,0xB9C9,0xC804,0xC0C1,0xC219,0xB8E8,
    # 0x5880 #
    0xC9C0,0xB9CC,0xD45C,0xACBD,0xCC99,0xC11C,0xCCB4,0xC7A5,
    0xAC10,0xC6A9,0xC810,0xCC38,0xCC99,0xAE30,0xACFD,0xC7A5,
    0xADFC,0xC801,0xC0C1,0xBB18,0xCD5C,0xC5B8,0xD0D1,0xC99D,
    0xAC74,0xC7A5,0xB7C9,0xC704,0xCD94,0xC694,0xC99D,0xD5C8,
    0xC120,0xC120,0xBC1C,0xBCF5,0xAD34,0xB3D9,0xBC88,0xAC01,
    0xBB35,0xB3C8,0xB3C8,0xC900,0xC9C0,0xC131,0xD0C0,0xD0C0,
    0xB2F4,0xB4F1,0xBB34,0xBD84,0xD669,0xB2F4,0xB2EC,0xD654,
    0xC800,0xAC04,0xC624,0xC7A5,0xACA9,0xAD50,0xAC04,0xC5ED,
    0xBE44,0xBCBD,0xC804,0xAC15,0xC57C,0xC639,0xD559,0xB2E8,
    0xB78C,0xAC70,0xAD34,0xB2F9,0xC591,0xCC38,0xD6C8,0xD568,
    0xC0C8,0xD559,0xC560,0xC555,0xB3C4,0xD638,0xC5F0,0xC9C4,
    0xB8E8,0xAD11,0xB85C,0xC5FC,0xB2F4,0xC720,0xAD34,0xB871,
    0xB871,0xC608,0xB825,0xB9B0,0xC591,0xC804,0xD6C8,0xC554,
    0xB8B0,0xD30C,0xB9CC,0xC0AC,0xC784,0xC0B0,0xC7A5,0xC7A5,
    0xC131,0xC77C,0xB9E4,0xAC01,0xC8FC,0xC7A5,0xD638,0xD638,
    0xACE4,0xC77C,0xD638,0xC11C,0xACE4,0xC218,0xB9DD,0xC900,
    # 0x5900 #
    0xC218,0xC77C,0xCE58,0xACE0,0xCC98,0xAC15,0xBD09,0xBE44,
    0xC7AC,0xBCC0,0xC1E0,0xC900,0xB989,0xBCF5,0xC88C,0xD558,
    0xD615,0xC12D,0xB178,0xD558,0xAE30,0xC11D,0xC678,0xC6D0,
    0xC6D0,0xC219,0xB2E4,0xB2E4,0xC57C,0xCCAD,0xC68B,0xAD6C,
    0xAD6C,0xAE30,0xBABD,0xBABD,0xC778,0xACFC,0xCE68,0xB300,
    0xB148,0xCC9C,0xD0DC,0xBD80,0xCF8C,0xC694,0xC559,0xD56D,
    0xD638,0xC2E4,0xB3C4,0xD0DC,0xB450,0xC5FC,0xBE44,0xC774,
    0xACFC,0xD611,0xD0C8,0xD654,0xCC9C,0xC6B4,0xD611,0xD30C,
    0xB9DD,0xB834,0xD658,0xC800,0xC5C4,0xD3EC,0xAD8C,0xAE30,
    0xB0B4,0xBD09,0xD608,0xAC15,0xC810,0xC591,0xADDC,0xC8FC,
    0xD658,0xACC4,0xAC1C,0xCC28,0xBD84,0xD601,0xC7A5,0xD22C,
    0xC7A5,0xBD84,0xD574,0xD669,0xBE44,0xC870,0xC21C,0xAE0D,
    0xC804,0xC624,0xC0AC,0xC575,0xBC18,0xC624,0xBB34,0xC624,
    0xC7A5,0xB834,0xD0C8,0xC724,0xC7A5,0xC11D,0xBD84,0xD65C,
    0xBE44,0xB828,0xCC28,0xB140,0xB178,0xC815,0xB0B4,0xCC9C,
    0xAC04,0xC800,0xAD6C,0xB09C,0xD0C0,0xD638,0xC120,0xBC88,
    # 0x5980 #
    0xAE30,0xC791,0xC5EC,0xBE44,0xB9DD,0xD64D,0xC7A5,0xBD80,
    0xB9C8,0xB2F4,0xC784,0xBD80,0xC815,0xC5F0,0xD574,0xBB38,
    0xC885,0xD30C,0xD22C,0xAE30,0xAC31,0xC911,0xC694,0xAE08,
    0xC6B4,0xBB18,0xBC30,0xCE58,0xACB0,0xC7A5,0xB274,0xC548,
    0xB0A9,0xD754,0xBD84,0xBE44,0xC5EC,0xD0C0,0xBD09,0xC644,
    0xBC29,0xBB34,0xAD6C,0xADDC,0xD22C,0xBC1C,0xB2C8,0xCD95,
    0xC791,0xCD08,0xB2EC,0xB2C8,0xC6D0,0xC8FC,0xD604,0xC9C8,
    0xC544,0xB9E4,0xB9D0,0xCC98,0xD544,0xC2E0,0xCCA9,0xC544,
    0xD654,0xD6C4,0xD54D,0xC815,0xBBFC,0xBC18,0xBAA8,0xBD80,
    0xB839,0xC790,0xC790,0xC2DC,0xC5FC,0xC0B0,0xC559,0xB2F4,
    0xC800,0xACE0,0xC0AC,0xC131,0xC704,0xC790,0xAC70,0xC0B0,
    0xD3C9,0xC784,0xC694,0xB3D9,0xAC15,0xC8FC,0xAE38,0xD574,
    0xD5A5,0xD65C,0xC5F0,0xAD50,0xAD6C,0xBAA8,0xAC04,0xAC04,
    0xC774,0xB144,0xC9C8,0xC9C4,0xD76C,0xD5D8,0xD56D,0xAD11,
    0xC21C,0xACFC,0xC548,0xBA85,0xB82C,0xD328,0xC555,0xC720,
    0xC5F0,0xCC28,0xC2E0,0xC778,0xC81C,0xADA4,0xC804,0xC790,
    # 0x5A00 #
    0xC735,0xC704,0xD64D,0xC65C,0xB8E8,0xC544,0xC694,0xAD50,
    0xB828,0xBE59,0xD604,0xC18C,0xB9AC,0xC131,0xD608,0xB9DD,
    0xBD80,0xC0AC,0xBAA8,0xBBF8,0xADF9,0xCC29,0xCC29,0xC815,
    0xB0AD,0xD615,0xB0A8,0xC624,0xB098,0xBD80,0xB1CC,0xC5F0,
    0xC2E0,0xC9C0,0xD568,0xC81C,0xC7A5,0xC544,0xBE48,0xD0DC,
    0xD55C,0xB9CC,0xC624,0xC5F0,0xBB34,0xC560,0xC5B8,0xC624,
    0xC0AC,0xC624,0xC65C,0xB9AC,0xD55C,0xCD94,0xCDE8,0xC218,
    0xAE30,0xD604,0xCD2C,0xB3D9,0xCC3D,0xB85D,0xC560,0xC544,
    0xC544,0xB8E8,0xBA74,0xC885,0xBD80,0xAD6D,0xD30C,0xCC44,
    0xB989,0xC644,0xD45C,0xD6A8,0xC219,0xAE30,0xD734,0xBC18,
    0xC640,0xC720,0xB2F4,0xBE44,0xBE44,0xCCA9,0xCCA8,0xC608,
    0xAD8C,0xC815,0xD63C,0xACBD,0xAC04,0xC804,0xD589,0xACE0,
    0xC644,0xB798,0xBE44,0xC778,0xC8FC,0xC791,0xBD80,0xC815,
    0xB860,0xC548,0xB78C,0xD63C,0xC74C,0xC544,0xAC70,0xB824,
    0xC804,0xD604,0xD654,0xD68D,0xC601,0xC120,0xC2EC,0xC815,
    0xD0D5,0xC694,0xBB34,0xB0A8,0xC57C,0xAC00,0xC720,0xC11C,
    # 0x5A80 #
    0xC6B0,0xC704,0xC81C,0xC720,0xBBF8,0xB2F4,0xB208,0xCE5C,
    0xD718,0xC625,0xC804,0xCD98,0xBB18,0xBD80,0xC800,0xB2E8,
    0xC774,0xC911,0xB9E4,0xD669,0xBA74,0xC554,0xC601,0xD6E4,
    0xAC1C,0xC704,0xBBF8,0xC6D0,0xC815,0xCD94,0xC81C,0xC124,
    0xD0C0,0xB828,0xBAA8,0xC5FC,0xC2DC,0xD3B8,0xC704,0xC65C,
    0xC720,0xD638,0xC624,0xCCA9,0xBCF4,0xC218,0xC720,0xADDC,
    0xCD94,0xC694,0xBE44,0xC2DD,0xC6D0,0xC789,0xC6A9,0xC695,
    0xCE58,0xB958,0xBBF8,0xBC18,0xC628,0xB9C8,0xAD6C,0xAD34,
    0xC9C4,0xAC00,0xC218,0xC9C4,0xC6D0,0xCC28,0xC6A9,0xBA85,
    0xC575,0xC9C8,0xC18C,0xB1E8,0xD610,0xB3C4,0xBC29,0xB791,
    0xB1E8,0xC694,0xC560,0xBE44,0xBE48,0xC608,0xD45C,0xAD6C,
    0xB8E8,0xC120,0xB9CC,0xC608,0xC7A5,0xAC15,0xC6A9,0xB2C9,
    0xB9AC,0xC801,0xADDC,0xC5B8,0xADFC,0xC804,0xD56D,0xCC45,
    0xD55C,0xB208,0xB85C,0xBAA8,0xC11C,0xD638,0xD638,0xC624,
    0xB208,0xC7A5,0xB9C8,0xBCC4,0xACE0,0xBB34,0xCD08,0xD0C0,
    0xC120,0xBB18,0xD55C,0xD55C,0xBB35,0xB8CC,0xB828,0xD68D,
    # 0x5B00 #
    0xADDC,0xB4F1,0xC9C1,0xC218,0xC77C,0xD654,0xAE09,0xADA4,
    0xC694,0xD76C,0xC5F0,0xC120,0xAD50,0xBBF8,0xBC18,0xBC88,
    0xC12C,0xC758,0xD68C,0xAD50,0xBC18,0xC11D,0xD3D0,0xC120,
    0xC218,0xC7A5,0xB834,0xD604,0xD760,0xB1E8,0xB3D9,0xC758,
    0xCC38,0xC560,0xC591,0xB155,0xB9C8,0xC870,0xC218,0xC9C4,
    0xC790,0xC5EC,0xBE48,0xC601,0xC720,0xB0B4,0xC5FC,0xB300,
    0xC601,0xCC38,0xB1E8,0xD655,0xC601,0xBA74,0xBE44,0xB9C8,
    0xC2EC,0xD765,0xB2C9,0xB3C5,0xB958,0xC5F0,0xB780,0xC5F0,
    0xC0C1,0xB839,0xAD50,0xC591,0xB780,0xC12C,0xC601,0xC30D,
    0xD734,0xAD8C,0xBBF8,0xB9AC,0xB828,0xC5C4,0xCD09,0xB780,
    0xC790,0xD608,0xAD90,0xAD90,0xACF5,0xC789,0xC790,0xC790,
    0xC874,0xC190,0xBD80,0xD328,0xC790,0xD6A8,0xC2E0,0xB9F9,
    0xC0AC,0xD0DC,0xD3EC,0xACC4,0xACE0,0xB178,0xD559,0xC720,
    0xC804,0xD574,0xC0B0,0xC190,0xC704,0xBA78,0xC885,0xAC04,
    0xC219,0xC794,0xC544,0xC790,0xC758,0xBD80,0xC790,0xB9AC,
    0xD559,0xBCBD,0xC720,0xB0B4,0xC5BC,0xC5BC,0xC601,0xC0B0,
    # 0x5B80 #
    0xBA74,0xC800,0xC6A9,0xD0C0,0xADC0,0xB301,0xAD81,0xC6B0,
    0xC218,0xC548,0xAC00,0xC1A1,0xC644,0xC721,0xC694,0xAD49,
    0xC758,0xC815,0xC900,0xBCF5,0xC8FC,0xD0D5,0xD6A1,0xC885,
    0xAD00,0xC8FC,0xC815,0xC644,0xC758,0xBCF4,0xC2E4,0xC2E4,
    0xCD1D,0xC2EC,0xAC1D,0xC120,0xC2E4,0xC720,0xD658,0xC774,
    0xC870,0xC2DC,0xD5CC,0xAD81,0xC131,0xAD70,0xAD81,0xD6A8,
    0xC7AC,0xC790,0xD3EC,0xD574,0xC5F0,0xC18C,0xAC00,0xC2EC,
    0xC2E0,0xC6A9,0xD669,0xBC00,0xAD6C,0xAD00,0xBE48,0xC219,
    0xCC44,0xC7A0,0xC801,0xC6D0,0xAE30,0xC778,0xBC00,0xAD6C,
    0xAC74,0xCD94,0xC815,0xAC74,0xBD80,0xB155,0xBCD1,0xD658,
    0xB9E4,0xCE68,0xD55C,0xC6B0,0xC2DD,0xB155,0xCE68,0xB155,
    0xCE58,0xC720,0xBCF4,0xAD00,0xB155,0xCE68,0xB9C9,0xCC30,
    0xAD6C,0xACFC,0xCE68,0xD640,0xC624,0xC694,0xC2E4,0xB155,
    0xCC44,0xC2EC,0xC704,0xC0AC,0xAD00,0xD61C,0xB8CC,0xC900,
    0xD658,0xC608,0xC758,0xBCF4,0xCE5C,0xCD1D,0xBCF4,0xD48D,
    0xCD0C,0xB300,0xC0AC,0xC2EC,0xB3C4,0xB960,0xB300,0xC218,
    # 0x5C00 #
    0xD30C,0xBD09,0xBD80,0xBD80,0xC0AC,0xADF9,0xC7A5,0xC7A5,
    0xC804,0xC704,0xC874,0xC2EC,0xC8FC,0xB300,0xB3C4,0xC18C,
    0xC808,0xC18C,0xC774,0xC774,0xC774,0xC18C,0xCCA8,0xC219,
    0xC9C4,0xC0C1,0xC0C1,0xB9C8,0xAC00,0xC0C1,0xB8CC,0xC120,
    0xC120,0xACE4,0xC655,0xC655,0xC6B0,0xB8CC,0xB8CC,0xC694,
    0xBC29,0xC655,0xC655,0xC655,0xAC1C,0xC694,0xD0C0,0xADC0,
    0xC885,0xCDE8,0xAC10,0xACE8,0xCD94,0xD1F4,0xAC10,0xCD94,
    0xC2DC,0xC724,0xCC99,0xACE0,0xB2C8,0xC9C4,0xBBF8,0xB1E8,
    0xAD6D,0xBE44,0xCE35,0xD76C,0xBE44,0xAC70,0xACC4,0xC804,
    0xAD74,0xCCB4,0xACC4,0xC625,0xCD08,0xC2DC,0xC2DC,0xBCD1,
    0xADF9,0xC124,0xC9C4,0xD76C,0xB2C8,0xC804,0xC11C,0xCD0C,
    0xB9CC,0xC544,0xB8E8,0xBCD1,0xCCB4,0xBE44,0xC18D,0xC12D,
    0xB3C4,0xB8E8,0xB8E8,0xC0AC,0xCE35,0xB9AC,0xAD6C,0xC12D,
    0xAD6C,0xAD50,0xB8CC,0xAD50,0xC18D,0xD76C,0xC88C,0xB454,
    0xC5ED,0xC0B0,0xC815,0xC120,0xB825,0xC54C,0xB3C4,0xD68C,
    0xD64D,0xD758,0xAE30,0xC778,0xC62C,0xD55C,0xC2E0,0xC11C,
    # 0x5C80 #
    0xCD9C,0xC138,0xAE30,0xC778,0xC6D4,0xD310,0xC694,0xC559,
    0xD558,0xBB3C,0xC808,0xC555,0xAE09,0xACAC,0xBD84,0xC644,
    0xAE30,0xC7A0,0xACB8,0xAE30,0xCC28,0xAC1C,0xAD6C,0xAC15,
    0xD604,0xC624,0xB78C,0xB3C4,0xD30C,0xC791,0xC791,0xC559,
    0xAC70,0xAC15,0xAC00,0xAD6C,0xD608,0xD30C,0xB9BD,0xCD08,
    0xC800,0xC554,0xBD88,0xC218,0xAC11,0xB839,0xD0C0,0xBE44,
    0xC720,0xB300,0xD56D,0xC545,0xAD6C,0xD638,0xBC31,0xBBFC,
    0xC548,0xCD08,0xB839,0xC9C0,0xD3C9,0xB3D9,0xC810,0xADDC,
    0xC218,0xBB18,0xB3D9,0xD559,0xC5ED,0xBCC0,0xD569,0xD569,
    0xB77D,0xC561,0xBD80,0xC21C,0xC9C8,0xB960,0xC740,0xC774,
    0xD574,0xC804,0xB3D9,0xC774,0xBAA8,0xAC15,0xC548,0xC704,
    0xD658,0xCE58,0xBC00,0xB9AC,0xACC4,0xB3D9,0xC678,0xC6B0,
    0xC0C1,0xD611,0xB9AC,0xC694,0xAD50,0xC7C1,0xB9CC,0xAD50,
    0xC544,0xC544,0xC695,0xC0AC,0xD3EC,0xCD08,0xADE0,0xBD09,
    0xBD09,0xB178,0xB9AC,0xC720,0xD604,0xD6A1,0xB3C4,0xC2E0,
    0xC131,0xB3C4,0xACBD,0xC900,0xD638,0xD611,0xC740,0xC5B4,
    # 0x5D00 #
    0xB791,0xAC10,0xB85C,0xB798,0xD5D8,0xAC01,0xACF5,0xC22D,
    0xD654,0xB2F5,0xB9BC,0xD654,0xAC70,0xB798,0xAE30,0xBBFC,
    0xACE4,0xACE4,0xC904,0xACE0,0xCD5C,0xC560,0xC560,0xAC15,
    0xB95C,0xB95C,0xB989,0xAD74,0xD0C0,0xC7C1,0xACFD,0xC74C,
    0xB3D9,0xC7C1,0xC7C1,0xC704,0xD6A8,0xBE44,0xC5C4,0xC22D,
    0xCCA9,0xBD95,0xC904,0xAD74,0xB3D9,0xCC38,0xACE0,0xC74C,
    0xCE58,0xC989,0xD669,0xC720,0xC678,0xC591,0xBD09,0xCD94,
    0xB3C8,0xCCB4,0xC774,0xCE58,0xC2DC,0xC7AC,0xC694,0xC545,
    0xC8FC,0xAC10,0xB960,0xC5B8,0xBBF8,0xAC10,0xD61C,0xD61C,
    0xC644,0xC815,0xC2B9,0xBBF8,0xAC10,0xBB34,0xC6B0,0xC885,
    0xB78C,0xAC08,0xC554,0xC554,0xC678,0xC885,0xC0AC,0xC138,
    0xC601,0xACFC,0xAE08,0xC720,0xAE30,0xB8E8,0xB3C4,0xD1F4,
    0xACC4,0xC639,0xCC3D,0xB2F9,0xD615,0xAC78,0xC560,0xB958,
    0xC624,0xC22D,0xACE0,0xC790,0xC678,0xD33D,0xC804,0xCC28,
    0xACB8,0xC6A9,0xC5BC,0xCC28,0xCC99,0xC2DC,0xC57D,0xC885,
    0xC885,0xAC15,0xAD50,0xAC15,0xC0B0,0xCCB4,0xCC38,0xC815,
    # 0x5D80 #
    0xB3C4,0xB8E8,0xC7A5,0xCC38,0xCC38,0xC624,0xC870,0xAD6C,
    0xC7A5,0xCDE8,0xCC38,0xB3C4,0xB3C4,0xC2B5,0xC704,0xBC30,
    0xB96D,0xC0C1,0xC99D,0xD30C,0xAE08,0xCD08,0xC5C4,0xB85C,
    0xC794,0xB9B0,0xB8CC,0xB8CC,0xCE68,0xB4F1,0xD0C0,0xC900,
    0xAD50,0xAD90,0xC694,0xCD08,0xC694,0xAD90,0xCCA8,0xC5ED,
    0xD559,0xB18D,0xC5C5,0xC5C5,0xC758,0xC54C,0xD5D8,0xC9D1,
    0xD574,0xAC08,0xC218,0xC9C0,0xC624,0xC8C4,0xBBF8,0xC758,
    0xC601,0xB3C4,0xB839,0xC808,0xC11C,0xC545,0xC740,0xC218,
    0xCC30,0xB824,0xD734,0xB871,0xB871,0xC804,0xC601,0xD76C,
    0xAD6D,0xCC38,0xC601,0xADDC,0xC554,0xC678,0xB178,0xAD8C,
    0xCD08,0xCC2C,0xB9CC,0xC804,0xC804,0xC5BC,0xC554,0xC554,
    0xD5CC,0xB178,0xD5CC,0xCC9C,0xAD34,0xCC9C,0xC8FC,0xD669,
    0xACBD,0xC21C,0xC18C,0xC18C,0xB835,0xACF5,0xC88C,0xAD50,
    0xAC70,0xACF5,0xAC71,0xBB34,0xBD80,0xBD80,0xCC28,0xAD6C,
    0xAD6C,0xAE30,0xC774,0xC0AC,0xD30C,0xCE58,0xC18C,0xD56D,
    0xC774,0xADFC,0xC190,0xAD8C,0xD31F,0xC190,0xAC74,0xBD88,
    # 0x5E00 #
    0xC7A1,0xC7A1,0xC2DC,0xD3EC,0xC815,0xC218,0xBC94,0xB151,
    0xC0AC,0xBD84,0xD30C,0xC9C0,0xD76C,0xD638,0xB2F4,0xC704,
    0xC7A5,0xD0D5,0xB300,0xB9D0,0xD53C,0xB9D0,0xCCA9,0xBD88,
    0xB834,0xC9C8,0xCD94,0xBC31,0xCE58,0xC81C,0xB9E5,0xC5ED,
    0xC608,0xBCD1,0xAC11,0xAD8C,0xB140,0xC218,0xB300,0xC815,
    0xC138,0xCD08,0xC9C4,0xC0AC,0xAD70,0xC11D,0xBC29,0xB300,
    0xADC0,0xC8FC,0xBCD1,0xC7A5,0xC804,0xC644,0xB300,0xC720,
    0xC0C1,0xC0BD,0xAE30,0xCC45,0xAD35,0xBAA8,0xB3C4,0xD6C4,
    0xC815,0xC218,0xBA71,0xC704,0xC545,0xD3ED,0xAC1C,0xBC29,
    0xBCD1,0xB151,0xACF5,0xBC18,0xD669,0xB3C4,0xBA71,0xAC00,
    0xB4F1,0xD718,0xC885,0xC0BC,0xB9CC,0xB9C9,0xD45C,0xAD35,
    0xCC45,0xB9C9,0xBC29,0xC7A5,0xACBD,0xCC9C,0xBCF5,0xCE58,
    0xBB34,0xBC88,0xB2F9,0xD3D0,0xD3D0,0xC7A5,0xBA71,0xC870,
    0xCCA8,0xBD84,0xBABD,0xBC29,0xC8FC,0xBA78,0xC8FC,0xC808,
    0xD5CC,0xB780,0xAC04,0xD3C9,0xB144,0xACAC,0xBCD1,0xBCD1,
    0xD589,0xAC04,0xC694,0xD658,0xC720,0xC720,0xAE30,0xC5C4,
    # 0x5E80 #
    0xBE44,0xCCAD,0xCE21,0xAD11,0xC7A5,0xC800,0xACBD,0xBE44,
    0xAE08,0xB3C8,0xC0C1,0xAE30,0xC544,0xD754,0xAC1C,0xC11C,
    0xB824,0xBB34,0xC555,0xACE0,0xC751,0xC800,0xD3EC,0xC810,
    0xC555,0xBB18,0xACBD,0xC790,0xBD80,0xB3D9,0xBC29,0xD3D0,
    0xC0C1,0xC758,0xC9C8,0xC870,0xCE58,0xD734,0xB3C4,0xC88C,
    0xD6A8,0xB3C4,0xAE30,0xACE0,0xBC29,0xC815,0xC720,0xD3EC,
    0xBCD1,0xB989,0xB798,0xBE44,0xC801,0xC554,0xC11C,0xAC15,
    0xC6A9,0xD0C1,0xC1A1,0xC11C,0xACBD,0xC6B0,0xC720,0xBB18,
    0xC218,0xCE21,0xC0C1,0xD3D0,0xAD6C,0xD569,0xC678,0xB958,
    0xD558,0xB834,0xB791,0xC218,0xCE58,0xBD80,0xACBD,0xAD6C,
    0xAD6C,0xADFC,0xC624,0xACFD,0xB8E8,0xC74C,0xB8CC,0xB300,
    0xB85D,0xC774,0xC8FC,0xC804,0xB3C4,0xC2DC,0xD760,0xBB18,
    0xCC3D,0xBB34,0xD3D0,0xAD11,0xACF3,0xAD34,0xBCBD,0xC7A5,
    0xD574,0xB984,0xB984,0xB8CC,0xB824,0xC801,0xC601,0xC120,
    0xCCAD,0xC639,0xB824,0xCCAD,0xC778,0xC21C,0xC5F0,0xC815,
    0xC801,0xBC15,0xAC74,0xD68C,0xB0B4,0xD68C,0xACF5,0xC785,
    # 0x5F00 #
    0xAC1C,0xBCC0,0xC774,0xAE30,0xB871,0xBD84,0xAC70,0xAC10,
    0xD601,0xC7A5,0xD3D0,0xC775,0xC77C,0xC774,0xC0BC,0xC2DD,
    0xC774,0xC2DC,0xC2DC,0xAD81,0xC870,0xC778,0xD638,0xBD88,
    0xD64D,0xC624,0xD1F4,0xC774,0xAC15,0xD30C,0xC2E0,0xC81C,
    0xC7A5,0xAD74,0xB3C4,0xBD80,0xC800,0xBBF8,0xD604,0xD638,
    0xCD08,0xB178,0xACBD,0xC9C4,0xC774,0xBBF8,0xD658,0xB9CC,
    0xC18C,0xC57D,0xD604,0xACBD,0xB3C8,0xC7A5,0xAC15,0xAC15,
    0xBD95,0xD0C4,0xAC15,0xD544,0xD544,0xC12D,0xD0C4,0xAC74,
    0xAD6C,0xAC00,0xBC1C,0xD544,0xAD6C,0xC804,0xBCC4,0xC18C,
    0xD0C4,0xD655,0xAC15,0xD6A1,0xBBF8,0xD655,0xB9CC,0xD655,
    0xACC4,0xACC4,0xADC0,0xB2F9,0xB85D,0xB85D,0xB2E8,0xD61C,
    0xCCB4,0xD718,0xD718,0xC774,0xC774,0xC774,0xC774,0xD655,
    0xD655,0xC0BC,0xD615,0xBB38,0xB3D9,0xC5B8,0xC5B8,0xC6B1,
    0xB9AC,0xCC44,0xD45C,0xC870,0xBE48,0xD33D,0xC6A9,0xD45C,
    0xCC3D,0xC601,0xB9AC,0xCC99,0xBC15,0xD0C0,0xAE09,0xBC29,
    0xC1A1,0xC5ED,0xC655,0xCCA0,0xD53C,0xC9C0,0xB839,0xBD88,
    # 0x5F80 #
    0xC655,0xC815,0xC870,0xC655,0xACBD,0xB300,0xC11C,0xC21C,
    0xD754,0xC591,0xD68C,0xB960,0xD6C4,0xB960,0xC815,0xCC99,
    0xC11C,0xACBD,0xB3C4,0xC885,0xC885,0xB798,0xC885,0xB4DD,
    0xBC30,0xC0AC,0xB828,0xAE30,0xC0C1,0xCE58,0xC885,0xC8FC,
    0xB798,0xC5B4,0xC12D,0xCC28,0xAC74,0xC2DC,0xAC00,0xD3B8,
    0xD669,0xBCF5,0xC21C,0xC704,0xBC29,0xC694,0xBBF8,0xD61C,
    0xC815,0xD45C,0xC81C,0xB355,0xC9D5,0xC9D5,0xBCC4,0xB355,
    0xC885,0xCCA0,0xC694,0xC678,0xC694,0xD718,0xBBF8,0xB8E1,
    0xC591,0xD3EC,0xAD6C,0xC2EC,0xC2EC,0xD544,0xC5B5,0xB975,
    0xC778,0xB3C4,0xC815,0xAC1C,0xAE30,0xC778,0xC778,0xCC9C,
    0xD0D0,0xD2B9,0xD2B9,0xAC04,0xD758,0xD0DC,0xCD0C,0xC9C0,
    0xB9DD,0xB9DD,0xD61C,0xBC94,0xC751,0xCCA8,0xBBFC,0xBBFC,
    0xCDA9,0xCDA9,0xC624,0xAE09,0xC624,0xD76C,0xAC1C,0xC6B0,
    0xC644,0xCD1D,0xC885,0xCF8C,0xC5EC,0xBCC0,0xAE30,0xC9C0,
    0xCDCC,0xCE68,0xD0DC,0xB3C8,0xAC80,0xB150,0xD63C,0xD749,
    0xB274,0xC655,0xD5D8,0xD754,0xAC15,0xD640,0xD788,0xBD84,
    # 0x6000 #
    0xBD80,0xD0DC,0xC885,0xBB34,0xC6B0,0xCC3D,0xCC3D,0xAC70,
    0xC608,0xD3EC,0xCD08,0xBBFC,0xBE44,0xC791,0xC998,0xC559,
    0xAD6C,0xBC18,0xB178,0xB178,0xC815,0xD30C,0xD3EC,0xCCA9,
    0xACE0,0xD638,0xC800,0xB2EC,0xB839,0xC0AC,0xC8FC,0xC81C,
    0xD0DC,0xC774,0xB3CC,0xC6B0,0xBD80,0xAE09,0xD3C9,0xC131,
    0xC6D0,0xB2C8,0xAD34,0xBD88,0xD76C,0xD544,0xC720,0xAC81,
    0xD604,0xCD1D,0xBCD1,0xD669,0xC6D4,0xCD9C,0xD53C,0xCD9C,
    0xC2E4,0xD0C4,0xC601,0xCD1D,0xB300,0xB9D0,0xAE30,0xC5ED,
    0xCE58,0xC784,0xC21C,0xC2DC,0xD790,0xB85C,0xD56D,0xAD11,
    0xBAA8,0xC9C0,0xD611,0xB828,0xC870,0xD669,0xC9C8,0xD638,
    0xACF5,0xADA4,0xD56D,0xC11C,0xAD50,0xC11C,0xC0AC,0xACFC,
    0xADDC,0xC591,0xC5D0,0xD68C,0xCE59,0xAD04,0xC774,0xD749,
    0xAD34,0xB9B0,0xD68C,0xC790,0xD73C,0xCE58,0xC0C1,0xB275,
    0xD55C,0xC740,0xAC01,0xD1B5,0xB150,0xACF5,0xC804,0xC2DD,
    0xD761,0xC5F4,0xBCD1,0xAC04,0xB355,0xD61C,0xC545,0xADDC,
    0xD1B5,0xC5FC,0xAC1C,0xCE21,0xB1CC,0xC6B4,0xB9DD,0xC6A9,
    # 0x6080 #
    0xC6A9,0xC5F0,0xBE44,0xACE4,0xCD08,0xC5F4,0xC5EC,0xC11C,
    0xACC4,0xC2E4,0xCCA0,0xB9B0,0xC81C,0xD55C,0xD638,0xD611,
    0xCC99,0xD3EC,0xC74D,0xACAC,0xD68C,0xD76C,0xD328,0xBB38,
    0xC608,0xD615,0xC1A1,0xC804,0xC815,0xB9AC,0xC624,0xC624,
    0xC720,0xB9AC,0xB7C9,0xD658,0xCD1D,0xC5B5,0xC5F4,0xB9AC,
    0xB2C8,0xB1CC,0xC545,0xAC01,0xD604,0xAC04,0xC624,0xBBFC,
    0xC885,0xBE44,0xBE44,0xB355,0xCDCC,0xCC3D,0xBBFC,0xB824,
    0xACC4,0xAD00,0xAD00,0xD589,0xB3C4,0xCC98,0xACF5,0xCCA8,
    0xB860,0xC11D,0xAC10,0xACE4,0xB141,0xC815,0xCD94,0xB3C8,
    0xACFC,0xCCA8,0xB7C9,0xC644,0xC6D0,0xAE08,0xAE30,0xB78C,
    0xCC3D,0xD639,0xD654,0xAD8C,0xB2F4,0xCC99,0xCC99,0xB151,
    0xB9DD,0xCCA0,0xD640,0xD63C,0xC11D,0xCC3D,0xD754,0xC720,
    0xD61C,0xC545,0xC1C4,0xCD1D,0xD604,0xC218,0xC810,0xAD6C,
    0xCC38,0xC9D5,0xB355,0xBE44,0xD611,0xCC38,0xD0C4,0xAD00,
    0xD0C0,0xB1CC,0xC6B4,0xC0C1,0xCDCC,0xCCA9,0xD669,0xC900,
    0xACBD,0xC57C,0xC131,0xCE21,0xD3B8,0xD63C,0xC218,0xC81C,
    # 0x6100 #
    0xCD08,0xC218,0xBC1C,0xC120,0xC678,0xACA9,0xAC74,0xC704,
    0xC720,0xC720,0xD54D,0xD6E4,0xD658,0xBBFC,0xD345,0xC758,
    0xBA74,0xC6A9,0xAC8C,0xC0C1,0xC74C,0xC545,0xC2EC,0xBB34,
    0xAC00,0xAC01,0xC6B0,0xC560,0xD611,0xC5B8,0xC5F0,0xAC10,
    0xC628,0xCD1D,0xC0C8,0xB989,0xBD84,0xC601,0xADA4,0xAD34,
    0xAC01,0xACF5,0xC6B4,0xC18C,0xC18C,0xAE30,0xC694,0xC1A1,
    0xD669,0xC9C8,0xACE8,0xAD6C,0xCC3D,0xB2C9,0xD611,0xAC1C,
    0xC815,0xC6A9,0xCD08,0xC190,0xC2E0,0xBC15,0xAC1C,0xC6D0,
    0xD574,0xD754,0xC6A9,0xC559,0xB960,0xC18C,0xB3C4,0xC740,
    0xC790,0xD735,0xACB8,0xD0DC,0xD669,0xC628,0xC2E0,0xBA85,
    0xACF5,0xC12D,0xC885,0xD45C,0xBAA8,0xBAA8,0xAD35,0xCE59,
    0xCC38,0xCC38,0xCC38,0xCD5C,0xBBFC,0xD2B9,0xC7A5,0xD1B5,
    0xC624,0xC0C1,0xB9CC,0xAD00,0xAC01,0xC870,0xAD6C,0xD61C,
    0xAC1C,0xB828,0xC6B0,0xC885,0xADFC,0xC740,0xB824,0xC0C1,
    0xC704,0xB2E8,0xB9CC,0xAC04,0xC2B5,0xC6A9,0xACBD,0xAC15,
    0xC81C,0xC9D1,0xB8E8,0xAD8C,0xCC99,0xCC99,0xC695,0xBE59,
    # 0x6180 #
    0xB8CC,0xCD1D,0xC6B0,0xC6A9,0xCE58,0xD1B5,0xB2F9,0xAC8C,
    0xD5C8,0xD33D,0xBE44,0xBCC4,0xC21C,0xAD50,0xC99D,0xC81C,
    0xB828,0xBE59,0xADA4,0xD61C,0xCD08,0xC9D5,0xC740,0xC740,
    0xD76C,0xD76C,0xD0C4,0xB2F4,0xD0C0,0xB300,0xB300,0xC18D,
    0xAD90,0xCC45,0xD6A8,0xBC18,0xBD84,0xB85C,0xB85C,0xB3D9,
    0xAC10,0xAC8C,0xD55C,0xBBFC,0xACBD,0xB8CC,0xBB34,0xCC38,
    0xD73C,0xCD94,0xD5CC,0xC2EC,0xC2B9,0xBCBD,0xC5B5,0xCD08,
    0xC12C,0xB1CC,0xB2F4,0xD0C4,0xACBD,0xC1A1,0xAC10,0xC694,
    0xC678,0xD658,0xB3D9,0xADFC,0xADFC,0xAC70,0xC870,0xAC04,
    0xD574,0xC751,0xC624,0xBB34,0xC5ED,0xB984,0xC0C9,0xC900,
    0xD68C,0xBB38,0xB77C,0xC560,0xB984,0xC5FC,0xAD04,0xD558,
    0xCCB4,0xC5EC,0xC740,0xB300,0xBABD,0xC560,0xBABD,0xB300,
    0xC81C,0xB9C8,0xB78C,0xBB38,0xC8FC,0xCE58,0xB098,0xB098,
    0xC5FC,0xC591,0xBC15,0xCE58,0xAD11,0xAD11,0xC6B0,0xBD80,
    0xB958,0xBA78,0xC9D5,0xD61C,0xCC38,0xBABD,0xB77C,0xD68C,
    0xD604,0xC591,0xCC38,0xAE30,0xAD6C,0xD658,0xC12D,0xC758,
    # 0x6200 #
    0xB828,0xB09C,0xB9C8,0xB2F9,0xD655,0xB2F9,0xB2F9,0xB2F9,
    0xACFC,0xC6D4,0xBB34,0xC794,0xC220,0xC218,0xC735,0xD76C,
    0xC131,0xC544,0xACC4,0xAC00,0xC794,0xC7A5,0xD639,0xCC3D,
    0xC804,0xB3D9,0xCC99,0xC54C,0xC9C8,0xC801,0xC54C,0xADF9,
    0xC2DC,0xAC10,0xC9D1,0xADDC,0xAC1C,0xB4F1,0xC804,0xCC3D,
    0xAC00,0xC804,0xC808,0xC5ED,0xC804,0xC778,0xB959,0xD76C,
    0xC804,0xD76C,0xD76C,0xCC29,0xB300,0xAD6C,0xD638,0xD638,
    0xD638,0xC561,0xC0AC,0xD0DC,0xBB18,0xD638,0xB824,0xBC29,
    0xC18C,0xD3B8,0xC810,0xACBD,0xC0C1,0xC774,0xC758,0xC120,
    0xD638,0xBE44,0xC5FC,0xC218,0xC218,0xC7AC,0xCC30,0xAD6C,
    0xB975,0xBCF5,0xBC30,0xD0C0,0xC789,0xBD88,0xC785,0xC7AC,
    0xD0C1,0xC7A5,0xC791,0xAC15,0xC6B0,0xC6B0,0xD55C,0xC2E0,
    0xCC28,0xD0C0,0xD758,0xAD6C,0xC62C,0xB3C8,0xCC9C,0xC9D1,
    0xC778,0xD655,0xBB38,0xC18C,0xC591,0xB274,0xBD84,0xCC28,
    0xC6B0,0xAE09,0xAE08,0xBC18,0xAC08,0xC5B4,0xBD80,0xC624,
    0xC11D,0xBE44,0xC9C0,0xC790,0xC561,0xB3C8,0xC870,0xC2B9,
    # 0x6280 #
    0xAE30,0xC5F0,0xAD11,0xBCC0,0xCD08,0xAD6C,0xBB38,0xACE8,
    0xC6D4,0xACB0,0xD30C,0xCE68,0xCE68,0xC2B9,0xC6B4,0xC644,
    0xB20C,0xC5B5,0xC11C,0xC870,0xBD80,0xD22C,0xB450,0xD56D,
    0xC808,0xBD80,0xBB34,0xD3EC,0xBC1C,0xC694,0xD0DD,0xB2E8,
    0xAD6C,0xB95C,0xCC3D,0xADE0,0xD638,0xBCF4,0xBCD1,0xC9C0,
    0xD3C9,0xC5FC,0xD3EC,0xD53C,0xD0DC,0xC720,0xC9C4,0xC800,
    0xC559,0xD3EC,0xD558,0xB2C8,0xC124,0xC800,0xC9C8,0xBE44,
    0xC7A1,0xB9D0,0xB9E4,0xC2E0,0xC555,0xCD94,0xAC81,0xBBFC,
    0xCD95,0xAC00,0xBD88,0xC794,0xC8FC,0xB2E8,0xD0C1,0xBB34,
    0xB150,0xB78D,0xBD80,0xD3EC,0xBC18,0xBC15,0xB839,0xB098,
    0xAD34,0xACB8,0xAC70,0xCC99,0xBC1C,0xD0C0,0xD0C0,0xC694,
    0xAD6C,0xC878,0xBCC0,0xCD08,0xBC30,0xBC30,0xC800,0xC758,
    0xAC70,0xD655,0xB871,0xAC04,0xC7A1,0xC639,0xB780,0xB155,
    0xBC1C,0xD0DD,0xCC9C,0xD754,0xAD04,0xC2DD,0xAE38,0xC99D,
    0xB2D8,0xACF5,0xACF5,0xAD8C,0xC804,0xC874,0xCC30,0xACE0,
    0xCE58,0xD611,0xCC45,0xD68C,0xD3C9,0xC608,0xC2B5,0xB098,
    # 0x6300 #
    0xBCBD,0xC9C0,0xAD18,0xC9C8,0xD655,0xD0C0,0xD0C0,0xC9C0,
    0xC124,0xC548,0xB871,0xC9C4,0xACA9,0xAD50,0xACE0,0xB3D9,
    0xB098,0xB3C4,0xB82C,0xCC28,0xB824,0xC811,0xC54C,0xACB0,
    0xB82C,0xAC70,0xC9C0,0xB828,0xC544,0xACFC,0xB2EC,0xD611,
    0xC694,0xB2F9,0xAD50,0xC7C1,0xC81C,0xD63C,0xC7A0,0xC6B0,
    0xC560,0xC138,0xB098,0xC88C,0xBC1C,0xACBD,0xCCB4,0xC9C4,
    0xC815,0xC0AC,0xC0AC,0xACBD,0xB9E4,0xB871,0xAD6D,0xBC29,
    0xACAC,0xC74D,0xC815,0xC5F0,0xB1CC,0xB9CC,0xD611,0xC0BD,
    0xBD09,0xACE4,0xC624,0xAD70,0xAD6C,0xD1B5,0xACE4,0xD601,
    0xB3C4,0xCC29,0xBD80,0xB784,0xD314,0xD55C,0xC18C,0xB0A0,
    0xC5F0,0xCE21,0xC1A1,0xC57C,0xAC01,0xD3EC,0xC644,0xCC99,
    0xC900,0xC608,0xC7AC,0xB824,0xC218,0xD0C8,0xB85C,0xC190,
    0xBCD1,0xAC80,0xD658,0xB3C4,0xBBF8,0xC644,0xAE08,0xBD09,
    0xC0AC,0xB82C,0xBBFC,0xBB38,0xBD80,0xD328,0xAC70,0xB3C4,
    0xC640,0xC560,0xAD8C,0xC545,0xCD1D,0xC804,0xCD94,0xCCA9,
    0xD0DC,0xBD84,0xB0A0,0xB150,0xB1CC,0xC878,0xC54C,0xC11C,
    # 0x6380 #
    0xD754,0xC7C1,0xC810,0xC18C,0xB95C,0xCCAD,0xAC15,0xCCA0,
    0xC218,0xB3C4,0xBD80,0xC800,0xC7A5,0xD63C,0xAE30,0xB3C4,
    0xACB9,0xAE30,0xBC30,0xC219,0xACAC,0xB989,0xC561,0xC544,
    0xAD74,0xC7C1,0xB7C9,0xAD18,0xC608,0xD639,0xC12C,0xC815,
    0xB7B5,0xCC44,0xD0D0,0xCCB4,0xBD95,0xC811,0xCC99,0xACF5,
    0xCD94,0xC5C4,0xC870,0xCD94,0xAD6D,0xCCA8,0xACAC,0xAE0D,
    0xBC30,0xC218,0xAC8C,0xB85C,0xAD35,0xBA85,0xACBD,0xCC99,
    0xD0C4,0xB9F9,0xC12C,0xC18C,0xAD00,0xD33D,0xC5F0,0xB099,
    0xAC04,0xC815,0xCD94,0xC804,0xC720,0xC5F0,0xADDC,0xB0A8,
    0xD6A1,0xC720,0xBCBD,0xC678,0xC2DC,0xC8FC,0xC120,0xBB18,
    0xC81C,0xC5F4,0xC0BD,0xC2DC,0xCD1D,0xCE68,0xC74D,0xC21C,
    0xD669,0xD3B8,0xC591,0xD658,0xC5C4,0xC7A0,0xC554,0xC11C,
    0xC54C,0xC545,0xAC1D,0xCDCC,0xC989,0xCCB4,0xB784,0xB784,
    0xC815,0xAC1C,0xCD94,0xCD94,0xB3CC,0xAC8C,0xD718,0xAE0D,
    0xCDA9,0xC0AD,0xC124,0xC124,0xC6D0,0xAC74,0xC57C,0xC0BD,
    0xC0AC,0xBC30,0xC694,0xBA78,0xCC9C,0xB78C,0xC628,0xD760,
    # 0x6400 #
    0xCC38,0xAC01,0xB8E8,0xCD1D,0xAE0D,0xAD50,0xAD6C,0xAE08,
    0xC6A9,0xAC01,0xCD94,0xCCB4,0xC804,0xC190,0xC190,0xBC15,
    0xD735,0xC6A9,0xBC29,0xCC28,0xC18C,0xAC11,0xC694,0xB3C4,
    0xC9C0,0xB179,0xB78D,0xB834,0xC218,0xAD6C,0xACE0,0xD5CC,
    0xC0AD,0xC0C1,0xC9C4,0xBA78,0xC561,0xCD94,0xB2C9,0xC120,
    0xD0D1,0xAC78,0xB2F9,0xBC18,0xBC18,0xD0D1,0xB960,0xB3C4,
    0xACE8,0xCE58,0xC640,0xD560,0xAC74,0xC628,0xCC3D,0xC804,
    0xC9C4,0xACA9,0xD734,0xB2C9,0xAD8C,0xCC28,0xCC29,0xACA9,
    0xC624,0xC740,0xC12D,0xAC15,0xC12D,0xD130,0xD30C,0xC694,
    0xBE48,0xC218,0xD0C4,0xC0B4,0xC0B0,0xC219,0xADDC,0xC6A9,
    0xCC3D,0xAD35,0xBCD1,0xBD09,0xC194,0xC81C,0xCCB4,0xC218,
    0xC801,0xB828,0xB2F9,0xB9AC,0xAD00,0xB85D,0xB77C,0xB8E8,
    0xCD1D,0xAC1C,0xD638,0xC0AC,0xCC3D,0xD0D5,0xD654,0xCD5C,
    0xB0B4,0xB9C8,0xC7A5,0xADDC,0xC601,0xCC99,0xC624,0xC9C0,
    0xCCB4,0xB9CC,0xCC38,0xAD6C,0xC800,0xC0C9,0xB2E8,0xCD08,
    0xBAA8,0xBAA8,0xC811,0xC12C,0xACBD,0xD45C,0xAC15,0xC74C,
    # 0x6480 #
    0xAD6C,0xACAC,0xB7B5,0xACA9,0xC601,0xADA4,0xB0B4,0xBCC4,
    0xB85C,0xB3C8,0xD55C,0xC5F0,0xADC0,0xC7A0,0xC758,0xC7A0,
    0xD0F1,0xD0F1,0xC0B4,0xC694,0xD6A1,0xC11C,0xAC10,0xAD11,
    0xD0D1,0xC900,0xB144,0xB9B0,0xC99D,0xD718,0xB2F9,0xAD50,
    0xADF9,0xC12C,0xD0D0,0xD0C4,0xCCA0,0xBC1C,0xCC28,0xC808,
    0xCD08,0xB8CC,0xBD84,0xBB34,0xD6A8,0xD30C,0xCD2C,0xCC29,
    0xCC2C,0xD0C0,0xBC15,0xD760,0xB3C8,0xB828,0xD68D,0xD790,
    0xB85C,0xAD50,0xCC2C,0xB2EC,0xAC10,0xAD50,0xACFC,0xAC80,
    0xAC04,0xC639,0xB8B0,0xB0AD,0xB85C,0xCC9C,0xCC29,0xD0DD,
    0xBC15,0xCC29,0xACA9,0xB2F9,0xC0C9,0xC870,0xACBD,0xACBD,
    0xD658,0xC811,0xAE08,0xD68C,0xB2F4,0xD734,0xAC08,0xBCBD,
    0xBCBD,0xC624,0xAC70,0xC5FD,0xC54C,0xB9F9,0xC218,0xBBF8,
    0xC81C,0xB300,0xD0C1,0xB3C4,0xD615,0xB78C,0xCC30,0xAC70,
    0xC57C,0xC720,0xC5FD,0xC5FD,0xC758,0xD654,0xC808,0xBE48,
    0xB155,0xAC01,0xCC99,0xC990,0xD655,0xB9C8,0xC804,0xD790,
    0xB835,0xD0C4,0xD30C,0xC218,0xB85C,0xB825,0xC694,0xC801,
    # 0x6500 #
    0xBC18,0xC591,0xB8B0,0xCC30,0xD130,0xCC2C,0xB828,0xD5CC,
    0xAD70,0xD655,0xB825,0xB784,0xD658,0xC601,0xB85C,0xB871,
    0xAC74,0xAC70,0xCC2C,0xAC74,0xB780,0xC12C,0xC601,0xBBF8,
    0xC591,0xCC38,0xC601,0xCC2C,0xD734,0xC12D,0xB77C,0xAD70,
    0xBBF8,0xB9AC,0xCC2C,0xB828,0xD0C4,0xCD2C,0xB824,0xC804,
    0xC640,0xB2F9,0xAD50,0xD655,0xB78C,0xB77C,0xB0AD,0xC9C0,
    0xAE30,0xADA4,0xAE30,0xC2EC,0xBCF5,0xBCF5,0xC218,0xACE0,
    0xC720,0xAC1C,0xC774,0xACF5,0xAC04,0xBC18,0xBC29,0xC815,
    0xBC15,0xCCA8,0xAD6C,0xBBFC,0xBB34,0xACE0,0xAC11,0xCC45,
    0xD6A8,0xBBF8,0xCD95,0xACA9,0xD65C,0xC11C,0xAD50,0xBBFC,
    0xC9C4,0xAD6C,0xC2E0,0xD0C8,0xC5B4,0xCE59,0xC624,0xD328,
    0xC11C,0xAD50,0xD0C8,0xB834,0xB151,0xD3D0,0xCC3D,0xC804,
    0xCCA0,0xC774,0xAC10,0xC0B0,0xACFC,0xC5FC,0xB3C8,0xAE30,
    0xD22C,0xD6A8,0xCCA0,0xAD50,0xACBD,0xC591,0xD569,0xBBFC,
    0xC218,0xC560,0xACE0,0xC560,0xC815,0xC801,0xC9C4,0xBD80,
    0xC218,0xB8CC,0xAD6C,0xD604,0xD68C,0xAD50,0xC120,0xAD50,
    # 0x6580 #
    0xD0C1,0xB450,0xB834,0xD3D0,0xD0DC,0xD6A8,0xD6A8,0xBB38,
    0xD559,0xC81C,0xC81C,0xC7AC,0xBE48,0xAC01,0xC7AC,0xB7C9,
    0xBE44,0xBC18,0xBC18,0xB780,0xC720,0xB780,0xBBF8,0xB450,
    0xC2B9,0xB8CC,0xAC00,0xACE1,0xC0AC,0xAC00,0xC720,0xC9D0,
    0xAC01,0xC54C,0xC8FC,0xCD95,0xADFC,0xCC99,0xC740,0xBD80,
    0xC7A5,0xCC38,0xAD6C,0xC791,0xCC38,0xB2E8,0xCC29,0xC0AC,
    0xC2E0,0xC791,0xCC29,0xADFC,0xB9B0,0xCC29,0xCD09,0xB2E8,
    0xCD09,0xBC29,0xAC1C,0xD56D,0xC5B4,0xC2DC,0xD328,0xC720,
    0xBA70,0xBC29,0xAE30,0xC804,0xBAA8,0xB824,0xD328,0xD53C,
    0xB958,0xBD80,0xBC29,0xC120,0xC815,0xC815,0xB2C8,0xC871,
    0xC870,0xC758,0xB958,0xC18C,0xAC74,0xC5C7,0xC758,0xAE30,
    0xCE58,0xBC88,0xD45C,0xBC88,0xC804,0xAD34,0xC218,0xC5EC,
    0xBB34,0xAE30,0xAE30,0xAE30,0xD654,0xC77C,0xB2E8,0xAD6C,
    0xC9C0,0xC870,0xD611,0xB3C4,0xC21C,0xC6B1,0xC6B1,0xB77C,
    0xAC04,0xD55C,0xB300,0xC801,0xC6B0,0xCC38,0xC2DC,0xAD11,
    0xC591,0xC2DC,0xC655,0xBBFC,0xBBFC,0xB3C8,0xCD98,0xC624,
    # 0x6600 #
    0xC724,0xD328,0xC559,0xCE21,0xD310,0xAC81,0xACE4,0xC2B9,
    0xD638,0xBC29,0xD638,0xACC4,0xCC3D,0xD6E4,0xBA85,0xD63C,
    0xBD84,0xAE08,0xBB3C,0xC5ED,0xC11D,0xD754,0xC5F0,0xCE21,
    0xBC29,0xC695,0xC2E0,0xAC70,0xC591,0xC7A0,0xBCD1,0xC131,
    0xC601,0xD604,0xBD88,0xC9C4,0xB839,0xCD98,0xD638,0xB9E4,
    0xC791,0xB9D0,0xBCC0,0xAD6C,0xD63C,0xC18C,0xC885,0xC2DC,
    0xD558,0xC6B1,0xBE44,0xC9C8,0xBB18,0xB2D0,0xCC3D,0xC628,
    0xB3D9,0xC560,0xBCD1,0xC559,0xC8FC,0xB871,0xD604,0xAD11,
    0xC870,0xC870,0xC2DC,0xD669,0xD669,0xD6E4,0xAD34,0xACFC,
    0xAD50,0xC9C4,0xC9C8,0xC9C4,0xC0C1,0xB3D9,0xD64D,0xC548,
    0xD574,0xD5A5,0xC1C4,0xD6A8,0xC5FD,0xD6C8,0xD718,0xD568,
    0xD55C,0xC900,0xB9CC,0xD604,0xACE4,0xC8FC,0xD76C,0xC131,
    0xC131,0xD3EC,0xC808,0xC808,0xC624,0xD658,0xD68C,0xD638,
    0xC2E0,0xB9CC,0xC804,0xD0C1,0xC218,0xC8FC,0xBCF4,0xACBD,
    0xC11D,0xC12C,0xC608,0xC11D,0xCCAD,0xACC4,0xC815,0xADC0,
    0xC815,0xC5ED,0xC9C0,0xC554,0xC6D0,0xB9BC,0xB7C9,0xCC3D,
    # 0x6680 #
    0xC655,0xD6A8,0xC7A0,0xBE44,0xD6E4,0xD658,0xC774,0xAC00,
    0xD6C8,0xD718,0xBD80,0xBBFC,0xADDC,0xAC08,0xC601,0xB3C4,
    0xC704,0xC11C,0xCCAD,0xBB34,0xB0A8,0xAC04,0xB09C,0xC554,
    0xC591,0xCD98,0xC694,0xCC28,0xBCF4,0xBA85,0xAD50,0xAC1C,
    0xACE0,0xC639,0xCC3D,0xAE30,0xD638,0xC548,0xB825,0xC560,
    0xAE30,0xACC4,0xBB38,0xC7A0,0xC124,0xD638,0xBAA8,0xB9C9,
    0xC885,0xB2D0,0xC7A5,0xD61C,0xD3ED,0xD55C,0xC120,0xC804,
    0xB8CC,0xC12C,0xD0C4,0xACBD,0xBCC4,0xB9B0,0xB3C8,0xD76C,
    0xC5D0,0xAE30,0xD669,0xD0DC,0xC5FD,0xC5FD,0xB825,0xB2F4,
    0xB3D9,0xD6A8,0xBE44,0xB2F4,0xC870,0xD638,0xC5ED,0xD5A5,
    0xC131,0xC0BC,0xAD50,0xD3EC,0xACBD,0xC5FC,0xC560,0xC5FD,
    0xC720,0xC11C,0xBABD,0xD6C8,0xC694,0xD3ED,0xB824,0xC2E0,
    0xAD11,0xCCA9,0xB8CC,0xC5F0,0xD655,0xB824,0xD76C,0xC735,
    0xB871,0xB0AD,0xB77C,0xB780,0xC1C4,0xB2F9,0xC5C4,0xCD09,
    0xC648,0xC555,0xACE1,0xC608,0xACBD,0xC608,0xD640,0xAC08,
    0xC11C,0xC870,0xC870,0xCC9C,0xB9CC,0xC99D,0xC99D,0xCCB4,
    # 0x6700 #
    0xCD5C,0xCC38,0xC6B1,0xD68C,0xC778,0xAC78,0xBD84,0xBE44,
    0xC6D4,0xC720,0xC6D0,0xBD95,0xBC18,0xBCF5,0xB839,0xAD74,
    0xAD6C,0xC138,0xB275,0xC870,0xC0AD,0xC9D0,0xB791,0xB791,
    0xC804,0xBA85,0xD669,0xB9DD,0xB3C8,0xC870,0xAE30,0xAE30,
    0xC601,0xC885,0xB9DD,0xB3D9,0xB791,0xB85C,0xBABD,0xB871,
    0xBAA9,0xBE48,0xBBF8,0xB9D0,0xBCF8,0xCC30,0xCD9C,0xCD9C,
    0xBAB0,0xC8FC,0xC778,0xD314,0xBC15,0xD0C0,0xD0C0,0xB3C4,
    0xB825,0xAD6C,0xADA4,0xADDC,0xBE44,0xD6C4,0xC815,0xC790,
    0xC0B4,0xC785,0xC7A1,0xAD8C,0xCC9C,0xC6B0,0xAC04,0xC624,
    0xCC28,0xC0BC,0xC21C,0xBC94,0xC62C,0xC790,0xB9AC,0xD589,
    0xC7AC,0xCD0C,0xC778,0xD45C,0xD0C1,0xCCB4,0xC7A5,0xB9DD,
    0xCE58,0xC775,0xACE8,0xAD81,0xB450,0xC774,0xAE30,0xC18D,
    0xAC15,0xC870,0xBAA9,0xC0B0,0xD68C,0xB798,0xAD6C,0xB9DD,
    0xC591,0xB9C8,0xCD08,0xC9C0,0xC6D0,0xD56D,0xD3D0,0xBC30,
    0xAC78,0xB3D9,0xACE0,0xBB18,0xD5D8,0xC800,0xCD98,0xD30C,
    0xC218,0xD654,0xC2EC,0xB274,0xC800,0xCD98,0xC1A1,0xD310,
    # 0x6780 #
    0xC1A1,0xAC81,0xC6D4,0xC9C4,0xAD6C,0xACC4,0xBAA8,0xBE44,
    0xBE44,0xC655,0xC559,0xBC29,0xBD84,0xC608,0xBD80,0xB0A8,
    0xC11D,0xD638,0xC57C,0xB450,0xC2EC,0xCE68,0xC694,0xB9BC,
    0xC608,0xC640,0xB9E4,0xC870,0xACFC,0xC9C0,0xC885,0xC6B4,
    0xD654,0xC2B9,0xCD94,0xC870,0xACAC,0xB825,0xD638,0xACAC,
    0xC815,0xC1A1,0xCC3D,0xD48D,0xB2E8,0xD6A8,0xCE68,0xACE0,
    0xD3C9,0xC774,0xC2DC,0xC9C0,0xAD18,0xD6A8,0xAC00,0xAC00,
    0xAD6C,0xD3EC,0xB9D0,0xC124,0xC5FD,0xC5FD,0xC2DC,0xC5BC,
    0xD53C,0xD0C0,0xC774,0xB839,0xBCD1,0xB2C8,0xB78D,0xD654,
    0xBC18,0xBC94,0xC885,0xB300,0xC0AC,0xC601,0xBD80,0xBC31,
    0xBAA8,0xAC10,0xCE60,0xC5FC,0xC720,0xBB34,0xC18C,0xC1A1,
    0xC790,0xD569,0xC720,0xC2E0,0xAC70,0xD0C1,0xC791,0xB0A8,
    0xC800,0xC601,0xC800,0xC9C8,0xC0AC,0xC0AC,0xB2E8,0xACE0,
    0xD3EC,0xAD6C,0xC694,0xBD88,0xAC04,0xBC1C,0xB3CC,0xAC00,
    0xB0B4,0xC8FC,0xBE44,0xB958,0xC2DC,0xCC45,0xC0AC,0xCD95,
    0xBC30,0xC2DC,0xAD18,0xC0AC,0xC694,0xC815,0xC815,0xC2DC,
    # 0x6800 #
    0xCE58,0xB958,0xBAA8,0xD68C,0xC601,0xCC45,0xC870,0xD45C,
    0xC794,0xC990,0xB871,0xB3D9,0xB85C,0xC0DD,0xB825,0xB780,
    0xC601,0xC218,0xC21C,0xC804,0xACC4,0xC815,0xC11C,0xB960,
    0xCCB4,0xD56D,0xC9D0,0xB824,0xC0C9,0xAD04,0xAC04,0xBCD1,
    0xC784,0xAD50,0xBC31,0xC784,0xD48D,0xC790,0xC218,0xC608,
    0xCC28,0xD5C8,0xC8FC,0xCC9C,0xC81C,0xC774,0xC774,0xC6B1,
    0xBC8C,0xACF5,0xACE0,0xB85C,0xC804,0xB82C,0xD575,0xC591,
    0xD575,0xADFC,0xC9C0,0xC2DD,0xACA9,0xC7AC,0xB780,0xBCF5,
    0xAC78,0xD56D,0xACC4,0xB3C4,0xAD11,0xC678,0xAD11,0xC5EC,
    0xC548,0xC548,0xAD8C,0xC774,0xD0C1,0xACE0,0xC9C8,0xACF5,
    0xB3D9,0xC0C1,0xC0C1,0xD658,0xAE38,0xAD6C,0xD608,0xD0C0,
    0xD1F4,0xC6B0,0xCC30,0xC0C1,0xC575,0xC2B9,0xC11D,0xC794,
    0xC544,0xC694,0xC815,0xB2F9,0xAE30,0xAD50,0xD654,0xD68C,
    0xC7A5,0xC7A5,0xC2EC,0xC0AC,0xC0AC,0xC9C4,0xBC30,0xC815,
    0xAD04,0xACBD,0xBC1C,0xBD84,0xBD80,0xC720,0xD1B5,0xAC01,
    0xD76C,0xB791,0xB958,0xBD09,0xCE60,0xC628,0xAD70,0xAC04,
    # 0x6880 #
    0xC18D,0xB7C9,0xAD6C,0xC815,0xC720,0xB9E4,0xBC29,0xB871,
    0xD33D,0xC7A5,0xC81C,0xD604,0xB3C4,0xC870,0xC694,0xACE1,
    0xD3D0,0xC801,0xD568,0xC7AC,0xCE58,0xC778,0xD328,0xACBD,
    0xACAC,0xD658,0xB9CC,0xB098,0xD611,0xC870,0xAE30,0xD6A8,
    0xB824,0xC644,0xCD08,0xC2EC,0xBD84,0xC1A1,0xBABD,0xC624,
    0xB9AC,0xB9AC,0xB450,0xCE68,0xC601,0xC0AC,0xAD6D,0xC81C,
    0xACC4,0xACE4,0xD0C8,0xC18C,0xCC9C,0xBC94,0xBBF8,0xC815,
    0xB9AC,0xBE48,0xB85D,0xBD88,0xB3C4,0xC9C0,0xB798,0xB828,
    0xAC80,0xC808,0xB839,0xB9AC,0xAE30,0xBCD1,0xB95C,0xCD1D,
    0xCC9C,0xBA74,0xAE30,0xAE30,0xCC44,0xACE4,0xC12C,0xB4DD,
    0xBE44,0xD328,0xBD09,0xBD80,0xD63C,0xC885,0xC815,0xC870,
    0xADF9,0xB824,0xBD95,0xC721,0xC5B4,0xACE0,0xACE4,0xB3D9,
    0xB2F9,0xAC15,0xB9DD,0xCCB4,0xC11D,0xBC88,0xC7C1,0xC794,
    0xACC4,0xC5F0,0xC5FC,0xC5ED,0xAD8C,0xC5ED,0xC0BC,0xC784,
    0xCD94,0xB989,0xC11C,0xC808,0xBCF5,0xACFC,0xB798,0xCD94,
    0xCD94,0xB3C4,0xAD00,0xBD84,0xBD84,0xB9BC,0xACBD,0xC608,
    # 0x6900 #
    0xC644,0xACFD,0xB85D,0xD638,0xC811,0xC758,0xC8FC,0xAD6C,
    0xAD6D,0xC2B9,0xC878,0xB7C9,0xAC15,0xC2DD,0xCD94,0xC544,
    0xAC70,0xBE44,0xCD08,0xD0C1,0xCE58,0xBE48,0xBD95,0xC815,
    0xCD08,0xCC3D,0xB975,0xD654,0xAC80,0xADDC,0xC2ED,0xB3C5,
    0xCC38,0xB3C4,0xADC0,0xC804,0xB77C,0xC9C0,0xAD8C,0xBA85,
    0xBD80,0xACBD,0xBCD1,0xC804,0xC758,0xD0C0,0xC0BC,0xD0C0,
    0xC57C,0xBCF5,0xD718,0xC678,0xB2E8,0xAC00,0xC885,0xAC10,
    0xC774,0xCE68,0xBCF4,0xC5B8,0xC5F0,0xC5F0,0xC804,0xCD98,
    0xC6B0,0xACA9,0xC0AC,0xC545,0xD3B8,0xBCF5,0xC694,0xD654,
    0xC11C,0xC57D,0xC591,0xB784,0xC548,0xBCF8,0xD718,0xADDC,
    0xACC4,0xADDC,0xC0AC,0xD48D,0xC124,0xD0C0,0xC990,0xAC74,
    0xBAA9,0xBB34,0xCD08,0xACE0,0xD638,0xB828,0xB989,0xC815,
    0xB0A8,0xC720,0xC720,0xBBF8,0xC1A1,0xC6D0,0xD6E4,0xC601,
    0xC815,0xD3B8,0xC811,0xC999,0xAC08,0xC5C5,0xC800,0xC21C,
    0xC720,0xC8FC,0xC704,0xB9E4,0xCCB4,0xADF9,0xC808,0xD574,
    0xCD94,0xC601,0xC720,0xD669,0xB8E8,0xC545,0xCC9C,0xD5A5,
    # 0x6980 #
    0xD488,0xC2E4,0xAC1C,0xD5D8,0xB78C,0xC628,0xC720,0xCE5C,
    0xB824,0xAC70,0xC2E0,0xCD94,0xBE44,0xC124,0xAC00,0xC775,
    0xC804,0xBD80,0xB158,0xD544,0xB791,0xC6A9,0xACE1,0xC9C4,
    0xAD6C,0xB2F5,0xC694,0xC9C4,0xBC29,0xC0B4,0xC6D0,0xC7AC,
    0xBA85,0xC18C,0xAC00,0xC694,0xAC78,0xD669,0xAC04,0xBE44,
    0xC790,0xAC74,0xB9C8,0xC21C,0xC6D0,0xC0AC,0xC601,0xC2DC,
    0xC9C0,0xCD5C,0xC628,0xC815,0xB958,0xC6A9,0xB2F9,0xAD50,
    0xCC44,0xC0AC,0xC2B9,0xD0D1,0xD569,0xD61C,0xACE8,0xAE30,
    0xACE0,0xACE0,0xC190,0xBC18,0xB3C4,0xB3C4,0xC21C,0xC804,
    0xB204,0xC9C8,0xC0AD,0xAD6C,0xD1F4,0xCC3D,0xCC28,0xACB8,
    0xAD34,0xB9E4,0xD735,0xACF5,0xACE0,0xD0C1,0xD0C1,0xAD50,
    0xC591,0xC804,0xAC00,0xD568,0xCDE8,0xB3C4,0xB871,0xBE48,
    0xC800,0xC0C1,0xC2B5,0xAE30,0xB828,0xD61C,0xC6A9,0xCC38,
    0xACFD,0xAC1C,0xAC1C,0xB2E8,0xD654,0xC0C9,0xC0BC,0xCD5C,
    0xBD09,0xC720,0xACE1,0xC7A5,0xD638,0xD658,0xADC0,0xC5BC,
    0xC608,0xACE0,0xAC15,0xADDC,0xADDC,0xC870,0xB9CC,0xADFC,
    # 0x6A00 #
    0xC801,0xC7A5,0xC545,0xB791,0xC9C4,0xC885,0xB9AC,0xC218,
    0xACBD,0xC0C1,0xBC88,0xD1B5,0xAD00,0xC801,0xCD9C,0xB958,
    0xB85C,0xB7C9,0xBC00,0xB8E8,0xC18C,0xC18D,0xAC00,0xC800,
    0xD0F1,0xD45C,0xB85D,0xADDC,0xC790,0xC0AC,0xCD94,0xC7A5,
    0xB9CC,0xBAA8,0xC870,0xC591,0xC870,0xBD09,0xC8FC,0xC0B4,
    0xC11C,0xAD8C,0xD6A1,0xACAC,0xCD1D,0xAE30,0xC5F0,0xC7A5,
    0xC124,0xC575,0xC774,0xC2EC,0xC9C1,0xCD08,0xCD5C,0xCD1D,
    0xBC15,0xC218,0xD654,0xADA4,0xC9C4,0xC900,0xC6D4,0xC804,
    0xD61C,0xCD98,0xC874,0xBC8C,0xAC10,0xBAA8,0xBB34,0xCDE8,
    0xC694,0xB9B0,0xB958,0xAD50,0xD55C,0xC724,0xBC88,0xC804,
    0xD0C1,0xB8CC,0xC6B4,0xC21C,0xB3C8,0xD0F1,0xD0F1,0xB9F9,
    0xADE4,0xB4F1,0xC219,0xAD90,0xAD90,0xB2F4,0xD61C,0xAE30,
    0xB098,0xC0C1,0xD0C0,0xB155,0xC608,0xC800,0xB3D9,0xC99D,
    0xBD84,0xACBD,0xC5F0,0xD6A1,0xC2EC,0xACE0,0xB958,0xB85C,
    0xACE0,0xC8FC,0xD76C,0xC2B9,0xC790,0xC0B0,0xADF9,0xB450,
    0xC815,0xB85C,0xD55C,0xCD94,0xC5F0,0xB2EC,0xC218,0xAC15,
    # 0x6A80 #
    0xB2E8,0xB984,0xB18D,0xC740,0xACA9,0xC138,0xC0BC,0xCDE8,
    0xC120,0xC815,0xAC04,0xAD6D,0xC8C4,0xC5B5,0xAE08,0xBC15,
    0xCCA8,0xB8B0,0xD48D,0xD6FC,0xB2F9,0xACC4,0xC218,0xBCBD,
    0xBCBD,0xC815,0xCD08,0xACFC,0xD68C,0xC999,0xD574,0xAC00,
    0xACBD,0xC11D,0xAC80,0xC7A5,0xB3C4,0xC758,0xD45C,0xC1A1,
    0xC591,0xB984,0xB825,0xCC30,0xBABD,0xC740,0xB3C4,0xB300,
    0xBA74,0xAE30,0xB2E8,0xBE48,0xD655,0xACC4,0xC5FC,0xB2C8,
    0xB155,0xC758,0xACE0,0xD568,0xC740,0xB204,0xACBD,0xC5FC,
    0xAE30,0xBC00,0xB3C4,0xADA4,0xCD98,0xC81C,0xAD34,0xD30C,
    0xB4F1,0xC8FC,0xAC01,0xBA74,0xC6B0,0xC9C8,0xD669,0xCC9C,
    0xB8E8,0xB8B0,0xCC30,0xB85C,0xB840,0xCC2C,0xB824,0xBA78,
    0xD61C,0xC6B0,0xB824,0xC990,0xACE0,0xB3C5,0xC5F0,0xB825,
    0xD3D0,0xC800,0xC218,0xB828,0xC804,0xC8FC,0xACBD,0xC800,
    0xB85C,0xC5FC,0xB825,0xC800,0xCE5C,0xAC78,0xC545,0xC18C,
    0xD68C,0xC5BC,0xC5EC,0xB871,0xB8B0,0xCD08,0xD5CC,0xADC0,
    0xAC70,0xC18C,0xB839,0xC575,0xCCA8,0xC740,0xC720,0xC601,
    # 0x6B00 #
    0xC591,0xB18D,0xBC15,0xCC38,0xB780,0xAC70,0xC30D,0xC12D,
    0xCDE8,0xCD1D,0xAD8C,0xAD6C,0xC7A5,0xAD6C,0xC6B8,0xB77C,
    0xB824,0xCC2C,0xB780,0xB2F9,0xACFD,0xC5C4,0xB78C,0xB780,
    0xCD09,0xB958,0xB840,0xD30C,0xB0AD,0xC6B8,0xB839,0xAD00,
    0xD760,0xCC28,0xD658,0xD754,0xC5EC,0xC728,0xD568,0xAD6C,
    0xAD6C,0xCD08,0xCD9C,0xACA9,0xD574,0xC778,0xAD90,0xD790,
    0xC220,0xD569,0xC695,0xAD34,0xB791,0xAD00,0xC218,0xD76C,
    0xC560,0xC758,0xAE30,0xD6CC,0xCD5C,0xD760,0xAD00,0xAC10,
    0xAD00,0xAC10,0xCC9C,0xC0BD,0xACFC,0xC778,0xD760,0xD5D0,
    0xC720,0xACB8,0xD6A8,0xC774,0xAC00,0xC624,0xD0C4,0xADFC,
    0xAD6C,0xD638,0xC801,0xD658,0xD5C8,0xBD84,0xD76C,0xC18C,
    0xD6CC,0xD761,0xC120,0xAC10,0xCD09,0xC5ED,0xC74D,0xC5EC,
    0xCCA0,0xD658,0xC9C0,0xC815,0xCC28,0xBCF4,0xBB34,0xAE30,
    0xBCF4,0xBCF4,0xC65C,0xAC70,0xC804,0xCE58,0xC0C9,0xCE58,
    0xC0BD,0xC885,0xC138,0xC138,0xB825,0xC0C9,0xC6B0,0xB825,
    0xADC0,0xC54C,0xC54C,0xC0AC,0xC12C,0xBAB0,0xBAB0,0xBAB0,
    # 0x6B80 #
    0xC694,0xBAB0,0xC870,0xC559,0xC9C4,0xC0DD,0xD0DC,0xC0C1,
    0xD601,0xC21C,0xC218,0xC794,0xACBD,0xD45C,0xACB9,0xAD6C,
    0xC18D,0xAE0D,0xC6B4,0xC5FC,0xC774,0xBD80,0xC2DD,0xC5C5,
    0xC794,0xD63C,0xD0C4,0xADF9,0xC5FD,0xC9C4,0xC6B4,0xC628,
    0xCD94,0xBE48,0xCCB4,0xADFC,0xC0C1,0xC778,0xC870,0xCD95,
    0xADA4,0xCC2C,0xC5D0,0xD0C4,0xB450,0xAC15,0xB834,0xBE48,
    0xB3C5,0xC12C,0xC12C,0xC218,0xAD6C,0xB2E8,0xC8FC,0xC740,
    0xC131,0xC608,0xC0B4,0xAC01,0xAC01,0xD6A8,0xC900,0xC804,
    0xD6FC,0xD6FC,0xACE1,0xAC01,0xACA9,0xC758,0xAD6C,0xD6FC,
    0xB2E8,0xC758,0xD6A8,0xBB34,0xAD00,0xBAA8,0xB9E4,0xB9E4,
    0xC560,0xC790,0xB3C5,0xC721,0xBE44,0xD544,0xBE44,0xBE44,
    0xBE44,0xD3D0,0xCC38,0xBAA8,0xC18C,0xC0BC,0xBE44,0xBAA8,
    0xAC00,0xC804,0xC2DC,0xBAA9,0xD0C0,0xC21C,0xC774,0xC735,
    0xC120,0xAD6D,0xBAA8,0xD638,0xAD6C,0xB450,0xBAA8,0xB2F4,
    0xBC30,0xAD6D,0xD0C8,0xCDE8,0xBE44,0xC0B0,0xCC38,0xBAA8,
    0xC2DC,0xC720,0xC720,0xD0C0,0xAC08,0xAC74,0xD0D1,0xC0B0,
    # 0x6C00 #
    0xB8E8,0xBAA8,0xB9AC,0xB3D9,0xC6A9,0xCC3D,0xBC29,0xB85C,
    0xC804,0xC18C,0xC804,0xBABD,0xB85C,0xAD6C,0xCCA9,0xC528,
    0xC800,0xBBFC,0xAD90,0xB9F9,0xAE30,0xD53C,0xB0B4,0xAE30,
    0xB3C4,0xC120,0xCC9C,0xBD84,0xC591,0xB0B4,0xBCD1,0xBD88,
    0xC2E0,0xB3D9,0xACBD,0xAE30,0xC778,0xC11C,0xD574,0xC591,
    0xC548,0xC544,0xADF9,0xACBD,0xC544,0xB3D9,0xB2F4,0xB85D,
    0xCCAD,0xC591,0xC628,0xC628,0xC218,0xC218,0xC2B9,0xBE59,
    0xC601,0xB2F9,0xC218,0xB975,0xB2C9,0xD0C4,0xBC94,0xADA4,
    0xC815,0xC999,0xAD6C,0xD314,0xCE21,0xBA74,0xD0C4,0xD718,
    0xC870,0xD55C,0xCC28,0xC791,0xCC9C,0xD658,0xBC94,0xB300,
    0xC11D,0xD0C1,0xB9DD,0xC218,0xD758,0xC0B0,0xD30C,0xD55C,
    0xCC9C,0xC624,0xC624,0xC2E0,0xC0AC,0xC5EC,0xD64D,0xAC15,
    0xC9C0,0xC624,0xD1A0,0xAD6C,0xD0D5,0xC9C0,0xC9C0,0xACAC,
    0xACE8,0xACE8,0xC655,0xC815,0xC815,0xC608,0xADE0,0xAD49,
    0xD0DC,0xACAC,0xAE09,0xBCC0,0xD310,0xAC10,0xBB38,0xC885,
    0xBC29,0xD749,0xACB0,0xC624,0xC6B0,0xAE30,0xBD84,0xC11C,
    # 0x6C80 #
    0xC11C,0xC2EC,0xAE30,0xC625,0xC6B4,0xC6D0,0xD56D,0xC5F0,
    0xCE68,0xCE68,0xD0D0,0xC6B0,0xB3C8,0xD638,0xD654,0xC808,
    0xBAA9,0xB274,0xBAB0,0xB2F5,0xBA74,0xBB3C,0xCDA9,0xCCA8,
    0xBE44,0xC0AC,0xC9C0,0xD328,0xBC18,0xCD94,0xC7A1,0xAD6C,
    0xC870,0xBAB0,0xD0DD,0xD48D,0xAD6C,0xB825,0xB95C,0xCC3D,
    0xD48D,0xADDC,0xD638,0xB9D0,0xB9E4,0xC220,0xC800,0xC11D,
    0xD0C1,0xD0C0,0xD0C0,0xD558,0xB824,0xB824,0xC2DC,0xBC1C,
    0xBE44,0xC720,0xC804,0xCE58,0xC18C,0xACE0,0xCCA8,0xC5F0,
    0xC0AC,0xD669,0xD615,0xAD6C,0xC124,0xC218,0xC77C,0xAC00,
    0xC885,0xCC9C,0xBC15,0xD718,0xD544,0xBD84,0xC0C9,0xCD9C,
    0xB975,0xC720,0xACE0,0xD64D,0xAC10,0xBC95,0xBB18,0xC0AC,
    0xD638,0xD3C9,0xC790,0xBC94,0xC9C0,0xC18C,0xC800,0xC815,
    0xB839,0xD3EC,0xD30C,0xC74D,0xC0AC,0xB2C8,0xAD6D,0xC6D4,
    0xC8FC,0xC0DD,0xB8E8,0xD604,0xD608,0xBD80,0xBC18,0xBBFC,
    0xD0DC,0xC559,0xC81C,0xC601,0xAD00,0xBE59,0xD615,0xB871,
    0xB85C,0xB2E8,0xB77D,0xC0AC,0xBC1C,0xD0DD,0xACBD,0xC740,
    # 0x6D00 #
    0xC8FC,0xAE38,0xC57D,0xD68C,0xD68C,0xC7AC,0xC2B9,0xC778,
    0xC704,0xD6C4,0xCC9C,0xC591,0xB82C,0xC0AC,0xACC4,0xC774,
    0xD589,0xBCF4,0xC138,0xC0C9,0xC9C0,0xC778,0xC624,0xC138,
    0xACE0,0xC218,0xD64D,0xB77D,0xB7B5,0xC548,0xB3D9,0xC774,
    0xBAA8,0xB8B0,0xC774,0xBBF8,0xCC9C,0xC9C4,0xBC31,0xC720,
    0xD6A8,0xC124,0xD64D,0xD601,0xC18D,0xAD11,0xB3C4,0xACB0,
    0xAC70,0xC774,0xC8FC,0xC5EC,0xBCD1,0xC21C,0xD749,0xC9C8,
    0xAD11,0xC6D0,0xBA85,0xD65C,0xC640,0xD761,0xD30C,0xC624,
    0xACE1,0xB958,0xC77C,0xD611,0xC815,0xCC9C,0xC7A5,0xC694,
    0xC815,0xC0AC,0xD0C1,0xCE21,0xBC8C,0xD68C,0xC81C,0xB958,
    0xC0B0,0xD63C,0xD5C8,0xB18D,0xC2EC,0xC9C4,0xB82C,0xAD6C,
    0xBBF8,0xC808,0xC900,0xD568,0xBE48,0xBC29,0xCC29,0xC720,
    0xD76C,0xBC1C,0xB450,0xC644,0xAD49,0xC74D,0xD3EC,0xC601,
    0xB78C,0xD638,0xB791,0xD55C,0xB9AC,0xACBD,0xBD80,0xC624,
    0xB9AC,0xC21C,0xBD09,0xC775,0xC695,0xB3D9,0xB85C,0xD574,
    0xCE68,0xD611,0xCDA9,0xD615,0xB9E4,0xC218,0xC801,0xD328,
    # 0x6D80 #
    0xACAC,0xC0BC,0xB3C4,0xACE4,0xBE59,0xC5F4,0xAC04,0xACBD,
    0xC18C,0xC12D,0xB144,0xB3C5,0xC6A9,0xD6A8,0xC5F0,0xC815,
    0xC544,0xC18D,0xAD70,0xC5F0,0xC7A0,0xCCB4,0xB9AC,0xC138,
    0xC0AC,0xB8E8,0xC138,0xB3C4,0xB3C5,0xB85C,0xB798,0xB828,
    0xC704,0xC640,0xC6B4,0xD658,0xCC99,0xD615,0xC724,0xAC04,
    0xCC3D,0xC0BD,0xBD80,0xAD00,0xD589,0xC218,0xC1C4,0xC560,
    0xCCA0,0xC561,0xC561,0xACF5,0xC644,0xD568,0xD0C0,0xB3D9,
    0xD6C4,0xC640,0xAC70,0xC0AC,0xB7C9,0xD63C,0xB2F5,0xD0C1,
    0xC815,0xCCA9,0xB4DD,0xAD8C,0xCE58,0xC11D,0xD6A8,0xAE30,
    0xAD74,0xACFC,0xD568,0xB9BC,0xCC3D,0xC8FC,0xBD09,0xD638,
    0xCC3D,0xC219,0xCC98,0xBC29,0xCE59,0xB959,0xB1E8,0xAD6D,
    0xB3C4,0xC885,0xB8E8,0xC81C,0xBE59,0xBE44,0xC1A1,0xC804,
    0xBE44,0xB2F4,0xC5ED,0xC608,0xC5B4,0xB85D,0xAC10,0xBC00,
    0xC815,0xB989,0xB95C,0xC74C,0xC26C,0xAC70,0xD68C,0xC721,
    0xC2EC,0xC2EC,0xD45C,0xC21C,0xC62C,0xC5F0,0xB798,0xD63C,
    0xCCAD,0xC5C4,0xCC9C,0xCCA8,0xBB18,0xC9C0,0xC74C,0xBA71,
    # 0x6E00 #
    0xBD84,0xC5F0,0xBB38,0xC57D,0xBE44,0xCCAD,0xC5F0,0xAC08,
    0xC81C,0xC12D,0xC5F0,0xC0BD,0xB85D,0xC9C0,0xB3C5,0xAE30,
    0xC810,0xBBFC,0xBE44,0xBD80,0xC5B4,0xC5F0,0xC2EC,0xC0BC,
    0xC720,0xD658,0xC800,0xAC10,0xB09C,0xD22C,0xCD94,0xC815,
    0xAC70,0xB3C4,0xD48D,0xC0AC,0xBC1C,0xC545,0xC640,0xC81C,
    0xC678,0xC628,0xC720,0xC124,0xCE21,0xC704,0xAC00,0xD56D,
    0xC5C4,0xD64D,0xC120,0xBBF8,0xAC08,0xBB18,0xC601,0xC5F0,
    0xC720,0xAD49,0xBB18,0xC131,0xBBF8,0xC7AC,0xD63C,0xB0B4,
    0xADDC,0xB9BD,0xC545,0xBC30,0xBBF8,0xB828,0xC74D,0xC74D,
    0xB9E4,0xCCA8,0xC8FC,0xC704,0xCC2C,0xB2E8,0xBA74,0xD68C,
    0xBC31,0xC11C,0xC999,0xBD84,0xC804,0xAC74,0xD638,0xBD09,
    0xC0C1,0xC5ED,0xC778,0xB2F4,0xC2DD,0xAC1C,0xC815,0xD669,
    0xD0C4,0xC6B0,0xBCBD,0xBBFC,0xC2DC,0xB3CC,0xC0DD,0xC6A9,
    0xACA9,0xB3D9,0xB2E8,0xCD94,0xCD94,0xCD94,0xC778,0xD0D5,
    0xB96D,0xD68D,0xC6D0,0xB0A8,0xBC24,0xC720,0xCC9C,0xCD98,
    0xB7C9,0xC804,0xBCF4,0xC21C,0xC5F4,0xCE58,0xB9CC,0xC2B5,
    # 0x6E80 #
    0xB9CC,0xC601,0xC790,0xADA4,0xBD09,0xCC9C,0xC11C,0xB8E8,
    0xADDC,0xAC1C,0xAC00,0xC601,0xBC1C,0xC9C4,0xC5F0,0xB2F9,
    0xC6D0,0xC1C4,0xC6D0,0xB834,0xC694,0xBABD,0xC900,0xC2B9,
    0xD569,0xD0DC,0xB2F5,0xC640,0xB958,0xAD6C,0xC18C,0xBA85,
    0xC790,0xC2DC,0xC77C,0xB860,0xB9C8,0xBD80,0xBBF8,0xB960,
    0xC7AC,0xC624,0xACC4,0xC628,0xAC15,0xC9C1,0xC0AC,0xC18C,
    0xAE30,0xC9C4,0xC218,0xC6B4,0xCD94,0xC740,0xC6A9,0xD63C,
    0xC18C,0xC0AD,0xB2C9,0xD0D1,0xC2B5,0xC695,0xC678,0xBC18,
    0xCD95,0xC800,0xBC29,0xC639,0xCC3D,0xBA78,0xACA9,0xC804,
    0xD638,0xD669,0xD5D0,0xC790,0xCC99,0xCE58,0xD615,0xBD80,
    0xAC78,0xD65C,0xAC00,0xC7AC,0xB3C4,0xB4F1,0xC218,0xD544,
    0xAD50,0xD68C,0xACE4,0xC81C,0xACE0,0xB871,0xCCB4,0xC5FC,
    0xC12D,0xB9CC,0xD615,0xC21C,0xB824,0xB78C,0xB780,0xD6A8,
    0xBE48,0xD0C4,0xC5EC,0xC218,0xD638,0xD544,0xD45C,0xCCB4,
    0xACBD,0xAD6C,0xC0BC,0xC0C1,0xC801,0xBC00,0xC624,0xB85C,
    0xD638,0xD638,0xC720,0xC0B0,0xBC94,0xC6A9,0xACE4,0xB9CC,
    # 0x6F00 #
    0xACBD,0xC5B4,0xD45C,0xC801,0xC560,0xC18C,0xCE60,0xC0AC,
    0xC81C,0xB85D,0xB8E8,0xC735,0xADFC,0xAD35,0xCD1D,0xB8E8,
    0xCE69,0xAC1C,0xAC15,0xB9AC,0xC5F0,0xC870,0xAD50,0xCD1D,
    0xC21C,0xB2E8,0xAD6C,0xB4F1,0xC57C,0xC2B5,0xBA71,0xB2F9,
    0xB9C9,0xC0C1,0xD55C,0xB828,0xB78C,0xC640,0xC2DC,0xAC74,
    0xBD09,0xC120,0xC758,0xB9CC,0xC9C0,0xB9DD,0xAC15,0xD0D1,
    0xBD95,0xC218,0xCC3D,0xC7A5,0xCDA9,0xC11C,0xD658,0xACFD,
    0xC810,0xC5B8,0xC0C1,0xB958,0xCD5C,0xC81C,0xC591,0xC7A5,
    0xC885,0xC601,0xD64D,0xC21C,0xC218,0xAD00,0xD615,0xC18C,
    0xCD1D,0xACE4,0xC11C,0xB834,0xC9C8,0xC720,0xBCC4,0xC728,
    0xCD08,0xBC1C,0xC0C1,0xD61C,0xACB0,0xBB34,0xD30C,0xC9D1,
    0xBC18,0xADDC,0xC219,0xC7A0,0xC7A0,0xD761,0xB85C,0xC11D,
    0xC190,0xB3C8,0xD669,0xBBFC,0xC724,0xC18D,0xB8CC,0xC99D,
    0xCD1D,0xC774,0xC9C0,0xB9CC,0xB2E8,0xB2F4,0xC870,0xC2EC,
    0xADA4,0xC5F4,0xC18C,0xB3C4,0xC800,0xC0B0,0xD751,0xD544,
    0xC0B0,0xC794,0xC794,0xC11C,0xB3D9,0xBCF4,0xB9B0,0xC704,
    # 0x6F80 #
    0xC0BD,0xC0BD,0xC9D5,0xACBD,0xC9D5,0xD670,0xC694,0xB85C,
    0xCCA0,0xAC10,0xCD0C,0xD6A1,0xC2DC,0xC8FC,0xD33D,0xD568,
    0xC6B4,0xB958,0xD64D,0xBCF5,0xD638,0xD654,0xD55C,0xAC04,
    0xC0B0,0xC11D,0xC624,0xB85C,0xB780,0xB155,0xC6B0,0xB984,
    0xBBFC,0xC870,0xB2F9,0xD55C,0xD0DD,0xD574,0xC5EC,0xB840,
    0xC11C,0xD559,0xB839,0xB9CC,0xC790,0xC639,0xD68C,0xCC2C,
    0xB834,0xC804,0xC5C5,0xC624,0xD658,0xCE5C,0xC804,0xB9CC,
    0xB2F4,0xB2F4,0xC5B5,0xC218,0xBCBD,0xAC70,0xB2EC,0xAE08,
    0xACA9,0xD0C1,0xB834,0xB18D,0xACFC,0xCE68,0xBD84,0xC0C9,
    0xC999,0xC218,0xC608,0xCD08,0xB2F5,0xCD1D,0xC815,0xC2AC,
    0xC800,0xB8B0,0xBE48,0xB834,0xB2C8,0xC2B5,0xC11C,0xBA71,
    0xB155,0xC601,0xC601,0xBABD,0xC9C4,0xAE30,0xBE44,0xC81C,
    0xD638,0xC720,0xCDE8,0xC54C,0xB3C4,0xC778,0xC740,0xB300,
    0xC790,0xD638,0xC815,0xB78C,0xC900,0xC560,0xBCF5,0xD0C1,
    0xC720,0xBE48,0xACE1,0xC7A0,0xC601,0xBE48,0xD65C,0xB9CC,
    0xCC3D,0xBB35,0xCC9C,0xC720,0xB77D,0xCC2C,0xB824,0xB840,
    # 0x7000 #
    0xC6B0,0xC591,0xB85C,0xC0AC,0xC990,0xD615,0xB3C5,0xC655,
    0xD718,0xC0AC,0xBC18,0xC2EC,0xD45C,0xC804,0xB9D0,0xB958,
    0xCCA8,0xD3ED,0xC0C9,0xC9D5,0xACE1,0xBE48,0xACFD,0xD5CC,
    0xB85C,0xCE5C,0xD55C,0xC601,0xC735,0xB825,0xC815,0xC18C,
    0xD615,0xC218,0xC720,0xD574,0xD68C,0xD638,0xC800,0xB871,
    0xB8B0,0xB300,0xBC88,0xACE1,0xB8B0,0xC218,0xB9BC,0xC601,
    0xBBF8,0xACC4,0xB834,0xCC9C,0xC601,0xBD84,0xB9BC,0xC775,
    0xCCA8,0xC57D,0xCC38,0xB300,0xC591,0xAC74,0xB780,0xBC88,
    0xC0C1,0xC5F0,0xCC29,0xD48D,0xC12D,0xB958,0xB78C,0xCD1D,
    0xAD6C,0xC639,0xCCA8,0xBC95,0xAD00,0xAD90,0xC5FC,0xD638,
    0xD615,0xC1C4,0xCC2C,0xB780,0xC5FC,0xB77C,0xBBF8,0xC120,
    0xD0C4,0xB2F9,0xAD50,0xCC9C,0xC601,0xD638,0xD30C,0xCD09,
    0xB78C,0xB780,0xB0AD,0xB9CC,0xB780,0xCC9C,0xD604,0xC5FC,
    0xACF5,0xC5FC,0xC6B8,0xD654,0xD654,0xBA78,0xAD11,0xC815,
    0xD68C,0xD6A8,0xD6A8,0xD718,0xD64D,0xB839,0xC870,0xC120,
    0xAD6C,0xD0C0,0xC0AC,0xC801,0xC791,0xC7AC,0xC7AC,0xCC2C,
    # 0x7080 #
    0xC591,0xAE30,0xC885,0xBD84,0xB274,0xACBD,0xBB38,0xBC15,
    0xC5ED,0xB85C,0xCDE8,0xBC30,0xAC1C,0xBC18,0xC5FC,0xAC1C,
    0xBC29,0xBAA9,0xCD08,0xB8CC,0xACB0,0xD56D,0xB3C8,0xAD11,
    0xD754,0xC790,0xAD11,0xAD11,0xC704,0xCC3D,0xBCC0,0xB2EC,
    0xC555,0xC815,0xCD9C,0xAC00,0xC18C,0xBD88,0xBC1C,0xD0C0,
    0xD0C0,0xB839,0xC878,0xD604,0xAC70,0xD0C4,0xD3EC,0xD615,
    0xD3EC,0xD0DC,0xD0DC,0xBCD1,0xC559,0xB3D9,0xC12C,0xC8FC,
    0xC791,0xC810,0xC704,0xC11D,0xB828,0xCE58,0xD669,0xC8FC,
    0xD638,0xC0AD,0xB780,0xACBD,0xAD50,0xD73C,0xD589,0xC804,
    0xB82C,0xD658,0xC591,0xD734,0xD734,0xC120,0xC74C,0xC624,
    0xC8FC,0xC694,0xC2DD,0xACC4,0xB3D9,0xD608,0xC7AC,0xAC1C,
    0xD64D,0xB77D,0xD569,0xCD09,0xD6E4,0xC99D,0xBC15,0xC5F0,
    0xAD34,0xAD11,0xD0DD,0xD68C,0xACE0,0xC2E0,0xBC88,0xC18C,
    0xC5FD,0xD68C,0xAD00,0xD0D5,0xC2E0,0xC5F4,0xB82C,0xD76C,
    0xBD80,0xACBD,0xCCA0,0xBCF4,0xACBD,0xC791,0xC815,0xC644,
    0xD68C,0xD33D,0xB791,0xC5F0,0xD6CC,0xBD09,0xC801,0xB96D,
    # 0x7100 #
    0xACE1,0xD76C,0xC219,0xD601,0xD6C8,0xACE1,0xACB0,0xC18C,
    0xD76C,0xC5B8,0xD55C,0xC7A5,0xC900,0xC81C,0xCCA0,0xAE30,
    0xC624,0xACE4,0xB824,0xD568,0xC5FC,0xD658,0xBBFC,0xAD6D,
    0xB3C4,0xBC30,0xBD84,0xB9B0,0xD63C,0xD63C,0xB3C8,0xC11D,
    0xC26C,0xBB34,0xD64D,0xCD08,0xBD80,0xC54C,0xCD08,0xCD1D,
    0xBD09,0xBD95,0xAD81,0xC124,0xC11D,0xACBD,0xD754,0xC791,
    0xC5FC,0xD601,0xC57C,0xC791,0xC721,0xAC15,0xC5F0,0xBE44,
    0xACE0,0xB9DD,0xC2B9,0xCC3D,0xC18C,0xBA85,0xB150,0xACBD,
    0xAD74,0xC2EC,0xD601,0xADDC,0xC885,0xB2E8,0xD558,0xD718,
    0xD48D,0xB828,0xD6E4,0xC131,0xD669,0xCD08,0xC804,0xD53D,
    0xC601,0xC790,0xC704,0xB2E8,0xC810,0xD76C,0xB09C,0xB09C,
    0xBD88,0xC5F0,0xACBD,0xACBD,0xC6B1,0xBBF8,0xC0B4,0xC704,
    0xC7A1,0xD754,0xACBD,0xC720,0xB9E4,0xD658,0xD6C4,0xC870,
    0xC678,0xBC88,0xCD94,0xC218,0xC591,0xB82C,0xC790,0xAC1C,
    0xACE0,0xACFC,0xBCF4,0xD638,0xC628,0xB0A8,0xC2DD,0xB7C9,
    0xD3B8,0xAD6C,0xD1F4,0xB2F9,0xCD94,0xC120,0xC740,0xBC15,
    # 0x7180 #
    0xC5FD,0xD611,0xD76C,0xBB34,0xC2DD,0xC628,0xD569,0xD6A8,
    0xD76C,0xC6B4,0xC6C5,0xB0B4,0xC12C,0xAD81,0xC694,0xD6C8,
    0xBA85,0xB834,0xD615,0xC624,0xC6A9,0xACF5,0xB3C4,0xCC3D,
    0xB958,0xD76C,0xD544,0xD45C,0xCD1D,0xB85D,0xACAC,0xC219,
    0xC2B5,0xB8E8,0xBD09,0xCD5C,0xC775,0xD1B5,0xC791,0xC885,
    0xC704,0xD638,0xC774,0xC790,0xC624,0xC704,0xB8CC,0xC120,
    0xAD6C,0xC5F4,0xACBD,0xB9CC,0xACE4,0xC801,0xCC2C,0xC99D,
    0xC7A0,0xD76C,0xD76C,0xD761,0xC775,0xC18C,0xCE58,0xD669,
    0xCC9C,0xC5FD,0xCCA8,0xC5F0,0xC5FC,0xC12C,0xAD50,0xC874,
    0xB4F1,0xB3C8,0xC2E0,0xCD08,0xBD84,0xC0AC,0xB8CC,0xC728,
    0xB9B0,0xB3D9,0xC18C,0xBD84,0xBC88,0xC5F0,0xC2EC,0xB780,
    0xBBFC,0xD0D5,0xC77C,0xACBD,0xBBFC,0xACBD,0xCD08,0xC601,
    0xC6B1,0xC5ED,0xD45C,0xB78C,0xD0DC,0xC870,0xCC2C,0xC218,
    0xD76C,0xACA9,0xCD1D,0xB834,0xD6FC,0xCD09,0xC12D,0xB839,
    0xC560,0xC758,0xD611,0xC870,0xD68C,0xB2EC,0xB18D,0xB78C,
    0xC720,0xD76C,0xACE0,0xD6C8,0xC2E0,0xC8FC,0xB3C4,0xC694,
    # 0x7200 #
    0xD601,0xB78C,0xD45C,0xC601,0xB82C,0xBB35,0xD3ED,0xC124,
    0xB824,0xB78D,0xC624,0xD6C8,0xAD11,0xC0AD,0xB8CC,0xB825,
    0xB85C,0xC791,0xB8CC,0xC12C,0xD76C,0xC12D,0xB8E1,0xC5FD,
    0xCC2C,0xC591,0xC57D,0xB780,0xCD1D,0xC791,0xCDA9,0xAD00,
    0xAD6C,0xCCA0,0xBBF8,0xB2F9,0xB780,0xCD09,0xB78C,0xB839,
    0xCC2C,0xC6B8,0xC870,0xC870,0xD30C,0xC7C1,0xD3EC,0xCE6D,
    0xC6D0,0xC560,0xC704,0xB8CC,0xD655,0xC791,0xBD80,0xC57C,
    0xD30C,0xB2E4,0xC57C,0xD6A8,0xC870,0xC0C1,0xC774,0xC7A5,
    0xC0C1,0xAC00,0xC7A5,0xCCA9,0xC7A5,0xC6A9,0xC7A5,0xD3B8,
    0xD310,0xBC18,0xC18C,0xC804,0xD328,0xB3C5,0xCC3D,0xD22C,
    0xC0BD,0xD3B8,0xCCA9,0xBC29,0xBC15,0xCC3D,0xC720,0xC6A9,
    0xB3C5,0xC544,0xD0F1,0xC6B0,0xC6B0,0xBE48,0xAD6C,0xBAA8,
    0xD0C0,0xBAA8,0xB8B0,0xC778,0xB9DD,0xBC29,0xBAA8,0xBAA9,
    0xAC15,0xBB3C,0xC5B8,0xAC00,0xD328,0xC0AC,0xCC9C,0xACE0,
    0xC720,0xAC00,0xC0DD,0xBB34,0xC800,0xACAC,0xAD8C,0xC804,
    0xC790,0xD2B9,0xD76C,0xBC29,0xACBD,0xACAC,0xC624,0xACE1,
    # 0x7280 #
    0xC11C,0xB9AC,0xB9AC,0xBD80,0xC758,0xAC15,0xC9C1,0xBD84,
    0xAD8C,0xC21C,0xB3C5,0xAD6C,0xAC00,0xAC74,0xBD09,0xD3B8,
    0xACFC,0xACA9,0xD638,0xCD94,0xD76C,0xBE44,0xB77D,0xAC1C,
    0xB9C8,0xC0BC,0xC704,0xB9AC,0xB3C8,0xB3D9,0xAD50,0xAC15,
    0xD76C,0xB840,0xB3C5,0xB835,0xD53C,0xD45C,0xBC15,0xD76C,
    0xC8FC,0xC704,0xADDC,0xC8FC,0xACAC,0xACAC,0xBC1C,0xBC94,
    0xAD6C,0xD658,0xC2DC,0xC791,0xC548,0xD790,0xC0C1,0xAD11,
    0xB9C8,0xC6B0,0xAC15,0xD328,0xD6C4,0xC544,0xC740,0xBCC0,
    0xC0C1,0xC724,0xAD11,0xB274,0xC801,0xACBD,0xC911,0xBAA9,
    0xD328,0xBE44,0xACA9,0xC758,0xC131,0xD3EC,0xC555,0xC774,
    0xD638,0xB839,0xBE44,0xD53C,0xB2C8,0xC694,0xC720,0xAD6C,
    0xC6D4,0xC800,0xB2EC,0xBC15,0xACE0,0xC120,0xC601,0xD6E4,
    0xD55C,0xAD50,0xD559,0xC870,0xAE38,0xC21C,0xC0B0,0xD0D1,
    0xC735,0xC218,0xB3D9,0xB85C,0xB3C5,0xD611,0xC0AC,0xD68C,
    0xC7C1,0xC625,0xC190,0xC5EC,0xD3D0,0xBC29,0xD76C,0xACAC,
    0xB9AC,0xD611,0xC740,0xC0B0,0xB791,0xD328,0xC81C,0xC5F0,
    # 0x7300 #
    0xC0AC,0xB9AC,0xD55C,0xD5D8,0xACBD,0xBC30,0xBE44,0xD6A8,
    0xD328,0xAE30,0xC608,0xD45C,0xC740,0xB798,0xC791,0xACAC,
    0xAC15,0xACE4,0xC5FC,0xACFC,0xC885,0xBBF8,0xCC3D,0xC758,
    0xC81C,0xC7C1,0xC560,0xB9F9,0xC2DC,0xC878,0xC0AC,0xB835,
    0xC804,0xB77C,0xD638,0xC885,0xD6C4,0xC678,0xD48D,0xC640,
    0xC6D0,0xC131,0xC800,0xBB18,0xC704,0xCC9C,0xD5CC,0xB2E8,
    0xC54C,0xB178,0xD638,0xAC00,0xD6C4,0xD3B8,0xC720,0xC720,
    0xBBF8,0xC0AC,0xC694,0xC190,0xBC15,0xBA85,0xD65C,0xC6D0,
    0xC218,0xB9C8,0xC6D0,0xC560,0xC625,0xC0AC,0xD638,0xAC15,
    0xC775,0xC9C4,0xCC3D,0xD638,0xB9CC,0xACBD,0xC7A5,0xBAA8,
    0xC7A5,0xCC38,0xC624,0xC624,0xD638,0xCD5C,0xBD84,0xAD90,
    0xD3D0,0xD3D0,0xD669,0xBCF5,0xB9B0,0xD73C,0xB3D9,0xAD50,
    0xB8CC,0xC0AD,0xD6A8,0xC218,0xB3C8,0xACA9,0xAC08,0xACAC,
    0xB3C5,0xC608,0xD68C,0xD5D8,0xD574,0xB784,0xC120,0xD6C8,
    0xC601,0xBE48,0xD68D,0xB204,0xBABD,0xB835,0xC6B0,0xAD11,
    0xC218,0xB85C,0xB2EC,0xD5CC,0xBBF8,0xC591,0xD658,0xB178,
    # 0x7380 #
    0xB77C,0xD5D8,0xAE30,0xD655,0xD604,0xBB18,0xC790,0xC194,
    0xB85C,0xC625,0xC219,0xC655,0xADDC,0xAC00,0xC815,0xB975,
    0xD314,0xAE30,0xAC15,0xC801,0xCC9C,0xAC04,0xAD6C,0xC6B0,
    0xAE30,0xC5EC,0xCC3D,0xB9C8,0xAC15,0xC624,0xBD80,0xBBFC,
    0xAC1C,0xC544,0xBD84,0xBCC0,0xBC29,0xBAA8,0xACB0,0xC724,
    0xAC01,0xC644,0xAC10,0xB9E4,0xB2E8,0xBE48,0xC704,0xBC30,
    0xD604,0xCC3D,0xB839,0xB300,0xC608,0xAC10,0xD3C9,0xC810,
    0xBD80,0xD604,0xC0C8,0xD30C,0xC790,0xAD6C,0xAC11,0xC18C,
    0xBC15,0xC790,0xAC00,0xC5FC,0xC0DD,0xC2E0,0xC774,0xC870,
    0xAC00,0xBBFC,0xC0B0,0xB958,0xD544,0xC9C4,0xC9C4,0xAC01,
    0xBC95,0xB871,0xC9C4,0xAD50,0xCC9C,0xB824,0xAD11,0xC120,
    0xC8FC,0xACF5,0xC5F0,0xD6C4,0xC591,0xD6C4,0xB77D,0xC219,
    0xC8FC,0xAE08,0xC740,0xC21C,0xBCF4,0xC774,0xD5A5,0xC694,
    0xD569,0xD615,0xADDC,0xCDA9,0xC220,0xBC18,0xD328,0xB85C,
    0xB2F9,0xB8B0,0xD63C,0xBB38,0xC544,0xC815,0xC81C,0xBB34,
    0xC624,0xC131,0xAD70,0xB9E4,0xD328,0xC815,0xD604,0xCC29,
    # 0x7400 #
    0xD568,0xC120,0xC5B8,0xAD6C,0xD604,0xB791,0xB9AC,0xC218,
    0xBD80,0xB958,0xC57C,0xD76C,0xB989,0xB9AC,0xC9C4,0xB828,
    0xC1C4,0xC18C,0xBD09,0xC644,0xC815,0xBCD1,0xC794,0xC26C,
    0xBBFC,0xC5ED,0xAC70,0xCE68,0xB798,0xBBFC,0xB9DD,0xC720,
    0xC804,0xC219,0xD0C1,0xBC30,0xC7C1,0xD638,0xAE30,0xC545,
    0xACE4,0xCC3D,0xAE30,0xBD09,0xC644,0xB85D,0xC885,0xAD00,
    0xC5FC,0xC870,0xBC30,0xB9BC,0xAE08,0xBE44,0xD30C,0xAC15,
    0xD0C1,0xAE08,0xBC95,0xAE08,0xACBD,0xB3C4,0xAC1C,0xD63C,
    0xC6B0,0xBAA8,0xBBF8,0xCD98,0xC120,0xC81C,0xC131,0xB300,
    0xC720,0xBBFC,0xAC10,0xC704,0xC5F0,0xD658,0xD574,0xCC9C,
    0xC804,0xC804,0xCC3D,0xB828,0xC804,0xD558,0xB2E8,0xC6D0,
    0xC57C,0xB178,0xD638,0xC601,0xC720,0xD669,0xC11C,0xC2AC,
    0xB958,0xC0AC,0xC6A9,0xC1C4,0xC694,0xC628,0xC624,0xC9C4,
    0xC9C4,0xD615,0xB9C8,0xB3C4,0xB958,0xB2F9,0xB960,0xB791,
    0xAD34,0xC804,0xCC3D,0xCC28,0xACE1,0xC870,0xC694,0xC560,
    0xBE48,0xC11C,0xC0C1,0xACE4,0xC804,0xC885,0xADFC,0xC608,
    # 0x7480 #
    0xCD5C,0xCD1D,0xAE30,0xB9AC,0xC601,0xC18C,0xAD6C,0xC120,
    0xC624,0xB828,0xBB38,0xC7A5,0xC778,0xD654,0xC601,0xCCB4,
    0xB85C,0xBB34,0xB4F1,0xC218,0xC99D,0xC2EC,0xAC70,0xD0D5,
    0xB9B0,0xB8CC,0xACBD,0xC219,0xD669,0xAD34,0xBC15,0xACBD,
    0xBC88,0xC9C4,0xB958,0xAE30,0xD61C,0xACBD,0xC560,0xBCBD,
    0xCC2C,0xAC70,0xC870,0xB2F9,0xAD50,0xACE4,0xB2E8,0xD68C,
    0xD658,0xC2AC,0xC218,0xC804,0xCD08,0xC5EC,0xC2E0,0xBD80,
    0xBE48,0xC219,0xBB38,0xCDE8,0xB78C,0xC0C8,0xC81C,0xC120,
    0xC5F0,0xD655,0xAC1C,0xB8B0,0xB3C5,0xB825,0xC9C8,0xC720,
    0xB824,0xCC2C,0xACBD,0xC801,0xAD34,0xC218,0xB784,0xB871,
    0xB85C,0xB825,0xCC2C,0xB780,0xC601,0xC0C8,0xC591,0xD734,
    0xAD00,0xB3C4,0xCC2C,0xD658,0xACFC,0xD3EC,0xC9C8,0xBC15,
    0xD638,0xC9D1,0xD45C,0xD310,0xC591,0xB840,0xC640,0xC2ED,
    0xAC15,0xCC9C,0xD310,0xBD84,0xBC29,0xB2F4,0xC639,0xAD6C,
    0xBD84,0xBAA8,0xD1A4,0xD638,0xB839,0xC774,0xBCD1,0xC790,
    0xBC31,0xACAC,0xC7A5,0xCE58,0xB9AC,0xB2F9,0xB9F9,0xBD80,
    # 0x7500 #
    0xCD94,0xBCD1,0xBCC0,0xCD94,0xACAC,0xB9AC,0xC790,0xC575,
    0xACC4,0xD568,0xB8E8,0xC801,0xAD6C,0xB9F9,0xC804,0xD33D,
    0xB9B0,0xC99D,0xBB34,0xBCBD,0xB2F4,0xC639,0xC575,0xC5B8,
    0xAC10,0xB300,0xC2EC,0xCCA8,0xCCA8,0xAC10,0xC0C1,0xC0DD,
    0xCCAD,0xC2E0,0xC0B0,0xC0B0,0xC720,0xC0DD,0xC18C,0xC0BC,
    0xC6A9,0xC194,0xB85D,0xBCF4,0xC6A9,0xBD09,0xBABD,0xB155,
    0xC804,0xC720,0xAC11,0xC2E0,0xC0BD,0xC804,0xBD88,0xB0A8,
    0xC804,0xBCD1,0xC815,0xD654,0xC815,0xACAC,0xCE58,0xB9F9,
    0xBE44,0xBE44,0xAD6C,0xC21C,0xB958,0xCC3D,0xBB18,0xADE0,
    0xD310,0xBD80,0xACBD,0xC804,0xACC4,0xACC4,0xACAC,0xC678,
    0xBCF5,0xC804,0xBB18,0xB2F5,0xBC18,0xAC15,0xC640,0xBCF5,
    0xB0A8,0xB958,0xBD84,0xC9C4,0xCD95,0xBB34,0xBB34,0xCE21,
    0xC804,0xD574,0xD544,0xB2F5,0xCE58,0xB7B5,0xD734,0xB7B5,
    0xBC88,0xC758,0xBC88,0xD654,0xC5EC,0xC5EC,0xBB34,0xC900,
    0xC774,0xB958,0xC5EC,0xCCA9,0xC8FC,0xD654,0xB2F9,0xCCA0,
    0xAE30,0xC6D0,0xAC15,0xC2B9,0xCC3D,0xD1A4,0xB8B0,0xAE30,
    # 0x7580 #
    0xC7A1,0xB958,0xCCA9,0xD0C4,0xB9B0,0xAC15,0xAC15,0xC8FC,
    0xBCBD,0xCCA9,0xCCA9,0xD544,0xC12D,0xB2E8,0xC18C,0xC18C,
    0xCCB4,0xC758,0xB141,0xB0B4,0xC815,0xBE44,0xC808,0xB8CC,
    0xACF5,0xD758,0xAD6C,0xC8FC,0xD558,0xC0B0,0xD6C4,0xD559,
    0xB824,0xC591,0xC9C4,0xC6B0,0xD30C,0xAC1C,0xD608,0xC800,
    0xC544,0xCDCC,0xBE44,0xC5ED,0xB825,0xC885,0xCC3D,0xD48D,
    0xC8FC,0xD3EC,0xD53C,0xAC10,0xC544,0xC790,0xC124,0xC800,
    0xB2EC,0xC9C4,0xBC95,0xC9C0,0xB3D9,0xC800,0xC9C8,0xBE44,
    0xAD6C,0xC810,0xAC00,0xD604,0xC790,0xBCD1,0xB2D0,0xC99D,
    0xC639,0xACBD,0xC804,0xCDA9,0xD1B5,0xC774,0xD574,0xC720,
    0xD68C,0xD0C0,0xC591,0xCE58,0xCE58,0xD754,0xC544,0xB9E4,
    0xB450,0xACBD,0xD6A8,0xD1B5,0xB3C5,0xB9DD,0xBE44,0xC18C,
    0xC0B0,0xBD80,0xB9AC,0xC9C0,0xC88C,0xD0C8,0xC624,0xC0AC,
    0xB85C,0xC218,0xD0C4,0xAC04,0xC5ED,0xBD95,0xC7A5,0xAD00,
    0xB2F4,0xBE44,0xB9C8,0xB9BC,0xCE58,0xACC4,0xC804,0xC554,
    0xCCB4,0xBE44,0xBE44,0xBBFC,0xACE0,0xD1F4,0xC544,0xC704,
    # 0x7600 #
    0xC5B4,0xCDCC,0xC544,0xCD09,0xCD08,0xB2E8,0xCC38,0xC885,
    0xACC4,0xC720,0xD6C4,0xD48D,0xB784,0xC591,0xC2EC,0xB3C4,
    0xC720,0xACFC,0xC628,0xD0C4,0xACE0,0xD558,0xC74C,0xC608,
    0xB8E8,0xC18C,0xAD90,0xACC4,0xC2DD,0xAD00,0xC608,0xC628,
    0xCC99,0xCC3D,0xBC18,0xC678,0xB958,0xCC44,0xC218,0xD559,
    0xC804,0xD0D1,0xBCC4,0xD0C4,0xC7A5,0xD45C,0xCC38,0xC871,
    0xB77C,0xC608,0xC885,0xCD94,0xC7A5,0xCC44,0xC218,0xC0C9,
    0xAC00,0xC870,0xB8E8,0xB8E8,0xB9C9,0xADFC,0xC740,0xC601,
    0xD669,0xBCF5,0xB8CC,0xB96D,0xCD08,0xB958,0xB85C,0xAC04,
    0xD3D0,0xB2E8,0xC74C,0xD559,0xC554,0xBC18,0xAC04,0xD658,
    0xAD34,0xB18D,0xC720,0xBBF8,0xC5B5,0xC639,0xBCBD,0xB8B0,
    0xB824,0xC11C,0xB2F4,0xB984,0xC804,0xB984,0xB77C,0xBCC4,
    0xC81C,0xCE58,0xC591,0xC120,0xC808,0xC9D5,0xBB35,0xB825,
    0xACFD,0xB77C,0xC801,0xC804,0xC120,0xC601,0xC740,0xAD6C,
    0xC639,0xD0C4,0xC804,0xB8E8,0xB828,0xB780,0xBC1C,0xAC04,
    0xACC4,0xBC1C,0xBC1C,0xB4F1,0xBC1C,0xBC31,0xBC31,0xAC00,
    # 0x7680 #
    0xAE09,0xC870,0xC870,0xBAA8,0xC801,0xD30C,0xAC1C,0xD669,
    0xADC0,0xCCB4,0xB839,0xACE0,0xB9D0,0xC989,0xAD50,0xD33D,
    0xACE0,0xC560,0xC544,0xD638,0xD55C,0xBCBD,0xD658,0xC8FC,
    0xCC9C,0xC11D,0xC560,0xD6A8,0xD638,0xD669,0xD638,0xCC45,
    0xCD5C,0xD638,0xD6A8,0xC5FD,0xD30C,0xD638,0xAD50,0xC560,
    0xC131,0xD669,0xB825,0xD45C,0xD559,0xC791,0xD53C,0xAC04,
    0xD3EC,0xCD94,0xAD70,0xAD6C,0xC900,0xC791,0xC0AC,0xACE0,
    0xAD70,0xAD70,0xCD94,0xC0AC,0xC77C,0xC804,0xB3C5,0xBA85,
    0xAE30,0xC601,0xC6B0,0xBC30,0xC870,0xCDA9,0xBD84,0xD569,
    0xC601,0xD654,0xC775,0xBC1C,0xC644,0xD569,0xC559,0xC794,
    0xC5FC,0xAC10,0xD569,0xC6B0,0xD68C,0xBC94,0xAC1C,0xB3C4,
    0xBC18,0xBCF4,0xAD6C,0xC131,0xB3C4,0xB85D,0xC794,0xB9F9,
    0xB9AC,0xC9C4,0xD601,0xAC10,0xBC18,0xAD00,0xC554,0xB85C,
    0xC218,0xC8FC,0xD0D5,0xC554,0xACE0,0xB824,0xBAA9,0xC815,
    0xAC04,0xC6B0,0xB9F9,0xB9DD,0xC9C1,0xAE30,0xC6D0,0xC804,
    0xC0C1,0xC21C,0xD754,0xD61C,0xBC18,0xBD09,0xC21C,0xBBFC,
    # 0x7700 #
    0xBA85,0xC131,0xC2DC,0xC6B4,0xBA74,0xD310,0xBC29,0xBB18,
    0xD0D0,0xBBF8,0xBAA8,0xAC04,0xD604,0xAD6C,0xC2DC,0xC559,
    0xC815,0xC720,0xC2E0,0xD65C,0xB2F5,0xC9C4,0xD669,0xAD6C,
    0xC2E0,0xC774,0xC0DD,0xB9E4,0xB9D0,0xC800,0xC9C4,0xC9C4,
    0xBA74,0xC800,0xC6D0,0xC9C8,0xC774,0xC790,0xC790,0xCD08,
    0xC7A1,0xD604,0xBCD1,0xBBF8,0xB8E1,0xD734,0xB3D9,0xBBF8,
    0xC9C8,0xC774,0xC774,0xBA85,0xC21C,0xCE58,0xAD11,0xAD8C,
    0xBAA8,0xC9C4,0xC870,0xC591,0xC548,0xB9E5,0xC911,0xB9E5,
    0xCC29,0xC815,0xBBF8,0xC900,0xCD08,0xD658,0xD658,0xC81C,
    0xC815,0xC88C,0xACAC,0xC544,0xB9CC,0xD604,0xD76C,0xACE4,
    0xB798,0xAC80,0xC12C,0xC804,0xACE4,0xC644,0xB989,0xC11D,
    0xACBD,0xB82C,0xC560,0xC815,0xC815,0xB9AC,0xB798,0xC218,
    0xAD8C,0xC218,0xC218,0xB3C5,0xBE44,0xBE44,0xBAA9,0xD63C,
    0xC608,0xB85D,0xC5ED,0xCCA9,0xCC44,0xCD94,0xC720,0xD63C,
    0xB9D0,0xD558,0xC131,0xD734,0xACE4,0xC7AC,0xCD98,0xAC74,
    0xBBF8,0xB3C4,0xD6C4,0xD6E4,0xC81C,0xADDC,0xACE0,0xC608,
    # 0x7780 #
    0xBB34,0xD601,0xBC8C,0xC62C,0xBB18,0xCD94,0xADC0,0xBBF8,
    0xC639,0xAD6C,0xB2F9,0xC9C4,0xAC11,0xC218,0xD560,0xACBD,
    0xB9C9,0xBA85,0xB9CC,0xD6C8,0xCC45,0xC7A5,0xC608,0xC870,
    0xAD6C,0xB9C9,0xC21C,0xC885,0xB8E8,0xB9AC,0xB9CC,0xD45C,
    0xB2F9,0xADDC,0xBABD,0xD658,0xC21C,0xBCC4,0xD76C,0xCD08,
    0xBC15,0xCD09,0xC9D5,0xC2EC,0xC21C,0xB8CC,0xCCA0,0xAC04,
    0xAC10,0xC5FD,0xD73C,0xB3D9,0xBB34,0xB9B0,0xADC0,0xD55C,
    0xC5FD,0xC560,0xD68C,0xCCA8,0xAC80,0xACE0,0xC870,0xAD6C,
    0xBBF8,0xCD94,0xC18C,0xB155,0xD6C8,0xC694,0xD655,0xBABD,
    0xBA74,0xBE48,0xBA74,0xB824,0xAD11,0xD655,0xD604,0xBA74,
    0xD559,0xB85C,0xBABD,0xB8E1,0xAD00,0xB9CC,0xB9AC,0xCD09,
    0xB2F9,0xAC10,0xCD09,0xBAA8,0xAE0D,0xAE0D,0xC728,0xC0AD,
    0xC0C9,0xD655,0xC2DC,0xC758,0xC2E0,0xC9C0,0xD6C4,0xC2E0,
    0xC601,0xAD6C,0xC8FC,0xAD50,0xC88C,0xB2E8,0xC65C,0xAD50,
    0xC99D,0xD655,0xD328,0xC11D,0xC815,0xCCB4,0xAE30,0xC790,
    0xC548,0xC62C,0xD0C1,0xACE8,0xAC15,0xC11D,0xBC18,0xAD11,
    # 0x7800 #
    0xD0D5,0xB9C8,0xC0AC,0xB2E8,0xACB0,0xB840,0xBD80,0xBBFC,
    0xB098,0xD68D,0xAC15,0xC9C0,0xCCB4,0xAC10,0xAC1C,0xBD84,
    0xC555,0xC544,0xBE44,0xCCA0,0xC5F0,0xC1C4,0xC804,0xCC28,
    0xB3C8,0xC640,0xC5F0,0xAE08,0xD48D,0xAC81,0xB9D0,0xC0AC,
    0xC800,0xC625,0xB77C,0xD0C0,0xD0C0,0xC9C0,0xCC44,0xCE68,
    0xC561,0xD3D0,0xBAA8,0xC8FC,0xB9BD,0xD3C4,0xB178,0xBE59,
    0xD33D,0xB839,0xD3EC,0xB825,0xD30C,0xBC1C,0xBC15,0xC2E0,
    0xC7A1,0xC560,0xB824,0xB871,0xB3D9,0xC6A9,0xB825,0xAD11,
    0xCD9C,0xAC31,0xC804,0xC8FC,0xAD11,0xADDC,0xC555,0xB1E8,
    0xD560,0xB960,0xC704,0xC560,0xB77D,0xAC04,0xD615,0xC5F0,
    0xB3D9,0xD33D,0xC11C,0xB85C,0xD64D,0xC11D,0xD611,0xAD50,
    0xD68C,0xC560,0xAD50,0xC5ED,0xAC31,0xCD08,0xACE1,0xCC9C,
    0xB791,0xAD49,0xC5EC,0xD6A8,0xD611,0xB9DD,0xB871,0xC6A9,
    0xCC28,0xCC99,0xC544,0xB958,0xACBD,0xB9DD,0xD559,0xC5F0,
    0xC0AC,0xACE4,0xACE1,0xC801,0xD654,0xB1E8,0xC7A0,0xD5D8,
    0xD559,0xC22D,0xD0C1,0xAC31,0xBD95,0xC5C4,0xCD94,0xACF5,
    # 0x7880 #
    0xC7C1,0xAE30,0xC885,0xCCAD,0xB9BC,0xADE0,0xD30C,0xC815,
    0xBBFC,0xC870,0xC804,0xD558,0xB85D,0xC560,0xC1C4,0xC791,
    0xB989,0xBE44,0xC74C,0xB300,0xBB34,0xAE30,0xB860,0xC644,
    0xC804,0xAC15,0xBC30,0xC801,0xCC38,0xC5F0,0xC554,0xC124,
    0xC815,0xB3C5,0xD0C0,0xAC08,0xC601,0xD3B8,0xAC1D,0xBCBD,
    0xC678,0xC11D,0xCE68,0xB2E8,0xD558,0xD0D5,0xC81C,0xB1CC,
    0xD33D,0xAC10,0xC81C,0xD0C4,0xC0AC,0xC815,0xACC4,0xC21C,
    0xD48D,0xC120,0xD655,0xD655,0xB9C8,0xACF5,0xB144,0xC194,
    0xC561,0xC790,0xB958,0xC0AC,0xB2F9,0xBC29,0xD65C,0xBE44,
    0xC678,0xC0C1,0xB8B0,0xCC28,0xC804,0xD560,0xACC4,0xB834,
    0xBC18,0xC560,0xC6B4,0xD1F4,0xCC45,0xAC1C,0xB78D,0xBD80,
    0xC694,0xACE4,0xC804,0xCC38,0xCCB4,0xC624,0xD33D,0xB959,
    0xB1E8,0xAC10,0xCC3D,0xCC38,0xC740,0xB8B0,0xD45C,0xC801,
    0xB9C8,0xCC99,0xCD5C,0xC885,0xACBD,0xC21C,0xB95C,0xAE30,
    0xC120,0xB85C,0xAC70,0xC99D,0xB4F1,0xAC04,0xC11D,0xB9B0,
    0xC815,0xC810,0xAD11,0xBC18,0xC7A1,0xAD50,0xC81C,0xB825,
    # 0x7900 #
    0xAC04,0xCD08,0xD76C,0xC7A5,0xAD50,0xB3C8,0xD5D8,0xC6B1,
    0xCD94,0xAD50,0xACA9,0xD0DD,0xB8B0,0xAC08,0xCD08,0xAE09,
    0xAC01,0xB2F9,0xC758,0xAC15,0xBCBD,0xBCBD,0xC5EC,0xBE48,
    0xAE09,0xC560,0xAC1C,0xAC10,0xC5EC,0xC5F0,0xBABD,0xD3EC,
    0xC790,0xBC15,0xC591,0xB9D0,0xCC30,0xD604,0xAD11,0xB8B0,
    0xB8B0,0xC9C8,0xB824,0xB825,0xBC18,0xD655,0xD3EC,0xC601,
    0xB825,0xB871,0xB871,0xB9C8,0xBC15,0xC0C1,0xAD00,0xB78C,
    0xCC30,0xC554,0xC2DC,0xC2DC,0xB840,0xC789,0xC0AC,0xC57D,
    0xC0AC,0xAE30,0xC57C,0xB9C8,0xAC1C,0xC694,0xCC9C,0xAE30,
    0xAE30,0xC9C0,0xD33D,0xB300,0xCDA9,0xC784,0xC758,0xC11D,
    0xC6B0,0xC9C8,0xCD08,0xBD88,0xBD80,0xBE44,0xC870,0xC9C0,
    0xC0B0,0xBBF8,0xC870,0xAC70,0xD638,0xCD95,0xC2E0,0xC218,
    0xC0AC,0xC2DC,0xB2C8,0xB824,0xC6B0,0xC0C1,0xC624,0xC870,
    0xD45C,0xC8FC,0xADA4,0xD611,0xC9C0,0xC81C,0xACE0,0xC815,
    0xACE0,0xC138,0xCE68,0xC2E0,0xAC1C,0xACE4,0xCCB4,0xB3C4,
    0xD654,0xB3C4,0xAE30,0xACE0,0xAD00,0xCD40,0xB989,0xB85D,
    # 0x7980 #
    0xD488,0xAE08,0xB3C4,0xC2DD,0xB85D,0xC120,0xBE44,0xC800,
    0xD718,0xC720,0xACC4,0xC778,0xC790,0xD654,0xC815,0xBCF5,
    0xC6D0,0xC6B0,0xC120,0xC591,0xC81C,0xC758,0xB9E4,0xC0AC,
    0xCCB4,0xBC30,0xC791,0xC9C4,0xC601,0xC9C1,0xACE0,0xB2F9,
    0xC0AC,0xB9C8,0xD0D1,0xBD80,0xD6E4,0xAE30,0xC5B4,0xD76C,
    0xAE30,0xC0AC,0xC120,0xB2F4,0xD68C,0xC218,0xB840,0xB18D,
    0xB2C8,0xB3C4,0xB824,0xC591,0xC57D,0xC81C,0xCC2C,0xB958,
    0xC720,0xC6B0,0xC639,0xB9AC,0xC124,0xAE08,0xD654,0xB3C5,
    0xC218,0xC0AC,0xC778,0xB3C5,0xC790,0xD0C0,0xAC04,0xC608,
    0xC120,0xBCD1,0xB144,0xCD94,0xCD94,0xCDA9,0xBD84,0xBAA8,
    0xC6B4,0xACFC,0xCD08,0xC9C0,0xAC31,0xBE44,0xC9C0,0xC5B4,
    0xBE44,0xACE0,0xBC18,0xD53C,0xB2C8,0xB825,0xC720,0xC870,
    0xBE44,0xBC1C,0xB839,0xB9D0,0xCE6D,0xC810,0xC9C4,0xC559,
    0xC791,0xC9C8,0xC9C0,0xCD9C,0xAC70,0xC790,0xD65C,0xC801,
    0xCE6D,0xB3D9,0xCE58,0xD65C,0xD569,0xC778,0xC790,0xC9C8,
    0xAC08,0xC784,0xD22C,0xC774,0xC8FC,0xC608,0xB18D,0xBD80,
    # 0x7A00 #
    0xD76C,0xACE0,0xB791,0xBD80,0xCE21,0xC138,0xB824,0xACE4,
    0xAC04,0xAC31,0xC81C,0xC815,0xB3C4,0xCD08,0xC138,0xC544,
    0xB95C,0xB959,0xACE0,0xC791,0xC784,0xC900,0xBC29,0xD328,
    0xAE30,0xC9C1,0xCE58,0xADE0,0xB989,0xD33D,0xACFC,0xD488,
    0xC870,0xC878,0xC6B1,0xC18C,0xC218,0xD5A5,0xC758,0xC124,
    0xBCC0,0xAE30,0xBCF5,0xBCBD,0xB098,0xAC1C,0xC885,0xC885,
    0xC11C,0xCE6D,0xB3C4,0xC740,0xB834,0xC790,0xC6B1,0xC9C1,
    0xCD95,0xC9C4,0xCE58,0xB3C4,0xAC00,0xACC4,0xACE0,0xACE0,
    0xACE1,0xC6A9,0xC218,0xC6A9,0xC81C,0xAC15,0xBAA9,0xC0BC,
    0xBBF8,0xCE58,0xAE30,0xB959,0xC18C,0xC801,0xC601,0xC740,
    0xCD94,0xC0C9,0xC870,0xC775,0xD669,0xCCA9,0xAE30,0xC218,
    0xD6A8,0xBCF5,0xAD50,0xCC29,0xB3D9,0xCD5C,0xB824,0xC218,
    0xB18D,0xC0C9,0xC608,0xC591,0xB098,0xC5EC,0xBE48,0xC81C,
    0xD1F4,0xC628,0xCE6D,0xD655,0xAD11,0xB824,0xD45C,0xC0C9,
    0xC591,0xC791,0xB9AC,0xCC2C,0xD608,0xC54C,0xAD6C,0xAD81,
    0xC11D,0xAD81,0xACF5,0xC6B0,0xC0BC,0xC815,0xC694,0xCC9C,
    # 0x7A80 #
    0xB454,0xB3CC,0xB85C,0xC808,0xCC29,0xC694,0xD3C4,0xBC15,
    0xC694,0xBCD1,0xC640,0xC904,0xAD50,0xADDC,0xC870,0xC624,
    0xADDC,0xC694,0xC9C8,0xCC3D,0xC694,0xC870,0xAD50,0xCC3D,
    0xAD70,0xD6A8,0xC131,0xAD6C,0xCC2C,0xC640,0xB2F4,0xAD74,
    0xACFC,0xCD2C,0xD68D,0xC194,0xAD00,0xADDC,0xB450,0xD0C1,
    0xC74C,0xC640,0xC640,0xC54C,0xC720,0xAD6C,0xAD81,0xC694,
    0xC694,0xC870,0xB8CC,0xC720,0xC804,0xC870,0xAD6C,0xB8CC,
    0xC2E4,0xC624,0xADDC,0xCC3D,0xC18C,0xAD00,0xAD00,0xB96D,
    0xD0F1,0xCDE8,0xB8CC,0xC870,0xCC2C,0xADDC,0xAD81,0xB450,
    0xC870,0xB871,0xC808,0xB9BD,0xCC98,0xC2ED,0xBD80,0xCC9C,
    0xCD09,0xD6A1,0xAE30,0xBAA8,0xC2B9,0xBD84,0xC218,0xBB18,
    0xAD6C,0xCC38,0xC800,0xB839,0xB8E1,0xBCD1,0xACBD,0xACBD,
    0xC7A5,0xBC31,0xC0AC,0xC900,0xAD49,0xB3D9,0xC1A1,0xC815,
    0xC870,0xC758,0xC218,0xC815,0xAD6C,0xAC08,0xBCD1,0xB2E8,
    0xB9AC,0xC804,0xC99D,0xB4F1,0xC900,0xD654,0xACBD,0xAC10,
    0xACBD,0xC8FD,0xCD95,0xB975,0xBD09,0xC6B0,0xC9C0,0xAC04,
    # 0x7B00 #
    0xB9DD,0xCD95,0xD658,0xB3C5,0xACC4,0xD6A8,0xD30C,0xC0B0,
    0xAE09,0xC2E0,0xC870,0xC21C,0xC544,0xCCB4,0xC6D0,0xD640,
    0xD56D,0xC18C,0xAE08,0xBE44,0xD544,0xACAC,0xC774,0xB3D9,
    0xC810,0xC0DD,0xAC11,0xC801,0xC904,0xB0A9,0xD0DC,0xACE0,
    0xB9BD,0xCC28,0xBBFC,0xD3EC,0xC18C,0xC0AC,0xBD80,0xCC45,
    0xBD84,0xD328,0xB2EC,0xC790,0xC81C,0xB839,0xCC29,0xB178,
    0xBD88,0xAD6C,0xBC88,0xAC00,0xAC00,0xBC94,0xC2DC,0xBB18,
    0xD30C,0xC138,0xC804,0xACF5,0xB871,0xBA85,0xBCC0,0xB77D,
    0xACC4,0xACE1,0xC9C0,0xC778,0xC694,0xC120,0xD544,0xACF5,
    0xAD04,0xB4F1,0xD6A8,0xADFC,0xC804,0xC21C,0xC5EC,0xBC8C,
    0xAD11,0xCD95,0xD1B5,0xACC4,0xB2F5,0xD589,0xCC45,0xC911,
    0xAD6C,0xB8B0,0xD544,0xC0AC,0xB2F9,0xC7C1,0xCC45,0xBD80,
    0xADE0,0xB3C4,0xD30C,0xB9AC,0xB791,0xAC70,0xAD00,0xACAC,
    0xD568,0xD1B5,0xAC11,0xC9C0,0xC131,0xC0B0,0xC11C,0xC800,
    0xC791,0xC18C,0xC18C,0xC815,0xD611,0xC5F0,0xACE0,0xCF8C,
    0xAC04,0xC8FC,0xAD11,0xAC15,0xC6B4,0xC624,0xCCA8,0xC18C,
    # 0x7B80 #
    0xAC04,0xBD80,0xB798,0xCD94,0xBE44,0xD3D0,0xBE44,0xAC1C,
    0xC9C0,0xAD34,0xC5B4,0xC804,0xC870,0xACE0,0xD638,0xC7C1,
    0xC815,0xC0BD,0xCD94,0xB85D,0xBC15,0xAE30,0xB9BC,0xC0B0,
    0xADE0,0xBCF5,0xCC28,0xACE0,0xACF5,0xACB8,0xAD8C,0xADE0,
    0xCD94,0xAD00,0xC6D0,0xCC45,0xC878,0xD30C,0xCC45,0xD611,
    0xD0C1,0xB77C,0xB2E8,0xC18C,0xC57D,0xC804,0xD6E4,0xD3B8,
    0xC21C,0xC0C1,0xC120,0xBCD1,0xC7A0,0xC131,0xD638,0xC774,
    0xC800,0xC57D,0xC900,0xB960,0xC625,0xB3D9,0xC18C,0xC0BD,
    0xC808,0xD669,0xC131,0xBBF8,0xBC94,0xCC9C,0xC804,0xD3B8,
    0xBD09,0xCD95,0xD64D,0xD611,0xD6C4,0xCD94,0xBB18,0xAC10,
    0xACE0,0xADA4,0xC2DD,0xB8E8,0xC6B4,0xD569,0xB2F9,0xD655,
    0xCD94,0xACE0,0xBE44,0xC57D,0xC99D,0xAD6C,0xB148,0xCC9C,
    0xC18C,0xCC2C,0xACF5,0xBC29,0xB3C5,0xB960,0xBE44,0xCC29,
    0xC800,0xC0AC,0xC9C0,0xCD95,0xCC3D,0xB871,0xB78C,0xC804,
    0xBD80,0xB9AC,0xC218,0xD544,0xC801,0xCD1D,0xC5B8,0xBD09,
    0xC7A0,0xCC2C,0xD328,0xD45C,0xB450,0xC5B4,0xBA78,0xC804,
    # 0x7C00 #
    0xCC45,0xC0AC,0xADA4,0xC774,0xD638,0xC0B0,0xAD6C,0xC871,
    0xBCD1,0xCD94,0xAE30,0xADA4,0xC18D,0xB8E8,0xCC29,0xB85D,
    0xB144,0xC0AC,0xCC2C,0xC870,0xC0AC,0xB975,0xB2E8,0xB7C9,
    0xC18C,0xBC15,0xBA71,0xC2DC,0xD0D5,0xB8CC,0xB2E8,0xC810,
    0xBCF4,0xAC04,0xBBFC,0xADA4,0xB300,0xAD50,0xB4F1,0xD669,
    0xC21C,0xB85C,0xC7A0,0xC18C,0xB85C,0xC11C,0xC7A0,0xAE30,
    0xD328,0xAE30,0xBE44,0xAC04,0xAC70,0xB85C,0xB85D,0xCCA8,
    0xD30C,0xB2F9,0xC0C8,0xACFC,0xAD6C,0xCCA8,0xB834,0xBD80,
    0xC8FC,0xB8B0,0xC2DD,0xB78C,0xADA4,0xC5EC,0xD655,0xD638,
    0xC9C4,0xB300,0xC801,0xC12D,0xC8FC,0xC801,0xC758,0xAE30,
    0xB4F1,0xCC2C,0xC8FC,0xBC88,0xC218,0xCD94,0xCCA8,0xACFD,
    0xB4F1,0xB85D,0xB85C,0xC804,0xD0C1,0xC601,0xC5B4,0xB8B0,
    0xB871,0xCCA8,0xB834,0xB780,0xCCA8,0xC57D,0xC885,0xAC70,
    0xB834,0xBCC0,0xB2E8,0xCC2C,0xB9AC,0xC0AC,0xB77C,0xC601,
    0xD655,0xCC29,0xC720,0xBBF8,0xC801,0xC2ED,0xC2E0,0xCC45,
    0xC2E0,0xC5EC,0xD758,0xB958,0xC120,0xC790,0xC778,0xCD0C,
    # 0x7C80 #
    0xC7A5,0xCC9C,0xAD6C,0xBE44,0xD310,0xBB3C,0xC0AC,0xAC15,
    0xB274,0xBD84,0xBE44,0xC218,0xC778,0xBAA8,0xCC99,0xD0DC,
    0xD638,0xD30C,0xB9BD,0xAC10,0xAC70,0xBC15,0xB9D0,0xC870,
    0xC810,0xC8FC,0xB9AC,0xC219,0xC870,0xB824,0xC11C,0xC18D,
    0xD64D,0xB3D9,0xC790,0xCC45,0xC6D4,0xC8FD,0xB9B0,0xC7A5,
    0xBC31,0xB178,0xBD84,0xC774,0xACE1,0xD569,0xB7C9,0xAC04,
    0xBD80,0xB7C9,0xCC2C,0xAC31,0xB9AC,0xC6D4,0xB85D,0xAD6D,
    0xAE30,0xC218,0xD328,0xC7A5,0xB9B0,0xC885,0xC815,0xACFC,
    0xD654,0xC0BC,0xC0BC,0xB2F9,0xBCC0,0xC720,0xBA74,0xD6C4,
    0xC11C,0xC885,0xD638,0xC804,0xCC30,0xC790,0xB9AC,0xC124,
    0xBD80,0xB2C9,0xBE44,0xACE1,0xC218,0xACE0,0xB2F9,0xAD6C,
    0xAC00,0xC870,0xC7A5,0xB2F9,0xBBF8,0xC0BC,0xBD84,0xC870,
    0xAC15,0xAC15,0xBAA8,0xC0BC,0xC0B0,0xB098,0xCE58,0xB7C9,
    0xAC15,0xAD34,0xBCBD,0xD658,0xC11C,0xC885,0xD568,0xB098,
    0xB2E8,0xC5BC,0xB824,0xCC29,0xC801,0xC5BC,0xC870,0xB780,
    0xBA71,0xBA71,0xADDC,0xACC4,0xACF5,0xC815,0xADDC,0xACF5,
    # 0x7D00 #
    0xAE30,0xCC28,0xC8FC,0xC21C,0xC57D,0xD64D,0xC6B0,0xD758,
    0xD658,0xC778,0xBB38,0xBB38,0xAD6C,0xB0A9,0xCE58,0xB450,
    0xB274,0xBD80,0xACC4,0xC11C,0xC21C,0xBE44,0xC9C4,0xC0AC,
    0xAD49,0xC9C0,0xAE09,0xBD84,0xC6B4,0xC784,0xB2F4,0xAE08,
    0xC18C,0xBC29,0xC0C9,0xCD5C,0xADDC,0xCC30,0xD30C,0xAE34,
    0xBD80,0xC9C8,0xCC98,0xC790,0xC8FC,0xD6A1,0xCC30,0xB8E8,
    0xC138,0xBD88,0xC124,0xC2E0,0xD53C,0xC800,0xAC70,0xB839,
    0xC8FC,0xC18C,0xAC10,0xC559,0xBD88,0xD0C0,0xC9C4,0xD0DC,
    0xCD9C,0xC2DC,0xC885,0xD604,0xC870,0xACBD,0xBC18,0xAD6C,
    0xB9E5,0xC220,0xBCF8,0xAD11,0xACBD,0xC784,0xD589,0xC124,
    0xACB0,0xC8FC,0xC218,0xAD18,0xBC31,0xC808,0xAD11,0xD640,
    0xCC28,0xD658,0xAE0D,0xC870,0xD608,0xACE0,0xAD50,0xC804,
    0xAC1C,0xB77D,0xD604,0xBCD1,0xC120,0xBCF5,0xAE09,0xB3D9,
    0xC735,0xC870,0xC778,0xB958,0xC124,0xAD8C,0xC11C,0xD574,
    0xC9C8,0xD1B5,0xC0AC,0xAC15,0xC0C1,0xD68C,0xC808,0xC9D1,
    0xACAC,0xACAC,0xCE58,0xBB38,0xC9C4,0xB824,0xC131,0xAD6C,
    # 0x7D80 #
    0xC18C,0xBC29,0xD1B5,0xCD08,0xD658,0xCE68,0xACBD,0xC218,
    0xC81C,0xC218,0xD611,0xAD49,0xACA9,0xBC1C,0xC815,0xC218,
    0xD0DC,0xACE4,0xBD80,0xACBD,0xD638,0xC9C0,0xC5F0,0xACBD,
    0xBD09,0xACC4,0xC18D,0xC774,0xC885,0xCE68,0xD0C0,0xB824,
    0xB85D,0xB7C9,0xC8FC,0xAD8C,0xC18C,0xAE30,0xAE30,0xC900,
    0xAE30,0xC6D0,0xCC9C,0xC120,0xC218,0xC720,0xACC4,0xB3C4,
    0xAD00,0xAC15,0xB9DD,0xBD95,0xCCA0,0xCC44,0xACFC,0xCD5C,
    0xB95C,0xB958,0xAE30,0xD0C4,0xBCBD,0xC791,0xB989,0xBA74,
    0xCC98,0xCCA9,0xB2F4,0xC885,0xACE4,0xCD94,0xC11D,0xCE58,
    0xD589,0xB7C9,0xAE34,0xBE44,0xC720,0xBBFC,0xC5ED,0xCD1D,
    0xBC88,0xB85D,0xC11C,0xC601,0xC0C1,0xC790,0xC11C,0xC0C1,
    0xD568,0xACA9,0xC120,0xC5F0,0xBA74,0xC9D1,0xB2E8,0xC885,
    0xCCB4,0xBBFC,0xBB18,0xC5F0,0xC124,0xBCF4,0xC2DC,0xCD94,
    0xD3B8,0xC644,0xAE0D,0xCD1D,0xBA74,0xC704,0xBD80,0xC704,
    0xD22C,0xAD6C,0xBB18,0xD608,0xB828,0xC885,0xD3B8,0xD63C,
    0xC778,0xC81C,0xC65C,0xCE58,0xC628,0xC815,0xC804,0xD0DC,
    # 0x7E00 #
    0xD558,0xC5F0,0xCD1D,0xC11C,0xC2B9,0xC704,0xAE0D,0xC120,
    0xC601,0xC9C4,0xC561,0xCD94,0xC5ED,0xBC29,0xACE8,0xBC18,
    0xCD94,0xACB8,0xCC29,0xC804,0xC0C1,0xC628,0xD560,0xCD5C,
    0xACC4,0xC6A9,0xB3C4,0xBC15,0xC6B4,0xC9C4,0xD638,0xC695,
    0xACE1,0xC7AC,0xB4F1,0xD604,0xC18C,0xC9C4,0xC885,0xC870,
    0xD669,0xCC44,0xD544,0xBD09,0xCD95,0xB9AC,0xCD95,0xC5F0,
    0xC1C4,0xC885,0xB958,0xACAC,0xACAC,0xB9CC,0xC9D1,0xB8E8,
    0xB9C9,0xD45C,0xB828,0xBBF8,0xC120,0xCD1D,0xC801,0xC0BC,
    0xC1C4,0xBC88,0xB960,0xBD95,0xC608,0xC18C,0xBB34,0xC694,
    0xAC15,0xD63C,0xC12C,0xACC4,0xB9AC,0xC218,0xC5F0,0xC120,
    0xC138,0xAD50,0xC99D,0xCD2C,0xC9C1,0xC120,0xC0B0,0xB9B0,
    0xC728,0xBC88,0xB8CC,0xC791,0xC900,0xAC04,0xC694,0xCC9C,
    0xC608,0xC218,0xADA4,0xD68D,0xCC2C,0xD76C,0xAC15,0xC6B4,
    0xB2EC,0xC2B9,0xD68C,0xACC4,0xC0C9,0xACAC,0xAC15,0xD604,
    0xC870,0xCD1D,0xD574,0xACA9,0xBCBD,0xB2E8,0xC5B5,0xB18D,
    0xC218,0xC5ED,0xC624,0xC218,0xACC4,0xBE48,0xACAC,0xB78C,
    # 0x7E80 #
    0xBCF5,0xD6C8,0xCC2C,0xC790,0xBD09,0xC57D,0xBB35,0xB8B0,
    0xD790,0xCC2C,0xAD11,0xC6B0,0xC18D,0xB958,0xC12C,0xC804,
    0xAD50,0xB85C,0xC804,0xC601,0xC7AC,0xC591,0xC12C,0xC218,
    0xCC2C,0xB77C,0xB9AC,0xB3C5,0xB78C,0xB958,0xB828,0xBA71,
    0xADDC,0xC6B0,0xD64D,0xC8FC,0xC12C,0xD758,0xC57D,0xAE09,
    0xD658,0xAD11,0xAE30,0xC778,0xC704,0xC6B4,0xAD49,0xC21C,
    0xBE44,0xC0AC,0xB9DD,0xB0A9,0xC784,0xC885,0xB95C,0xBD84,
    0xC9C0,0xBB38,0xBC29,0xC800,0xC9C4,0xB274,0xC11C,0xC120,
    0xAC10,0xC124,0xBD88,0xB828,0xC870,0xC2E0,0xC138,0xC9C1,
    0xC885,0xCD94,0xBC18,0xBD88,0xCD9C,0xC18C,0xC5ED,0xACBD,
    0xD0DC,0xBC29,0xC735,0xACB0,0xACE0,0xC694,0xC9C8,0xD589,
    0xD68C,0xAE09,0xD604,0xAC15,0xB77D,0xC808,0xAD50,0xD1B5,
    0xACBD,0xCD08,0xACAC,0xC218,0xACA9,0xC218,0xC870,0xACC4,
    0xC81C,0xC801,0xC11C,0xB989,0xC601,0xC18D,0xAE30,0xBE44,
    0xC791,0xC0C1,0xACE4,0xC2B9,0xC720,0xBA74,0xC218,0xBD95,
    0xC8FC,0xB3C4,0xB958,0xAD8C,0xC885,0xD0C4,0xAD00,0xB85D,
    # 0x7F00 #
    0xCCA0,0xCE58,0xACA9,0xC0C1,0xD568,0xBA74,0xB78C,0xC81C,
    0xBB18,0xC9D1,0xC628,0xADA4,0xC2DC,0xC218,0xB2E8,0xD3B8,
    0xC120,0xAD6C,0xCD94,0xC644,0xCCB4,0xB8E8,0xD3B8,0xBBFC,
    0xC5F0,0xC9C4,0xBC15,0xC695,0xC9C4,0xBD09,0xCD5C,0xD638,
    0xC804,0xB9AC,0xC561,0xACB8,0xBE48,0xD45C,0xB9CC,0xB958,
    0xC601,0xCD95,0xBB34,0xC18C,0xD790,0xB8CC,0xC120,0xC99D,
    0xAC15,0xACAC,0xC870,0xD604,0xACA9,0xCC2C,0xBD80,0xC0AC,
    0xD56D,0xBD80,0xACB0,0xBD80,0xACB0,0xBC1C,0xBCD1,0xD56D,
    0xC870,0xD56D,0xC575,0xC575,0xACBD,0xD558,0xAD00,0xC900,
    0xB2F4,0xC7A5,0xACC4,0xC639,0xC575,0xB8B0,0xB2F4,0xB85C,
    0xAD00,0xB9DD,0xB9DD,0xB9DD,0xB9DD,0xD55C,0xB77C,0xB77C,
    0xBD80,0xBBF8,0xBC8C,0xACE0,0xC8FC,0xC800,0xBAA8,0xACE0,
    0xBBFC,0xAC15,0xD30C,0xAD18,0xC81C,0xACAC,0xBD80,0xC0BC,
    0xC5C4,0xC870,0xC8C4,0xAD18,0xCCA0,0xC5ED,0xCE58,0xC554,
    0xBC8C,0xB0A8,0xC11C,0xC2DC,0xBE44,0xB9E4,0xB958,0xD30C,
    0xBC8C,0xB9AC,0xC870,0xC704,0xD544,0xACC4,0xC99D,0xB3D9,
    # 0x7F80 #
    0xB958,0xAE30,0xACAC,0xBA71,0xC870,0xB77C,0xBE44,0xAE30,
    0xAE30,0xB780,0xC591,0xBBF8,0xAC15,0xB2EC,0xBBF8,0xC591,
    0xC720,0xC720,0xBD84,0xD30C,0xACE0,0xC591,0xACE0,0xAC15,
    0xC7A5,0xACE0,0xB839,0xC758,0xC800,0xC800,0xC218,0xAC04,
    0xC774,0xC774,0xC735,0xAD70,0xAD70,0xAC04,0xD658,0xCD5C,
    0xC120,0xC758,0xB7C9,0xAC15,0xACB8,0xC720,0xAC31,0xAC08,
    0xD0C4,0xC644,0xD76C,0xBC88,0xC804,0xBD84,0xC804,0xB834,
    0xB9AC,0xAC31,0xB204,0xC559,0xCC2C,0xC6B0,0xACF5,0xC608,
    0xCDA9,0xC639,0xBD84,0xAD49,0xC2DC,0xC2DC,0xCDE8,0xBD88,
    0xD569,0xBD84,0xC775,0xB78D,0xC775,0xD53C,0xB839,0xB8CC,
    0xC9C8,0xAD6C,0xC2B5,0xD790,0xC0C1,0xD761,0xD761,0xAC70,
    0xAD50,0xD670,0xD718,0xC18C,0xC0BD,0xAD49,0xAC15,0xC801,
    0xCDE8,0xBE44,0xC6B0,0xC0BD,0xC2DC,0xC800,0xC804,0xD6E4,
    0xC2DC,0xD3B8,0xC885,0xC644,0xD718,0xD6C4,0xD575,0xD559,
    0xD55C,0xACE0,0xD45C,0xC608,0xB828,0xD6C4,0xACE0,0xB9B0,
    0xBD84,0xAD50,0xACE0,0xBC88,0xC775,0xD670,0xD604,0xB3C4,
    # 0x8000 #
    0xC694,0xB85C,0xB85C,0xACE0,0xBAA8,0xC790,0xAE30,0xAD6C,
    0xAD6C,0xAD6C,0xC9C8,0xC9C8,0xC774,0xC0AC,0xC5F0,0xB0B4,
    0xB0B4,0xB2E8,0xB8B0,0xC815,0xC790,0xACBD,0xCD08,0xBAA8,
    0xC6B4,0xD30C,0xD53C,0xCE58,0xC0AC,0xCC98,0xAC00,0xAC70,
    0xD569,0xC11C,0xB85C,0xB95C,0xC801,0xB2F9,0xC6B0,0xB8E8,
    0xB204,0xAC15,0xBC29,0xCC30,0xB8E8,0xAE30,0xB85C,0xD655,
    0xC6B0,0xB9C8,0xD68C,0xC774,0xCCA9,0xC815,0xC57C,0xD0D1,
    0xC6A9,0xAE08,0xC6B4,0xCE58,0xB2F4,0xD0D0,0xAD49,0xACBD,
    0xC9C1,0xBD84,0xC12D,0xB2F4,0xC9C4,0xCCA0,0xB839,0xC815,
    0xC720,0xC648,0xB8CC,0xB871,0xC9C1,0xB155,0xC870,0xC774,
    0xC54C,0xC811,0xAD04,0xC11C,0xB828,0xD638,0xC131,0xB835,
    0xBE59,0xC815,0xCDE8,0xBE44,0xC800,0xAD35,0xBB38,0xC11C,
    0xBCD1,0xCD1D,0xC815,0xC544,0xC815,0xAD6C,0xCD1D,0xADDC,
    0xB828,0xC678,0xCD1D,0xB828,0xC639,0xADC0,0xB828,0xB828,
    0xCD1D,0xC624,0xC131,0xC6A9,0xCCAD,0xC678,0xC12D,0xC9C1,
    0xB2F4,0xB155,0xC808,0xC801,0xCCAD,0xCCAD,0xB871,0xC728,
    # 0x8080 #
    0xC0AC,0xC870,0xC0AC,0xC219,0xC774,0xC219,0xC0AC,0xC870,
    0xC870,0xC721,0xC5B5,0xB975,0xAE30,0xAD6C,0xAE0D,0xC870,
    0xD758,0xC801,0xD658,0xD669,0xC774,0xC778,0xCD08,0xC5EC,
    0xC8FC,0xC5F0,0xB450,0xD56D,0xC735,0xAC04,0xCC28,0xC624,
    0xC7A5,0xACE0,0xC9C0,0xAE08,0xBD80,0xBE44,0xBD84,0xBC30,
    0xBC29,0xACAC,0xBC29,0xC21C,0xC6B0,0xB20C,0xD56D,0xAE0D,
    0xC5F0,0xAD49,0xC721,0xBB38,0xD6A8,0xAE30,0xBE44,0xD73C,
    0xD790,0xD790,0xD3D0,0xAE0D,0xC815,0xD0DC,0xC2E0,0xC885,
    0xCC3D,0xD611,0xC2E0,0xC704,0xC8FC,0xC9C8,0xB2E8,0xD544,
    0xBC1C,0xBC15,0xAD6C,0xC810,0xBC30,0xACE0,0xD0DC,0xC790,
    0xAD74,0xC9C0,0xB2C8,0xD3C9,0xC790,0xBD80,0xBC18,0xC9C4,
    0xD604,0xC870,0xBC30,0xAC11,0xC131,0xC9C0,0xD3EC,0xBB34,
    0xAC70,0xD638,0xAC00,0xC774,0xC724,0xC11C,0xC559,0xB871,
    0xB3D9,0xCE74,0xB824,0xACBD,0xB178,0xC5F0,0xBC29,0xACE0,
    0xC774,0xAD11,0xD574,0xAC01,0xB3D9,0xCE58,0xD6A8,0xD749,
    0xD749,0xC774,0xC54C,0xD589,0xBCC0,0xB2A5,0xC790,0xADDC,
    # 0x8100 #
    0xC2B9,0xC870,0xC9C0,0xCDE8,0xB9E4,0xD611,0xCDE8,0xD611,
    0xB9E5,0xB9E5,0xCC99,0xD611,0xB144,0xD68C,0xC0B4,0xC7A5,
    0xC81C,0xB1CC,0xBBF8,0xB18D,0xB828,0xB9CC,0xBC1C,0xBB38,
    0xC644,0xAD6C,0xAC01,0xACBD,0xC720,0xD615,0xC88C,0xB82C,
    0xC804,0xC815,0xB9E4,0xC21C,0xC2E0,0xD611,0xD2B9,0xCD5C,
    0xCD09,0xC218,0xD754,0xD0C8,0xD3EC,0xC815,0xD1F4,0xD3EC,
    0xB450,0xD0C8,0xB1E8,0xB1CC,0xBE44,0xC624,0xB77C,0xB9AC,
    0xAC80,0xCC3D,0xC218,0xCCA9,0xB7C9,0xC218,0xBE44,0xD45C,
    0xB95C,0xBCC0,0xACFC,0xADC0,0xC218,0xB2F4,0xC804,0xB1CC,
    0xC815,0xAC1C,0xC11D,0xC561,0xC5C4,0xC784,0xC2E0,0xCCA0,
    0xBD80,0xBD80,0xAC70,0xBE44,0xAC15,0xC644,0xB3D9,0xBE44,
    0xAD35,0xC885,0xC815,0xC545,0xB9E4,0xBD80,0xC804,0xC9C8,
    0xC8FC,0xB77C,0xC6B0,0xC81C,0xC554,0xC131,0xB1CC,0xC218,
    0xCC9C,0xB0A8,0xC6B4,0xC885,0xC720,0xC545,0xC2DC,0xB3CC,
    0xC694,0xAC74,0xC678,0xAC01,0xC720,0xAC00,0xB2E8,0xD53D,
    0xC7A5,0xBCF5,0xC120,0xB2C8,0xBA74,0xC62C,0xB4F1,0xD1F4,
    # 0x8180 #
    0xBC29,0xACB8,0xB824,0xC62C,0xC218,0xB2F9,0xC18C,0xCD94,
    0xACA9,0xC775,0xBC15,0xB8CC,0xCC99,0xBE44,0xD574,0xACE0,
    0xB824,0xBE48,0xAD6C,0xC7A5,0xB85D,0xAD35,0xBC29,0xCD5C,
    0xD45C,0xAC15,0xBD80,0xB2F9,0xB9C9,0xC2AC,0xC804,0xB960,
    0xAD50,0xC789,0xB8E8,0xC9C8,0xC124,0xB780,0xB828,0xB3D9,
    0xD33D,0xB2C8,0xC2DC,0xB8CC,0xCDE8,0xAD34,0xD6A8,0xB4F1,
    0xBC88,0xC9C1,0xCD08,0xC120,0xBB34,0xCDCC,0xC724,0xD5A5,
    0xC218,0xBD84,0xC751,0xC804,0xACFC,0xB2F4,0xD68C,0xB18D,
    0xB454,0xB834,0xBE44,0xC639,0xAC39,0xCD09,0xC5B5,0xC804,
    0xB78D,0xAC80,0xC870,0xB454,0xACE0,0xC81C,0xCDE8,0xBE48,
    0xD6C8,0xB178,0xD655,0xC7A5,0xD604,0xD45C,0xD765,0xACE4,
    0xB78D,0xC5F0,0xB824,0xD655,0xC7A0,0xB77C,0xAD6C,0xC7A5,
    0xB828,0xB2C8,0xC7A0,0xC2E0,0xD604,0xC640,0xAD11,0xC7A5,
    0xB9BC,0xAD11,0xC790,0xAD50,0xC5BC,0xCDE8,0xAE30,0xACE0,
    0xCDE8,0xBA74,0xC5BC,0xC9C0,0xCE58,0xACA9,0xCC9C,0xC9C8,
    0xC9C4,0xC218,0xB300,0xC9C4,0xAD6C,0xD568,0xC720,0xC0BD,
    # 0x8200 #
    0xC694,0xC5EC,0xC6A9,0xC11D,0xC11D,0xAD6C,0xC5EC,0xC5EC,
    0xD765,0xAC70,0xAD6C,0xD754,0xC124,0xC0AC,0xC0AC,0xAD6C,
    0xC9C0,0xB2F4,0xC11C,0xC9C0,0xCCA8,0xB2F4,0xD3EC,0xD3EC,
    0xAD00,0xD654,0xCCA8,0xCC9C,0xC21C,0xD560,0xBB34,0xC8FC,
    0xB3C4,0xAC15,0xC0B0,0xCC28,0xBC94,0xD30C,0xD0DC,0xBC94,
    0xD310,0xC120,0xD56D,0xBC29,0xBC18,0xBE44,0xD638,0xC911,
    0xD568,0xCC3D,0xB839,0xCD95,0xCC45,0xD0C0,0xBC15,0xD604,
    0xAC00,0xC120,0xAC11,0xB85C,0xACF5,0xBC29,0xC11C,0xACFC,
    0xBD80,0xC870,0xBD09,0xB9AC,0xC18C,0xC5EC,0xB791,0xC815,
    0xB958,0xBBF8,0xBC15,0xB9F9,0xB150,0xAC70,0xD669,0xC218,
    0xC885,0xD3B8,0xBAA8,0xC811,0xB3C4,0xBC29,0xCC28,0xC775,
    0xC18C,0xCC3D,0xC870,0xB8E8,0xB300,0xC124,0xC694,0xB3D9,
    0xB4F1,0xB2F9,0xC7A5,0xB85C,0xC758,0xC9D1,0xD568,0xD655,
    0xBABD,0xC81C,0xB85C,0xB85C,0xCC38,0xC30D,0xAC04,0xB7C9,
    0xAC04,0xAC04,0xC0C9,0xC5FC,0xBD88,0xBCD1,0xC5FC,0xC5FC,
    0xCD08,0xCD08,0xC608,0xB975,0xC815,0xAD6C,0xC560,0xC789,
    # 0x8280 #
    0xCD08,0xADDC,0xC808,0xBD09,0xD658,0xC775,0xCC28,0xBA74,
    0xBBF8,0xAC04,0xCC9C,0xC6B0,0xC6B0,0xC791,0xAD81,0xD1A0,
    0xD558,0xAE30,0xB9DD,0xC790,0xD6FC,0xC720,0xCE58,0xD5A5,
    0xBE44,0xBD80,0xB454,0xC21C,0xBB34,0xC9C0,0xAC78,0xC0BC,
    0xBB38,0xAC80,0xC778,0xBD80,0xADDC,0xAC1C,0xD638,0xC11C,
    0xAE09,0xAE08,0xAE30,0xC6D0,0xBD84,0xD30C,0xC608,0xC2EC,
    0xAE30,0xD654,0xD654,0xBC29,0xD640,0xACB0,0xAD6C,0xC9C0,
    0xC6B4,0xADFC,0xC694,0xCD94,0xBAA8,0xC544,0xBE44,0xC789,
    0xD56D,0xC885,0xC74C,0xC6B0,0xBCC0,0xC608,0xC808,0xC704,
    0xB825,0xD544,0xC561,0xD604,0xC7A5,0xCC3D,0xC800,0xC18C,
    0xC81C,0xC6D0,0xC5FC,0xB839,0xD0DC,0xCD08,0xC801,0xBB18,
    0xACBD,0xB9BD,0xC6A9,0xAC00,0xBAA9,0xD328,0xD3EC,0xAD6C,
    0xBBFC,0xC774,0xC774,0xAC70,0xBE44,0xC57D,0xACE0,0xC800,
    0xB2C8,0xBC31,0xBCD1,0xC810,0xC218,0xC694,0xC120,0xBD84,
    0xD64D,0xC601,0xC791,0xB3D9,0xC800,0xC9C8,0xB0A0,0xAC10,
    0xD638,0xD3C9,0xB9E4,0xBD80,0xC0DD,0xACE0,0xD544,0xBBF8,
    # 0x8300 #
    0xBD88,0xC904,0xBB34,0xBC94,0xAC00,0xBAA8,0xBB18,0xBC1C,
    0xC790,0xB9D0,0xC790,0xC800,0xCE58,0xADF9,0xACBD,0xB871,
    0xCD1D,0xC870,0xC6D0,0xD608,0xD1A0,0xACBD,0xAC01,0xBA85,
    0xB824,0xC735,0xC778,0xAC04,0xCC9C,0xCC44,0xC2E0,0xC728,
    0xD734,0xC790,0xB82C,0xC624,0xB2E4,0xADDC,0xCC45,0xCDA9,
    0xC790,0xAD6C,0xAD11,0xB9DD,0xCE58,0xAD50,0xCD08,0xBCF5,
    0xC720,0xC218,0xC790,0xAC15,0xD68C,0xC778,0xB2E4,0xD328,
    0xC6A9,0xC5EC,0xCDA9,0xB9DD,0xB3D9,0xC911,0xACAC,0xCD95,
    0xC21C,0xD658,0xACFC,0xC804,0xD574,0xB2F5,0xD615,0xD589,
    0xCC9C,0xCD08,0xD615,0xC774,0xC548,0xAD50,0xCE58,0xC784,
    0xCC9C,0xC774,0xD669,0xBCD1,0xB824,0xADFC,0xBC30,0xC220,
    0xC7A5,0xB2EC,0xD611,0xC694,0xD544,0xC989,0xAD50,0xD68C,
    0xC81C,0xD0D5,0xC6B0,0xC1A1,0xD6C8,0xD615,0xB77D,0xD615,
    0xB2F4,0xC2E0,0xC190,0xC74C,0xB9E4,0xD64D,0xC870,0xC57D,
    0xB450,0xBBF8,0xB9AC,0xB450,0xBD80,0xC778,0xC74C,0xD558,
    0xBC1C,0xCD08,0xC724,0xC801,0xB3C4,0xC720,0xC218,0xC131,
    # 0x8380 #
    0xC2E0,0xBB34,0xBCC4,0xD76C,0xACBD,0xB9AC,0xBCF4,0xC870,
    0xBAB0,0xB9AC,0xC7A5,0xC791,0xD0C8,0xCD9C,0xC0AC,0xC0AC,
    0xCE68,0xBD09,0xAC70,0xB9E4,0xB9F9,0xD589,0xACBD,0xCC28,
    0xC2E0,0xAD70,0xC5F0,0xC815,0xC870,0xC88C,0xC644,0xD568,
    0xC720,0xCC29,0xD611,0xB9DD,0xC219,0xB274,0xC18C,0xD604,
    0xB791,0xBD80,0xC544,0xB9C9,0xBA74,0xC989,0xB0A8,0xBAA9,
    0xAC10,0xB798,0xB828,0xC2DC,0xC640,0xD1A0,0xB834,0xD68D,
    0xC720,0xC625,0xC575,0xB2A6,0xC21C,0xB9DD,0xB9DD,0xC790,
    0xC6B8,0xCCAD,0xC801,0xAC70,0xB3D9,0xAD00,0xCD94,0xACE0,
    0xB78D,0xB85D,0xAD6D,0xBBF8,0xADE0,0xC784,0xACE4,0xD558,
    0xBCF5,0xCE58,0xACE0,0xACFC,0xBCF5,0xB860,0xCC3D,0xC8FC,
    0xC22D,0xC218,0xC794,0xBB38,0xCC44,0xBC1C,0xB9AC,0xB3C4,
    0xD30C,0xD568,0xD3EC,0xAE34,0xAD8C,0xC11D,0xADFC,0xC800,
    0xC811,0xBCF4,0xD0D5,0xADFC,0xCD08,0xD0DC,0xACBD,0xD654,
    0xACE0,0xB989,0xBE44,0xAE08,0xC554,0xB9DD,0xBD09,0xCD94,
    0xC5B4,0xC800,0xACAC,0xB984,0xB2F4,0xC219,0xCCA8,0xB3C4,
    # 0x8400 #
    0xD638,0xAE30,0xD654,0xCDCC,0xB3C4,0xCD98,0xBE44,0xC7A5,
    0xD658,0xBE44,0xB798,0xCC98,0xB9F9,0xD3C9,0xC704,0xB2F4,
    0xC0BD,0xCD94,0xC5B8,0xC758,0xCD08,0xC81C,0xC644,0xCC45,
    0xB0B4,0xCE68,0xD0C1,0xAD6C,0xCCA9,0xB77C,0xBE44,0xD658,
    0xBD95,0xBC15,0xD3EC,0xC815,0xD615,0xC601,0xC601,0xC18C,
    0xC0B4,0xCD94,0xACFC,0xD5A5,0xB9CC,0xC6B0,0xC720,0xBD80,
    0xB828,0xD6E4,0xD6E4,0xB0A8,0xC989,0xC640,0xCD98,0xC18C,
    0xC720,0xD3B8,0xBAA8,0xC554,0xC545,0xB77D,0xC601,0xD65C,
    0xAD04,0xAC15,0xBA74,0xC801,0xC8FC,0xC800,0xBCF4,0xC720,
    0xC2DC,0xC5FD,0xC554,0xAD6C,0xAC04,0xBCF5,0xB960,0xC804,
    0xBD84,0xD48D,0xD64D,0xD64D,0xD6C4,0xC5F0,0xB3CC,0xC800,
    0xCE58,0xC0C1,0xC2EC,0xAC08,0xACC4,0xACBD,0xBBF8,0xD669,
    0xC0BC,0xD3EC,0xAC1C,0xB3D9,0xC870,0xC804,0xC704,0xBC1C,
    0xC678,0xD30C,0xACC4,0xD638,0xC7A5,0xAC00,0xB2E8,0xC57D,
    0xC900,0xCD1D,0xCC9C,0xC704,0xCE68,0xADDC,0xC815,0xD6C8,
    0xC0AC,0xC2DC,0xC999,0xB78C,0xC885,0xC694,0xC6D0,0xBBF8,
    # 0x8480 #
    0xC628,0xC220,0xCCB4,0xC804,0xAD00,0xC5FC,0xACF5,0xCC9C,
    0xAC1C,0xAD34,0xACF3,0xC7A5,0xB8E8,0xC704,0xD30C,0xC720,
    0xC218,0xC740,0xC0AC,0xC21C,0xC2DC,0xC628,0xC9C4,0xB791,
    0xB098,0xBABD,0xB825,0xACB0,0xC0B0,0xC6D0,0xB9AC,0xAD6C,
    0xC2DD,0xBC29,0xC81C,0xC11C,0xB3C4,0xB958,0xD655,0xC810,
    0xCC9C,0xC870,0xBC15,0xCC28,0xC6D0,0xCD94,0xC721,0xAD34,
    0xBC18,0xD3EC,0xD3EC,0xB0A9,0xC0AD,0xD61C,0xBD84,0xC6B4,
    0xC99D,0xACB8,0xC9C8,0xC57D,0xCC3D,0xC740,0xBBF8,0xD638,
    0xC190,0xC9C4,0xBA85,0xC218,0xCD95,0xB958,0xC11D,0xACE8,
    0xB791,0xC6A9,0xC639,0xAC1C,0xC88C,0xC2DC,0xB2F9,0xB77C,
    0xC695,0xC0AC,0xD55C,0xBC30,0xC694,0xACC4,0xBE44,0xC885,
    0xACE4,0xC88C,0xC218,0xCC45,0xBC30,0xB78C,0xB3C4,0xACC4,
    0xB9AC,0xC0BC,0xB791,0xC5EC,0xB989,0xD615,0xB9E5,0xC870,
    0xC218,0xBAA8,0xD1B5,0xCD95,0xBD09,0xC554,0xB828,0xCD1D,
    0xC0AC,0xD3C9,0xAD6C,0xADFC,0xC21C,0xCCA9,0xC720,0xD1F4,
    0xC870,0xC5B4,0xC608,0xC9D1,0xB8CC,0xD544,0xB85C,0xC219,
    # 0x8500 #
    0xBD80,0xC7A5,0xB958,0xAC15,0xB9CC,0xC5F0,0xB989,0xAE30,
    0xD45C,0xACE4,0xD55C,0xC801,0xC18D,0xB85D,0xC124,0xC0C1,
    0xC801,0xBA78,0xD6C8,0xB9CC,0xBCF5,0xCCB4,0xCC28,0xC790,
    0xC0BC,0xC120,0xC6B8,0xACE1,0xC624,0xBBF8,0xB8E8,0xC8FC,
    0xC885,0xCC44,0xD30C,0xC7A5,0xBC00,0xCD1D,0xC870,0xC138,
    0xAD8C,0xC778,0xC810,0xC5B8,0xC18C,0xC74C,0xADA4,0xC9C4,
    0xD638,0xC0B4,0xAD6C,0xCC9C,0xB9C8,0xC7A5,0xCC45,0xC7A5,
    0xB450,0xB834,0xB9B0,0xAD6C,0xC560,0xD3D0,0xB9AC,0xC704,
    0xADF9,0xB2F4,0xC2B9,0xBC88,0xB9F9,0xC6B0,0xCC9C,0xC804,
    0xC2EC,0xCD08,0xC608,0xC608,0xB958,0xC720,0xAD50,0xC800,
    0xD654,0xAC04,0xB9E4,0xC6B4,0xBCF4,0xC720,0xAC70,0xB85C,
    0xC694,0xD61C,0xC545,0xC81C,0xBE44,0xC808,0xCCB4,0xD3D0,
    0xC5EC,0xBD84,0xAD34,0xC21C,0xC720,0xC544,0xC218,0xBCF5,
    0xAD90,0xD0D5,0xBB34,0xB3D9,0xC0AC,0xC18C,0xC11D,0xB96D,
    0xC628,0xCD08,0xAE30,0xAC04,0xC628,0xC190,0xB839,0xC5EC,
    0xD558,0xC639,0xC999,0xD64D,0xC0AC,0xB18D,0xB8B0,0xD6E4,
    # 0x8580 #
    0xC628,0xC6B1,0xACA9,0xD638,0xBC15,0xD638,0xC560,0xBBF8,
    0xD68C,0xC608,0xACC4,0xC790,0xD5A5,0xC644,0xBA78,0xC758,
    0xB989,0xAC15,0xCC2C,0xC0BC,0xC7A5,0xB834,0xACFC,0xC6D0,
    0xB2EC,0xCE58,0xD0D5,0xC124,0xBCBD,0xB2F4,0xC190,0xB834,
    0xBC88,0xC815,0xD574,0xACE0,0xD574,0xCD09,0xCC9C,0xACE0,
    0xD6D9,0xC0B4,0xC2E0,0xD6C8,0xC57D,0xBE44,0xC218,0xC11C,
    0xD6C8,0xB300,0xBE48,0xC6D0,0xB155,0xC8FC,0xB9E4,0xC720,
    0xD45C,0xB300,0xC81C,0xC870,0xC9C4,0xC9C4,0xC774,0xC758,
    0xD615,0xACE0,0xCD1D,0xD638,0xAE30,0xBC8C,0xAC74,0xC11C,
    0xADDC,0xC790,0xBCC0,0xC870,0xBC00,0xB78C,0xC2E0,0xC7A5,
    0xBB18,0xACBD,0xAC78,0xC120,0xB8CC,0xC6B0,0xC0B0,0xC18D,
    0xB824,0xC758,0xC18D,0xC0AC,0xB824,0xC608,0xC57D,0xB958,
    0xD6A8,0xC801,0xCE58,0xD53C,0xB4F1,0xC57D,0xB9C8,0xD658,
    0xD45C,0xBC88,0xC218,0xB2F4,0xD1F4,0xAD81,0xCD08,0xC704,
    0xB958,0xD68C,0xCD94,0xACE0,0xC628,0xBCF4,0xB825,0xC800,
    0xC800,0xC560,0xB9B0,0xC870,0xD6E4,0xCE5C,0xB8B0,0xACFD,
    # 0x8600 #
    0xD0C1,0xC624,0xC608,0xC608,0xAE30,0xD615,0xB85C,0xC18C,
    0xD1F4,0xB9DD,0xC628,0xBE48,0xC5B4,0xD6C8,0xAE30,0xACBD,
    0xD6E4,0xB9C8,0xAD6C,0xC5B4,0xB3D9,0xBD09,0xC5BC,0xBCBD,
    0xC591,0xC608,0xC120,0xC721,0xAD6D,0xB834,0xB834,0xC740,
    0xC7A5,0xC601,0xB871,0xD22C,0xC704,0xC57D,0xB839,0xAC70,
    0xC694,0xBC88,0xBBF8,0xB78C,0xADC0,0xB780,0xACC4,0xD0D5,
    0xB9CC,0xB958,0xB958,0xD734,0xD48D,0xC9C1,0xC704,0xAE30,
    0xC7A0,0xD68C,0xB9AC,0xACC4,0xBBF8,0xB958,0xAD34,0xB77C,
    0xC81C,0xAE30,0xB85C,0xCCA8,0xC0B4,0xB4F1,0xB958,0xAD8C,
    0xD6A8,0xC5ED,0xB780,0xBB38,0xBCC4,0xD638,0xD638,0xB85C,
    0xD559,0xD544,0xC0AC,0xD6A8,0xAC74,0xCC98,0xD638,0xD5C8,
    0xCC28,0xBCF5,0xD5C8,0xD5C8,0xB85C,0xD638,0xC6B0,0xD638,
    0xAD50,0xAC70,0xAD35,0xD3EC,0xD604,0xC794,0xC794,0xD734,
    0xBC18,0xD601,0xC219,0xD6FC,0xADDC,0xB3C4,0xAE30,0xADDC,
    0xC815,0xC2AC,0xBCF5,0xAD74,0xCC45,0xC0AC,0xC6B0,0xAC04,
    0xC790,0xD64D,0xD6FC,0xB9F9,0xD758,0xC218,0xD558,0xCC44,
    # 0x8680 #
    0xC2DD,0xC758,0xB9C8,0xD5A5,0xBC29,0xC561,0xD30C,0xCC99,
    0xACAC,0xBB38,0xBB38,0xC608,0xBC29,0xBE44,0xC6D4,0xC6D4,
    0xADE0,0xAE30,0xB3D9,0xC778,0xAE30,0xCC9C,0xC6D0,0xACB0,
    0xD68C,0xAE08,0xAE30,0xC911,0xC544,0xC790,0xBAA9,0xC655,
    0xBD84,0xBD84,0xD56D,0xACF5,0xC870,0xBCF4,0xC5FC,0xAC1C,
    0xBD80,0xCE58,0xB450,0xD3EC,0xD604,0xB2C8,0xD2B9,0xAD6C,
    0xC720,0xCC45,0xD3C9,0xC9C0,0xC720,0xAC00,0xAC10,0xAC70,
    0xB825,0xBD80,0xC5FC,0xCC30,0xAD6C,0xBE44,0xD30C,0xD604,
    0xC8FC,0xC870,0xBCC4,0xBCD1,0xACE0,0xC810,0xC800,0xC0AC,
    0xCCA0,0xB839,0xACE0,0xB2E8,0xACE0,0xD615,0xB824,0xC815,
    0xACE1,0xBAA8,0xACA9,0xC790,0xD68C,0xD68C,0xBC29,0xBD80,
    0xC591,0xC640,0xB82C,0xC8FC,0xC774,0xD55C,0xD65C,0xAD50,
    0xB824,0xC775,0xBCD1,0xAE38,0xD569,0xC124,0xC774,0xB9DD,
    0xB9E5,0xACF5,0xACB0,0xADA4,0xACF5,0xC9C8,0xB9CC,0xB178,
    0xCE69,0xD611,0xC694,0xC0AC,0xC81C,0xD615,0xB82C,0xAD6C,
    0xC18C,0xC6A9,0xD611,0xC138,0xCC28,0xD328,0xC544,0xD568,
    # 0x8700 #
    0xCD09,0xC120,0xBD09,0xC2E0,0xC9C4,0xD3EC,0xD604,0xCCA0,
    0xC624,0xBD80,0xB9AC,0xB791,0xD3D0,0xC11C,0xC5F0,0xC720,
    0xAC81,0xB2E8,0xC5F0,0xC815,0xC804,0xD0DC,0xD68C,0xC640,
    0xC9C0,0xC1A1,0xBE44,0xAC70,0xBC00,0xAE30,0xAE30,0xC721,
    0xAD70,0xC0AC,0xB9F9,0xAC15,0xC0AC,0xC11D,0xB95C,0xB824,
    0xC811,0xC870,0xB3C4,0xACE4,0xD568,0xD568,0xC5ED,0xBC29,
    0xBE44,0xBE44,0xC704,0xC724,0xCC99,0xC5F0,0xC194,0xAD8C,
    0xACAC,0xC608,0xC608,0xCCAD,0xC720,0xB7C9,0xACFC,0xC6D0,
    0xB3D9,0xC545,0xD310,0xCCB4,0xB9DD,0xC7A0,0xC591,0xC2B9,
    0xAD35,0xC120,0xC815,0xB78D,0xACFC,0xC989,0xAC08,0xC815,
    0xBAA8,0xC11C,0xBA74,0xC720,0xAC1C,0xC2DD,0xD6E4,0xD669,
    0xC5B8,0xD3B8,0xC720,0xC704,0xBD80,0xC5F0,0xBBF8,0xC704,
    0xBCF5,0xC724,0xD608,0xC720,0xC720,0xBAA8,0xD558,0xC601,
    0xC2AC,0xC911,0xD0D5,0xC800,0xC885,0xC81C,0xBCF5,0xC6D0,
    0xADDC,0xB9F9,0xB784,0xB3C5,0xD638,0xCD94,0xC811,0xB825,
    0xC640,0xC6B4,0xAD6C,0xB0A8,0xB8E8,0xCD98,0xC601,0xC2B9,
    # 0x8780 #
    0xC7A5,0xD1F4,0xB791,0xBC29,0xC0AC,0xC2E4,0xC790,0xD61C,
    0xC6D0,0xC639,0xB834,0xC218,0xBC18,0xC735,0xC735,0xC9C8,
    0xC624,0xD6C4,0xD55C,0xC9C4,0xC774,0xBE44,0xD65C,0xB2F9,
    0xC758,0xB450,0xB0B4,0xD560,0xACE1,0xD68C,0xB9C8,0xBA85,
    0xC758,0xBB38,0xD615,0xB4F1,0xC720,0xCC3D,0xC18C,0xAE30,
    0xB9CC,0xC870,0xC0C1,0xC11D,0xC870,0xB9AC,0xCCB4,0xC624,
    0xB85D,0xC704,0xC9C8,0xB2F9,0xC9C4,0xD45C,0xAC70,0xBE44,
    0xC720,0xC810,0xB77C,0xB8E8,0xADFC,0xC885,0xC778,0xC7A5,
    0xC194,0xBB38,0xAD50,0xB9CC,0xCE69,0xC790,0xB9C8,0xB9C8,
    0xAD35,0xB8CC,0xBAA8,0xC2E4,0xCD1D,0xB9AC,0xB9CC,0xC18C,
    0xC0C1,0xC7A5,0xB9DD,0xC0C1,0xBB35,0xC8FC,0xC0AC,0xCD94,
    0xD2B9,0xC9C1,0xD33D,0xD33D,0xAD50,0xAC70,0xBCC4,0xB8CC,
    0xBC18,0xC704,0xD76C,0xAE30,0xC804,0xD669,0xBE44,0xB85C,
    0xAD90,0xAD90,0xD61C,0xB2F4,0xC120,0xCD08,0xC120,0xC694,
    0xC18C,0xBAA8,0xCDA9,0xC2EC,0xC0AC,0xC8FC,0xC815,0xB2F9,
    0xB824,0xD574,0xC120,0xC758,0xACBD,0xB2EC,0xC12C,0xACC4,
    # 0x8800 #
    0xC790,0xD5A5,0xC12D,0xB77C,0xAE08,0xC2B9,0xCC44,0xB824,
    0xC801,0xD604,0xB834,0xCD09,0xD0DD,0xAC08,0xB9DD,0xD574,
    0xC81C,0xC601,0xACAC,0xBABD,0xD638,0xC5F0,0xD655,0xD0C1,
    0xC808,0xBE48,0xD559,0xBA78,0xBC88,0xB8B0,0xC808,0xB78D,
    0xBC00,0xB824,0xC900,0xB824,0xCD94,0xC5BC,0xB85C,0xB450,
    0xC18C,0xC800,0xB871,0xB9AC,0xB8E1,0xBD09,0xC5F4,0xBE44,
    0xC0C1,0xACE0,0xACAC,0xC601,0xC11C,0xD734,0xC7A0,0xAD6C,
    0xAD8C,0xB450,0xC7A0,0xB9CC,0xAD6C,0xC808,0xCD09,0xCC30,
    0xD608,0xD669,0xB275,0xBC30,0xB275,0xD754,0xC911,0xB9E5,
    0xC774,0xAC1D,0xBA78,0xD601,0xD589,0xC5F0,0xAC04,0xC6D0,
    0xAC70,0xB839,0xD604,0xC220,0xD568,0xB3D9,0xD56D,0xAC00,
    0xD568,0xC544,0xD638,0xC704,0xB3C4,0xCDA9,0xC704,0xB3C4,
    0xC21C,0xD615,0xAD6C,0xC758,0xC758,0xBCF4,0xAC04,0xC6B0,
    0xD45C,0xCC28,0xC774,0xC0BC,0xCE5C,0xBD80,0xACE4,0xBD84,
    0xC1E0,0xAC81,0xB0A9,0xC885,0xB2F4,0xC77C,0xC911,0xCDA9,
    0xAC1C,0xAE30,0xC0AC,0xC5FC,0xC9C0,0xC784,0xAE08,0xAE08,
    # 0x8880 #
    0xADE0,0xC6D0,0xBA8C,0xC81C,0xC624,0xB1E8,0xC704,0xB2E8,
    0xAC00,0xD0C0,0xB839,0xB300,0xD3EC,0xD3EC,0xC694,0xC88C,
    0xD544,0xC18C,0xB2E8,0xC800,0xD558,0xC220,0xC218,0xC9C4,
    0xC774,0xD30C,0xBC1C,0xC800,0xB9D0,0xBD80,0xACE4,0xC9C8,
    0xC9C8,0xC5FC,0xBC88,0xC608,0xBB34,0xD0C1,0xAD74,0xAD6C,
    0xD604,0xC810,0xAC70,0xD53C,0xC721,0xC2B5,0xCE58,0xBC1C,
    0xBB34,0xBCF5,0xC774,0xCE58,0xACE0,0xC784,0xAC15,0xAC81,
    0xC874,0xB9D0,0xACB0,0xC774,0xAC01,0xB140,0xC8FC,0xADDC,
    0xC778,0xC7AC,0xB82C,0xB871,0xD589,0xC7A5,0xB2F9,0xD608,
    0xACE4,0xAC04,0xB1E8,0xC218,0xACB9,0xACE4,0xC815,0xB9AC,
    0xACAC,0xC2E0,0xBD80,0xADF9,0xC608,0xC720,0xC9C4,0xB958,
    0xAD6C,0xAD70,0xC81C,0xC74D,0xBCF4,0xC7A5,0xC138,0xC0AC,
    0xAD70,0xB9AC,0xB828,0xCCA8,0xACE0,0xAC04,0xD3EC,0xCCA8,
    0xBE44,0xACE4,0xB3C4,0xC5F0,0xB989,0xCE58,0xCC3D,0xC8FC,
    0xCCA0,0xD45C,0xB7C9,0xC0C1,0xBC30,0xBC30,0xBE44,0xAD8C,
    0xB77C,0xACFC,0xC554,0xB3C5,0xC11D,0xC81C,0xAC70,0xAE30,
    # 0x8900 #
    0xAE30,0xCC99,0xAD18,0xAE0D,0xCC98,0xCCB4,0xC81C,0xBCF5,
    0xC911,0xC124,0xD3B8,0xC811,0xACE4,0xB2E8,0xC720,0xC720,
    0xAC08,0xC6D0,0xD3EC,0xBCF4,0xBD80,0xC720,0xB2E8,0xC5B8,
    0xC704,0xBC30,0xC800,0xB8E8,0xD3EC,0xB2E8,0xC628,0xB2F5,
    0xAD6C,0xB2F5,0xD68C,0xC6A9,0xC6D0,0xC695,0xB0B4,0xACBD,
    0xCC28,0xBC18,0xD1F4,0xCE58,0xC0C1,0xB1E8,0xD615,0xC11D,
    0xAC74,0xD68C,0xACE0,0xB828,0xB78C,0xB9AC,0xC2B5,0xC2DC,
    0xB8E8,0xC608,0xCCA9,0xC124,0xC120,0xC704,0xD45C,0xC870,
    0xC801,0xAC15,0xC0BC,0xD3EC,0xC591,0xD544,0xBCF5,0xAC04,
    0xC120,0xAC04,0xCD2C,0xADF9,0xB2E8,0xC7A1,0xBC88,0xBC1C,
    0xC0C1,0xC2EC,0xBCC4,0xC694,0xB9CC,0xB780,0xC624,0xD0C1,
    0xAD34,0xC870,0xC218,0xB18D,0xCCA8,0xCCA8,0xBCBD,0xAE08,
    0xB2F9,0xCD09,0xB2E8,0xBE44,0xB78C,0xBCF5,0xC720,0xCE58,
    0xB300,0xCD09,0xB9D0,0xC11D,0xD53C,0xD790,0xBC15,0xCE5C,
    0xB8B0,0xB871,0xC2B5,0xC12C,0xB780,0xC811,0xB300,0xAC70,
    0xCC2C,0xC2DC,0xACAC,0xBC18,0xC608,0xB780,0xC544,0xC11C,
    # 0x8980 #
    0xC544,0xC694,0xBD09,0xB2F4,0xBCF5,0xBB18,0xBCF5,0xD328,
    0xD575,0xAE30,0xAE30,0xACAC,0xAD00,0xBCC0,0xC5C4,0xADDC,
    0xAC01,0xD3B8,0xBAA8,0xBA71,0xBA71,0xBCC4,0xC2DC,0xC0AC,
    0xC810,0xB77C,0xAC01,0xB9E5,0xC870,0xB834,0xC694,0xC9C0,
    0xADE0,0xACA9,0xC12C,0xC704,0xD601,0xC804,0xC720,0xB78C,
    0xC545,0xB3C4,0xCE5C,0xBC29,0xAE30,0xBA85,0xC601,0xAD6C,
    0xCC98,0xCC38,0xADFC,0xAD00,0xB4F1,0xD55C,0xB77C,0xCC98,
    0xAC04,0xBBF8,0xAC01,0xCC98,0xB77C,0xB78C,0xC2EC,0xC801,
    0xAD00,0xACAC,0xAD00,0xC5C4,0xADDC,0xBA71,0xC2DC,0xC810,
    0xB78C,0xAC01,0xAE30,0xACA9,0xC801,0xC804,0xC720,0xAD6C,
    0xADFC,0xCC98,0xAC01,0xAD6C,0xADFC,0xCD94,0xACB0,0xC9C0,
    0xCD08,0xAE09,0xACE0,0xB2E8,0xC790,0xC800,0xC0C1,0xD574,
    0xAD8C,0xACA9,0xC11C,0xD574,0xADA4,0xAD49,0xCD09,0xD574,
    0xD63C,0xAD6C,0xC131,0xC18D,0xC608,0xAE30,0xB85D,0xCE58,
    0xB2E4,0xD544,0xC131,0xACE1,0xC0C1,0xAD49,0xCE58,0xD559,
    0xCD09,0xD734,0xC758,0xB825,0xACB0,0xD734,0xC5F0,0xD734,
    # 0x8A00 #
    0xC5B8,0xC5B8,0xC815,0xBD80,0xAD6C,0xAD6C,0xADDC,0xAD49,
    0xACC4,0xBC94,0xC2E0,0xC870,0xD64D,0xCC28,0xD1A0,0xC6B0,
    0xC54C,0xC774,0xC778,0xD6C8,0xC740,0xC0B0,0xD758,0xD0C1,
    0xAE30,0xC2E0,0xC740,0xC640,0xBD84,0xC544,0xC694,0xC1A1,
    0xC2E0,0xC74C,0xD754,0xACB0,0xD6A8,0xB20C,0xC6B0,0xC6B0,
    0xC9C0,0xD749,0xBC29,0xC2E0,0xCD08,0xC124,0xD604,0xC0AC,
    0xC900,0xD5C8,0xC5B5,0xC5ED,0xC18C,0xCE58,0xAC00,0xC2E0,
    0xD654,0xC218,0xC9C4,0xC8FC,0xC815,0xAD6C,0xC790,0xC790,
    0xCC38,0xACE0,0xBD80,0xACAC,0xC9C8,0xB839,0xC800,0xC559,
    0xB9AC,0xB178,0xBC18,0xC8FC,0xAC10,0xC608,0xAC70,0xC694,
    0xC0AC,0xC774,0xC774,0xAC70,0xC870,0xD3C9,0xD53C,0xD615,
    0xAD74,0xBC1C,0xB2EC,0xC800,0xB3C4,0xC800,0xC0AC,0xC12D,
    0xC601,0xD6C4,0xC21C,0xC608,0xD669,0xD569,0xC2DC,0xCC30,
    0xD6A8,0xC2DC,0xD604,0xD0C0,0xAD6C,0xADA4,0xC804,0xD68C,
    0xD790,0xD654,0xD574,0xC0C1,0xC678,0xC120,0xC218,0xB3D9,
    0xBBF8,0xCCA8,0xBA85,0xC561,0xD68C,0xD604,0xD749,0xAD18,
    # 0x8A80 #
    0xC774,0xBCD1,0xC870,0xCE58,0xB8B0,0xC8FC,0xAD11,0xACFC,
    0xBB34,0xC608,0xB4F1,0xAE30,0xC9C0,0xC778,0xC18D,0xB791,
    0xC544,0xAD11,0xD76C,0xC11C,0xC815,0xD0C4,0xD328,0xC810,
    0xC720,0xACBD,0xCD08,0xCE68,0xC0AC,0xC554,0xC5B4,0xD6A8,
    0xC131,0xACC4,0xD604,0xBB34,0xC624,0xACE0,0xC1A1,0xD3EC,
    0xD68C,0xACBD,0xC124,0xC9C4,0xC124,0xB3C5,0xD654,0xCC3D,
    0xC218,0xCCA9,0xACFC,0xAD74,0xC885,0xD6A8,0xC218,0xB9DD,
    0xD604,0xBE44,0xCE58,0xB2F5,0xC758,0xB098,0xC740,0xC870,
    0xBE44,0xCCA0,0xCCA8,0xCE68,0xC21C,0xAE30,0xAE30,0xB2F4,
    0xCD94,0xC704,0xAD6D,0xCCAD,0xB3D9,0xC7C1,0xCC45,0xCD94,
    0xAC74,0xCC29,0xB7C9,0xC804,0xC219,0xD558,0xB860,0xC2EC,
    0xD45C,0xD68C,0xBC94,0xC720,0xCCA9,0xC11C,0xD3B8,0xC2DC,
    0xD6E4,0xC2DC,0xC6D0,0xACFC,0xC545,0xC885,0xCCB4,0xD574,
    0xBCF5,0xBCF4,0xC815,0xAC04,0xACC4,0xC720,0xC790,0xC804,
    0xC2DC,0xD718,0xC778,0xC554,0xD568,0xB0A8,0xC2EC,0xD48D,
    0xC81C,0xC591,0xC5B8,0xD669,0xD6E4,0xACA9,0xB099,0xC9D1,
    # 0x8B00 #
    0xBAA8,0xC54C,0xC704,0xC131,0xB4F1,0xCD08,0xC120,0xAC74,
    0xD3EC,0xAD34,0xD669,0xD68D,0xAC00,0xC601,0xBBF8,0xC18C,
    0xBC00,0xD61C,0xCC3D,0xC9C4,0xD559,0xC81C,0xC18D,0xBC29,
    0xC9C0,0xACB8,0xC775,0xAC15,0xC6D0,0xC0AC,0xD559,0xB3C4,
    0xC694,0xC694,0xD68D,0xC6B0,0xD45C,0xCD1D,0xACBD,0xB9AC,
    0xBAA8,0xBAA8,0xC0C1,0xC801,0xB958,0xC804,0xCC45,0xC870,
    0xB828,0xB8E8,0xCC38,0xAD6C,0xACE4,0xC2B5,0xC791,0xC624,
    0xC624,0xADFC,0xC9D1,0xC774,0xD638,0xAC15,0xB9CC,0xC870,
    0xD568,0xD654,0xCC9C,0xD6C4,0xC99D,0xC0BD,0xD76C,0xCC28,
    0xB300,0xC99D,0xB1E8,0xB780,0xC640,0xC751,0xD73C,0xAE30,
    0xC900,0xAD50,0xD30C,0xD61C,0xC120,0xBB34,0xCC38,0xC7A1,
    0xC2DD,0xCD08,0xB2F4,0xCC38,0xBCF4,0xC2B9,0xD604,0xC870,
    0xD0C4,0xB2F9,0xC218,0xD5D8,0xACA9,0xAD50,0xACBD,0xC7A0,
    0xB204,0xC758,0xC560,0xC12C,0xBE44,0xD6FC,0xD654,0xC5ED,
    0xC758,0xC120,0xC591,0xB204,0xACAC,0xB300,0xB2F5,0xD638,
    0xC8FC,0xD638,0xC758,0xC575,0xAC10,0xC608,0xC804,0xD61C,
    # 0x8B80 #
    0xB3C5,0xC801,0xD604,0xCC2C,0xB8B0,0xC2EC,0xC704,0xCCA8,
    0xB825,0xC720,0xBCC0,0xC12D,0xC5F0,0xC545,0xC218,0xC704,
    0xC218,0xC694,0xCC38,0xC591,0xC740,0xB780,0xCC38,0xD68D,
    0xC12D,0xD658,0xCC2C,0xC608,0xB2F9,0xC12C,0xC5B8,0xB3C5,
    0xC5B8,0xACC4,0xC815,0xBD80,0xC778,0xAE30,0xC54C,0xD64D,
    0xD1A0,0xC591,0xC0B0,0xD758,0xD0C1,0xD6C8,0xC758,0xC2E0,
    0xAE30,0xC778,0xAC15,0xD718,0xAD6C,0xAC70,0xC544,0xB20C,
    0xD5C8,0xC640,0xB860,0xD749,0xC1A1,0xD48D,0xC124,0xBC29,
    0xACB0,0xC815,0xACE0,0xAC00,0xD3C9,0xC800,0xC2E0,0xD615,
    0xC0AC,0xC18C,0xC9C4,0xC800,0xCD08,0xC0AC,0xAD74,0xC870,
    0xD53C,0xC5ED,0xC774,0xAD11,0xB8B0,0xC2DC,0xAD18,0xC2DC,
    0xD790,0xD68C,0xC131,0xC8FC,0xC120,0xD654,0xD0C4,0xAD6C,
    0xC804,0xADA4,0xC21C,0xC608,0xC7C1,0xD574,0xC0C1,0xD0C0,
    0xC6D0,0xD6C4,0xC8FC,0xACC4,0xBB34,0xC5B4,0xCD08,0xC624,
    0xACE0,0xC720,0xD68C,0xAD11,0xC124,0xC1A1,0xD76C,0xCCAD,
    0xC81C,0xCD94,0xB099,0xB3C5,0xCC29,0xBE44,0xACFC,0xC704,
    # 0x8C00 #
    0xC720,0xC218,0xC2EC,0xC870,0xCCA8,0xB7C9,0xC21C,0xC218,
    0xB2F4,0xC2EC,0xC758,0xBAA8,0xC2EC,0xCCA9,0xD669,0xAC04,
    0xD574,0xD559,0xC54C,0xC704,0xC545,0xC720,0xD6E4,0xCC38,
    0xC790,0xC554,0xC5B8,0xCCB4,0xBBF8,0xD3B8,0xC11C,0xBAA8,
    0xB2F9,0xC18D,0xC0AC,0xC694,0xBC29,0xC775,0xACB8,0xBC00,
    0xADFC,0xB9CC,0xC801,0xC804,0xB958,0xB2F4,0xCC38,0xCD08,
    0xB780,0xBCF4,0xD73C,0xC5B8,0xACAC,0xC12C,0xCC38,0xACE1,
    0xCC9C,0xD6A1,0xD558,0xAC39,0xD64D,0xD568,0xD64D,0xACC4,
    0xD61C,0xD65C,0xB8CC,0xD568,0xB3C5,0xB871,0xB450,0xAC15,
    0xAE30,0xC2DC,0xD48D,0xB4F1,0xC644,0xBE44,0xC218,0xD568,
    0xD48D,0xC9C8,0xC9C8,0xC5FC,0xC5FC,0xC2DC,0xCD95,0xD68C,
    0xB3C8,0xC758,0xB3C8,0xC5ED,0xACAC,0xD30C,0xD6C4,0xC561,
    0xC800,0xC0C1,0xD658,0xACAC,0xAC04,0xD574,0xAC70,0xBD80,
    0xD76C,0xBE48,0xD638,0xC608,0xC800,0xAC00,0xBD84,0xD61C,
    0xD639,0xC628,0xC6D0,0xBE48,0xC801,0xC885,0xBD84,0xD76C,
    0xCE58,0xD45C,0xC2DC,0xD55C,0xBE44,0xB19C,0xBE44,0xAD6C,
    # 0x8C80 #
    0xB19C,0xC720,0xCD08,0xB9E5,0xC0AC,0xD734,0xD6E4,0xAC04,
    0xD559,0xB9E5,0xB9E5,0xD55C,0xBAA8,0xB9AC,0xC608,0xD53C,
    0xC720,0xAC00,0xB2E8,0xBB18,0xBE44,0xD734,0xC561,0xB8E8,
    0xB9E5,0xCD94,0xB2E8,0xD658,0xD655,0xD328,0xC815,0xC6D0,
    0xBD80,0xC7AC,0xACF5,0xD2B9,0xC774,0xD56D,0xC644,0xBE48,
    0xD654,0xD310,0xD0D0,0xAD00,0xCC45,0xC9C8,0xC774,0xC800,
    0xC138,0xD53C,0xC790,0xC774,0xADC0,0xD3B8,0xD3C4,0xB9E4,
    0xB300,0xC0DD,0xD669,0xBE44,0xCCA9,0xC774,0xC9C0,0xBB34,
    0xD558,0xBD84,0xB8B0,0xC784,0xD68C,0xD574,0xBCC0,0xC790,
    0xAC00,0xD73C,0xC801,0xAD50,0xD574,0xC7A5,0xCC9C,0xC601,
    0xC21C,0xC9C4,0xC0AC,0xBE48,0xBE48,0xAD6C,0xC0AC,0xAD00,
    0xC7A5,0xC8FC,0xB8B0,0xCC2C,0xC0AC,0xCE68,0xC0C1,0xC804,
    0xBC30,0xAC31,0xD604,0xB9E4,0xCC9C,0xC218,0xBD80,0xD0D0,
    0xC885,0xC885,0xC9C8,0xC7AC,0xC7A5,0xB3C4,0xC2E0,0xD615,
    0xCD98,0xC6B4,0xBCF4,0xC7AC,0xB8B0,0xBD09,0xCC3D,0xC7AC,
    0xC789,0xC560,0xC7A0,0xBD80,0xAD6C,0xC0C8,0xC0C9,0xB8CC,
    # 0x8D00 #
    0xC704,0xD328,0xC0BC,0xC644,0xC9C0,0xCDCC,0xD45C,0xC724,
    0xC99D,0xB2F4,0xCC2C,0xC548,0xBCF5,0xC12C,0xB9CC,0xC601,
    0xC2E0,0xAC10,0xD604,0xC7A5,0xBE44,0xB3C5,0xC18D,0xC548,
    0xC0C1,0xD604,0xB8E1,0xACF5,0xC7A5,0xD328,0xC815,0xBD80,
    0xC6D0,0xACF5,0xC7AC,0xCC45,0xD604,0xD328,0xC7A5,0xD654,
    0xC9C8,0xD310,0xD0D0,0xBE48,0xD3C4,0xAD6C,0xC800,0xAD00,
    0xC774,0xCC9C,0xBD84,0xC138,0xCCA9,0xADC0,0xD669,0xB300,
    0xBB34,0xBE44,0xD558,0xC774,0xC801,0xC9C0,0xAC00,0xD68C,
    0xC790,0xC784,0xB8B0,0xC7A5,0xC790,0xD574,0xC2E0,0xAD6C,
    0xC9C4,0xB8B0,0xC0AC,0xBD80,0xB3C4,0xC7AC,0xC18D,0xC0C1,
    0xC0AC,0xBE44,0xC8FC,0xAC31,0xBC30,0xD0D0,0xB8B0,0xBD09,
    0xCDCC,0xBD80,0xC7A0,0xC0C8,0xC0C9,0xC548,0xCC2C,0xC724,
    0xC99D,0xC12C,0xC601,0xACF5,0xC801,0xD601,0xC0AC,0xB09C,
    0xB3D9,0xD601,0xC815,0xD601,0xC815,0xC790,0xD558,0xB2F9,
    0xC8FC,0xC8FC,0xB825,0xADDC,0xBD80,0xC870,0xAC04,0xAE30,
    0xC0B0,0xACBD,0xAE08,0xC120,0xC790,0xACB0,0xADFC,0xC9C0,
    # 0x8D80 #
    0xC790,0xC9C4,0xC9C4,0xC808,0xC800,0xCD08,0xC800,0xC2ED,
    0xC7A0,0xAD74,0xC6D4,0xCD94,0xAE38,0xCD94,0xC8FC,0xD65C,
    0xD608,0xC790,0xC870,0xD0C0,0xB82C,0xAC04,0xC88C,0xCD09,
    0xD601,0xC870,0xC18D,0xC74C,0xAD6D,0xACB8,0xC791,0xC7C1,
    0xCD08,0xC720,0xB85D,0xCDE8,0xD0D5,0xCD94,0xC790,0xC81C,
    0xCD94,0xCE59,0xD669,0xAD50,0xAD50,0xCD08,0xC870,0xC801,
    0xC774,0xCC2C,0xCC2C,0xC871,0xD30C,0xBC15,0xC624,0xD758,
    0xB3C8,0xACB0,0xBD80,0xCC38,0xACAC,0xBC29,0xC9C0,0xC0BD,
    0xC6D4,0xD30C,0xAE30,0xC57D,0xCC3D,0xD0C1,0xD0DC,0xC608,
    0xC804,0xB839,0xB9E4,0xBC1C,0xC9C8,0xACE0,0xD0C0,0xAC00,
    0xCC28,0xD3EC,0xAC00,0xC8FC,0xAD6C,0xC811,0xCC99,0xBD80,
    0xBC18,0xC800,0xC0B0,0xD30C,0xB2C8,0xAC70,0xB825,0xADFC,
    0xC774,0xC801,0xB2E4,0xC120,0xAD50,0xD0C0,0xC8FC,0xC804,
    0xACFC,0xC138,0xADA4,0xACF5,0xADDC,0xD56D,0xCE58,0xB85C,
    0xBCC0,0xCE58,0xAC81,0xB3C4,0xC120,0xCC9C,0xB2EC,0xAD50,
    0xD544,0xC120,0xD0C0,0xC81C,0xAD6D,0xAE30,0xC219,0xB3C4,
    # 0x8E00 #
    0xCD09,0xACBD,0xC12D,0xC18C,0xBCF4,0xC608,0xC900,0xBB34,
    0xC18C,0xB7C9,0xC6A9,0xAC01,0xC8FC,0xAD50,0xBD80,0xB2F5,
    0xCC9C,0xAE30,0xC704,0xC720,0xD0C1,0xCCA9,0xC801,0xB150,
    0xAD6D,0xC12D,0xB95C,0xB959,0xB989,0xACFC,0xAC70,0xC9C0,
    0xC6D0,0xAD8C,0xCC99,0xBD81,0xC878,0xCCA9,0xAE30,0xCD95,
    0xC885,0xCC44,0xC885,0xBCD1,0xAC04,0xC815,0xC810,0xCC99,
    0xC720,0xD0C1,0xB454,0xC900,0xC6A9,0xC885,0xC81C,0xCC28,
    0xCE68,0xB2E8,0xAC74,0xACFC,0xD0D5,0xC6B0,0xBCF5,0xC871,
    0xC811,0xD3B8,0xC720,0xB0D1,0xC81C,0xC0AC,0xD1F4,0xAC74,
    0xB3C4,0xCC28,0xD61C,0xB2F5,0xCC3D,0xC804,0xC804,0xC81C,
    0xCC99,0xC12D,0xB9CC,0xB958,0xC7A0,0xD544,0xC6A9,0xB85D,
    0xB8CC,0xCD95,0xB2F9,0xB300,0xCD95,0xC0AC,0xADDC,0xC801,
    0xCC99,0xC7A5,0xCC99,0xB9CC,0xC885,0xB828,0xBD95,0xC870,
    0xC5F0,0xBCC4,0xD1F4,0xADE4,0xB4F1,0xCE35,0xC120,0xBC88,
    0xC8FC,0xC885,0xC900,0xBC1C,0xCD95,0xCD95,0xAD90,0xAD90,
    0xB9B0,0xB2F5,0xAD50,0xAD50,0xBCF5,0xB8CC,0xB3C8,0xCC2C,
    # 0x8E80 #
    0xAD00,0xC870,0xB2EC,0xBCBD,0xBCBD,0xCD09,0xAC70,0xC800,
    0xAD50,0xB3C8,0xC8FC,0xC81C,0xBB34,0xC57D,0xB144,0xB9B0,
    0xB835,0xCC99,0xB825,0xC9C0,0xC804,0xC8FC,0xB2E8,0xC704,
    0xB8E1,0xB9B0,0xC120,0xC704,0xCC2C,0xB780,0xC12D,0xC591,
    0xC124,0xC12D,0xB2F5,0xAD6C,0xC801,0xCC2C,0xCC2C,0xC0AC,
    0xAE30,0xACFD,0xB9B0,0xC2E0,0xAD81,0xD0D0,0xBD84,0xAD6C,
    0xCCB4,0xD0C0,0xD0C0,0xAD81,0xB791,0xC778,0xB77C,0xC65C,
    0xAE30,0xAD6D,0xB2F9,0xACF5,0xC7A5,0xC5B8,0xBBF8,0xAC15,
    0xAD6C,0xB8E8,0xB85C,0xD0C0,0xC9C1,0xC548,0xCCB4,0xB3C4,
    0xC751,0xC625,0xCC28,0xC54C,0xADA4,0xAD70,0xC138,0xC6D4,
    0xC120,0xB300,0xD5CC,0xBC94,0xC778,0xC0B0,0xAD11,0xC218,
    0xB3C8,0xC9C4,0xB300,0xC561,0xB0A9,0xAE30,0xBAA8,0xC5F0,
    0xC784,0xAE08,0xC804,0xAD49,0xD638,0xAD6C,0xD669,0xC800,
    0xB839,0xD0DC,0xC694,0xC9C4,0xBD84,0xAD11,0xC559,0xD33D,
    0xBC30,0xACE0,0xACE0,0xD3EC,0xC8FC,0xC6A9,0xC561,0xBC1C,
    0xCD95,0xC9C0,0xCD08,0xAC00,0xC77C,0xACBD,0xC2DD,0xBCD1,
    # 0x8F00 #
    0xC774,0xACF5,0xAD6D,0xAD50,0xAD11,0xB85C,0xD574,0xC804,
    0xC8FC,0xC7AC,0xC9C0,0xC694,0xB7C9,0xC695,0xC18C,0xC720,
    0xC644,0xAD70,0xCCA9,0xB9CC,0xBCF4,0xACBD,0xC8FC,0xC608,
    0xB989,0xCCA9,0xC794,0xB7C9,0xCE58,0xD718,0xB9DD,0xCCA0,
    0xACFC,0xAC10,0xC758,0xD33D,0xCC9C,0xACE4,0xB828,0xBCD1,
    0xAD00,0xBC30,0xB95C,0xBC30,0xB7C9,0xC5F0,0xC720,0xC9D1,
    0xC591,0xD568,0xCC9C,0xC8FC,0xC21C,0xAC08,0xC720,0xD6A1,
    0xC218,0xBCF5,0xCE58,0xBCF5,0xC628,0xBD84,0xC804,0xC5EC,
    0xC628,0xAC10,0xACE1,0xC9C4,0xD560,0xC6D0,0xB85D,0xAD50,
    0xCD08,0xC804,0xC138,0xC5F0,0xC124,0xCCA0,0xAD50,0xC794,
    0xBCF5,0xB8CC,0xBD84,0xBC88,0xB9B0,0xAC08,0xC0C9,0xAC10,
    0xD658,0xC758,0xACA9,0xB300,0xC774,0xC5EC,0xD568,0xAD49,
    0xB8B0,0xBE44,0xB825,0xB825,0xB85C,0xB9B0,0xCC28,0xC54C,
    0xADA4,0xD5CC,0xB300,0xC778,0xC804,0xC561,0xB95C,0xC5F0,
    0xAD49,0xACE0,0xAC00,0xB85C,0xCD95,0xC9C0,0xC77C,0xD638,
    0xC9C4,0xB825,0xCD08,0xACBD,0xC2DD,0xC7AC,0xC9C0,0xAD50,
    # 0x8F80 #
    0xC8FC,0xC804,0xB85C,0xAD50,0xCCA9,0xBCF4,0xB7C9,0xB828,
    0xBC30,0xD718,0xACE4,0xB9DD,0xB7C9,0xCCA0,0xCE58,0xC8FC,
    0xBCF5,0xC9D1,0xC628,0xC218,0xBE44,0xC6D0,0xD560,0xC804,
    0xB85D,0xCCA0,0xB9B0,0xC2E0,0xACE0,0xC0AC,0xC0AC,0xD53C,
    0xC8C4,0xBCC0,0xB784,0xB784,0xC0AC,0xC124,0xD310,0xD310,
    0xBCC0,0xBCC0,0xC124,0xBCC0,0xBC18,0xC0AC,0xBCC0,0xBCC0,
    0xC9C4,0xC695,0xB18D,0xB18D,0xC9C4,0xCC29,0xCC29,0xC77C,
    0xC789,0xBCC0,0xBCC0,0xC2ED,0xC785,0xB8CC,0xCCB4,0xCC9C,
    0xAC04,0xCC9C,0xC6B0,0xC624,0xD758,0xC2E0,0xC774,0xACFC,
    0xB9E4,0xC11C,0xC7A1,0xAD11,0xB3CC,0xB454,0xC601,0xCCB4,
    0xC6B4,0xADFC,0xD56D,0xC544,0xBC18,0xC624,0xCCB4,0xC640,
    0xD658,0xC800,0xC911,0xC9C4,0xC6D0,0xC704,0xB828,0xC9C0,
    0xCCA9,0xB2C8,0xCD08,0xB82C,0xC774,0xD615,0xAC00,0xC9C4,
    0xD0DC,0xC774,0xC801,0xBC15,0xC655,0xC9C8,0xCC45,0xB3C4,
    0xC220,0xC774,0xAC81,0xACBD,0xD68C,0xB3D9,0xC720,0xBBF8,
    0xBCD1,0xC801,0xB0B4,0xC774,0xACB0,0xCD94,0xB82C,0xC900,
    # 0x9000 #
    0xD1F4,0xC1A1,0xAD04,0xB3C4,0xBC29,0xD6C4,0xC5ED,0xB3C8,
    0xD615,0xC120,0xC190,0xD3EC,0xC720,0xC18C,0xC8FC,0xD22C,
    0xCD95,0xAD6C,0xCCB4,0xCCB4,0xB3C4,0xACBD,0xC801,0xB450,
    0xC758,0xC800,0xD1B5,0xAD11,0xC624,0xC11C,0xB839,0xC18D,
    0xC870,0xC900,0xBD09,0xB828,0xC0AC,0xD68C,0xB9AC,0xACE1,
    0xB798,0xBD84,0xCC29,0xACB0,0xBCD1,0xD658,0xCCB4,0xB85D,
    0xC720,0xC8FC,0xC9C4,0xC721,0xD0C1,0xADDC,0xC704,0xC801,
    0xC77C,0xB2EC,0xC6D0,0xB77C,0xD54D,0xB0D1,0xC720,0xD0D5,
    0xC218,0xB454,0xC218,0xC5B8,0xCC9C,0xC9C0,0xCCB4,0xC6B0,
    0xC2DD,0xC815,0xC720,0xC6B4,0xC545,0xD3B8,0xACFC,0xC54C,
    0xD558,0xD669,0xC8FC,0xB3C4,0xB2EC,0xC704,0xB0A8,0xC720,
    0xAD6C,0xC694,0xCD94,0xB958,0xC190,0xB2F5,0xCCB4,0xC9C0,
    0xC6D0,0xC18C,0xD0D1,0xACAC,0xD72D,0xC694,0xAD00,0xC7A5,
    0xC624,0xC801,0xC0BD,0xCE59,0xC18D,0xC870,0xCC28,0xB454,
    0xCCB4,0xB8E8,0xC9C0,0xC88C,0xB9B0,0xC900,0xC694,0xCC9C,
    0xC120,0xD73C,0xC720,0xC624,0xB8CC,0xAC70,0xC11C,0xD53C,
    # 0x9080 #
    0xC694,0xB9E4,0xD574,0xC218,0xD658,0xC804,0xB4F1,0xC774,
    0xB9C9,0xBCC0,0xBCC0,0xB78D,0xB824,0xC6D0,0xC720,0xB77C,
    0xB9AC,0xC74D,0xC815,0xB4F1,0xAE30,0xC639,0xC0B0,0xD55C,
    0xC6B0,0xB9DD,0xC5EC,0xACF5,0xC11D,0xAD11,0xBD80,0xD56D,
    0xBE48,0xBC29,0xD615,0xB098,0xD754,0xC2EC,0xBC29,0xC6D0,
    0xCD0C,0xD654,0xC0AC,0xBC29,0xAD50,0xAD6C,0xC6B0,0xAC10,
    0xD0DC,0xAD6C,0xD544,0xBE44,0xBCD1,0xC18C,0xD328,0xC640,
    0xC800,0xCD94,0xC5C5,0xB9B0,0xAD11,0xADDC,0xC8FC,0xC2DC,
    0xACE0,0xC6B1,0xAC1C,0xD569,0xADF9,0xC9C8,0xAE38,0xC21C,
    0xD6C4,0xD615,0xAD50,0xD574,0xADDC,0xB098,0xB791,0xACB9,
    0xD68C,0xC815,0xB791,0xC6B4,0xC5F0,0xC131,0xB450,0xCE58,
    0xB824,0xBD80,0xC624,0xBD80,0xACE0,0xD559,0xB791,0xACB9,
    0xACBD,0xAD70,0xC601,0xBC1C,0xADF9,0xD328,0xB825,0xC6B4,
    0xBD80,0xD6A8,0xCC98,0xBE44,0xCCAD,0xACFD,0xC8FC,0xB2F4,
    0xCD94,0xBCD1,0xB798,0xC608,0xCE68,0xC6B0,0xBD80,0xD5A5,
    0xB2E8,0xACA9,0xC639,0xAD50,0xC758,0xB3C4,0xC5B8,0xBBF8,
    # 0x9100 #
    0xC57D,0xD328,0xC545,0xC720,0xACAC,0xC6B0,0xC6B4,0xD6C4,
    0xADDC,0xD5A5,0xD5A5,0xC218,0xB2F9,0xBA85,0xC2DD,0xC695,
    0xCD95,0xC790,0xCD94,0xACA9,0xC624,0xD5A5,0xC6B4,0xD638,
    0xC6A9,0xBE44,0xB9C9,0xC18C,0xBD80,0xB8CC,0xC740,0xC804,
    0xD638,0xAD50,0xC5B8,0xC7A5,0xB9CC,0xAD50,0xD5C8,0xB4F1,
    0xD3D0,0xC2EC,0xBE44,0xC99D,0xC704,0xC815,0xBB34,0xC120,
    0xB9B0,0xD30C,0xB2E8,0xB9F9,0xC5C5,0xC870,0xD68C,0xD48D,
    0xBABD,0xCD94,0xAD11,0xB828,0xCC2C,0xC804,0xC6B0,0xAE30,
    0xC5F0,0xCC38,0xCC2C,0xB839,0xD658,0xD734,0xD48D,0xCC2C,
    0xB825,0xC720,0xC815,0xCD94,0xC791,0xBC30,0xC8FC,0xC774,
    0xD56D,0xC6B0,0xC8FC,0xC5FC,0xCDE8,0xBAA8,0xD0D0,0xD6C4,
    0xB450,0xC9D0,0xBD84,0xC6D0,0xBD80,0xC628,0xD0DC,0xCCA8,
    0xAC00,0xD0C0,0xCD08,0xAC10,0xACE0,0xC18C,0xBC1C,0xC218,
    0xC7AC,0xBA85,0xB77D,0xCCA0,0xC218,0xC720,0xB3D9,0xC9C0,
    0xC120,0xC7A5,0xC815,0xC724,0xB3C4,0xD6A8,0xB9E4,0xD639,
    0xC0B0,0xB8B0,0xD3EC,0xCDE8,0xD574,0xC5FC,0xC2DC,0xC591,
    # 0x9180 #
    0xC720,0xB85D,0xB9BC,0xC5C4,0xB3C4,0xBC30,0xC794,0xC21C,
    0xB2F4,0xCDE8,0xCCA0,0xCD08,0xACE4,0xC81C,0xD568,0xB3C4,
    0xD638,0xC11C,0xC131,0xD0D0,0xCD94,0xC21C,0xC628,0xBC1C,
    0xAC11,0xC218,0xBBF8,0xCCA0,0xCD94,0xCC28,0xC628,0xC601,
    0xC559,0xC790,0xD574,0xB2F9,0xC7A5,0xD45C,0xCC38,0xC5B4,
    0xB9AC,0xC870,0xB8CC,0xC758,0xC7A5,0xBCF5,0xCD08,0xD61C,
    0xB2F4,0xBC1C,0xB18D,0xC5ED,0xB840,0xAC39,0xC5FC,0xC758,
    0xC591,0xC720,0xD6C8,0xC218,0xC5F0,0xB839,0xBBF8,0xBBF8,
    0xC591,0xD754,0xC870,0xC2DC,0xBBF8,0xC5FC,0xBCC0,0xCC44,
    0xC11D,0xC720,0xC11D,0xC11D,0xB9AC,0xC911,0xC57C,0xB7C9,
    0xB9AC,0xAE40,0xAE08,0xAD6C,0xC744,0xC870,0xB3C4,0xC1E0,
    0xC815,0xBC15,0xAD6C,0xD751,0xBD80,0xCE68,0xCE69,0xD314,
    0xB780,0xBD80,0xB0B4,0xC870,0xC0BC,0xCD08,0xAD6C,0xCC9C,
    0xACB0,0xBC94,0xC6B0,0xD654,0xD55C,0xACF5,0xC7AC,0xB9DD,
    0xC77C,0xCCB4,0xC0AC,0xD758,0xC775,0xCC44,0xC0AC,0xD1A0,
    0xC11D,0xB140,0xCC9C,0xD658,0xC778,0xBCBD,0xC57C,0xADFC,
    # 0x9200 #
    0xD30C,0xBC29,0xCE68,0xACAC,0xB450,0xC6D4,0xC5F0,0xBD80,
    0xBE44,0xB0A9,0xC2EC,0xC640,0xACB0,0xB454,0xAD6C,0xC778,
    0xAC80,0xD310,0xC0BD,0xC784,0xCD08,0xB274,0xBD84,0xC724,
    0xC758,0xAE08,0xBE44,0xACFC,0xD6A1,0xC74C,0xADE0,0xC870,
    0xC5ED,0xC911,0xB151,0xAC1C,0xC77C,0xD654,0xD0DC,0xD56D,
    0xC6D0,0xD638,0xC561,0xBB38,0xD0C1,0xC790,0xB2C8,0xB3CC,
    0xC2DC,0xBBFC,0xACE0,0xC544,0xB839,0xBCD1,0xC0AC,0xACE0,
    0xBC1C,0xD53C,0xC625,0xC0AC,0xC791,0xD3EC,0xC720,0xC804,
    0xAC11,0xC9C4,0xC0AC,0xC2DC,0xCCA0,0xAC70,0xCCA9,0xC0AC,
    0xC0AC,0xD604,0xCD08,0xD3EC,0xD654,0xD544,0xC0DD,0xC11C,
    0xC11D,0xBC15,0xC8FC,0xCE59,0xC7A1,0xD30C,0xB3D9,0xACB8,
    0xBD88,0xC7AC,0xB958,0xC5F0,0xBD80,0xB9BD,0xC6D4,0xBE44,
    0xC559,0xBC18,0xBC1C,0xAC81,0xAD6C,0xC220,0xC815,0xBB34,
    0xB2C8,0xB151,0xCCB4,0xAC00,0xBAA9,0xB2E8,0xC2E0,0xC774,
    0xC0AC,0xAD11,0xAC00,0xBD81,0xAC10,0xB3D9,0xD615,0xD64D,
    0xAD50,0xCE58,0xC774,0xB77D,0xBCD1,0xC2DD,0xBAA8,0xD611,
    # 0x9280 #
    0xC740,0xADE0,0xC8FC,0xCD1D,0xD5A5,0xB3D9,0xBC31,0xB8B0,
    0xACC4,0xC728,0xC220,0xC784,0xC874,0xC9C8,0xACF5,0xCC45,
    0xCCB4,0xC120,0xACAC,0xC804,0xD53C,0xCCA0,0xC218,0xD6C4,
    0xBA85,0xACFC,0xC870,0xC12C,0xD568,0xD734,0xADE0,0xCC28,
    0xB85C,0xAE38,0xBCBD,0xC5EC,0xBBF8,0xC758,0xC778,0xAD11,
    0xC548,0xC8FC,0xC720,0xC0C9,0xACE0,0xC804,0xB780,0xC0AC,
    0xC560,0xC870,0xD55C,0xC608,0xC138,0xAC31,0xAD6C,0xC18C,
    0xC12D,0xC218,0xC7A5,0xC81C,0xC88C,0xAD04,0xD64D,0xC885,
    0xB450,0xB824,0xB9E4,0xB791,0xB9D8,0xC790,0xC724,0xD328,
    0xC625,0xC18D,0xC695,0xC5F0,0xC815,0xBC1C,0xD658,0xD611,
    0xD6A1,0xC804,0xBD09,0xCCA8,0xB9CC,0xC9C0,0xC0AC,0xD604,
    0xC624,0xC5B4,0xC870,0xAD11,0xCC29,0xB82C,0xD615,0xCE68,
    0xC2E0,0xD568,0xB82C,0xC57C,0xC11C,0xC815,0xAD6D,0xD604,
    0xCCA0,0xB9DD,0xD3EC,0xB9AC,0xBC18,0xC608,0xC131,0xACE0,
    0xB9AC,0xD2B9,0xBCD1,0xC8FC,0xADF9,0xB3C5,0xB958,0xCD5C,
    0xAC70,0xCC3D,0xC6D0,0xACAC,0xAC15,0xC870,0xB3C4,0xC0C1,
    # 0x9300 #
    0xB95C,0xACFC,0xB989,0xD30C,0xB85D,0xB9AC,0xCC3D,0xBD80,
    0xAD8C,0xBBFC,0xCD40,0xD33D,0xC548,0xBE44,0xD568,0xC544,
    0xCD94,0xB8B0,0xC544,0xAD49,0xD0D1,0xACE4,0xB3C5,0xCD94,
    0xCD94,0xCE58,0xC7C1,0xBD84,0xB151,0xC885,0xC21C,0xB2F4,
    0xC815,0xAE30,0xC804,0xCCA0,0xAE30,0xC721,0xAE08,0xAD00,
    0xBB18,0xCC3D,0xC804,0xC11D,0xB3D9,0xC870,0xACE0,0xCC29,
    0xC220,0xC9C4,0xB85D,0xB9F9,0xB85D,0xD654,0xD45C,0xC54C,
    0xB798,0xAE0D,0xBC29,0xBB34,0xB0B4,0xB9D8,0xCC38,0xD638,
    0xB4DD,0xD754,0xAE08,0xD640,0xACBD,0xBC95,0xBB38,0xAC1C,
    0xC601,0xC2DC,0xB828,0xACFC,0xC120,0xB3C4,0xB3CC,0xC704,
    0xC885,0xBCF5,0xC720,0xC9D1,0xC545,0xAD70,0xCE68,0xC81C,
    0xCC30,0xD639,0xC591,0xB2E8,0xD558,0xC6B0,0xAC31,0xC131,
    0xAD49,0xC678,0xBCF5,0xCD08,0xC0BD,0xACC4,0xC0AC,0xAD49,
    0xADDC,0xCCA8,0xBB34,0xCD08,0xCD08,0xD6C4,0xC720,0xCD1D,
    0xD658,0xC12D,0xBBFC,0xAC10,0xB2E8,0xAC74,0xC1A1,0xADDC,
    0xD638,0xC120,0xD0C0,0xAC08,0xCE68,0xD3B8,0xC885,0xCE58,
    # 0x9380 #
    0xC218,0xC57C,0xBBF8,0xD30C,0xC560,0xACC4,0xC804,0xBBF8,
    0xCC28,0xB2F5,0xBC29,0xD560,0xACB8,0xC0C9,0xAC1C,0xB958,
    0xC694,0xD0D1,0xB204,0xC639,0xC6A9,0xB2F9,0xC1C4,0xC7C1,
    0xB825,0xC0AD,0xCD94,0xBC15,0xBC18,0xC0BD,0xBE44,0xC0C1,
    0xAC15,0xC790,0xC624,0xD615,0xD669,0xC870,0xB958,0xAC1C,
    0xC900,0xC1C4,0xC218,0xB9D8,0xD638,0xC9C4,0xC9C4,0xB77C,
    0xC77C,0xC6D0,0xB2F9,0xC5BC,0xC2DD,0xAC00,0xAC00,0xB9C8,
    0xC804,0xC1A1,0xC870,0xC1C4,0xD558,0xBD09,0xC628,0xB098,
    0xB85C,0xC1C4,0xC6B0,0xC871,0xB2E8,0xC218,0xAD00,0xC120,
    0xB828,0xC218,0xC624,0xB9CC,0xB9C9,0xB77C,0xD544,0xC608,
    0xB958,0xC801,0xC0BC,0xCD1D,0xC778,0xC624,0xC624,0xAC31,
    0xC7A5,0xCD5C,0xCC99,0xC0C1,0xB2F9,0xB9CC,0xC6A9,0xC0B0,
    0xBD09,0xACBD,0xD45C,0xC11C,0xB8E8,0xC218,0xCD1D,0xB871,
    0xCC38,0xC810,0xC870,0xB824,0xD558,0xC2E4,0xAC15,0xC0C1,
    0xBD95,0xC7A5,0xACAC,0xC7C1,0xB85C,0xD654,0xC9D1,0xBC15,
    0xD61C,0xAC15,0xBC1C,0xB9B0,0xCC45,0xC218,0xC0B0,0xC7C1,
    # 0x9400 #
    0xADA4,0xC0AC,0xB958,0xB1E8,0xD6A1,0xBCC4,0xC218,0xBC88,
    0xAD50,0xC804,0xC591,0xD0D5,0xC0C1,0xD73C,0xCD08,0xC900,
    0xB8CC,0xACB0,0xB85C,0xB300,0xC2EC,0xC7A0,0xAE30,0xAC04,
    0xC885,0xB4F1,0xC544,0xC601,0xB300,0xAD90,0xB204,0xCCB4,
    0xBCF4,0xCCA0,0xAE08,0xC7A5,0xC815,0xC120,0xAC1C,0xAC04,
    0xBE44,0xC218,0xB85C,0xC804,0xD68C,0xC624,0xB834,0xC791,
    0xC870,0xCCA8,0xD0C1,0xB8B0,0xBCBD,0xCCA0,0xD658,0xC5FD,
    0xD0C1,0xACFC,0xB2F9,0xAC70,0xBD84,0xB2EC,0xD3D0,0xC758,
    0xC560,0xBC88,0xD6C8,0xC870,0xC8FC,0xD6A1,0xCD94,0xC81C,
    0xB2C8,0xD0D1,0xD655,0xACBD,0xBE48,0xC601,0xADA4,0xB155,
    0xC720,0xAC10,0xAC10,0xACAC,0xCC30,0xC9C8,0xBA78,0xB824,
    0xB8B0,0xACC4,0xCC2C,0xAD11,0xC0C1,0xBD09,0xB78D,0xB3C5,
    0xC0AD,0xCC29,0xB824,0xD45C,0xD3EC,0xB178,0xD604,0xAD00,
    0xB871,0xC545,0xB85C,0xD760,0xAC10,0xB780,0xBC15,0xCCA8,
    0xC57D,0xCC38,0xC591,0xAC74,0xD734,0xAD00,0xC7A5,0xC12D,
    0xB8B0,0xCC2C,0xAD6C,0xBC18,0xB77C,0xCC2C,0xB780,0xCC29,
    # 0x9480 #
    0xC54C,0xACFD,0xB2F9,0xCD09,0xB780,0xAE08,0xAD6C,0xC744,
    0xCE68,0xC815,0xC1E0,0xBC15,0xC870,0xD1A0,0xCC9C,0xCC9C,
    0xC0BC,0xC0BD,0xBC94,0xC870,0xBB38,0xB140,0xC591,0xCC44,
    0xACAC,0xAC1C,0xBE44,0xD0DC,0xAC70,0xB454,0xCD08,0xC885,
    0xB0A9,0xD328,0xAC15,0xD310,0xAC80,0xC6D4,0xD760,0xADE0,
    0xC624,0xAD6C,0xD56D,0xBC29,0xD654,0xB450,0xB274,0xD30C,
    0xC625,0xC804,0xC815,0xACB8,0xACE0,0xBC1C,0xC544,0xD30C,
    0xD3EC,0xBC1C,0xC6D4,0xCCA9,0xBAA9,0xB2E8,0xAC11,0xC804,
    0xC720,0xCCA0,0xBC15,0xB839,0xC0AD,0xC5F0,0xB958,0xD3EC,
    0xC2DC,0xD604,0xC0AC,0xD544,0xB2C8,0xD53C,0xD0C1,0xD615,
    0xACE0,0xB85C,0xC774,0xB9DD,0xC544,0xC720,0xC131,0xD611,
    0xC57C,0xB1E8,0xC9C8,0xB2F9,0xB3D9,0xB824,0xC870,0xC778,
    0xAC1C,0xCC30,0xC218,0xC120,0xC815,0xC8FC,0xC12C,0xD654,
    0xC804,0xC1C4,0xD611,0xC870,0xB77D,0xBA85,0xC7C1,0xC0C9,
    0xAD50,0xC758,0xC0B0,0xCD1D,0xD0D5,0xC548,0xC740,0xC5EC,
    0xC8FC,0xB85C,0xD3EC,0xC5B4,0xB798,0xD2B9,0xB828,0xAC31,
    # 0x9500 #
    0xC18C,0xC1C4,0xB9AC,0xC815,0xC11C,0xACFC,0xACE0,0xCCA0,
    0xC218,0xC88C,0xB82C,0xBD09,0xC790,0xB958,0xAC1C,0xAC04,
    0xC608,0xC81C,0xB791,0xCE68,0xAD6D,0xC544,0xCC3D,0xD0C0,
    0xCCA8,0xCC29,0xBB18,0xBD84,0xAE30,0xB4DD,0xACFC,0xACE4,
    0xCC3D,0xC11D,0xACE0,0xB77C,0xCD94,0xCD94,0xAE08,0xC9C8,
    0xD754,0xAD8C,0xD640,0xBD80,0xB2F4,0xC815,0xAC70,0xAC70,
    0xB9F9,0xCE58,0xACC4,0xC601,0xAC1C,0xC7A5,0xC1A1,0xC545,
    0xC0BD,0xCD08,0xC885,0xB2E8,0xC218,0xAD49,0xD658,0xC560,
    0xB3C4,0xBBF8,0xB8E8,0xC790,0xBE44,0xBBF8,0xB9C9,0xC9C4,
    0xBC15,0xB825,0xC12D,0xB2F9,0xC804,0xC5BC,0xB098,0xB958,
    0xD638,0xBC29,0xC77C,0xAC00,0xBE48,0xC6A9,0xD45C,0xB2F9,
    0xB9CC,0xB77C,0xBD95,0xC6A9,0xACBD,0xC801,0xC871,0xC120,
    0xB958,0xC2EC,0xAD90,0xB8CC,0xBC15,0xB178,0xB300,0xB780,
    0xBCF4,0xCC2C,0xAC15,0xB4F1,0xD655,0xB8B0,0xD658,0xD0C1,
    0xB834,0xC758,0xCC30,0xD45C,0xB78D,0xCC38,0xC591,0xC7A5,
    0xC7A5,0xAD6C,0xC624,0xC808,0xAD74,0xB8CC,0xBBF8,0xC7A5,
    # 0x9580 #
    0xBB38,0xB9D0,0xC0B0,0xC12C,0xD639,0xBB38,0xC5FC,0xD3D0,
    0xD55C,0xD3D0,0xC0B0,0xAC1C,0xD56D,0xD33D,0xAD49,0xC724,
    0xC0BC,0xD55C,0xD55C,0xAC04,0xBBFC,0xD558,0xC218,0xB450,
    0xAC11,0xB1E8,0xCCA8,0xD3C9,0xD558,0xB839,0xBCC0,0xBE44,
    0xC724,0xC560,0xAD00,0xAC01,0xD569,0xBC8C,0xCD95,0xD64D,
    0xADDC,0xBBFC,0xC11C,0xACE4,0xB791,0xB824,0xC815,0xC0AC,
    0xAD6D,0xC5F4,0xC5F4,0xCC9C,0xACA9,0xB9B0,0xCC3D,0xC0B4,
    0xACE4,0xC5C4,0xBB38,0xC5FC,0xC54C,0xD63C,0xC5ED,0xBB38,
    0xD56D,0xD3EC,0xD56D,0xACA9,0xC694,0xBB38,0xBC18,0xC554,
    0xC704,0xC778,0xD65C,0xACB0,0xB780,0xB3C4,0xCC9C,0xD33D,
    0xC804,0xC5BC,0xD0D1,0xAC1C,0xD569,0xAD90,0xD2C8,0xAD00,
    0xD22C,0xACC4,0xADDC,0xB2F9,0xAD00,0xD45C,0xD568,0xD761,
    0xADA4,0xCC9C,0xBCBD,0xB2F9,0xD658,0xB2EC,0xC628,0xC6D0,
    0xBB38,0xC0B0,0xC12C,0xC5FC,0xD55C,0xD3D0,0xBB38,0xD2C8,
    0xC724,0xC704,0xD55C,0xAD49,0xAC04,0xBBFC,0xD56D,0xBBFC,
    0xAC11,0xB1E8,0xADDC,0xBB38,0xB2EC,0xBBFC,0xB824,0xAC1C,
    # 0x9600 #
    0xBC8C,0xAC01,0xC560,0xACE4,0xAD6C,0xC5F4,0xB791,0xB3C4,
    0xC5ED,0xC5C4,0xCC3D,0xD601,0xBB38,0xD63C,0xC5FC,0xC54C,
    0xCC9C,0xB780,0xACA9,0xADA4,0xD65C,0xACB0,0xD569,0xC804,
    0xD0D1,0xAD90,0xD568,0xD658,0xBD80,0xBD80,0xB975,0xB300,
    0xC2E0,0xCC9C,0xC62C,0xAC1C,0xCE58,0xC74C,0xC591,0xB450,
    0xC561,0xC2B9,0xD310,0xBC30,0xAC31,0xC724,0xC644,0xC9C0,
    0xBE44,0xC815,0xBC29,0xC591,0xC74C,0xC9C4,0xACC4,0xC815,
    0xC561,0xAC70,0xC800,0xC870,0xC870,0xC810,0xB839,0xC544,
    0xD0C0,0xD0C0,0xD53C,0xBCD1,0xBD80,0xC81C,0xB959,0xB871,
    0xC9C4,0xD615,0xCE58,0xB8E8,0xB9E5,0xAC15,0xC218,0xD0C0,
    0xD55C,0xC774,0xADA4,0xC6B0,0xD574,0xD569,0xC900,0xCD08,
    0xD615,0xC21C,0xBD80,0xD3D0,0xD569,0xC12C,0xC2B9,0xCC99,
    0xD3EC,0xB450,0xC6D0,0xC9C4,0xC81C,0xD568,0xB3C4,0xB0A0,
    0xC6B4,0xD5D8,0xBC30,0xBE44,0xCD94,0xAE30,0xD1F4,0xB95C,
    0xC74C,0xAD6D,0xC218,0xC9C4,0xBE44,0xB989,0xB3C4,0xD568,
    0xB959,0xC2B9,0xD5D8,0xC778,0xC800,0xC591,0xC789,0xD611,
    # 0x9680 #
    0xC911,0xC5B8,0xC74C,0xC720,0xC81C,0xC6B0,0xB96D,0xC704,
    0xC678,0xC5BC,0xB300,0xC218,0xC554,0xD669,0xACC4,0xC218,
    0xC740,0xAE30,0xC5C4,0xD734,0xACA9,0xC6B4,0xC624,0xC678,
    0xC560,0xADF9,0xB2F9,0xC81C,0xC7A5,0xB3C4,0xC624,0xADF9,
    0xC740,0xC0B0,0xC694,0xB9B0,0xD1F4,0xB4F1,0xBE44,0xC218,
    0xC218,0xC624,0xD5D8,0xBD84,0xB2C8,0xC774,0xC81C,0xB3C4,
    0xC2B5,0xC740,0xCC99,0xD734,0xB871,0xD76C,0xC774,0xB840,
    0xB840,0xCD94,0xAC01,0xCC99,0xC900,0xC804,0xB09C,0xC775,
    0xC791,0xC548,0xAE08,0xACAC,0xC6C5,0xC544,0xC9D1,0xACE0,
    0xD658,0xCE58,0xAD6C,0xC900,0xC790,0xC639,0xC800,0xCD94,
    0xD638,0xC7A1,0xB77D,0xC5EC,0xC218,0xC870,0xC218,0xD55C,
    0xD655,0xC30D,0xAD00,0xCD94,0xC7A1,0xC639,0xACC4,0xD734,
    0xC218,0xB958,0xB9AC,0xB09C,0xD559,0xC7A1,0xC9D1,0xC9D1,
    0xC6B0,0xC6B0,0xC124,0xB194,0xBD80,0xC0BD,0xBAA9,0xBB38,
    0xBD84,0xBC29,0xC6B4,0xB825,0xB9BD,0xC559,0xB839,0xB8B0,
    0xC554,0xBC15,0xBABD,0xC804,0xD0D5,0xD638,0xBB34,0xC870,
    # 0x9700 #
    0xC218,0xC81C,0xBAA9,0xCE68,0xC18C,0xC0BD,0xC815,0xC9C4,
    0xD328,0xB9E4,0xB839,0xCC98,0xC8FC,0xACFD,0xC0BD,0xBE44,
    0xD64D,0xC810,0xC74C,0xC608,0xC8FC,0xB454,0xB9BC,0xB839,
    0xB3D9,0xC601,0xBB34,0xB839,0xC0C1,0xB839,0xD558,0xD64D,
    0xC74C,0xB9E5,0xB9E5,0xC6B4,0xB958,0xBABD,0xBE48,0xBB34,
    0xC704,0xD655,0xC74C,0xC2B5,0xC775,0xC560,0xB2F4,0xB4F1,
    0xC0B0,0xD73C,0xB85C,0xB96D,0xCCB4,0xC999,0xBC29,0xC591,
    0xD328,0xBCBD,0xBBF8,0xD48D,0xD76C,0xC81C,0xB9E4,0xBABD,
    0xBABD,0xB8B0,0xB825,0xD655,0xC560,0xBE44,0xCCB4,0xB871,
    0xB839,0xC560,0xD48D,0xB825,0xBCF4,0xC791,0xC870,0xD559,
    0xBE59,0xCCAD,0xCCAD,0xC815,0xCC9C,0xC9C4,0xC815,0xC815,
    0xC815,0xC815,0xC815,0xC804,0xC815,0xCC9C,0xBE44,0xBE44,
    0xACE0,0xBBF8,0xBA74,0xBA74,0xD3EC,0xC5FD,0xC804,0xD68C,
    0xC5FD,0xD601,0xC815,0xCC44,0xAC04,0xC778,0xC801,0xB3C4,
    0xC62C,0xC778,0xAE08,0xADFC,0xD654,0xB274,0xD30C,0xC778,
    0xC0BD,0xB0A9,0xB9D0,0xC870,0xB2EC,0xBC18,0xC608,0xC694,
    # 0x9780 #
    0xB3C4,0xD53C,0xAC08,0xAD49,0xD3EC,0xC559,0xBCD1,0xC778,
    0xD611,0xB3C4,0xAE38,0xD61C,0xC548,0xC548,0xD754,0xACF5,
    0xD558,0xB2EC,0xAD50,0xC815,0xB9CC,0xACBD,0xC1E0,0xC870,
    0xCD08,0xD604,0xACF5,0xBD09,0xD0D1,0xC7A5,0xBE44,0xACFD,
    0xAD6D,0xB78D,0xC12D,0xC720,0xBC29,0xC555,0xCD94,0xCD94,
    0xAC08,0xCD08,0xBB34,0xAD6D,0xAC74,0xD3B8,0xC81C,0xCC9C,
    0xC628,0xB3C4,0xAD6C,0xD0D1,0xBE44,0xD61C,0xBC18,0xACA9,
    0xD544,0xACFD,0xB2F9,0xB8E8,0xADA4,0xAD50,0xD654,0xAE30,
    0xCC9C,0xAC15,0xCCA8,0xB2EC,0xD68D,0xD604,0xCC9C,0xB3C5,
    0xB9D0,0xCC9C,0xB780,0xC704,0xC778,0xBD88,0xB9E4,0xAD8C,
    0xAC11,0xC704,0xCD08,0xD55C,0xD560,0xB3C8,0xC720,0xC6B4,
    0xC12D,0xC704,0xC704,0xBC30,0xB3C4,0xAD6C,0xC628,0xACE0,
    0xD544,0xC704,0xD61C,0xB3C5,0xB9D0,0xB3C5,0xC704,0xC778,
    0xBD88,0xD55C,0xC704,0xC628,0xB3C4,0xAD6C,0xAD6C,0xAD6C,
    0xD574,0xC12C,0xC81C,0xC74C,0xC7A1,0xC6B4,0xC18C,0xB825,
    0xBD09,0xD669,0xC601,0xC6B4,0xBD09,0xC554,0xC74C,0xD5A5,
    # 0x9800 #
    0xD638,0xD608,0xC815,0xACBD,0xADDC,0xD56D,0xC21C,0xC548,
    0xC218,0xC774,0xC6B1,0xC640,0xC1A1,0xADDC,0xAE30,0xD56D,
    0xC608,0xC644,0xBC18,0xB3C8,0xC801,0xC810,0xBC18,0xD30C,
    0xB839,0xCC45,0xACBD,0xB8B0,0xD569,0xAD50,0xC54C,0xC561,
    0xC704,0xD790,0xAD04,0xC2E0,0xC774,0xC774,0xD574,0xD1F4,
    0xD3B8,0xBCD1,0xB8B0,0xBD80,0xD611,0xB450,0xD68C,0xADDC,
    0xD611,0xB784,0xC815,0xC815,0xC601,0xAD70,0xD639,0xC554,
    0xACBD,0xD1F4,0xD1F4,0xBE48,0xB8B0,0xD1F4,0xC790,0xC790,
    0xCD94,0xC815,0xB8B0,0xB2F4,0xD568,0xAC04,0xACFC,0xCDCC,
    0xACBD,0xAE08,0xC774,0xC2DC,0xC81C,0xC561,0xC545,0xC548,
    0xC6D0,0xD568,0xC639,0xC804,0xC548,0xD604,0xC2E0,0xC758,
    0xC6D0,0xC0C1,0xC804,0xC804,0xAC15,0xACE8,0xB958,0xB8CC,
    0xD45C,0xC758,0xB9CC,0xCD95,0xD6A8,0xD638,0xCD08,0xACE0,
    0xC190,0xC5C4,0xD6FC,0xC804,0xC720,0xD6D9,0xBE48,0xD604,
    0xBE48,0xB85C,0xB78C,0xC12D,0xAD00,0xD608,0xC815,0xACBD,
    0xC548,0xD56D,0xC21C,0xC218,0xC6B1,0xC644,0xACE0,0xB3C8,
    # 0x9880 #
    0xAE30,0xBC18,0xC1A1,0xD56D,0xC608,0xB85C,0xB839,0xD30C,
    0xACBD,0xD790,0xD611,0xC815,0xD569,0xC601,0xACBD,0xD574,
    0xC774,0xBE48,0xD68C,0xD1F4,0xC554,0xC601,0xC601,0xACFC,
    0xC81C,0xC639,0xC545,0xC804,0xC548,0xC561,0xC12D,0xB9CC,
    0xC804,0xC0C1,0xD638,0xB8B0,0xC804,0xC720,0xBE48,0xAD00,
    0xD48D,0xD45C,0xD48D,0xBD80,0xD558,0xC810,0xBC15,0xC0BD,
    0xD0DC,0xD0DC,0xB82C,0xAD04,0xC120,0xC18C,0xAD6C,0xD45C,
    0xC2DC,0xC704,0xC591,0xC694,0xC218,0xAC1C,0xC18C,0xBC94,
    0xB958,0xC2B5,0xB8CC,0xD45C,0xD45C,0xB958,0xD45C,0xD45C,
    0xD45C,0xB8CC,0xD45C,0xC2E4,0xD48D,0xD734,0xD48D,0xC591,
    0xC810,0xBC15,0xC0BD,0xAD6C,0xC2DC,0xC218,0xC694,0xB958,
    0xD45C,0xD45C,0xD45C,0xBE44,0xBC88,0xBE44,0xBE44,0xC2DD,
    0xC2DD,0xC190,0xAE30,0xC815,0xC0AC,0xD0C1,0xC804,0xC190,
    0xD5A5,0xB3C8,0xC784,0xC5B4,0xAD8C,0xCE59,0xC74C,0xBC18,
    0xBC18,0xC190,0xC74C,0xC8FC,0xC774,0xC791,0xD544,0xC790,
    0xB3C4,0xB958,0xC790,0xCCA0,0xC0AC,0xD3EC,0xC2DD,0xB3CC,
    # 0x9900 #
    0xD574,0xC784,0xCCA8,0xAD50,0xD611,0xBCD1,0xC694,0xB3D9,
    0xC790,0xD5A5,0xC591,0xAD8C,0xC774,0xC5FC,0xB77D,0xC758,
    0xCC2C,0xBC1C,0xB1CC,0xC544,0xD3EC,0xC900,0xB450,0xC18D,
    0xC5EC,0xD76C,0xD6A8,0xD63C,0xACFC,0xC2DD,0xC804,0xCCB4,
    0xBCD1,0xD568,0xBD80,0xC5C5,0xB2F4,0xBE44,0xC7A5,0xC704,
    0xAD00,0xC5B5,0xB09C,0xC6B4,0xD638,0xD669,0xCCA0,0xD6FC,
    0xC804,0xD6C4,0xC560,0xB2F9,0xBD84,0xC704,0xACE8,0xC0AC,
    0xC1A1,0xB2F9,0xBC15,0xACE0,0xD76C,0xADA4,0xB958,0xC218,
    0xB3C4,0xC5FD,0xC628,0xB9C9,0xB2F9,0xB9CC,0xD544,0xC5B4,
    0xC218,0xADFC,0xC0B0,0xADA4,0xCC2C,0xC120,0xD76C,0xB2F4,
    0xC758,0xAE30,0xC694,0xC7C1,0xC639,0xB3C4,0xC608,0xD5A5,
    0xC804,0xBD84,0xD574,0xBABD,0xC5FC,0xB9C8,0xCC38,0xC591,
    0xB77C,0xCC2C,0xB0AD,0xC2DD,0xC815,0xAE30,0xD0C1,0xB2F9,
    0xB3C8,0xD76C,0xC784,0xC5B4,0xCE59,0xBC18,0xC74C,0xC804,
    0xC2DD,0xD3EC,0xC0AC,0xB3CC,0xC774,0xC774,0xC694,0xD5A5,
    0xD611,0xB77D,0xAD50,0xC758,0xBCD1,0xBC1C,0xB450,0xC544,
    # 0x9980 #
    0xC5EC,0xB1CC,0xC900,0xACFC,0xD63C,0xD568,0xAD00,0xC0AC,
    0xADA4,0xACE8,0xC218,0xCC38,0xC5FD,0xB9C9,0xBC15,0xB958,
    0xC218,0xADFC,0xB9CC,0xC0B0,0xCC2C,0xC591,0xC218,0xADDC,
    0xAD35,0xD5A5,0xBD84,0xBC1C,0xB2C8,0xD544,0xBC1C,0xB3C4,
    0xD568,0xBE44,0xC804,0xC554,0xC560,0xBCF5,0xD610,0xC628,
    0xD615,0xBD84,0xBE48,0xD765,0xB9C8,0xC5B4,0xD48D,0xAC04,
    0xC801,0xD0C0,0xD0C1,0xCE58,0xC21C,0xC8FC,0xC9C0,0xD328,
    0xADFC,0xC77C,0xC0BD,0xC724,0xBB38,0xCE69,0xB2F4,0xB824,
    0xC6B0,0xBC15,0xBCF4,0xACB0,0xD0DC,0xC5ED,0xAD6C,0xBB38,
    0xAD6C,0xACBD,0xD30C,0xC870,0xC6D0,0xD3C9,0xCD94,0xAC70,
    0xC8FC,0xB178,0xAD6C,0xBE44,0xC7A5,0xAC00,0xB839,0xC9C4,
    0xD0DC,0xBD80,0xC559,0xC0AC,0xD544,0xD0C0,0xD0C0,0xC0AC,
    0xB958,0xB9E4,0xBCC0,0xC870,0xCE58,0xC735,0xB4F1,0xB3D9,
    0xC21C,0xC804,0xC2E0,0xACBD,0xC774,0xD574,0xBC15,0xC8FC,
    0xC778,0xB77D,0xC8FC,0xB2E8,0xD574,0xB958,0xAD6D,0xC1A1,
    0xCE68,0xBC29,0xB791,0xD55C,0xB3C4,0xD604,0xD0DC,0xC900,
    # 0x9A00 #
    0xC544,0xBE59,0xC131,0xC560,0xB85D,0xCD94,0xC8FC,0xC0AC,
    0xBCD1,0xACE4,0xB3C4,0xB798,0xC885,0xACFC,0xAE30,0xAE30,
    0xD5D8,0xBE44,0xC18C,0xD5D8,0xAC08,0xC694,0xBB34,0xD3B8,
    0xCD1D,0xD3B8,0xC804,0xBE44,0xD669,0xAC74,0xD68D,0xC720,
    0xC81C,0xC804,0xD558,0xC885,0xC885,0xC720,0xC0AC,0xC65C,
    0xD0C4,0xADC0,0xC218,0xAC74,0xC2B9,0xC990,0xB958,0xD33D,
    0xB4F1,0xD61C,0xCD08,0xB3C5,0xC548,0xC6D0,0xCD94,0xC18C,
    0xC120,0xB824,0xCE58,0xC0C1,0xB85D,0xC2B5,0xB77C,0xC7A5,
    0xB9E5,0xC624,0xCC38,0xD45C,0xCD1D,0xAD6C,0xD544,0xC9C0,
    0xC728,0xD5C8,0xD654,0xBC1C,0xC219,0xD6A8,0xB9B0,0xC794,
    0xB3C8,0xB958,0xD0C4,0xC99D,0xB2F4,0xAD50,0xCCA0,0xD5D8,
    0xB77C,0xB2E8,0xACBD,0xC5ED,0xC5C5,0xD0C1,0xBE48,0xCDE8,
    0xC5F0,0xB8E1,0xB824,0xB4F1,0xC591,0xAE30,0xC0C1,0xAD6D,
    0xD734,0xD658,0xB824,0xD45C,0xB9C8,0xC5B4,0xD0C0,0xC21C,
    0xCE58,0xAD6C,0xC77C,0xBC15,0xB824,0xC7A5,0xC0AC,0xC0AC,
    0xBD80,0xAD6C,0xCD94,0xC8FC,0xD0C0,0xB178,0xAC00,0xC5ED,
    # 0x9A80 #
    0xD0DC,0xD6A8,0xB9E4,0xC778,0xAD50,0xD654,0xB77D,0xD574,
    0xBCC0,0xD45C,0xB824,0xBE59,0xD5D8,0xC131,0xCE68,0xC900,
    0xAE30,0xAE30,0xACFC,0xCD94,0xC885,0xC219,0xCC38,0xD3B8,
    0xC990,0xC885,0xC18C,0xBB34,0xC624,0xB958,0xAC74,0xC120,
    0xD45C,0xB77C,0xCD1D,0xC794,0xCDE8,0xAE30,0xC0C1,0xC591,
    0xACE8,0xC704,0xC704,0xC704,0xC6B0,0xD55C,0xC775,0xD56D,
    0xD22C,0xAC08,0xBC15,0xD53C,0xC790,0xCCB4,0xC800,0xACE0,
    0xD574,0xAD50,0xD6C4,0xACFC,0xACA9,0xD1F4,0xACBD,0xBCC0,
    0xBE44,0xACFC,0xAC00,0xC6B0,0xC218,0xB8E8,0xBC15,0xD6A8,
    0xBC29,0xBC15,0xC790,0xAD00,0xBE48,0xB9C8,0xB8CC,0xB8E8,
    0xD6A8,0xCD09,0xC7A5,0xC218,0xCCB4,0xBE48,0xAD00,0xB85C,
    0xACE0,0xACE0,0xACE0,0xACE0,0xAD50,0xB85C,0xC870,0xD45C,
    0xACE4,0xACE4,0xCCB4,0xBC29,0xD734,0xC5FC,0xBAA8,0xB2F4,
    0xACE4,0xBE48,0xBC1C,0xCD08,0xBE44,0xC790,0xBC1C,0xC5FC,
    0xCCB4,0xD3EC,0xD53C,0xBB34,0xBD88,0xC774,0xC6A9,0xACE1,
    0xACF5,0xD734,0xAD04,0xACC4,0xBD09,0xC88C,0xC18C,0xC0AC,
    # 0x9B00 #
    0xCCB4,0xB9AC,0xBE48,0xC885,0xCCB4,0xBD95,0xC1A1,0xC7C1,
    0xAD8C,0xC885,0xC21C,0xC804,0xCD94,0xD638,0xB784,0xCD94,
    0xAE30,0xB834,0xC9C4,0xBE48,0xBD09,0xB9C8,0xC0BC,0xB9CC,
    0xB9CC,0xC2B9,0xC218,0xB9CC,0xAC04,0xAC04,0xB18D,0xD658,
    0xAD04,0xB155,0xBE48,0xB835,0xC591,0xB450,0xD22C,0xB8CC,
    0xD64D,0xD601,0xD22C,0xD568,0xD22C,0xD22C,0xAD6C,0xCC3D,
    0xC6B8,0xC6B8,0xACA9,0xAD8C,0xBD80,0xC2EC,0xADDC,0xC885,
    0xB958,0xADDC,0xC0C1,0xC8FD,0xADC0,0xB9E4,0xAE30,0xAE30,
    0xAC1C,0xAD34,0xD63C,0xBC1C,0xBC31,0xB9E4,0xD6CC,0xC5FC,
    0xC18C,0xB7C9,0xC5ED,0xCD94,0xAE30,0xB9DD,0xB7C9,0xC704,
    0xAC10,0xB9AC,0xD45C,0xD544,0xB9C8,0xAE30,0xD5C8,0xC218,
    0xC5FC,0xCC38,0xC5B4,0xB3C4,0xC778,0xACB0,0xC785,0xD64D,
    0xD0C1,0xC870,0xAE30,0xC11C,0xD654,0xAC81,0xC0AC,0xD56D,
    0xB3C8,0xB9D0,0xAC1C,0xC2EC,0xBC18,0xC6D0,0xBE44,0xB85C,
    0xBB38,0xD638,0xB85C,0xC0AC,0xBC29,0xBD84,0xB0A9,0xC6B0,
    0xD3B8,0xBAA8,0xAC00,0xD569,0xD5C8,0xD568,0xBE44,0xB839,
    # 0x9B80 #
    0xD0C0,0xBC1C,0xC218,0xD3C9,0xBD88,0xD544,0xC81C,0xBBF8,
    0xAD6C,0xC870,0xBC31,0xC720,0xACE4,0xD53C,0xC810,0xC131,
    0xD0DC,0xD3EC,0xBD80,0xC790,0xAC70,0xACE0,0xC11D,0xB3D9,
    0xB300,0xD0D1,0xAE38,0xC219,0xD6C4,0xC0C1,0xC774,0xC548,
    0xC678,0xC870,0xC8FC,0xC778,0xB82C,0xB77D,0xB3D9,0xC81C,
    0xC9C0,0xBCD1,0xC720,0xAD50,0xBCF4,0xD574,0xC120,0xD569,
    0xD68C,0xB85C,0xBCF5,0xACE0,0xD734,0xD0C8,0xAD70,0xC81C,
    0xBA74,0xC18C,0xC790,0xC0AC,0xCE68,0xC5EC,0xB1CC,0xCCA9,
    0xACE4,0xACBD,0xC18C,0xC6B0,0xAD6C,0xC120,0xD3EC,0xD658,
    0xC870,0xB9AC,0xC0AC,0xC0AC,0xACE0,0xBAB8,0xC131,0xB9AC,
    0xC8FC,0xD76C,0xC6A9,0xC2E0,0xCE58,0xAE30,0xCCAD,0xC0C1,
    0xB1CC,0xC21C,0xACC4,0xC870,0xCCA9,0xACE0,0xCD94,0xB3D9,
    0xB798,0xBE44,0xC608,0xC5ED,0xACE4,0xB959,0xAD6C,0xCC3D,
    0xACBD,0xB95C,0xB989,0xCD94,0xB9AC,0xB9F9,0xC885,0xC81C,
    0xC5FC,0xD638,0xC5B4,0xC800,0xC2AC,0xC18C,0xD63C,0xC81C,
    0xD6C4,0xC131,0xB2E4,0xB784,0xC885,0xC989,0xD3B8,0xD3B8,
    # 0x9C00 #
    0xD658,0xCC9C,0xC989,0xC678,0xC704,0xC639,0xCD98,0xC720,
    0xC811,0xD669,0xB828,0xC5B8,0xCD94,0xCD94,0xAC74,0xBCBD,
    0xC545,0xC591,0xBCF5,0xC0C8,0xD568,0xD558,0xD0C0,0xD638,
    0xC2E4,0xC57D,0xC120,0xC628,0xACB8,0xD638,0xC624,0xBC29,
    0xC18C,0xB958,0xB9C8,0xC2DC,0xC0AC,0xD658,0xC790,0xB4F1,
    0xD0D1,0xC694,0xC555,0xC6A9,0xAC74,0xAE30,0xC628,0xC57D,
    0xC2E0,0xB828,0xC624,0xB975,0xD718,0xBBFC,0xC81C,0xC870,
    0xAD6C,0xACAC,0xC18C,0xB9CC,0xC2B5,0xC218,0xD45C,0xC801,
    0xAE30,0xCD95,0xC7A5,0xCD94,0xC804,0xC6A9,0xC7A5,0xAC15,
    0xC124,0xBCC4,0xC728,0xAC70,0xC0C1,0xBC1C,0xAD50,0xC2EC,
    0xC219,0xD669,0xC900,0xC120,0xC120,0xBC88,0xAD90,0xB9B0,
    0xC2EC,0xBB18,0xD76C,0xC99D,0xD5A5,0xBD84,0xD658,0xD6C4,
    0xD68C,0xC989,0xC18C,0xC804,0xAC10,0xADA4,0xC2B9,0xB840,
    0xC0C1,0xB8B0,0xC11C,0xC560,0xC720,0xC81C,0xC11C,0xD654,
    0xC11C,0xB824,0xB835,0xB825,0xBA78,0xCE68,0xC0C1,0xC545,
    0xB85C,0xAD00,0xB824,0xC120,0xC5B4,0xB3C4,0xAE30,0xC6B0,
    # 0x9C80 #
    0xB3C8,0xB85C,0xBC29,0xD30C,0xAC00,0xBC1C,0xD3C9,0xC810,
    0xB85C,0xC720,0xC790,0xBD80,0xBC31,0xD3EC,0xD6C4,0xD53C,
    0xD0DC,0xD574,0xAE38,0xACE0,0xC720,0xC774,0xB3D9,0xC989,
    0xD6C4,0xD68C,0xC81C,0xAD50,0xC120,0xC790,0xC0C1,0xC2EC,
    0xACBD,0xB824,0xB828,0xACAC,0xB9AC,0xC2DC,0xC870,0xACE4,
    0xC0AC,0xD658,0xAD70,0xC989,0xC6A9,0xCCAD,0xB989,0xAE30,
    0xCD94,0xBE44,0xACE4,0xCC3D,0xACE0,0xC608,0xC5FC,0xC870,
    0xACBD,0xC18C,0xC2AC,0xCE58,0xBD84,0xC811,0xBCBD,0xC0C1,
    0xC81C,0xC628,0xC678,0xC0C8,0xC545,0xCD94,0xBCF5,0xD669,
    0xCC9C,0xC7A5,0xD3B8,0xC18C,0xC624,0xAE30,0xD0D1,0xD658,
    0xC694,0xBC29,0xACB8,0xB975,0xD45C,0xC124,0xBCC4,0xB9CC,
    0xBBFC,0xC6A9,0xC704,0xC2B5,0xAD90,0xC120,0xB9B0,0xC900,
    0xD654,0xAC10,0xB840,0xC804,0xAD00,0xC870,0xC744,0xBD80,
    0xB825,0xAD6C,0xBCF5,0xC548,0xBD80,0xB3C4,0xACC4,0xBD09,
    0xC785,0xAC04,0xC2DC,0xBD09,0xBA85,0xBCF4,0xC5F0,0xC9C0,
    0xD638,0xAE08,0xBD80,0xBC18,0xBB38,0xACAC,0xC0AC,0xC625,
    # 0x9D00 #
    0xBD80,0xC694,0xACB0,0xACA9,0xD544,0xD658,0xC9D0,0xBCF4,
    0xC548,0xC544,0xC815,0xBC29,0xBD09,0xBB38,0xAD6C,0xD2B9,
    0xAC00,0xB178,0xB839,0xBA78,0xD54D,0xD0C0,0xBBFC,0xB9BD,
    0xBCC0,0xCE58,0xAC00,0xC6D0,0xC790,0xAD6C,0xD6A8,0xCE58,
    0xB2E8,0xC800,0xC694,0xACE0,0xC885,0xC728,0xC559,0xC728,
    0xC555,0xC77C,0xC6A9,0xC804,0xD559,0xD1F4,0xC624,0xC774,
    0xAD04,0xC560,0xC9C0,0xC548,0xD589,0xAD50,0xC54C,0xB82C,
    0xC8FC,0xC591,0xC81C,0xD64D,0xB77D,0xC5EC,0xBAA8,0xD569,
    0xC784,0xAD50,0xD734,0xC8FC,0xCE58,0xAC01,0xD589,0xB144,
    0xBA85,0xB780,0xACB9,0xAE30,0xB3C4,0xD658,0xD0C0,0xD3EC,
    0xBB34,0xACAC,0xC695,0xBC1C,0xC900,0xC900,0xAC81,0xD76C,
    0xAD70,0xACA9,0xB3C5,0xACBD,0xC81C,0xC544,0xC544,0xAD11,
    0xACE1,0xBB34,0xC2E0,0xB798,0xAC01,0xD310,0xB85D,0xBCD1,
    0xC11C,0xBCF5,0xC554,0xD0C1,0xBD95,0xAE08,0xAC10,0xD544,
    0xC870,0xB959,0xC791,0xACAC,0xAD6D,0xD1A0,0xC544,0xC6D0,
    0xAE30,0xB824,0xC57C,0xCD94,0xACF5,0xD0C8,0xACE4,0xC2B9,
    # 0x9D80 #
    0xAE30,0xACBD,0xC5ED,0xC5ED,0xCCAD,0xCE58,0xB798,0xB3D9,
    0xCC98,0xC21C,0xACBD,0xAC70,0xAD74,0xC774,0xC885,0xACC4,
    0xC220,0xD615,0xCE59,0xBB18,0xC720,0xC554,0xCD94,0xC81C,
    0xD638,0xC81C,0xC545,0xAC1C,0xBAA8,0xBCF5,0xCD98,0xB3CC,
    0xC5B8,0xAC08,0xC6D0,0xD3B8,0xACE4,0xBBF8,0xD638,0xC601,
    0xB2E8,0xBAA9,0xACA9,0xAC04,0xCC3D,0xBC29,0xD559,0xC575,
    0xC6D0,0xAC74,0xC639,0xC0AC,0xD559,0xCD94,0xB2F9,0xD560,
    0xC57D,0xB958,0xCC99,0xACE8,0xACB8,0xC900,0xD55C,0xC790,
    0xC790,0xC775,0xC694,0xC548,0xACC4,0xB960,0xC804,0xAD6C,
    0xCCB4,0xCCB4,0xC5ED,0xB3C4,0xB9C8,0xAD50,0xACE0,0xC804,
    0xC2E0,0xAE09,0xB2E8,0xC790,0xC624,0xC694,0xC608,0xAD6C,
    0xCE59,0xC9C0,0xB958,0xC6A9,0xB8E8,0xD544,0xC0C1,0xC791,
    0xC5B4,0xBB34,0xAD90,0xC74C,0xB2E8,0xC0AC,0xCD08,0xC77C,
    0xD654,0xBCC4,0xC575,0xC219,0xD669,0xBC88,0xAD50,0xB8CC,
    0xC5F0,0xACE0,0xCDE8,0xD55C,0xD55C,0xB3C4,0xB9E4,0xC900,
    0xD73C,0xC751,0xB85C,0xB2E8,0xD55C,0xD559,0xC758,0xBCBD,
    # 0x9E00 #
    0xCD09,0xB77C,0xACC4,0xC758,0xACA9,0xD0DD,0xC6B0,0xC804,
    0xC5C5,0xC591,0xBCBD,0xB155,0xD655,0xC2DC,0xC575,0xBABD,
    0xC801,0xC545,0xC5EC,0xB958,0xBCF5,0xB85C,0xD559,0xB871,
    0xC0C1,0xC57D,0xC575,0xAD00,0xAD6C,0xB9AC,0xB780,0xC870,
    0xAD6C,0xACC4,0xC5F0,0xBA85,0xC2DC,0xAD6C,0xC544,0xCC3D,
    0xBCF4,0xC9D0,0xACE0,0xB3D9,0xB85C,0xC555,0xD6A8,0xC559,
    0xB839,0xCE58,0xAD6C,0xC6D0,0xD559,0xD0C0,0xC0AC,0xC9C0,
    0xC774,0xAD04,0xD734,0xD589,0xC8FC,0xD569,0xB780,0xD64D,
    0xBB34,0xBC1C,0xB9AC,0xACAC,0xACE1,0xC544,0xC695,0xD55C,
    0xC81C,0xBB34,0xC791,0xBB18,0xC554,0xACE4,0xD544,0xBD95,
    0xAC10,0xC21C,0xACBD,0xC6D0,0xC219,0xD638,0xAC08,0xC545,
    0xACE8,0xCD94,0xC790,0xBBF8,0xBAA9,0xC5ED,0xC694,0xC5ED,
    0xC21C,0xCC99,0xC775,0xACB8,0xD559,0xC608,0xC575,0xC790,
    0xB958,0xB8CC,0xCD08,0xCDE8,0xD73C,0xB85C,0xD658,0xC804,
    0xC751,0xD655,0xBABD,0xAD00,0xC0C1,0xB85C,0xAE0D,0xB839,
    0xAC10,0xD568,0xCC28,0xAC10,0xAC10,0xC5FC,0xCC28,0xB85D,
    # 0x9E80 #
    0xC6B0,0xCD94,0xADA4,0xD3EC,0xCD94,0xD3EC,0xC870,0xADE0,
    0xC8FC,0xACAC,0xBBF8,0xBBF8,0xC6B0,0xB958,0xC2E0,0xADE0,
    0xB9B0,0xC608,0xAE30,0xB85D,0xAD6C,0xADE0,0xACBD,0xB824,
    0xD5A5,0xC554,0xAC00,0xBBF8,0xB960,0xC0AC,0xC7A5,0xB9B0,
    0xACBD,0xC81C,0xB839,0xC554,0xCD94,0xB9E5,0xB9E5,0xD758,
    0xCD08,0xBD80,0xBA74,0xBA74,0xBD80,0xD3EC,0xAC70,0xAD6D,
    0xBAA8,0xBD80,0xD55C,0xB798,0xAD6D,0xBA74,0xB9AC,0xD48D,
    0xBD80,0xBD80,0xBA74,0xB9C8,0xB9C8,0xB9C8,0xD718,0xB9C8,
    0xCD94,0xD5A5,0xBD84,0xD669,0xD669,0xAE08,0xAD11,0xCCA8,
    0xC8FC,0xD6A1,0xADDC,0xAD11,0xD6A1,0xC11C,0xB824,0xC810,
    0xB9AC,0xD751,0xD751,0xC775,0xAC80,0xB2F4,0xAE30,0xB3C8,
    0xBB35,0xBB35,0xACB8,0xB300,0xCD9C,0xC720,0xC810,0xC774,
    0xD790,0xC5FC,0xCD9C,0xB9E4,0xC554,0xACBD,0xC6B8,0xB824,
    0xB2F9,0xB3C5,0xCC38,0xC548,0xC554,0xC554,0xB2F4,0xC554,
    0xC9C4,0xB300,0xCC38,0xC608,0xBBF8,0xB2F4,0xC5FC,0xB3C5,
    0xB85C,0xCE58,0xBD84,0xBD88,0xBCF4,0xBBFC,0xBBFC,0xC6D0,
    # 0x9F00 #
    0xCD95,0xAC70,0xC870,0xC640,0xC8FC,0xC9C0,0xB9F9,0xC624,
    0xBCC4,0xD0C0,0xBCBD,0xC6D0,0xC870,0xD0C0,0xC815,0xBA71,
    0xB0B4,0xC815,0xC790,0xACE0,0xACE0,0xB3D9,0xBD84,0xB3C4,
    0xC5F0,0xBE44,0xCC3D,0xACE0,0xCC99,0xC5F0,0xB2F9,0xB4F1,
    0xC11C,0xC11C,0xBD84,0xD3D0,0xBB38,0xBC1C,0xCD08,0xD0C0,
    0xC885,0xAD6C,0xC0DD,0xC11D,0xC720,0xC2DC,0xC815,0xC624,
    0xB144,0xC815,0xD63C,0xACA9,0xC5B8,0xB3CC,0xC0AC,0xD61C,
    0xACB8,0xC5B8,0xB8E8,0xBE44,0xADDC,0xAD6C,0xD55C,0xC62C,
    0xC62C,0xD6C4,0xD76C,0xC54C,0xC0AC,0xD6C4,0xC639,0xCC28,
    0xB18D,0xB0AD,0xC81C,0xC7AC,0xC81C,0xC790,0xC7AC,0xC81C,
    0xC81C,0xC81C,0xCE58,0xCE5C,0xCE5C,0xD758,0xC544,0xC740,
    0xACC4,0xD3EC,0xC0C9,0xC138,0xC7AC,0xCE58,0xC5B8,0xC800,
    0xCD08,0xB839,0xB839,0xCC99,0xAD8C,0xC138,0xAC04,0xC124,
    0xAD6C,0xAD50,0xCC29,0xACE4,0xC5B4,0xC18C,0xAE30,0xC608,
    0xC0C9,0xCD94,0xC6B0,0xC6B4,0xC5B8,0xC6B0,0xC545,0xC545,
    0xC775,0xCC28,0xCD94,0xC804,0xCD08,0xAE08,0xC54C,0xCE58,
    # 0x9F80 #
    0xCE5C,0xD758,0xC740,0xC800,0xB839,0xD3EC,0xCD08,0xC7AC,
    0xAC04,0xC5B4,0xCC29,0xC6B0,0xC545,0xB8E1,0xB871,0xACF5,
    0xBC29,0xC5C4,0xB8E1,0xB871,0xACF5,0xAC10,0xB2F5,0xB839,
    0xB2F5,0xB8E1,0xACF5,0xAC10,0xAD6C,0xCD94,0xBCC4,0xAD6C,
    0xC57D,0xCDE8,0xD654,0xB85D,0xD574,0xC720 # 0x9FA5
    );

    @hanjaextA_to_hangul = (
    # 0x3400 #
    0xAD6C,0xCCA8,0xCE60,0xB9C8,0xACFC,0xC624,0xC740,0xAD74,
    0xB458,0xC808,0xC0B4,0xD1A8,0xC774,0xC878,0xAE00,0xC62C,
    0xB180,0xB3CC,0xC878,0xAC08,0xACE8,0xC728,0xD608,0xB180,
    0xC300,0xB458,0xC62C,0xC6B8,0xAD6C,0xAD74,0xAE38,0xAE38,
    0xC728,0xC720,0xB730,0xACE8,0xAD6C,0xC124,0xAC78,0xC81C,
    0xC11C,0xD615,0xCC9C,0xD749,0xB958,0xB984,0xC591,0xC6A9,
    0xC2E0,0xC9C4,0xB300,0xC62C,0xBC18,0xC720,0xC0AC,0xB9C8,
    0xD760,0xD758,0xC911,0xB0B4,0xC2B9,0xD48D,0xC6D0,0xACA9,
    0xD0DC,0xCD9C,0xBC29,0xC694,0xBAA8,0xC791,0xC774,0xCD94,
    0xB3D9,0xC219,0xC5ED,0xAD81,0xC655,0xB8B0,0xB1CC,0xC800,
    0xC219,0xC790,0xCCA8,0xC900,0xC218,0xC138,0xC911,0xC2E0,
    0xAC1C,0xC811,0xB098,0xC18D,0xC808,0xB871,0xC789,0xD33D,
    0xACAC,0xC989,0xAC01,0xB78C,0xBB18,0xC774,0xB824,0xACC4,
    0xC624,0xB77C,0xC81C,0xB150,0xACE0,0xBE44,0xD63C,0xC218,
    0xD6FC,0xC694,0xB0A8,0xCD94,0xCE68,0xC9C8,0xD76C,0xD0DC,
    0xC694,0xD68C,0xC900,0xB9D0,0xB7B5,0xB2F9,0xC694,0xC18C,
    # 0x3480 #
    0xC801,0xC6B0,0xCC29,0xC774,0xC5F0,0xACC4,0xD761,0xBB34,
    0xAC10,0xCC3D,0xC2B5,0xC2DC,0xACBD,0xB8E8,0xC0BD,0xD55C,
    0xC21C,0xD68C,0xBCF5,0xB2EC,0xB3C5,0xC559,0xC6B0,0xB300,
    0xC218,0xBA74,0xC740,0xC870,0xC5EC,0xBA78,0xC900,0xB1E8,
    0xD574,0xC720,0xC57D,0xC751,0xC12D,0xD48D,0xB8B0,0xB824,
    0xC120,0xB77C,0xC11D,0xAE30,0xC655,0xACE4,0xC2DC,0xC5FD,
    0xC804,0xBABD,0xC7AC,0xB7C9,0xACE8,0xBAA8,0xACF5,0xD765,
    0xC218,0xC804,0xB9DD,0xBAA8,0xB9CC,0xAD8C,0xC2DC,0xB9AC,
    0xBCF5,0xBA85,0xAD6C,0xD0C0,0xCE68,0xC815,0xB95C,0xC625,
    0xBE59,0xD65C,0xB3D9,0xACF5,0xC7C1,0xCDA9,0xCE68,0xACBD,
    0xB959,0xD589,0xCE60,0xB0A8,0xC0AC,0xBA78,0xD544,0xACB0,
    0xC219,0xD749,0xACF5,0xACF5,0xC720,0xD615,0xAC08,0xD53C,
    0xC810,0xBD80,0xB77D,0xAC11,0xAC08,0xB2F9,0xBC31,0xD568,
    0xC790,0xD6E4,0xB791,0xB300,0xACE0,0xC124,0xC870,0xB824,
    0xD68D,0xB450,0xD3B8,0xC800,0xC5F0,0xC545,0xACB0,0xC758,
    0xCC29,0xCCB4,0xAC74,0xAC15,0xCE60,0xC22D,0xC11C,0xCE60,
    # 0x3500 #
    0xB7C9,0xB4F1,0xB9B0,0xC808,0xC18D,0xC18C,0xC7A0,0xBC1C,
    0xBE44,0xCD09,0xC804,0xAC10,0xCD94,0xCD2C,0xC124,0xB825,
    0xCCA8,0xCE60,0xD734,0xAC74,0xAC15,0xAE00,0xAC01,0xBE44,
    0xCD9C,0xBCD1,0xAD6C,0xD560,0xBC1C,0xB7C9,0xAD34,0xC138,
    0xD560,0xBCC4,0xC808,0xB8B0,0xC2EC,0xD328,0xC591,0xB85C,
    0xBC30,0xC555,0xB85C,0xC88C,0xD0C1,0xC2DC,0xB098,0xC120,
    0xD56D,0xC720,0xADA4,0xADA4,0xC775,0xC120,0xAC10,0xB8E8,
    0xCCB4,0xB97C,0xC138,0xBE44,0xC21C,0xC720,0xC808,0xC8FC,
    0xC8FC,0xAC01,0xC74C,0xACC4,0xC9C0,0xAC11,0xD638,0xB78D,
    0xC758,0xAC11,0xBD80,0xAE08,0xC560,0xD1F4,0xC555,0xC8FC,
    0xC0AC,0xC8FC,0xC758,0xC804,0xCCAD,0xD658,0xC18C,0xC720,
    0xCC38,0xC900,0xC870,0xC6B0,0xC0AC,0xACE0,0xC1C4,0xAD34,
    0xC30D,0xD559,0xAC1C,0xC5F0,0xAD6C,0xC774,0xD654,0xD788,
    0xBC94,0xBC29,0xB2F4,0xBC29,0xACF5,0xC694,0xBD80,0xB20C,
    0xD559,0xC6B0,0xD65C,0xD749,0xCE68,0xB9DD,0xC740,0xBC15,
    0xB9BD,0xBC8C,0xD6A8,0xD22C,0xD749,0xC0AC,0xC19F,0xD5A5,
    # 0x3580 #
    0xB960,0xB9B0,0xC608,0xD6C4,0xC8FC,0xC220,0xACE1,0xC774,
    0xB188,0xAE30,0xC2EC,0xAC2F,0xAD7F,0xB463,0xAC2F,0xB148,
    0xC704,0xACC4,0xC81C,0xD64D,0xD0C4,0xC54C,0xC54C,0xC74C,
    0xC9C4,0xAC13,0xBD93,0xACF3,0xACF3,0xB057,0xAD18,0xC218,
    0xB098,0xC57C,0xC790,0xD22C,0xD568,0xAD70,0xB3D9,0xD63C,
    0xB85D,0xCD94,0xD68D,0xB989,0xC218,0xCCA8,0xB95C,0xB625,
    0xB625,0xBC40,0xC5FF,0xC5FF,0xD640,0xAD6C,0xC5F4,0xC2DC,
    0xAC39,0xBD84,0xCD98,0xB274,0xBAA8,0xCC45,0xC545,0xC0AC,
    0xC720,0xC545,0xC0DD,0xBB38,0xB9CC,0xD638,0xAC1D,0xD558,
    0xB9CC,0xB7B5,0xC9D1,0xD6C4,0xC9C8,0xC7AC,0xAC00,0xC65C,
    0xAC11,0xBC30,0xC560,0xCD94,0xAC74,0xAD6C,0xB2F4,0xD328,
    0xBC15,0xCD94,0xB960,0xC18C,0xD6C4,0xACE0,0xD30C,0xC90F,
    0xBE44,0xC787,0xB3D9,0xC81C,0xCD95,0xACFD,0xB85C,0xC9C8,
    0xD574,0xC2B5,0xD53C,0xC808,0xCC28,0xC2E4,0xBA85,0xC7A3,
    0xC885,0xC9D1,0xD68D,0xD0D1,0xC548,0xD6CC,0xBC1C,0xC0C8,
    0xC704,0xCD08,0xBE44,0xACFC,0xC5C5,0xD5A5,0xD654,0xD558,
    # 0x3600 #
    0xC791,0xC5ED,0xC790,0xC57C,0xB989,0xD568,0xB300,0xC601,
    0xC758,0xC990,0xC74D,0xD604,0xADF9,0xC9C8,0xD568,0xB3D7,
    0xD45C,0xB840,0xC53B,0xB780,0xC0C8,0xB78C,0xC548,0xAD6C,
    0xBE44,0xC554,0xD568,0xAC10,0xC218,0xB2D9,0xC790,0xCC3D,
    0xBCBD,0xD569,0xC639,0xC120,0xC644,0xC640,0xADFC,0xC11C,
    0xAD34,0xBE44,0xBAA8,0xC815,0xBD88,0xC694,0xCC99,0xC7A5,
    0xC9D0,0xB2F4,0xAD6D,0xAD6C,0xC88C,0xD3EC,0xAC78,0xC560,
    0xC88C,0xC790,0xBC8C,0xC778,0xACE0,0xC7AC,0xC6B0,0xB148,
    0xAD6C,0xB9E4,0xD0DC,0xBCD1,0xD3D0,0xBCF4,0xD64D,0xCD09,
    0xD558,0xC804,0xC7A5,0xAE30,0xC18C,0xCCA0,0xC704,0xBCF5,
    0xD0C0,0xC6B0,0xC57C,0xADDC,0xC704,0xAD34,0xC6B0,0xC678,
    0xC694,0xB871,0xC131,0xBCF4,0xB300,0xD611,0xC5BC,0xB791,
    0xC608,0xC885,0xB9CC,0xC7A5,0xD558,0xACE4,0xC0AC,0xB958,
    0xAE30,0xB8CC,0xC608,0xC9D1,0xC740,0xAD90,0xB2F5,0xC608,
    0xD574,0xD638,0xC639,0xAC10,0xCCA8,0xB300,0xB2F9,0xCE69,
    0xBC15,0xBABD,0xADA4,0xC804,0xB8E8,0xC11D,0xAC01,0xD76C,
    # 0x3680 #
    0xD76C,0xAD50,0xB0AD,0xC6B4,0xCCB4,0xB96D,0xBCF5,0xC885,
    0xCC9C,0xACE0,0xD574,0xC870,0xACFC,0xAD34,0xB300,0xD638,
    0xD22C,0xB839,0xC12C,0xB798,0xB151,0xBD88,0xACE0,0xC790,
    0xBC18,0xAC00,0xAD49,0xD61C,0xC5ED,0xC21C,0xC2EC,0xCC29,
    0xD6A8,0xAE30,0xB178,0xAD50,0xC775,0xC6B0,0xD76C,0xC5C4,
    0xC2E0,0xC5FC,0xD638,0xC0BD,0xADE0,0xC6B0,0xB2F4,0xC2EC,
    0xBC30,0xAD6C,0xCCA8,0xC544,0xD3EC,0xB3D9,0xC0AC,0xB0B4,
    0xC2DC,0xBB18,0xC789,0xAE30,0xD638,0xAD50,0xD615,0xD3EC,
    0xCD94,0xD3C9,0xC640,0xACB0,0xC758,0xC774,0xD0C0,0xC7A5,
    0xACE0,0xC11C,0xD0C0,0xC774,0xBAA8,0xD611,0xB824,0xAD6C,
    0xC218,0xCC2C,0xB450,0xCE58,0xBD09,0xC555,0xC0AC,0xC88C,
    0xBC1C,0xC2E0,0xC6A9,0xC2E0,0xC720,0xD328,0xB871,0xD658,
    0xD55C,0xC644,0xC218,0xC6B4,0xB9AC,0xD0D1,0xB78C,0xB9D8,
    0xAC15,0xCD95,0xC5C4,0xC11D,0xB959,0xC11D,0xC218,0xBA74,
    0xD63C,0xC678,0xBC1C,0xC608,0xB1CC,0xCE6D,0xD0C4,0xACC4,
    0xC218,0xBCC0,0xC554,0xACFC,0xC0BD,0xC0B0,0xD568,0xB300,
    # 0x3700 #
    0xC0C1,0xC0AC,0xBD09,0xB828,0xC2EC,0xCD95,0xBBF8,0xC774,
    0xBAA9,0xC639,0xC804,0xC775,0xB204,0xB2F9,0xD61C,0xC6B4,
    0xC218,0xD30C,0xC608,0xB2F5,0xACBD,0xB828,0xC870,0xCC38,
    0xCC98,0xB85D,0xC219,0xB208,0xC624,0xC554,0xCC38,0xAC10,
    0xCD5C,0xC885,0xB8E8,0xC5F0,0xB2F4,0xB9E4,0xC2EC,0xC6D4,
    0xB0B4,0xC624,0xC2E0,0xBBF8,0xCCA8,0xB2F9,0xB78C,0xD76C,
    0xC57D,0xC9C8,0xC601,0xD68C,0xBABD,0xB1E8,0xBC18,0xBBF8,
    0xC5BC,0xAD6C,0xCC2C,0xB828,0xC9C8,0xC790,0xD574,0xC11C,
    0xD638,0xACAC,0xC81C,0xBA74,0xC21C,0xB204,0xD76C,0xC21C,
    0xB828,0xC800,0xC218,0xB8CC,0xAD6C,0xC0AC,0xC815,0xAC1C,
    0xC6A9,0xBC29,0xAC70,0xD569,0xC694,0xB155,0xC758,0xB7C9,
    0xC639,0xC778,0xC5F0,0xC219,0xC11D,0xB9BC,0xC544,0xBAA8,
    0xBA85,0xCD5C,0xC6B0,0xC608,0xAD6C,0xBBF8,0xC900,0xC628,
    0xC6D0,0xAC15,0xC810,0xB96D,0xD560,0xC131,0xCD5C,0xAD50,
    0xBA74,0xBABD,0xCE68,0xB300,0xC644,0xC560,0xB4DD,0xC2EC,
    0xBCC0,0xB204,0xB834,0xADFC,0xC6B0,0xC218,0xC88C,0xD30C,
    # 0x3780 #
    0xD68C,0xC694,0xD1F4,0xADF9,0xC554,0xB77C,0xAE30,0xC678,
    0xBC1C,0xCC30,0xC220,0xC9C1,0xC789,0xD658,0xD30C,0xCE69,
    0xAC70,0xBBF8,0xD574,0xAE30,0xC2DC,0xC124,0xCC28,0xAD6C,
    0xB3C5,0xB1E8,0xCE69,0xAE30,0xD1F4,0xCC99,0xC1A1,0xC804,
    0xB8CC,0xC804,0xC9C0,0xBD84,0xC74C,0xC7A0,0xADA4,0xD68C,
    0xC9C0,0xB78C,0xB178,0xC8FC,0xADFC,0xB300,0xC704,0xAE30,
    0xD5C8,0xCD1D,0xC6C5,0xB450,0xC9C0,0xB3C4,0xBBFC,0xC655,
    0xBD88,0xAC00,0xC871,0xD638,0xC2B9,0xC6D4,0xB2C8,0xAE30,
    0xB828,0xC548,0xBAA8,0xC0AC,0xC0C1,0xC559,0xD654,0xC88C,
    0xAD6C,0xB85C,0xBD80,0xD0DC,0xB9DD,0xB791,0xD0C0,0xD568,
    0xB9DD,0xBC1C,0xADE0,0xAE30,0xD568,0xB450,0xB871,0xBE48,
    0xC870,0xCC45,0xAE30,0xC7A0,0xBBF8,0xBC30,0xC794,0xD56D,
    0xAC15,0xAD8C,0xAE30,0xC22D,0xB85D,0xCC38,0xC6B4,0xC545,
    0xB2E8,0xBBFC,0xC704,0xCC9C,0xC218,0xBBFC,0xB3CC,0xC561,
    0xBA85,0xC694,0xC6D0,0xB960,0xC678,0xAC15,0xC6D0,0xB2F5,
    0xACE0,0xB8CC,0xB8E8,0xCC38,0xC624,0xD45C,0xC6A9,0xB9DD,
    # 0x3800 #
    0xB3C4,0xCC38,0xC624,0xC801,0xC2B5,0xBCF5,0xB2E8,0xCD94,
    0xC724,0xB3D9,0xD5C8,0xC545,0xAE30,0xC9D1,0xC9D1,0xD654,
    0xAD50,0xC8C4,0xD45C,0xBABD,0xBC30,0xC678,0xC758,0xC624,
    0xC11C,0xD638,0xB300,0xD655,0xC758,0xCC2C,0xC9D5,0xB824,
    0xB824,0xB1E8,0xD68C,0xB825,0xC591,0xB8B0,0xD48D,0xBBF8,
    0xC6B8,0xD669,0xAC70,0xBD80,0xBD80,0xC804,0xBD09,0xC774,
    0xAC08,0xAE30,0xBE44,0xB9C9,0xC778,0xD669,0xBC94,0xAC11,
    0xBD80,0xAC1C,0xC0AC,0xD76C,0xC0AC,0xB3D9,0xC6D0,0xC790,
    0xD3D0,0xACFC,0xB840,0xD669,0xC21C,0xB098,0xD669,0xCCA9,
    0xBB38,0xD604,0xD761,0xC5C5,0xBAA8,0xBC31,0xC0BC,0xC720,
    0xC804,0xC870,0xC900,0xACE4,0xBB34,0xC601,0xC885,0xCCB4,
    0xB834,0xBE44,0xAD6C,0xD669,0xC124,0xBD09,0xB8E8,0xC870,
    0xC815,0xC8FC,0xB9CC,0xB8E1,0xC5C5,0xC740,0xBE48,0xC815,
    0xCCA8,0xB780,0xB208,0xC608,0xAE30,0xACC4,0xAE30,0xD0DD,
    0xC6B0,0xAD6C,0xD658,0xC800,0xB78D,0xB839,0xC9C0,0xBCF8,
    0xC0AC,0xC800,0xB2E8,0xB8CC,0xC608,0xC870,0xD55C,0xCC99,
    # 0x3880 #
    0xC790,0xCE58,0xC5C4,0xB791,0xB450,0xB871,0xC804,0xC5B8,
    0xD1F4,0xD0C0,0xC758,0xCE58,0xC544,0xC601,0xC811,0xD22C,
    0xC544,0xC218,0xCC28,0xC7A5,0xC885,0xC639,0xBC18,0xAD50,
    0xB834,0xADFC,0xB85C,0xC5C4,0xAC15,0xC18C,0xC775,0xC9C0,
    0xD615,0xC7A5,0xD3D0,0xACBD,0xC7AC,0xB3D9,0xAC00,0xAD8C,
    0xD55C,0xC801,0xC624,0xC0B0,0xD6A1,0xB3C4,0xC774,0xB3C8,
    0xD53C,0xBA70,0xC190,0xB85C,0xC11C,0xD611,0xD544,0xC138,
    0xD544,0xC2E0,0xD604,0xC704,0xBCC4,0xC774,0xACAC,0xD6C4,
    0xC9C4,0xBE44,0xC5ED,0xC721,0xAC70,0xC7A0,0xBBF8,0xC774,
    0xC2DC,0xACF5,0xC218,0xB2E8,0xC0BC,0xD0DC,0xBAA9,0xC815,
    0xBCC0,0xC6A9,0xC99D,0xCC2C,0xC815,0xB300,0xD0DC,0xD638,
    0xAD6C,0xC801,0xD1B5,0xD68C,0xD615,0xC22D,0xD0C8,0xAE38,
    0xB3D9,0xC911,0xC81C,0xC12C,0xCC9C,0xCE58,0xC704,0xC724,
    0xACE0,0xB9BC,0xC644,0xC885,0xC9D1,0xC885,0xB0A8,0xC124,
    0xC2E4,0xC0C9,0xBBF8,0xBB34,0xD669,0xB2EC,0xB2E8,0xB155,
    0xC720,0xC751,0xC2EC,0xC560,0xC778,0xC11C,0xCC28,0xC870,
    # 0x3900 #
    0xB9DD,0xCCA8,0xAE09,0xBC29,0xD328,0xC560,0xD310,0xC624,
    0xC2EC,0xAC00,0xD6A8,0xBD84,0xAC10,0xAD50,0xAC00,0xB3D9,
    0xCCA8,0xC6B0,0xACE0,0xBD84,0xBD80,0xC904,0xC800,0xD0DC,
    0xCD08,0xC740,0xD56D,0xC784,0xD73C,0xCDA9,0xD0C1,0xACF5,
    0xB82C,0xB840,0xC6B1,0xD33D,0xC608,0xD574,0xB9AC,0xD6C4,
    0xACF5,0xAC01,0xC6D0,0xB355,0xC5D0,0xAD50,0xAD11,0xACBD,
    0xC791,0xBD80,0xD611,0xBC30,0xCCA9,0xC790,0xBC29,0xD568,
    0xD601,0xAD6C,0xD669,0xB860,0xAC81,0xC8FC,0xD0D0,0xC5C4,
    0xC2DD,0xB355,0xD2B9,0xBBFC,0xB989,0xC218,0xD1F4,0xC794,
    0xCCA9,0xBD80,0xBD95,0xC758,0xAD6D,0xAE30,0xB9AC,0xC804,
    0xC6D0,0xC6B0,0xCC44,0xAE30,0xC721,0xB828,0xC885,0xBBFC,
    0xAC81,0xCDA9,0xC720,0xADF9,0xC704,0xBBF8,0xC218,0xD734,
    0xC11C,0xCE58,0xCD94,0xD61C,0xAE0D,0xC6B0,0xD611,0xC21C,
    0xC218,0xD0C0,0xB8E8,0xB3C8,0xBC29,0xD0DC,0xCD08,0xC740,
    0xC18C,0xBE44,0xC9C4,0xC6D0,0xC774,0xD754,0xC0C9,0xD611,
    0xBBFC,0xBD84,0xD569,0xCC99,0xC740,0xCC45,0xB2C9,0xC624,
    # 0x3980 #
    0xBD09,0xB828,0xC0C1,0xC0B0,0xB9C8,0xCC44,0xD638,0xB85D,
    0xC560,0xC758,0xD654,0xCC28,0xCC2C,0xC545,0xD68D,0xC21C,
    0xB2C8,0xAC10,0xB9AC,0xC5F0,0xC5FC,0xB96D,0xBB38,0xAE08,
    0xACA9,0xC6B0,0xBCC0,0xC5EC,0xD655,0xB9C9,0xC8FC,0xB9E4,
    0xB300,0xB77D,0xC808,0xC704,0xC758,0xD5CC,0xD601,0xCC38,
    0xB780,0xC740,0xC12D,0xCC30,0xB77C,0xB839,0xC804,0xD639,
    0xCCA8,0xC544,0xC7AC,0xC7AC,0xACA9,0xC8FC,0xC6A9,0xC6A9,
    0xADF9,0xC591,0xC695,0xC2B5,0xC0C1,0xC6B1,0xC774,0xD638,
    0xAE09,0xAC11,0xC804,0xADDC,0xAC80,0xB3C4,0xADFC,0xBAA8,
    0xC778,0xC54C,0xBC1C,0xD604,0xBAA8,0xBC29,0xC544,0xAC15,
    0xC1A1,0xD718,0xC694,0xACFC,0xAD34,0xB958,0xC561,0xC790,
    0xC790,0xBE44,0xC640,0xB78C,0xC7A1,0xAC00,0xBC1C,0xD68C,
    0xC774,0xD574,0xC778,0xC8FC,0xCDA9,0xC120,0xD604,0xC18C,
    0xAD6C,0xD328,0xADA4,0xC720,0xACF5,0xACF5,0xD640,0xB85C,
    0xB825,0xB098,0xC0BC,0xC7AC,0xC544,0xBD80,0xAC31,0xD0C4,
    0xD33D,0xD2B9,0xB2F5,0xD0C1,0xD45C,0xACE0,0xD640,0xCC3D,
    # 0x3A00 #
    0xBCD1,0xC9C0,0xB3D9,0xD1F4,0xC870,0xC608,0xB984,0xD30C,
    0xC81C,0xBBFC,0xD0C0,0xCC28,0xAD6C,0xBC29,0xC5F0,0xD0C4,
    0xBD80,0xC885,0xADDC,0xB85C,0xD568,0xC601,0xCE58,0xCCA9,
    0xC131,0xD61C,0xC21C,0xC12C,0xAC74,0xC124,0xC18C,0xAC1C,
    0xBA74,0xD640,0xD53C,0xC639,0xD68C,0xB0A9,0xC1A1,0xBD84,
    0xCD94,0xCCA9,0xD669,0xB78C,0xC6D0,0xD638,0xB450,0xD655,
    0xACE4,0xC694,0xCC45,0xAE30,0xAC74,0xC804,0xB3C4,0xADFC,
    0xB9D0,0xC81C,0xBA74,0xCC38,0xB7B5,0xBCBD,0xC591,0xAC70,
    0xAC70,0xAC01,0xC0AD,0xAC74,0xC0AC,0xCD94,0xCD94,0xD68D,
    0xC6B4,0xD761,0xC120,0xC219,0xBE44,0xCC45,0xC5FD,0xBB35,
    0xB3C8,0xC0BD,0xAE08,0xD6FC,0xB454,0xB839,0xAC15,0xD734,
    0xC758,0xC0C9,0xBABD,0xB2E8,0xB78C,0xD638,0xCC45,0xC7AC,
    0xC624,0xB77C,0xBA78,0xD718,0xBD80,0xC12C,0xD734,0xBC15,
    0xD61C,0xACBD,0xD790,0xC9C8,0xD76C,0xD6A8,0xAC74,0xD30C,
    0xCD08,0xC791,0xAD8C,0xC1A1,0xAD6D,0xC54C,0xB151,0xAC74,
    0xCCA9,0xCCA9,0xBE44,0xAE30,0xC9C0,0xAE30,0xCD94,0xAD74,
    # 0x3A80 #
    0xC6B0,0xAE08,0xAD74,0xAC00,0xBD88,0xACBD,0xC800,0xC120,
    0xACC4,0xAC11,0xAD70,0xD55C,0xD1B5,0xBC1C,0xC12C,0xBE44,
    0xB960,0xC5C5,0xC608,0xC8C4,0xC0B0,0xC791,0xB85D,0xD22C,
    0xB834,0xACFC,0xC0B0,0xCE68,0xCDE8,0xB828,0xBAA8,0xB3C8,
    0xAC10,0xAC1C,0xC18C,0xACE0,0xD544,0xC790,0xC778,0xD761,
    0xC120,0xC219,0xC0BD,0xC608,0xD0C1,0xB85C,0xB839,0xAC70,
    0xC7AC,0xD658,0xB451,0xB465,0xD560,0xBC18,0xACE1,0xB450,
    0xC9D0,0xB8E8,0xAD6C,0xAD8C,0xAC00,0xC18C,0xACA9,0xC808,
    0xC815,0xB2E8,0xC800,0xC5B8,0xBC29,0xAE30,0xBBF8,0xC5B5,
    0xC5C9,0xC704,0xC758,0xC804,0xC815,0xC720,0xD718,0xC694,
    0xC694,0xC9C0,0xACF5,0xAE30,0xAC04,0xAD11,0xC9C0,0xD6C4,
    0xBC00,0xBD80,0xBB3C,0xAD11,0xB2E8,0xC800,0xB3C4,0xC5F0,
    0xBC18,0xB3D9,0xAC70,0xBBFC,0xCC3D,0xBA85,0xD1A0,0xD3EC,
    0xC548,0xCD98,0xC6A9,0xD604,0xC21C,0xC2DC,0xC790,0xBB35,
    0xB791,0xB09C,0xD328,0xC2E0,0xD6A8,0xBE44,0xC8FC,0xAE30,
    0xCCA9,0xC18C,0xC11D,0xACE4,0xC81C,0xB85D,0xC0C1,0xC720,
    # 0x3B00 #
    0xC21C,0xC7A1,0xC6B0,0xB300,0xCC2C,0xB9CC,0xBBFC,0xD658,
    0xC628,0xB09C,0xD658,0xD6C4,0xACBD,0xBC15,0xD604,0xB825,
    0xC9C4,0xD655,0xB9DD,0xD45C,0xD638,0xC591,0xACC4,0xB144,
    0xC18D,0xC704,0xCCA0,0xD761,0xC9C4,0xC1A1,0xAC08,0xBD95,
    0xC1C4,0xB839,0xD76C,0xB300,0xAE09,0xD3EC,0xD655,0xD3EC,
    0xD601,0xD61C,0xCCA9,0xC5F0,0xAD6C,0xC791,0xB09C,0xB82C,
    0xC720,0xCCB4,0xCCA8,0xC624,0xD64D,0xAD50,0xD638,0xACE4,
    0xB3C4,0xC7C1,0xAD8C,0xD669,0xBCF5,0xC870,0xC758,0xB3C8,
    0xC11C,0xC789,0xCD08,0xAC15,0xC9C4,0xC0BC,0xB0B4,0xC5F0,
    0xACB0,0xD654,0xC11D,0xBC29,0xBB34,0xCE60,0xAC15,0xD718,
    0xB9D0,0xB9E4,0xC0AC,0xBCC0,0xB85C,0xAC70,0xB300,0xC6B8,
    0xD569,0xC801,0xB824,0xD30C,0xC735,0xAD6C,0xB82C,0xACF5,
    0xC120,0xC2E0,0xD615,0xBB38,0xC870,0xBD80,0xD0DD,0xBC18,
    0xC57C,0xB82C,0xBD80,0xC88C,0xC800,0xD314,0xCD2C,0xCCA9,
    0xCD94,0xAC11,0xAC81,0xD6A8,0xACAC,0xC804,0xBC29,0xB0A8,
    0xB3C4,0xD604,0xC5C4,0xB2F9,0xB2F5,0xC800,0xAD74,0xC559,
    # 0x3B80 #
    0xAC10,0xD6A8,0xACE1,0xC704,0xBC29,0xCD94,0xC5BC,0xCCA8,
    0xB0B4,0xD611,0xBB34,0xC6B1,0xBA74,0xC794,0xBC30,0xB0B4,
    0xC131,0xCE69,0xC5F0,0xAE0D,0xCDA9,0xC774,0xAC08,0xADFC,
    0xBB34,0xC545,0xB960,0xC2DC,0xC7A5,0xD601,0xC808,0xB144,
    0xC601,0xAD00,0xD6C4,0xAC1C,0xC1A1,0xBD84,0xC0C9,0xC624,
    0xC9C1,0xC2DD,0xACF5,0xD560,0xC639,0xD568,0xACB0,0xD63C,
    0xBE44,0xC2B9,0xCD94,0xC9D0,0xC18C,0xC804,0xC0AD,0xACC4,
    0xC1A1,0xCE58,0xBCF8,0xC870,0xC0B0,0xBC18,0xB791,0xD544,
    0xC120,0xBC30,0xB300,0xCE60,0xC9C0,0xD53C,0xC0B0,0xD3D0,
    0xC18D,0xC800,0xD754,0xACBD,0xCC9C,0xC7A5,0xB17C,0xD615,
    0xD0C0,0xD0F1,0xBA71,0xD0D1,0xCDE8,0xC11C,0xC801,0xD55C,
    0xAD00,0xCCA0,0xB2F5,0xD638,0xCDE8,0xB85C,0xACAC,0xB85D,
    0xACAC,0xD3EC,0xC9D0,0xBD84,0xB825,0xC870,0xAE30,0xCD08,
    0xC728,0xC774,0xB839,0xAC70,0xB834,0xB85C,0xCD09,0xACF5,
    0xCE58,0xD45C,0xAE08,0xACBD,0xC6A9,0xB3D9,0xC885,0xBCF5,
    0xC9C4,0xD45C,0xD568,0xBCF8,0xAC1C,0xBE48,0xC870,0xB835,
    # 0x3C00 #
    0xB824,0xB77C,0xC2EC,0xBA74,0xC804,0xC801,0xBC30,0xC12C,
    0xB828,0xC9C4,0xC12C,0xBE48,0xAC01,0xB871,0xCD94,0xACE0,
    0xD0C0,0xC0BC,0xD559,0xB78C,0xC12D,0xD76C,0xB78C,0xCD95,
    0xC774,0xB098,0xB9AC,0xC57D,0xC804,0xC774,0xCE58,0xAE30,
    0xD56D,0xD574,0xAC31,0xC790,0xD558,0xD61C,0xAC70,0xD574,
    0xD76C,0xD574,0xC65C,0xCC38,0xC21C,0xD6C4,0xC2E0,0xB450,
    0xD569,0xC0BD,0xC6B1,0xC544,0xBD80,0xC878,0xAD6C,0xC790,
    0xAC10,0xD568,0xD558,0xC774,0xC12D,0xC5B8,0xAD50,0xD61C,
    0xCE58,0xC218,0xAC15,0xC74C,0xD751,0xC758,0xD76C,0xC0C9,
    0xAE08,0xC5C5,0xC6B0,0xAC01,0xCCA9,0xB780,0xACE4,0xC815,
    0xBB34,0xC138,0xAC00,0xB839,0xC0AC,0xADC0,0xCDE8,0xD734,
    0xC5FC,0xD6C4,0xC794,0xCC9C,0xCC30,0xC0AC,0xC74D,0xD53C,
    0xACE0,0xC2B9,0xB791,0xD1F4,0xC11D,0xB989,0xAE30,0xC644,
    0xB834,0xB3C5,0xD63C,0xB780,0xC624,0xB2E8,0xADA4,0xC560,
    0xC7AC,0xD68C,0xC758,0xB9C9,0xC9C0,0xBD84,0xD33D,0xC9D1,
    0xBCBD,0xB825,0xB824,0xB77C,0xD574,0xAE08,0xAC1C,0xAC01,
    # 0x3C80 #
    0xC9C4,0xACF5,0xC815,0xAD6C,0xAD6C,0xACC4,0xB839,0xB3D9,
    0xC18C,0xAC01,0xC608,0xCC29,0xB155,0xC9C0,0xB8E8,0xD45C,
    0xAE08,0xC218,0xD3EC,0xC218,0xC120,0xB8B0,0xC18C,0xBD80,
    0xAD6C,0xC218,0xC0AC,0xC9C0,0xB2F4,0xC6A9,0xC194,0xC601,
    0xB9AC,0xB0B4,0xBCC0,0xC218,0xC1E0,0xB2F9,0xD55C,0xC18C,
    0xC6A9,0xD0D1,0xB4F1,0xBCF5,0xCD08,0xB2F4,0xD0D1,0xB78C,
    0xB155,0xB835,0xCCA9,0xC9C8,0xC911,0xC18C,0xB85D,0xB2F4,
    0xD761,0xAE30,0xC9C8,0xB2C9,0xC608,0xC778,0xC6B0,0xC655,
    0xACFC,0xCE21,0xC5F0,0xC26C,0xC5F0,0xB958,0xD1B5,0xBB34,
    0xD328,0xC6D4,0xC720,0xAD6C,0xC555,0xD3EC,0xBCC0,0xC2DC,
    0xCC30,0xC77C,0xBC95,0xC6B0,0xB300,0xB780,0xC758,0xCC44,
    0xCDA9,0xC5F0,0xD73C,0xC720,0xD734,0xC655,0xCDA9,0xACF5,
    0xB2EC,0xACFC,0xAD50,0xB85C,0xC219,0xB871,0xACC4,0xCCA9,
    0xCC30,0xB2F4,0xBE44,0xB2F5,0xC120,0xC5F0,0xB1E8,0xC2E0,
    0xAD6C,0xC591,0xD0DC,0xADF9,0xBC00,0xACC4,0xC720,0xD640,
    0xD654,0xC655,0xC720,0xCC45,0xD544,0xBBF8,0xAC15,0xC124,
    # 0x3D00 #
    0xBC94,0xC5ED,0xB2F4,0xB8E8,0xC575,0xC18C,0xCE68,0xC12D,
    0xC740,0xC81C,0xC5F0,0xC219,0xACE0,0xC2B9,0xB0B4,0xC655,
    0xBA74,0xC18C,0xC5ED,0xC0AC,0xC74D,0xC9D1,0xBC15,0xC720,
    0xBAA8,0xC0BD,0xC218,0xCE58,0xD3B8,0xB824,0xB3C4,0xD6C4,
    0xD568,0xD5A5,0xC911,0xC774,0xC8FC,0xCD08,0xAD81,0xC2DD,
    0xC9D0,0xC639,0xC5BC,0xAD70,0xC0AC,0xC694,0xC124,0xC9C0,
    0xB2A5,0xC2EC,0xC0AC,0xBABD,0xCE68,0xBC00,0xAC01,0xD0D0,
    0xC12C,0xBBF8,0xB798,0xC8FC,0xC219,0xC124,0xBC1C,0xC815,
    0xC871,0xD669,0xC11C,0xC0AC,0xD55C,0xD0D0,0xD638,0xCCA8,
    0xD65C,0xB9BC,0xB151,0xB9E4,0xC21C,0xBB38,0xAC04,0xCD5C,
    0xAD90,0xD558,0xBE44,0xC2DD,0xC0AC,0xC0BC,0xB140,0xBE59,
    0xB9CC,0xCCAD,0xBD80,0xC120,0xB0A8,0xC608,0xC218,0xBBF8,
    0xAD74,0xBC15,0xB8B0,0xAC08,0xC0BD,0xBC00,0xC218,0xAC08,
    0xBCBD,0xC608,0xC120,0xC74D,0xC601,0xC800,0xC21C,0xBD95,
    0xC11C,0xD45C,0xBB34,0xB8CC,0xC7A5,0xCD94,0xCD2C,0xBCC0,
    0xC57D,0xB9E5,0xBE44,0xD734,0xC0AC,0xB8B0,0xC815,0xD6A8,
    # 0x3D80 #
    0xAD50,0xAD35,0xD669,0xBB34,0xC5FC,0xD559,0xC800,0xD6A1,
    0xC601,0xACC4,0xD76C,0xC720,0xB828,0xC120,0xD658,0xC740,
    0xC751,0xB834,0xC2EC,0xC7A5,0xBC30,0xAC04,0xC219,0xBC18,
    0xC810,0xC720,0xD328,0xC5EC,0xC5F0,0xC751,0xB0AD,0xB8E8,
    0xC5ED,0xD654,0xAD6C,0xC810,0xCD08,0xAC04,0xC2E0,0xB208,
    0xBC30,0xCE68,0xBC30,0xB8CC,0xB9D0,0xC720,0xC18C,0xB958,
    0xD568,0xBCF8,0xC6A9,0xC2E0,0xCE58,0xC784,0xB18D,0xC21C,
    0xD611,0xD64D,0xCCA8,0xBD09,0xC560,0xACFC,0xD45C,0xBC1C,
    0xACBD,0xD1B5,0xC11C,0xCD94,0xD68C,0xCD08,0xBD80,0xD68C,
    0xC555,0xC704,0xBD84,0xC5FC,0xBD80,0xB95C,0xC54C,0xC639,
    0xD6FC,0xC5F0,0xC6B0,0xCD1D,0xC5FC,0xCD94,0xC870,0xD76C,
    0xB300,0xC804,0xC815,0xBCF4,0xD601,0xB3CC,0xD6C4,0xD1F4,
    0xB9B0,0xACBD,0xCC28,0xC131,0xD639,0xC99D,0xD601,0xC6D0,
    0xBD09,0xD76C,0xC900,0xACBD,0xB9C9,0xBD09,0xC870,0xBD09,
    0xB9AC,0xC6C5,0xB3D9,0xC548,0xB825,0xBB35,0xBCBD,0xC790,
    0xC5FD,0xB3C4,0xC5FC,0xBB34,0xC5F0,0xC120,0xAC39,0xD5D8,
    # 0x3E00 #
    0xB300,0xD55C,0xC218,0xC810,0xC81C,0xC808,0xACE0,0xCC2C,
    0xCD08,0xC12D,0xB784,0xBC88,0xACFD,0xD76C,0xC12D,0xBBF8,
    0xC5F0,0xCC2C,0xC74C,0xB3C4,0xAC04,0xD655,0xC800,0xB3D9,
    0xB9CC,0xCC28,0xB9AC,0xC18C,0xACF5,0xD5D8,0xC808,0xC9C0,
    0xC870,0xC218,0xBE44,0xC5C5,0xD3B8,0xCC38,0xD638,0xAC04,
    0xAD6C,0xC548,0xC21C,0xAC74,0xD328,0xD30C,0xBD84,0xACFC,
    0xD0C0,0xD0C0,0xC791,0xB839,0xC18C,0xADC0,0xC5F0,0xC138,
    0xD6C4,0xB82C,0xC0AC,0xC0AC,0xBD09,0xD328,0xC778,0xB3C5,
    0xC790,0xB7C9,0xACAC,0xBE44,0xC9C1,0xCD1D,0xD718,0xAC78,
    0xB9AC,0xC6D0,0xC545,0xC218,0xC0B0,0xC801,0xB8E8,0xADFC,
    0xC1A1,0xC0AC,0xBC15,0xC694,0xAC15,0xD658,0xD658,0xB3C4,
    0xC720,0xC575,0xC575,0xC694,0xC740,0xC2DC,0xC740,0xACB0,
    0xB3C8,0xD604,0xAC00,0xC885,0xAC81,0xC8FC,0xCD08,0xC559,
    0xC720,0xACBD,0xC0B0,0xC774,0xC0AC,0xC608,0xB9E5,0xD734,
    0xAD11,0xC791,0xD6A8,0xC624,0xAC31,0xACBD,0xC815,0xD76C,
    0xBAA8,0xACBD,0xD0D1,0xC640,0xAD6D,0xCC2C,0xD45C,0xD0C1,
    # 0x3E80 #
    0xD640,0xB178,0xAC10,0xAD6C,0xC720,0xD6C4,0xC790,0xC2DC,
    0xCE58,0xD639,0xC591,0xC639,0xD610,0xBE48,0xC6A9,0xB8E8,
    0xC870,0xC0BC,0xAD50,0xC801,0xD718,0xBC88,0xD568,0xCC2C,
    0xC7A0,0xC2E4,0xB2EC,0xC8FC,0xB178,0xD568,0xC5EC,0xD0C1,
    0xC720,0xB825,0xD655,0xD76C,0xC12C,0xCC38,0xB828,0xD6A8,
    0xC0AC,0xC2AC,0xBC15,0xAD6C,0xACF5,0xC790,0xC6B0,0xB871,
    0xC0AC,0xC789,0xB274,0xB9E4,0xBC1C,0xAD6C,0xB450,0xC220,
    0xD3C9,0xBCC0,0xBAA8,0xBD88,0xC120,0xBE44,0xD615,0xC774,
    0xC720,0xAD34,0xBCD1,0xACE1,0xBCF4,0xD68C,0xC5F0,0xC804,
    0xD6C4,0xBCF4,0xBB38,0xB784,0xB3C4,0xC624,0xC2AC,0xB839,
    0xC900,0xACC4,0xC6B4,0xCD94,0xCE74,0xAD74,0xB300,0xBC30,
    0xBCC0,0xC721,0xBD95,0xC5ED,0xC885,0xB784,0xBE48,0xC218,
    0xB3CC,0xC124,0xC2DC,0xC2EC,0xAD6C,0xC720,0xC6B0,0xD0C0,
    0xC644,0xACB8,0xC900,0xD544,0xB3C4,0xC2AC,0xCC2C,0xB3C4,
    0xC704,0xBD09,0xB8E8,0xB9AC,0xB9CC,0xC794,0xD544,0xADF9,
    0xC7A0,0xD604,0xB825,0xB3C8,0xB2F4,0xC218,0xC639,0xCD09,
    # 0x3F00 #
    0xB2EC,0xC758,0xC5EC,0xB835,0xAE30,0xAD11,0xD615,0xACBD,
    0xB77C,0xC9D0,0xB454,0xACE0,0xC720,0xB8B0,0xBC15,0xB1CC,
    0xD3B8,0xB828,0xD0D5,0xB834,0xC628,0xB2F9,0xB9AC,0xC815,
    0xC640,0xCD94,0xAC15,0xD615,0xC559,0xC644,0xD33D,0xBC31,
    0xD0C0,0xC218,0xC774,0xBC31,0xACB0,0xACE0,0xACF5,0xB3D9,
    0xD568,0xC131,0xD611,0xACFC,0xD589,0xC810,0xCC28,0xB3D9,
    0xBE44,0xC900,0xB835,0xC131,0xC6B0,0xC81C,0xC720,0xC804,
    0xC6A9,0xAC15,0xB2F9,0xC7A5,0xD45C,0xCC3D,0xB85D,0xB3D9,
    0xC815,0xB825,0xC0BD,0xBC18,0xC0AC,0xB4F1,0xB2F9,0xD639,
    0xC758,0xD568,0xC12D,0xB77C,0xB958,0xAC10,0xB2F4,0xD761,
    0xD610,0xB2F4,0xC0DD,0xC0DD,0xC720,0xC720,0xB0A8,0xBB34,
    0xAC15,0xC724,0xCC99,0xAD6C,0xC6D0,0xB840,0xB958,0xB82C,
    0xD611,0xBE44,0xC554,0xC5ED,0xAD6D,0xC720,0xC21C,0xC9C0,
    0xCC28,0xCC38,0xC99D,0xC639,0xBD80,0xC5F0,0xC131,0xD734,
    0xC11C,0xAD50,0xAD50,0xD6C4,0xC7A5,0xC7A5,0xAE30,0xC218,
    0xC2EC,0xBC18,0xAE09,0xC9C0,0xC778,0xACE0,0xC62C,0xACFC,
    # 0x3F80 #
    0xAC81,0xC220,0xD574,0xD0C0,0xB3C5,0xC790,0xCCA8,0xBAA9,
    0xBD80,0xB839,0xC0C9,0xB958,0xC120,0xB0B4,0xC555,0xC560,
    0xB824,0xB2F5,0xC5EC,0xC5F0,0xB824,0xC2E0,0xB9AC,0xB7C9,
    0xACBD,0xD754,0xC0AC,0xCE68,0xD611,0xCC28,0xC720,0xBCF4,
    0xAD11,0xAC01,0xB798,0xAE08,0xAC15,0xCD95,0xBC30,0xACFC,
    0xC758,0xAD34,0xC131,0xD3B8,0xD574,0xCD94,0xD669,0xD68C,
    0xD638,0xD3D0,0xC624,0xC790,0xC0AC,0xACC4,0xACE8,0xC11C,
    0xACE0,0xC0AC,0xB9C8,0xC800,0xD1F4,0xCD94,0xD610,0xB791,
    0xBC18,0xACE0,0xCE58,0xCCB4,0xC560,0xC120,0xACFC,0xC2B5,
    0xC639,0xD1F4,0xCC38,0xC18C,0xD5D8,0xAC1C,0xBD84,0xAD70,
    0xCE58,0xC57D,0xC8FC,0xD611,0xB8B0,0xC5FC,0xB85C,0xD1F4,
    0xC601,0xBE44,0xB77C,0xB824,0xBCC4,0xD5A5,0xBAA8,0xBC31,
    0xAD11,0xB450,0xC694,0xD560,0xCD98,0xD559,0xB155,0xC8FC,
    0xB825,0xB2F9,0xD658,0xBE44,0xD30C,0xCC45,0xC559,0xB2F5,
    0xC624,0xC124,0xC758,0xCE58,0xB2F5,0xC5F0,0xBC29,0xCD94,
    0xB9CC,0xB2EC,0xBC15,0xAC04,0xC5F0,0xD61C,0xC800,0xC544,
    # 0x4000 #
    0xBC94,0xC720,0xC548,0xD1F4,0xBABD,0xC0AC,0xC9C4,0xACE0,
    0xAE30,0xAD50,0xAD50,0xC5FC,0xC9C4,0xAC10,0xBA74,0xD604,
    0xC0BC,0xC54C,0xCC9C,0xD658,0xC778,0xC778,0xCC9C,0xACB0,
    0xACC4,0xCCB4,0xC559,0xB9E4,0xB9E4,0xBE44,0xB3C4,0xBE44,
    0xAD6C,0xC810,0xC21C,0xBE44,0xBB34,0xC0AD,0xACE0,0xD64D,
    0xD65C,0xB77D,0xD56D,0xACB9,0xC804,0xD574,0xD669,0xBCF4,
    0xACE1,0xBD09,0xBAA9,0xB784,0xC601,0xC21C,0xB7C9,0xAC81,
    0xC81C,0xC12C,0xCD94,0xBE59,0xC9C4,0xC5F0,0xB3C4,0xCE58,
    0xC808,0xB7C9,0xD55C,0xD45C,0xD589,0xB9F9,0xC5C5,0xBC00,
    0xACC4,0xACC4,0xC54C,0xD611,0xC6B8,0xACB9,0xC815,0xC694,
    0xC601,0xC591,0xC9D1,0xC885,0xD6E4,0xBBFC,0xB8E8,0xAC1C,
    0xC694,0xC5B8,0xC190,0xADC0,0xD669,0xC575,0xC131,0xCC28,
    0xB834,0xC12C,0xC120,0xC120,0xC801,0xB2D0,0xCC98,0xBB18,
    0xD655,0xC5B4,0xCC38,0xD640,0xCE35,0xD45C,0xC7A0,0xD761,
    0xD56D,0xC6B0,0xB9E4,0xB9DD,0xC804,0xD658,0xACA9,0xAC01,
    0xB0AD,0xBE44,0xC11D,0xC0AD,0xBB35,0xB835,0xBA78,0xBB35,
    # 0x4080 #
    0xD76C,0xCC38,0xAD6C,0xCD08,0xD655,0xD55C,0xACA9,0xB274,
    0xB3D9,0xD6C4,0xC5EC,0xC720,0xCDA9,0xBC15,0xCC2C,0xC870,
    0xC878,0xC81C,0xAC08,0xADDC,0xD589,0xD6FC,0xC11D,0xAD74,
    0xCC28,0xC11D,0xD6A8,0xC5EC,0xBC29,0xD0C0,0xC11D,0xAC00,
    0xC2DC,0xC9C0,0xB3D9,0xC790,0xBD80,0xBBFC,0xC9C4,0xC9C4,
    0xCC28,0xC5F0,0xAD50,0xD64D,0xACF5,0xAD50,0xB7B5,0xAD34,
    0xB78D,0xC608,0xAC81,0xC88C,0xC5F0,0xACF5,0xAC81,0xAD34,
    0xAD35,0xC0C9,0xC640,0xC815,0xB148,0xB3C4,0xB798,0xB2F5,
    0xCC44,0xC544,0xACE4,0xAC15,0xACBD,0xC81C,0xAE30,0xBA74,
    0xAC1C,0xBBFC,0xC800,0xC720,0xC778,0xB300,0xCC28,0xC131,
    0xB3CC,0xBC18,0xD575,0xAD6C,0xD64D,0xB85C,0xC624,0xBC15,
    0xAC31,0xB85D,0xCD09,0xB828,0xC608,0xAD50,0xC219,0xC0B0,
    0xC120,0xC7A0,0xAE08,0xD6FC,0xC219,0xB2F9,0xB3C8,0xB96D,
    0xAC15,0xB1E8,0xB2E8,0xB2F4,0xC678,0xAC10,0xB2EC,0xB825,
    0xCC30,0xC12C,0xBC18,0xB78D,0xC800,0xB1E8,0xAD34,0xC601,
    0xC12C,0xB780,0xB9C8,0xD30C,0xBCF5,0xADA4,0xBE44,0xBD80,
    # 0x4100 #
    0xD654,0xC608,0xB958,0xC559,0xC778,0xAD8C,0xD65C,0xC815,
    0xB450,0xC544,0xC9C0,0xC5C4,0xCCA0,0xC790,0xAE30,0xC694,
    0xAD8C,0xD65C,0xC784,0xD669,0xAD6C,0xC0AC,0xC218,0xC5F0,
    0xD33D,0xBA85,0xC870,0xB8E8,0xB9AC,0xCC3D,0xC81C,0xCCB4,
    0xC120,0xCCA8,0xC81C,0xB3C5,0xB8B0,0xB839,0xB8CC,0xC789,
    0xC6B0,0xC775,0xCD08,0xAE30,0xC774,0xB144,0xBD80,0xACAC,
    0xC544,0xBC29,0xB15C,0xC120,0xC6D4,0xB144,0xD544,0xC11D,
    0xBC15,0xCC9C,0xC81C,0xB3C4,0xCCA8,0xC120,0xC6A9,0xC608,
    0xB82C,0xC548,0xD559,0xACF5,0xB840,0xADDC,0xCE58,0xC18D,
    0xC6D0,0xC544,0xC885,0xB9CC,0xACAC,0xC815,0xC720,0xBBF8,
    0xACAC,0xC720,0xB9DD,0xAD6C,0xCE58,0xAC70,0xC554,0xC720,
    0xB798,0xD63C,0xAD8C,0xCC3D,0xD0C0,0xACF5,0xB291,0xC0BC,
    0xC81C,0xC218,0xCD94,0xD669,0xC9D1,0xAC08,0xBB18,0xC5FC,
    0xD5A5,0xC9C0,0xADA4,0xC218,0xC560,0xBC29,0xCC3D,0xB2F9,
    0xC740,0xC628,0xAE30,0xCD94,0xC0AD,0xC791,0xB204,0xB3C4,
    0xC2E0,0xB8E8,0xD45C,0xB9AC,0xB9CC,0xD615,0xC7A0,0xD654,
    # 0x4180 #
    0xB9E4,0xACE0,0xB834,0xB3C4,0xC120,0xC790,0xC870,0xBD09,
    0xCE58,0xD30C,0xBBF8,0xCD94,0xC608,0xB871,0xC12C,0xBE44,
    0xAD6D,0xC815,0xAD6C,0xC5F0,0xCDA9,0xC5F4,0xAD49,0xC694,
    0xC555,0xC694,0xB3D9,0xD0C0,0xC720,0xD608,0xC694,0xD569,
    0xD658,0xB791,0xC5F4,0xC2E0,0xCC9C,0xCC9C,0xB2F4,0xC640,
    0xB155,0xBA85,0xD64D,0xCC3D,0xC6B4,0xD5CC,0xCE68,0xCD2C,
    0xC6B0,0xB2F4,0xAC15,0xC218,0xC870,0xC815,0xCD94,0xD608,
    0xC815,0xCD1D,0xBC18,0xADDC,0xACFC,0xAC70,0xB78C,0xC608,
    0xC6A9,0xC0AC,0xAC74,0xC0AC,0xD758,0xBC8C,0xB450,0xB9F9,
    0xC131,0xB9BD,0xAD11,0xD574,0xCD08,0xCD09,0xC791,0xD1F4,
    0xB9AC,0xBE44,0xAC1C,0xC218,0xB77C,0xC218,0xC6B4,0xC885,
    0xD638,0xC778,0xBCF5,0xC9C0,0xAC80,0xCCA8,0xAC10,0xAC74,
    0xC8FC,0xC800,0xACE0,0xB151,0xC608,0xCC29,0xC559,0xCCB4,
    0xACF5,0xC608,0xCE58,0xAE30,0xCD94,0xB85C,0xC784,0xC6A9,
    0xC99D,0xB78D,0xD611,0xC804,0xC11C,0xC740,0xAC01,0xBCC4,
    0xC815,0xADE0,0xB450,0xBBF8,0xC74D,0xC81C,0xC5B8,0xCC45,
    # 0x4200 #
    0xC0B0,0xB95C,0xBCD1,0xC18C,0xD568,0xD655,0xB300,0xC870,
    0xBE44,0xC0BD,0xB989,0xB2F5,0xC800,0xB9F9,0xC5FD,0xBCF5,
    0xAD34,0xACFC,0xB0A8,0xAC08,0xAC00,0xC2DC,0xACFC,0xC1C4,
    0xC790,0xC8FC,0xD0DC,0xAD34,0xCE68,0xC11C,0xB3C5,0xCE21,
    0xC6D0,0xCD1D,0xC0C8,0xC815,0xACB8,0xADFC,0xC885,0xC704,
    0xD55C,0xAC80,0xACA9,0xB0A9,0xD3EC,0xC218,0xAD6C,0xC9C4,
    0xC18C,0xB3C4,0xBC18,0xD0D1,0xACB8,0xC639,0xC6A9,0xB77D,
    0xACE1,0xC218,0xC885,0xD3EC,0xBA78,0xADFC,0xCD08,0xBA71,
    0xC11C,0xB839,0xB8E8,0xC7A5,0xB989,0xC9D1,0xC870,0xC2EC,
    0xC0B0,0xACE0,0xBC18,0xBBF8,0xC218,0xAC04,0xB2F9,0xD574,
    0xACE0,0xBB34,0xBC88,0xB77C,0xCC2C,0xC99D,0xB839,0xC74D,
    0xC0C1,0xC6B4,0xB9F9,0xC6B1,0xCE58,0xC758,0xB2F4,0xD655,
    0xBBF8,0xB2E8,0xC0C9,0xC0AC,0xC218,0xCD1D,0xCC9C,0xB958,
    0xC758,0xAD6C,0xB8B0,0xB824,0xD3D0,0xB835,0xB9B0,0xD55C,
    0xD6A8,0xC6B0,0xBBF8,0xC120,0xC591,0xCC2C,0xC30D,0xC5C4,
    0xBCC0,0xB839,0xD64D,0xAE30,0xB8CC,0xBC18,0xBE44,0xD638,
    # 0x4280 #
    0xD638,0xC2E0,0xC0C9,0xD328,0xACF5,0xBA85,0xAD6C,0xD3EC,
    0xB9E4,0xC0BC,0xBBF8,0xC7A5,0xBE44,0xB9AC,0xAD8C,0xC0BC,
    0xD63C,0xD5A5,0xC815,0xC2DC,0xC601,0xAC74,0xB0A8,0xD669,
    0xC8FC,0xC5F0,0xD1F4,0xC0B4,0xB2E8,0xC2E4,0xC801,0xBB38,
    0xD76C,0xB9CC,0xC7A5,0xD669,0xB2F4,0xC18C,0xC5F4,0xBE44,
    0xB77C,0xBC18,0xB824,0xCD5C,0xCC28,0xB3C4,0xC801,0xAD11,
    0xC800,0xC12C,0xC0B0,0xBBF8,0xACB8,0xAD6C,0xC9C4,0xCE58,
    0xC6B0,0xC12C,0xD638,0xAC10,0xCE58,0xACB0,0xBAA9,0xBD80,
    0xD638,0xACBD,0xD6A8,0xBAA8,0xB9DD,0xC6B0,0xD638,0xCC99,
    0xB140,0xD608,0xC815,0xBBFC,0xACAC,0xC544,0xD0C4,0xC791,
    0xC6D4,0xBCD1,0xC11C,0xCD94,0xBC30,0xC784,0xC728,0xACAC,
    0xCD94,0xC774,0xC775,0xBBF8,0xACC4,0xC601,0xB9DD,0xAE30,
    0xBCF4,0xC11C,0xBCC4,0xBC88,0xC57D,0xB9AC,0xBC88,0xAD6C,
    0xBD80,0xC544,0xC544,0xC7C1,0xCCA8,0xC721,0xAE08,0xACC4,
    0xAD6D,0xB798,0xC2B9,0xBC30,0xB274,0xC608,0xC218,0xBB34,
    0xC21C,0xD3ED,0xCD94,0xB2D8,0xC815,0xBD09,0xC790,0xC678,
    # 0x4300 #
    0xACFC,0xC694,0xC6B0,0xCD08,0xACBD,0xB2F9,0xADC0,0xC0AD,
    0xD0D1,0xAC15,0xC694,0xB2F5,0xCCA9,0xADFC,0xB7B5,0xBC00,
    0xBA71,0xACAC,0xB85D,0xBC88,0xC6B0,0xBBF8,0xC9D1,0xBB34,
    0xBCC4,0xD669,0xC18D,0xC694,0xC5C5,0xAE08,0xB834,0xBCBD,
    0xAC10,0xCCB4,0xB839,0xCC2C,0xC2DC,0xC740,0xB3C4,0xC8FC,
    0xCC44,0xBA78,0xC5FC,0xB78C,0xC911,0xCD08,0xC0C1,0xAD8C,
    0xB151,0xB77C,0xD6C8,0xC2DC,0xB77C,0xCD09,0xCE58,0xC8FC,
    0xACAC,0xACBD,0xC774,0xC775,0xD0DC,0xCC44,0xB2D8,0xD3ED,
    0xB78C,0xC218,0xC6B0,0xC694,0xC810,0xB839,0xC800,0xB2F5,
    0xBCD1,0xC7AC,0xAD50,0xC218,0xBD80,0xBD80,0xCC9C,0xB9DD,
    0xD55C,0xD55C,0xBD80,0xC544,0xD6A1,0xC800,0xD3EC,0xD604,
    0xBBF8,0xB9E4,0xB791,0xACE0,0xC870,0xB2F5,0xC5ED,0xC885,
    0xB9AC,0xB85D,0xBB34,0xB8B0,0xC81C,0xB825,0xB9AC,0xC7A5,
    0xBC1C,0xC591,0xB9D0,0xD0C0,0xD3C9,0xC7A5,0xC870,0xADA4,
    0xC778,0xC11C,0xC608,0xACB0,0xC704,0xC7C1,0xB3D9,0xC704,
    0xBC15,0xC804,0xD658,0xC120,0xC7A0,0xB825,0xC5F0,0xD669,
    # 0x4380 #
    0xD6E8,0xD638,0xD3EC,0xC5FC,0xCD08,0xBC15,0xB8CC,0xC8FC,
    0xC608,0xD73C,0xB77D,0xACE0,0xCD09,0xBD80,0xB151,0xD568,
    0xCD08,0xB85D,0xC794,0xB2F5,0xBD80,0xD6A1,0xC99D,0xAD50,
    0xC219,0xBE48,0xD61C,0xAE30,0xD63C,0xC800,0xC791,0xC774,
    0xC774,0xB09C,0xAC78,0xC0AC,0xAD6D,0xACE1,0xC5FC,0xBD80,
    0xC5C5,0xCE58,0xB291,0xCC3D,0xD30C,0xC870,0xCCB4,0xD55C,
    0xC791,0xD30C,0xC744,0xC6D4,0xAC31,0xBE44,0xC774,0xC8FC,
    0xC624,0xBB38,0xC81C,0xC8FC,0xB85D,0xBB38,0xACE4,0xCD94,
    0xB784,0xC7AC,0xC218,0xBA85,0xC9C8,0xCCB4,0xC870,0xD45C,
    0xB828,0xC2B5,0xB871,0xC219,0xD758,0xC6D0,0xD48D,0xD6C4,
    0xACB0,0xC790,0xD3B8,0xAD00,0xB274,0xC784,0xC778,0xAC1C,
    0xD544,0xD0D0,0xBB18,0xC21C,0xAE09,0xC804,0xB9D0,0xBCC4,
    0xAE09,0xC2DC,0xD53C,0xC800,0xC0AC,0xD0D0,0xCCA8,0xCE58,
    0xD1F4,0xD611,0xC774,0xD734,0xBB34,0xC8FC,0xD611,0xC9C0,
    0xC778,0xAD6D,0xC81C,0xC808,0xC18C,0xBABD,0xD53C,0xD55C,
    0xC5B4,0xD604,0xBC29,0xB2A5,0xC794,0xBD80,0xBC29,0xACC4,
    # 0x4400 #
    0xAE30,0xB3C5,0xB85D,0xADE0,0xD568,0xD76C,0xCC44,0xC21C,
    0xC9C1,0xCE58,0xD63C,0xCD1D,0xC804,0xCD94,0xC81C,0xC900,
    0xCD94,0xC811,0xCC28,0xC720,0xBCC0,0xC9D1,0xD788,0xC800,
    0xAC01,0xACA9,0xC989,0xB2F5,0xC9C4,0xC1A8,0xC57D,0xAD6C,
    0xD669,0xC81C,0xCD94,0xC190,0xCC28,0xC639,0xAC11,0xD638,
    0xACE1,0xAC1C,0xC804,0xC885,0xC870,0xCCB4,0xC0B0,0xB8B0,
    0xC218,0xCC44,0xC811,0xC5B4,0xAC1C,0xD669,0xC7A0,0xB2E8,
    0xD68D,0xC218,0xB2F4,0xACE0,0xD608,0xB9CC,0xD0C1,0xC624,
    0xBCBD,0xC625,0xC5EC,0xBABD,0xBE44,0xBABD,0xC591,0xC9C8,
    0xBC15,0xC601,0xC720,0xC591,0xB780,0xC601,0xCC38,0xAD8C,
    0xC9C4,0xBCF5,0xC778,0xB300,0xBC8C,0xC11C,0xCCA9,0xD0D5,
    0xCC28,0xB2F4,0xCCA8,0xC9C0,0xD0D1,0xAC00,0xC21C,0xD669,
    0xB8CC,0xCC28,0xC62C,0xCE68,0xAE08,0xC555,0xAD6C,0xBD80,
    0xD0C0,0xACE0,0xC555,0xD33D,0xB3C4,0xC81C,0xD0C0,0xC81C,
    0xBCF4,0xC6D0,0xB3C4,0xB95C,0xAE30,0xBAA9,0xCC9C,0xACAC,
    0xC885,0xC18C,0xBC94,0xC720,0xCD94,0xD0D1,0xCC99,0xC219,
    # 0x4480 #
    0xBD80,0xC2B5,0xC7A5,0xC870,0xBD80,0xB4F1,0xCCA0,0xBD80,
    0xBE44,0xBB34,0xD61C,0xC559,0xBA85,0xBC29,0xB9DD,0xC2B9,
    0xBABD,0xCD08,0xC870,0xAC1C,0xBC30,0xC18C,0xC2E0,0xAC78,
    0xC218,0xC0C1,0xC18C,0xD658,0xC6B0,0xD6A8,0xCE68,0xB2E8,
    0xBD09,0xC778,0xC559,0xC5FC,0xC77C,0xB9CC,0xBC94,0xAC70,
    0xC2DC,0xD654,0xBCC0,0xB300,0xB9C9,0xB4F1,0xBC94,0xD658,
    0xAD11,0xC99D,0xCC28,0xD0C0,0xC720,0xD638,0xCC9C,0xAD04,
    0xD608,0xB8B0,0xADFC,0xAE30,0xACE1,0xB9DD,0xC758,0xB8CC,
    0xAE38,0xB4F1,0xC5B8,0xC74D,0xC740,0xAE30,0xC808,0xD601,
    0xC5ED,0xC57C,0xC624,0xC9C0,0xC9C0,0xD55C,0xCC29,0xBD80,
    0xC21C,0xD3C9,0xAD34,0xC8FC,0xD6A8,0xC6D0,0xAD81,0xCD1D,
    0xACE0,0xAD34,0xC11C,0xAD74,0xC9C0,0xB9F9,0xB824,0xC8FC,
    0xB2F5,0xC9C0,0xACE0,0xB7C9,0xD640,0xB784,0xC804,0xADF9,
    0xBD80,0xC9C0,0xC5ED,0xAE30,0xD0C1,0xCC30,0xBB34,0xB3C5,
    0xC778,0xC2DC,0xC608,0xD55C,0xC5F0,0xBD80,0xB784,0xD589,
    0xAC04,0xC758,0xBBF8,0xAD6C,0xB9DD,0xAE30,0xC0AC,0xD568,
    # 0x4500 #
    0xC720,0xB960,0xC790,0xC870,0xC694,0xAC00,0xB9AC,0xAE30,
    0xACF5,0xB825,0xBCD1,0xC0AC,0xACE0,0xB9C8,0xC18D,0xCD94,
    0xC804,0xC0AC,0xBC30,0xD5C8,0xACBD,0xD3EC,0xB989,0xC0C1,
    0xC870,0xC870,0xC21C,0xACBD,0xB2F4,0xC790,0xB960,0xC774,
    0xC18C,0xC5B4,0xD654,0xB824,0xD30C,0xC18C,0xB9E4,0xB824,
    0xC639,0xC18D,0xC0C1,0xC18C,0xC774,0xB155,0xC0AC,0xACE0,
    0xBD80,0xC74D,0xB4F1,0xC5F0,0xCD5C,0xAC04,0xC81C,0xAE08,
    0xD45C,0xC218,0xC218,0xB3C8,0xC0BD,0xC560,0xC54C,0xC900,
    0xAD00,0xBE44,0xC6D0,0xC74C,0xC99D,0xC18C,0xB450,0xD68C,
    0xCCA9,0xD0DD,0xB2E8,0xB2F9,0xCE58,0xC608,0xBCF5,0xC560,
    0xBCF5,0xC218,0xAC00,0xCC30,0xD568,0xB9CC,0xC190,0xBE44,
    0xB839,0xC808,0xADA4,0xD611,0xCDE8,0xCE6D,0xB791,0xD765,
    0xD3D0,0xB824,0xC790,0xD560,0xAE30,0xB2C8,0xC601,0xD6A8,
    0xB4F1,0xB8CC,0xD0DD,0xAE30,0xAC15,0xC12C,0xAD6D,0xD45C,
    0xBC88,0xB450,0xB984,0xBBF8,0xCC29,0xD608,0xD638,0xBBF8,
    0xD560,0xC7A1,0xCD1D,0xB824,0xC5F0,0xCD09,0xC5C4,0xD55C,
    # 0x4580 #
    0xD6A8,0xC5B5,0xB780,0xC57D,0xC5F0,0xB839,0xC591,0xC6B8,
    0xD559,0xD6C4,0xC608,0xD559,0xC5ED,0xAC74,0xD569,0xCC98,
    0xC740,0xBA71,0xD76C,0xB0A0,0xD568,0xCC28,0xD569,0xC554,
    0xB3C4,0xC81C,0xC624,0xC0AD,0xC740,0xCDA9,0xC8FC,0xB9F9,
    0xC6D0,0xB275,0xBB18,0xC870,0xC6D0,0xBAA8,0xAD74,0xB0A0,
    0xC11D,0xD544,0xC790,0xBC29,0xAC11,0xAD8C,0xD5A5,0xADDC,
    0xD328,0xAD11,0xC21C,0xCC28,0xC694,0xACE4,0xD68C,0xD76C,
    0xC544,0xC591,0xC870,0xB958,0xAC01,0xB9AC,0xC644,0xB9AC,
    0xC99D,0xAE30,0xD638,0xC794,0xBD80,0xC7A5,0xAD00,0xAD6D,
    0xB9F9,0xCC3D,0xB2F4,0xBAA8,0xC131,0xB824,0xC5F0,0xC218,
    0xC2DC,0xC2B5,0xBCD1,0xCD1D,0xD6C4,0xC6D0,0xCCB4,0xACAC,
    0xAC11,0xD55C,0xBC15,0xC218,0xB958,0xC7A0,0xC7A0,0xC608,
    0xC120,0xC5B8,0xC870,0xAC10,0xC6A9,0xC885,0xBD09,0xAC15,
    0xC5B4,0xCC99,0xC790,0xB9C8,0xBD09,0xD658,0xC0C1,0xC9C4,
    0xAD00,0xBCF5,0xB9B0,0xB4F1,0xC815,0xAC15,0xB78D,0xC5B5,
    0xC639,0xC790,0xC5F0,0xC808,0xD6C8,0xC720,0xD604,0xB155,
    # 0x4600 #
    0xBD80,0xC808,0xC810,0xBB35,0xC800,0xB2A5,0xD5CC,0xBB38,
    0xB824,0xC7A0,0xBA78,0xC810,0xB2D0,0xCC44,0xB9CC,0xD73C,
    0xB275,0xB9E5,0xCD5C,0xAC10,0xAC1D,0xD56D,0xD568,0xD718,
    0xC18C,0xC704,0xC878,0xAE30,0xAC74,0xC775,0xB9C8,0xC870,
    0xBC1C,0xBE44,0xC800,0xC790,0xCD9C,0xAC11,0xB2C8,0xC559,
    0xAD50,0xC21C,0xCDA9,0xB140,0xC735,0xC9C0,0xC0C1,0xCD08,
    0xC120,0xC720,0xCE68,0xAE08,0xC885,0xB85D,0xD568,0xBCC4,
    0xC561,0xC26C,0xD0C4,0xC721,0xC6D0,0xC608,0xAD00,0xAD74,
    0xD33D,0xC794,0xC885,0xD0C0,0xC7A1,0xC694,0xACC4,0xC5F0,
    0xD6C4,0xC21C,0xB300,0xC120,0xAD34,0xBE44,0xD61C,0xBC15,
    0xACA9,0xCD5C,0xCD95,0xD53C,0xAD6C,0xC885,0xBD95,0xCCB4,
    0xCD95,0xC9C0,0xB1E8,0xACE4,0xBD09,0xC124,0xB4F1,0xC704,
    0xAD90,0xADC0,0xC99D,0xC0BD,0xD0C0,0xB839,0xBABD,0xD6C8,
    0xACFC,0xBABD,0xBC18,0xAE30,0xC601,0xAC74,0xAD00,0xCD95,
    0xB9AC,0xCD09,0xC120,0xD45C,0xC120,0xADDC,0xB18D,0xB4DD,
    0xB4DD,0xC774,0xB834,0xC790,0xC18C,0xD608,0xC2DC,0xBBF8,
    # 0x4680 #
    0xCE68,0xCE68,0xD601,0xC720,0xB85D,0xB798,0xC601,0xC0DD,
    0xACAC,0xACC4,0xACAC,0xC6B4,0xACE0,0xC801,0xCC3D,0xB9B0,
    0xC801,0xB9E4,0xB2F9,0xC2EC,0xBE48,0xB9AC,0xC131,0xAC15,
    0xD615,0xD6E4,0xC120,0xACE1,0xBE44,0xC878,0xB300,0xB300,
    0xD63C,0xC0C8,0xCCA0,0xC81C,0xC6B0,0xC57D,0xCE58,0xB958,
    0xBC1C,0xAD50,0xD658,0xD601,0xB9B0,0xD6E4,0xC789,0xD604,
    0xBE44,0xC2E0,0xC0B0,0xCE58,0xC648,0xB450,0xCC9C,0xD61C,
    0xD574,0xBE44,0xC694,0xC694,0xB275,0xD638,0xC784,0xC74C,
    0xBC18,0xC5FC,0xC774,0xC644,0xC6D0,0xD569,0xC8FC,0xC5F0,
    0xC2DC,0xBA74,0xD61C,0xC790,0xD3EC,0xBE44,0xD608,0xB2C8,
    0xC0AC,0xBC00,0xBCC0,0xAC10,0xB098,0xC720,0xC608,0xAE30,
    0xC784,0xD735,0xB7B5,0xD68C,0xC2E0,0xB178,0xD55C,0xACB9,
    0xD22C,0xD654,0xB3C5,0xBE59,0xCD09,0xD76C,0xC1A1,0xBBF8,
    0xC2E0,0xC624,0xAD81,0xC7A5,0xB3C4,0xD589,0xAD6C,0xAC70,
    0xD63C,0xC81C,0xBA74,0xC5C4,0xAE30,0xC218,0xB8B0,0xC6D0,
    0xC810,0xD604,0xACC4,0xC720,0xD6FC,0xC0BD,0xC18C,0xACA9,
    # 0x4700 #
    0xB178,0xD61C,0xACE0,0xD1F4,0xC9C0,0xC720,0xB9C8,0xACE4,
    0xCD08,0xCE60,0xC870,0xD68C,0xB828,0xB8CC,0xB85C,0xD0C0,
    0xC218,0xC624,0xC624,0xC12D,0xC218,0xB9E4,0xB2F4,0xD760,
    0xACBD,0xC555,0xB2F5,0xCC38,0xC608,0xB2E8,0xC81C,0xCC38,
    0xC9C8,0xC6B1,0xD5CC,0xD754,0xACF5,0xB2E8,0xC21C,0xB178,
    0xD658,0xC5F0,0xAD6C,0xD64D,0xC218,0xC608,0xB85C,0xAD6D,
    0xD638,0xB9CC,0xB835,0xB454,0xCD94,0xC2DC,0xD56D,0xCE68,
    0xB9E4,0xC18C,0xCC45,0xC2DC,0xBAA9,0xC720,0xC74C,0xC218,
    0xB958,0xB85C,0xC218,0xC811,0xC30D,0xD68C,0xD640,0xD68C,
    0xC561,0xBABD,0xC0BD,0xC885,0xACB0,0xAD70,0xB2E8,0xB8E8,
    0xC218,0xCDA9,0xCD94,0xB835,0xD658,0xC811,0xC870,0xD734,
    0xC758,0xCD94,0xB2C8,0xD30C,0xC0B0,0xC758,0xD638,0xC124,
    0xD658,0xB9CC,0xB9CC,0xAC70,0xB8CC,0xD638,0xC911,0xBBFC,
    0xD604,0xC9C4,0xC18C,0xC791,0xC8FC,0xAD6C,0xD604,0xC774,
    0xCE58,0xD611,0xC2E0,0xC794,0xC7AC,0xD3EC,0xB7C9,0xC9C0,
    0xAE30,0xC644,0xAD00,0xAC70,0xCCAD,0xC560,0xBD80,0xADC0,
    # 0x4780 #
    0xD6C4,0xC5B8,0xC5F0,0xCE58,0xD45C,0xC774,0xC1C4,0xC9C0,
    0xADC0,0xC789,0xC608,0xCE5C,0xCCA8,0xCCAD,0xCC3D,0xC0AC,
    0xCD98,0xD64D,0xB3D9,0xC815,0xBBF8,0xC720,0xC18D,0xCC44,
    0xAE00,0xC7A1,0xAE30,0xC624,0xBD80,0xC625,0xBD88,0xBC31,
    0xCC99,0xB2E8,0xC791,0xCC28,0xAD6C,0xC720,0xACA9,0xD6C4,
    0xADDC,0xD761,0xC7A5,0xC6B4,0xD22C,0xC900,0xB3C4,0xBD80,
    0xCC45,0xD639,0xC6D4,0xBCF5,0xC870,0xCCA0,0xCC99,0xAD74,
    0xBD80,0xD669,0xCD98,0xC6A9,0xCC2C,0xC0C9,0xCE58,0xAC74,
    0xCE58,0xCD08,0xBB38,0xCC38,0xCC45,0xC7A0,0xD544,0xAE30,
    0xC9C8,0xCD09,0xAC70,0xC810,0xAE38,0xBCC0,0xCC2C,0xB825,
    0xB825,0xC57D,0xAD8C,0xC815,0xBD80,0xCC28,0xC9C0,0xC2DC,
    0xD56D,0xC808,0xAE30,0xBC1C,0xB20C,0xD22C,0xC8FC,0xCD09,
    0xC6D4,0xC9C0,0xC804,0xCD9C,0xBCC4,0xBABD,0xBC1C,0xC804,
    0xBBFC,0xAC01,0xBC94,0xC7C1,0xAD6C,0xC870,0xBCF5,0xAD04,
    0xD568,0xC801,0xCDA9,0xC6B0,0xC9C4,0xAD6C,0xC88C,0xCCB4,
    0xADDC,0xB82C,0xD328,0xB3C4,0xBB34,0xC18C,0xCCA0,0xB85D,
    # 0x4800 #
    0xCC3D,0xC81C,0xCD08,0xB7C9,0xC804,0xACE4,0xC7A5,0xAD74,
    0xB3CC,0xD658,0xBE44,0xBE44,0xB2F5,0xD558,0xC545,0xACC4,
    0xACA9,0xADDC,0xD638,0xCD94,0xC218,0xCC44,0xC790,0xD749,
    0xD3D0,0xBC29,0xC640,0xC694,0xC6A9,0xD6C8,0xCD95,0xCCA9,
    0xCCB4,0xCC28,0xBABD,0xC120,0xD0C0,0xBCC4,0xC9C0,0xC800,
    0xCCA8,0xADA4,0xB2E8,0xC8FC,0xB4F1,0xB8B0,0xB4F1,0xC57D,
    0xAD8C,0xCD09,0xB839,0xCE5C,0xCE5C,0xBD80,0xC0AC,0xC870,
    0xACFC,0xD574,0xBB38,0xAD81,0xC218,0xD574,0xC12C,0xC678,
    0xC804,0xB871,0xAD6C,0xB960,0xADA4,0xCD98,0xC6A9,0xC6D4,
    0xAD50,0xAC15,0xBC18,0xAE30,0xAD49,0xBD80,0xB85C,0xAD49,
    0xD0C0,0xBBFC,0xC804,0xACAC,0xACC4,0xC99D,0xAC31,0xACF5,
    0xC804,0xB791,0xBAA8,0xC5ED,0xB959,0xC6D0,0xAD6D,0xBE44,
    0xAC31,0xD574,0xD3B8,0xD63C,0xC800,0xC6A9,0xC0C1,0xC624,
    0xCC28,0xC9C4,0xC120,0xBD09,0xB9CC,0xC218,0xC885,0xCD1D,
    0xAC31,0xC804,0xC0B0,0xC2DC,0xCDA9,0xC218,0xBE44,0xAC1C,
    0xBA78,0xC9C0,0xC608,0xBBFC,0xB839,0xCC2C,0xC5BC,0xB839,
    # 0x4880 #
    0xD758,0xC6D4,0xB9BD,0xC608,0xC2DC,0xC2E0,0xC6A9,0xC6A9,
    0xD68C,0xB18D,0xC720,0xAE30,0xBC1C,0xBC29,0xAE30,0xB450,
    0xC870,0xC81C,0xAD50,0xC6B0,0xD569,0xD73C,0xC728,0xACE1,
    0xC218,0xD328,0xAC31,0xD615,0xADC0,0xC544,0xC220,0xC720,
    0xC1A1,0xC12D,0xCC3D,0xC694,0xC220,0xC5F0,0xC194,0xB8CC,
    0xC885,0xC5B4,0xAD50,0xC218,0xCC9C,0xC120,0xB8B0,0xB9B0,
    0xC801,0xB3C5,0xC641,0xAE30,0xCC9C,0xC6B4,0xBC29,0xB2E8,
    0xC800,0xAC70,0xCD9C,0xC2E0,0xACF5,0xD56D,0xC120,0xC548,
    0xADA4,0xC6B0,0xB8B0,0xC0AC,0xB3C4,0xC2E0,0xD615,0xAD6C,
    0xD56D,0xC0AC,0xB2F9,0xCC44,0xC800,0xC5C4,0xCE58,0xACF5,
    0xC601,0xC804,0xADA4,0xB824,0xC1C4,0xB9C8,0xB9C8,0xACE0,
    0xB2F9,0xBC30,0xB8E8,0xCE60,0xCC28,0xB3C4,0xC545,0xC7A0,
    0xC7A0,0xC758,0xC801,0xB2F9,0xACFD,0xBE44,0xB958,0xC775,
    0xC21C,0xC900,0xBC1C,0xB9AC,0xACFC,0xC8FC,0xBC1C,0xCD94,
    0xAC39,0xD6C4,0xBC18,0xC0AC,0xD6C4,0xC774,0xAD04,0xC800,
    0xC5FC,0xBC8C,0xACAC,0xD568,0xB7C9,0xC9C0,0xBA71,0xC6B0,
    # 0x4900 #
    0xC57D,0xC2EC,0xB9E4,0xC74C,0xBA74,0xD22C,0xADDC,0xC218,
    0xD61C,0xBC00,0xC6A9,0xC6B1,0xCC3D,0xB9CC,0xADE4,0xBE44,
    0xC7A0,0xC655,0xAE30,0xBABD,0xC810,0xD559,0xD3EC,0xAC10,
    0xCC38,0xB825,0xB9AC,0xAD6C,0xB454,0xAD81,0xC724,0xCE68,
    0xC9C0,0xC5FC,0xBCC4,0xD638,0xAC1C,0xADA4,0xC6D4,0xD68C,
    0xBCBD,0xD0C0,0xD0C0,0xCC38,0xC0AC,0xC2DD,0xC12D,0xD615,
    0xD615,0xC11C,0xC801,0xC57C,0xD568,0xBE44,0xC5C5,0xC5B8,
    0xCD1D,0xC218,0xADFC,0xD0C0,0xC120,0xAD00,0xB3C4,0xACB0,
    0xCC9C,0xD568,0xBABD,0xC545,0xC870,0xAE08,0xAE08,0xC0BC,
    0xB9DD,0xC6D0,0xCC3D,0xD33D,0xC99D,0xC9C0,0xC21C,0xC5B4,
    0xBB34,0xB9D8,0xAC15,0xAE30,0xC18D,0xBCC4,0xC804,0xAD00,
    0xCC29,0xC218,0xCD08,0xACB0,0xD55C,0xC624,0xAD50,0xC54C,
    0xCE68,0xCCA9,0xB96D,0xCC29,0xBC15,0xB834,0xC218,0xC120,
    0xB824,0xBBF8,0xD604,0xCCA0,0xBC15,0xC99D,0xCD95,0xD30C,
    0xB9F9,0xC0AC,0xAD6C,0xC6B0,0xC900,0xD6A8,0xB825,0xCC30,
    0xBBF8,0xC124,0xC57C,0xBB34,0xBB3C,0xBC1C,0xC0AC,0xB824,
    # 0x4980 #
    0xC6B0,0xBC29,0xC0BC,0xC791,0xB9AC,0xC120,0xACFD,0xACC4,
    0xCC28,0xC0AC,0xB1E8,0xC624,0xCD94,0xC62C,0xAD00,0xD574,
    0xC815,0xD608,0xD0D5,0xCCA8,0xB2E8,0xD3C9,0xD560,0xD601,
    0xD55C,0xD788,0xAD04,0xC7C1,0xC624,0xD68D,0xC724,0xC628,
    0xC2DC,0xD658,0xD65C,0xBD80,0xCD40,0xD55C,0xAE08,0xD608,
    0xB780,0xBB38,0xD560,0xC601,0xACB0,0xD5A5,0xCD98,0xCE58,
    0xAD6C,0xC704,0xC5FC,0xD5A5,0xC5ED,0xBBF8,0xC7C1,0xC628,
    0xC6B0,0xC2ED,0xC815,0xC790,0xACB0,0xC11C,0xC6B0,0xC911,
    0xAD49,0xD6C4,0xC870,0xC804,0xAC01,0xC774,0xD64D,0xC758,
    0xC11C,0xB9AC,0xACE1,0xD604,0xC218,0xADF9,0xD604,0xBD09,
    0xACFD,0xC81C,0xB798,0xC8FC,0xB150,0xC5ED,0xC804,0xBCBD,
    0xC804,0xB989,0xD638,0xBC29,0xB2F9,0xCE58,0xB9C8,0xD568,
    0xC804,0xC6A9,0xAD6C,0xC778,0xBCF5,0xD61C,0xC704,0xC758,
    0xC5C5,0xAC10,0xCCA9,0xD638,0xBE48,0xCD1D,0xD5CC,0xCC38,
    0xD63C,0xAD6C,0xAC04,0xC790,0xC9C0,0xC9D0,0xAD6C,0xC720,
    0xACE0,0xC751,0xC6C5,0xD569,0xACE1,0xCD5C,0xC11C,0xC791,
    # 0x4A00 #
    0xC801,0xBB34,0xCD94,0xC548,0xC554,0xB8CC,0xBCC4,0xC30D,
    0xBE48,0xC575,0xC5F0,0xD559,0xBC15,0xC601,0xD64D,0xC790,
    0xD761,0xC81C,0xC6B0,0xB8B0,0xBC15,0xC6B0,0xC81C,0xBD80,
    0xC120,0xC74C,0xD640,0xC11D,0xBD95,0xCCAD,0xC6B0,0xC640,
    0xC560,0xD568,0xB2F4,0xBC15,0xC801,0xD655,0xBC29,0xC74C,
    0xCD94,0xB839,0xB9E4,0xB9E5,0xB78C,0xC18C,0xC124,0xC9C4,
    0xBC15,0xBCF5,0xB204,0xD76C,0xB300,0xB2F4,0xC6B4,0xC0B0,
    0xC740,0xC219,0xD1F4,0xBCD1,0xD638,0xBE44,0xBE44,0xC7A1,
    0xBE44,0xBE44,0xD568,0xC2DC,0xC804,0xC804,0xC794,0xC810,
    0xD68C,0xBCF4,0xC6D0,0xB9C8,0xCD08,0xB8CC,0xAC80,0xBA78,
    0xD640,0xAD49,0xC6B0,0xAE30,0xD0C0,0xC559,0xC0AC,0xD328,
    0xC81C,0xD604,0xC81C,0xD544,0xC8FC,0xD3EC,0xCCA9,0xC774,
    0xC815,0xACB9,0xC808,0xB3C4,0xD608,0xB2E8,0xC870,0xD608,
    0xCC3D,0xC6D0,0xAD00,0xB7C9,0xBD09,0xAE30,0xB85D,0xADF9,
    0xC9D1,0xC720,0xB3C4,0xC218,0xD638,0xC6B4,0xC815,0xBC29,
    0xC6A9,0xC561,0xC639,0xD328,0xBD09,0xC6B0,0xC790,0xBD84,
    # 0x4A80 #
    0xAD00,0xBCF5,0xADF9,0xB3C8,0xD669,0xCD09,0xCCB4,0xBC15,
    0xACAC,0xB835,0xB871,0xC720,0xCC38,0xB780,0xC1E0,0xB0A9,
    0xBE44,0xD0C0,0xC8FC,0xC811,0xBD80,0xAD6D,0xBD80,0xD558,
    0xC704,0xBC15,0xB2F5,0xBC88,0xCCA8,0xD68D,0xC7A1,0xBE44,
    0xC81C,0xC81C,0xC81C,0xC81C,0xBC88,0xD574,0xD64D,0xC9C0,
    0xBC15,0xC74C,0xAC00,0xACBD,0xBC1C,0xC6D0,0xCD94,0xC601,
    0xC758,0xAC1C,0xC62C,0xC724,0xCE68,0xC544,0xC800,0xAD6C,
    0xBBFC,0xBC30,0xAC11,0xBCC0,0xC808,0xD638,0xC9C4,0xC2E0,
    0xAC04,0xBE44,0xB2E4,0xC9C4,0xD0C8,0xC0BC,0xC131,0xC5FC,
    0xC7A0,0xBAA8,0xBC30,0xD1F4,0xBE44,0xBD80,0xCCA0,0xAE30,
    0xB9BC,0xC758,0xBB38,0xC624,0xACC4,0xC808,0xCE68,0xD558,
    0xD560,0xC0C1,0xACFC,0xD6C4,0xC694,0xBCF5,0xD6A8,0xC6B4,
    0xBE44,0xC554,0xC0AC,0xD61C,0xBA85,0xC678,0xAC11,0xACE0,
    0xC624,0xC0BC,0xC0C1,0xB8E8,0xCE68,0xD68C,0xC0BC,0xC758,
    0xB9B0,0xC720,0xD568,0xB3C5,0xAE08,0xBA74,0xBC88,0xC545,
    0xCD08,0xD64D,0xD6A1,0xC728,0xD608,0xD3EC,0xD544,0xCD08,
    # 0x4B00 #
    0xC720,0xC774,0xC6D4,0xC0BD,0xD73C,0xD611,0xB960,0xC5F0,
    0xD0DC,0xD68D,0xC0BD,0xB989,0xD478,0xD640,0xAD35,0xBD80,
    0xC704,0xC704,0xC218,0xC554,0xC720,0xAC15,0xD6A1,0xC591,
    0xD6A8,0xC694,0xBC94,0xD544,0xB9AC,0xD6A1,0xB3C4,0xB958,
    0xBE44,0xC800,0xB3C4,0xD758,0xCC2C,0xC758,0xB450,0xC6D0,
    0xAD6C,0xC7AC,0xBC15,0xC81C,0xC559,0xB3C4,0xC774,0xB150,
    0xC18C,0xBCF8,0xAD6C,0xBC18,0xB9D0,0xC560,0xC548,0xC0AC,
    0xCC2C,0xC9C8,0xC591,0xC804,0xC5F0,0xC138,0xC81C,0xBBF8,
    0xC2E0,0xC81C,0xC74D,0xC784,0xC0AC,0xACE0,0xB141,0xC5F4,
    0xAC74,0xC218,0xC601,0xD3EC,0xD638,0xD638,0xC5FD,0xD3B8,
    0xC591,0xB834,0xC2DD,0xC628,0xD1F4,0xC7A0,0xC800,0xC601,
    0xC601,0xCE68,0xB2F9,0xB2F4,0xB8CC,0xD68C,0xC5ED,0xC5FD,
    0xACB8,0xC740,0xB155,0xC790,0xACAC,0xC591,0xBC15,0xBBF8,
    0xC218,0xB9C8,0xB7C9,0xACC4,0xACC4,0xC218,0xBD88,0xBC1C,
    0xBD09,0xBCC4,0xC758,0xC704,0xD658,0xBC94,0xAE30,0xBAA8,
    0xBD80,0xC559,0xC559,0xBD84,0xAE30,0xAD70,0xD0DC,0xC77C,
    # 0x4B80 #
    0xBC15,0xBCC0,0xBC1C,0xAD6C,0xD604,0xC220,0xBE44,0xC728,
    0xCE58,0xB824,0xC774,0xB82C,0xD734,0xB1E8,0xD76C,0xC624,
    0xACBD,0xB8B0,0xD3EC,0xD0C1,0xCD94,0xCCA0,0xCC3D,0xC548,
    0xC608,0xC5ED,0xB989,0xBD80,0xC0BD,0xD63C,0xC900,0xC218,
    0xBCBD,0xD544,0xC0BD,0xC0C1,0xD559,0xB825,0xAD50,0xD55C,
    0xC7AC,0xACE8,0xC2B9,0xB8E8,0xB9C9,0xBA71,0xB9E5,0xC624,
    0xC801,0xCD95,0xD669,0xBC88,0xB4F1,0xB3D9,0xC9D1,0xB3C5,
    0xC54C,0xC608,0xC81C,0xB3C4,0xB9B0,0xD45C,0xBD09,0xAC74,
    0xC12D,0xB77C,0xC2E0,0xC548,0xACFC,0xC12D,0xC775,0xACE8,
    0xC644,0xC54C,0xAC00,0xBC1C,0xACE0,0xB839,0xAC04,0xAD04,
    0xD574,0xAD11,0xD589,0xADDC,0xCC45,0xC815,0xB791,0xD3D0,
    0xD658,0xBCF4,0xC694,0xC644,0xCC99,0xC218,0xACFC,0xB300,
    0xC624,0xACB8,0xB9C8,0xAD34,0xAD34,0xC554,0xB9D0,0xACBD,
    0xACE0,0xACF1,0xACE0,0xD638,0xB2E4,0xC12C,0xB0B4,0xC0AC,
    0xAC1C,0xBE44,0xD30C,0xC1A1,0xC7A5,0xC54C,0xB9CC,0xC22D,
    0xCC28,0xC12C,0xAD04,0xACE0,0xC801,0xBD80,0xC870,0xC878,
    # 0x4C00 #
    0xC640,0xBE44,0xCC44,0xBCD1,0xC0C8,0xC218,0xC720,0xAE30,
    0xCC28,0xBC18,0xBC15,0xB9CC,0xCD1D,0xD734,0xADC0,0xC81C,
    0xB78C,0xC218,0xBABD,0xBA74,0xBC18,0xB824,0xCC2C,0xAD6C,
    0xB958,0xC758,0xBB38,0xB825,0xB825,0xC99D,0xC790,0xD63C,
    0xC2E0,0xCE58,0xD589,0xB9DD,0xB3D9,0xC5ED,0xBE44,0xD638,
    0xB9E4,0xCC28,0xB9E4,0xCD08,0xADE4,0xC720,0xC758,0xC758,
    0xC720,0xB839,0xC54C,0xC815,0xAE00,0xC790,0xB9DD,0xBC29,
    0xACF5,0xC801,0xAC1C,0xC5B4,0xC7A0,0xD328,0xD30C,0xD0C0,
    0xC559,0xAD50,0xC720,0xC9C8,0xAC1C,0xB9D0,0xC2B9,0xC120,
    0xC9C0,0xC800,0xBBF8,0xACF5,0xC774,0xAE0D,0xAE0D,0xB450,
    0xBD80,0xC124,0xC5C5,0xC815,0xC870,0xBB34,0xB958,0xCC2C,
    0xB9AC,0xC219,0xB85D,0xD601,0xC791,0xD328,0xB0B4,0xAC70,
    0xC794,0xAD6D,0xC7C1,0xC878,0xD568,0xC81C,0xCD94,0xC120,
    0xC81C,0xB9DD,0xD45C,0xB784,0xC11C,0xAE0D,0xC561,0xB9B0,
    0xB3D9,0xC81C,0xC5F0,0xC804,0xAE0D,0xC639,0xB791,0xC5B4,
    0xC218,0xCC28,0xD574,0xD65C,0xC804,0xCC3D,0xB8E8,0xCC38,
    # 0x4C80 #
    0xC9C0,0xC704,0xC120,0xCD08,0xBBFC,0xADDC,0xC18C,0xC18D,
    0xB9C8,0xC0AC,0xD0C0,0xC7A0,0xAD00,0xB4F1,0xB0B4,0xB85C,
    0xB85C,0xC758,0xD574,0xC5C4,0xACBD,0xBCF4,0xC8FC,0xD568,
    0xAD00,0xC808,0xB8B0,0xBABD,0xC5C5,0xCC3D,0xB9BD,0xC778,
    0xCD98,0xCD94,0xB4F1,0xC5B4,0xC8FC,0xAD6C,0xB300,0xB450,
    0xD64D,0xC2DC,0xD61C,0xAD6C,0xC9C0,0xC2DC,0xC6D0,0xAE09,
    0xC6B4,0xBC29,0xACF5,0xD56D,0xC9D0,0xC791,0xC6D0,0xBAA9,
    0xAC1C,0xBE44,0xAC10,0xD604,0xC0DD,0xC11D,0xAD50,0xC790,
    0xC77C,0xBC1C,0xC870,0xC6D0,0xC790,0xC9C0,0xBC31,0xBB34,
    0xBCF4,0xB3D9,0xBC1C,0xB3D9,0xACAC,0xACF5,0xAD6C,0xADDC,
    0xCC28,0xC720,0xC6D0,0xB85C,0xACE1,0xBD80,0xB151,0xC544,
    0xC544,0xD615,0xAC04,0xC548,0xB3C4,0xBD80,0xBD09,0xBA85,
    0xC218,0xCD94,0xAE30,0xC5F0,0xBCC4,0xC7A0,0xC120,0xD6C4,
    0xD669,0xC694,0xC804,0xADDC,0xC5ED,0xC801,0xB9E5,0xC911,
    0xBCF4,0xBAA9,0xC9C4,0xC220,0xB2F5,0xCE59,0xACC4,0xC885,
    0xB9C8,0xAD6C,0xC554,0xCC38,0xAD6C,0xD559,0xB4F1,0xC5F0,
    # 0x4D00 #
    0xB3D9,0xC6B0,0xC0C1,0xB1E8,0xC21C,0xBD84,0xBCF5,0xB839,
    0xC624,0xD658,0xC758,0xD658,0xBABD,0xC575,0xB8E8,0xC5F0,
    0xBCF4,0xCCA9,0xB839,0xC0AC,0xAD50,0xB82C,0xCCAD,0xACA9,
    0xCCB4,0xBCBD,0xAC15,0xC18C,0xD68C,0xCD5C,0xC801,0xD658,
    0xC624,0xB824,0xBBF8,0xD638,0xC0DD,0xAC00,0xC740,0xC704,
    0xC6D0,0xD45C,0xB85D,0xB839,0xC775,0xC7AC,0xC0B0,0xD640,
    0xC18D,0xD0C0,0xB9D0,0xD65C,0xCCA9,0xBCD1,0xBD09,0xD63C,
    0xBD80,0xACFC,0xBD80,0xB9AC,0xC794,0xBE44,0xCC28,0xBABD,
    0xC1C4,0xC7A5,0xC801,0xAD49,0xD48D,0xC624,0xBABD,0xC0BC,
    0xACE1,0xB450,0xB3C8,0xC720,0xD610,0xB3C8,0xB2E8,0xB85C,
    0xCC9C,0xB2D0,0xB2D0,0xB9AC,0xB3D9,0xAC70,0xACAC,0xBCF5,
    0xC0C8,0xCC28,0xB3C4,0xACAC,0xB18D,0xC54C,0xACBD,0xAC04,
    0xC801,0xACAC,0xB9E4,0xB2EC,0xACAC,0xC6B8,0xC0AC,0xC7AC,
    0xB9DD,0xB840,0xACE4,0xD6C8,0xB2F5,0xC790,0xC591,0xD1A4,
    0xC0C1,0xD601,0xC870,0xD68C,0xC789,0xCD2C,0xAD6C,0xC640,
    0xCD94,0xC9C0,0xC815,0xC138,0xC0C1,0xC7A1,0xBD80,0xCCA9,
    # 0x4D80 #
    0xB2F5,0xB2F5,0xD45C,0xD568,0xBCD1,0xAC01,0xCD94,0xC8FC,
    0xBC15,0xB958,0xB275,0xD761,0xD3EC,0xC81C,0xD569,0xCCB4,
    0xC65C,0xC81C,0xC81C,0xC81C,0xCE58,0xD30C,0xAE08,0xAC00,
    0xB9BD,0xAC70,0xAD6C,0xB784,0xACE1,0xD611,0xAE30,0xD568,
    0xD568,0xC2E4,0xD568,0xC560,0xD560,0xCC28,0xCC45,0xC694,
    0xCC38,0xC81C,0xCC30,0xC5C4,0xACAC,0xC655,0xC5C4,0xADDC,
    0xCD08,0xB3D9,0xC5FC,0xC57D,0xCDE8,0xC9C0 # 0x4DB5
    );

    @hanjacompat_to_hangul = (
    # 0xF900 #
    0xAC1C,0xAC31,0xAC70,0xACE0,0xACE8,0xAD00,0xADC0,0xADC0,
    0xADE0,0xAE00,0xAE08,0xB098,0xB098,0xB098,0xB098,0xB098,
    0xB098,0xB098,0xB098,0xB098,0xB099,0xB099,0xB099,0xB099,
    0xB099,0xB099,0xB099,0xB09C,0xB09C,0xB09C,0xB09C,0xB09C,
    0xB09C,0xB0A8,0xB0A8,0xB0A8,0xB0A8,0xB0A9,0xB0A9,0xB0A9,
    0xB0AD,0xB0AD,0xB0AD,0xB0AD,0xB0AD,0xB0B4,0xB0C9,0xB178,
    0xB178,0xB178,0xB178,0xB178,0xB178,0xB178,0xB178,0xB178,
    0xB178,0xB178,0xB178,0xB179,0xB179,0xB179,0xB179,0xB179,
    0xB179,0xB17C,0xB18D,0xB18D,0xB18D,0xB18D,0xB1CC,0xB1CC,
    0xB1CC,0xB1CC,0xB204,0xB204,0xB204,0xB204,0xB204,0xB204,
    0xB204,0xB204,0xB291,0xB291,0xB2A0,0xB2A5,0xB2A5,0xB2A5,
    0xB2A5,0xB2A5,0xB450,0xB77C,0xB77D,0xB77D,0xB780,0xB839,
    0xB85C,0xB960,0xB9AC,0xBC30,0xBC88,0xBCC0,0xBD80,0xBD88,
    0xBE44,0xC0AD,0xC0AD,0xC0BC,0xC0C9,0xC0DD,0xC12D,0xC138,
    0xC1C4,0xC2E0,0xC2EC,0xC2ED,0xC57C,0xC57D,0xC57D,0xC591,
    0xC591,0xC591,0xC591,0xC591,0xC591,0xC591,0xC591,0xC5EC,
    # 0xF980 #
    0xC5EC,0xC5EC,0xC5EC,0xC5EC,0xC5EC,0xC5EC,0xC5EC,0xC5EC,
    0xC5EC,0xC5EC,0xC5ED,0xC5ED,0xC5ED,0xC5ED,0xC5F0,0xC5F0,
    0xC5F0,0xC5F0,0xC5F0,0xC5F0,0xC5F0,0xC5F0,0xC5F0,0xC5F0,
    0xC5F0,0xC5F0,0xC5F0,0xC5F0,0xC5F4,0xC5F4,0xC5F4,0xC5F4,
    0xC5F4,0xC5F4,0xC5FC,0xC5FC,0xC5FC,0xC5FC,0xC5FC,0xC5FD,
    0xC601,0xC601,0xC601,0xC601,0xC601,0xC601,0xC601,0xC601,
    0xC601,0xC601,0xC601,0xC601,0xC601,0xC608,0xC608,0xC608,
    0xC608,0xC624,0xC694,0xC694,0xC694,0xC694,0xC694,0xC694,
    0xC694,0xC694,0xC694,0xC694,0xC6A9,0xC6B4,0xC6D0,0xC720,
    0xC720,0xC720,0xC720,0xC720,0xC720,0xC720,0xC720,0xC720,
    0xC720,0xC721,0xC721,0xC721,0xC724,0xC724,0xC724,0xC724,
    0xC728,0xC728,0xC728,0xC728,0xC735,0xC774,0xC774,0xC774,
    0xC774,0xC774,0xC774,0xC774,0xC774,0xC774,0xC774,0xC774,
    0xC774,0xC774,0xC774,0xC775,0xC775,0xC778,0xC778,0xC778,
    0xC778,0xC778,0xC778,0xC778,0xC784,0xC784,0xC784,0xC785,
    0xC785,0xC785,0xC7A5,0xC801,0xC9C0,0xC9D1,0xCC28,0xCC99,
    # 0xFA00 #
    0xCCB4,0xD0C1,0xD0C1,0xD0D5,0xD0DD,0xD1B5,0xD3EC,0xD3ED,
    0xD56D,0xD56D,0xD604,0xD655,0xC62C,0xD639,0xC30D,0xACE1,
    0xCD1D,0xAE30,0xCCAD,0xBD80,0xAC70,0xD76C,0xC800,0xC775,
    0xB840,0xC2E0,0xC0C1,0xBCF5,0xC815,0xC815,0xC6B0,0xC54C,
    0xAD6C,0xC0DD,0xC81C,0xB450,0xAE09,0xC77C,0xB3C4,0xD6A8,
    0xD589,0xB3C4,0xBC18,0xC0AC,0xAD00,0xD559 # 0xFA2D
    );
}
#eof
