package latexDraw.parsers.svg.parsers;


/**
 * Defines a parser that parses a SVG CSS style attribute.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/24/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 */
public class CSSStyleParser extends AbstractSVGParser
{
	/** The handler which will manage actions to do when a CSS style is parsed. @since 0.1 */
	protected CSSStyleHandler handler ;
	
	
	/**
	 * The constructor.
	 * @param code The code to parse (must not be null).
	 * @param handler The CSS style handler.
	 * @since 0.1
	 */
	public CSSStyleParser(String code, CSSStyleHandler handler)
	{
		super(code);
		
		if(handler==null)
			throw new IllegalArgumentException();
		
		this.handler = handler;
	}

	
	
	/**
	 * Parses the code to find some CSS styles which are given to the CSS style handler.
	 * @since 0.1
	 */
	public void parseCSSStyles()
	{
		String[] styles = code.split(";");//$NON-NLS-1$
		String[] style;
		
		for(int i=0; i<styles.length; i++)
		{
			style = styles[i].split(":", 2);//$NON-NLS-1$
			
			if(style.length==2)
				handler.onCSSStyle(style[0], style[1]);
		}
	}
}
