package latexDraw.parsers.svg.parsers;

/**
 * Defines a parser that parses URI references.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 11/21/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 * @since 0.1
 */
public class URIReferenceParser extends AbstractSVGParser
{

	/**
	 * Creates a parser.
	 * @param code The code to parse.
	 */
	public URIReferenceParser(String code)
	{
		super(code);
	}

	
	/**
	 * Reads a URI reference string from an url(#ref) attribute - such as url(#id123) - returns the extracted reference (id123).
	 * @return The parsed reference or an empty string if the format of the code is not valid (not "url(#ref)")
	 * @since 0.1
	 */
	public String getURI()
	{
		String uri = "";//$NON-NLS-1$
		skipWSP();
		
		if(getChar()=='u' && nextChar()=='r' && nextChar()=='l' && nextChar()=='(')
		{
			nextChar();
			skipWSP();
			
			if(getChar()=='#')
			{
				while(nextChar()!=')' && !isEOP())
					uri += (char)getChar();
				
				if(getChar()!=')')
					uri = "";//$NON-NLS-1$
			}
		}
		
		return uri;
	}
}
