/*
 * LMenuBar.java
 */
package latexDraw.ui.components;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Vector;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.CodePanel;
import latexDraw.ui.DrawPanel;
import latexDraw.ui.LaTeXDrawFrame;
import latexDraw.ui.dialog.ExceptionFrameDialog;
import latexDraw.ui.listeners.MenusListener;
import latexDraw.ui.listeners.RecentFilesListener;
import latexDraw.util.LaTeXDrawResources;


/** 
 * Defines the latexdraw menu bar..<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 09/22/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class LMenuBar extends JMenuBar
{
	private static final long	serialVersionUID	= 1L;
	
	/** The menu which allows to import templates */
	protected MenuTemplate menuTemplate;
	
	/** Allows to cut a figure */
	protected JMenuItem cutMenu;
	
	/** Allows to paste a figure */
	protected JMenuItem pasteMenu;
	
	/** Allows to copy a figure */
	protected JMenuItem copyMenu;
	
	/** This menu allows to export the drawing as a template */
	protected JMenuItem exportTemplateMenu;
	
	/** Allows to undo actions */
	protected JMenuItem undoMenu;
	
	/** Allows to redo actions */
	protected JMenuItem redoMenu;
	
    /** This menu allows the user to export either the pstricks code or the drawing as jpg picture */
	protected JMenu exportAsMenu;
	
	protected JMenu recentFilesMenu;
	
	/** The menu "drawing" */
	protected JMenu drawMenu;
	
	/** This menu allows the user to set his preferences */
	protected JMenuItem preferencesMenu;
	
	/** This menu allows the set the properties of the selected figure */
	protected JMenuItem propertiesFigureMenu;
        
    /** This menu allows the user to delete a figure in the drawing. */
	protected JMenuItem deleteFigure;
    
    /** This menu allows the user to see or not the borders of the drawing */
    protected JCheckBoxMenuItem displayBorders;
    
    /** This menu allows the user to see or not the X-scale */
    protected JCheckBoxMenuItem displayXScale;
    
    /** This menu allows the user to see or not the Y-scale */
    protected JCheckBoxMenuItem displayYScale;
    
    /** This menu allows the user to see or not the grids */
    protected JCheckBoxMenuItem displayGrid;
    
    protected JCheckBoxMenuItem displayPersoGrid;
    
    /** This menu allows the user to set visible or not the code panel */
    protected JCheckBoxMenuItem displayCodePanel;
    
    /** This menu allows to activate the automatic adjustment of the borders of the drawing */
    protected JCheckBoxMenuItem autoAdjustBorders;
    
	/** The button of the menubar to draw polygons */
    protected JRadioButtonMenuItem menuPoly;
	
	/** The button of the menubar to draw lines */
    protected JRadioButtonMenuItem menuLine;
	
	/** The button of the menubar to draw rectangles */
    protected JRadioButtonMenuItem menuRect;
	
	/** The button of the menubar to draw squares */
    protected JRadioButtonMenuItem menuSquare;
	
	/** The button of the menubar to draw dots */
    protected JRadioButtonMenuItem menuDot;
	
	/** The button of the menubar to draw rhombus */
    protected JRadioButtonMenuItem menuRhombus;
	
	/** The button of the menubar to draw triangles */
    protected JRadioButtonMenuItem menuTriangle;
	
	/** The button of the menubar to draw joined lines */
    protected JRadioButtonMenuItem menuJoinedLines;
	
	/** The button of the menubar to draw circles */
    protected JRadioButtonMenuItem menuCircle;
	
    protected JRadioButtonMenuItem menuAxes;
	
	/** The button of the menubar to draw chords */
    protected JRadioButtonMenuItem menuChord;
	
	/** The button of the menubar to draw ellipses */
    protected JRadioButtonMenuItem menuEllipse;
	
	/** The button of the menubar to draw Bézier curves */
    protected JRadioButtonMenuItem menuBezierCurve;
	
    protected JRadioButtonMenuItem menuClosedBezierCurve;
	
	/** The button of the menubar to select figures */
    protected JRadioButtonMenuItem menuSelect;
	
	/** The button of the menubar to draw arcs */
    protected JRadioButtonMenuItem menuArc;
	
	/** The button of the menubar to draw wedges */
    protected JRadioButtonMenuItem menuWedge;
	
	/** The button of the menubar to draw texts */
    protected JRadioButtonMenuItem menuText;
	
	/** The button of the menubar to draw akin points */
    protected JRadioButtonMenuItem menuPointsAkin;
	
	/** The button of the menubar to draw grids */
    protected JRadioButtonMenuItem menuGrid;
	protected JCheckBoxMenuItem menuAutoUpdate;
	protected JMenuItem menuReloadCode;
	protected JMenuItem updateToGridMenu;
	
	protected LaTeXDrawFrame parentFrame;
	
	
	public LMenuBar(LaTeXDrawFrame p)
	{
		super();
		
		if(p==null)
			throw new IllegalArgumentException();
		
		parentFrame = p;
		
		MenusListener ml = parentFrame.getMenuListener();
		ButtonGroup drawMenuGroup = new ButtonGroup();

		JMenu fileMenu = new JMenu(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.88")); //$NON-NLS-1$
		JMenu editMenu = new JMenu(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.89")); //$NON-NLS-1$
		JMenu displayM = new JMenu(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.90")); //$NON-NLS-1$
		drawMenu = new JMenu(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.91")); //$NON-NLS-1$
		JMenu insertMenu = new JMenu(LaTeXDrawLang.getString1_6("LaTeXDrawFrame.10")); //$NON-NLS-1$
		JMenu codeMenu = new JMenu(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.92")); //$NON-NLS-1$
		JMenu helpMenu = new JMenu(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.93")); //$NON-NLS-1$
		JMenuItem menu;
		
		undoMenu = new JMenuItem(LaTeXDrawResources.LABEL_UNDO, KeyEvent.VK_Z);
		undoMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Z,InputEvent.CTRL_MASK));
		undoMenu.setIcon(LaTeXDrawResources.undoIcon);
		undoMenu.addActionListener(ml); 
		undoMenu.setActionCommand(LaTeXDrawResources.LABEL_UNDO);
		editMenu.add(undoMenu); 
		
		redoMenu = new JMenuItem(LaTeXDrawResources.LABEL_REDO, KeyEvent.VK_Y);
		redoMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Y,InputEvent.CTRL_MASK));
		redoMenu.setIcon(LaTeXDrawResources.redoIcon);
		redoMenu.addActionListener(ml); 
		redoMenu.setActionCommand(LaTeXDrawResources.LABEL_REDO);
		editMenu.add(redoMenu); 
		
		editMenu.addSeparator();
		
		copyMenu = new JMenuItem(LaTeXDrawResources.LABEL_COPY, KeyEvent.VK_C);
		copyMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C,InputEvent.CTRL_MASK));
		copyMenu.setIcon(LaTeXDrawResources.copyIcon);
		copyMenu.addActionListener(ml); 
		copyMenu.setActionCommand(LaTeXDrawResources.LABEL_COPY);
		editMenu.add(copyMenu); 
		copyMenu.setEnabled(false);
		
		cutMenu = new JMenuItem(LaTeXDrawResources.LABEL_CUT, KeyEvent.VK_X);
		cutMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X,InputEvent.CTRL_MASK));
		cutMenu.setIcon(LaTeXDrawResources.cutIcon);
		cutMenu.addActionListener(ml); 
		cutMenu.setActionCommand(LaTeXDrawResources.LABEL_CUT);
		editMenu.add(cutMenu); 
		cutMenu.setEnabled(false);
		
		pasteMenu = new JMenuItem(LaTeXDrawResources.LABEL_PASTE, KeyEvent.VK_V);
		pasteMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V,InputEvent.CTRL_MASK));
		pasteMenu.setIcon(LaTeXDrawResources.pasteIcon);
		pasteMenu.addActionListener(ml); 
		pasteMenu.setActionCommand(LaTeXDrawResources.LABEL_PASTE);
		editMenu.add(pasteMenu); 
		pasteMenu.setEnabled(false);
		
		menu = new JMenuItem(LaTeXDrawResources.LABEL_NEW, KeyEvent.VK_N);
		menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N,InputEvent.CTRL_MASK));
		menu.setIcon(LaTeXDrawResources.newIcon);
		menu.addActionListener(ml); 
		menu.setActionCommand(LaTeXDrawResources.LABEL_NEW);
		fileMenu.add(menu);
		
		menu = new JMenuItem(LaTeXDrawResources.LABEL_NEW_WITH_SEL);
		menu.setIcon(LaTeXDrawResources.newIcon);
		menu.addActionListener(ml); 
		menu.setActionCommand(LaTeXDrawResources.LABEL_NEW_WITH_SEL);
		fileMenu.add(menu);

		menu = new JMenuItem(LaTeXDrawResources.LABEL_OPEN, KeyEvent.VK_O);
		menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O,InputEvent.CTRL_MASK));
		menu.setIcon(LaTeXDrawResources.openIcon);
		menu.addActionListener(ml); 
		menu.setActionCommand(LaTeXDrawResources.LABEL_OPEN);
        fileMenu.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_SAVE, KeyEvent.VK_S);
        menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S,InputEvent.CTRL_MASK));
        menu.setIcon(LaTeXDrawResources.saveIcon);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_SAVE);
        fileMenu.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_SAVE_AS, KeyEvent.VK_A);
        menu.setIcon(LaTeXDrawResources.saveAsIcon);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_SAVE_AS);
        fileMenu.add(menu);
        
        recentFilesMenu = new JMenu(LaTeXDrawResources.LABEL_RECENT_FILES);
        recentFilesMenu.setIcon(LaTeXDrawResources.emptyIcon);
        recentFilesMenu.setActionCommand(LaTeXDrawResources.LABEL_RECENT_FILES);
        fileMenu.add(recentFilesMenu);
        
        fileMenu.addSeparator();
        
        JMenu importM = new JMenu(LaTeXDrawResources.LABEL_IMPORT);
        importM.setIcon(LaTeXDrawResources.importIcon);
        fileMenu.add(importM);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_IMPORT_TEX, KeyEvent.VK_X);
        menu.setIcon(LaTeXDrawResources.insertPSTricksIcon);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_IMPORT_TEX);
        importM.add(menu);
        
        exportAsMenu = new JMenu(LaTeXDrawResources.LABEL_EXPORT_AS);
        exportAsMenu.setIcon(LaTeXDrawResources.exportIcon);
        fileMenu.add(exportAsMenu);
        exportAsMenu.setEnabled(false);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_EXPORT_TRICKS, KeyEvent.VK_T);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_EXPORT_TRICKS);
        exportAsMenu.add(menu);
       
        menu = new JMenuItem(LaTeXDrawResources.LABEL_EXPORT_JPG, KeyEvent.VK_J);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_EXPORT_JPG);
        exportAsMenu.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_EXPORT_PNG, KeyEvent.VK_P);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_EXPORT_PNG);
        exportAsMenu.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_EXPORT_EPS, KeyEvent.VK_E);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_EXPORT_EPS);
        exportAsMenu.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_EXPORT_BMP, KeyEvent.VK_B);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_EXPORT_BMP);
        exportAsMenu.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_EXPORT_PPM, KeyEvent.VK_N);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_EXPORT_PPM);
        exportAsMenu.add(menu);
        
        exportTemplateMenu = new JMenuItem(LaTeXDrawResources.LABEL_TEMPLATE_EXPORT);
        exportTemplateMenu.addActionListener(ml); 
        exportTemplateMenu.setActionCommand(LaTeXDrawResources.LABEL_TEMPLATE_EXPORT);
        exportAsMenu.add(exportTemplateMenu);
        exportTemplateMenu.setEnabled(false);
           
        fileMenu.addSeparator();
     
        menu = new JMenuItem(LaTeXDrawResources.LABEL_BATCH_CONVERT, KeyEvent.VK_V);
        menu.addActionListener(ml); 
        menu.setIcon(LaTeXDrawResources.copyIcon);
        menu.setActionCommand(LaTeXDrawResources.LABEL_BATCH_CONVERT);
        fileMenu.add(menu);
        
        fileMenu.addSeparator();
        
        preferencesMenu = new JMenuItem(LaTeXDrawResources.LABEL_PREFERENCES, KeyEvent.VK_P);
        preferencesMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P,InputEvent.CTRL_MASK));
        preferencesMenu.setIcon(LaTeXDrawResources.preferencesIcon);
        preferencesMenu.addActionListener(parentFrame); 
        preferencesMenu.setActionCommand(LaTeXDrawResources.LABEL_PREFERENCES);
        fileMenu.add(preferencesMenu);
        
        fileMenu.addSeparator();
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_PRINT_CODE, KeyEvent.VK_E);
        menu.setIcon(LaTeXDrawResources.printIcon);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_PRINT_CODE);
        fileMenu.add(menu);
         
        menu = new JMenuItem(LaTeXDrawResources.LABEL_PRINT_DRAW, KeyEvent.VK_D);
        menu.setIcon(LaTeXDrawResources.printIcon);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_PRINT_DRAW);
        fileMenu.add(menu);
        
        fileMenu.addSeparator();
         
        menu = new JMenuItem(LaTeXDrawResources.LABEL_QUIT, KeyEvent.VK_Q);
        menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_W,InputEvent.CTRL_MASK));
        menu.setIcon(LaTeXDrawResources.emptyIcon);
        menu.addActionListener(ml); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_QUIT);
        fileMenu.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_HELP, KeyEvent.VK_H);
        menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0));
        menu.setIcon(LaTeXDrawResources.helpIcon);
        menu.addActionListener(parentFrame); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_HELP);
        helpMenu.add(menu); 
        
        menu = new JMenuItem(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.3"), KeyEvent.VK_S); //$NON-NLS-1$
        menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
        menu.setIcon(LaTeXDrawResources.helpIcon);
        menu.addActionListener(ml); 
        menu.setActionCommand(MenusListener.ACTION_CMD_SHORTCUTS);
        helpMenu.add(menu);   
     
     	helpMenu.addSeparator();
     	
     	if(LaTeXDrawFrame.WITH_UPDATE)
     	{
	        menu = new JMenuItem(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.4"), KeyEvent.VK_U); //$NON-NLS-1$
	        menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F3, 0));
	        menu.setIcon(LaTeXDrawResources.updateIcon);
	        menu.addActionListener(ml);
	        menu.setActionCommand(MenusListener.LABEL_CHECK_UPDATE);
	        helpMenu.add(menu);   
	     
	     	helpMenu.addSeparator();
     	}
     
     	menu = new JMenuItem(LaTeXDrawResources.LABEL_ABOUT, KeyEvent.VK_A);
     	menu.setIcon(LaTeXDrawResources.aboutIcon);
        menu.addActionListener(parentFrame); 
        menu.setActionCommand(LaTeXDrawResources.LABEL_ABOUT);
        helpMenu.add(menu);    
              
        drawMenu.add(createTemplateMenu());        
        drawMenu.addSeparator();
        
        menu = new JMenu(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.5")); //$NON-NLS-1$
        menu.setIcon(LaTeXDrawResources.emptyIcon);
        drawMenu.add(menu);
        
        menuLine = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_LINE, LaTeXDrawResources.lineIcon);
        menuLine.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_L, 0));
        menuLine.setMnemonic(KeyEvent.VK_L);
        menuLine.addActionListener(ml);
        menuLine.setActionCommand(LaTeXDrawResources.LABEL_LINE);
        menu.add(menuLine);
        drawMenuGroup.add(menuLine);
        
        menuJoinedLines = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_JOINED_LINES, LaTeXDrawResources.joinedLinesIcon);
        menuJoinedLines.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_J,0));
        menuJoinedLines.setMnemonic(KeyEvent.VK_J);
        menuJoinedLines.addActionListener(ml);
        menuJoinedLines.setActionCommand(LaTeXDrawResources.LABEL_JOINED_LINES);
        menu.add(menuJoinedLines);
        drawMenuGroup.add(menuJoinedLines);
           
        menuPoly = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_POLY, LaTeXDrawResources.polygonIcon);
        menuPoly.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P,0));
        menuPoly.setMnemonic(KeyEvent.VK_P);
        menuPoly.addActionListener(ml);
        menuPoly.setActionCommand(LaTeXDrawResources.LABEL_POLY);
        menu.add(menuPoly);
        drawMenuGroup.add(menuPoly);
        menuPoly.setSelected(false);
        
        menuDot = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_DOT, LaTeXDrawResources.dotIcon);
        menuDot.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_D,0));
        menuDot.setMnemonic(KeyEvent.VK_D);
        menuDot.addActionListener(ml);
        menuDot.setActionCommand(LaTeXDrawResources.LABEL_DOT);
        menu.add(menuDot);
        drawMenuGroup.add(menuDot);
        menuDot.setSelected(false);
        
        menuRect = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_RECT, LaTeXDrawResources.rectIcon);
        menuRect.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R,0));
        menuRect.setMnemonic(KeyEvent.VK_R);
        menuRect.addActionListener(ml);
        menuRect.setActionCommand(LaTeXDrawResources.LABEL_RECT);
        menu.add(menuRect);
        drawMenuGroup.add(menuRect);
        menuRect.setSelected(false);
        
        menuSquare = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_SQUARE, LaTeXDrawResources.squareIcon);
        menuSquare.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S,0));
        menuSquare.setMnemonic(KeyEvent.VK_S);
        menuSquare.addActionListener(ml);
        menuSquare.setActionCommand(LaTeXDrawResources.LABEL_SQUARE);
        menu.add(menuSquare);
        drawMenuGroup.add(menuSquare);
        menuSquare.setSelected(false);
        
        menuRhombus = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_RHOMBUS, LaTeXDrawResources.rhombusIcon);
        menuRhombus.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_H,0));
        menuRhombus.setMnemonic(KeyEvent.VK_H);
        menuRhombus.addActionListener(ml);
        menuRhombus.setActionCommand(LaTeXDrawResources.LABEL_RHOMBUS);
        menu.add(menuRhombus);
        drawMenuGroup.add(menuRhombus);
        menuRhombus.setSelected(false);
        
        menuTriangle = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_TRIANGLE, LaTeXDrawResources.triangleIcon);
        menuTriangle.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T,0));
        menuTriangle.setMnemonic(KeyEvent.VK_T);
        menuTriangle.addActionListener(ml);
        menuTriangle.setActionCommand(LaTeXDrawResources.LABEL_TRIANGLE);
        menu.add(menuTriangle);
        drawMenuGroup.add(menuTriangle);
        menuTriangle.setSelected(false);

        menuEllipse = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_ELLIPSE, LaTeXDrawResources.ellipseIcon);
        menuEllipse.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E,0));
        menuEllipse.setMnemonic(KeyEvent.VK_E);
        menuEllipse.addActionListener(ml);
        menuEllipse.setActionCommand(LaTeXDrawResources.LABEL_ELLIPSE);
        menu.add(menuEllipse);
        drawMenuGroup.add(menuEllipse);
        menuEllipse.setSelected(false);
        
        menuCircle = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_CIRCLE, LaTeXDrawResources.circleIcon);
        menuCircle.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C,0));
        menuCircle.setMnemonic(KeyEvent.VK_C);
        menuCircle.addActionListener(ml);
        menuCircle.setActionCommand(LaTeXDrawResources.LABEL_CIRCLE);
        menu.add(menuCircle);
        drawMenuGroup.add(menuCircle);
        menuCircle.setSelected(false);
        
        menuArc = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_ARC, LaTeXDrawResources.arcIcon);
        menuArc.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A,0));
        menuArc.setMnemonic(KeyEvent.VK_A);
        menuArc.addActionListener(ml);
        menuArc.setActionCommand(LaTeXDrawResources.LABEL_ARC);
        menu.add(menuArc);
        drawMenuGroup.add(menuArc);
        menuArc.setSelected(false);
        
        menuWedge = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_WEDGE, LaTeXDrawResources.wedgeIcon);
        menuWedge.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_W,0));
        menuWedge.setMnemonic(KeyEvent.VK_W);
        menuWedge.addActionListener(ml);
        menuWedge.setActionCommand(LaTeXDrawResources.LABEL_WEDGE);
        menu.add(menuWedge);
        drawMenuGroup.add(menuWedge);
        menuWedge.setSelected(false);
        
        menuChord = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_CHORD, LaTeXDrawResources.chordIcon);
        menuChord.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O,0));
        menuChord.setMnemonic(KeyEvent.VK_O);
        menuChord.addActionListener(ml);
        menuChord.setActionCommand(LaTeXDrawResources.LABEL_CHORD);
        menu.add(menuChord);
        drawMenuGroup.add(menuChord);
        menuChord.setSelected(false);
        
        menuBezierCurve = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_BEZIER_CURVE, LaTeXDrawResources.bezierCurveIcon);
        menuBezierCurve.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_B,0));
        menuBezierCurve.setMnemonic(KeyEvent.VK_B);
        menuBezierCurve.addActionListener(ml);
        menuBezierCurve.setActionCommand(LaTeXDrawResources.LABEL_BEZIER_CURVE);
        menu.add(menuBezierCurve);
        drawMenuGroup.add(menuBezierCurve);
        menuBezierCurve.setSelected(false);
        
        menuClosedBezierCurve = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_CLOSED_BEZIER_CURVE, LaTeXDrawResources.closedBezierIcon);
        menuClosedBezierCurve.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V,0));
        menuClosedBezierCurve.setMnemonic(KeyEvent.VK_B);
        menuClosedBezierCurve.addActionListener(ml);
        menuClosedBezierCurve.setActionCommand(LaTeXDrawResources.LABEL_CLOSED_BEZIER_CURVE);
        menu.add(menuClosedBezierCurve);
        drawMenuGroup.add(menuClosedBezierCurve);
        menuClosedBezierCurve.setSelected(false);
        
        menuGrid = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_GRID, LaTeXDrawResources.gridIcon);
        menuGrid.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_G,0));
        menuGrid.setMnemonic(KeyEvent.VK_G);
        menuGrid.addActionListener(ml);
        menuGrid.setActionCommand(LaTeXDrawResources.LABEL_GRID);
        menu.add(menuGrid);
        drawMenuGroup.add(menuGrid);
        menuGrid.setSelected(false);
        
        menuAxes = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_AXES, LaTeXDrawResources.axesIcon);
        menuAxes.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Z,0));
        menuAxes.setMnemonic(KeyEvent.VK_Z);
        menuAxes.addActionListener(ml);
        menuAxes.setActionCommand(LaTeXDrawResources.LABEL_AXES);
        menu.add(menuAxes);
        drawMenuGroup.add(menuAxes);
        menuAxes.setSelected(false);
        
        menuPointsAkin = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_POINTS_AKIN, LaTeXDrawResources.pointsAkinIcon);
        menuPointsAkin.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_K,0));
        menuPointsAkin.setMnemonic(KeyEvent.VK_K);
        menuPointsAkin.addActionListener(ml);
        menuPointsAkin.setActionCommand(LaTeXDrawResources.LABEL_POINTS_AKIN);
        menu.add(menuPointsAkin);
        drawMenuGroup.add(menuPointsAkin);
        menuPointsAkin.setSelected(false);
               
        menuText = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_TEXT, LaTeXDrawResources.textIcon);
        menuText.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X,0));
        menuText.setMnemonic(KeyEvent.VK_X);
        menuText.addActionListener(ml);
        menuText.setActionCommand(LaTeXDrawResources.LABEL_TEXT);
        menu.add(menuText);
        drawMenuGroup.add(menuText);
        menuText.setSelected(false);
        
        menuSelect = new JRadioButtonMenuItem(LaTeXDrawResources.LABEL_SELECT_FIGURE, LaTeXDrawResources.selectIcon);
        menuSelect.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F,0));
        menuSelect.addActionListener(ml);
        menuSelect.setActionCommand(LaTeXDrawResources.LABEL_SELECT_FIGURE);
        drawMenu.add(menuSelect);
        drawMenuGroup.add(menuSelect);
        menuSelect.setSelected(true);
        
        deleteFigure = new JMenuItem(LaTeXDrawResources.LABEL_DELETE, LaTeXDrawResources.delIcon);
        deleteFigure.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_DELETE,0));
        deleteFigure.addActionListener(ml);
        deleteFigure.setActionCommand(LaTeXDrawResources.LABEL_DELETE);
        deleteFigure.setEnabled(false);
        drawMenu.add(deleteFigure);
        
        updateToGridMenu = new JMenuItem(DrawPanel.LABEL_UPDATE_TO_GRID, LaTeXDrawResources.emptyIcon);
        updateToGridMenu.setActionCommand(DrawPanel.ACTION_CMD_UPDATETOGRID);
        updateToGridMenu.addActionListener(ml);
        drawMenu.add(updateToGridMenu);
        
        menu = new JMenuItem(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.6"), LaTeXDrawResources.emptyIcon); //$NON-NLS-1$
        menu.setToolTipText(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.7")); //$NON-NLS-1$
		menu.setActionCommand(MenusListener.ACTION_VISIBLE_ALL_FIGURES);
		menu.addActionListener(ml);
		drawMenu.add(menu);
        drawMenu.addSeparator();
        
        propertiesFigureMenu = new JMenuItem(LaTeXDrawResources.LABEL_FIGURE_PROPERTIES, LaTeXDrawResources.propertiesIcon);
        propertiesFigureMenu.addActionListener(ml);
        propertiesFigureMenu.setActionCommand(LaTeXDrawResources.LABEL_FIGURE_PROPERTIES);
        propertiesFigureMenu.setEnabled(false);
        drawMenu.add(propertiesFigureMenu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_DRAW_PROPERTIES, LaTeXDrawResources.drawingPropIcon);
        menu.addActionListener(parentFrame);
        menu.setActionCommand(LaTeXDrawResources.LABEL_DRAW_PROPERTIES);
        drawMenu.add(menu);
        
        drawMenu.addSeparator();
        
        displayBorders = new JCheckBoxMenuItem(LaTeXDrawResources.LABEL_DISPLAY_BORDERS, LaTeXDrawResources.bordersIcon);
        displayBorders.addActionListener(ml);
        displayBorders.setActionCommand(LaTeXDrawResources.LABEL_DISPLAY_BORDERS);
        displayBorders.setSelected(false);
        drawMenu.add(displayBorders);
        
        autoAdjustBorders = new JCheckBoxMenuItem(LaTeXDrawResources.LABEL_AUTO_ADJUST_BORDERS, LaTeXDrawResources.autoBordersIcon);
        autoAdjustBorders.addActionListener(ml);
        autoAdjustBorders.setActionCommand(LaTeXDrawResources.LABEL_AUTO_ADJUST_BORDERS);
        autoAdjustBorders.setSelected(true);
        drawMenu.add(autoAdjustBorders);
        
        
        displayXScale = new JCheckBoxMenuItem(LaTeXDrawResources.LABEL_DISPLAY_XSCALE, LaTeXDrawResources.emptyIcon);
        displayXScale.addActionListener(ml);
        displayXScale.setActionCommand(LaTeXDrawResources.LABEL_DISPLAY_XSCALE);
        displayXScale.setSelected(LaTeXDrawFrame.DEFAULT_DISPLAY_XSCALE);
        displayM.add(displayXScale);
        
        displayYScale = new JCheckBoxMenuItem(LaTeXDrawResources.LABEL_DISPLAY_YSCALE, LaTeXDrawResources.emptyIcon);
        displayYScale.addActionListener(ml);
        displayYScale.setActionCommand(LaTeXDrawResources.LABEL_DISPLAY_YSCALE);
        displayYScale.setSelected(LaTeXDrawFrame.DEFAULT_DISPLAY_YSCALE);
        displayM.add(displayYScale);
        
        JMenu menuGrill = new JMenu(LaTeXDrawLang.getDialogFrameString("PreferencesFrame.grid"));  //$NON-NLS-1$
        menuGrill.setIcon(LaTeXDrawResources.displayGridIcon);
        
        displayGrid = new JCheckBoxMenuItem(LaTeXDrawResources.LABEL_DISPLAY_GRID, LaTeXDrawResources.emptyIcon);
        displayGrid.setToolTipText(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.10")); //$NON-NLS-1$
        displayGrid.addActionListener(parentFrame);
        displayGrid.setActionCommand(LaTeXDrawResources.LABEL_DISPLAY_GRID);
        displayGrid.setSelected(LaTeXDrawFrame.DEFAULT_DISPLAY_GRID && MagneticGrid.DEFAULT_TYPE!=MagneticGrid.TYPE_PERSONAL);
        menuGrill.add(displayGrid);
        displayM.add(menuGrill);
        
        displayPersoGrid = new JCheckBoxMenuItem(LaTeXDrawResources.LABEL_DISPLAY_PERSO_GRID, LaTeXDrawResources.emptyIcon);
        displayPersoGrid.setToolTipText(LaTeXDrawLang.getString1_8("LaTeXDrawFrame.11")); //$NON-NLS-1$
        displayPersoGrid.addActionListener(parentFrame);
        displayPersoGrid.setActionCommand(LaTeXDrawResources.LABEL_DISPLAY_PERSO_GRID);
        displayPersoGrid.setSelected(LaTeXDrawFrame.DEFAULT_DISPLAY_GRID && MagneticGrid.DEFAULT_TYPE==MagneticGrid.TYPE_PERSONAL);
        menuGrill.add(displayPersoGrid);
        
        displayCodePanel = new JCheckBoxMenuItem(LaTeXDrawResources.LABEL_DISPLAY_CODE_PANEL, LaTeXDrawResources.emptyIcon);
        displayCodePanel.addActionListener(parentFrame);
        displayCodePanel.setActionCommand(LaTeXDrawResources.LABEL_DISPLAY_CODE_PANEL);
        displayCodePanel.setSelected(LaTeXDrawFrame.DEFAULT_DISPLAY_CODEPANEL);
        displayCodePanel.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E,InputEvent.CTRL_MASK));
        displayM.add(displayCodePanel);
        
        displayM.addSeparator();
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_ZOOM_IN, LaTeXDrawResources.zoomInIcon);
        menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_ADD,0));
        menu.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.94")); //$NON-NLS-1$
        menu.addActionListener(ml);
        menu.setActionCommand(LaTeXDrawResources.LABEL_ZOOM_IN);
        displayM.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_ZOOM_OUT, LaTeXDrawResources.zoomOutIcon);
        menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_SUBTRACT,0));
        menu.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.95")); //$NON-NLS-1$
        menu.addActionListener(ml);
        menu.setActionCommand(LaTeXDrawResources.LABEL_ZOOM_OUT);
        displayM.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_ZOOM_DEFAULT, LaTeXDrawResources.zoomDefaultIcon);
        menu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F9,0));
        menu.setToolTipText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.96")); //$NON-NLS-1$
        menu.addActionListener(ml);
        menu.setActionCommand(LaTeXDrawResources.LABEL_ZOOM_DEFAULT);
        displayM.add(menu);
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_INSERT_CODE, LaTeXDrawResources.insertPSTricksIcon);
        menu.setToolTipText(LaTeXDrawLang.getString1_6("LaTeXDrawFrame.11"));  //$NON-NLS-1$
        menu.addActionListener(parentFrame);
        menu.setActionCommand(LaTeXDrawResources.LABEL_INSERT_CODE);
        insertMenu.add(menu); 
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_INSERT_PIX, LaTeXDrawResources.insertPicIcon);
        menu.setToolTipText(LaTeXDrawLang.getString1_6("LaTeXDrawFrame.1"));  //$NON-NLS-1$
        menu.addActionListener(ml);
        menu.setActionCommand(LaTeXDrawResources.LABEL_INSERT_PIX);
        insertMenu.add(menu); 
        
        menu = new JMenuItem(LaTeXDrawResources.LABEL_COMMENTS, LaTeXDrawResources.commentIcon); 
        menu.addActionListener(parentFrame);
        menu.setActionCommand(LaTeXDrawResources.LABEL_COMMENTS);
        codeMenu.add(menu);
        
        codeMenu.addSeparator();
        
        menu = new JMenuItem(CodePanel.LABEL_COPY_ALL, LaTeXDrawResources.copyIcon);
        menu.addActionListener(parentFrame.getCodePanel());
        menu.setActionCommand(CodePanel.LABEL_COPY_ALL);
        codeMenu.add(menu);
        
        codeMenu.addSeparator();
        
        menuAutoUpdate = new JCheckBoxMenuItem(CodePanel.LABEL_AUTO_UPDATE, LaTeXDrawResources.emptyIcon);
        menuAutoUpdate.addActionListener(parentFrame.getCodePanel());
        menuAutoUpdate.setToolTipText(LaTeXDrawLang.getOthersString("CodePanel.tip")); //$NON-NLS-1$
        menuAutoUpdate.setActionCommand(CodePanel.LABEL_AUTO_UPDATE);
        menuAutoUpdate.setSelected(CodePanel.DEFAULT_AUTO_UPDATE);
        codeMenu.add(menuAutoUpdate);
        
        menuReloadCode = new JMenuItem(CodePanel.LABEL_RELOAD, LaTeXDrawResources.reloadIcon);
        menuReloadCode.addActionListener(parentFrame.getCodePanel());
        menuReloadCode.setToolTipText(LaTeXDrawLang.getOthersString("CodePanel.updateCode")); //$NON-NLS-1$
        menuReloadCode.setActionCommand(CodePanel.LABEL_RELOAD);
        menuReloadCode.setSelected(!CodePanel.DEFAULT_AUTO_UPDATE);
        codeMenu.add(menuReloadCode);
        
        add(fileMenu);
        add(editMenu);
        add(displayM);
        add(drawMenu);
        add(insertMenu);
        add(codeMenu);
        add(helpMenu);  
	}

	
	
    /**
     * Allows to create the menu "template".
     * @return The menu template.
     */
    private JMenu createTemplateMenu()
    {
		try
		{
	        menuTemplate = new MenuTemplate(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.103"), parentFrame); //$NON-NLS-1$
	        menuTemplate.setIcon(LaTeXDrawResources.emptyIcon);
	        
		}catch(Exception e)
		{
			parentFrame.setStatusBarText(LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.105")); //$NON-NLS-1$
			e.printStackTrace();
			ExceptionFrameDialog.showExceptionDialog(e);
		}
    	return menuTemplate;
    }

	/**
	 * @return the menuTemplate.
	 * @since 2.0.0
	 */
	public MenuTemplate getMenuTemplate()
	{
		return menuTemplate;
	}

	/**
	 * @return the cutMenu.
	 * @since 2.0.0
	 */
	public JMenuItem getCutMenu()
	{
		return cutMenu;
	}

	/**
	 * @return the pasteMenu.
	 * @since 2.0.0
	 */
	public JMenuItem getPasteMenu()
	{
		return pasteMenu;
	}

	/**
	 * @return the copyMenu.
	 * @since 2.0.0
	 */
	public JMenuItem getCopyMenu()
	{
		return copyMenu;
	}

	/**
	 * @return the exportTemplateMenu.
	 * @since 2.0.0
	 */
	public JMenuItem getExportTemplateMenu()
	{
		return exportTemplateMenu;
	}

	/**
	 * @return the undoMenu.
	 * @since 2.0.0
	 */
	public JMenuItem getUndoMenu()
	{
		return undoMenu;
	}

	/**
	 * @return the redoMenu.
	 * @since 2.0.0
	 */
	public JMenuItem getRedoMenu()
	{
		return redoMenu;
	}

	/**
	 * @return the exportAsMenu.
	 * @since 2.0.0
	 */
	public JMenu getExportAsMenu()
	{
		return exportAsMenu;
	}

	/**
	 * @return the recentFilesMenu.
	 * @since 2.0.0
	 */
	public JMenu getRecentFilesMenu()
	{
		return recentFilesMenu;
	}

	/**
	 * @return the drawMenu.
	 * @since 2.0.0
	 */
	public JMenu getDrawMenu()
	{
		return drawMenu;
	}

	/**
	 * @return the preferencesMenu.
	 * @since 2.0.0
	 */
	public JMenuItem getPreferencesMenu()
	{
		return preferencesMenu;
	}

	/**
	 * @return the propertiesFigureMenu.
	 * @since 2.0.0
	 */
	public JMenuItem getPropertiesFigureMenu()
	{
		return propertiesFigureMenu;
	}

	/**
	 * @return the deleteFigure.
	 * @since 2.0.0
	 */
	public JMenuItem getDeleteFigure()
	{
		return deleteFigure;
	}

	/**
	 * @return the displayBorders.
	 * @since 2.0.0
	 */
	public JCheckBoxMenuItem getDisplayBorders()
	{
		return displayBorders;
	}

	/**
	 * @return the displayXScale.
	 * @since 2.0.0
	 */
	public JCheckBoxMenuItem getDisplayXScale()
	{
		return displayXScale;
	}

	/**
	 * @return the displayYScale.
	 * @since 2.0.0
	 */
	public JCheckBoxMenuItem getDisplayYScale()
	{
		return displayYScale;
	}

	/**
	 * @return the displayGrid.
	 * @since 2.0.0
	 */
	public JCheckBoxMenuItem getDisplayGrid()
	{
		return displayGrid;
	}

	/**
	 * @return the displayPersoGrid.
	 * @since 2.0.0
	 */
	public JCheckBoxMenuItem getDisplayPersoGrid()
	{
		return displayPersoGrid;
	}

	/**
	 * @return the displayCodePanel.
	 * @since 2.0.0
	 */
	public JCheckBoxMenuItem getDisplayCodePanel()
	{
		return displayCodePanel;
	}

	/**
	 * @return the autoAdjustBorders.
	 * @since 2.0.0
	 */
	public JCheckBoxMenuItem getAutoAdjustBorders()
	{
		return autoAdjustBorders;
	}

	/**
	 * @return the menuPoly.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuPoly()
	{
		return menuPoly;
	}

	/**
	 * @return the menuLine.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuLine()
	{
		return menuLine;
	}

	/**
	 * @return the menuRect.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuRect()
	{
		return menuRect;
	}

	/**
	 * @return the menuSquare.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuSquare()
	{
		return menuSquare;
	}

	/**
	 * @return the menuDot.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuDot()
	{
		return menuDot;
	}

	/**
	 * @return the menuRhombus.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuRhombus()
	{
		return menuRhombus;
	}

	/**
	 * @return the menuTriangle.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuTriangle()
	{
		return menuTriangle;
	}

	/**
	 * @return the menuJoinedLines.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuJoinedLines()
	{
		return menuJoinedLines;
	}

	/**
	 * @return the menuCircle.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuCircle()
	{
		return menuCircle;
	}

	/**
	 * @return the menuAxes.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuAxes()
	{
		return menuAxes;
	}

	/**
	 * @return the menuChord.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuChord()
	{
		return menuChord;
	}

	/**
	 * @return the menuEllipse.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuEllipse()
	{
		return menuEllipse;
	}

	/**
	 * @return the menuBezierCurve.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuBezierCurve()
	{
		return menuBezierCurve;
	}

	/**
	 * @return the menuClosedBezierCurve.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuClosedBezierCurve()
	{
		return menuClosedBezierCurve;
	}

	/**
	 * @return the menuSelect.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuSelect()
	{
		return menuSelect;
	}

	/**
	 * @return the menuArc.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuArc()
	{
		return menuArc;
	}

	/**
	 * @return the menuWedge.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuWedge()
	{
		return menuWedge;
	}

	/**
	 * @return the menuText.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuText()
	{
		return menuText;
	}

	/**
	 * @return the menuPointsAkin.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuPointsAkin()
	{
		return menuPointsAkin;
	}

	/**
	 * @return the menuGrid.
	 * @since 2.0.0
	 */
	public JRadioButtonMenuItem getMenuGrid()
	{
		return menuGrid;
	}

	/**
	 * @return the menuAutoUpdate.
	 * @since 2.0.0
	 */
	public JCheckBoxMenuItem getMenuAutoUpdate()
	{
		return menuAutoUpdate;
	}

	/**
	 * @return the menuReloadCode.
	 * @since 2.0.0
	 */
	public JMenuItem getMenuReloadCode()
	{
		return menuReloadCode;
	}

	/**
	 * @return the updateToGridMenu.
	 * @since 2.0.0
	 */
	public JMenuItem getUpdateToGridMenu()
	{
		return updateToGridMenu;
	}

	/**
	 * @return the parentFrame.
	 * @since 2.0.0
	 */
	public LaTeXDrawFrame getParentFrame()
	{
		return parentFrame;
	}
	
	
	
	/**
	 * Updates the menus related to the grid.
	 * @param displayed Defines if the grid is shown or not.
	 * @param classic Defines if the grid is classic or defined by the user.
	 * @since 2.0.0
	 */
	public void setGridDisplayed(boolean displayed, boolean classic)
	{
		if(displayed)
		{
			displayGrid.setSelected(classic);
			displayPersoGrid.setSelected(!classic);
		}
		else
		{
			displayGrid.setSelected(false);
			displayPersoGrid.setSelected(false);
		}
	}
	
	
	
	/**
	 * Create the menu item of the menu "recent files".
	 * @since 1.9
	 */
	public void updateRecentFilesMenu()
	{
		Vector<String> recentFilesName = parentFrame.getPreferencesFrame().getRecentFilesName();
		recentFilesMenu.removeAll();
		
		for(String fileName : recentFilesName)
		{
			String shortName = fileName.substring(fileName.lastIndexOf(System.getProperty("file.separator"))+1);//$NON-NLS-1$
			JMenuItem menuItem = new JMenuItem(shortName);
			menuItem.setToolTipText(fileName);
			menuItem.addActionListener(parentFrame.getRecentFilesListener());
			menuItem.setActionCommand(RecentFilesListener.RECENT_PREFIX_CMD+fileName);
			recentFilesMenu.add(menuItem);
		}
		
		recentFilesMenu.addSeparator();
		JMenuItem delMenu = new JMenuItem(LaTeXDrawLang.getString1_9("LaTeXDrawFrame.2"), LaTeXDrawResources.delIcon); //$NON-NLS-1$
		delMenu.setActionCommand(RecentFilesListener.ACTION_CMD_RECENT_CLEAR);
		delMenu.addActionListener(parentFrame.getRecentFilesListener());
		recentFilesMenu.add(delMenu);
	}
}
