/* templates.c generated by valac 0.10.3, the Vala compiler
 * generated from templates.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <config.h>
#include <stdio.h>
#include <gtksourceview/gtksourceview.h>
#include <float.h>
#include <math.h>


#define TYPE_TEMPLATES (templates_get_type ())
#define TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPLATES, Templates))
#define TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPLATES, TemplatesClass))
#define IS_TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPLATES))
#define IS_TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPLATES))
#define TEMPLATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPLATES, TemplatesClass))

typedef struct _Templates Templates;
typedef struct _TemplatesClass TemplatesClass;
typedef struct _TemplatesPrivate TemplatesPrivate;

#define TEMPLATES_TYPE_TEMPLATE_COLUMN (templates_template_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define __g_list_free_gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_gtk_tree_path_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block8Data Block8Data;

struct _Templates {
	GObject parent_instance;
	TemplatesPrivate * priv;
};

struct _TemplatesClass {
	GObjectClass parent_class;
};

struct _TemplatesPrivate {
	GtkListStore* default_store;
	GtkListStore* personnal_store;
	gint nb_personnal_templates;
	char* rc_file;
	char* rc_dir;
};

typedef enum  {
	TEMPLATES_TEMPLATE_COLUMN_PIXBUF,
	TEMPLATES_TEMPLATE_COLUMN_ICON_ID,
	TEMPLATES_TEMPLATE_COLUMN_NAME,
	TEMPLATES_TEMPLATE_COLUMN_CONTENTS,
	TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS
} TemplatesTemplateColumn;

struct _Block8Data {
	int _ref_count_;
	Templates * self;
	GtkIconView* icon_view_default_templates;
	GtkIconView* icon_view_personnal_templates;
};


static Templates* templates_templates;
static Templates* templates_templates = NULL;
static gpointer templates_parent_class = NULL;

GType templates_get_type (void) G_GNUC_CONST;
#define TEMPLATES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEMPLATES, TemplatesPrivate))
enum  {
	TEMPLATES_DUMMY_PROPERTY
};
static GType templates_template_column_get_type (void) G_GNUC_UNUSED;
static Templates* templates_new (void);
static Templates* templates_construct (GType object_type);
static void templates_add_template_from_string (Templates* self, GtkListStore* store, const char* name, const char* icon_id, const char* contents);
static void templates_add_template_from_file (Templates* self, GtkListStore* store, const char* name, const char* icon_id, GFile* file);
Templates* templates_get_default (void);
GType main_window_get_type (void) G_GNUC_CONST;
void templates_show_dialog_new (Templates* self, MainWindow* parent);
static GtkIconView* templates_create_icon_view (Templates* self, GtkListStore* store);
static GtkWidget* templates_get_dialog_component (Templates* self, const char* title, GtkWidget* widget);
static void _lambda59_ (Block8Data* _data8_);
static void templates_on_icon_view_selection_changed (Templates* self, GtkIconView* icon_view, GtkIconView* other_icon_view);
static void __lambda59__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void _lambda60_ (Block8Data* _data8_);
static void __lambda60__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self);
static void _g_list_free_gtk_tree_path_free (GList* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
GType document_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
void document_set_contents (Document* self, const char* contents);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
void templates_show_dialog_create (Templates* self, MainWindow* parent);
DocumentTab* main_window_get_active_tab (MainWindow* self);
Document* main_window_get_active_document (MainWindow* self);
static void templates_add_personnal_template (Templates* self, const char* contents);
void templates_show_dialog_delete (Templates* self, MainWindow* parent);
static void templates_save_rc_file (Templates* self);
static void templates_save_contents (Templates* self);
static void templates_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static GType templates_template_column_get_type (void) {
	static volatile gsize templates_template_column_type_id__volatile = 0;
	if (g_once_init_enter (&templates_template_column_type_id__volatile)) {
		static const GEnumValue values[] = {{TEMPLATES_TEMPLATE_COLUMN_PIXBUF, "TEMPLATES_TEMPLATE_COLUMN_PIXBUF", "pixbuf"}, {TEMPLATES_TEMPLATE_COLUMN_ICON_ID, "TEMPLATES_TEMPLATE_COLUMN_ICON_ID", "icon-id"}, {TEMPLATES_TEMPLATE_COLUMN_NAME, "TEMPLATES_TEMPLATE_COLUMN_NAME", "name"}, {TEMPLATES_TEMPLATE_COLUMN_CONTENTS, "TEMPLATES_TEMPLATE_COLUMN_CONTENTS", "contents"}, {TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, "TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType templates_template_column_type_id;
		templates_template_column_type_id = g_enum_register_static ("TemplatesTemplateColumn", values);
		g_once_init_leave (&templates_template_column_type_id__volatile, templates_template_column_type_id);
	}
	return templates_template_column_type_id__volatile;
}


static Templates* templates_construct (GType object_type) {
	Templates * self = NULL;
	GtkListStore* _tmp0_;
	char* _tmp1_;
	GFile* _tmp2_;
	char* _tmp3_;
	GFile* _tmp4_;
	char* _tmp5_;
	GFile* _tmp6_;
	char* _tmp7_;
	GFile* _tmp8_;
	char* _tmp9_;
	GFile* _tmp10_;
	GtkListStore* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	GFile* _tmp14_;
	gboolean _tmp15_;
	GError * _inner_error_ = NULL;
	self = (Templates*) g_object_new (object_type, NULL);
	self->priv->default_store = (_tmp0_ = gtk_list_store_new ((gint) TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING), _g_object_unref0 (self->priv->default_store), _tmp0_);
	templates_add_template_from_string (self, self->priv->default_store, _ ("Empty"), "empty", "");
	templates_add_template_from_file (self, self->priv->default_store, _ ("Article"), "article", _tmp2_ = g_file_new_for_path (_tmp1_ = g_strconcat (DATA_DIR "/templates/", _ ("article-en.tex"), NULL)));
	_g_object_unref0 (_tmp2_);
	_g_free0 (_tmp1_);
	templates_add_template_from_file (self, self->priv->default_store, _ ("Report"), "report", _tmp4_ = g_file_new_for_path (_tmp3_ = g_strconcat (DATA_DIR "/templates/", _ ("report-en.tex"), NULL)));
	_g_object_unref0 (_tmp4_);
	_g_free0 (_tmp3_);
	templates_add_template_from_file (self, self->priv->default_store, _ ("Book"), "book", _tmp6_ = g_file_new_for_path (_tmp5_ = g_strconcat (DATA_DIR "/templates/", _ ("book-en.tex"), NULL)));
	_g_object_unref0 (_tmp6_);
	_g_free0 (_tmp5_);
	templates_add_template_from_file (self, self->priv->default_store, _ ("Letter"), "letter", _tmp8_ = g_file_new_for_path (_tmp7_ = g_strconcat (DATA_DIR "/templates/", _ ("letter-en.tex"), NULL)));
	_g_object_unref0 (_tmp8_);
	_g_free0 (_tmp7_);
	templates_add_template_from_file (self, self->priv->default_store, _ ("Presentation"), "beamer", _tmp10_ = g_file_new_for_path (_tmp9_ = g_strconcat (DATA_DIR "/templates/", _ ("beamer-en.tex"), NULL)));
	_g_object_unref0 (_tmp10_);
	_g_free0 (_tmp9_);
	self->priv->personnal_store = (_tmp11_ = gtk_list_store_new ((gint) TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING), _g_object_unref0 (self->priv->personnal_store), _tmp11_);
	self->priv->nb_personnal_templates = 0;
	self->priv->rc_file = (_tmp12_ = g_build_filename (g_get_user_data_dir (), "latexila", "templatesrc", NULL, NULL), _g_free0 (self->priv->rc_file), _tmp12_);
	self->priv->rc_dir = (_tmp13_ = g_build_filename (g_get_user_data_dir (), "latexila", NULL, NULL), _g_free0 (self->priv->rc_dir), _tmp13_);
	if ((_tmp15_ = !g_file_query_exists (_tmp14_ = g_file_new_for_path (self->priv->rc_file), NULL), _g_object_unref0 (_tmp14_), _tmp15_)) {
		return self;
	}
	{
		GKeyFile* key_file;
		gint names_length1;
		gint _names_size_;
		char** _tmp17_;
		gsize _tmp16_;
		char** names;
		gint icons_length1;
		gint _icons_size_;
		char** _tmp19_;
		gsize _tmp18_;
		char** icons;
		key_file = g_key_file_new ();
		g_key_file_load_from_file (key_file, self->priv->rc_file, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_key_file_free0 (key_file);
			goto __catch7_g_error;
		}
		names = (_tmp17_ = g_key_file_get_string_list (key_file, APP_NAME, "names", &_tmp16_, &_inner_error_), names_length1 = _tmp16_, _names_size_ = names_length1, _tmp17_);
		if (_inner_error_ != NULL) {
			_g_key_file_free0 (key_file);
			goto __catch7_g_error;
		}
		icons = (_tmp19_ = g_key_file_get_string_list (key_file, APP_NAME, "icons", &_tmp18_, &_inner_error_), icons_length1 = _tmp18_, _icons_size_ = icons_length1, _tmp19_);
		if (_inner_error_ != NULL) {
			names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
			_g_key_file_free0 (key_file);
			goto __catch7_g_error;
		}
		self->priv->nb_personnal_templates = names_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp20_;
				_tmp20_ = TRUE;
				while (TRUE) {
					char* _tmp21_;
					GFile* _tmp22_;
					GFile* file;
					if (!_tmp20_) {
						i++;
					}
					_tmp20_ = FALSE;
					if (!(i < self->priv->nb_personnal_templates)) {
						break;
					}
					file = (_tmp22_ = g_file_new_for_path (_tmp21_ = g_strdup_printf ("%s/%d.tex", self->priv->rc_dir, i)), _g_free0 (_tmp21_), _tmp22_);
					if (!g_file_query_exists (file, NULL)) {
						_g_object_unref0 (file);
						continue;
					}
					templates_add_template_from_file (self, self->priv->personnal_store, names[i], icons[i], file);
					_g_object_unref0 (file);
				}
			}
		}
		icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_free0 (key_file);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: load templates failed: %s\n", e->message);
			_g_error_free0 (e);
			return self;
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static Templates* templates_new (void) {
	return templates_construct (TYPE_TEMPLATES);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Templates* templates_get_default (void) {
	Templates* result = NULL;
	if (templates_templates == NULL) {
		Templates* _tmp0_;
		templates_templates = (_tmp0_ = templates_new (), _g_object_unref0 (templates_templates), _tmp0_);
	}
	result = _g_object_ref0 (templates_templates);
	return result;
}


static void _lambda59_ (Block8Data* _data8_) {
	Templates * self;
	self = _data8_->self;
	templates_on_icon_view_selection_changed (self, _data8_->icon_view_default_templates, _data8_->icon_view_personnal_templates);
}


static void __lambda59__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	_lambda59_ (self);
}


static void _lambda60_ (Block8Data* _data8_) {
	Templates * self;
	self = _data8_->self;
	templates_on_icon_view_selection_changed (self, _data8_->icon_view_personnal_templates, _data8_->icon_view_default_templates);
}


static void __lambda60__gtk_icon_view_selection_changed (GtkIconView* _sender, gpointer self) {
	_lambda60_ (self);
}


static void _g_list_free_gtk_tree_path_free (GList* self) {
	g_list_foreach (self, (GFunc) gtk_tree_path_free, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		_g_object_unref0 (_data8_->icon_view_personnal_templates);
		_g_object_unref0 (_data8_->icon_view_default_templates);
		g_slice_free (Block8Data, _data8_);
	}
}


void templates_show_dialog_new (Templates* self, MainWindow* parent) {
	Block8Data* _data8_;
	GtkDialog* dialog;
	GSettings* settings;
	gint w = 0;
	gint h = 0;
	GtkBox* content_area;
	GtkVPaned* vpaned;
	GtkWidget* component;
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	dialog = g_object_ref_sink ((GtkDialog*) gtk_dialog_new_with_buttons (_ ("New File..."), (GtkWindow*) parent, GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL, NULL));
	settings = g_settings_new ("org.gnome.latexila.state.window");
	g_settings_get (settings, "new-file-dialog-size", "(ii)", &w, &h);
	gtk_window_set_default_size ((GtkWindow*) dialog, w, h);
	gtk_widget_set_size_request ((GtkWidget*) dialog, 0, 0);
	content_area = _g_object_ref0 (GTK_BOX (gtk_dialog_get_content_area (dialog)));
	vpaned = g_object_ref_sink ((GtkVPaned*) gtk_vpaned_new ());
	gtk_box_pack_start (content_area, (GtkWidget*) vpaned, TRUE, TRUE, 0);
	gtk_paned_set_position ((GtkPaned*) vpaned, g_settings_get_int (settings, "new-file-dialog-paned-position"));
	_data8_->icon_view_default_templates = templates_create_icon_view (self, self->priv->default_store);
	component = templates_get_dialog_component (self, _ ("Default templates"), (GtkWidget*) _data8_->icon_view_default_templates);
	gtk_paned_pack1 ((GtkPaned*) vpaned, component, TRUE, TRUE);
	_data8_->icon_view_personnal_templates = templates_create_icon_view (self, self->priv->personnal_store);
	component = (_tmp0_ = templates_get_dialog_component (self, _ ("Your personnal templates"), (GtkWidget*) _data8_->icon_view_personnal_templates), _g_object_unref0 (component), _tmp0_);
	gtk_paned_pack2 ((GtkPaned*) vpaned, component, FALSE, TRUE);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (_data8_->icon_view_default_templates, "selection-changed", (GCallback) __lambda59__gtk_icon_view_selection_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	g_signal_connect_data (_data8_->icon_view_personnal_templates, "selection-changed", (GCallback) __lambda60__gtk_icon_view_selection_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	if (gtk_dialog_run (dialog) == GTK_RESPONSE_ACCEPT) {
		GList* selected_items;
		GtkTreeModel* model;
		GtkTreePath* path;
		GtkTreeIter _tmp3_ = {0};
		GtkTreeIter iter;
		char* contents;
		gboolean _tmp4_ = FALSE;
		DocumentTab* tab;
		selected_items = gtk_icon_view_get_selected_items (_data8_->icon_view_default_templates);
		model = _g_object_ref0 (GTK_TREE_MODEL (self->priv->default_store));
		if (g_list_length (selected_items) == 0) {
			GList* _tmp1_;
			GtkTreeModel* _tmp2_;
			selected_items = (_tmp1_ = gtk_icon_view_get_selected_items (_data8_->icon_view_personnal_templates), __g_list_free_gtk_tree_path_free0 (selected_items), _tmp1_);
			model = (_tmp2_ = _g_object_ref0 (GTK_TREE_MODEL (self->priv->personnal_store)), _g_object_unref0 (model), _tmp2_);
		}
		path = _gtk_tree_path_copy0 ((GtkTreePath*) ((GtkTreePath*) g_list_nth_data (selected_items, (guint) 0)));
		iter = (_tmp3_);
		contents = g_strdup ("");
		if (path != NULL) {
			_tmp4_ = gtk_tree_model_get_iter (model, &iter, path);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gtk_tree_model_get (model, &iter, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, &contents, -1, -1);
		}
		tab = main_window_create_tab (parent, TRUE);
		document_set_contents (document_tab_get_document (tab), contents);
		_g_object_unref0 (tab);
		_g_free0 (contents);
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		__g_list_free_gtk_tree_path_free0 (selected_items);
	}
	gtk_window_get_size ((GtkWindow*) dialog, &w, &h);
	g_settings_set (settings, "new-file-dialog-size", "(ii)", w, h);
	g_settings_set_int (settings, "new-file-dialog-paned-position", gtk_paned_get_position ((GtkPaned*) vpaned));
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (component);
	_g_object_unref0 (vpaned);
	_g_object_unref0 (content_area);
	_g_object_unref0 (settings);
	_g_object_unref0 (dialog);
	block8_data_unref (_data8_);
}


static GtkWidget* templates_get_dialog_component (Templates* self, const char* title, GtkWidget* widget) {
	GtkWidget* result = NULL;
	GtkVBox* vbox;
	GtkLabel* label;
	char* _tmp0_;
	char* _tmp1_;
	GtkAlignment* alignment;
	GtkWidget* scrollbar;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (NULL));
	gtk_label_set_markup (label, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("<b>", title, NULL), "</b>", NULL));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	g_object_set ((GtkMisc*) label, "xalign", (float) 0.0, NULL);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) label, FALSE, FALSE, 0);
	alignment = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new ((float) 0.5, (float) 0.5, (float) 1.0, (float) 1.0));
	g_object_set (alignment, "left-padding", (guint) 12, NULL);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) alignment, TRUE, TRUE, 0);
	scrollbar = utils_add_scrollbar (widget);
	gtk_container_add ((GtkContainer*) alignment, scrollbar);
	result = (GtkWidget*) vbox;
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (alignment);
	_g_object_unref0 (label);
	return result;
}


void templates_show_dialog_create (Templates* self, MainWindow* parent) {
	GtkDialog* dialog;
	GtkBox* content_area;
	GtkHBox* hbox;
	GtkLabel* label;
	GtkEntry* entry;
	GtkIconView* icon_view;
	GtkWidget* scrollbar;
	GtkFrame* frame;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (main_window_get_active_tab (parent) != NULL);
	dialog = g_object_ref_sink ((GtkDialog*) gtk_dialog_new_with_buttons (_ ("New Template..."), (GtkWindow*) parent, 0, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL, NULL));
	gtk_window_set_default_size ((GtkWindow*) dialog, 400, 330);
	content_area = _g_object_ref0 (GTK_BOX (gtk_dialog_get_content_area (dialog)));
	hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 5));
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("Name of the new template:")));
	entry = g_object_ref_sink ((GtkEntry*) gtk_entry_new ());
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) entry, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (content_area, (GtkWidget*) hbox, FALSE, FALSE, (guint) 10);
	icon_view = templates_create_icon_view (self, self->priv->default_store);
	scrollbar = utils_add_scrollbar ((GtkWidget*) icon_view);
	frame = g_object_ref_sink ((GtkFrame*) gtk_frame_new (_ ("Choose an icon:")));
	gtk_container_add ((GtkContainer*) frame, scrollbar);
	gtk_box_pack_start (content_area, (GtkWidget*) frame, TRUE, TRUE, (guint) 10);
	gtk_widget_show_all ((GtkWidget*) content_area);
	while (TRUE) {
		GList* selected_items;
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		char* contents;
		GtkTreeModel* model;
		GtkTreePath* path;
		GtkTreeIter iter = {0};
		char* icon_id;
		if (!(gtk_dialog_run (dialog) == GTK_RESPONSE_ACCEPT)) {
			break;
		}
		if (gtk_entry_get_text_length (entry) == 0) {
			continue;
		}
		selected_items = gtk_icon_view_get_selected_items (icon_view);
		if (g_list_length (selected_items) == 0) {
			__g_list_free_gtk_tree_path_free0 (selected_items);
			continue;
		}
		self->priv->nb_personnal_templates++;
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) main_window_get_active_document (parent), &start, &end);
		contents = gtk_text_buffer_get_text ((GtkTextBuffer*) main_window_get_active_document (parent), &start, &end, FALSE);
		model = _g_object_ref0 (GTK_TREE_MODEL (self->priv->default_store));
		path = _gtk_tree_path_copy0 ((GtkTreePath*) g_list_nth_data (selected_items, (guint) 0));
		icon_id = NULL;
		gtk_tree_model_get_iter (model, &iter, path);
		gtk_tree_model_get (model, &iter, TEMPLATES_TEMPLATE_COLUMN_ICON_ID, &icon_id, -1, -1);
		templates_add_template_from_string (self, self->priv->personnal_store, gtk_entry_get_text (entry), icon_id, contents);
		templates_add_personnal_template (self, contents);
		_g_free0 (icon_id);
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		_g_free0 (contents);
		__g_list_free_gtk_tree_path_free0 (selected_items);
		break;
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (frame);
	_g_object_unref0 (scrollbar);
	_g_object_unref0 (icon_view);
	_g_object_unref0 (entry);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
}


void templates_show_dialog_delete (Templates* self, MainWindow* parent) {
	GtkDialog* dialog;
	GtkBox* content_area;
	GtkIconView* icon_view;
	GtkWidget* component;
	gint nb_personnal_templates_before;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	dialog = g_object_ref_sink ((GtkDialog*) gtk_dialog_new_with_buttons (_ ("Delete Template(s)..."), (GtkWindow*) parent, GTK_DIALOG_NO_SEPARATOR, GTK_STOCK_DELETE, GTK_RESPONSE_ACCEPT, GTK_STOCK_OK, GTK_RESPONSE_REJECT, NULL, NULL));
	gtk_window_set_default_size ((GtkWindow*) dialog, 400, 200);
	content_area = _g_object_ref0 (GTK_BOX (gtk_dialog_get_content_area (dialog)));
	icon_view = templates_create_icon_view (self, self->priv->personnal_store);
	gtk_icon_view_set_selection_mode (icon_view, GTK_SELECTION_MULTIPLE);
	component = templates_get_dialog_component (self, _ ("Personnal templates"), (GtkWidget*) icon_view);
	gtk_box_pack_start (content_area, component, TRUE, TRUE, (guint) 10);
	gtk_widget_show_all ((GtkWidget*) content_area);
	nb_personnal_templates_before = self->priv->nb_personnal_templates;
	while (TRUE) {
		GList* selected_items;
		GtkTreeModel* model;
		guint nb_selected_items;
		if (!(gtk_dialog_run (dialog) == GTK_RESPONSE_ACCEPT)) {
			break;
		}
		selected_items = gtk_icon_view_get_selected_items (icon_view);
		model = _g_object_ref0 (GTK_TREE_MODEL (self->priv->personnal_store));
		nb_selected_items = g_list_length (selected_items);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp0_;
				_tmp0_ = TRUE;
				while (TRUE) {
					GtkTreePath* path;
					GtkTreeIter iter = {0};
					if (!_tmp0_) {
						i++;
					}
					_tmp0_ = FALSE;
					if (!(i < nb_selected_items)) {
						break;
					}
					path = _gtk_tree_path_copy0 ((GtkTreePath*) g_list_nth_data (selected_items, (guint) i));
					gtk_tree_model_get_iter (model, &iter, path);
					gtk_list_store_remove (self->priv->personnal_store, &iter);
					_gtk_tree_path_free0 (path);
				}
			}
		}
		self->priv->nb_personnal_templates = self->priv->nb_personnal_templates - ((gint) nb_selected_items);
		_g_object_unref0 (model);
		__g_list_free_gtk_tree_path_free0 (selected_items);
	}
	if (self->priv->nb_personnal_templates != nb_personnal_templates_before) {
		templates_save_rc_file (self);
		templates_save_contents (self);
	}
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (component);
	_g_object_unref0 (icon_view);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
}


static void templates_add_template_from_string (Templates* self, GtkListStore* store, const char* name, const char* icon_id, const char* contents) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (contents != NULL);
	{
		char* _tmp0_;
		char* _tmp1_;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* pixbuf;
		GtkTreeIter iter = {0};
		pixbuf = (_tmp2_ = gdk_pixbuf_new_from_file (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat (DATA_DIR "/images/templates/", icon_id, NULL), ".png", NULL), &_inner_error_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		gtk_list_store_append (store, &iter);
		gtk_list_store_set (store, &iter, TEMPLATES_TEMPLATE_COLUMN_PIXBUF, pixbuf, TEMPLATES_TEMPLATE_COLUMN_ICON_ID, icon_id, TEMPLATES_TEMPLATE_COLUMN_NAME, name, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, contents, -1, -1);
		_g_object_unref0 (pixbuf);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: impossible to load the icon of the template: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void templates_add_template_from_file (Templates* self, GtkListStore* store, const char* name, const char* icon_id, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (file != NULL);
	{
		char* contents;
		char* _tmp0_ = NULL;
		char* _tmp1_;
		contents = NULL;
		g_file_load_contents (file, NULL, &_tmp0_, NULL, NULL, &_inner_error_);
		contents = (_tmp1_ = _tmp0_, _g_free0 (contents), _tmp1_);
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			goto __catch9_g_error;
		}
		templates_add_template_from_string (self, store, name, icon_id, contents);
		_g_free0 (contents);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: impossible to load the template \"%s\": %s\n", name, e->message);
			_g_error_free0 (e);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static GtkIconView* templates_create_icon_view (Templates* self, GtkListStore* store) {
	GtkIconView* result = NULL;
	GtkIconView* icon_view;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	icon_view = g_object_ref_sink ((GtkIconView*) gtk_icon_view_new_with_model ((GtkTreeModel*) store));
	gtk_icon_view_set_selection_mode (icon_view, GTK_SELECTION_SINGLE);
	gtk_icon_view_set_text_column (icon_view, (gint) TEMPLATES_TEMPLATE_COLUMN_NAME);
	gtk_icon_view_set_pixbuf_column (icon_view, (gint) TEMPLATES_TEMPLATE_COLUMN_PIXBUF);
	result = icon_view;
	return result;
}


static void templates_on_icon_view_selection_changed (Templates* self, GtkIconView* icon_view, GtkIconView* other_icon_view) {
	GList* selected_items;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_view != NULL);
	g_return_if_fail (other_icon_view != NULL);
	selected_items = gtk_icon_view_get_selected_items (icon_view);
	if (g_list_length (selected_items) > 0) {
		g_signal_emit_by_name (other_icon_view, "unselect-all");
	}
	__g_list_free_gtk_tree_path_free0 (selected_items);
}


static void templates_add_personnal_template (Templates* self, const char* contents) {
	char* _tmp0_;
	GFile* _tmp1_;
	GFile* file;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	templates_save_rc_file (self);
	file = (_tmp1_ = g_file_new_for_path (_tmp0_ = g_strdup_printf ("%s/%d.tex", self->priv->rc_dir, self->priv->nb_personnal_templates - 1)), _g_free0 (_tmp0_), _tmp1_);
	{
		GFile* parent;
		gboolean _tmp2_ = FALSE;
		parent = g_file_get_parent (file);
		if (parent != NULL) {
			_tmp2_ = !g_file_query_exists (parent, NULL);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch10_g_error;
			}
		}
		g_file_replace_contents (file, contents, strlen (contents), NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch10_g_error;
		}
		_g_object_unref0 (parent);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: impossible to save templates: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
}


static void templates_save_rc_file (Templates* self) {
	gint names_length1;
	gint _names_size_;
	char** _tmp1_;
	char** names;
	gint icons_length1;
	gint _icons_size_;
	char** _tmp2_;
	char** icons;
	GtkTreeIter iter = {0};
	GtkTreeModel* model;
	gboolean valid_iter;
	gint i;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->nb_personnal_templates == 0) {
		{
			GFile* _tmp0_;
			g_file_delete (_tmp0_ = g_file_new_for_path (self->priv->rc_file), NULL, &_inner_error_);
			_g_object_unref0 (_tmp0_);
			if (_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
		}
		goto __finally11;
		__catch11_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (e);
			}
		}
		__finally11:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		return;
	}
	names = (_tmp1_ = g_new0 (char*, self->priv->nb_personnal_templates + 1), names_length1 = self->priv->nb_personnal_templates, _names_size_ = names_length1, _tmp1_);
	icons = (_tmp2_ = g_new0 (char*, self->priv->nb_personnal_templates + 1), icons_length1 = self->priv->nb_personnal_templates, _icons_size_ = icons_length1, _tmp2_);
	model = _g_object_ref0 (GTK_TREE_MODEL (self->priv->personnal_store));
	valid_iter = gtk_tree_model_get_iter_first (model, &iter);
	i = 0;
	while (TRUE) {
		if (!valid_iter) {
			break;
		}
		gtk_tree_model_get (model, &iter, TEMPLATES_TEMPLATE_COLUMN_NAME, &names[i], TEMPLATES_TEMPLATE_COLUMN_ICON_ID, &icons[i], -1, -1);
		valid_iter = gtk_tree_model_iter_next (model, &iter);
		i++;
	}
	{
		GKeyFile* key_file;
		char* key_file_data;
		GFile* file;
		GFile* parent;
		gboolean _tmp3_ = FALSE;
		key_file = g_key_file_new ();
		g_key_file_set_string_list (key_file, APP_NAME, "names", (const gchar* const*) names, names_length1);
		g_key_file_set_string_list (key_file, APP_NAME, "icons", (const gchar* const*) icons, icons_length1);
		key_file_data = g_key_file_to_data (key_file, NULL, NULL);
		file = g_file_new_for_path (self->priv->rc_file);
		parent = g_file_get_parent (file);
		if (parent != NULL) {
			_tmp3_ = !g_file_query_exists (parent, NULL);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				_g_free0 (key_file_data);
				_g_key_file_free0 (key_file);
				goto __catch12_g_error;
			}
		}
		g_file_replace_contents (file, key_file_data, strlen (key_file_data), NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			_g_free0 (key_file_data);
			_g_key_file_free0 (key_file);
			goto __catch12_g_error;
		}
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
		_g_free0 (key_file_data);
		_g_key_file_free0 (key_file);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Warning: impossible to save templates: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (model);
		icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (model);
	icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
}


static void templates_save_contents (Templates* self) {
	char* _tmp0_;
	GtkTreeIter iter = {0};
	GtkTreeModel* model;
	gboolean valid_iter;
	gint i;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	system (_tmp0_ = g_strdup_printf ("rm -f %s/*.tex", self->priv->rc_dir));
	_g_free0 (_tmp0_);
	model = _g_object_ref0 (GTK_TREE_MODEL (self->priv->personnal_store));
	valid_iter = gtk_tree_model_get_iter_first (model, &iter);
	i = 0;
	while (TRUE) {
		char* contents;
		char* _tmp1_;
		GFile* _tmp2_;
		GFile* file;
		if (!valid_iter) {
			break;
		}
		contents = NULL;
		gtk_tree_model_get (model, &iter, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, &contents, -1, -1);
		file = (_tmp2_ = g_file_new_for_path (_tmp1_ = g_strdup_printf ("%s/%d.tex", self->priv->rc_dir, i)), _g_free0 (_tmp1_), _tmp2_);
		{
			GFile* parent;
			gboolean _tmp3_ = FALSE;
			parent = g_file_get_parent (file);
			if (parent != NULL) {
				_tmp3_ = !g_file_query_exists (parent, NULL);
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (parent);
					goto __catch13_g_error;
				}
			}
			g_file_replace_contents (file, contents, strlen (contents), NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				goto __catch13_g_error;
			}
			_g_object_unref0 (parent);
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stderr, "Warning: impossible to save the template: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally13:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_g_free0 (contents);
			_g_object_unref0 (model);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		valid_iter = gtk_tree_model_iter_next (model, &iter);
		i++;
		_g_object_unref0 (file);
		_g_free0 (contents);
	}
	_g_object_unref0 (model);
}


static void templates_class_init (TemplatesClass * klass) {
	templates_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TemplatesPrivate));
	G_OBJECT_CLASS (klass)->finalize = templates_finalize;
}


static void templates_instance_init (Templates * self) {
	self->priv = TEMPLATES_GET_PRIVATE (self);
}


static void templates_finalize (GObject* obj) {
	Templates * self;
	self = TEMPLATES (obj);
	_g_object_unref0 (self->priv->default_store);
	_g_object_unref0 (self->priv->personnal_store);
	_g_free0 (self->priv->rc_file);
	_g_free0 (self->priv->rc_dir);
	G_OBJECT_CLASS (templates_parent_class)->finalize (obj);
}


GType templates_get_type (void) {
	static volatile gsize templates_type_id__volatile = 0;
	if (g_once_init_enter (&templates_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TemplatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) templates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Templates), 0, (GInstanceInitFunc) templates_instance_init, NULL };
		GType templates_type_id;
		templates_type_id = g_type_register_static (G_TYPE_OBJECT, "Templates", &g_define_type_info, 0);
		g_once_init_leave (&templates_type_id__volatile, templates_type_id);
	}
	return templates_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




