/* document_structure.c generated by valac 0.12.1, the Vala compiler
 * generated from document_structure.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
typedef struct _DocumentStructurePrivate DocumentStructurePrivate;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;

#define DOCUMENT_STRUCTURE_TYPE_ENV_DATA (document_structure_env_data_get_type ())

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
typedef struct _DocumentStructureEnvData DocumentStructureEnvData;

#define DOCUMENT_STRUCTURE_TYPE_LOW_LEVEL_TYPE (document_structure_low_level_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _document_structure_env_data_free0(var) ((var == NULL) ? NULL : (var = (document_structure_env_data_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;

#define TYPE_STRUCT_ACTION (struct_action_get_type ())

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

struct _DocumentStructure {
	GObject parent_instance;
	DocumentStructurePrivate * priv;
};

struct _DocumentStructureClass {
	GObjectClass parent_class;
};

typedef enum  {
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_NB_COMMON_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_NB_TYPES
} StructType;

struct _DocumentStructureEnvData {
	GtkTreePath* path;
	StructType type;
	gchar* first_caption;
};

struct _DocumentStructurePrivate {
	Document* _doc;
	gint _nb_marks;
	GtkTextMark* _end_document_mark;
	StructureModel* _model;
	gboolean _in_verbatim_env;
	DocumentStructureEnvData* _last_env_data;
	gint _start_parsing_line;
	GTimer* _timer;
	gboolean _parsing_done;
};

typedef enum  {
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PART,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CHAPTER,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SECTION,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSECTION,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSUBSECTION,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PARAGRAPH,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBPARAGRAPH,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_LABEL,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_INCLUDE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_IMAGE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT,
	DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION
} DocumentStructureLowLevelType;

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;


static gpointer document_structure_parent_class = NULL;
static GRegex* document_structure__chars_regex;
static GRegex* document_structure__chars_regex = NULL;
static GRegex* document_structure__comment_regex;
static GRegex* document_structure__comment_regex = NULL;
static GRegex* document_structure__command_name_regex;
static GRegex* document_structure__command_name_regex = NULL;
static gchar** document_structure__section_names;
static gint document_structure__section_names_length1;
static gchar** document_structure__section_names = NULL;
static gint document_structure__section_names_length1 = 0;
static gint _document_structure__section_names_size_ = 0;

GType document_structure_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType structure_model_get_type (void) G_GNUC_CONST;
static GType document_structure_env_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType struct_type_get_type (void) G_GNUC_CONST;
static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self);
static void document_structure_env_data_free (DocumentStructureEnvData* self);
static void document_structure_env_data_copy (const DocumentStructureEnvData* self, DocumentStructureEnvData* dest);
static void document_structure_env_data_destroy (DocumentStructureEnvData* self);
#define DOCUMENT_STRUCTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_STRUCTURE, DocumentStructurePrivate))
enum  {
	DOCUMENT_STRUCTURE_DUMMY_PROPERTY,
	DOCUMENT_STRUCTURE_PARSING_DONE
};
static GType document_structure_low_level_type_get_type (void) G_GNUC_UNUSED;
#define DOCUMENT_STRUCTURE_MARK_NAME_PREFIX "struct_item_"
#define DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH 60
#define DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE 2000
#define DOCUMENT_STRUCTURE__measure_parsing_time FALSE
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type, Document* doc);
void document_structure_parse (DocumentStructure* self);
static void document_structure_set_parsing_done (DocumentStructure* self, gboolean value);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void document_structure_clear_all_structure_marks (DocumentStructure* self);
static gboolean _lambda6_ (DocumentStructure* self);
static gboolean document_structure_parse_impl (DocumentStructure* self);
static gboolean __lambda6__gsource_func (gpointer self);
StructureModel* document_structure_get_model (DocumentStructure* self);
static gchar* document_structure_get_document_line_contents (DocumentStructure* self, gint line_num);
static gboolean document_structure_search_low_level_item (DocumentStructure* self, const gchar* line, gint start_index, DocumentStructureLowLevelType** type, gchar** contents, gint** start_match_index, gint** end_match_index);
static void document_structure_handle_item (DocumentStructure* self, DocumentStructureLowLevelType type, const gchar* contents, GtkTextIter* iter);
static gint* _int_dup (gint* self);
gboolean utils_char_is_escaped (const gchar* text, glong char_index);
static gboolean document_structure_search_markup (DocumentStructure* self, const gchar* line, gint after_backslash_index, DocumentStructureLowLevelType** type, gchar** contents, gint** end_match_index);
static gboolean document_structure_search_comment (DocumentStructure* self, const gchar* line, gint after_percent_index, DocumentStructureLowLevelType** type, gchar** contents, gint** end_match_index);
static gchar* document_structure_get_markup_name (DocumentStructure* self, const gchar* line, gint after_backslash_index, gint** begin_contents_index);
static gboolean document_structure_search_env (DocumentStructure* self, const gchar* line, gint begin_contents_index, gboolean is_begin_env, DocumentStructureLowLevelType** type, gint** end_match_index);
static DocumentStructureLowLevelType* document_structure_get_markup_low_level_type (DocumentStructure* self, const gchar* markup_name);
static gchar* document_structure_get_markup_contents (DocumentStructure* self, const gchar* line, gint begin_contents_index, gint** end_match_index);
static DocumentStructureLowLevelType* _document_structure_low_level_type_dup (DocumentStructureLowLevelType* self);
static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self, const gchar* line, gint start_index, gint* begin_contents_index);
static gchar* document_structure_truncate (DocumentStructure* self, const gchar* text);
static GtkTreeIter* document_structure_add_item (DocumentStructure* self, StructType type, const gchar* text, GtkTextIter* start_iter);
static void document_structure_create_new_environment (DocumentStructure* self, DocumentStructureLowLevelType type, GtkTextIter* start_iter);
static gboolean document_structure_verify_end_environment_type (DocumentStructure* self, DocumentStructureLowLevelType type);
static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self, GtkTextIter* iter);
void structure_model_modify_data (StructureModel* self, GtkTreePath* path, const gchar* text, GtkTextMark* end_mark);
GType struct_data_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self, StructData* dest);
void struct_data_destroy (StructData* self);
static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self, StructData* data);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self, StructData* item);
GType struct_action_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
void document_structure_do_action (DocumentStructure* self, StructAction action_type, GtkTreeIter* tree_iter, gboolean* refresh_simple_list, GError** error);
static gboolean document_structure_comment_item (DocumentStructure* self, GtkTreeIter* tree_iter);
void structure_model_delete (StructureModel* self, GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self, GtkTreeIter* iter);
static gboolean document_structure_shift_item (DocumentStructure* self, GtkTreeIter* tree_iter, gboolean shift_right, gboolean* doc_modified);
void structure_model_shift_right (StructureModel* self, GtkTreeIter* iter);
void structure_model_shift_left (StructureModel* self, GtkTreeIter* iter);
static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self, GtkTreeIter* tree_iter, GtkTextIter** start_iter, GtkTextIter** end_iter);
static void document_structure_backward_indentation (DocumentStructure* self, GtkTextIter** iter);
GType struct_column_get_type (void) G_GNUC_CONST;
static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self);
gboolean structure_is_section (StructType type);
void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self, GtkTreeIter* section_iter, GError** error);
static void document_structure_get_end_document_iter (DocumentStructure* self, gboolean* end_of_file, GtkTextIter* result);
static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self, StructType item_type, const gchar* item_contents, GtkTextIter* start_match_iter, gboolean is_start, GtkTextIter** end_match_iter);
static gboolean _int_equal (const gint* s1, const gint* s2);
static gboolean document_structure_same_items (DocumentStructure* self, StructType item_type, const gchar* item_contents, DocumentStructureLowLevelType item_found_type, const gchar* item_found_contents, gboolean start);
static gchar* document_structure_get_section_name_from_type (DocumentStructure* self, StructType type);
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
gboolean document_structure_get_parsing_done (DocumentStructure* self);
static void document_structure_finalize (GObject* obj);
static void _vala_document_structure_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_document_structure_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType document_structure_low_level_type_get_type (void) {
	static volatile gsize document_structure_low_level_type_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_low_level_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PART, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PART", "part"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CHAPTER, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CHAPTER", "chapter"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SECTION, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SECTION", "section"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSECTION, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSECTION", "subsection"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSUBSECTION, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSUBSECTION", "subsubsection"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PARAGRAPH, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PARAGRAPH", "paragraph"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBPARAGRAPH, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBPARAGRAPH", "subparagraph"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_LABEL, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_LABEL", "label"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_INCLUDE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_INCLUDE", "include"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_IMAGE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_IMAGE", "image"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO", "todo"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME", "fixme"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES", "nb-common-types"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE", "begin-figure"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE", "end-figure"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE", "begin-table"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE", "end-table"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM", "begin-verbatim"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM", "end-verbatim"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT", "end-document"}, {DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION, "DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION", "caption"}, {0, NULL, NULL}};
		GType document_structure_low_level_type_type_id;
		document_structure_low_level_type_type_id = g_enum_register_static ("DocumentStructureLowLevelType", values);
		g_once_init_leave (&document_structure_low_level_type_type_id__volatile, document_structure_low_level_type_type_id);
	}
	return document_structure_low_level_type_type_id__volatile;
}


DocumentStructure* document_structure_construct (GType object_type, Document* doc) {
	DocumentStructure * self = NULL;
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* _tmp4_ = NULL;
	GRegex* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (DocumentStructure*) g_object_new (object_type, NULL);
	self->priv->_doc = doc;
	if (document_structure__chars_regex != NULL) {
		return self;
	}
	_tmp0_ = g_regex_new ("\\\\|%", 0, 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch59_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (document_structure__chars_regex);
	document_structure__chars_regex = _tmp1_;
	_tmp2_ = g_regex_new ("^(?P<type>TODO|FIXME)\\s+:?\\s*(?P<text>.*)$", G_REGEX_OPTIMIZE, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch59_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (document_structure__comment_regex);
	document_structure__comment_regex = _tmp3_;
	_tmp4_ = g_regex_new ("^(?P<name>[a-z]+\\*?)\\s*(\\[|{)", G_REGEX_OPTIMIZE, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch59_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_regex_unref0 (document_structure__command_name_regex);
	document_structure__command_name_regex = _tmp5_;
	goto __finally59;
	__catch59_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("document_structure.vala:111: Structure: %s", e->message);
		_g_error_free0 (e);
	}
	__finally59:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


DocumentStructure* document_structure_new (Document* doc) {
	return document_structure_construct (TYPE_DOCUMENT_STRUCTURE, doc);
}


static gboolean _lambda6_ (DocumentStructure* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	_tmp0_ = document_structure_parse_impl (self);
	result = _tmp0_;
	return result;
}


static gboolean __lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda6_ (self);
	return result;
}


void document_structure_parse (DocumentStructure* self) {
	StructureModel* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	document_structure_set_parsing_done (self, FALSE);
	_tmp0_ = structure_model_new ();
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	_g_object_unref0 (self->priv->_end_document_mark);
	self->priv->_end_document_mark = NULL;
	document_structure_clear_all_structure_marks (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda6__gsource_func, g_object_ref (self), g_object_unref);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


StructureModel* document_structure_get_model (DocumentStructure* self) {
	StructureModel* result = NULL;
	StructureModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->_model);
	result = _tmp0_;
	return result;
}


/*************************************************************************/
static gboolean document_structure_parse_impl (DocumentStructure* self) {
	gboolean result = FALSE;
	gint cur_line;
	gint _tmp1_;
	gint nb_lines;
	gint stop_parsing_line;
	g_return_val_if_fail (self != NULL, FALSE);
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		if (self->priv->_timer == NULL) {
			GTimer* _tmp0_ = NULL;
			_tmp0_ = g_timer_new ();
			_g_timer_destroy0 (self->priv->_timer);
			self->priv->_timer = _tmp0_;
		} else {
			g_timer_continue (self->priv->_timer);
		}
	}
	cur_line = self->priv->_start_parsing_line;
	_tmp1_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self->priv->_doc);
	nb_lines = _tmp1_;
	stop_parsing_line = self->priv->_start_parsing_line + DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE;
	while (TRUE) {
		gchar* _tmp2_ = NULL;
		gchar* line;
		gint start_index;
		gint _tmp3_;
		gint line_length;
		if (!(cur_line < nb_lines)) {
			break;
		}
		if (cur_line == stop_parsing_line) {
			self->priv->_start_parsing_line = cur_line;
			if (DOCUMENT_STRUCTURE__measure_parsing_time) {
				g_timer_stop (self->priv->_timer);
			}
			result = TRUE;
			return result;
		}
		_tmp2_ = document_structure_get_document_line_contents (self, cur_line);
		line = _tmp2_;
		start_index = 0;
		_tmp3_ = strlen (line);
		line_length = _tmp3_;
		while (TRUE) {
			DocumentStructureLowLevelType* type = NULL;
			gchar* contents = NULL;
			gint* start_match_index = NULL;
			gint* end_match_index = NULL;
			DocumentStructureLowLevelType* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gint* _tmp6_ = NULL;
			gint* _tmp7_ = NULL;
			gboolean _tmp8_;
			gboolean item_found;
			GtkTextIter iter = {0};
			GtkTextIter _tmp9_ = {0};
			if (!(start_index < line_length)) {
				break;
			}
			_tmp8_ = document_structure_search_low_level_item (self, line, start_index, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
			_g_free0 (type);
			type = _tmp4_;
			_g_free0 (contents);
			contents = _tmp5_;
			_g_free0 (start_match_index);
			start_match_index = _tmp6_;
			_g_free0 (end_match_index);
			end_match_index = _tmp7_;
			item_found = _tmp8_;
			if (!item_found) {
				_g_free0 (end_match_index);
				_g_free0 (start_match_index);
				_g_free0 (contents);
				_g_free0 (type);
				break;
			}
			gtk_text_buffer_get_iter_at_line_index ((GtkTextBuffer*) self->priv->_doc, &_tmp9_, cur_line, *start_match_index);
			iter = _tmp9_;
			document_structure_handle_item (self, *type, contents, &iter);
			start_index = *end_match_index;
			_g_free0 (end_match_index);
			_g_free0 (start_match_index);
			_g_free0 (contents);
			_g_free0 (type);
		}
		cur_line++;
		_g_free0 (line);
	}
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		gdouble _tmp10_;
		g_timer_stop (self->priv->_timer);
		_tmp10_ = g_timer_elapsed (self->priv->_timer, NULL);
		g_message ("document_structure.vala:203: Structure parsing took %f seconds", _tmp10_);
		g_timer_reset (self->priv->_timer);
	}
	document_structure_set_parsing_done (self, TRUE);
	result = FALSE;
	return result;
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static gboolean document_structure_search_low_level_item (DocumentStructure* self, const gchar* line, gint start_index, DocumentStructureLowLevelType** type, gchar** contents, gint** start_match_index, gint** end_match_index) {
	DocumentStructureLowLevelType* _type = NULL;
	gchar* _contents = NULL;
	gint* _start_match_index = NULL;
	gint* _end_match_index = NULL;
	gboolean result = FALSE;
	GMatchInfo* match_info = NULL;
	GMatchInfo* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	g_regex_match_full (document_structure__chars_regex, line, (gssize) (-1), start_index, 0, &_tmp0_, &_inner_error_);
	_g_match_info_free0 (match_info);
	match_info = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch60_g_error;
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("document_structure.vala:230: Structure parsing: chars regex: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_match_info_free0 (match_info);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (contents) {
			*contents = _contents;
		} else {
			_g_free0 (_contents);
		}
		if (start_match_index) {
			*start_match_index = _start_match_index;
		} else {
			_g_free0 (_start_match_index);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	__finally60:
	if (_inner_error_ != NULL) {
		_g_match_info_free0 (match_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	while (TRUE) {
		gboolean _tmp1_;
		gint after_char_index = 0;
		gint _tmp2_;
		gint _tmp3_;
		gboolean _tmp4_;
		gint* _tmp5_;
		gboolean _tmp6_;
		_tmp1_ = g_match_info_matches (match_info);
		if (!_tmp1_) {
			break;
		}
		_tmp4_ = g_match_info_fetch_pos (match_info, 0, &_tmp2_, &_tmp3_);
		_g_free0 (_start_match_index);
		_tmp5_ = __int_dup0 (&_tmp2_);
		_start_match_index = _tmp5_;
		after_char_index = _tmp3_;
		if (!_tmp4_) {
			g_warning ("document_structure.vala:239: Structure parsing: position can not be fe" \
"tched");
			result = FALSE;
			_g_match_info_free0 (match_info);
			if (type) {
				*type = _type;
			} else {
				_g_free0 (_type);
			}
			if (contents) {
				*contents = _contents;
			} else {
				_g_free0 (_contents);
			}
			if (start_match_index) {
				*start_match_index = _start_match_index;
			} else {
				_g_free0 (_start_match_index);
			}
			if (end_match_index) {
				*end_match_index = _end_match_index;
			} else {
				_g_free0 (_end_match_index);
			}
			return result;
		}
		_tmp6_ = utils_char_is_escaped (line, *_start_match_index);
		if (!_tmp6_) {
			gchar* _tmp7_ = NULL;
			gchar* char_matched;
			_tmp7_ = g_match_info_fetch (match_info, 0);
			char_matched = _tmp7_;
			if (g_strcmp0 (char_matched, "\\") == 0) {
				DocumentStructureLowLevelType* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gint* _tmp10_ = NULL;
				gboolean _tmp11_;
				gboolean markup_found;
				_tmp11_ = document_structure_search_markup (self, line, after_char_index, &_tmp8_, &_tmp9_, &_tmp10_);
				_g_free0 (_type);
				_type = _tmp8_;
				_g_free0 (_contents);
				_contents = _tmp9_;
				_g_free0 (_end_match_index);
				_end_match_index = _tmp10_;
				markup_found = _tmp11_;
				if (markup_found) {
					result = TRUE;
					_g_free0 (char_matched);
					_g_match_info_free0 (match_info);
					if (type) {
						*type = _type;
					} else {
						_g_free0 (_type);
					}
					if (contents) {
						*contents = _contents;
					} else {
						_g_free0 (_contents);
					}
					if (start_match_index) {
						*start_match_index = _start_match_index;
					} else {
						_g_free0 (_start_match_index);
					}
					if (end_match_index) {
						*end_match_index = _end_match_index;
					} else {
						_g_free0 (_end_match_index);
					}
					return result;
				}
			} else {
				DocumentStructureLowLevelType* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gint* _tmp14_ = NULL;
				gboolean _tmp15_;
				_tmp15_ = document_structure_search_comment (self, line, after_char_index, &_tmp12_, &_tmp13_, &_tmp14_);
				_g_free0 (_type);
				_type = _tmp12_;
				_g_free0 (_contents);
				_contents = _tmp13_;
				_g_free0 (_end_match_index);
				_end_match_index = _tmp14_;
				result = _tmp15_;
				_g_free0 (char_matched);
				_g_match_info_free0 (match_info);
				if (type) {
					*type = _type;
				} else {
					_g_free0 (_type);
				}
				if (contents) {
					*contents = _contents;
				} else {
					_g_free0 (_contents);
				}
				if (start_match_index) {
					*start_match_index = _start_match_index;
				} else {
					_g_free0 (_start_match_index);
				}
				if (end_match_index) {
					*end_match_index = _end_match_index;
				} else {
					_g_free0 (_end_match_index);
				}
				return result;
			}
			_g_free0 (char_matched);
		}
		g_match_info_next (match_info, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch61_g_regex_error;
			}
			_g_match_info_free0 (match_info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		goto __finally61;
		__catch61_g_regex_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("document_structure.vala:275: Structure parsing: %s", e->message);
			_g_error_free0 (e);
			break;
		}
		__finally61:
		if (_inner_error_ != NULL) {
			_g_match_info_free0 (match_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = FALSE;
	_g_match_info_free0 (match_info);
	if (type) {
		*type = _type;
	} else {
		_g_free0 (_type);
	}
	if (contents) {
		*contents = _contents;
	} else {
		_g_free0 (_contents);
	}
	if (start_match_index) {
		*start_match_index = _start_match_index;
	} else {
		_g_free0 (_start_match_index);
	}
	if (end_match_index) {
		*end_match_index = _end_match_index;
	} else {
		_g_free0 (_end_match_index);
	}
	return result;
}


static gboolean document_structure_search_markup (DocumentStructure* self, const gchar* line, gint after_backslash_index, DocumentStructureLowLevelType** type, gchar** contents, gint** end_match_index) {
	DocumentStructureLowLevelType* _type = NULL;
	gchar* _contents = NULL;
	gint* _end_match_index = NULL;
	gboolean result = FALSE;
	gint* begin_contents_index = NULL;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* name;
	gboolean is_begin_env;
	gboolean _tmp2_ = FALSE;
	DocumentStructureLowLevelType* _tmp6_ = NULL;
	gint* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp1_ = document_structure_get_markup_name (self, line, after_backslash_index, &_tmp0_);
	_g_free0 (begin_contents_index);
	begin_contents_index = _tmp0_;
	name = _tmp1_;
	if (name == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (contents) {
			*contents = _contents;
		} else {
			_g_free0 (_contents);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	is_begin_env = g_strcmp0 (name, "begin") == 0;
	if (is_begin_env) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (name, "end") == 0;
	}
	if (_tmp2_) {
		DocumentStructureLowLevelType* _tmp3_ = NULL;
		gint* _tmp4_ = NULL;
		gboolean _tmp5_;
		_g_free0 (_contents);
		_contents = NULL;
		_tmp5_ = document_structure_search_env (self, line, *begin_contents_index, is_begin_env, &_tmp3_, &_tmp4_);
		_g_free0 (_type);
		_type = _tmp3_;
		_g_free0 (_end_match_index);
		_end_match_index = _tmp4_;
		result = _tmp5_;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (contents) {
			*contents = _contents;
		} else {
			_g_free0 (_contents);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	_tmp6_ = document_structure_get_markup_low_level_type (self, name);
	_g_free0 (_type);
	_type = _tmp6_;
	if (_type == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (contents) {
			*contents = _contents;
		} else {
			_g_free0 (_contents);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	_tmp8_ = document_structure_get_markup_contents (self, line, *begin_contents_index, &_tmp7_);
	_g_free0 (_end_match_index);
	_end_match_index = _tmp7_;
	_g_free0 (_contents);
	_contents = _tmp8_;
	result = _contents != NULL;
	_g_free0 (name);
	_g_free0 (begin_contents_index);
	if (type) {
		*type = _type;
	} else {
		_g_free0 (_type);
	}
	if (contents) {
		*contents = _contents;
	} else {
		_g_free0 (_contents);
	}
	if (end_match_index) {
		*end_match_index = _end_match_index;
	} else {
		_g_free0 (_end_match_index);
	}
	return result;
}


static DocumentStructureLowLevelType* _document_structure_low_level_type_dup (DocumentStructureLowLevelType* self) {
	DocumentStructureLowLevelType* dup;
	dup = g_new0 (DocumentStructureLowLevelType, 1);
	memcpy (dup, self, sizeof (DocumentStructureLowLevelType));
	return dup;
}


static gpointer __document_structure_low_level_type_dup0 (gpointer self) {
	return self ? _document_structure_low_level_type_dup (self) : NULL;
}


static gboolean document_structure_search_env (DocumentStructure* self, const gchar* line, gint begin_contents_index, gboolean is_begin_env, DocumentStructureLowLevelType** type, gint** end_match_index) {
	DocumentStructureLowLevelType* _type = NULL;
	gint* _end_match_index = NULL;
	gboolean result = FALSE;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* contents;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp1_ = document_structure_get_markup_contents (self, line, begin_contents_index, &_tmp0_);
	_g_free0 (_end_match_index);
	_end_match_index = _tmp0_;
	contents = _tmp1_;
	if (contents == NULL) {
		result = FALSE;
		_g_free0 (contents);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	if (g_strcmp0 (contents, "verbatim") == 0) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (contents, "verbatim*") == 0;
	}
	if (_tmp2_) {
		DocumentStructureLowLevelType _tmp3_ = 0;
		DocumentStructureLowLevelType* _tmp4_;
		if (is_begin_env) {
			_tmp3_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM;
		} else {
			_tmp3_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM;
		}
		_tmp4_ = __document_structure_low_level_type_dup0 (&_tmp3_);
		_g_free0 (_type);
		_type = _tmp4_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	if (g_strcmp0 (contents, "figure") == 0) {
		DocumentStructureLowLevelType _tmp5_ = 0;
		DocumentStructureLowLevelType* _tmp6_;
		if (is_begin_env) {
			_tmp5_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE;
		} else {
			_tmp5_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE;
		}
		_tmp6_ = __document_structure_low_level_type_dup0 (&_tmp5_);
		_g_free0 (_type);
		_type = _tmp6_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	if (g_strcmp0 (contents, "table") == 0) {
		DocumentStructureLowLevelType _tmp7_ = 0;
		DocumentStructureLowLevelType* _tmp8_;
		if (is_begin_env) {
			_tmp7_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE;
		} else {
			_tmp7_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE;
		}
		_tmp8_ = __document_structure_low_level_type_dup0 (&_tmp7_);
		_g_free0 (_type);
		_type = _tmp8_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	if (g_strcmp0 (contents, "document") == 0) {
		_tmp9_ = !is_begin_env;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		DocumentStructureLowLevelType _tmp10_;
		DocumentStructureLowLevelType* _tmp11_;
		_tmp10_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT;
		_tmp11_ = __document_structure_low_level_type_dup0 (&_tmp10_);
		_g_free0 (_type);
		_type = _tmp11_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	result = FALSE;
	_g_free0 (contents);
	if (type) {
		*type = _type;
	} else {
		_g_free0 (_type);
	}
	if (end_match_index) {
		*end_match_index = _end_match_index;
	} else {
		_g_free0 (_end_match_index);
	}
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* document_structure_get_markup_name (DocumentStructure* self, const gchar* line, gint after_backslash_index, gint** begin_contents_index) {
	gint* _begin_contents_index = NULL;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* after_backslash_text;
	GMatchInfo* match_info = NULL;
	GMatchInfo* _tmp1_ = NULL;
	gboolean _tmp2_;
	gint pos = 0;
	gint _tmp3_;
	gint begin_first_arg_index;
	gchar* _tmp4_ = NULL;
	gchar* markup_name;
	gint _tmp5_;
	gboolean _tmp6_;
	gint* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = string_substring (line, (glong) after_backslash_index, (glong) (-1));
	after_backslash_text = _tmp0_;
	_tmp2_ = g_regex_match (document_structure__command_name_regex, after_backslash_text, 0, &_tmp1_);
	_g_match_info_free0 (match_info);
	match_info = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_g_match_info_free0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _begin_contents_index;
		} else {
			_g_free0 (_begin_contents_index);
		}
		return result;
	}
	g_match_info_fetch_pos (match_info, 0, NULL, &_tmp3_);
	pos = _tmp3_;
	begin_first_arg_index = after_backslash_index + pos;
	_tmp4_ = g_match_info_fetch_named (match_info, "name");
	markup_name = _tmp4_;
	_tmp6_ = document_structure_search_firt_non_optional_arg (self, line, begin_first_arg_index - 1, &_tmp5_);
	_g_free0 (_begin_contents_index);
	_tmp7_ = __int_dup0 (&_tmp5_);
	_begin_contents_index = _tmp7_;
	if (_tmp6_) {
		result = markup_name;
		_g_match_info_free0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _begin_contents_index;
		} else {
			_g_free0 (_begin_contents_index);
		}
		return result;
	}
	result = NULL;
	_g_free0 (markup_name);
	_g_match_info_free0 (match_info);
	_g_free0 (after_backslash_text);
	if (begin_contents_index) {
		*begin_contents_index = _begin_contents_index;
	} else {
		_g_free0 (_begin_contents_index);
	}
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _c = 0U;
	gboolean result = FALSE;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + (*index));
	_c = _tmp0_;
	if (_c != 0) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp1_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _c;
		}
		return result;
	}
	if (c) {
		*c = _c;
	}
}


static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self, const gchar* line, gint start_index, gint* begin_contents_index) {
	gint _begin_contents_index = 0;
	gboolean result = FALSE;
	gint cur_index;
	gboolean in_optional_arg;
	gint additional_bracket_level;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	cur_index = start_index;
	in_optional_arg = FALSE;
	additional_bracket_level = 0;
	while (TRUE) {
		gint next_index;
		gunichar cur_char = 0U;
		gunichar _tmp0_;
		gboolean _tmp1_;
		gboolean end;
		next_index = cur_index;
		_tmp1_ = string_get_next_char (line, &next_index, &_tmp0_);
		cur_char = _tmp0_;
		end = !_tmp1_;
		if (in_optional_arg) {
			switch (cur_char) {
				case ']':
				{
					gboolean _tmp2_;
					_tmp2_ = utils_char_is_escaped (line, (glong) cur_index);
					if (!_tmp2_) {
						if (0 < additional_bracket_level) {
							additional_bracket_level--;
						} else {
							in_optional_arg = FALSE;
						}
					}
					break;
				}
				case '[':
				{
					gboolean _tmp3_;
					_tmp3_ = utils_char_is_escaped (line, (glong) cur_index);
					if (!_tmp3_) {
						additional_bracket_level++;
					}
					break;
				}
				default:
				break;
			}
		} else {
			switch (cur_char) {
				case '{':
				{
					_begin_contents_index = next_index;
					result = TRUE;
					if (begin_contents_index) {
						*begin_contents_index = _begin_contents_index;
					}
					return result;
				}
				case '[':
				{
					in_optional_arg = TRUE;
					break;
				}
				case ' ':
				case '\t':
				{
					break;
				}
				default:
				{
					result = FALSE;
					if (begin_contents_index) {
						*begin_contents_index = _begin_contents_index;
					}
					return result;
				}
			}
		}
		if (end) {
			result = FALSE;
			if (begin_contents_index) {
				*begin_contents_index = _begin_contents_index;
			}
			return result;
		}
		cur_index = next_index;
	}
	if (begin_contents_index) {
		*begin_contents_index = _begin_contents_index;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	glong string_length;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = (glong) _tmp0_;
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp1_ = start <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	if (end >= 0) {
		_tmp2_ = end <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp3_;
	return result;
}


static gchar* document_structure_get_markup_contents (DocumentStructure* self, const gchar* line, gint begin_contents_index, gint** end_match_index) {
	gint* _end_match_index = NULL;
	gchar* result = NULL;
	gint brace_level;
	gint cur_index;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	brace_level = 0;
	cur_index = begin_contents_index;
	while (TRUE) {
		gint next_index;
		gunichar cur_char = 0U;
		gunichar _tmp0_;
		gboolean _tmp1_;
		gboolean end;
		gboolean _tmp2_ = FALSE;
		next_index = cur_index;
		_tmp1_ = string_get_next_char (line, &next_index, &_tmp0_);
		cur_char = _tmp0_;
		end = !_tmp1_;
		if (cur_char == '{') {
			gboolean _tmp3_;
			_tmp3_ = utils_char_is_escaped (line, (glong) cur_index);
			_tmp2_ = !_tmp3_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			brace_level++;
		} else {
			gboolean _tmp4_ = FALSE;
			if (cur_char == '}') {
				gboolean _tmp5_;
				_tmp5_ = utils_char_is_escaped (line, (glong) cur_index);
				_tmp4_ = !_tmp5_;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				if (brace_level > 0) {
					brace_level--;
				} else {
					gchar* _tmp6_ = NULL;
					gchar* contents;
					gint* _tmp7_;
					_tmp6_ = string_slice (line, (glong) begin_contents_index, (glong) cur_index);
					contents = _tmp6_;
					if (g_strcmp0 (contents, "") == 0) {
						result = NULL;
						_g_free0 (contents);
						if (end_match_index) {
							*end_match_index = _end_match_index;
						} else {
							_g_free0 (_end_match_index);
						}
						return result;
					}
					_tmp7_ = __int_dup0 (&next_index);
					_g_free0 (_end_match_index);
					_end_match_index = _tmp7_;
					result = contents;
					if (end_match_index) {
						*end_match_index = _end_match_index;
					} else {
						_g_free0 (_end_match_index);
					}
					return result;
				}
			}
		}
		if (end) {
			result = NULL;
			if (end_match_index) {
				*end_match_index = _end_match_index;
			} else {
				_g_free0 (_end_match_index);
			}
			return result;
		}
		cur_index = next_index;
	}
	if (end_match_index) {
		*end_match_index = _end_match_index;
	} else {
		_g_free0 (_end_match_index);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean document_structure_search_comment (DocumentStructure* self, const gchar* line, gint after_percent_index, DocumentStructureLowLevelType** type, gchar** contents, gint** end_match_index) {
	DocumentStructureLowLevelType* _type = NULL;
	gchar* _contents = NULL;
	gint* _end_match_index = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* text_after;
	GMatchInfo* match_info = NULL;
	GMatchInfo* _tmp4_ = NULL;
	gboolean _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* type_str;
	DocumentStructureLowLevelType _tmp7_ = 0;
	DocumentStructureLowLevelType* _tmp8_;
	gchar* _tmp9_ = NULL;
	gint _tmp10_;
	gint* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = string_substring (line, (glong) after_percent_index, (glong) (-1));
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	text_after = _tmp3_;
	_tmp5_ = g_regex_match (document_structure__comment_regex, text_after, 0, &_tmp4_);
	_g_match_info_free0 (match_info);
	match_info = _tmp4_;
	if (!_tmp5_) {
		result = FALSE;
		_g_match_info_free0 (match_info);
		_g_free0 (text_after);
		if (type) {
			*type = _type;
		} else {
			_g_free0 (_type);
		}
		if (contents) {
			*contents = _contents;
		} else {
			_g_free0 (_contents);
		}
		if (end_match_index) {
			*end_match_index = _end_match_index;
		} else {
			_g_free0 (_end_match_index);
		}
		return result;
	}
	_tmp6_ = g_match_info_fetch_named (match_info, "type");
	type_str = _tmp6_;
	if (g_strcmp0 (type_str, "TODO") == 0) {
		_tmp7_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO;
	} else {
		_tmp7_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME;
	}
	_tmp8_ = __document_structure_low_level_type_dup0 (&_tmp7_);
	_g_free0 (_type);
	_type = _tmp8_;
	_tmp9_ = g_match_info_fetch_named (match_info, "text");
	_g_free0 (_contents);
	_contents = _tmp9_;
	_tmp10_ = strlen (line);
	_tmp11_ = __int_dup0 (&_tmp10_);
	_g_free0 (_end_match_index);
	_end_match_index = _tmp11_;
	result = TRUE;
	_g_free0 (type_str);
	_g_match_info_free0 (match_info);
	_g_free0 (text_after);
	if (type) {
		*type = _type;
	} else {
		_g_free0 (_type);
	}
	if (contents) {
		*contents = _contents;
	} else {
		_g_free0 (_contents);
	}
	if (end_match_index) {
		*end_match_index = _end_match_index;
	} else {
		_g_free0 (_end_match_index);
	}
	return result;
}


static void document_structure_handle_item (DocumentStructure* self, DocumentStructureLowLevelType type, const gchar* contents, GtkTextIter* iter) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_in_verbatim_env) {
		if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_VERBATIM) {
			self->priv->_in_verbatim_env = FALSE;
		}
		return;
	}
	if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_TODO) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_FIXME;
	}
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GtkTreeIter* _tmp4_ = NULL;
		GtkTreeIter* _tmp5_;
		_tmp1_ = document_structure_truncate (self, contents);
		_tmp2_ = _tmp1_;
		if (_tmp2_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (contents);
			_g_free0 (_tmp2_);
			_tmp2_ = _tmp3_;
		}
		_tmp4_ = document_structure_add_item (self, (StructType) type, _tmp2_, iter);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
	} else {
		if (type < DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES) {
			GtkTreeIter* _tmp6_ = NULL;
			GtkTreeIter* _tmp7_;
			_tmp6_ = document_structure_add_item (self, (StructType) type, contents, iter);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp7_);
		} else {
			if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_VERBATIM) {
				self->priv->_in_verbatim_env = TRUE;
			} else {
				gboolean _tmp8_ = FALSE;
				if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE;
				}
				if (_tmp8_) {
					document_structure_create_new_environment (self, type, iter);
				} else {
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION) {
						_tmp10_ = self->priv->_last_env_data != NULL;
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						_tmp9_ = (*self->priv->_last_env_data).first_caption == NULL;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						gchar* _tmp11_ = NULL;
						gchar* _tmp12_;
						gchar* _tmp14_;
						_tmp11_ = document_structure_truncate (self, contents);
						_tmp12_ = _tmp11_;
						if (_tmp12_ == NULL) {
							gchar* _tmp13_;
							_tmp13_ = g_strdup (contents);
							_g_free0 (_tmp12_);
							_tmp12_ = _tmp13_;
						}
						_tmp14_ = g_strdup (_tmp12_);
						_g_free0 ((*self->priv->_last_env_data).first_caption);
						(*self->priv->_last_env_data).first_caption = _tmp14_;
						_g_free0 (_tmp12_);
					} else {
						gboolean _tmp15_;
						_tmp15_ = document_structure_verify_end_environment_type (self, type);
						if (_tmp15_) {
							GtkTextMark* _tmp16_ = NULL;
							GtkTextMark* end_mark;
							_tmp16_ = document_structure_create_text_mark_from_iter (self, iter);
							end_mark = _tmp16_;
							structure_model_modify_data (self->priv->_model, (*self->priv->_last_env_data).path, (*self->priv->_last_env_data).first_caption, end_mark);
							_document_structure_env_data_free0 (self->priv->_last_env_data);
							self->priv->_last_env_data = NULL;
							_g_object_unref0 (end_mark);
						} else {
							if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_DOCUMENT) {
								GtkTextMark* _tmp17_ = NULL;
								_tmp17_ = document_structure_create_text_mark_from_iter (self, iter);
								_g_object_unref0 (self->priv->_end_document_mark);
								self->priv->_end_document_mark = _tmp17_;
							}
						}
					}
				}
			}
		}
	}
}


static gpointer _document_structure_env_data_dup0 (gpointer self) {
	return self ? document_structure_env_data_dup (self) : NULL;
}


static void document_structure_create_new_environment (DocumentStructure* self, DocumentStructureLowLevelType type, GtkTextIter* start_iter) {
	gboolean _tmp0_ = FALSE;
	DocumentStructureEnvData _tmp1_ = {0};
	DocumentStructureEnvData _tmp2_ = {0};
	DocumentStructureEnvData _tmp3_;
	DocumentStructureEnvData* _tmp4_;
	GtkTreeIter* _tmp5_ = NULL;
	GtkTreeIter* _tmp6_;
	GtkTreeIter _tmp7_;
	GtkTreeIter tree_iter;
	GtkTreePath* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE;
	}
	g_return_if_fail (_tmp0_);
	memset (&_tmp1_, 0, sizeof (DocumentStructureEnvData));
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _document_structure_env_data_dup0 (&_tmp3_);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = _tmp4_;
	document_structure_env_data_destroy (&_tmp3_);
	_g_free0 ((*self->priv->_last_env_data).first_caption);
	(*self->priv->_last_env_data).first_caption = NULL;
	if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE) {
		(*self->priv->_last_env_data).type = STRUCT_TYPE_TABLE;
	} else {
		(*self->priv->_last_env_data).type = STRUCT_TYPE_FIGURE;
	}
	_tmp5_ = document_structure_add_item (self, (*self->priv->_last_env_data).type, NULL, start_iter);
	_tmp6_ = _tmp5_;
	_tmp7_ = *_tmp6_;
	_g_free0 (_tmp6_);
	tree_iter = _tmp7_;
	_tmp8_ = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->_model, &tree_iter);
	_gtk_tree_path_free0 ((*self->priv->_last_env_data).path);
	(*self->priv->_last_env_data).path = _tmp8_;
}


static gboolean document_structure_verify_end_environment_type (DocumentStructure* self, DocumentStructureLowLevelType type) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_last_env_data == NULL) {
		result = FALSE;
		return result;
	}
	if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE) {
		result = (*self->priv->_last_env_data).type == STRUCT_TYPE_TABLE;
		return result;
	}
	if (type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE) {
		result = (*self->priv->_last_env_data).type == STRUCT_TYPE_FIGURE;
		return result;
	}
	result = FALSE;
	return result;
}


static GtkTreeIter* document_structure_add_item (DocumentStructure* self, StructType type, const gchar* text, GtkTextIter* start_iter) {
	GtkTreeIter* result = NULL;
	StructData _tmp0_ = {0};
	StructData data;
	gchar* _tmp1_;
	GtkTextMark* _tmp2_ = NULL;
	GtkTreeIter* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	data = _tmp0_;
	data.type = type;
	_tmp1_ = g_strdup (text);
	_g_free0 (data.text);
	data.text = _tmp1_;
	_tmp2_ = document_structure_create_text_mark_from_iter (self, start_iter);
	_g_object_unref0 (data.start_mark);
	data.start_mark = _tmp2_;
	_g_object_unref0 (data.end_mark);
	data.end_mark = NULL;
	_tmp3_ = document_structure_add_item_data (self, &data);
	result = _tmp3_;
	struct_data_destroy (&data);
	return result;
}


static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self, StructData* data) {
	GtkTreeIter* result = NULL;
	GtkTreeIter* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if ((*data).text == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		_g_free0 ((*data).text);
		(*data).text = _tmp0_;
	}
	_tmp1_ = structure_model_add_item_at_end (self->priv->_model, data);
	result = _tmp1_;
	return result;
}


static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self, GtkTextIter* iter) {
	GtkTextMark* result = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* doc;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* name;
	GtkTextMark* _tmp6_ = NULL;
	GtkTextMark* _tmp7_;
	GtkTextMark* mark;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = g_strdup_printf ("%i", self->priv->_nb_marks);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	name = _tmp5_;
	_tmp6_ = gtk_text_buffer_create_mark (doc, name, iter, FALSE);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	mark = _tmp7_;
	self->priv->_nb_marks++;
	result = mark;
	_g_free0 (name);
	_g_object_unref0 (doc);
	return result;
}


static void document_structure_clear_all_structure_marks (DocumentStructure* self) {
	g_return_if_fail (self != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* _tmp1_ = NULL;
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* mark_name;
				GtkTextMark* _tmp5_ = NULL;
				GtkTextMark* _tmp6_;
				GtkTextMark* mark;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->_nb_marks)) {
					break;
				}
				_tmp1_ = g_strdup_printf ("%i", i);
				_tmp2_ = _tmp1_;
				_tmp3_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp2_, NULL);
				_tmp4_ = _tmp3_;
				_g_free0 (_tmp2_);
				mark_name = _tmp4_;
				_tmp5_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self->priv->_doc, mark_name);
				_tmp6_ = _g_object_ref0 (_tmp5_);
				mark = _tmp6_;
				if (mark != NULL) {
					gtk_text_buffer_delete_mark ((GtkTextBuffer*) self->priv->_doc, mark);
				}
				_g_object_unref0 (mark);
				_g_free0 (mark_name);
			}
		}
	}
	self->priv->_nb_marks = 0;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}


static gchar* document_structure_truncate (DocumentStructure* self, const gchar* text) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint index;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (text == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_utf8_strlen (text, (gssize) (-1));
	if (_tmp0_ <= DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH) {
		result = NULL;
		return result;
	}
	_tmp1_ = string_index_of_nth_char (text, (glong) DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH);
	index = _tmp1_;
	_tmp2_ = string_substring (text, (glong) 0, (glong) index);
	result = _tmp2_;
	return result;
}


static DocumentStructureLowLevelType* document_structure_get_markup_low_level_type (DocumentStructure* self, const gchar* markup_name) {
	DocumentStructureLowLevelType* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	static GQuark _tmp1__label5 = 0;
	static GQuark _tmp1__label6 = 0;
	static GQuark _tmp1__label7 = 0;
	static GQuark _tmp1__label8 = 0;
	static GQuark _tmp1__label9 = 0;
	static GQuark _tmp1__label10 = 0;
	static GQuark _tmp1__label11 = 0;
	static GQuark _tmp1__label12 = 0;
	static GQuark _tmp1__label13 = 0;
	static GQuark _tmp1__label14 = 0;
	static GQuark _tmp1__label15 = 0;
	static GQuark _tmp1__label16 = 0;
	static GQuark _tmp1__label17 = 0;
	static GQuark _tmp1__label18 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (markup_name != NULL, NULL);
	_tmp0_ = markup_name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("part")))) || (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("part*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp2_;
				DocumentStructureLowLevelType* _tmp3_;
				_tmp2_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PART;
				_tmp3_ = __document_structure_low_level_type_dup0 (&_tmp2_);
				result = _tmp3_;
				return result;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("chapter")))) || (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("chapter*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp4_;
				DocumentStructureLowLevelType* _tmp5_;
				_tmp4_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CHAPTER;
				_tmp5_ = __document_structure_low_level_type_dup0 (&_tmp4_);
				result = _tmp5_;
				return result;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("section")))) || (_tmp1_ == ((0 != _tmp1__label5) ? _tmp1__label5 : (_tmp1__label5 = g_quark_from_static_string ("section*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp6_;
				DocumentStructureLowLevelType* _tmp7_;
				_tmp6_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SECTION;
				_tmp7_ = __document_structure_low_level_type_dup0 (&_tmp6_);
				result = _tmp7_;
				return result;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label6) ? _tmp1__label6 : (_tmp1__label6 = g_quark_from_static_string ("subsection")))) || (_tmp1_ == ((0 != _tmp1__label7) ? _tmp1__label7 : (_tmp1__label7 = g_quark_from_static_string ("subsection*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp8_;
				DocumentStructureLowLevelType* _tmp9_;
				_tmp8_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSECTION;
				_tmp9_ = __document_structure_low_level_type_dup0 (&_tmp8_);
				result = _tmp9_;
				return result;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label8) ? _tmp1__label8 : (_tmp1__label8 = g_quark_from_static_string ("subsubsection")))) || (_tmp1_ == ((0 != _tmp1__label9) ? _tmp1__label9 : (_tmp1__label9 = g_quark_from_static_string ("subsubsection*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp10_;
				DocumentStructureLowLevelType* _tmp11_;
				_tmp10_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBSUBSECTION;
				_tmp11_ = __document_structure_low_level_type_dup0 (&_tmp10_);
				result = _tmp11_;
				return result;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label10) ? _tmp1__label10 : (_tmp1__label10 = g_quark_from_static_string ("paragraph")))) || (_tmp1_ == ((0 != _tmp1__label11) ? _tmp1__label11 : (_tmp1__label11 = g_quark_from_static_string ("paragraph*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp12_;
				DocumentStructureLowLevelType* _tmp13_;
				_tmp12_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_PARAGRAPH;
				_tmp13_ = __document_structure_low_level_type_dup0 (&_tmp12_);
				result = _tmp13_;
				return result;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label12) ? _tmp1__label12 : (_tmp1__label12 = g_quark_from_static_string ("subparagraph")))) || (_tmp1_ == ((0 != _tmp1__label13) ? _tmp1__label13 : (_tmp1__label13 = g_quark_from_static_string ("subparagraph*"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp14_;
				DocumentStructureLowLevelType* _tmp15_;
				_tmp14_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_SUBPARAGRAPH;
				_tmp15_ = __document_structure_low_level_type_dup0 (&_tmp14_);
				result = _tmp15_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label14) ? _tmp1__label14 : (_tmp1__label14 = g_quark_from_static_string ("label")))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp16_;
				DocumentStructureLowLevelType* _tmp17_;
				_tmp16_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_LABEL;
				_tmp17_ = __document_structure_low_level_type_dup0 (&_tmp16_);
				result = _tmp17_;
				return result;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label15) ? _tmp1__label15 : (_tmp1__label15 = g_quark_from_static_string ("input")))) || (_tmp1_ == ((0 != _tmp1__label16) ? _tmp1__label16 : (_tmp1__label16 = g_quark_from_static_string ("include"))))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp18_;
				DocumentStructureLowLevelType* _tmp19_;
				_tmp18_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_INCLUDE;
				_tmp19_ = __document_structure_low_level_type_dup0 (&_tmp18_);
				result = _tmp19_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label17) ? _tmp1__label17 : (_tmp1__label17 = g_quark_from_static_string ("includegraphics")))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp20_;
				DocumentStructureLowLevelType* _tmp21_;
				_tmp20_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_IMAGE;
				_tmp21_ = __document_structure_low_level_type_dup0 (&_tmp20_);
				result = _tmp21_;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label18) ? _tmp1__label18 : (_tmp1__label18 = g_quark_from_static_string ("caption")))) {
		switch (0) {
			default:
			{
				DocumentStructureLowLevelType _tmp22_;
				DocumentStructureLowLevelType* _tmp23_;
				_tmp22_ = DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_CAPTION;
				_tmp23_ = __document_structure_low_level_type_dup0 (&_tmp22_);
				result = _tmp23_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}


/*************************************************************************/
void document_structure_do_action (DocumentStructure* self, StructAction action_type, GtkTreeIter* tree_iter, gboolean* refresh_simple_list, GError** error) {
	gboolean _refresh_simple_list = FALSE;
	gboolean shift_right;
	gboolean _tmp2_ = FALSE;
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextIter* _tmp10_ = NULL;
	GtkTextIter* _tmp11_ = NULL;
	gboolean _tmp12_;
	gboolean found;
	gint _tmp14_;
	gint _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_refresh_simple_list = FALSE;
	if (action_type == STRUCT_ACTION_COMMENT) {
		gboolean _tmp0_;
		_tmp0_ = document_structure_comment_item (self, tree_iter);
		if (!_tmp0_) {
			GError* _tmp1_ = NULL;
			_tmp1_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error_ = _tmp1_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		structure_model_delete (self->priv->_model, tree_iter);
		_refresh_simple_list = TRUE;
		if (refresh_simple_list) {
			*refresh_simple_list = _refresh_simple_list;
		}
		return;
	}
	shift_right = action_type == STRUCT_ACTION_SHIFT_RIGHT;
	if (shift_right) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = action_type == STRUCT_ACTION_SHIFT_LEFT;
	}
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean doc_modified = FALSE;
		gboolean _tmp7_;
		gboolean _tmp8_;
		gboolean success;
		if (shift_right) {
			gboolean _tmp4_;
			_tmp4_ = structure_model_item_contains_subparagraph (self->priv->_model, tree_iter);
			_tmp3_ = _tmp4_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			const gchar* _tmp5_ = NULL;
			GError* _tmp6_ = NULL;
			_tmp5_ = _ ("The structure item already contains a sub-paragraph.");
			_tmp6_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, _tmp5_);
			_inner_error_ = _tmp6_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self->priv->_doc);
		_tmp8_ = document_structure_shift_item (self, tree_iter, shift_right, &_tmp7_);
		doc_modified = _tmp7_;
		success = _tmp8_;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) self->priv->_doc);
		if (!success) {
			GError* _tmp9_ = NULL;
			if (doc_modified) {
				gtk_source_buffer_undo ((GtkSourceBuffer*) self->priv->_doc);
			}
			_tmp9_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error_ = _tmp9_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (shift_right) {
			structure_model_shift_right (self->priv->_model, tree_iter);
		} else {
			structure_model_shift_left (self->priv->_model, tree_iter);
		}
		if (refresh_simple_list) {
			*refresh_simple_list = _refresh_simple_list;
		}
		return;
	}
	_tmp12_ = document_structure_get_exact_item_bounds (self, tree_iter, &_tmp10_, &_tmp11_);
	_g_free0 (start_iter);
	start_iter = _tmp10_;
	_g_free0 (end_iter);
	end_iter = _tmp11_;
	found = _tmp12_;
	if (!found) {
		GError* _tmp13_ = NULL;
		_tmp13_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (end_iter);
			_g_free0 (start_iter);
			return;
		} else {
			_g_free0 (end_iter);
			_g_free0 (start_iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = gtk_text_iter_get_line (start_iter);
	_tmp15_ = gtk_text_iter_get_line (end_iter);
	if (_tmp14_ != _tmp15_) {
		document_structure_backward_indentation (self, &start_iter);
		document_structure_backward_indentation (self, &end_iter);
	}
	if (action_type == STRUCT_ACTION_SELECT) {
		gtk_text_buffer_select_range ((GtkTextBuffer*) self->priv->_doc, start_iter, end_iter);
		_g_free0 (end_iter);
		_g_free0 (start_iter);
		if (refresh_simple_list) {
			*refresh_simple_list = _refresh_simple_list;
		}
		return;
	}
	if (action_type == STRUCT_ACTION_COPY) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = action_type == STRUCT_ACTION_CUT;
	}
	if (_tmp16_) {
		gchar* _tmp17_ = NULL;
		gchar* data;
		GtkClipboard* _tmp18_ = NULL;
		GtkClipboard* _tmp19_;
		GtkClipboard* clipboard;
		_tmp17_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self->priv->_doc, start_iter, end_iter, FALSE);
		data = _tmp17_;
		_tmp18_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
		_tmp19_ = _g_object_ref0 (_tmp18_);
		clipboard = _tmp19_;
		gtk_clipboard_set_text (clipboard, data, -1);
		_g_object_unref0 (clipboard);
		_g_free0 (data);
	}
	if (action_type == STRUCT_ACTION_DELETE) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = action_type == STRUCT_ACTION_CUT;
	}
	if (_tmp20_) {
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self->priv->_doc);
		gtk_text_buffer_delete ((GtkTextBuffer*) self->priv->_doc, start_iter, end_iter);
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) self->priv->_doc);
		structure_model_delete (self->priv->_model, tree_iter);
		_refresh_simple_list = TRUE;
	}
	_g_free0 (end_iter);
	_g_free0 (start_iter);
	if (refresh_simple_list) {
		*refresh_simple_list = _refresh_simple_list;
	}
}


static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self) {
	GtkTextIter* dup;
	dup = g_new0 (GtkTextIter, 1);
	memcpy (dup, self, sizeof (GtkTextIter));
	return dup;
}


static gpointer __gtk_text_iter_dup0 (gpointer self) {
	return self ? _gtk_text_iter_dup (self) : NULL;
}


static gboolean document_structure_comment_item (DocumentStructure* self, GtkTreeIter* tree_iter) {
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
	GtkTextIter start_iter = {0};
	GtkTextIter* end_iter;
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp3_;
	GtkTreeIter* next_section_iter;
	GtkTreeIter* _tmp4_ = NULL;
	GtkTreeIter* _tmp5_;
	gboolean go_one_line_backward;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_model, tree_iter, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, -1, -1);
	end_iter = NULL;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_doc, &_tmp0_, start_mark);
	start_iter = _tmp0_;
	if (end_mark != NULL) {
		GtkTextIter _tmp1_ = {0};
		GtkTextIter* _tmp2_;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_doc, &_tmp1_, end_mark);
		_g_free0 (end_iter);
		_tmp2_ = __gtk_text_iter_dup0 (&_tmp1_);
		end_iter = _tmp2_;
	}
	_tmp3_ = structure_is_section (type);
	if (!_tmp3_) {
		document_comment_between (self->priv->_doc, &start_iter, end_iter);
		result = TRUE;
		_g_free0 (end_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	next_section_iter = NULL;
	_tmp4_ = structure_model_get_next_sibling_or_parent (self->priv->_model, tree_iter, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == STRUCT_ERROR) {
			goto __catch62_struct_error;
		}
		_g_free0 (next_section_iter);
		_g_free0 (end_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (next_section_iter);
	next_section_iter = _tmp5_;
	goto __finally62;
	__catch62_struct_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("document_structure.vala:809: Structure: get next sibling or parent: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (next_section_iter);
		_g_free0 (end_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	__finally62:
	if (_inner_error_ != NULL) {
		_g_free0 (next_section_iter);
		_g_free0 (end_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	go_one_line_backward = TRUE;
	if (next_section_iter == NULL) {
		gboolean end_of_file = FALSE;
		gboolean _tmp6_;
		GtkTextIter _tmp7_ = {0};
		GtkTextIter _tmp8_ = {0};
		GtkTextIter* _tmp9_;
		document_structure_get_end_document_iter (self, &_tmp6_, &_tmp7_);
		_tmp8_ = _tmp7_;
		end_of_file = _tmp6_;
		_tmp9_ = __gtk_text_iter_dup0 (&_tmp8_);
		_g_free0 (end_iter);
		end_iter = _tmp9_;
		go_one_line_backward = !end_of_file;
	} else {
		GtkTextIter _tmp10_ = {0};
		GtkTextIter* _tmp11_;
		gtk_tree_model_get ((GtkTreeModel*) self->priv->_model, next_section_iter, STRUCT_COLUMN_START_MARK, &end_mark, -1, -1);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_doc, &_tmp10_, end_mark);
		_g_free0 (end_iter);
		_tmp11_ = __gtk_text_iter_dup0 (&_tmp10_);
		end_iter = _tmp11_;
	}
	if (go_one_line_backward) {
		gboolean _tmp12_;
		_tmp12_ = gtk_text_iter_backward_line (end_iter);
		if (!_tmp12_) {
			_g_free0 (end_iter);
			end_iter = NULL;
		}
	}
	document_comment_between (self->priv->_doc, &start_iter, end_iter);
	result = TRUE;
	_g_free0 (next_section_iter);
	_g_free0 (end_iter);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	return result;
}


static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self, GtkTreeIter* tree_iter, GtkTextIter** start_iter, GtkTextIter** end_iter) {
	GtkTextIter* _start_iter = NULL;
	GtkTextIter* _end_iter = NULL;
	gboolean result = FALSE;
	StructType item_type = 0;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
	gchar* item_contents;
	GtkTextIter _tmp0_ = {0};
	GtkTextIter* _tmp1_;
	GtkTextIter* _tmp2_ = NULL;
	gboolean _tmp3_;
	gboolean found;
	gboolean _tmp4_;
	GtkTextIter end_env_iter = {0};
	GtkTextIter _tmp13_ = {0};
	GtkTextIter* _tmp14_ = NULL;
	gboolean _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	item_contents = NULL;
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_model, tree_iter, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_doc, &_tmp0_, start_mark);
	_g_free0 (_start_iter);
	_tmp1_ = __gtk_text_iter_dup0 (&_tmp0_);
	_start_iter = _tmp1_;
	_tmp3_ = document_structure_get_low_level_item_bounds (self, item_type, item_contents, _start_iter, TRUE, &_tmp2_);
	_g_free0 (_end_iter);
	_end_iter = _tmp2_;
	found = _tmp3_;
	if (!found) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _start_iter;
		} else {
			_g_free0 (_start_iter);
		}
		if (end_iter) {
			*end_iter = _end_iter;
		} else {
			_g_free0 (_end_iter);
		}
		return result;
	}
	_tmp4_ = structure_is_section (item_type);
	if (_tmp4_) {
		GtkTreeIter* next_section_iter;
		GtkTreeIter* _tmp5_ = NULL;
		GtkTreeIter* _tmp6_;
		GtkTextIter _tmp10_ = {0};
		GtkTextIter* _tmp11_;
		gboolean _tmp12_;
		next_section_iter = NULL;
		_tmp5_ = structure_model_get_next_sibling_or_parent (self->priv->_model, tree_iter, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == STRUCT_ERROR) {
				goto __catch63_struct_error;
			}
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_free0 (next_section_iter);
		next_section_iter = _tmp6_;
		goto __finally63;
		__catch63_struct_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("document_structure.vala:882: Structure: get next sibling or parent: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _start_iter;
			} else {
				_g_free0 (_start_iter);
			}
			if (end_iter) {
				*end_iter = _end_iter;
			} else {
				_g_free0 (_end_iter);
			}
			return result;
		}
		__finally63:
		if (_inner_error_ != NULL) {
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (next_section_iter == NULL) {
			GtkTextIter _tmp7_ = {0};
			GtkTextIter _tmp8_ = {0};
			GtkTextIter* _tmp9_;
			document_structure_get_end_document_iter (self, NULL, &_tmp7_);
			_tmp8_ = _tmp7_;
			_tmp9_ = __gtk_text_iter_dup0 (&_tmp8_);
			_g_free0 (_end_iter);
			_end_iter = _tmp9_;
			result = TRUE;
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _start_iter;
			} else {
				_g_free0 (_start_iter);
			}
			if (end_iter) {
				*end_iter = _end_iter;
			} else {
				_g_free0 (_end_iter);
			}
			return result;
		}
		gtk_tree_model_get ((GtkTreeModel*) self->priv->_model, next_section_iter, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_doc, &_tmp10_, start_mark);
		_g_free0 (_end_iter);
		_tmp11_ = __gtk_text_iter_dup0 (&_tmp10_);
		_end_iter = _tmp11_;
		_tmp12_ = document_structure_get_low_level_item_bounds (self, item_type, item_contents, _end_iter, TRUE, NULL);
		result = _tmp12_;
		_g_free0 (next_section_iter);
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _start_iter;
		} else {
			_g_free0 (_start_iter);
		}
		if (end_iter) {
			*end_iter = _end_iter;
		} else {
			_g_free0 (_end_iter);
		}
		return result;
	} else {
		if (item_type < STRUCT_TYPE_NB_COMMON_TYPES) {
			result = TRUE;
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _start_iter;
			} else {
				_g_free0 (_start_iter);
			}
			if (end_iter) {
				*end_iter = _end_iter;
			} else {
				_g_free0 (_end_iter);
			}
			return result;
		}
	}
	if (end_mark == NULL) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _start_iter;
		} else {
			_g_free0 (_start_iter);
		}
		if (end_iter) {
			*end_iter = _end_iter;
		} else {
			_g_free0 (_end_iter);
		}
		return result;
	}
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_doc, &_tmp13_, end_mark);
	end_env_iter = _tmp13_;
	_tmp15_ = document_structure_get_low_level_item_bounds (self, item_type, item_contents, &end_env_iter, FALSE, &_tmp14_);
	_g_free0 (_end_iter);
	_end_iter = _tmp14_;
	result = _tmp15_;
	_g_free0 (item_contents);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	if (start_iter) {
		*start_iter = _start_iter;
	} else {
		_g_free0 (_start_iter);
	}
	if (end_iter) {
		*end_iter = _end_iter;
	} else {
		_g_free0 (_end_iter);
	}
	return result;
}


static gboolean _int_equal (const gint* s1, const gint* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self, StructType item_type, const gchar* item_contents, GtkTextIter* start_match_iter, gboolean is_start, GtkTextIter** end_match_iter) {
	GtkTextIter* _end_match_iter = NULL;
	gboolean result = FALSE;
	gint _tmp0_;
	gint line_num;
	gchar* _tmp1_ = NULL;
	gchar* line;
	gint _tmp2_;
	gint start_index;
	DocumentStructureLowLevelType* low_level_type = NULL;
	gchar* contents = NULL;
	gint* start_match_index = NULL;
	gint* end_match_index = NULL;
	DocumentStructureLowLevelType* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint* _tmp5_ = NULL;
	gint* _tmp6_ = NULL;
	gboolean _tmp7_;
	gboolean found;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	_tmp0_ = gtk_text_iter_get_line (start_match_iter);
	line_num = _tmp0_;
	_tmp1_ = document_structure_get_document_line_contents (self, line_num);
	line = _tmp1_;
	_tmp2_ = gtk_text_iter_get_line_index (start_match_iter);
	start_index = _tmp2_;
	_tmp7_ = document_structure_search_low_level_item (self, line, start_index, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (low_level_type);
	low_level_type = _tmp3_;
	_g_free0 (contents);
	contents = _tmp4_;
	_g_free0 (start_match_index);
	start_match_index = _tmp5_;
	_g_free0 (end_match_index);
	end_match_index = _tmp6_;
	found = _tmp7_;
	if (!found) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = _int_equal (&start_index, start_match_index) != TRUE;
	}
	if (_tmp8_) {
		result = FALSE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _end_match_iter;
		} else {
			_g_free0 (_end_match_iter);
		}
		return result;
	}
	if (contents == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp9_;
	}
	_tmp10_ = document_structure_same_items (self, item_type, item_contents, *low_level_type, contents, is_start);
	if (_tmp10_) {
		GtkTextIter _tmp11_ = {0};
		GtkTextIter* _tmp12_;
		gtk_text_buffer_get_iter_at_line_index ((GtkTextBuffer*) self->priv->_doc, &_tmp11_, line_num, *end_match_index);
		_g_free0 (_end_match_iter);
		_tmp12_ = __gtk_text_iter_dup0 (&_tmp11_);
		_end_match_iter = _tmp12_;
		result = TRUE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _end_match_iter;
		} else {
			_g_free0 (_end_match_iter);
		}
		return result;
	}
	result = FALSE;
	_g_free0 (end_match_index);
	_g_free0 (start_match_index);
	_g_free0 (contents);
	_g_free0 (low_level_type);
	_g_free0 (line);
	if (end_match_iter) {
		*end_match_iter = _end_match_iter;
	} else {
		_g_free0 (_end_match_iter);
	}
	return result;
}


static gboolean document_structure_same_items (DocumentStructure* self, StructType item_type, const gchar* item_contents, DocumentStructureLowLevelType item_found_type, const gchar* item_found_contents, gboolean start) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	g_return_val_if_fail (item_found_contents != NULL, FALSE);
	if (item_found_type < DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_NB_COMMON_TYPES) {
		gboolean same_type;
		gboolean same_contents;
		gboolean _tmp0_ = FALSE;
		same_type = item_type == ((StructType) item_found_type);
		same_contents = g_strcmp0 (item_contents, item_found_contents) == 0;
		if (same_type) {
			_tmp0_ = same_contents;
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		return result;
	}
	if (item_type == STRUCT_TYPE_FIGURE) {
		if (start) {
			result = item_found_type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_FIGURE;
			return result;
		} else {
			result = item_found_type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_FIGURE;
			return result;
		}
	}
	if (item_type == STRUCT_TYPE_TABLE) {
		if (start) {
			result = item_found_type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_BEGIN_TABLE;
			return result;
		} else {
			result = item_found_type == DOCUMENT_STRUCTURE_LOW_LEVEL_TYPE_END_TABLE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gchar* document_structure_get_document_line_contents (DocumentStructure* self, gint line_num) {
	gchar* result = NULL;
	gint _tmp0_;
	gint nb_lines;
	gboolean _tmp1_ = FALSE;
	GtkTextIter begin = {0};
	GtkTextIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkTextIter end;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self->priv->_doc);
	nb_lines = _tmp0_;
	if (0 <= line_num) {
		_tmp1_ = line_num < nb_lines;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self->priv->_doc, &_tmp2_, line_num);
	begin = _tmp2_;
	_tmp3_ = gtk_text_iter_ends_line (&begin);
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		result = _tmp4_;
		return result;
	}
	end = begin;
	gtk_text_iter_forward_to_line_end (&end);
	_tmp5_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self->priv->_doc, &begin, &end, FALSE);
	result = _tmp5_;
	return result;
}


static void document_structure_get_end_document_iter (DocumentStructure* self, gboolean* end_of_file, GtkTextIter* result) {
	gboolean _end_of_file = FALSE;
	GtkTextIter eof_iter = {0};
	GtkTextIter _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	if (self->priv->_end_document_mark != NULL) {
		GtkTextIter end_document_iter = {0};
		GtkTextIter _tmp0_ = {0};
		_end_of_file = FALSE;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_doc, &_tmp0_, self->priv->_end_document_mark);
		end_document_iter = _tmp0_;
		*result = end_document_iter;
		if (end_of_file) {
			*end_of_file = _end_of_file;
		}
		return;
	}
	_end_of_file = TRUE;
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self->priv->_doc, &_tmp1_);
	eof_iter = _tmp1_;
	*result = eof_iter;
	if (end_of_file) {
		*end_of_file = _end_of_file;
	}
	return;
}


static void document_structure_backward_indentation (DocumentStructure* self, GtkTextIter** iter) {
	gboolean _tmp0_;
	gint _tmp1_;
	gint line_num;
	GtkTextIter begin_line_iter = {0};
	GtkTextIter _tmp2_ = {0};
	gchar* _tmp3_ = NULL;
	gchar* text_between;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail ((*iter) != NULL);
	_tmp0_ = gtk_text_iter_starts_line (*iter);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = gtk_text_iter_get_line (*iter);
	line_num = _tmp1_;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self->priv->_doc, &_tmp2_, line_num);
	begin_line_iter = _tmp2_;
	_tmp3_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self->priv->_doc, &begin_line_iter, *iter, FALSE);
	text_between = _tmp3_;
	_tmp4_ = string_strip (text_between);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		GtkTextIter* _tmp7_;
		_tmp7_ = __gtk_text_iter_dup0 (&begin_line_iter);
		_g_free0 (*iter);
		*iter = _tmp7_;
	}
	_g_free0 (text_between);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gboolean document_structure_shift_item (DocumentStructure* self, GtkTreeIter* tree_iter, gboolean shift_right, gboolean* doc_modified) {
	gboolean _doc_modified = FALSE;
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* mark = NULL;
	gboolean _tmp0_;
	GtkTextIter text_iter = {0};
	GtkTextIter _tmp1_ = {0};
	gint _tmp2_;
	gint line_num;
	gchar* _tmp3_ = NULL;
	gchar* line;
	gint _tmp4_;
	gint backslash_index;
	gchar _tmp5_;
	gint after_backslash_index;
	gchar* _tmp6_ = NULL;
	gchar* markup_name;
	DocumentStructureLowLevelType* _tmp7_ = NULL;
	DocumentStructureLowLevelType* markup_type;
	DocumentStructureLowLevelType markup_type_hack;
	gboolean _tmp8_;
	gboolean with_star;
	StructType new_type = 0;
	gchar* _tmp9_ = NULL;
	gchar* new_markup_name;
	GtkTextIter begin_markup_name_iter = {0};
	GtkTextIter _tmp11_ = {0};
	GtkTextIter end_markup_name_iter = {0};
	gint _tmp12_;
	GtkTextIter _tmp13_ = {0};
	gint _tmp14_;
	gint nb_children;
	g_return_val_if_fail (self != NULL, FALSE);
	_doc_modified = FALSE;
	gtk_tree_model_get ((GtkTreeModel*) self->priv->_model, tree_iter, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &mark, -1, -1);
	if (shift_right) {
		g_return_val_if_fail (type != STRUCT_TYPE_SUBPARAGRAPH, FALSE);
	} else {
		g_return_val_if_fail (type != STRUCT_TYPE_PART, FALSE);
	}
	_tmp0_ = structure_is_section (type);
	if (!_tmp0_) {
		result = TRUE;
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _doc_modified;
		}
		return result;
	}
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->_doc, &_tmp1_, mark);
	text_iter = _tmp1_;
	_tmp2_ = gtk_text_iter_get_line (&text_iter);
	line_num = _tmp2_;
	_tmp3_ = document_structure_get_document_line_contents (self, line_num);
	line = _tmp3_;
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp4_ = gtk_text_iter_get_line_index (&text_iter);
	backslash_index = _tmp4_;
	_tmp5_ = string_get (line, (glong) backslash_index);
	if (_tmp5_ != '\\') {
		result = FALSE;
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _doc_modified;
		}
		return result;
	}
	after_backslash_index = backslash_index + 1;
	_tmp6_ = document_structure_get_markup_name (self, line, after_backslash_index, NULL);
	markup_name = _tmp6_;
	if (markup_name == NULL) {
		result = FALSE;
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _doc_modified;
		}
		return result;
	}
	_tmp7_ = document_structure_get_markup_low_level_type (self, markup_name);
	markup_type = _tmp7_;
	if (markup_type == NULL) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _doc_modified;
		}
		return result;
	}
	markup_type_hack = *markup_type;
	if (((gint) type) != ((gint) markup_type_hack)) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _doc_modified;
		}
		return result;
	}
	_tmp8_ = g_str_has_suffix (markup_name, "*");
	with_star = _tmp8_;
	if (shift_right) {
		new_type = type + 1;
	} else {
		new_type = type - 1;
	}
	_tmp9_ = document_structure_get_section_name_from_type (self, new_type);
	new_markup_name = _tmp9_;
	g_return_val_if_fail (new_markup_name != NULL, FALSE);
	if (with_star) {
		gchar* _tmp10_;
		_tmp10_ = g_strconcat (new_markup_name, "*", NULL);
		_g_free0 (new_markup_name);
		new_markup_name = _tmp10_;
	}
	gtk_text_buffer_get_iter_at_line_index ((GtkTextBuffer*) self->priv->_doc, &_tmp11_, line_num, after_backslash_index);
	begin_markup_name_iter = _tmp11_;
	_tmp12_ = strlen (markup_name);
	gtk_text_buffer_get_iter_at_line_index ((GtkTextBuffer*) self->priv->_doc, &_tmp13_, line_num, after_backslash_index + _tmp12_);
	end_markup_name_iter = _tmp13_;
	gtk_text_buffer_delete ((GtkTextBuffer*) self->priv->_doc, &begin_markup_name_iter, &end_markup_name_iter);
	document_insert (self->priv->_doc, &begin_markup_name_iter, new_markup_name, -1);
	_doc_modified = TRUE;
	_tmp14_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) self->priv->_model, tree_iter);
	nb_children = _tmp14_;
	{
		gint child_num;
		child_num = 0;
		{
			gboolean _tmp15_;
			_tmp15_ = TRUE;
			while (TRUE) {
				GtkTreeIter child_iter = {0};
				GtkTreeIter _tmp16_ = {0};
				gboolean _tmp17_;
				gboolean child_iter_set;
				gboolean _tmp18_;
				if (!_tmp15_) {
					child_num++;
				}
				_tmp15_ = FALSE;
				if (!(child_num < nb_children)) {
					break;
				}
				_tmp17_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self->priv->_model, &_tmp16_, tree_iter, child_num);
				child_iter = _tmp16_;
				child_iter_set = _tmp17_;
				g_return_val_if_fail (child_iter_set, FALSE);
				_tmp18_ = document_structure_shift_item (self, &child_iter, shift_right, NULL);
				if (!_tmp18_) {
					result = FALSE;
					_g_free0 (new_markup_name);
					_g_free0 (markup_type);
					_g_free0 (markup_name);
					_g_free0 (line);
					_g_object_unref0 (mark);
					if (doc_modified) {
						*doc_modified = _doc_modified;
					}
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (new_markup_name);
	_g_free0 (markup_type);
	_g_free0 (markup_name);
	_g_free0 (line);
	_g_object_unref0 (mark);
	if (doc_modified) {
		*doc_modified = _doc_modified;
	}
	return result;
}


static gchar* document_structure_get_section_name_from_type (DocumentStructure* self, StructType type) {
	gchar* result = NULL;
	gboolean _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	if (document_structure__section_names == NULL) {
		gchar** _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp0_ = g_new0 (gchar*, 7 + 1);
		document_structure__section_names = (_vala_array_free (document_structure__section_names, document_structure__section_names_length1, (GDestroyNotify) g_free), NULL);
		document_structure__section_names = _tmp0_;
		document_structure__section_names_length1 = 7;
		_document_structure__section_names_size_ = 7;
		_tmp1_ = g_strdup ("part");
		_tmp2_ = _tmp1_;
		_g_free0 (document_structure__section_names[STRUCT_TYPE_PART]);
		document_structure__section_names[STRUCT_TYPE_PART] = _tmp2_;
		_tmp3_ = g_strdup ("chapter");
		_tmp4_ = _tmp3_;
		_g_free0 (document_structure__section_names[STRUCT_TYPE_CHAPTER]);
		document_structure__section_names[STRUCT_TYPE_CHAPTER] = _tmp4_;
		_tmp5_ = g_strdup ("section");
		_tmp6_ = _tmp5_;
		_g_free0 (document_structure__section_names[STRUCT_TYPE_SECTION]);
		document_structure__section_names[STRUCT_TYPE_SECTION] = _tmp6_;
		_tmp7_ = g_strdup ("subsection");
		_tmp8_ = _tmp7_;
		_g_free0 (document_structure__section_names[STRUCT_TYPE_SUBSECTION]);
		document_structure__section_names[STRUCT_TYPE_SUBSECTION] = _tmp8_;
		_tmp9_ = g_strdup ("subsubsection");
		_tmp10_ = _tmp9_;
		_g_free0 (document_structure__section_names[STRUCT_TYPE_SUBSUBSECTION]);
		document_structure__section_names[STRUCT_TYPE_SUBSUBSECTION] = _tmp10_;
		_tmp11_ = g_strdup ("paragraph");
		_tmp12_ = _tmp11_;
		_g_free0 (document_structure__section_names[STRUCT_TYPE_PARAGRAPH]);
		document_structure__section_names[STRUCT_TYPE_PARAGRAPH] = _tmp12_;
		_tmp13_ = g_strdup ("subparagraph");
		_tmp14_ = _tmp13_;
		_g_free0 (document_structure__section_names[STRUCT_TYPE_SUBPARAGRAPH]);
		document_structure__section_names[STRUCT_TYPE_SUBPARAGRAPH] = _tmp14_;
	}
	_tmp15_ = structure_is_section (type);
	g_return_val_if_fail (_tmp15_, NULL);
	_tmp16_ = g_strdup (document_structure__section_names[type]);
	result = _tmp16_;
	return result;
}


gboolean document_structure_get_parsing_done (DocumentStructure* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_parsing_done;
	return result;
}


static void document_structure_set_parsing_done (DocumentStructure* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_parsing_done = value;
	g_object_notify ((GObject *) self, "parsing-done");
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void document_structure_env_data_copy (const DocumentStructureEnvData* self, DocumentStructureEnvData* dest) {
	dest->path = _gtk_tree_path_copy0 (self->path);
	dest->type = self->type;
	dest->first_caption = g_strdup (self->first_caption);
}


static void document_structure_env_data_destroy (DocumentStructureEnvData* self) {
	_gtk_tree_path_free0 ((*self).path);
	_g_free0 ((*self).first_caption);
}


static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self) {
	DocumentStructureEnvData* dup;
	dup = g_new0 (DocumentStructureEnvData, 1);
	document_structure_env_data_copy (self, dup);
	return dup;
}


static void document_structure_env_data_free (DocumentStructureEnvData* self) {
	document_structure_env_data_destroy (self);
	g_free (self);
}


static GType document_structure_env_data_get_type (void) {
	static volatile gsize document_structure_env_data_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_env_data_type_id__volatile)) {
		GType document_structure_env_data_type_id;
		document_structure_env_data_type_id = g_boxed_type_register_static ("DocumentStructureEnvData", (GBoxedCopyFunc) document_structure_env_data_dup, (GBoxedFreeFunc) document_structure_env_data_free);
		g_once_init_leave (&document_structure_env_data_type_id__volatile, document_structure_env_data_type_id);
	}
	return document_structure_env_data_type_id__volatile;
}


static void document_structure_class_init (DocumentStructureClass * klass) {
	document_structure_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentStructurePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_structure_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_structure_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_structure_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_STRUCTURE_PARSING_DONE, g_param_spec_boolean ("parsing-done", "parsing-done", "parsing-done", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void document_structure_instance_init (DocumentStructure * self) {
	self->priv = DOCUMENT_STRUCTURE_GET_PRIVATE (self);
	self->priv->_nb_marks = 0;
	self->priv->_end_document_mark = NULL;
	self->priv->_model = NULL;
	self->priv->_in_verbatim_env = FALSE;
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	self->priv->_timer = NULL;
	self->priv->_parsing_done = FALSE;
}


static void document_structure_finalize (GObject* obj) {
	DocumentStructure * self;
	self = DOCUMENT_STRUCTURE (obj);
	_g_object_unref0 (self->priv->_end_document_mark);
	_g_object_unref0 (self->priv->_model);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	_g_timer_destroy0 (self->priv->_timer);
	G_OBJECT_CLASS (document_structure_parent_class)->finalize (obj);
}


GType document_structure_get_type (void) {
	static volatile gsize document_structure_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentStructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentStructure), 0, (GInstanceInitFunc) document_structure_instance_init, NULL };
		GType document_structure_type_id;
		document_structure_type_id = g_type_register_static (G_TYPE_OBJECT, "DocumentStructure", &g_define_type_info, 0);
		g_once_init_leave (&document_structure_type_id__volatile, document_structure_type_id);
	}
	return document_structure_type_id__volatile;
}


static void _vala_document_structure_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DocumentStructure * self;
	self = DOCUMENT_STRUCTURE (object);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE:
		g_value_set_boolean (value, document_structure_get_parsing_done (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_document_structure_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DocumentStructure * self;
	self = DOCUMENT_STRUCTURE (object);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE:
		document_structure_set_parsing_done (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



