/* main_window_file.c generated by valac 0.32.0.7-5c081, the Vala compiler
 * generated from main_window_file.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "config.h"
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <latexila.h>
#include <gtksourceview/gtksource.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN_WINDOW_FILE (main_window_file_get_type ())
#define MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFile))
#define MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))
#define IS_MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_FILE))
#define IS_MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_FILE))
#define MAIN_WINDOW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))

typedef struct _MainWindowFile MainWindowFile;
typedef struct _MainWindowFileClass MainWindowFileClass;
typedef struct _MainWindowFilePrivate MainWindowFilePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_LATEXILA_APP (latexila_app_get_type ())
#define LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA_APP, LatexilaApp))
#define LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA_APP, LatexilaAppClass))
#define IS_LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA_APP))
#define IS_LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA_APP))
#define LATEXILA_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA_APP, LatexilaAppClass))

typedef struct _LatexilaApp LatexilaApp;
typedef struct _LatexilaAppClass LatexilaAppClass;
typedef struct _MainWindowPrivate MainWindowPrivate;
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _ParamSpecMainWindowFile ParamSpecMainWindowFile;

struct _MainWindowFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowFilePrivate * priv;
};

struct _MainWindowFileClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowFile *self);
};

struct _MainWindowFilePrivate {
	MainWindow* _main_window;
	GtkActionGroup* _action_group;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	gchar* default_location;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _ParamSpecMainWindowFile {
	GParamSpec parent_instance;
};


static gpointer main_window_file_parent_class = NULL;

gpointer main_window_file_ref (gpointer instance);
void main_window_file_unref (gpointer instance);
GParamSpec* param_spec_main_window_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_file (GValue* value, gpointer v_object);
void value_take_main_window_file (GValue* value, gpointer v_object);
gpointer value_get_main_window_file (const GValue* value);
GType main_window_file_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW_FILE, MainWindowFilePrivate))
enum  {
	MAIN_WINDOW_FILE_DUMMY_PROPERTY
};
void main_window_file_on_file_new (MainWindowFile* self);
static void _main_window_file_on_file_new_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_file_on_new_window (MainWindowFile* self);
static void _main_window_file_on_new_window_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_file_on_file_open (MainWindowFile* self);
static void _main_window_file_on_file_open_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_file_on_file_save (MainWindowFile* self);
static void _main_window_file_on_file_save_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_file_on_file_save_as (MainWindowFile* self);
static void _main_window_file_on_file_save_as_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_file_on_create_template (MainWindowFile* self);
static void _main_window_file_on_create_template_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_file_on_manage_templates (MainWindowFile* self);
static void _main_window_file_on_manage_templates_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_file_on_file_close (MainWindowFile* self);
static void _main_window_file_on_file_close_gtk_action_callback (GtkAction* action, gpointer self);
MainWindowFile* main_window_file_new (MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowFile* main_window_file_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
static void main_window_file_configure_recent_chooser (MainWindowFile* self, GtkRecentChooser* recent_chooser);
GtkToolItem* main_window_file_get_toolbar_open_button (MainWindowFile* self);
static void __lambda69_ (MainWindowFile* self, GtkRecentChooser* chooser);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
static void ___lambda69__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender, gpointer self);
void main_window_file_update_sensitivity (MainWindowFile* self, gboolean sensitive);
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
GType document_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
void document_set_contents (Document* self, const gchar* contents);
GType latexila_app_get_type (void) G_GNUC_CONST;
LatexilaApp* latexila_app_get_instance (void);
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as);
gboolean main_window_close_tab (MainWindow* self, DocumentTab* tab, gboolean force_close);
static void main_window_file_finalize (MainWindowFile* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GtkActionEntry MAIN_WINDOW_FILE__action_entries[9] = {{"File", NULL, "_File"}, {"FileNew", "document-new", "_New", "<Control>N", "New file", (GCallback) _main_window_file_on_file_new_gtk_action_callback}, {"FileNewWindow", NULL, "New _Window", NULL, "Create a new window", (GCallback) _main_window_file_on_new_window_gtk_action_callback}, {"FileOpen", "document-open", "_Open", "<Control>O", "Open a file", (GCallback) _main_window_file_on_file_open_gtk_action_callback}, {"FileSave", "document-save", "_Save", "<Control>S", "Save the current file", (GCallback) _main_window_file_on_file_save_gtk_action_callback}, {"FileSaveAs", "document-save-as", "Save _As", "<Shift><Control>S", "Save the current file with a different name", (GCallback) _main_window_file_on_file_save_as_gtk_action_callback}, {"FileCreateTemplate", NULL, "Create _Template From Document...", NULL, "Create a new template from the current document", (GCallback) _main_window_file_on_create_template_gtk_action_callback}, {"FileManageTemplates", NULL, "_Manage Personal Templates...", NULL, "Manage personal templates", (GCallback) _main_window_file_on_manage_templates_gtk_action_callback}, {"FileClose", "window-close", "_Close", "<Control>W", "Close the current file", (GCallback) _main_window_file_on_file_close_gtk_action_callback}};

static void _main_window_file_on_file_new_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_file_on_file_new ((MainWindowFile*) self);
}


static void _main_window_file_on_new_window_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_file_on_new_window ((MainWindowFile*) self);
}


static void _main_window_file_on_file_open_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_file_on_file_open ((MainWindowFile*) self);
}


static void _main_window_file_on_file_save_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_file_on_file_save ((MainWindowFile*) self);
}


static void _main_window_file_on_file_save_as_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_file_on_file_save_as ((MainWindowFile*) self);
}


static void _main_window_file_on_create_template_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_file_on_create_template ((MainWindowFile*) self);
}


static void _main_window_file_on_manage_templates_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_file_on_manage_templates ((MainWindowFile*) self);
}


static void _main_window_file_on_file_close_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_file_on_file_close ((MainWindowFile*) self);
}


MainWindowFile* main_window_file_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager) {
	MainWindowFile* self = NULL;
	MainWindow* _tmp0_ = NULL;
	GtkActionGroup* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GtkActionGroup* _tmp3_ = NULL;
	GtkAction* recent_action = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkRecentAction* _tmp6_ = NULL;
	GtkActionGroup* _tmp7_ = NULL;
	GtkUIManager* _tmp8_ = NULL;
	GtkActionGroup* _tmp9_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (MainWindowFile*) g_type_create_instance (object_type);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = gtk_action_group_new ("FileMenuActionGroup");
	_g_object_unref0 (self->priv->_action_group);
	self->priv->_action_group = _tmp1_;
	_tmp2_ = self->priv->_action_group;
	gtk_action_group_set_translation_domain (_tmp2_, GETTEXT_PACKAGE);
	_tmp3_ = self->priv->_action_group;
	gtk_action_group_add_actions (_tmp3_, MAIN_WINDOW_FILE__action_entries, G_N_ELEMENTS (MAIN_WINDOW_FILE__action_entries), self);
	_tmp4_ = _ ("Open _Recent");
	_tmp5_ = _ ("Open recently used files");
	_tmp6_ = (GtkRecentAction*) gtk_recent_action_new ("FileOpenRecent", _tmp4_, _tmp5_, "");
	recent_action = (GtkAction*) _tmp6_;
	main_window_file_configure_recent_chooser (self, G_TYPE_CHECK_INSTANCE_TYPE (recent_action, GTK_TYPE_RECENT_CHOOSER) ? ((GtkRecentChooser*) recent_action) : NULL);
	_tmp7_ = self->priv->_action_group;
	gtk_action_group_add_action (_tmp7_, recent_action);
	_tmp8_ = ui_manager;
	_tmp9_ = self->priv->_action_group;
	gtk_ui_manager_insert_action_group (_tmp8_, _tmp9_, 0);
	_g_object_unref0 (recent_action);
	return self;
}


MainWindowFile* main_window_file_new (MainWindow* main_window, GtkUIManager* ui_manager) {
	return main_window_file_construct (TYPE_MAIN_WINDOW_FILE, main_window, ui_manager);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GtkToolItem* main_window_file_get_toolbar_open_button (MainWindowFile* self) {
	GtkToolItem* result = NULL;
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_ = NULL;
	GtkWidget* recent_menu = NULL;
	GtkRecentChooserMenu* _tmp2_ = NULL;
	GtkMenuToolButton* open_button = NULL;
	GtkMenuToolButton* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp6_ = NULL;
	GtkAction* _tmp7_ = NULL;
	GtkAction* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_recent_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	recent_manager = _tmp1_;
	_tmp2_ = (GtkRecentChooserMenu*) gtk_recent_chooser_menu_new_for_manager (recent_manager);
	g_object_ref_sink (_tmp2_);
	recent_menu = (GtkWidget*) _tmp2_;
	main_window_file_configure_recent_chooser (self, G_TYPE_CHECK_INSTANCE_TYPE (recent_menu, GTK_TYPE_RECENT_CHOOSER) ? ((GtkRecentChooser*) recent_menu) : NULL);
	_tmp3_ = (GtkMenuToolButton*) gtk_menu_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp3_);
	open_button = _tmp3_;
	gtk_tool_button_set_icon_name ((GtkToolButton*) open_button, "document-open");
	gtk_menu_tool_button_set_menu (open_button, recent_menu);
	_tmp4_ = _ ("Open a file");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) open_button, _tmp4_);
	_tmp5_ = _ ("Open a recently used file");
	gtk_menu_tool_button_set_arrow_tooltip_text (open_button, _tmp5_);
	_tmp6_ = self->priv->_action_group;
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "FileOpen");
	_tmp8_ = _g_object_ref0 (_tmp7_);
	action = _tmp8_;
	gtk_activatable_set_related_action ((GtkActivatable*) open_button, action);
	result = (GtkToolItem*) open_button;
	_g_object_unref0 (action);
	_g_object_unref0 (recent_menu);
	_g_object_unref0 (recent_manager);
	return result;
}


static void __lambda69_ (MainWindowFile* self, GtkRecentChooser* chooser) {
	gchar* uri = NULL;
	GtkRecentChooser* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	DocumentTab* _tmp5_ = NULL;
	DocumentTab* _tmp6_ = NULL;
	g_return_if_fail (chooser != NULL);
	_tmp0_ = chooser;
	_tmp1_ = gtk_recent_chooser_get_current_uri (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = self->priv->_main_window;
	_tmp3_ = g_file_new_for_uri (uri);
	_tmp4_ = _tmp3_;
	_tmp5_ = main_window_open_document (_tmp2_, _tmp4_, TRUE);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_free0 (uri);
}


static void ___lambda69__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender, gpointer self) {
	__lambda69_ ((MainWindowFile*) self, _sender);
}


static void main_window_file_configure_recent_chooser (MainWindowFile* self, GtkRecentChooser* recent_chooser) {
	GtkRecentChooser* _tmp0_ = NULL;
	GtkRecentChooser* _tmp1_ = NULL;
	GtkRecentFilter* filter = NULL;
	GtkRecentFilter* _tmp2_ = NULL;
	GtkRecentChooser* _tmp3_ = NULL;
	GtkRecentChooser* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recent_chooser != NULL);
	_tmp0_ = recent_chooser;
	gtk_recent_chooser_set_local_only (_tmp0_, FALSE);
	_tmp1_ = recent_chooser;
	gtk_recent_chooser_set_sort_type (_tmp1_, GTK_RECENT_SORT_MRU);
	_tmp2_ = gtk_recent_filter_new ();
	g_object_ref_sink (_tmp2_);
	filter = _tmp2_;
	gtk_recent_filter_add_application (filter, PACKAGE_NAME);
	_tmp3_ = recent_chooser;
	gtk_recent_chooser_set_filter (_tmp3_, filter);
	_tmp4_ = recent_chooser;
	g_signal_connect (_tmp4_, "item-activated", (GCallback) ___lambda69__gtk_recent_chooser_item_activated, self);
	_g_object_unref0 (filter);
}


void main_window_file_update_sensitivity (MainWindowFile* self, gboolean sensitive) {
	gchar** action_names = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint action_names_length1 = 0;
	gint _action_names_size_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("FileSave");
	_tmp1_ = g_strdup ("FileSaveAs");
	_tmp2_ = g_strdup ("FileClose");
	_tmp3_ = g_strdup ("FileCreateTemplate");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	action_names = _tmp4_;
	action_names_length1 = 4;
	_action_names_size_ = action_names_length1;
	_tmp5_ = action_names;
	_tmp5__length1 = action_names_length1;
	{
		gchar** action_name_collection = NULL;
		gint action_name_collection_length1 = 0;
		gint _action_name_collection_size_ = 0;
		gint action_name_it = 0;
		action_name_collection = _tmp5_;
		action_name_collection_length1 = _tmp5__length1;
		for (action_name_it = 0; action_name_it < _tmp5__length1; action_name_it = action_name_it + 1) {
			gchar* _tmp6_ = NULL;
			gchar* action_name = NULL;
			_tmp6_ = g_strdup (action_name_collection[action_name_it]);
			action_name = _tmp6_;
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				GtkAction* _tmp9_ = NULL;
				GtkAction* _tmp10_ = NULL;
				GtkAction* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				_tmp7_ = self->priv->_action_group;
				_tmp8_ = action_name;
				_tmp9_ = gtk_action_group_get_action (_tmp7_, _tmp8_);
				_tmp10_ = _g_object_ref0 (_tmp9_);
				action = _tmp10_;
				_tmp11_ = action;
				_tmp12_ = sensitive;
				gtk_action_set_sensitive (_tmp11_, _tmp12_);
				_g_object_unref0 (action);
				_g_free0 (action_name);
			}
		}
	}
	action_names = (_vala_array_free (action_names, action_names_length1, (GDestroyNotify) g_free), NULL);
}


void main_window_file_on_file_new (MainWindowFile* self) {
	gchar* contents = NULL;
	MainWindow* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = latexila_templates_dialogs_open ((GtkWindow*) _tmp0_);
	contents = _tmp1_;
	_tmp2_ = contents;
	if (_tmp2_ != NULL) {
		DocumentTab* tab = NULL;
		MainWindow* _tmp3_ = NULL;
		DocumentTab* _tmp4_ = NULL;
		DocumentTab* _tmp5_ = NULL;
		Document* _tmp6_ = NULL;
		Document* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp3_ = self->priv->_main_window;
		_tmp4_ = main_window_create_tab (_tmp3_, TRUE);
		tab = _tmp4_;
		_tmp5_ = tab;
		_tmp6_ = document_tab_get_document (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = contents;
		document_set_contents (_tmp7_, _tmp8_);
		_g_object_unref0 (tab);
	}
	_g_free0 (contents);
}


void main_window_file_on_new_window (MainWindowFile* self) {
	LatexilaApp* _tmp0_ = NULL;
	LatexilaApp* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_instance ();
	_tmp1_ = _tmp0_;
	g_action_group_activate_action ((GActionGroup*) _tmp1_, "new-window", NULL);
	_g_object_unref0 (_tmp1_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


void main_window_file_on_file_open (MainWindowFile* self) {
	GtkFileChooserDialog* file_chooser = NULL;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	MainWindow* _tmp6_ = NULL;
	Document* _tmp7_ = NULL;
	Document* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp32_ = NULL;
	GtkFileChooserDialog* _tmp33_ = NULL;
	GtkFileFilter* latex_filter = NULL;
	GtkFileFilter* _tmp34_ = NULL;
	GtkFileFilter* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	GtkFileFilter* _tmp37_ = NULL;
	GtkFileFilter* _tmp38_ = NULL;
	GtkFileChooserDialog* _tmp39_ = NULL;
	GtkFileFilter* _tmp40_ = NULL;
	GtkFileFilter* _tmp41_ = NULL;
	GtkFileFilter* all_files_filter = NULL;
	GtkFileFilter* _tmp42_ = NULL;
	GtkFileFilter* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GtkFileFilter* _tmp45_ = NULL;
	GtkFileChooserDialog* _tmp46_ = NULL;
	GtkFileFilter* _tmp47_ = NULL;
	GtkFileFilter* _tmp48_ = NULL;
	GSList* files_to_open = NULL;
	GtkFileChooserDialog* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	MainWindow* _tmp53_ = NULL;
	GtkFileChooserDialog* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	GtkFileChooserDialog* _tmp56_ = NULL;
	gboolean jump_to = FALSE;
	GSList* _tmp57_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Open Files");
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = _ ("_Cancel");
	_tmp3_ = _ ("_Open");
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, (GtkWindow*) _tmp1_, GTK_FILE_CHOOSER_ACTION_OPEN, _tmp2_, GTK_RESPONSE_CANCEL, _tmp3_, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp4_);
	file_chooser = _tmp4_;
	_tmp6_ = self->priv->_main_window;
	_tmp7_ = main_window_get_active_document (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		MainWindow* _tmp9_ = NULL;
		Document* _tmp10_ = NULL;
		Document* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		_tmp9_ = self->priv->_main_window;
		_tmp10_ = main_window_get_active_document (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = document_get_location (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp5_ = _tmp13_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GFile* location = NULL;
		MainWindow* _tmp14_ = NULL;
		Document* _tmp15_ = NULL;
		Document* _tmp16_ = NULL;
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		gchar* dirname = NULL;
		GFile* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		GtkFileChooserDialog* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		_tmp14_ = self->priv->_main_window;
		_tmp15_ = main_window_get_active_document (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = document_get_location (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		location = _tmp19_;
		_tmp20_ = location;
		_tmp21_ = g_file_get_parent (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_file_get_path (_tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		dirname = _tmp24_;
		_tmp25_ = file_chooser;
		_tmp26_ = dirname;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp25_, _tmp26_);
		_g_free0 (dirname);
		_g_object_unref0 (location);
	} else {
		MainWindow* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		_tmp27_ = self->priv->_main_window;
		_tmp28_ = _tmp27_->default_location;
		if (_tmp28_ != NULL) {
			GtkFileChooserDialog* _tmp29_ = NULL;
			MainWindow* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			_tmp29_ = file_chooser;
			_tmp30_ = self->priv->_main_window;
			_tmp31_ = _tmp30_->default_location;
			gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp29_, _tmp31_);
		}
	}
	_tmp32_ = file_chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp32_, FALSE);
	_tmp33_ = file_chooser;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp33_, TRUE);
	_tmp34_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp34_);
	latex_filter = _tmp34_;
	_tmp35_ = latex_filter;
	_tmp36_ = _ ("All LaTeX Files");
	gtk_file_filter_set_name (_tmp35_, _tmp36_);
	_tmp37_ = latex_filter;
	gtk_file_filter_add_pattern (_tmp37_, "*.tex");
	_tmp38_ = latex_filter;
	gtk_file_filter_add_pattern (_tmp38_, "*.bib");
	_tmp39_ = file_chooser;
	_tmp40_ = latex_filter;
	_tmp41_ = _g_object_ref0 (_tmp40_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp39_, _tmp41_);
	_tmp42_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp42_);
	all_files_filter = _tmp42_;
	_tmp43_ = all_files_filter;
	_tmp44_ = _ ("All Files");
	gtk_file_filter_set_name (_tmp43_, _tmp44_);
	_tmp45_ = all_files_filter;
	gtk_file_filter_add_pattern (_tmp45_, "*");
	_tmp46_ = file_chooser;
	_tmp47_ = all_files_filter;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp46_, _tmp48_);
	files_to_open = NULL;
	_tmp49_ = file_chooser;
	_tmp50_ = gtk_dialog_run ((GtkDialog*) _tmp49_);
	if (_tmp50_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp51_ = NULL;
		GSList* _tmp52_ = NULL;
		_tmp51_ = file_chooser;
		_tmp52_ = gtk_file_chooser_get_files ((GtkFileChooser*) _tmp51_);
		__g_slist_free__g_object_unref0_0 (files_to_open);
		files_to_open = _tmp52_;
	}
	_tmp53_ = self->priv->_main_window;
	_tmp54_ = file_chooser;
	_tmp55_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp54_);
	_g_free0 (_tmp53_->default_location);
	_tmp53_->default_location = _tmp55_;
	_tmp56_ = file_chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp56_);
	jump_to = TRUE;
	_tmp57_ = files_to_open;
	{
		GSList* file_collection = NULL;
		GSList* file_it = NULL;
		file_collection = _tmp57_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* _tmp58_ = NULL;
			GFile* file = NULL;
			_tmp58_ = _g_object_ref0 ((GFile*) file_it->data);
			file = _tmp58_;
			{
				MainWindow* _tmp59_ = NULL;
				GFile* _tmp60_ = NULL;
				gboolean _tmp61_ = FALSE;
				DocumentTab* _tmp62_ = NULL;
				DocumentTab* _tmp63_ = NULL;
				_tmp59_ = self->priv->_main_window;
				_tmp60_ = file;
				_tmp61_ = jump_to;
				_tmp62_ = main_window_open_document (_tmp59_, _tmp60_, _tmp61_);
				_tmp63_ = _tmp62_;
				_g_object_unref0 (_tmp63_);
				jump_to = FALSE;
				_g_object_unref0 (file);
			}
		}
	}
	__g_slist_free__g_object_unref0_0 (files_to_open);
	_g_object_unref0 (all_files_filter);
	_g_object_unref0 (latex_filter);
	_g_object_unref0 (file_chooser);
}


void main_window_file_on_file_save (MainWindowFile* self) {
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	Document* _tmp5_ = NULL;
	Document* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_document (_tmp4_);
	_tmp6_ = _tmp5_;
	main_window_save_document (_tmp3_, _tmp6_, FALSE);
}


void main_window_file_on_file_save_as (MainWindowFile* self) {
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	Document* _tmp5_ = NULL;
	Document* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_document (_tmp4_);
	_tmp6_ = _tmp5_;
	main_window_save_document (_tmp3_, _tmp6_, TRUE);
}


void main_window_file_on_create_template (MainWindowFile* self) {
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	Document* doc = NULL;
	MainWindow* _tmp3_ = NULL;
	Document* _tmp4_ = NULL;
	Document* _tmp5_ = NULL;
	Document* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	gchar* template_contents = NULL;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	gchar* _tmp11_ = NULL;
	MainWindow* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = main_window_get_active_document (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	doc = _tmp6_;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) doc, &_tmp7_, &_tmp8_);
	start = _tmp7_;
	end = _tmp8_;
	_tmp9_ = start;
	_tmp10_ = end;
	_tmp11_ = gtk_text_buffer_get_text ((GtkTextBuffer*) doc, &_tmp9_, &_tmp10_, FALSE);
	template_contents = _tmp11_;
	_tmp12_ = self->priv->_main_window;
	latexila_templates_dialogs_create_template ((GtkWindow*) _tmp12_, template_contents);
	_g_free0 (template_contents);
	_g_object_unref0 (doc);
}


void main_window_file_on_manage_templates (MainWindowFile* self) {
	GtkDialog* dialog = NULL;
	MainWindow* _tmp0_ = NULL;
	LatexilaTemplatesManageDialog* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = (LatexilaTemplatesManageDialog*) latexila_templates_manage_dialog_new ((GtkWindow*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	dialog = (GtkDialog*) _tmp1_;
	gtk_dialog_run (dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


void main_window_file_on_file_close (MainWindowFile* self) {
	MainWindow* _tmp0_ = NULL;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	DocumentTab* _tmp5_ = NULL;
	DocumentTab* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_tab (_tmp4_);
	_tmp6_ = _tmp5_;
	main_window_close_tab (_tmp3_, _tmp6_, FALSE);
}


static void value_main_window_file_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_main_window_file_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		main_window_file_unref (value->data[0].v_pointer);
	}
}


static void value_main_window_file_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_window_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_main_window_file_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_main_window_file_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		MainWindowFile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_window_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_main_window_file_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MainWindowFile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_window_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_main_window_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMainWindowFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_main_window_file (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_FILE), NULL);
	return value->data[0].v_pointer;
}


void value_set_main_window_file (GValue* value, gpointer v_object) {
	MainWindowFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_window_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_file_unref (old);
	}
}


void value_take_main_window_file (GValue* value, gpointer v_object) {
	MainWindowFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_file_unref (old);
	}
}


static void main_window_file_class_init (MainWindowFileClass * klass) {
	main_window_file_parent_class = g_type_class_peek_parent (klass);
	((MainWindowFileClass *) klass)->finalize = main_window_file_finalize;
	g_type_class_add_private (klass, sizeof (MainWindowFilePrivate));
}


static void main_window_file_instance_init (MainWindowFile * self) {
	self->priv = MAIN_WINDOW_FILE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void main_window_file_finalize (MainWindowFile* obj) {
	MainWindowFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_FILE, MainWindowFile);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_action_group);
}


GType main_window_file_get_type (void) {
	static volatile gsize main_window_file_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_file_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_file_init, value_main_window_file_free_value, value_main_window_file_copy_value, value_main_window_file_peek_pointer, "p", value_main_window_file_collect_value, "p", value_main_window_file_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowFile), 0, (GInstanceInitFunc) main_window_file_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_file_type_id;
		main_window_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_window_file_type_id__volatile, main_window_file_type_id);
	}
	return main_window_file_type_id__volatile;
}


gpointer main_window_file_ref (gpointer instance) {
	MainWindowFile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void main_window_file_unref (gpointer instance) {
	MainWindowFile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_WINDOW_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



