/*
 * $Id: cmd_history.c,v 1.1 2004/12/21 23:26:18 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <lcrash.h>

/*
 * history_usage() -- Print the usage string for the 'history' command.
 */

#define _HIST_USAGE "[n]"
void
history_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _HIST_USAGE);
}

/*
 * history_help() -- Print the help information for the 'history' command.
 */
void
history_help(command_t *cmd)
{
	CMD_HELP(cmd,_HIST_USAGE,
		"Without the optional parameter, displays the current history. "
		"Optional argument 'n' specifies the number of commands that "
		"are kept in the history list.");
}

/*
 * history_complete() -- Complete arguments of 'history' command.
 */
char *
history_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
		return(ret);
	}
	fprintf(cmd->ofp, "\n");
	history_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
