/*
 * $Id: lc_trace_s390.h,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of lcrash, an analysis tool for Linux memory dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __LC_TRACE_S390_H
#define __LC_TRACE_S390_H

#define STACK_SEGMENTS_S390	 2
#define STACK_SIZE_S390	 KL_KSTACK_SIZE_S390
#define STACK_MASK_S390  (~(STACK_SIZE_S390 - 1))

#define STD_SFRAME_SIZE_S390  96
#define ADDR_MASK_S390        0x7fffffffUL
#define RA_OFFSET_S390        56
#define CURRENT_TASK_S390(SP) ((SP) & 0xffffe000UL)
#define IS_USER_PSW_S390(PSW) ((PSW) & 0x10000UL)

/* init trace stuff for s390 dumps */
int trace_init_s390(void);

#endif /* __LC_TRACE_S390_H */
