/*
 * $Id: kl_hwgraph.h,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libhwconfig.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003-2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef __KL_HWGRAPH_H
#define __KL_HWGRAPH_H

typedef struct vertex_s {
	htnode_t 	 	 htn;
	kaddr_t		 	 vertex;
	void			*dentry;
	char			*name;
} vertex_t;
#define v_next htn.next
#define v_prev htn.prev
#define v_parent htn.parent
#define v_children htn.children

typedef struct vertex_label_s {
	char 			*name;
	uint64_t		 desc;
	uint64_t		 info;
} vertex_label_t;

#define FIRST_CHILD(cvp) ((vertex_t *)(cvp->v_parent->children))

#define PATH(p) (p->pchunk->prev->path[p->pchunk->prev->current])

#define PATHS_PER_CHUNK 100

typedef struct path_chunk_s {
        struct path_chunk_s	*next;
        struct path_chunk_s     *prev;
        int                      current;
        struct path_rec_s	*path[PATHS_PER_CHUNK];
} path_chunk_t;

typedef struct path_rec_s {
        struct path_rec_s      *next;
        struct path_rec_s      *prev;
	vertex_t	       *vertex;
        char                   *name;
} path_rec_t;

typedef struct path_s {
        int			count;
        path_chunk_t           *pchunk;
} path_t;

#define FT_MASK			0xf000
#define FT_SPEC 		0x2000
#define FT_DIR 			0x4000
#define FT_REG 			0x8000
#define FT_LINK			0xa000

#define IS_SPECIAL(m)	(((m) & FT_MASK) == FT_SPEC)
#define IS_DIR(m)	(((m) & FT_MASK) == FT_DIR)
#define IS_REG(m)	(((m) & FT_MASK) == FT_REG)
#define IS_LINK(m)	(((m) & FT_MASK) == FT_LINK)

#define INFO_MAGIC 0x4857434c
#define LABEL_LENGTH_MAX 	   256
#define HWGRAPH_NUM_INDEX_INFO       2

extern kaddr_t hwgraph_root_addr;
extern vertex_t *hwgraph_root;
extern int DEVFS_ENTRY_SZ;
extern int LABELCL_INFO_SZ;
extern int LABEL_INFO_SZ;

/* Function prototypes
 */
path_rec_t *kl_alloc_path_rec(vertex_t *, int);
void kl_free_path_rec(path_rec_t *);
void kl_free_path_records(path_rec_t *);
path_t *kl_alloc_path_table(int);
void kl_free_path_table(path_t *);
void kl_add_to_path(path_rec_t *, path_rec_t *);
path_rec_t *kl_clone_path(path_rec_t *, int);
void kl_delete_last_path(path_t *);
void kl_push_path_rec(path_t *, vertex_t *, int);
void kl_pop_path_rec(path_t *);
void kl_dup_current_path(path_t *, int);
path_t *kl_get_hw_pathnames(int);
vertex_t *kl_find_vertex(vertex_t *, char *);
kaddr_t kl_vertex_info_addr(vertex_t *);
vertex_t *kl_get_vertex(kaddr_t, int);
void kl_free_vertex(vertex_t *);
vertex_label_t *kl_vertex_label(vertex_t *, char *);
void kl_free_vertex_label(vertex_label_t *);
int kl_get_hwgraph(int);

#endif /* __KL_HWGRAPH_H */
