/*
 * $Id: kl_dump_alpha.c,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#include <klib.h>

int
kl_set_dumparch_alpha(void)
{
	KLP->dump->arch.pageoffset = KL_PAGE_OFFSET_ALPHA;
	KLP->dump->arch.kstacksize = KL_KSTACK_SIZE_ALPHA;
	KLP->dump->arch.pageshift = KL_PAGE_SHIFT_ALPHA;
	KLP->dump->arch.pagesize = KL_PAGE_SIZE_ALPHA;
	KLP->dump->arch.pagemask = KL_PAGE_MASK_ALPHA;
	KLP->dump->arch.pgdshift = KL_PGDIR_SHIFT_ALPHA;
	KLP->dump->arch.pgdsize = KL_PGDIR_SIZE_ALPHA;
	KLP->dump->arch.pgdmask = KL_PGDIR_MASK_ALPHA;
	KLP->dump->arch.pmdshift = KL_PMD_SHIFT_ALPHA;
	KLP->dump->arch.pmdsize = KL_PMD_SIZE_ALPHA;
	KLP->dump->arch.pmdmask = KL_PMD_MASK_ALPHA;
	KLP->dump->arch.ptrsperpgd = KL_PTRS_PER_PGD_ALPHA;
	KLP->dump->arch.ptrsperpmd = KL_PTRS_PER_PMD_ALPHA;
	KLP->dump->arch.ptrsperpte = KL_PTRS_PER_PTE_ALPHA;
	KLP->dump->arch.kernelstack = kl_kernelstack_alpha;
	KLP->dump->arch.mmap_virtop = kl_mmap_virtop_alpha;
	return(0);
}
