/*
 * $Id: kl_list.h,v 1.1 2004/12/21 23:26:23 tjm Exp $
 *
 * This file is part of libutil.
 * A library which provides auxiliary functions.
 * libutil is part of lkcdutils -- utilities for Linux kernel crash dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003, 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef __KL_LIST_H
#define __KL_LIST_H

typedef struct list_type_s {
	struct list_type_s	*next;
	struct list_type_s	*prev;
} list_type_t;

#define LIST_ADDR(s, type, member) \
	((list_type_t *)((char *)(s)+(unsigned long)(&((type *)0)->member)))

#define LIST_TO_STRUCT(l, type, member) \
	((t *)((char *)(l)-(unsigned long)(&((type *)0)->member)))

#define LIST_NEXT(l, type, member) LIST_TO_STRUCT((l)->next, type, member)

#define LIST_PREV(l, type, member) LIST_TO_STRUCT((l)->prev, type, member)

/* Function prototypes
 */
void list_add(list_type_t *, list_type_t *);
void list_remove(list_type_t *);

#endif /* __KL_LIST_H */
