/*
 * Copyright (c) 2009-~ Niu Tao
 *
 * This source code is released for free distribution under the terms of the
 * GNU General Public License
 *
 * Author:       Niu Tao<niutao0602@gmail.com>
 * Created Time: Sat 22 Jan 2011 06:33:56 PM CST
 *
 *
 * Description:  
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "iwindow.h"
#include "cwindow.h"
#include "iqconnect.h"
#include "debug.h"
#include "user.h"
#include "message.h"
#include "cqconnect.h"
#include "iterminal.h"

void lcrt_qconnect_on_button_connect_clicked(GtkButton *button, gpointer user_data)
{
    struct lcrt_qconnect *lqconnect = (struct lcrt_qconnect *)user_data;
    struct lcrt_window *lwindow = lqconnect->parent;
    struct lcrtc_user *user;
    char name[HOSTNAME_LEN + 256];
    const char *hostname;
    int i = 1;

    lcrt_protocol_t protocol = lcrt_user_get_protocol(
        gtk_combo_box_get_active_text(GTK_COMBO_BOX(lqconnect->q_cb_protocol)));
    if (protocol == LCRT_PROTOCOL_SHELL)
        hostname = "shell";
    else
        hostname = gtk_entry_get_text(GTK_ENTRY(lqconnect->q_et_hostname));
    
    strcpy(name, hostname);
    if (lqconnect->flag != LCRT_QCONNECT_SESSION_OPTION) {
        if (protocol != LCRT_PROTOCOL_SHELL ||
            (protocol == LCRT_PROTOCOL_SHELL && 
            (user = lcrt_user_find_by_name(&lwindow->u_config, name)) == NULL)) {
    
            user = lcrtc_user_create();
            if (user == NULL)
                return;
            if (lcrt_user_find_by_name(&lwindow->u_config, name) != NULL) {
                do {
                    sprintf(name, "%s (%d)", hostname, i++);
                    if (lcrt_user_find_by_name(&lwindow->u_config, name) == NULL)
                        break;
                } while (i < 100);
            }
            lcrtc_user_set_data(
               user,
               name,
               hostname,
               protocol,
               gtk_entry_get_text(GTK_ENTRY(lqconnect->q_et_username)),
               NULL,
               atoi(gtk_entry_get_text(GTK_ENTRY(lqconnect->q_et_port))),
               TRUE
            );
            lcrtc_user_ref(user);
            lcrt_user_add(&lwindow->u_config, user);
        }
        lcrt_window_set_current_user(lwindow, user);
        if (lqconnect->flag == LCRT_QCONNECT_IN_TAB) {
            lcrt_create_terminal(lwindow->w_notebook);
        }
    } else {
        if ((user = lcrt_user_find_by_name(&lwindow->u_config, lqconnect->uname)) != NULL) {
            lcrtc_user_set_data(
               user,
               lqconnect->uname,
               hostname,
               protocol,
               gtk_entry_get_text(GTK_ENTRY(lqconnect->q_et_username)),
               NULL,
               atoi(gtk_entry_get_text(GTK_ENTRY(lqconnect->q_et_port))),
               TRUE
            );
        }
    }
    lcrt_qconnect_on_button_cancel_clicked(NULL, lqconnect);
    if (lcrt_window_get_auto_save(lwindow)) {
        lcrt_user_save_one(&lwindow->u_config, user);
    }
    debug_print("qconnecting...\n");
    return;
}
void lcrt_qconnect_on_entry_hostname_changed(GtkWidget *widget, gpointer user_data)
{
    struct lcrt_qconnect *lqconnect = (struct lcrt_qconnect *)user_data;
    if (gtk_entry_get_text_length(GTK_ENTRY(widget)) > 0)
        gtk_widget_set_sensitive(lqconnect->q_bt_connect, TRUE);
    else
        gtk_widget_set_sensitive(lqconnect->q_bt_connect, FALSE);
}
void lcrt_qconnect_on_button_cancel_clicked (GtkButton *button, gpointer user_data)
{
    struct lcrt_qconnect *lqconnect = (struct lcrt_qconnect *)user_data;
    debug_where();
    gtk_widget_destroy(lqconnect->q_connect);
    lcrt_destroy_qconnect(lqconnect);
}

gboolean lcrt_qconnect_on_window_delete(GtkWidget *widget, GdkEvent  *event, gpointer user_data)
{
    lcrt_qconnect_on_button_cancel_clicked(NULL, user_data);
    return FALSE;
}
void lcrt_qconnect_on_protocol_changed(GtkComboBox *widget, gpointer user_data)
{
    struct lcrt_qconnect *lqconnect = (struct lcrt_qconnect *)user_data;
    const char *str_port[LCRT_PROTOCOL_NUMBER] = {LCRT_PROTOCOL_PORT};
    const char *proto = gtk_combo_box_get_active_text(GTK_COMBO_BOX(widget));

    debug_print("protocol: %s\n", proto);
    gtk_widget_set_sensitive(lqconnect->q_et_hostname, TRUE);
    gtk_widget_set_sensitive(lqconnect->q_et_username, TRUE);
    gtk_widget_set_sensitive(lqconnect->q_cb_firewall, TRUE);
    gtk_widget_set_sensitive(lqconnect->q_et_port, TRUE);
    lcrt_qconnect_on_entry_hostname_changed(lqconnect->q_et_hostname, lqconnect);

    lcrt_protocol_t protocol = lcrt_user_get_protocol(proto);
    if (protocol == LCRT_PROTOCOL_SSH1) {
        gtk_widget_set_sensitive(lqconnect->q_ssh_frame, TRUE);
        lcrt_qconnect_destroy_ssh1(lqconnect);
        lcrt_qconnect_destroy_ssh2(lqconnect);
        lcrt_qconnect_create_ssh1(lqconnect);
    } else if (protocol == LCRT_PROTOCOL_SSH2) {
        gtk_widget_set_sensitive(lqconnect->q_ssh_frame, TRUE);
        lcrt_qconnect_destroy_ssh1(lqconnect);
        lcrt_qconnect_destroy_ssh2(lqconnect);
        lcrt_qconnect_create_ssh2(lqconnect);
    } else if (protocol == LCRT_PROTOCOL_SHELL) {
        gtk_widget_set_sensitive(lqconnect->q_et_hostname, FALSE);
        gtk_widget_set_sensitive(lqconnect->q_et_username, FALSE);
        gtk_widget_set_sensitive(lqconnect->q_cb_firewall, FALSE);
        gtk_widget_set_sensitive(lqconnect->q_et_port, FALSE);
        gtk_widget_set_sensitive(lqconnect->q_bt_connect, TRUE);
        gtk_widget_set_sensitive(lqconnect->q_ssh_frame, FALSE);
    } else {
        gtk_widget_set_sensitive(lqconnect->q_ssh_frame, FALSE);
    }
    gtk_entry_set_text(GTK_ENTRY(lqconnect->q_et_port), str_port[protocol]);
    if (protocol == LCRT_PROTOCOL_TELNET || protocol == LCRT_PROTOCOL_TELNET_SSL)
        gtk_entry_set_editable(GTK_ENTRY(lqconnect->q_et_port), FALSE);
}
