<?php
/*
	$Id: selfServiceLogin.php,v 1.12 2008-09-28 12:25:34 roland Exp $

	This code is part of LDAP Account Manager Pro (http://www.sourceforge.net/projects/lam)
	Copyright (C) 2006 - 2007  Roland Gruber
*/

/**
* User login page for self service.
*
* @package selfService
*
* @author Roland Gruber
*/

/** Access to self service profiles */
include_once('../../lib/selfService.inc');
/** status messages */
include_once('../../lib/status.inc');

// start session
session_save_path("../../sess");
@session_start();

$cfgMain = new LAMCfgMain();
$defaultProfile = $cfgMain->default;
$config_object = new LAMConfig($defaultProfile);
$_SESSION['language'] = $config_object->get_defaultLanguage();


setlanguage();

// remove double slashes if magic quotes are on
if (get_magic_quotes_gpc() == 1) {
	$postKeys = array_keys($_POST);
	for ($i = 0; $i < sizeof($postKeys); $i++) {
		if (is_string($_POST[$postKeys[$i]])) $_POST[$postKeys[$i]] = stripslashes($_POST[$postKeys[$i]]);
	}
}

// remove double slashes if magic quotes are on
if (get_magic_quotes_gpc() == 1) {
	$getKeys = array_keys($_GET);
	for ($i = 0; $i < sizeof($getKeys); $i++) {
		if (is_string($_GET[$getKeys[$i]])) $_GET[$getKeys[$i]] = stripslashes($_GET[$getKeys[$i]]);
	}
}

$scope = $_GET['scope'];
$name = $_GET['name'];
$profile = loadSelfServiceProfile($name, $scope);
$errors = array();


if (isset($_POST['login'])) {
	$searchAttribute = $profile->searchAttribute;
	$user = $profile->LDAPUser;
	$password = $profile->LDAPPassword;
	$serverURL = $profile->serverURL;
	$suffix = $profile->LDAPSuffix;
	$clientUser = $_POST['username'];
	$clientPassword = $_POST['password'];
	// connect to LDAP server
	$server = @ldap_connect($serverURL);
	if ($server) {
		// use LDAPv3
		ldap_set_option($server, LDAP_OPT_PROTOCOL_VERSION, 3);
		// start TLS if possible
		if (function_exists('ldap_start_tls')) {
			@ldap_start_tls($server);
			// connect without TLS if it failed
			if (ldap_errno($server) != 0) {
				@ldap_close($server);
				$server = @ldap_connect($serverURL);
				ldap_set_option($server, LDAP_OPT_PROTOCOL_VERSION, 3);
			}
		}
		$bind = @ldap_bind($server, $user, $password);
		if ($bind) {
			// login ok, search user DN
			$result = @ldap_search($server, escapeDN($suffix), $searchAttribute . "=" . $clientUser, array('DN'), null, 1);
			$info = @ldap_get_entries($server, $result);
			if ($info['count'] == 1) {
				$clientDN = $info[0]['dn'];
				// try to bind with client DN
				$bind = @ldap_bind($server, $clientDN, $clientPassword);
				if (!$bind) {
					$errors[] = array("ERROR", _("Wrong password/user name combination. Please try again."));
				}
				else {
					$_SESSION['header'] = 
						'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">' . "\n" .
						'<html><head>' . "\n" .
						'<meta http-equiv="content-type" content="text/html; charset=UTF-8">' . "\n" .
						'<meta http-equiv="pragma" content="no-cache">' . "\n" .
						'<meta http-equiv="cache-control" content="no-cache">' . "\n";
					// TODO encrypt password/user name
					$_SESSION['selfService_clientDN'] = $clientDN;
					$_SESSION['selfService_clientPassword'] = $clientPassword;
					metaRefresh('selfServiceMain.php?scope=' . $scope . '&amp;name=' . $name);
					die();
				}

			}
			else {
				$errors[] = array("ERROR", _("Wrong password/user name combination. Please try again."));
			}
		}
		else {
			$errors[] = array("ERROR", _("Cannot connect to specified LDAP server. Please try again."));
		}
	}
	else {
		$errors[] = array("ERROR", _("Cannot connect to specified LDAP server. Please try again."));
	}
}

// remove session objects
$sessionKeys = array_keys($_SESSION);
for ($i = 0; $i < sizeof($sessionKeys); $i++) {
	if (substr($sessionKeys[$i], 0, 12) == "selfService_") unset($_SESSION[$sessionKeys[$i]]);
}

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache">
	<title>
		<?php
			echo _("Login");
		?>
	</title>
	<link rel="stylesheet" type="text/css" href="../../style/layout.css">
</head>
<body>
	<?php
		// set focus on password field
		echo "<script type=\"text/javascript\" language=\"javascript\">\n";
		echo "<!--\n";
		echo "window.onload = function() {\n";
			echo "loginField = document.getElementsByName('username')[0];\n";
			echo "loginField.focus();\n";
		echo "}\n";
		echo "//-->\n";
		echo "</script>\n";
	?>
	<p align="center"><a href="http://lam.sourceforge.net" target="_blank">
		<img src="../../graphics/banner.jpg" border=1 alt="LDAP Account Manager"></a>
	</p>
	<hr>

	<?PHP
	if (sizeof($errors) > 0) {
		for ($i = 0; $i < sizeof($errors); $i++) {
			call_user_func_array('StatusMessage', $errors[$i]);
		}
	}
	?>

	<br>
	<br>
	<?php echo "<form action=\"selfServiceLogin.php?scope=" . $scope . "&amp;name=" . $name . "\" method=\"post\">"; ?>
	<table align="center" border="2" rules="none" bgcolor="white">
		<tr>
			<td style="border-style:none" rowspan="3" width="20"></td>
			<td style="border-style:none" height="20" colspan="2"></td>
			<td style="border-style:none" rowspan="3" width="20"></td>
		</tr>
		<tr>
			<td style="border-style:none" align="center" colspan="2"><b> <?php echo $profile->loginCaption; ?> </b></td>
		</tr>
		<tr><td style="border-style:none" colspan="2">&nbsp;</td></tr>
		<tr>
			<td style="border-style:none" rowspan="5" width="20"></td>
			<td style="border-style:none" align="right">
			<?PHP
				echo $profile->loginAttributeText . ": ";
			?>
			</td>
			<td style="border-style:none" align="left">
			<?PHP
				echo "&nbsp;<input type=\"text\" name=\"username\">\n";
			?>
			</td>
			<td style="border-style:none" rowspan="5" width="20" colspan="2"></td>
		</tr>
		<tr>
			<td style="border-style:none" align="right">
			<?PHP
				echo _("Password") . ": ";
			?>
			</td>
			<td style="border-style:none" align="left">
			<?PHP
				echo "&nbsp;<input type=\"password\" name=\"password\">\n";
			?>
			</td>
		</tr>
		<tr>
			<td  style="border-style:none" colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td  style="border-style:none" colspan="2" align="center">
				<?PHP echo "<input type=\"submit\" name=\"login\" value=\"" . _("Ok") . "\">\n"; ?>
			</td>
		</tr>
		<tr>
			<td  style="border-style:none" colspan="2">&nbsp;</td>
		</tr>
	</table>
	</form>

</body>
</html>

