#include "gen/llvm.h"
#include "declaration.h"
#include "gen/irstate.h"
#include "ir/irvar.h"


//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

IrVar::IrVar(VarDeclaration* var)
{
    V = var;
    value = NULL;
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

IrGlobal::IrGlobal(VarDeclaration* v): IrVar(v),
    type(llvm::OpaqueType::get(gIR->context()))
{
    constInit = NULL;
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

IrLocal::IrLocal(VarDeclaration* v) : IrVar(v)
{
    nestedIndex = -1;
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

IrField::IrField(VarDeclaration* v) : IrVar(v)
{
    assert(V->ir.irField == NULL && "field for this variable already exists");
    V->ir.irField = this;

    if (v->aggrIndex)
    {
        index = v->aggrIndex;
        unionOffset = 0;
    }
    else
    {
        index = 0;
        unionOffset = v->offset;
    }
    constInit = NULL;
}

extern LLConstant* get_default_initializer(
    VarDeclaration* vd,
    Initializer* init);

llvm::Constant * IrField::getDefaultInit()
{
    if (constInit)
        return constInit;
    constInit = get_default_initializer(V, V->init);
    return constInit;
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
