from ldtpcommon import *

class Request:
    def __init__ (self):
        pass

    def parsexml (self, xmlpacket):
        """Returns the value obtained from the server's return LDTP packet"""
        global ldtpDebug
        _requestCommand = 0
        _context        = None
        _component      = None
        _requestId      = None
        _requestObj     = None
        _arguments      = None
        _argsList       = None

        try:
            dom = parseString (xmlpacket)
            try:
                _requestObj  = dom.getElementsByTagName ('REQUEST')[0]
            except IndexError:
                if ldtpDebug:
                    print 'Invalid request'
                return None
            try:
                _requestCommand = int (getText (_requestObj.getElementsByTagName ('COMMAND') [0].childNodes))
                _requestId  = getText (_requestObj.getElementsByTagName ('ID') [0].childNodes)
                _context = getText (_requestObj.getElementsByTagName ('CONTEXT') [0].childNodes)
            except ValueError:
                if ldtpDebug:
                    print 'Invalid Command'
                return None
            except IndexError:
                if ldtpDebug:
                    print 'Invalid Command'
                return None
            try:
                _component = getText (_requestObj.getElementsByTagName ('COMPONENT') [0].childNodes)
            except ValueError:
                pass
            except IndexError:
                # component tag may not be present
                pass
            try:
                _arguments = getText (_requestObj.getElementsByTagName ('ARGUMENTS'))
            except IndexError:
                pass
            _argsList = []
            for dataelements in _arguments:
                for data in dataelements.getElementsByTagName ('ARGUMENT'):
                    _argsList.append (getText (data.childNodes))
        except ExpatError, msg:
            if msg.code == xml.parsers.expat.errors.XML_ERROR_NO_ELEMENTS:
                return None
            if xml.parsers.expat.ErrorString (msg.code) == xml.parsers.expat.errors.XML_ERROR_NO_ELEMENTS:
                return None
            # Return all the respective values, let the calling function decide what to do with the values
        return _requestId, _requestCommand, _context, _component, _argsList
