/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <arpa/inet.h>
#include "context.h"
#include "pnglite.h"
#include "erlang.h"

/*
 * Protocol v8:
 *
 * P6\n                   PPM header
 * 640 400 255\n          Width, Height, Colors
 * [ image data ] (PPM)   RGB_BUFFSIZE bytes
 *
 */
void
v8(const Context_t *ctx)
{
  uint32_t proto = 8, proto2;
  uint32_t total, total2;
  u_char *data;
  char buff[MAXLEN];

  /* get picture */
  data = export_RGB_active_buffer(ctx, 1);

  memset(&buff, '\0', MAXLEN);
  g_snprintf(buff, MAXLEN, "P6  %d %d 255\n", WIDTH, HEIGHT);

  /* send packet size */
  total = sizeof(uint32_t)+strlen(buff)+RGB_BUFFSIZE*sizeof(uint8_t);
  total2 = htonl(total);
  write_uint32(&total2);
  
  /* protocol version */
  proto2 = htonl(proto);
  write_uint32(&proto2);

  /* PPM header */
  write_binary((uint8_t *)&buff, strlen(buff));

  /* PPM data */
  write_binary(data, RGB_BUFFSIZE*sizeof(uint8_t));
  xfree(data);
}
