/*
 *  Copyright 1994-2014 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <GL/gl.h>
#include <arpa/inet.h>
#include "context.h"
#include "erlang.h"

/*
 * Protocol v3:
 * [ volume ]             1 byte, 0..100 (% volume)
 * [ width ] "W"          2 bytes
 * [ height ] "H"         2 bytes
 * [ pixel_format ]       2 bytes (OpenGL spec)
 * [ pixel_type ]         2 bytes (OpenGL spec)
 * [ image data ]         W*H*pixel_format_size bytes
 *
 */

static u_char
get_volume(const Context_t *ctx)
{
  /* Return the volume as 0..100 */
  float vol = Input_get_volume(ctx->input);

  return (u_char)(vol * 100.0);
}


void
v3(const Context_t *ctx)
{
  u_char volume;
  uint16_t width = WIDTH, width2;
  uint16_t height = HEIGHT, height2;
  uint16_t pf, pf2; /* pixel format */
  uint16_t pt, pt2; /* pixel type */
  uint32_t proto, proto2;
  uint32_t total, total2;
  Pixel_t *src;

  /* send packet size */
  total = sizeof(uint32_t)+sizeof(u_char)+4*sizeof(uint16_t)+RGB_BUFFSIZE*sizeof(u_char);
  total2 = htonl(total);
  write_uint32(&total2);
  
  /* protocol version */
  proto = 3;
  proto2 = htonl(proto);
  write_uint32(&proto2);

  /* send volume */
  volume = get_volume(ctx);
  write_uint8(&volume);
  
  /* send width, height */
  width2 = htons(width);
  height2 = htons(height);
  write_uint16(&width2);
  write_uint16(&height2);

  /* send pixel format */
  pf = GL_RGB;
  pf2 = htons(pf);
  write_uint16(&pf2);

  /* send pixel type */
  pt = GL_UNSIGNED_BYTE;
  pt2 = htons(pt);
  write_uint16(&pt2);

  /* send picture */
  src = export_RGB_active_buffer(ctx, 0);
  write_binary(src, RGB_BUFFSIZE);
  xfree(src);
}
