#include "squeeze.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("Squeeze your lemon!");

static const char version[] = "v0.4.1";

int main(int argc, char **argv)
{
    KAboutData about("squeeze", 0, ki18n("squeeze"), version, ki18n(description), KAboutData::License_GPL, ki18n("(C) 2007 Miguel Chavez Gamboa"), KLocalizedString(), 0, "miguel.chavez.gamboa@gmail.com");
    about.addAuthor( ki18n("Miguel Chavez Gamboa"), KLocalizedString(), "miguel.chavez.gamboa@gmail.com" );
    KCmdLineArgs::init(argc, argv, &about);

    KCmdLineOptions options;
    options.add("+[URL]", ki18n( "Document to open" ));
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;

    // register ourselves as a dcop client
    //app.dcopClient()->registerAs(app.name(), false);

    // see if we are starting with session management
    if (app.isSessionRestored())
        RESTORE(squeeze)
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            squeeze *widget = new squeeze;
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                squeeze *widget = new squeeze;
                widget->show();
            }
        }
        args->clear();
    }

    return app.exec();
}
