/***************************************************************************
 *   Copyright (C) 2007-2008 by Miguel Chavez Gamboa                            *
 *   miguel.chavez.gamboa@gmail.com                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *

 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#define QT_GUI_LIB

#include <QtGui>
#include <QDate>
#include <QSqlRelationalDelegate>
#include "offersdelegate.h"

OffersDelegate::OffersDelegate(QObject *parent) : QSqlRelationalDelegate(parent)
{
}

QWidget *OffersDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
  if (index.column() == 5 ) return QSqlRelationalDelegate::createEditor(parent, option, index);
  else {
    QDate date;
    QWidget *editor;
    QDoubleSpinBox *dSpinbox = new QDoubleSpinBox(parent);
    QSpinBox       *iSpinbox = new QSpinBox(parent);
    switch(index.column())
    {
      case 1: //discount
        editor = dSpinbox;
        dSpinbox->setMinimum(0);
        dSpinbox->setMaximum(99.99);
        dSpinbox->setSuffix(" %");
        break;
      case 2: //day
        editor  = iSpinbox;
        iSpinbox->setMinimum(1);
        iSpinbox->setMaximum(31);
        break;
      case 3: //month
        editor  = iSpinbox;
        iSpinbox->setMinimum(1);
        iSpinbox->setMaximum(12);
        break;
      case 4: //year
         editor = iSpinbox;
         date = QDate::currentDate();
         iSpinbox->setMinimum(date.year());
         iSpinbox->setMaximum(10000); //at year 10,000 are we going to be using this? ..maybe we does not exists anymore
        break;
      default : //Never must be here...
        break;
    }
    return editor;
  }
}

#include "offersdelegate.moc"
