#include "lemon.h"
#include <kapplication.h>
//#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kurl.h>
#include <QPixmap>
#include <ksplashscreen.h>
#include <kstandarddirs.h>

static const char description[] =
    I18N_NOOP("Lemon, A point of sale for linux");

static const char version[] = "0.5";
KSplashScreen *splash;

int main(int argc, char **argv)
{
    KAboutData about("lemon", 0, ki18n("lemon"), version, ki18n(description), KAboutData::License_GPL, ki18n("(C) 2007 Miguel Chavez Gamboa"), KLocalizedString(), 0, "miguel.chavez.gamboa@gmail.com");
    about.addAuthor( ki18n("Miguel Chavez Gamboa"), KLocalizedString(), "miguel.chavez.gamboa@gmail.com" );
    KCmdLineArgs::init(argc, argv, &about);

    KCmdLineOptions options;
    //options.add("+[URL]", ki18n( "Document to open" ));
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;

    // register ourselves as a dcop client
    //app.dcopClient()->registerAs(app.name(), false);

    // see if we are starting with session management
    if (app.isSessionRestored())
        RESTORE(lemon)
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            QPixmap image (KStandardDirs().findResource("data", "lemon/images/splash_screen.png"));
            splash = new KSplashScreen(image, Qt::WindowStaysOnTopHint);
            splash->show();
            lemon *widget = new lemon;
            widget->show();
            splash->finish(widget);
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                lemon *widget = new lemon;
                widget->show();
            }
        }
        args->clear();
    }

    return app.exec();
}
