#include "lc_global.h"
#include "lc_colors.h"
#include "lc_math.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <zlib.h>
#include "minifig.h"
#include "opengl.h"
#include "pieceinf.h"
#include "project.h"
#include "system.h"
#include "lc_library.h"
#include "lc_application.h"

// =============================================================================
// Static variables

// Settings for the 2013.2 update (from holly-wood@holly-wood.it).
static const unsigned char sDefaultSettings[] = 
{
  0x78,0x9C,0xED,0x9D,0x79,0x73,0xE3,0x46,0xB2,0xE0,0xFF,0xDE,0x89,0xF0,0x77,0xC0,0xE3,0xC6,0xBA,0x3D,0x11,0xA2,0x9A,0x00,0x78,0xCE,0xCC,0x9B,0x58,0x92,0x3A,0x6D,
  0x5D,0x26,0xD9,0x2D,0x7B,0x8E,0xE8,0x00,0x49,0x48,0xC4,0x08,0x04,0x68,0x00,0x6C,0xB5,0x26,0xF6,0xC3,0x6F,0x66,0x55,0xE1,0xBE,0x2A,0x21,0x75,0x3F,0xC7,0x7B,0xEC,
  0x19,0xDB,0x6A,0x49,0xAC,0x1F,0xAA,0x50,0x95,0x95,0x99,0x95,0x95,0xF9,0x67,0xE5,0xFA,0x6A,0x6A,0xAC,0x8F,0x2D,0xC7,0xFA,0xEE,0x0F,0x7F,0x56,0x3E,0x9A,0x9E,0x6F,
  0xB9,0x8E,0xA2,0x75,0x54,0xBD,0xDD,0xD1,0xBE,0xFB,0x03,0xFE,0xEF,0xCF,0xF0,0xD7,0x4E,0xB7,0xDD,0xE9,0xB7,0x55,0x4D,0xB9,0x70,0x6D,0xFB,0x45,0xB9,0x77,0xDD,0xB5,
  0x62,0xAC,0xD7,0xE6,0x5A,0xB9,0x3A,0xF1,0x8C,0x67,0x65,0x67,0x78,0x81,0xAF,0xEC,0x77,0x6B,0x23,0x30,0xC5,0xAF,0x6B,0xF1,0x27,0x07,0xF0,0x61,0xE5,0xCA,0x58,0x6D,
  0xB6,0x86,0xE3,0x28,0xD7,0xD6,0x6A,0x63,0x98,0xB6,0x62,0xAE,0xAD,0x00,0x1A,0xF0,0x57,0x86,0xA3,0xB8,0xDE,0xDA,0xF4,0x14,0xDF,0x5C,0x05,0x80,0x8F,0x3F,0x38,0x6A,
  0xAB,0x43,0x02,0x52,0x8F,0x3E,0xA9,0xAA,0x40,0x25,0x7C,0xB2,0x2B,0x3E,0xD9,0x83,0x3E,0xB6,0x75,0x55,0xF6,0x93,0xBD,0x76,0x47,0x15,0x9F,0xEC,0xB7,0x3B,0xC3,0x76,
  0xA7,0xA7,0x8C,0x6D,0xDB,0x74,0x94,0xF9,0xD6,0x0A,0x36,0xCA,0x83,0xF5,0x05,0x3E,0xFA,0xD9,0xF0,0x2C,0x77,0xEF,0x2B,0xCB,0xFD,0xA3,0x2F,0x7E,0x79,0x04,0xC3,0x83,
  0xBF,0x2C,0x89,0x19,0xC5,0x98,0x11,0x1B,0x94,0x3E,0xE1,0x93,0x5A,0xF4,0x49,0xB5,0x53,0x38,0x9C,0xE1,0xF3,0x5D,0xCD,0x5F,0x1C,0x78,0x68,0x1F,0xFF,0x6D,0xFA,0x96,
  0x6F,0xC6,0x4F,0x0B,0x83,0xA2,0x8D,0x08,0x4C,0xF1,0x22,0x00,0xD8,0x51,0xDB,0x5A,0x97,0xC2,0x54,0x56,0x9E,0x69,0xE0,0xBC,0x58,0xBE,0x28,0x3F,0x1E,0x4F,0x8F,0x95,
  0x05,0xCC,0x16,0xE7,0x31,0x6E,0x10,0x67,0xA2,0xE4,0xA3,0x30,0x7E,0xFC,0xC9,0x01,0xED,0x93,0x62,0xE0,0x70,0x2A,0xA9,0xB4,0x4F,0xEA,0xF1,0x27,0x61,0x5A,0x14,0x0C,
  0x5C,0xD3,0xEE,0xE3,0xAC,0x6E,0x6B,0xB2,0xF3,0x86,0x3D,0xB9,0xF8,0xA4,0xC6,0x3A,0xA1,0x13,0x3E,0xA9,0xC5,0x9F,0x84,0x21,0x97,0x5D,0x12,0x0C,0x14,0x7F,0x12,0x9E,
  0xB6,0x60,0x19,0x06,0xCF,0xAE,0xE2,0x98,0xCF,0xCA,0x0A,0x3E,0xF3,0xE8,0x7A,0x56,0x5D,0xB7,0x35,0x5C,0x5B,0x6A,0x87,0xF0,0x08,0xE1,0xC3,0xEB,0xD8,0x6D,0xD2,0x27,
  0xF5,0xF8,0x93,0xF0,0xF0,0xD2,0xDD,0xD6,0xE3,0x6E,0x33,0x66,0xD1,0x5B,0x2F,0xFD,0x64,0x24,0x68,0xFF,0xF3,0x0D,0xFF,0x60,0x7B,0x8B,0x8D,0xE5,0x83,0x14,0xB2,0x4D,
  0x05,0xFE,0x0B,0x23,0xCC,0xC6,0x97,0x49,0x7C,0xE5,0xA3,0x7E,0xDC,0xE9,0x80,0xDC,0x55,0x36,0xD6,0xE3,0xC6,0xF4,0xBE,0x06,0xFD,0xCA,0x72,0xE0,0xCD,0x2E,0xCD,0x47,
  0xCB,0x71,0x2C,0xE7,0x51,0x79,0x46,0x99,0xF8,0x67,0xC5,0xF0,0x4C,0x65,0xE5,0x6E,0xB7,0xA6,0x03,0xE3,0x70,0x7C,0x7C,0x8C,0xBF,0x7A,0xBA,0xDD,0x05,0x2F,0x8A,0xCD,
  0x3E,0x80,0x3F,0xB7,0x1E,0x1D,0xD7,0x33,0xD7,0x7C,0x54,0x2E,0x6F,0x16,0xB3,0xDB,0x93,0x0F,0xD3,0xC5,0xE5,0xED,0x0D,0xFF,0xCE,0x62,0x63,0xC6,0x1B,0x17,0xEF,0x60,
  0x60,0xDA,0xB6,0xCF,0xBF,0xF9,0xCE,0x57,0xB6,0xF0,0xFD,0x07,0xEB,0x51,0x79,0x34,0x1D,0xD3,0x33,0x02,0xE8,0xE6,0xF3,0x06,0xB6,0x1D,0x31,0xF8,0x48,0x30,0x3E,0x1B,
  0x96,0x6D,0x2C,0x6D,0xF3,0x08,0x1B,0x34,0x7C,0xE5,0x19,0x1A,0xC0,0xFF,0xC2,0x4A,0xB4,0x3C,0x65,0xE7,0xFA,0x16,0xEE,0x45,0x8A,0xE1,0xAC,0x15,0xCF,0x0D,0x0C,0xFC,
  0xCB,0x31,0x1F,0xD0,0x47,0xEB,0x33,0x3C,0xE6,0x8B,0xBB,0x57,0x1E,0xF6,0xF0,0x99,0x9D,0xFB,0x0C,0x7B,0x97,0xFB,0x19,0xFE,0x05,0x9F,0xC5,0xD6,0x7C,0xD3,0x86,0x9D,
  0x0C,0x1B,0x57,0xE0,0x2B,0xD6,0xD1,0x23,0x10,0xFF,0x81,0x62,0xD8,0xBE,0xAB,0x6C,0x4D,0xC3,0x41,0x8C,0x11,0xE0,0xEF,0x2B,0x30,0xD1,0xBD,0x40,0xD9,0x20,0xD9,0x85,
  0xC1,0x12,0x33,0x63,0xAD,0x98,0xD0,0xE0,0x0B,0xB6,0x16,0x58,0x5B,0x53,0xCC,0x1D,0x0F,0x9A,0x33,0x50,0x4A,0x18,0x6C,0xFD,0xA4,0xA6,0xD2,0xCA,0x75,0x02,0xC3,0x62,
  0x03,0x1D,0xF6,0x9E,0xFD,0xFC,0x58,0xF9,0x15,0x9E,0x14,0x37,0x59,0x98,0x85,0xAC,0x3D,0x80,0xB2,0xD5,0xE7,0xAE,0x4D,0x9C,0x0F,0xD0,0x11,0x0F,0x9E,0xF8,0xE1,0x08,
  0x67,0xC3,0xBF,0xF6,0x7E,0xA0,0xAC,0xDD,0x67,0xC7,0x76,0x61,0x92,0xE0,0xAF,0x86,0xCF,0xC3,0x46,0xF9,0xC1,0x73,0xB7,0xD8,0xC6,0xF3,0xF3,0xF3,0xF1,0x06,0xE7,0x77,
  0xFB,0x19,0xE6,0xF7,0xB1,0x15,0xBC,0xDF,0xDA,0x2B,0x63,0xDD,0x36,0x9D,0xE3,0x4D,0xB0,0xB5,0x8F,0x95,0x7B,0x78,0xD7,0x16,0x20,0x95,0x07,0x20,0xAD,0x8D,0x17,0x7C,
  0xE4,0x82,0xF9,0x0F,0xDD,0xC6,0xE6,0x96,0x26,0xEC,0x99,0xA2,0x73,0x9C,0xCA,0x68,0xCF,0x16,0x0C,0x2F,0x1B,0x12,0x1C,0x1B,0xFC,0xC0,0x31,0x7B,0xF5,0xCE,0x7E,0xBB,
  0x04,0x4D,0x45,0x01,0x40,0xF8,0xBB,0x8E,0x01,0x83,0xE4,0x99,0x0F,0x7C,0x26,0xC3,0x6F,0xC7,0x8F,0x7E,0x14,0x37,0xE8,0x07,0xD6,0xEA,0x09,0x07,0x9A,0x4D,0xBA,0xF1,
  0x7A,0xCD,0xDE,0xB1,0x81,0xEB,0x34,0xFA,0x9D,0xB5,0xF9,0xC0,0xA6,0x21,0x7E,0x83,0xAB,0x25,0xEE,0x03,0x53,0x52,0x1C,0x1C,0x04,0xD7,0x5E,0x23,0x79,0xBD,0xF7,0x70,
  0xA0,0xF1,0x77,0x6C,0x63,0xEF,0xAC,0x36,0xD8,0x1E,0xFC,0x1E,0x7E,0x63,0xE7,0xB9,0x8F,0x9E,0xB1,0xCD,0xCC,0x29,0x98,0x14,0x41,0x00,0x9F,0x81,0xF5,0xE8,0x7A,0xE1,
  0xEF,0xED,0xA0,0x75,0xCB,0x09,0x60,0x8A,0x32,0xC5,0x87,0xAF,0x10,0xBE,0x29,0x1C,0x2B,0x7C,0xAA,0x5F,0x5F,0xDE,0x5C,0x9E,0x5D,0x9E,0x7F,0x98,0x9D,0x2A,0xE7,0xA7,
  0x37,0xA7,0xB3,0xF1,0xE2,0x76,0xA6,0xCC,0x4F,0xD9,0x62,0xF8,0x53,0xB4,0x1A,0x3C,0xB6,0xC2,0x5D,0xC7,0x0C,0x75,0x28,0x05,0x9B,0x0E,0xE7,0x81,0x98,0x84,0xC7,0xE1,
  0xD2,0x09,0x7F,0x07,0x07,0x8D,0xAF,0x06,0x50,0xCC,0xD6,0xB8,0x4C,0x5E,0x94,0xB6,0x62,0xB1,0x6E,0xBC,0xF0,0xEF,0x5B,0xBE,0x8F,0x1D,0xC5,0x05,0xE4,0xB9,0xF0,0x05,
  0x17,0x1E,0x7B,0xA1,0x1C,0x18,0xFC,0xE9,0x61,0x04,0x71,0xD8,0x8C,0xBD,0x1D,0xC0,0x37,0xFC,0x00,0x04,0xCD,0x91,0x58,0x70,0xF0,0x54,0x6B,0xEB,0x01,0x5E,0x0B,0xF0,
  0xD9,0xEC,0xE1,0x73,0x1E,0xE6,0x2A,0x7E,0x03,0x1F,0xFC,0x3F,0xD8,0xFA,0x07,0xE5,0x90,0x2D,0x7F,0xBE,0x10,0xF0,0x5D,0xC0,0xEC,0x72,0x9F,0x91,0x0D,0xE3,0xB5,0x35,
  0x82,0x3F,0xE1,0xAF,0xB5,0xFE,0x72,0x62,0xF9,0x3B,0xDB,0x78,0x61,0x8F,0xFE,0xD7,0x16,0x7E,0x63,0xBC,0x78,0x7F,0x75,0x32,0xE3,0xEF,0x4E,0x7C,0xF7,0x2F,0x67,0xB6,
  0xF1,0xE8,0xFF,0x55,0xF9,0xCB,0xB5,0x11,0x78,0xD6,0x17,0xF8,0xE2,0xF6,0xE1,0x01,0xC6,0xFF,0xAF,0xD8,0x46,0xBA,0x09,0x3E,0x9F,0x70,0xF2,0x88,0xB7,0x27,0xC6,0x0A,
  0xDF,0x9A,0x15,0xF0,0xC7,0x67,0xBF,0x0E,0x2F,0x5F,0x4C,0x37,0xF1,0x1B,0xD8,0x56,0xE6,0x8F,0x6D,0xF9,0x01,0x47,0xE4,0x1E,0x8A,0x71,0xA2,0xBF,0x66,0x61,0x30,0xBC,
  0xAD,0x16,0x9B,0x18,0x1B,0x0B,0xB6,0x0A,0x27,0xC9,0x08,0x3B,0x63,0xD8,0xCF,0xB8,0x8C,0x3A,0x30,0xCB,0x7D,0xD3,0xFB,0xCC,0x26,0xA3,0x07,0x12,0x28,0xD8,0xC3,0x7B,
  0x82,0x17,0xC2,0x7E,0x37,0xEC,0xB0,0x11,0xC9,0x2C,0x78,0xB5,0xF8,0x2D,0xC5,0x50,0x55,0xF8,0x47,0x83,0x7F,0x74,0x14,0xBA,0x8A,0xA1,0xEB,0xAC,0x01,0x77,0x07,0xF2,
  0x05,0xDE,0x9F,0xB1,0xDB,0x99,0x86,0x67,0x38,0x2B,0x10,0x8D,0xE9,0xBE,0x75,0xE0,0xDD,0x3E,0x7A,0xA6,0x19,0x37,0x09,0x3B,0xB3,0xCD,0x79,0x62,0x5C,0x59,0xEF,0x5C,
  0xF6,0x75,0xB4,0x0A,0x50,0xAA,0x71,0x89,0x06,0xE3,0x06,0x23,0xB8,0x32,0xBF,0xD6,0x1E,0x07,0xE3,0x11,0x4E,0x69,0x3E,0x9B,0x73,0x3B,0x9D,0xFA,0x55,0x77,0x3A,0x6C,
  0x71,0x3E,0x1D,0xDF,0x28,0xB7,0xB3,0x93,0xD3,0x82,0xC5,0x09,0x32,0xD0,0x60,0x6F,0x09,0xE7,0x36,0x13,0x75,0xC1,0xC6,0xDD,0x3F,0x6E,0xD8,0xF8,0x58,0xCE,0xCA,0xDE,
  0x83,0x20,0xDE,0x3B,0x30,0x7E,0xD6,0xCA,0xC2,0x57,0x01,0x5B,0xCE,0x0A,0xE4,0x30,0x17,0xB5,0x5C,0x5E,0xC2,0x3A,0x73,0x79,0x7F,0x8E,0x98,0x94,0x70,0xF7,0x81,0x10,
  0xE4,0x28,0x30,0x61,0x53,0x81,0x57,0x0C,0x7F,0xDF,0x72,0x11,0x12,0xF0,0xD7,0xC1,0x9B,0x63,0x62,0x37,0xD9,0x12,0xFB,0xF1,0x3F,0xEE,0xC6,0xB3,0xC5,0x9C,0xB1,0xFE,
  0x71,0x17,0xCA,0xB5,0x63,0x05,0x66,0x2E,0x9B,0xA6,0x28,0xA6,0xF6,0x4E,0x34,0xE7,0x99,0x91,0x86,0xE2,0x98,0x4B,0xEB,0xF0,0xA9,0xA3,0x9F,0xF3,0xA6,0x6D,0x6B,0xE9,
  0x19,0x20,0x43,0xB0,0xD1,0x36,0xCC,0x9A,0x9D,0xE9,0xAC,0x99,0xF4,0x10,0x72,0x1A,0x26,0x32,0x7C,0xDF,0xDF,0xB8,0xCF,0x28,0xD2,0x2D,0x27,0xDC,0x8D,0xF8,0xA7,0x03,
  0x9C,0x63,0xC9,0x26,0xF8,0xB7,0x77,0x9E,0xF9,0xD9,0x82,0x4D,0x04,0x64,0x01,0xEC,0x4B,0x5C,0x86,0x19,0x4F,0xD0,0x73,0x17,0x84,0xB9,0x19,0xEE,0xA3,0xA8,0xE7,0x88,
  0x51,0x86,0x2F,0x6F,0x6E,0x17,0x8A,0xF9,0xDB,0x1E,0x3A,0x2F,0x76,0x82,0xD6,0x19,0x2E,0xBD,0xBF,0x2A,0x73,0xEC,0xC7,0x1D,0xB6,0xDB,0x62,0x3A,0x08,0x60,0x98,0x1C,
  0x73,0xD8,0xAE,0x03,0xFB,0x07,0x68,0x1D,0x7C,0xDB,0xC1,0x26,0x3C,0xF3,0xD9,0x03,0x1B,0x95,0xB5,0xC0,0x3E,0x74,0x6C,0xC3,0xEE,0x88,0xC3,0x73,0xAC,0xDC,0xE2,0xEF,
  0x8B,0x2D,0x2D,0x70,0x5D,0xD0,0x3D,0xA2,0xFE,0xB2,0xBD,0xC0,0x29,0xF8,0x14,0xBC,0x25,0x7C,0xEB,0xF0,0xE4,0xD0,0xF4,0xCA,0x7D,0x74,0x40,0xE3,0x57,0x50,0x4E,0xC0,
  0xE4,0xBC,0xBE,0x3B,0x11,0x03,0x9F,0xD8,0xC8,0xFD,0x3D,0xDF,0x59,0x5A,0xE6,0x17,0x2E,0x66,0x5B,0x7C,0x50,0xFE,0x43,0x89,0x44,0x79,0x00,0x7F,0x6F,0xC3,0x68,0xC2,
  0xB2,0xE3,0xD3,0x3D,0xDC,0x34,0x7D,0x10,0x9F,0xF0,0x82,0x70,0x2F,0xCF,0xBF,0x0A,0xBE,0x83,0xC2,0x87,0xB0,0x9D,0x70,0x53,0xC3,0x51,0xF0,0xF7,0xCB,0xF0,0xAF,0x7C,
  0xF1,0x8A,0x9D,0x8F,0x6F,0xBC,0x68,0xA8,0x18,0x5F,0xE0,0x97,0x76,0x3B,0x17,0xDF,0x0D,0x3E,0x96,0x83,0xD3,0x60,0x3C,0x9F,0x5E,0x5E,0xB6,0x51,0xA3,0x38,0x06,0x89,
  0x01,0x8D,0x62,0xBB,0x30,0x84,0xA7,0xFF,0x11,0xA9,0xA1,0x16,0xAA,0x00,0x81,0xB9,0x85,0x4F,0xE2,0x0B,0xF6,0x5D,0x7B,0xCF,0x84,0xC9,0xDE,0x09,0x2C,0x31,0x49,0x8F,
  0x5D,0xEF,0x91,0x2D,0x12,0x03,0xE5,0xCD,0x1A,0x1F,0xD6,0x60,0x8A,0x95,0xC1,0x27,0x5E,0xF8,0x99,0x70,0x73,0x61,0x5D,0xE5,0xDB,0x28,0xEC,0xE0,0x7C,0xE3,0xC6,0xEE,
  0xF9,0xF8,0x6F,0xB6,0xD7,0xC2,0xF4,0x8C,0xB7,0x9F,0x50,0x57,0x3C,0x0E,0x1F,0x70,0x1E,0xB0,0x19,0xC6,0x96,0xCC,0xDF,0x71,0x05,0x7F,0x62,0x2B,0xF8,0x9F,0x6C,0x92,
  0xDD,0x3A,0x26,0xDF,0x91,0x70,0x27,0x5D,0x5B,0xF0,0xC2,0xD8,0xFE,0x08,0xA3,0x82,0x43,0x12,0xED,0xA5,0x7C,0x77,0xC2,0xE1,0x37,0xF8,0xAF,0x5B,0xFE,0x9F,0x14,0x47,
  0xF9,0x4F,0xE5,0x2F,0xF3,0x8B,0xDB,0xFB,0xFF,0x77,0x71,0x79,0x72,0xFA,0x57,0xE5,0xEF,0x7F,0x81,0xB7,0x3C,0xBE,0x3F,0xB9,0x9C,0xFD,0xF5,0x9F,0x7F,0x6F,0xFD,0xF3,
  0xCE,0x08,0x36,0xB8,0x0D,0xC0,0x97,0xEC,0x31,0xE0,0x17,0x51,0x26,0xB3,0x3F,0xA0,0x39,0x41,0xA7,0xC4,0xA6,0x93,0x58,0x1D,0xE1,0x72,0xF4,0xAD,0xB5,0xC9,0xE7,0x7B,
  0xFC,0x4C,0x7C,0x11,0xE6,0x37,0x24,0xFC,0x64,0x3B,0xB1,0xA2,0xDE,0xC3,0x3C,0x63,0xDF,0x4B,0xAF,0x29,0xFC,0x20,0x3E,0x67,0xE6,0x19,0x70,0x05,0xB0,0xB5,0xFA,0xCD,
  0x1E,0x22,0x1E,0x25,0x78,0x14,0xE5,0xC9,0x7C,0x79,0x06,0x05,0x8C,0x0B,0xC9,0xB5,0x85,0xC6,0x22,0xEA,0x88,0xB0,0x05,0x7D,0xC6,0xE7,0x09,0x36,0x3E,0x08,0x13,0xF6,
  0x10,0xB1,0xF2,0xEC,0xEF,0xCC,0x15,0xA8,0x3C,0xE6,0x9A,0xBD,0x54,0x68,0xF3,0x7F,0xFD,0x2F,0x7C,0x7A,0x80,0xAF,0x9E,0x4C,0xE8,0xC0,0x5F,0x14,0xA6,0x03,0x84,0x2F,
  0x80,0xF5,0x58,0x99,0xEF,0x97,0xC9,0x6E,0xB0,0xCE,0xD9,0x6B,0x5C,0xD8,0x4B,0xD0,0x47,0x19,0x0A,0x57,0xA8,0xB1,0x64,0xF3,0x4F,0x7C,0x83,0x4B,0x40,0xB1,0xDA,0xD3,
  0x7F,0xD6,0x1E,0x3E,0x21,0xB6,0x7F,0xAC,0xDC,0xB8,0x81,0x90,0x51,0xA0,0x56,0xA1,0xA6,0x1D,0x6B,0xAB,0x62,0x9D,0xFB,0xF0,0xD0,0xB0,0x39,0xFA,0x5C,0x4D,0x85,0x79,
  0x0A,0x8F,0x92,0x6F,0x33,0xFA,0xD4,0x16,0x15,0xF4,0x25,0xFE,0xE2,0xCA,0x76,0x7D,0x2E,0x81,0xD7,0xEE,0x1E,0x6D,0x8D,0xDF,0xF6,0x00,0x03,0x19,0xFE,0x43,0xB8,0xDE,
  0x40,0x38,0x80,0x5A,0xE7,0x31,0x4D,0x21,0xDF,0xA4,0xE1,0x80,0x75,0xCA,0xC6,0xDE,0x0F,0x65,0x21,0x9F,0xC1,0x6C,0x3D,0xD8,0xA8,0xED,0x85,0x54,0xFF,0x8F,0x62,0xC5,
  0xFC,0xE3,0xEE,0x28,0xB5,0x73,0x5C,0xDF,0x9E,0x9C,0x5E,0xCD,0x33,0x2A,0x24,0x7F,0x37,0xF8,0x73,0x66,0x68,0x71,0xBD,0x65,0x87,0x6A,0x0B,0x2C,0x42,0x30,0x6B,0x1C,
  0x1C,0x0B,0x10,0x82,0x6C,0x49,0x87,0x2F,0xEC,0x58,0xB9,0x64,0xDF,0x84,0x65,0xBC,0xB2,0xE1,0x73,0x28,0x90,0xA1,0x7F,0xB1,0x38,0x83,0x45,0x07,0xDF,0x84,0x81,0xB4,
  0x0D,0x3F,0x88,0x96,0xF0,0x25,0xD7,0x36,0xC2,0xB9,0x92,0x98,0x41,0xA8,0x0F,0x6F,0xB7,0x56,0x10,0x08,0x8B,0x82,0xBF,0x35,0x78,0x2E,0xDF,0xDF,0x6F,0xF9,0xA6,0x09,
  0xCD,0xA2,0x59,0x94,0x7C,0xAF,0xC7,0xA2,0xDD,0xD3,0x2F,0xC6,0x76,0x67,0x9B,0x7F,0x12,0x7F,0x4D,0x4A,0x07,0xFC,0xBB,0x0A,0x0B,0x9C,0x2D,0x99,0x3B,0x66,0xF4,0x87,
  0x7F,0x8B,0xF1,0x1F,0xA2,0xED,0xFC,0x1F,0xEC,0x57,0x74,0xF8,0x15,0xB6,0xCE,0x8B,0x7F,0x05,0x57,0x17,0xFE,0x5A,0x37,0xFF,0x6B,0xD7,0x2F,0x9F,0xA2,0x1F,0xF7,0xF2,
  0x3F,0x6E,0x8D,0xF7,0x30,0x50,0x68,0x8D,0xFC,0xE3,0xDE,0xF5,0x9E,0x98,0xB2,0x85,0x06,0x88,0xE9,0xFB,0x2D,0xFC,0x48,0x3F,0xFC,0xC8,0xC9,0x9F,0xFE,0xE1,0xBB,0xD0,
  0x71,0xCB,0x63,0xFF,0x05,0x41,0x1F,0x7A,0x1D,0xAE,0xE6,0xBF,0xDE,0x2C,0x2E,0x94,0x93,0xD3,0x33,0xB0,0x35,0x50,0x75,0x99,0xF3,0xEF,0xCF,0xCC,0x47,0x98,0x3C,0xB0,
  0x25,0xF9,0xA1,0x52,0x17,0xD9,0x43,0x01,0xDF,0x7A,0x02,0x6E,0xDC,0x86,0x5A,0x40,0xC2,0x1A,0x67,0x4A,0xFE,0x76,0x09,0x63,0xEC,0x7E,0x89,0x14,0x07,0x1F,0x36,0x0D,
  0x85,0x4F,0x33,0x3F,0xE0,0xEA,0x0A,0xDA,0x88,0xF6,0x6E,0x63,0x2C,0x4D,0xD8,0xCD,0x61,0xBF,0x66,0x84,0xE3,0x22,0xF9,0xCC,0x9F,0x92,0xCB,0xE6,0xFF,0x73,0x37,0x86,
  0x07,0x06,0x19,0xCB,0x5E,0x2A,0x57,0xB0,0x8F,0xE3,0x3F,0xCA,0x49,0xC2,0x86,0x4B,0x2F,0x5B,0x78,0xEB,0xDC,0xBE,0x2A,0x50,0xDF,0x73,0x7F,0xD8,0x06,0xA6,0xFC,0x80,
  0x82,0x90,0x49,0x11,0xB6,0x9B,0x08,0x41,0xF1,0x1F,0x7F,0xCC,0xEF,0x00,0xDC,0xCC,0x8B,0x6C,0xFF,0xE4,0xA2,0xF2,0xD9,0xBE,0xF0,0x97,0xC5,0xE5,0xE2,0x0A,0xF6,0x03,
  0x78,0xF2,0xE9,0xED,0xF5,0xF5,0xF8,0xE6,0x44,0x99,0x2F,0x66,0x97,0x37,0xE7,0x7F,0xE5,0x1B,0x3A,0xFE,0x34,0xD5,0x91,0xC8,0x3A,0xC9,0x59,0x21,0xF1,0xE8,0x0A,0x70,
  0x0B,0xCC,0xD9,0xD0,0xA1,0x38,0xE5,0xE4,0x56,0x71,0x27,0xD7,0x30,0xE5,0xDC,0x47,0x36,0x90,0xE9,0xA7,0x50,0x04,0x31,0x7C,0x70,0xB1,0x44,0xB8,0xCF,0xCE,0x0D,0x8D,
  0xD6,0x7F,0x41,0xFF,0x8E,0x95,0x3B,0x66,0xAC,0x73,0x93,0x1B,0x7E,0x58,0x4C,0xE2,0x8F,0x03,0xBB,0x84,0xBB,0xDA,0xE3,0x4C,0xE1,0xE6,0x03,0x9A,0x1D,0x06,0xAC,0x73,
  0x93,0x9B,0xBF,0x3E,0x2A,0x45,0x65,0xEB,0x4E,0xBC,0xF5,0xE4,0x4B,0x6F,0x4D,0xFF,0xF4,0x8F,0x3B,0x6E,0x63,0xFB,0xFF,0xE0,0x04,0xD6,0xD1,0x8E,0x0A,0xFB,0xC1,0xE9,
  0x15,0x68,0xDF,0xB3,0xCB,0xE9,0xA7,0x9B,0x5F,0x16,0x9F,0xA6,0xE3,0x09,0x8C,0x67,0xFE,0x0F,0xAC,0x08,0x36,0xE3,0x27,0xA7,0xE7,0x97,0x37,0x45,0x1F,0x51,0xFB,0xAC,
  0x41,0x2D,0xD9,0xE0,0xDD,0xED,0xFD,0xE9,0xEC,0xD3,0xD9,0x87,0x1B,0xA6,0xDD,0xCF,0x53,0x8D,0x97,0x34,0x58,0xFC,0x11,0xD1,0xB8,0x9E,0x6C,0x7C,0x36,0xFD,0x85,0xFA,
  0xB4,0xF1,0x47,0x44,0x83,0x5D,0x68,0xF0,0xEC,0x72,0x02,0xC4,0xDB,0xBB,0xC5,0xE5,0x74,0x2E,0xD9,0x60,0xC1,0x47,0xB0,0x41,0x61,0xD6,0x7C,0xB8,0xBB,0xBB,0x9D,0x2D,
  0x84,0x2D,0x73,0x66,0x9A,0x36,0x18,0xF1,0xA0,0xA6,0xA3,0xC5,0xE1,0x82,0x66,0x15,0xFB,0x4D,0xB8,0x83,0xEB,0x12,0xC4,0xEB,0x13,0x73,0x8D,0xA1,0x9E,0x04,0xBA,0xA1,
  0x02,0x73,0xD7,0x80,0x09,0xB5,0x7B,0xC1,0x79,0x6A,0x05,0xC2,0x3B,0x83,0xD3,0x0A,0x97,0x08,0xBA,0x75,0x40,0x16,0x78,0xD6,0x12,0x57,0xA8,0xC5,0x2C,0x22,0x97,0x69,
  0xD6,0x60,0xD1,0xA2,0x4A,0xCA,0x7D,0x28,0xB0,0x47,0x63,0x5B,0xD0,0x0C,0xFA,0x8A,0xF9,0x6C,0x8B,0xDD,0x4F,0xFF,0x37,0xE5,0x89,0xE2,0xE2,0x02,0x98,0xA0,0x34,0x72,
  0x1D,0x7A,0x99,0x9A,0xB1,0x6B,0x97,0x6D,0x33,0x7E,0xDC,0x20,0xB6,0x06,0x3B,0xD2,0x9E,0x79,0x3A,0x12,0x76,0x18,0xD3,0x79,0x8E,0x84,0xD3,0x0E,0x4D,0x0E,0x1F,0xCD,
  0x0B,0xEC,0x9C,0xC1,0x4C,0xEE,0xD8,0x03,0x04,0xDB,0x6E,0xC0,0x7E,0x1D,0x9B,0xE2,0xBA,0x0E,0x3E,0x28,0xF3,0x77,0xA0,0xAB,0x2C,0xD2,0x6E,0x8F,0xF9,0x40,0x8E,0xA7,
  0x3F,0xDD,0xDC,0xDE,0x5F,0x9D,0x9E,0x9C,0x9F,0x5E,0x9F,0xDE,0x2C,0xE6,0x91,0xAD,0xF8,0x05,0x07,0xE0,0x87,0x42,0xA1,0xF8,0xC7,0xE8,0xE0,0xEC,0xC2,0x04,0x0D,0x05,
  0x8F,0xD2,0x8E,0xA2,0x6F,0x85,0x87,0x6B,0x47,0x49,0xEF,0x39,0x13,0xB5,0x63,0x67,0x0D,0x66,0x8C,0x72,0x0F,0x4F,0xE8,0xC1,0x73,0xF2,0x17,0xFB,0xDD,0x1F,0xFE,0x7E,
  0x31,0x5E,0xCC,0x61,0x59,0xB5,0xA6,0xC6,0xAE,0x55,0x2B,0x08,0x8B,0xFF,0xB4,0xBA,0xDD,0x61,0xEF,0x18,0x2C,0xC6,0x44,0x03,0x1D,0xF8,0x47,0x85,0x7F,0xE3,0xFF,0xE2,
  0xFF,0xF2,0x2F,0x38,0x4D,0x19,0x7F,0xB6,0x50,0x4F,0xA0,0x52,0x5B,0x7A,0x47,0x1D,0xA8,0x69,0x5C,0x2D,0xCD,0x0F,0x60,0x92,0x5D,0x98,0xF6,0xD6,0x14,0xF3,0x62,0x0A,
  0x76,0x41,0xFB,0x7C,0x0F,0xFB,0x5A,0x35,0xBF,0xA5,0x0F,0x47,0x7D,0x6A,0xDF,0x72,0xB4,0x1B,0x73,0xF5,0xA4,0x80,0xAC,0x0A,0xD8,0x9E,0x51,0x4E,0x04,0x5A,0xB7,0x4B,
  0xA4,0xB9,0x0E,0xBC,0xD1,0x3D,0x77,0xE4,0x71,0xA6,0xEC,0x88,0x02,0x4D,0xD7,0xA9,0x34,0xF7,0xE9,0x9D,0xAF,0x5C,0x18,0xD2,0x90,0x24,0x6D,0x34,0x3C,0x5E,0xA7,0x3E,
  0x59,0x43,0x3B,0x83,0x4D,0x96,0xD8,0xA7,0x64,0xDF,0x68,0x23,0x89,0x0B,0xEF,0x43,0xE6,0x34,0x26,0xF9,0x04,0xCA,0x04,0x8F,0xA6,0xD0,0x9C,0x54,0x2E,0x40,0x21,0xAD,
  0x7D,0xA0,0x56,0x5F,0xED,0x0D,0x65,0x9F,0x40,0xEB,0xF2,0x47,0x48,0x01,0xD9,0xD4,0x61,0xDF,0xB8,0x72,0x1F,0x5D,0x65,0xBE,0xB1,0x4C,0x7B,0x8D,0x36,0x0B,0xFA,0x00,
  0xF2,0x7C,0xD6,0xE5,0x5D,0x27,0xB5,0x34,0xEA,0x06,0xD8,0x05,0xFD,0x30,0x00,0x81,0xA1,0x90,0x97,0x7F,0x6B,0x30,0xC8,0xAE,0x79,0x12,0x8D,0xF7,0x6E,0xBE,0x05,0xE9,
  0x0C,0x12,0x19,0xB4,0x02,0xE5,0x87,0x39,0xE8,0xAF,0xC1,0x6A,0x1F,0xFC,0xB1,0xA0,0x6F,0x40,0x5B,0xA5,0xBB,0x56,0x47,0x3B,0x07,0xB3,0x21,0x80,0x41,0xF3,0xDC,0x7D,
  0xCD,0x1A,0xCF,0xD3,0xB4,0xDE,0x50,0xFA,0xD5,0x71,0xDA,0x85,0x61,0x79,0xCA,0x04,0xAC,0x4B,0xDF,0xB6,0x56,0x4F,0x24,0x5E,0xAB,0xDF,0x1D,0x8C,0x86,0x14,0x81,0x56,
  0x38,0x55,0xD9,0x13,0x80,0xC2,0xB7,0x04,0x25,0xED,0xCC,0x03,0x9B,0x12,0xB7,0x90,0x99,0x69,0x48,0x08,0xD8,0xD6,0x48,0xEB,0x0C,0x49,0x22,0x35,0xE4,0x9D,0xC1,0xFE,
  0x63,0x0B,0x4B,0xF1,0xCE,0x7A,0x04,0x3B,0xD6,0xF6,0x25,0x78,0x7A,0x5F,0x23,0x6E,0x18,0x8C,0x76,0xE9,0xDB,0xB0,0x95,0x99,0xC4,0x2D,0xA3,0xD5,0xEF,0x34,0xA2,0x5D,
  0x43,0xCF,0xE8,0x5B,0x62,0x4B,0x1F,0x65,0xE6,0xA9,0x1C,0xED,0xCA,0x15,0x1B,0xF5,0x85,0x61,0x3F,0x80,0xAC,0x31,0x60,0x6F,0xAF,0x9F,0xB7,0xB0,0x19,0x76,0xB3,0xEB,
  0x50,0x9A,0x36,0x07,0x4D,0x00,0x75,0x6E,0xE9,0x4E,0xB6,0xBA,0x1D,0x4D,0x1F,0xA5,0x65,0xB8,0x34,0x8D,0x4B,0x33,0xCF,0x74,0x56,0x1B,0xDE,0xBD,0x3A,0x6C,0xAB,0x37,
  0xD2,0xFB,0x7A,0xC3,0xBE,0x31,0xDA,0x85,0x69,0xAC,0x97,0x68,0xFF,0xC8,0xF4,0x0D,0xD4,0x0A,0xB5,0xFB,0x16,0x34,0xF6,0x16,0xCF,0x70,0xAF,0x40,0xCD,0xF5,0x07,0x58,
  0x92,0x60,0xC8,0x04,0x66,0x4A,0xAA,0x71,0xDA,0x34,0x35,0x53,0xA4,0x69,0xF7,0xC6,0xE7,0x17,0x9A,0x84,0x81,0xF7,0xD6,0xA3,0xA9,0x4C,0x8C,0x76,0x67,0x82,0xB6,0x4B,
  0x15,0x9E,0x40,0xD3,0xBA,0x59,0x2D,0x46,0x8A,0xE6,0x3A,0x2F,0x28,0x40,0xC8,0xAB,0x7B,0xA4,0x1B,0xCD,0x69,0xE2,0xAC,0x15,0xC7,0x75,0x02,0xBA,0x72,0x8D,0xF4,0x6A,
  0xF5,0xB5,0x7E,0x56,0x1F,0x94,0xA2,0xED,0x6D,0x1B,0xE4,0x32,0x6E,0x10,0x84,0xEE,0x81,0x5C,0x1E,0xF4,0x1A,0xD0,0xD8,0x46,0x7A,0xA4,0x2C,0xDC,0xBD,0x6F,0x0B,0x17,
  0xA8,0x32,0x47,0x6F,0x26,0x3A,0x90,0x40,0x81,0x29,0x7E,0x04,0xE8,0xDB,0x50,0xED,0x34,0xA2,0xED,0xF1,0xA4,0x40,0xB9,0x32,0x9D,0x47,0xB0,0xC1,0x25,0xFB,0xD6,0xED,
  0xE9,0x9D,0x06,0x72,0x72,0xBE,0xB3,0x9E,0x5E,0xD8,0xFB,0xA2,0xCC,0x93,0x56,0x4F,0x1F,0x0D,0x35,0xBA,0xE4,0xE2,0x34,0x36,0x9E,0x94,0xF7,0x86,0x34,0xB5,0x01,0xED,
  0xD9,0xDC,0x05,0xCA,0x8C,0x1D,0x0E,0x09,0x71,0x89,0xFB,0xF8,0x74,0xEF,0x55,0x2D,0x8A,0xD6,0x68,0x38,0xD0,0x1A,0xCC,0x12,0x31,0x3D,0xA8,0xBA,0x91,0xDA,0xE9,0x74,
  0x49,0xDA,0x0A,0xA7,0xB1,0xFE,0x2C,0x9E,0x5D,0x65,0xB2,0x77,0x24,0x54,0x84,0x90,0x06,0xFB,0x5B,0x67,0x44,0xA4,0x81,0xAA,0x6E,0xAD,0x5C,0xCF,0x21,0xEF,0xDE,0xA0,
  0xF7,0x69,0x64,0xBD,0x2F,0xA2,0xF1,0x2E,0x9E,0x7E,0x06,0x99,0x32,0x7F,0xC2,0x80,0x20,0xDC,0x07,0xA6,0x9E,0xEB,0xFB,0x4B,0x17,0x1D,0x7F,0x59,0xC5,0x9D,0xD1,0xEE,
  0xD2,0x8B,0x40,0x86,0xE6,0x3E,0xDB,0x54,0x15,0x08,0x69,0xA3,0x5E,0x7F,0x40,0x95,0xCA,0x21,0x8D,0x77,0x6D,0x86,0x9A,0xA5,0xCD,0xA2,0x9C,0xD8,0xDF,0x7F,0x35,0x31,
  0x34,0x43,0x99,0x9A,0x4E,0xE0,0x99,0xE9,0xEE,0x71,0xDA,0x1D,0x6D,0x7F,0x83,0x99,0xEE,0x3A,0xCC,0xD1,0x31,0xF6,0x2D,0xA3,0xC0,0xC2,0x29,0xEF,0x9B,0xDE,0xE9,0xD1,
  0x67,0xC9,0xD4,0x7D,0x5E,0xBA,0xB4,0x9D,0x94,0xD1,0x40,0x7B,0x1D,0xD1,0x67,0x09,0xA7,0x09,0xEF,0x83,0xF1,0xD9,0xB0,0xBD,0x17,0x6E,0xD7,0x95,0x1A,0x74,0x31,0xED,
  0xEE,0x9E,0x62,0xD5,0x65,0x69,0x73,0xCB,0xC6,0xA0,0x34,0xF4,0xA2,0xD7,0xC0,0x42,0x9A,0x46,0xA5,0x79,0xEE,0x33,0xE1,0x7D,0x45,0xB4,0x81,0xDA,0x51,0xA9,0xDA,0x6B,
  0x00,0xBA,0xD5,0xDA,0xF5,0x0C,0xFA,0x7B,0x03,0x83,0xBC,0x43,0x95,0x93,0x48,0xFB,0x77,0x13,0xC7,0x58,0x6B,0xD8,0x1B,0x81,0x66,0x2E,0xB7,0x07,0xB4,0xD5,0x6E,0xC4,
  0xBB,0xDC,0xEE,0x4C,0x0F,0xDD,0x8E,0xCC,0x3B,0x05,0x7B,0x8F,0xF1,0xE4,0x4A,0x3C,0x00,0x48,0x93,0x2E,0xD9,0xCA,0x09,0x94,0x0B,0xD8,0x6C,0x70,0xD9,0x99,0x08,0xDA,
  0x49,0xEF,0x06,0x2D,0x4D,0xD7,0x1B,0x48,0xCA,0x9F,0xCC,0x9D,0xD5,0x60,0x30,0x51,0x5B,0xD6,0x65,0xC7,0x32,0x41,0x73,0xAC,0x80,0xEE,0xD8,0x00,0xCD,0x44,0xD5,0xB3,
  0xBE,0x23,0x09,0xDA,0x1D,0xB7,0x01,0xA8,0xCE,0x2A,0xE6,0xCE,0xD4,0xC8,0xB4,0x99,0x41,0xD2,0x7F,0x22,0x1A,0xCC,0x12,0xA2,0xCB,0x0F,0x69,0x0B,0xAF,0xD1,0x86,0x8A,
  0x34,0xA2,0x3B,0x33,0x49,0x13,0x6E,0x05,0xEE,0x1C,0x2A,0x34,0xA3,0xF2,0xB4,0x29,0xC9,0xFF,0x85,0xB4,0x7B,0x54,0x8C,0x27,0x9E,0xB5,0x85,0xBD,0x8D,0xE0,0xD6,0xC4,
  0xF7,0xD6,0x1F,0xD0,0xDE,0x1B,0x18,0x88,0x6B,0x3C,0x90,0x05,0x3B,0x00,0xDD,0x60,0x24,0x8D,0xB2,0x37,0xE8,0x10,0xE7,0x64,0x44,0x9B,0x1A,0xC1,0xB3,0x4B,0xE1,0x31,
  0x8D,0x92,0xB8,0x9F,0x46,0xB4,0x0B,0xD7,0xDB,0xCB,0x2B,0x78,0x8C,0xA6,0x6B,0xDD,0x57,0xD1,0x84,0xE6,0xF5,0x62,0xD6,0x6D,0x6F,0x11,0xED,0xEE,0xE7,0x0E,0x41,0x33,
  0x89,0x68,0x37,0x26,0x06,0xCA,0x2E,0x5E,0x76,0xA6,0xA2,0x4A,0x75,0x91,0xCD,0x12,0xA2,0xB6,0x5C,0x44,0xD3,0xE4,0x68,0xA3,0x4E,0xB7,0x4F,0x94,0x25,0x19,0x1A,0x1B,
  0x49,0x4D,0x39,0x31,0xBC,0xA7,0xA5,0xBD,0x87,0x5D,0xC1,0x31,0x9E,0x0A,0x74,0xD7,0x98,0xF6,0xAA,0x91,0x64,0xB4,0x98,0x15,0x78,0xD6,0xAE,0x04,0x16,0xD1,0x28,0x1A,
  0x65,0x44,0x9B,0xDF,0x2B,0x7F,0x33,0x96,0x9E,0xF1,0x84,0xF3,0x45,0xC6,0xFC,0x40,0xCB,0xBB,0x4F,0xF4,0x98,0x44,0xB4,0xC5,0xDE,0x5B,0xD2,0x56,0x37,0xFA,0xD5,0x88,
  0x7A,0x50,0x44,0xBB,0x37,0x3D,0xF3,0xD9,0xB5,0x1F,0x08,0x5E,0x3C,0xAD,0x9B,0xDD,0x04,0x6A,0x69,0xEC,0x40,0x62,0xEC,0x6D,0xC9,0xEA,0x72,0x6B,0x38,0x18,0xD1,0xBC,
  0xDB,0x49,0x1A,0x9F,0x21,0xF7,0x1B,0x8C,0xBE,0x9C,0x07,0xA6,0xB3,0x02,0xE3,0x8A,0x99,0x54,0x25,0x2B,0x9D,0xD3,0x76,0x24,0xBB,0x43,0xD0,0x6C,0x0B,0xEF,0xEB,0x31,
  0xC3,0x8D,0xDB,0xDE,0x12,0xDE,0x20,0xD0,0xF1,0xB2,0x4A,0x97,0x1C,0xAD,0xC9,0x69,0x6B,0xAB,0xDF,0x19,0x50,0x2D,0xEF,0x88,0x26,0x06,0xD2,0xAA,0xED,0x53,0x8A,0x46,
  0xDA,0xDF,0x8A,0x4F,0x25,0xC2,0x27,0x60,0x67,0xA2,0x33,0x77,0x83,0xF1,0xC3,0xC7,0xCA,0x74,0x63,0x9A,0xD1,0x89,0x28,0x9E,0x5C,0x7E,0xCF,0x8E,0x2E,0xD2,0xF2,0x45,
  0xED,0x74,0x7A,0xD4,0x3D,0xAF,0x86,0x76,0x2C,0x40,0xF8,0xDD,0x53,0x77,0x6B,0x32,0x83,0xE8,0xB8,0x15,0xD1,0x68,0x16,0x2B,0x85,0xB6,0xD8,0x98,0x2E,0x46,0xF4,0x73,
  0x5E,0x48,0xD3,0xA4,0x69,0x39,0xDE,0x07,0x6F,0xFF,0xD4,0xBE,0x30,0x2C,0xE1,0xC0,0x34,0xF0,0xF6,0x88,0x9D,0x1F,0xC5,0xC4,0x58,0x52,0xE5,0x99,0x1C,0x0D,0xFA,0x78,
  0x81,0x9E,0x8E,0xC4,0x82,0xE4,0xB4,0x57,0x8C,0x25,0xDF,0x17,0x3C,0xE3,0x11,0x66,0x06,0xB3,0x2D,0x95,0x85,0x5B,0xBA,0x60,0xC0,0xAE,0xD3,0x34,0x92,0x96,0x29,0x31,
  0x53,0xD9,0x13,0x8C,0xF1,0x7E,0xC3,0x3A,0x37,0x59,0x73,0x0F,0xD2,0xEA,0x0E,0xBB,0x23,0x92,0x44,0xCD,0xF3,0x8E,0x73,0xFD,0x55,0x26,0xB6,0xB1,0x7A,0x4A,0xFC,0x84,
  0x69,0xC2,0xAD,0xB0,0xC7,0x2B,0x9A,0xA6,0x5B,0x4B,0xC3,0x99,0x0B,0xAF,0xD0,0x36,0x37,0xB0,0x45,0x72,0x91,0xDB,0x8A,0xC7,0x77,0xD5,0x21,0xF9,0x04,0xF2,0x63,0x79,
  0xC6,0xEE,0x40,0x9F,0x19,0x2B,0x53,0x39,0xF7,0x2C,0xBB,0xF4,0x68,0xAD,0xD5,0xED,0x75,0xA8,0x16,0x8A,0xA0,0xD9,0x86,0xEF,0x5B,0x2B,0xE1,0x69,0xC4,0x5B,0x67,0x18,
  0xE4,0xA1,0x54,0x06,0x79,0x60,0xC0,0x85,0x46,0x3C,0x3D,0x28,0xA6,0xC1,0x9B,0xAA,0xC5,0x31,0xDA,0xB2,0x09,0x0D,0x74,0x24,0xC0,0x7C,0x34,0x28,0x87,0x9F,0xA0,0x7B,
  0xEA,0x64,0xDD,0x93,0xD1,0x22,0x17,0xC4,0x78,0xD1,0x9E,0x2F,0xC0,0xB2,0xB5,0xDD,0x5A,0xC3,0xA8,0xD5,0x1B,0x8C,0x3A,0xC4,0xD3,0x03,0x41,0xF3,0x60,0x1E,0x5E,0x93,
  0x14,0x26,0x94,0x30,0xA3,0xCE,0x9B,0xED,0x4E,0xE1,0x13,0xE0,0x1A,0xF8,0x68,0xF9,0x78,0xC9,0xED,0x58,0x39,0x77,0x6D,0x3E,0x5F,0x8F,0x84,0xFE,0x01,0xF6,0x45,0x42,
  0xED,0xE0,0x4F,0x40,0x39,0xC1,0x8B,0x79,0xD7,0xB0,0x13,0x54,0x1A,0x29,0x45,0x3D,0x06,0xA5,0x8D,0x18,0x88,0x14,0xD1,0xBC,0x22,0xA1,0x55,0x4D,0xD3,0xE9,0x5E,0x7E,
  0x4E,0xBB,0xC3,0xD4,0x11,0xB4,0x97,0x09,0x7A,0xD4,0x50,0x1B,0x36,0xDA,0xE9,0xE7,0xC6,0x76,0xEF,0x19,0x34,0x9F,0x12,0xF3,0xB8,0x34,0xD2,0xDA,0x04,0x4D,0x1C,0xF7,
  0xA2,0x98,0xAC,0x8A,0x59,0x49,0xD2,0x56,0x0D,0xF6,0xC2,0xF9,0x0A,0x2F,0x77,0x2D,0x3C,0x17,0xEF,0xB5,0xC8,0xFA,0xE5,0x70,0xCD,0x53,0x6D,0x69,0x4E,0x7B,0x82,0xA5,
  0xB1,0x74,0x6B,0x03,0xE2,0x52,0xB4,0x6E,0x5F,0xCF,0x0A,0x6B,0x49,0x5A,0xE0,0x7A,0xDB,0x80,0xD4,0x35,0x7E,0x16,0xD4,0x68,0x4E,0x26,0x69,0xC2,0x25,0x9E,0xFC,0x4E,
  0xB1,0xBD,0xC9,0x68,0x4D,0x2C,0x89,0x3C,0x6D,0x71,0x79,0xDA,0x3E,0xC3,0x53,0x3D,0x84,0xA1,0x30,0xCD,0x9F,0x05,0x09,0x9A,0xBC,0x3E,0x18,0xD1,0xEE,0x95,0x99,0xB9,
  0x34,0x6D,0x39,0x29,0x1D,0xD1,0xF4,0x41,0x23,0x59,0x9D,0xA6,0xF1,0xDE,0x4D,0xD0,0x76,0x17,0xDF,0x2D,0x19,0x49,0xA0,0xED,0x7C,0xFD,0x95,0x7D,0x0B,0x03,0x37,0xCD,
  0xD5,0x93,0x89,0xF7,0x42,0x4A,0x2C,0x40,0x41,0xEB,0xBE,0x09,0x0D,0x8F,0xBC,0x2A,0xBA,0x16,0xD1,0x5E,0xFB,0xDE,0x52,0x07,0x6A,0xA0,0x1F,0xB1,0x3B,0x6F,0x13,0xDB,
  0x7C,0x49,0x71,0x43,0x1A,0x65,0xCF,0x29,0xDF,0xF5,0x24,0x9E,0xE0,0xDC,0x2B,0x79,0x82,0x5E,0x83,0x5D,0xEF,0xA3,0xF5,0x14,0x65,0x7F,0x90,0x74,0xC3,0xE0,0x49,0x3A,
  0xE8,0x83,0xB4,0x38,0x99,0x3C,0xED,0x06,0x2F,0x10,0xC9,0x84,0xDF,0x32,0x5A,0x93,0x75,0xC1,0x17,0x02,0xF3,0x26,0xCB,0x5B,0xD8,0xB0,0x33,0x74,0x1A,0xED,0x43,0x51,
  0x04,0x33,0xC6,0x72,0xEF,0xD8,0x39,0x73,0xE4,0xC5,0xAE,0xD8,0x87,0xB4,0x01,0xD1,0x46,0x29,0x9F,0x3B,0x89,0xE8,0x84,0x3B,0xCC,0x07,0x20,0xF5,0x2E,0xD5,0x8E,0xFE,
  0x8A,0xFE,0x26,0x69,0xCC,0x80,0x31,0x3C,0x30,0xCA,0xF6,0xDE,0x0E,0x63,0xAD,0x41,0xB8,0xDA,0x2C,0x6C,0x22,0xA9,0x9F,0x01,0x8D,0x62,0x83,0x66,0x78,0x17,0xE6,0x17,
  0xB4,0x90,0x40,0x0B,0x06,0xEB,0xE8,0x88,0xC5,0xFC,0x56,0xF5,0x12,0xDF,0xA6,0xD6,0x7C,0xEE,0x14,0xD1,0x8E,0xB8,0x0E,0xCA,0x3D,0x53,0x69,0xF9,0xC3,0x69,0x4D,0x2C,
  0xEC,0x0A,0x9A,0x38,0x27,0xCE,0xF3,0x42,0x1A,0x45,0xCA,0xB9,0x2E,0x39,0x70,0x2C,0x1E,0x49,0x9D,0x16,0x8D,0xCA,0x68,0xCA,0xB5,0xB9,0xB6,0xCC,0xCF,0xCC,0x2B,0xF1,
  0x2C,0x1F,0x44,0x86,0xF6,0x66,0x8F,0x66,0x01,0xFE,0x68,0xFA,0x30,0x34,0xEF,0xFC,0x26,0x67,0x8B,0x7D,0xAD,0xA7,0xD3,0x4E,0x8D,0x92,0xB4,0x70,0xC3,0x45,0xBF,0x00,
  0x8B,0x13,0x65,0x4B,0x9F,0x59,0x27,0x77,0xEE,0x36,0xE7,0x14,0xE5,0x34,0x92,0x56,0x51,0x44,0x83,0xED,0x3D,0x82,0xB1,0xBF,0x01,0xAB,0x60,0x3F,0x0C,0x69,0x84,0x39,
  0x99,0xA7,0xE1,0x86,0x1B,0xC1,0xF0,0x2F,0xC5,0xAC,0x98,0x46,0xD0,0x2A,0xEE,0x5C,0x1B,0x33,0x05,0x34,0xBB,0xBC,0xD0,0xD7,0x88,0x27,0x99,0xE8,0x53,0x69,0x82,0x62,
  0xB4,0xE1,0x80,0x78,0xBA,0x7E,0x6F,0xFD,0x1B,0x54,0xF7,0x46,0x37,0x33,0x5A,0x7D,0x55,0x27,0x46,0x2C,0xB7,0xDF,0xF8,0x4F,0xAC,0x07,0x17,0x3C,0x7C,0xCD,0xB3,0xDC,
  0xB8,0xF4,0x40,0xAF,0xC6,0xB4,0xE8,0xCA,0x94,0xF6,0xCF,0x6F,0x8D,0x4E,0xDE,0x99,0x82,0x8D,0xE1,0xF1,0xD1,0xAE,0xDC,0x8F,0xD2,0x34,0x34,0x42,0x65,0x37,0xA7,0xA1,
  0xA0,0x85,0xBE,0x40,0x5F,0x51,0x7E,0xF0,0xCC,0x30,0x11,0x16,0xCB,0x2B,0x85,0x59,0x73,0x4C,0x73,0x6D,0xAE,0x0B,0xCD,0x5E,0x0C,0xB8,0x1F,0xC9,0x8A,0xD4,0x76,0x5F,
  0x69,0xAB,0x43,0x00,0x9E,0x58,0xB8,0xF9,0x5C,0x1B,0x3E,0xED,0xF6,0x84,0xE8,0x5E,0x67,0x44,0xDB,0x7B,0xA3,0xF8,0x6C,0x71,0x75,0x81,0x12,0x6D,0x86,0xBB,0xA1,0x6C,
  0x1C,0x91,0x7E,0x3C,0xD4,0x15,0x75,0x70,0x3C,0xE8,0x17,0x41,0x85,0x48,0x45,0x71,0xBE,0xB0,0x76,0x55,0xA7,0xD7,0x1C,0x2A,0x29,0x5C,0x53,0xD0,0x8C,0xEF,0x82,0xB9,
  0x2D,0x24,0x5F,0x68,0xAB,0x97,0x0B,0x74,0x93,0x78,0x91,0x91,0x02,0xEE,0x93,0x2F,0xF7,0xA1,0x93,0x6B,0x40,0x13,0x45,0x49,0x9A,0x72,0x09,0xE2,0xFD,0xCE,0x36,0x1C,
  0xB9,0x10,0x1C,0x10,0x7C,0x2A,0x2D,0x90,0xAF,0x4A,0x25,0x16,0x4F,0x40,0x72,0x66,0x32,0x27,0xA2,0xAC,0x4B,0xA3,0x3D,0x84,0xFF,0x97,0xF1,0x32,0x1E,0x4B,0xB6,0x4D,
  0xA7,0x1D,0x96,0x31,0x4F,0x52,0x91,0xA3,0xF0,0x8A,0x3C,0xA4,0x09,0x9E,0xD4,0xAC,0xAD,0xE5,0x09,0xFD,0x94,0x13,0x4F,0x9E,0x50,0x3B,0xC0,0xD4,0x82,0x09,0x62,0xC8,
  0x93,0x32,0xFE,0x69,0xBC,0xC2,0x1E,0x86,0x3C,0x29,0x25,0x44,0xF0,0xD2,0x26,0x31,0x32,0xE7,0x98,0xF7,0x43,0x5E,0x61,0xD5,0x74,0x5D,0x6D,0xE4,0x06,0xE3,0xB4,0x0F,
  0x78,0x83,0xEA,0x19,0x0F,0xF0,0xE4,0xD6,0x48,0x4E,0xB2,0xD6,0xD1,0x78,0xC0,0x96,0x38,0x5F,0xA2,0x6D,0x1D,0xAD,0xE1,0xA0,0x3F,0x94,0x55,0x8F,0x31,0x0D,0xF1,0x20,
  0xE2,0x5D,0x19,0xDE,0xA3,0x49,0xDE,0xA9,0x80,0x37,0x92,0x75,0x3C,0xA7,0x79,0xFC,0xE6,0x22,0x0D,0xC7,0x79,0xB2,0x46,0x78,0x9A,0xB7,0xF0,0x2C,0xB4,0x74,0x1B,0xF4,
  0x4F,0x36,0x20,0x28,0xC5,0x7B,0x7F,0x66,0x1B,0x74,0x6A,0xAB,0xDF,0xED,0x4B,0x07,0x0D,0x08,0x1E,0x57,0xA9,0x4E,0xC7,0x27,0xA8,0x51,0xCD,0x83,0xFD,0x5A,0x99,0x83,
  0x9E,0x4E,0x37,0x1E,0x51,0x45,0xEF,0x8F,0x49,0xEB,0x22,0xA6,0x85,0x5E,0x61,0x91,0x27,0xE7,0xDC,0xB3,0xB2,0x16,0x77,0x21,0x8D,0x64,0x80,0x13,0x5A,0x2F,0xA4,0x4D,
  0x48,0xB4,0xF1,0xFA,0xB3,0xE9,0x60,0x1E,0x34,0x50,0x37,0xAE,0xF7,0xDB,0xED,0x8B,0x3C,0x51,0xD0,0xC6,0x04,0xB3,0x71,0x62,0xB2,0x58,0xE5,0x60,0xBF,0xC4,0x4C,0xAA,
  0x28,0x26,0x97,0x9E,0xFB,0x8C,0x3E,0x85,0x2D,0xCB,0x09,0x31,0x5F,0x95,0xC6,0x9E,0x33,0xDA,0x94,0x12,0x46,0x56,0xB8,0x0B,0xB3,0x27,0x38,0x02,0xFB,0x67,0xB7,0x7B,
  0x79,0x3F,0x76,0x1E,0xBD,0xA8,0xC3,0xCA,0x0F,0x0F,0xE8,0x3A,0xAA,0x08,0x1C,0xE5,0x4F,0x30,0x99,0x10,0xFB,0x5B,0x42,0xF3,0xE0,0x67,0xE5,0xB0,0x52,0x5A,0x3B,0x8B,
  0x6B,0xE7,0x79,0x73,0x58,0x75,0x98,0xE2,0xE7,0x3D,0x8E,0x67,0xEC,0x02,0xAF,0xEC,0x61,0xC8,0xBB,0x20,0xF7,0xAE,0x94,0x56,0xD1,0xC3,0x32,0x5A,0x55,0xEF,0x90,0xC8,
  0x74,0xE0,0x70,0xDA,0xF0,0x9B,0x33,0x2C,0xEA,0x82,0xE7,0x0E,0xAE,0xEA,0x67,0x48,0x1C,0x11,0xFA,0x27,0x49,0x2B,0xE8,0x67,0x19,0xAD,0xFA,0xED,0x31,0x1E,0x9A,0x36,
  0x49,0xCD,0x2C,0xD6,0xFD,0xAF,0xAC,0x5D,0x69,0x40,0x1B,0x5F,0x8B,0x93,0x31,0xA5,0x77,0x18,0x4B,0xB9,0x77,0x1E,0x31,0x42,0xA1,0x2C,0x9C,0xB2,0xF8,0x0F,0xA3,0x2D,
  0x77,0x83,0x25,0x91,0x76,0xEF,0x19,0xBB,0xF6,0xD8,0x63,0x59,0xE1,0xE4,0xC9,0x21,0x6D,0x45,0xA0,0x59,0x8F,0x6C,0xF0,0x8E,0xF0,0x52,0x1C,0xE6,0x3E,0x8D,0x25,0xCD,
  0xAD,0x67,0x38,0xA0,0x01,0x5C,0xBB,0x7B,0xB4,0xAD,0xF2,0xE4,0x50,0xAA,0xDD,0x12,0x68,0x2C,0x38,0x26,0x25,0xCC,0x3C,0x76,0xAA,0xC0,0x55,0xC2,0xBB,0xFD,0xCE,0xB2,
  0xCB,0xC2,0x55,0x39,0x6D,0x48,0x70,0x4F,0x71,0x1A,0xBB,0x2C,0xC7,0x92,0x48,0x63,0x3C,0x73,0x3C,0x47,0xA2,0xD9,0x5A,0xE8,0x0C,0xE3,0xB4,0x01,0x65,0x96,0x44,0x34,
  0x26,0xAE,0xE1,0x8D,0x6D,0x70,0x58,0x11,0x88,0xD3,0x11,0x13,0x24,0x97,0xBD,0xBF,0x70,0x24,0xFB,0xF2,0x34,0xE6,0xAC,0x67,0xA7,0x49,0x30,0x74,0x18,0x59,0xC2,0x6F,
  0xC5,0xCA,0xCC,0x4C,0x41,0xD3,0xE5,0xD7,0x77,0xE1,0xFE,0x10,0xDA,0x0B,0x3B,0x9C,0x2A,0x3B,0xD3,0x79,0x3F,0xE5,0x69,0xF3,0xD8,0x7C,0x39,0xC2,0x8B,0xE9,0xAB,0x27,
  0xBB,0x58,0xD4,0x84,0x6B,0xFE,0x47,0x42,0x7F,0xA9,0xB4,0x58,0xD4,0x94,0xD1,0x6A,0x24,0x68,0x92,0xC8,0xE6,0xE9,0x7B,0x78,0xAB,0x5B,0xCC,0xC2,0x54,0xBB,0x49,0x84,
  0x32,0x66,0xD8,0xAC,0x7F,0x25,0xB4,0xB2,0x4D,0xA2,0x8C,0x56,0x29,0x41,0xA1,0xF5,0x50,0xA8,0xF0,0x19,0xFA,0xB8,0x09,0x98,0x2A,0x5A,0xA1,0x58,0xA4,0x79,0x17,0xAF,
  0x3C,0x34,0x65,0x22,0xDB,0x72,0x84,0x14,0xE7,0xD6,0xE0,0xBB,0xF1,0xBB,0x94,0x14,0x07,0x5B,0x14,0x8F,0x6D,0x8D,0xCC,0xD2,0x09,0xDF,0xE8,0x15,0xE5,0x28,0x4A,0xDC,
  0x23,0x35,0x6D,0x33,0x70,0xC3,0xB8,0x64,0x49,0x49,0x1E,0xAE,0x4F,0xC2,0xFB,0x4C,0xE6,0xF1,0x08,0xDF,0xAC,0x30,0x71,0x2A,0x05,0x4F,0x4C,0xEB,0x34,0xA4,0xA1,0x82,
  0x48,0xD0,0x68,0x04,0xED,0x67,0x82,0x5C,0x95,0xA1,0x95,0x4C,0xD6,0x32,0x5A,0xE5,0x5C,0x15,0x8B,0x9B,0x9F,0x3A,0xE3,0xF4,0x90,0x57,0xFC,0xC5,0x8E,0x98,0x8A,0x6C,
  0xAB,0xE9,0xDD,0x79,0x62,0x59,0xF0,0x59,0x79,0xBD,0x0F,0x60,0xCA,0xAC,0x36,0x6E,0xA9,0x52,0x91,0x99,0x27,0xAF,0x5C,0x19,0xE2,0x09,0x40,0xB5,0x61,0x5B,0x0A,0x26,
  0x1A,0x58,0xEE,0xD1,0x6D,0x8C,0x8F,0x04,0x02,0xCF,0x0F,0x8C,0xD5,0xA6,0xF8,0x6A,0x4E,0x38,0xBE,0x84,0x60,0x8D,0x88,0xC6,0x76,0x13,0xAE,0x0B,0xC4,0x3B,0x34,0x53,
  0xE3,0x2A,0x75,0x29,0x58,0x87,0x3F,0x51,0xD6,0x21,0x73,0x72,0xDD,0x19,0x96,0xC3,0x33,0x56,0xCE,0x6D,0xC3,0x09,0xB8,0xDE,0x21,0xA7,0xDF,0x4C,0xEE,0xFA,0x1F,0x08,
  0xBD,0x43,0xDA,0xCC,0x5D,0x16,0x84,0x08,0xD5,0xFD,0x09,0x69,0x94,0xB1,0xF4,0x30,0x09,0x39,0x26,0x63,0xE1,0x9E,0x68,0x11,0xFD,0x51,0xAA,0x42,0x15,0xD0,0x7E,0xA5,
  0xD2,0x98,0x64,0x09,0x0F,0xF7,0xEA,0x64,0x4B,0x86,0x36,0x91,0x0F,0x3B,0x41,0xDA,0x23,0x26,0xA1,0x3D,0x77,0x5F,0x6C,0xF3,0xFD,0x85,0xE1,0xA1,0x89,0xE6,0x06,0x41,
  0x1C,0xEF,0x55,0x27,0x63,0x2E,0x68,0x23,0x59,0x4B,0xAB,0x96,0x31,0x39,0x5A,0xF5,0x7E,0x5F,0xB4,0x0E,0xBD,0xFD,0x96,0x6C,0xFB,0x26,0x9E,0x01,0x56,0xC6,0x09,0xA5,
  0xC7,0x45,0xB4,0x1A,0xDB,0xB7,0x9A,0x56,0xA3,0xE1,0xE0,0xB1,0x70,0xFB,0xDA,0xC5,0xB0,0xA4,0x84,0xCC,0x0B,0xC5,0x80,0xCC,0x1E,0x75,0x41,0xD0,0x8F,0xF1,0x82,0x15,
  0x96,0x31,0xB8,0x45,0x55,0x3C,0xA1,0x9A,0x7F,0x5F,0x3F,0x69,0xC3,0xB5,0x41,0xB0,0x48,0xE3,0x83,0x8B,0x30,0xA5,0x16,0x3F,0x08,0x97,0x50,0x92,0x43,0x1A,0x61,0x6D,
  0x24,0x68,0xD7,0xA6,0xEF,0xBF,0x88,0x8D,0x43,0x06,0x17,0xD2,0x08,0xBE,0xA1,0x24,0x2D,0xDA,0x0D,0xF0,0xD5,0xD5,0xAF,0xFE,0x90,0x46,0xF0,0x7B,0x85,0x39,0xC2,0x78,
  0x9F,0xDE,0xF3,0x78,0x05,0x14,0xDF,0xE1,0xED,0x83,0xF2,0x0E,0x86,0x96,0x86,0xFC,0xFE,0x90,0xA5,0xB1,0x80,0x05,0x39,0x58,0x44,0x23,0x58,0x15,0xDC,0xC7,0xCD,0xBA,
  0x74,0x9D,0xD0,0xB5,0xA5,0x2D,0x7B,0x18,0xC9,0x8F,0x04,0x9A,0xF9,0x10,0xBC,0x88,0xCD,0x80,0xAB,0x31,0xCC,0xBB,0x27,0x43,0x0D,0xAD,0x5F,0xC2,0x7B,0xBB,0xBA,0x5D,
  0xCC,0x94,0xB4,0xC1,0xAD,0xDC,0xBB,0x9E,0x67,0x99,0xEB,0xF7,0xCC,0x89,0x58,0x2E,0xD2,0x84,0x3C,0xB9,0x26,0xCC,0x49,0x02,0x2D,0x2B,0xD2,0xCA,0x68,0x95,0x3A,0x21,
  0xE3,0x9D,0x21,0x0F,0xB5,0x4F,0xD0,0x03,0xB7,0x60,0x06,0x83,0xF9,0x22,0x21,0xA6,0x43,0x1E,0xC1,0xDA,0xAE,0xA5,0x95,0x8B,0xE9,0x32,0x1A,0xA1,0x77,0x04,0xDF,0x64,
  0xCC,0x23,0xEC,0xB5,0xD5,0xB4,0xCA,0x1D,0xA8,0x8C,0x46,0xE9,0x1D,0x96,0x5C,0x91,0x7C,0x75,0x11,0x8F,0x20,0x9B,0xEB,0x68,0xF5,0xBE,0xD7,0x1C,0xAD,0xBE,0x77,0xFC,
  0xFE,0xD2,0xB9,0x67,0xBC,0xA4,0xBD,0xA2,0xA9,0xA5,0x50,0xBC,0xCF,0x01,0x8F,0xBA,0xCA,0x17,0x16,0xBC,0xB1,0xF7,0x77,0xAE,0xE5,0xBB,0x8E,0xF4,0x44,0x89,0x68,0x04,
  0xCB,0xAF,0x92,0x56,0xAD,0xAA,0x94,0xD1,0x2A,0xC7,0x92,0x09,0xE5,0x89,0x77,0xCC,0x35,0xDD,0x30,0x29,0xC1,0xC6,0xB5,0xCD,0xDA,0xE1,0x0C,0x35,0x5C,0x82,0x0C,0xE3,
  0x5B,0x00,0x0F,0x80,0x25,0xB1,0x62,0x1A,0x41,0xA6,0x70,0x45,0x81,0xA9,0x08,0x62,0xEF,0xC6,0xC6,0x57,0x75,0x76,0x42,0x82,0xA6,0x13,0xE6,0x49,0x86,0x56,0x6D,0x45,
  0x16,0xD3,0x08,0x69,0x09,0x12,0x34,0xA1,0x7D,0x51,0xCF,0xCA,0xBA,0x8D,0x68,0x60,0x32,0xB3,0x73,0x33,0xE9,0x01,0x0D,0xFB,0x46,0x90,0x96,0x49,0x5A,0x5A,0xFD,0xE2,
  0x6C,0x09,0x1A,0x61,0xC5,0x95,0xD3,0x6A,0xFB,0x17,0xD2,0x28,0x2B,0xA0,0x94,0x56,0xAB,0xAB,0x84,0x34,0x82,0x64,0xBE,0x76,0x1D,0x77,0x65,0x27,0x7D,0xF2,0x09,0x67,
  0x80,0x84,0x45,0xB0,0xDC,0x2D,0x09,0x7E,0x1D,0x41,0xE3,0x47,0xA7,0x47,0xA4,0x55,0x10,0xFA,0x75,0x64,0x69,0x58,0xA8,0xA9,0xC5,0xCF,0x88,0x99,0xD2,0x2A,0x72,0x80,
  0x30,0x17,0xC7,0x7B,0xF8,0xAD,0x44,0x62,0x95,0xF2,0x13,0xB8,0x09,0x29,0x11,0x88,0x2C,0xAD,0xEC,0x04,0xAE,0x80,0x56,0x2D,0x99,0x19,0x2F,0x8D,0x62,0xBE,0x96,0x13,
  0x0C,0xC9,0x4B,0x69,0xD3,0xD9,0x2E,0x86,0x3C,0x8A,0xF4,0xA2,0xD0,0xD2,0x5D,0x2C,0xA3,0x91,0xBD,0x01,0x78,0xEA,0x10,0xBA,0x3B,0xC3,0x63,0x87,0x85,0x69,0x0A,0x5D,
  0x7E,0xE1,0xEE,0xF1,0xB0,0xAC,0xF2,0xCC,0x71,0x9A,0xCC,0xDD,0x54,0xEB,0x27,0x13,0xC7,0x6F,0xB1,0x40,0x13,0x49,0x3B,0x2A,0x35,0x88,0x14,0x6F,0x48,0x98,0x3F,0x77,
  0x58,0xAA,0x74,0x1D,0x3B,0x93,0x38,0x0C,0x13,0x8C,0x6F,0xB0,0xE6,0x5F,0xAD,0x8F,0x15,0xF6,0x3E,0xC2,0xFB,0x9C,0x25,0x51,0x7C,0xE9,0x7F,0xD8,0xF9,0x2C,0x59,0x67,
  0x74,0x74,0x56,0x35,0x96,0xCB,0x5D,0xFF,0x81,0x40,0x73,0x1D,0xE5,0xDE,0x34,0xFC,0xEC,0xED,0x2F,0x89,0x3F,0x82,0xB6,0xD1,0x13,0xB9,0xD2,0xEA,0xA2,0x52,0xB0,0xBE,
  0xEC,0xDE,0xC7,0x44,0x3F,0x3B,0xC2,0xBE,0x97,0x18,0xC9,0x0B,0x42,0xDC,0x44,0xDA,0x39,0x7C,0x82,0x97,0x24,0x5F,0x12,0x72,0x8D,0x8F,0x6D,0xE5,0xAC,0xD4,0x6F,0xDE,
  0x8E,0xC6,0xEC,0xBF,0x6A,0xDA,0xCF,0x0D,0x68,0x78,0x6F,0x07,0x16,0xA3,0x19,0x6E,0xEF,0x51,0x58,0x4C,0xE9,0x61,0x55,0xB8,0xEA,0x09,0x7B,0x9F,0x08,0x4E,0x64,0xB2,
  0x44,0x6C,0x0E,0xB0,0xB6,0x79,0x6A,0x05,0x49,0xDF,0xED,0x2F,0x64,0x5A,0x13,0xCF,0x74,0x48,0x23,0x68,0x11,0xFC,0xB4,0x8B,0xA7,0xD9,0x52,0x7E,0x60,0x41,0x36,0x7F,
  0x94,0xA4,0xB6,0x86,0x9A,0x4E,0x4C,0x05,0xCA,0x8F,0xB9,0x5E,0xE5,0x55,0xB9,0x27,0xF4,0x8D,0x09,0x44,0xE6,0xB9,0xC4,0x1D,0x61,0xE1,0xBA,0xB5,0xBE,0xF6,0x0C,0x6D,
  0x48,0xD0,0xDA,0x45,0xF8,0x55,0x41,0xC0,0x8B,0xB8,0x35,0x54,0x1E,0xC2,0x10,0xD2,0x08,0xBA,0x66,0x48,0x4B,0xFB,0x55,0x48,0x34,0x82,0x3E,0xC6,0xCE,0x9D,0xC3,0xBE,
  0x51,0x2C,0x84,0x58,0x43,0xA2,0xCC,0xC9,0x24,0x2D,0x32,0x4C,0xF8,0x42,0x97,0xDC,0xDF,0x28,0xAB,0x3B,0x75,0x64,0x28,0xE7,0x2C,0x4D,0xD3,0x3A,0x94,0x91,0xCC,0xD1,
  0xC0,0x5C,0x66,0x9A,0x6D,0xED,0xB0,0x86,0x34,0xCA,0x48,0xE6,0x68,0xD2,0x21,0x43,0x21,0x8D,0x32,0x27,0x93,0xB4,0xA3,0xF4,0xAC,0xBC,0xB6,0x56,0x9E,0xBB,0xDB,0xB8,
  0x4E,0xE5,0xE9,0x64,0x87,0xB2,0xDE,0x42,0xDA,0x3D,0x26,0x5C,0x24,0x49,0xCA,0x90,0x46,0x9A,0x25,0x62,0x63,0xC9,0x18,0x3F,0x38,0x55,0x25,0x6D,0x04,0xCA,0x2C,0xB9,
  0x17,0x57,0x43,0x45,0x0A,0x28,0xEE,0x8B,0x16,0x82,0xA5,0xFA,0xCD,0x09,0xDA,0x9C,0xA2,0x29,0xDC,0x17,0x49,0x2D,0xDC,0x41,0x65,0x4F,0x0B,0xE7,0x04,0x6B,0x0B,0x69,
  0x79,0xA9,0x55,0x6B,0x21,0x27,0x69,0x84,0xD3,0x9E,0x3C,0x8D,0xEA,0x6F,0x98,0x53,0x66,0xC9,0xBD,0x48,0x1F,0x74,0x6D,0xEC,0xA5,0x63,0x48,0xD2,0x34,0x42,0x6C,0x07,
  0xD0,0xA2,0xE8,0x26,0x66,0x69,0x60,0x52,0x24,0xB9,0xDE,0x86,0x34,0xC2,0x29,0x24,0xD0,0xD8,0x01,0x60,0xCA,0x8F,0x42,0x92,0x93,0x73,0x8A,0x2C,0xB9,0xCF,0x1C,0x37,
  0x7E,0x8F,0xA9,0x92,0xD0,0x09,0x20,0x7B,0xA6,0x3C,0x9F,0xBE,0x2D,0xAD,0xFA,0x4C,0x39,0x47,0xAB,0xB4,0x91,0x59,0x3E,0x88,0x30,0xA8,0x2B,0x5E,0xD8,0x47,0xFC,0x15,
  0xCA,0xC4,0x1F,0xCE,0x09,0x16,0x1C,0xD0,0x52,0x09,0x6E,0x04,0x91,0xDF,0x51,0x91,0x92,0x5D,0xF3,0x53,0x1A,0x4D,0xA8,0x79,0xB5,0xC1,0x94,0x25,0x34,0xCA,0x0E,0x77,
  0x2F,0x64,0x30,0x13,0x22,0xA4,0x95,0x1E,0xD2,0x68,0x72,0x79,0xB1,0xF7,0x9F,0x40,0x30,0xCF,0xB0,0x68,0x90,0x64,0x58,0x65,0x8A,0xB6,0x90,0xA7,0x2D,0x8C,0x8C,0x90,
  0x3C,0xAB,0xB0,0xA2,0x0A,0x69,0x17,0x04,0xD9,0xB5,0xF0,0xAC,0xA5,0x61,0x27,0xE2,0x6F,0xC8,0xB4,0x31,0x61,0xC5,0x7D,0x04,0xE3,0xC9,0x32,0x1C,0x31,0x49,0x48,0x91,
  0xAA,0x21,0x8D,0x20,0x4D,0x90,0x06,0xFD,0x82,0xAD,0x3B,0x0A,0x68,0xF8,0x5E,0x12,0x2D,0xEC,0x7C,0x83,0xB0,0xE7,0x7C,0xB4,0x9C,0x15,0xD6,0x5D,0x9E,0x7A,0xC6,0x72,
  0x69,0xBE,0xA7,0x38,0x19,0x42,0xAF,0x42,0x4F,0xDE,0xAB,0x10,0x07,0x14,0x24,0xA3,0xB3,0xA4,0x9C,0x98,0x62,0x24,0x6F,0x08,0xFE,0x19,0x96,0xFC,0x44,0x18,0x1F,0x29,
  0x5F,0x0D,0x66,0x37,0x7C,0xE7,0x63,0xBD,0xD2,0x32,0xAB,0x35,0xF4,0x06,0x11,0x56,0xF7,0xBD,0xE5,0x25,0xBC,0x08,0xA1,0xB1,0x2F,0xB5,0xF9,0x88,0x91,0xD4,0x4D,0x79,
  0x5A,0xD1,0x75,0xF9,0x1B,0xD7,0x69,0x47,0x35,0xBD,0xD1,0xE1,0xE5,0x7F,0x9B,0xAB,0xF6,0x22,0x47,0xEE,0x6F,0x7B,0x6B,0x4D,0x4B,0x5F,0xAE,0xF0,0x54,0xB9,0xB2,0x37,
  0xC3,0x78,0x35,0xC4,0x0C,0x2E,0x99,0xFB,0x82,0x29,0x9C,0xDF,0xA7,0xAF,0x6B,0xB4,0xF2,0x38,0xC9,0x0B,0x53,0x21,0xCE,0xD9,0x2F,0x2D,0xBF,0x3A,0x5F,0x64,0x59,0xEF,
  0x30,0xA9,0xB8,0xEC,0x9D,0xCC,0x02,0x1C,0xEF,0x1B,0x73,0x08,0x84,0x51,0xFF,0x55,0xC9,0xB0,0x39,0x4E,0xD2,0xE1,0x2E,0x70,0xA7,0x84,0x0C,0xD1,0xD9,0xDE,0x75,0xF5,
  0x81,0x74,0x9A,0xE3,0x18,0x27,0x3A,0xC5,0xCE,0x42,0x65,0xC2,0x25,0xD3,0x38,0xDA,0xBB,0x3B,0x7D,0x76,0xE9,0x69,0x03,0x04,0xAE,0xDF,0x1D,0x4A,0xA7,0x25,0x12,0xB8,
  0x73,0x77,0x69,0x53,0x52,0x06,0xA4,0x7A,0xA7,0xA9,0xD2,0x15,0x8D,0x04,0xEE,0x1A,0xCB,0x76,0x19,0x0E,0xAB,0x30,0x27,0x92,0x3F,0xD9,0x96,0x5C,0xEA,0x99,0x96,0xDE,
  0xC9,0x5D,0xE2,0x2F,0xC5,0xE9,0x5A,0x05,0x2E,0x3A,0x63,0xF6,0x31,0x9A,0xAB,0x24,0x90,0x99,0xE3,0x24,0xDF,0x9D,0x1C,0xAE,0xCA,0xBD,0x1E,0xE2,0xA4,0x34,0x8A,0x10,
  0x67,0x62,0x51,0x64,0x56,0x66,0x88,0x11,0xD1,0x18,0x33,0x30,0xD7,0x05,0x3A,0x88,0xAB,0xEF,0x9D,0xB2,0xEC,0x67,0xB2,0xCB,0x9C,0xE3,0x0A,0xCF,0x66,0x6E,0x8C,0x7D,
  0xE0,0xDA,0x44,0x09,0x2A,0x1E,0x01,0xD3,0xAC,0xCA,0x26,0x47,0x12,0xD3,0x27,0xC4,0x1D,0xA5,0xA5,0xA7,0x38,0x14,0xE2,0xFA,0xE9,0x02,0xAB,0xB2,0xE3,0xE9,0xE6,0x04,
  0x84,0x4F,0x9C,0x57,0x84,0xE3,0x48,0x6B,0x11,0x4F,0x67,0x3C,0x37,0x70,0x57,0xAE,0x5D,0x3F,0xA2,0x45,0x43,0xDC,0x1D,0xCA,0xA6,0xF2,0x08,0x81,0x05,0x43,0xCC,0x3C,
  0xD5,0xCD,0x24,0x42,0x6B,0x34,0xD4,0x89,0xD9,0x48,0xB9,0x5F,0x3C,0x4E,0x97,0x14,0xDD,0xEF,0x03,0x6D,0xE4,0xFD,0x0B,0x8F,0xAA,0xE6,0x87,0x6F,0x27,0x96,0x0F,0x26,
  0x5C,0x22,0x8B,0x3E,0xA7,0x11,0xF3,0x94,0xCD,0xDC,0xB5,0x25,0x76,0x44,0x34,0xA1,0x48,0x6E,0xA6,0xEE,0x20,0x57,0x28,0xA8,0x6E,0x02,0x25,0x70,0x71,0xD7,0x78,0x52,
  0xBD,0x5A,0xBD,0x98,0xE1,0x68,0xC2,0x7C,0xBE,0x73,0x9D,0x47,0x73,0xE2,0x16,0x25,0x32,0xAF,0xEB,0x5D,0xAF,0x3B,0x94,0xAE,0xA6,0x33,0x4C,0xD3,0x44,0x6A,0x34,0x3C,
  0x6D,0x90,0x75,0xC8,0x33,0x9A,0x64,0x52,0x96,0x61,0xE8,0xB2,0x5B,0x2B,0x17,0x2E,0xCE,0x08,0x6A,0xEF,0xB8,0xAA,0x4A,0x99,0x97,0x85,0x2B,0xE3,0xDE,0x75,0x9F,0x2C,
  0xD3,0x0C,0x53,0x16,0x3A,0x6B,0x17,0xD4,0x2C,0xB9,0x44,0x2D,0x6C,0x71,0xCA,0xA6,0x2F,0x10,0x2F,0x33,0x85,0x13,0xC7,0x48,0x11,0xF5,0x3D,0x17,0x48,0x25,0x53,0x89,
  0xE3,0xA8,0xC2,0xE7,0x57,0x77,0x6D,0x88,0x6D,0x44,0x5C,0x11,0x35,0x3C,0xD9,0x8C,0x8C,0x5D,0x75,0x48,0x14,0x3E,0xFF,0xB3,0x53,0x61,0x7D,0xF7,0x87,0xBF,0x4F,0x6E,
  0x4F,0x7E,0xC5,0xCC,0x0D,0x4C,0x27,0x68,0x2A,0x70,0xB3,0x89,0x29,0x6B,0x7B,0xFA,0xBF,0x55,0x65,0x96,0x8A,0x69,0x95,0x27,0x23,0xED,0x2E,0xF3,0x96,0x6B,0x68,0xEF,
  0xE6,0xEF,0x78,0xA9,0x3E,0xE6,0x8F,0x7B,0x2F,0x92,0xE0,0xC9,0x89,0x08,0xA4,0x69,0x7A,0x23,0x1A,0x9A,0xB2,0xEF,0x2B,0xCF,0xC4,0x0B,0x69,0x99,0x2A,0xC6,0x0D,0x44,
  0xC4,0xBB,0x05,0x18,0x56,0xEF,0xC0,0x04,0xB1,0x30,0xD5,0x2E,0x6D,0xFF,0x86,0x27,0x38,0x21,0x15,0x6A,0x07,0x9E,0xC6,0x92,0x99,0x9A,0x20,0x04,0xAE,0x4C,0xEC,0xA6,
  0x1F,0xDE,0x44,0xE2,0x46,0x50,0x65,0x8C,0x1A,0xF6,0x78,0xFC,0x33,0x65,0x7C,0xF5,0xF6,0x9D,0x65,0xAE,0xF0,0x8A,0xBC,0x15,0x84,0x37,0x39,0xE7,0x1B,0xCB,0x0B,0xA2,
  0x6B,0x49,0x0B,0xAB,0x2C,0x4A,0x13,0x69,0x27,0x13,0x0A,0x6D,0x6C,0x79,0xCA,0xB9,0xB1,0x7F,0x34,0xC5,0xB9,0x1A,0x8C,0xA8,0xEC,0x86,0xCD,0xE7,0xCE,0x88,0x48,0x43,
  0x0F,0xB1,0xC9,0x27,0x10,0x12,0xDF,0x8D,0x2F,0x67,0xEF,0x40,0xE2,0xAE,0x4B,0xC3,0x7D,0x92,0xB4,0x61,0xAF,0x39,0x8D,0x76,0xB2,0xC0,0x66,0x6A,0x9F,0x44,0xC3,0x3B,
  0x8D,0x1E,0xA8,0xAD,0x81,0xF5,0x40,0x8D,0x41,0x40,0x5A,0x87,0x36,0x92,0xDE,0x0A,0xA6,0x3F,0x70,0xBC,0x27,0x43,0x19,0xAB,0xA4,0xA8,0x00,0xA4,0x0D,0xC6,0xCD,0x69,
  0x1A,0x9D,0x46,0x9B,0x93,0x7E,0xE0,0x11,0xDF,0x57,0x8A,0xD6,0x3F,0x23,0xD1,0xC0,0xFA,0xF0,0x40,0x4D,0x25,0x46,0x17,0x45,0x34,0x6D,0x40,0xA2,0x89,0x0C,0x89,0x3F,
  0x1A,0x6C,0xA5,0x61,0x9D,0x1F,0xE3,0xD1,0x36,0xDF,0xBF,0x9B,0x5F,0x5F,0xBC,0x2B,0xBC,0x9E,0x9D,0xA6,0xFD,0x4C,0x5A,0x01,0xA8,0xC9,0x18,0x8F,0x89,0x78,0x8E,0x1B,
  0x3C,0xFA,0xAA,0xB9,0xF9,0x93,0xA4,0x91,0xF6,0x21,0x41,0x3B,0xCA,0xA0,0x22,0xF8,0xC4,0xB4,0x4B,0xFD,0x9C,0x8C,0x46,0x91,0xCB,0x2D,0x5E,0xA4,0x10,0x63,0x7E,0xA8,
  0xE9,0x8A,0x38,0x6D,0xA9,0x91,0x68,0x6C,0x9B,0x9B,0x82,0x66,0x6C,0x78,0x09,0x51,0x29,0xE3,0x35,0x42,0xDA,0xCE,0x0F,0xE8,0xB4,0x13,0x4B,0x64,0x41,0xFE,0x9B,0xB5,
  0x93,0x16,0xCF,0x8C,0xD6,0x59,0x36,0xA0,0xED,0x9D,0x47,0xC3,0xAB,0x8D,0x16,0x29,0x18,0x49,0x95,0x24,0x4B,0xC2,0x23,0x04,0x7B,0xE5,0x36,0x7A,0x6F,0x5D,0x92,0xB6,
  0x22,0x68,0xFB,0x60,0xEF,0x51,0x71,0x5C,0x96,0x90,0x24,0x17,0xA3,0x05,0x48,0xBA,0x24,0xC7,0x46,0x22,0xAD,0x47,0x9F,0x93,0x9C,0x46,0xC5,0x71,0x1A,0x6D,0xBD,0xD9,
  0xEE,0xDE,0x67,0x41,0x83,0x36,0x57,0x45,0xA8,0xB2,0x84,0xB4,0x9B,0x32,0x1D,0x96,0x07,0xC1,0x38,0x81,0xF0,0xD2,0x56,0x16,0x60,0x4C,0xD3,0x76,0x9A,0x49,0xA6,0x89,
  0x72,0x50,0x13,0x77,0x6D,0xC9,0x74,0x2A,0xD9,0xB7,0xEE,0x0D,0x99,0xD6,0x68,0xB9,0x89,0xF5,0x46,0x9C,0x93,0x40,0x6B,0xB4,0x00,0xC4,0x0A,0x98,0xD2,0x69,0xAC,0x0A,
  0xBB,0x8F,0xDB,0x19,0xE8,0xAA,0x6B,0xA1,0xBE,0xD6,0x9E,0xE3,0xB1,0xDD,0xF4,0x3C,0x55,0x47,0x59,0x86,0x76,0xE1,0x7A,0xD6,0xBF,0x5D,0x27,0x00,0x41,0x29,0x39,0x43,
  0x42,0xDA,0x4E,0x5D,0x93,0xFB,0x96,0xA9,0x7F,0x7D,0xFB,0xF0,0x00,0xB3,0xA5,0xFE,0x5E,0x32,0xF6,0x4D,0x9F,0xBD,0x96,0x26,0x7B,0x44,0xC1,0x68,0xF4,0x39,0x89,0x46,
  0xB2,0x78,0x5B,0x04,0xB5,0x8B,0x5B,0x1D,0x27,0x64,0x5A,0x6C,0xD4,0xCC,0x8D,0x07,0x33,0x78,0x91,0x7B,0x7B,0xDC,0x0E,0x38,0xA7,0xD3,0x58,0xE3,0xEB,0x68,0xDD,0xC9,
  0x9D,0xF7,0xF0,0xF5,0x46,0x7F,0x6F,0x2C,0x8B,0xA9,0xCF,0x3A,0x28,0xB2,0x58,0x80,0xB9,0xC8,0x14,0xA1,0x7D,0xC5,0x22,0x64,0xB4,0x7B,0x9A,0x86,0x87,0xB4,0x8F,0xA6,
  0x0F,0xA6,0x62,0x42,0x39,0x99,0x07,0x75,0x69,0x87,0x42,0xDA,0x98,0xDE,0xB7,0x1C,0x6D,0x01,0xDF,0x50,0x16,0xFB,0xA5,0x84,0x25,0x3C,0x6F,0x48,0x13,0xDA,0xD6,0x51,
  0x62,0xD2,0x9C,0x60,0x2C,0x79,0xE9,0x49,0x36,0xA3,0x2D,0x1A,0xD2,0x16,0xAE,0x6B,0xA7,0x58,0x13,0x2C,0x24,0x59,0xDE,0x39,0x4E,0xFB,0x40,0xA2,0x41,0x8B,0x66,0x64,
  0x06,0x84,0x81,0x15,0x52,0x82,0x92,0x5B,0x54,0x34,0xCD,0x3C,0x49,0xE3,0x5B,0xF8,0x91,0x24,0x94,0xF7,0x8D,0x36,0x27,0xD9,0x91,0x0D,0x1F,0xCA,0xB1,0xBF,0x72,0xC5,
  0x18,0x96,0x6B,0xFF,0x19,0x9A,0x4E,0xDB,0xDF,0x12,0xB4,0xC9,0x9E,0xA5,0x36,0x0A,0x0F,0xA8,0x9D,0x47,0x5C,0x77,0x41,0x99,0xBB,0x44,0xAC,0x37,0x92,0xDD,0x3D,0x61,
  0xD9,0x8B,0xF8,0x11,0xC3,0x2D,0xA6,0xDE,0xE1,0x45,0x1B,0x24,0x1C,0x18,0x42,0x96,0x90,0x6C,0xD3,0x29,0x4F,0x74,0xC9,0x3C,0x41,0xBC,0x87,0x91,0x31,0x75,0xE6,0x56,
  0xCD,0xC8,0xB0,0x6F,0x43,0x1A,0x8D,0x2B,0x40,0x9E,0x09,0x5F,0xEC,0x6C,0x83,0x60,0x12,0x73,0x2D,0x88,0x34,0x27,0xD3,0xEA,0x16,0x0B,0x87,0xB1,0x5D,0x43,0xCA,0x95,
  0xC8,0x69,0x17,0x0D,0x68,0xD3,0x8D,0x61,0x39,0x5B,0xC3,0xA2,0x04,0x9A,0x72,0x1A,0x49,0x57,0x0E,0x69,0x58,0x0A,0x1A,0x2F,0x75,0x5B,0x65,0x45,0xCA,0xCB,0x68,0x24,
  0x3B,0x40,0xD0,0xC4,0xDD,0xE0,0xB1,0xB7,0x75,0xF7,0xB2,0x51,0x76,0x9C,0x46,0xDA,0x4D,0xC3,0x7A,0xC2,0xE6,0xFA,0x3D,0xBB,0x91,0x4F,0xF5,0x05,0x75,0x49,0xFE,0x92,
  0xA9,0x11,0xF8,0x6C,0xFA,0xDF,0xB6,0x67,0xB8,0x9E,0xA5,0x25,0x89,0xA0,0x4D,0x68,0x2B,0x60,0x63,0x52,0x7D,0x77,0x49,0xDA,0x2E,0x53,0xAB,0xB5,0x8E,0x26,0x6A,0xB4,
  0xB2,0x04,0xEB,0x0D,0xEC,0x80,0x11,0x6D,0xBD,0xD9,0xB0,0x87,0x3E,0xBB,0xDE,0x13,0xFD,0x9A,0x14,0xA3,0x4D,0xFB,0xA9,0x17,0x57,0x47,0x73,0x3D,0xDF,0x8C,0xAB,0xD4,
  0xAD,0x2D,0x7F,0x23,0x8E,0xF2,0xAF,0xA0,0xB3,0x95,0x8B,0x81,0x8D,0x64,0xF7,0x99,0xD4,0x37,0xD6,0x32,0x98,0x1B,0x98,0xC8,0x13,0x37,0xF2,0xF7,0x58,0x6D,0x69,0xBF,
  0x65,0x7B,0xFA,0xCF,0xA0,0x3A,0x33,0xAF,0x7D,0xA9,0x57,0x6D,0xD7,0xFD,0x17,0x85,0xC6,0xB2,0x85,0x8A,0x0B,0xA5,0x28,0x95,0xB9,0x6F,0x86,0x67,0x3A,0x40,0x3D,0xAF,
  0xD4,0x3F,0x2F,0x68,0xCB,0x01,0xC5,0xC6,0x39,0x79,0xE2,0x77,0xBF,0xF6,0xFE,0x2A,0x0C,0x5A,0x97,0x75,0xE5,0x31,0xDA,0x6F,0x24,0x59,0x72,0xF2,0xC4,0xF5,0xD5,0xE4,
  0xFB,0xBB,0xE2,0x75,0x41,0xEA,0xD6,0x1D,0x1F,0xC9,0x2F,0x54,0x9A,0xF1,0x22,0x02,0x3F,0x8E,0x92,0x49,0xDE,0x84,0x77,0xAF,0x46,0xE7,0x9A,0x90,0xA4,0xB2,0xC8,0xF9,
  0x7F,0x51,0x77,0x05,0xB7,0xE0,0x0F,0x97,0x5C,0x24,0xBD,0xE4,0xF4,0xCB,0xCE,0x06,0xCB,0x14,0x73,0xCA,0x51,0x8F,0x1F,0xD8,0x48,0xF6,0x48,0x3A,0xD7,0xE9,0x97,0xC0,
  0x33,0x31,0x23,0xBE,0x69,0x6C,0x43,0xAD,0x52,0x92,0xCB,0x2D,0x2A,0x92,0x0F,0xEF,0xCC,0x00,0x73,0xDB,0x7F,0x51,0x4E,0x3D,0x43,0xB9,0x03,0x6D,0x01,0x83,0xFE,0x67,
  0xEE,0xCE,0x94,0x10,0xCD,0x7C,0x96,0x7C,0x26,0xD1,0x44,0xD2,0x0B,0xCB,0xA3,0xA8,0x24,0x71,0xDF,0x74,0xD2,0x1E,0x20,0x68,0x89,0x83,0x37,0x9E,0x23,0x37,0x1C,0xD5,
  0x5A,0x1B,0xE7,0xB4,0x01,0x4D,0xC4,0x76,0x78,0xB6,0xF9,0xDB,0xDE,0x12,0x11,0xDE,0xEF,0xC5,0xAD,0xC4,0x4A,0x6B,0x71,0x42,0x79,0x6F,0x85,0xA7,0xA9,0xE1,0x13,0x1C,
  0x47,0xE6,0x81,0x16,0x9B,0x5B,0x42,0xDD,0x3D,0x2A,0x96,0x36,0xFC,0x09,0x7E,0x24,0x3D,0x41,0xAA,0xC7,0x57,0x81,0x10,0x9B,0x78,0x71,0xEA,0x41,0x24,0xCC,0x33,0x5E,
  0xCA,0xA6,0x11,0xB7,0x7C,0x7E,0x25,0x8D,0xAF,0xF5,0xD9,0x14,0xBD,0x50,0xCE,0x2C,0x0F,0xB4,0xA4,0xB0,0xD0,0xAD,0xDC,0xBA,0xD0,0x48,0x12,0x06,0x6F,0xF8,0xFB,0x4C,
  0x70,0x89,0x2D,0x41,0x26,0x06,0x29,0x41,0xEB,0x92,0x7C,0xA4,0x31,0x2D,0x75,0x3A,0x21,0xED,0xD7,0xE8,0x91,0xF4,0x87,0x24,0x0D,0xBD,0xA5,0xF2,0x30,0xD1,0x37,0x92,
  0x9D,0x15,0xD3,0xAE,0x0D,0x0F,0x93,0x2A,0xCA,0xF3,0x38,0x8D,0xB6,0xE6,0x51,0x63,0x16,0xB3,0x04,0xAD,0x2D,0xEE,0xD6,0x60,0x89,0x47,0xEB,0x84,0x28,0x97,0x9E,0x94,
  0x98,0x86,0x56,0x64,0xBF,0x21,0x45,0xED,0x74,0x94,0x13,0xDE,0xB7,0x89,0x65,0x97,0xE5,0x6B,0x4F,0xD1,0xEE,0x49,0xB2,0x9A,0xD1,0x12,0x49,0x0E,0xA9,0x7A,0x5F,0x9F,
  0xB4,0x02,0x18,0xED,0xCA,0x72,0x9D,0x58,0x53,0x87,0xAF,0xD1,0x58,0xE0,0xD2,0x4C,0x28,0x63,0x45,0x4F,0xC1,0xDF,0xDB,0x15,0x99,0x96,0x3A,0x68,0x14,0xEA,0x43,0xC2,
  0xFF,0x56,0xE5,0x21,0x1A,0x90,0x74,0x23,0x16,0x5E,0x13,0x9F,0x66,0xD6,0x69,0x28,0x59,0xDA,0x6E,0x49,0x59,0x6F,0x25,0x39,0x54,0xE1,0x09,0x92,0x9A,0xE0,0xD8,0x5B,
  0xC1,0xE0,0x1A,0x58,0x37,0x58,0xC6,0xFB,0x30,0xA1,0xD8,0xCC,0xDF,0x85,0x39,0x71,0x1B,0x1D,0x8C,0xF0,0xB7,0x49,0x8A,0x7C,0xE1,0xB4,0x57,0x9C,0x43,0x52,0x76,0xA2,
  0x56,0xFA,0x4C,0x89,0xA5,0x6D,0x17,0x7A,0xEE,0x9C,0x95,0x2D,0xAE,0x5B,0xF3,0x3A,0xC9,0xBB,0x78,0xEE,0xBD,0x3C,0x3C,0x58,0xCE,0x9A,0x55,0xB8,0xB2,0x1E,0x5C,0xAF,
  0xB8,0x6C,0x68,0x69,0xDF,0x2E,0x48,0xAB,0xF0,0xC2,0x7D,0x7C,0x86,0x75,0xE6,0x93,0x59,0x21,0x8D,0xB4,0x33,0x60,0x79,0x5B,0x3C,0xE5,0x79,0x86,0xF1,0x63,0x6B,0x4E,
  0xA4,0x35,0x65,0x4A,0xC4,0x7B,0xD0,0xBA,0x9F,0x7D,0xEE,0x8C,0x2B,0xDE,0xD1,0x77,0x03,0x92,0xF5,0x75,0x81,0x96,0x49,0x23,0x25,0x5E,0xEC,0xE8,0xD7,0x04,0xEB,0xAB,
  0xB8,0xA2,0xDE,0x5D,0x14,0xBE,0x81,0x4A,0x4C,0x37,0xDC,0x39,0x22,0x5B,0xB0,0xDC,0x08,0xE4,0xA3,0x4B,0x8B,0x80,0x43,0x1E,0x03,0x31,0xBB,0x73,0x16,0x8E,0xB4,0xE9,
  0x25,0x05,0x1E,0x0A,0xC1,0xB2,0xF1,0xDD,0x90,0xF6,0xC2,0x90,0xC6,0x64,0x4D,0x92,0xC4,0xAA,0x1A,0x28,0x67,0x20,0x7A,0x36,0x25,0x38,0x4E,0x23,0xF9,0x77,0x42,0x9A,
  0x18,0x50,0xE6,0xD8,0xCF,0x76,0xB3,0xCA,0x96,0xDE,0x90,0x34,0xA6,0x02,0x1A,0xEF,0x55,0xAA,0xB3,0xE5,0x7E,0x82,0x0D,0xC9,0x26,0x8B,0x0E,0xEF,0xE6,0xB0,0x5F,0x58,
  0xB4,0x9B,0xAF,0x4C,0xC2,0x90,0x4E,0x14,0xA2,0xD2,0x80,0xDC,0x01,0x88,0xE3,0x87,0x9A,0xCC,0x35,0x8E,0xE6,0xC7,0xEA,0xF8,0x00,0xBE,0x37,0x50,0xAC,0xDB,0xC2,0x75,
  0x51,0xFD,0x04,0x95,0x8F,0xC0,0x9F,0x80,0x74,0xD2,0x5C,0x45,0xFB,0xE5,0xAA,0x12,0xC7,0x69,0x24,0x4F,0x7C,0x25,0xAD,0xBA,0x73,0x9C,0x46,0xB2,0x0A,0x2F,0xC5,0x59,
  0xBD,0x67,0xB9,0x41,0x86,0x28,0x75,0x82,0x32,0xA1,0x78,0x74,0x91,0xF7,0xF9,0x45,0x39,0x01,0x85,0x9B,0x54,0x8D,0x29,0xC9,0x23,0xAD,0x8B,0xE8,0x18,0x8A,0x1D,0x9A,
  0xD4,0x46,0xB5,0xE6,0x68,0x03,0xD2,0x99,0x65,0x44,0xE3,0x42,0x39,0x3C,0x48,0x99,0xB8,0x7B,0x90,0xD9,0x0E,0x2C,0xCB,0x8A,0x0C,0xB2,0xCC,0xEF,0x99,0x0E,0x8F,0x96,
  0xA4,0x25,0xDC,0x83,0x47,0xE2,0x08,0x18,0x65,0x66,0x7B,0xB5,0xB1,0xCA,0x5C,0xCC,0x7C,0x24,0x49,0xD1,0x4D,0x21,0xED,0xCE,0x72,0x9E,0x42,0x5F,0x05,0x73,0x93,0xBB,
  0x4E,0x9D,0x7F,0x90,0xEF,0xBC,0x9B,0x46,0x34,0x37,0xF1,0xFE,0x44,0xC9,0xB0,0x9A,0xB7,0xC7,0xDF,0x1B,0x49,0x1B,0x0C,0x69,0xD8,0x32,0x0F,0x7E,0x23,0x9D,0xB4,0xED,
  0x06,0xA4,0x9D,0x21,0xA4,0xA5,0xDC,0x3E,0x72,0x51,0x4E,0xDC,0xEB,0x43,0xDA,0x63,0xC5,0xFE,0xC3,0xEA,0x68,0x5D,0x05,0x7C,0x04,0x85,0x12,0x71,0xC2,0x8A,0x94,0x94,
  0x5B,0x2E,0x7C,0x24,0xFF,0xD6,0x94,0x16,0x9F,0x69,0xDF,0x79,0x98,0x72,0xB8,0x26,0xE8,0x82,0x8F,0x24,0x29,0x76,0xF1,0x47,0x3C,0x5D,0x4B,0xAA,0xD5,0xEF,0x34,0x7D,
  0xD0,0x1F,0xBE,0x93,0xF5,0xB8,0x0C,0x7E,0xA2,0xD0,0xAE,0x8C,0xBD,0xB3,0xDA,0x28,0x53,0x77,0xBB,0x65,0xBB,0x79,0x18,0x57,0x7E,0xFA,0xDB,0xDE,0xDA,0x6D,0x4D,0xA7,
  0x42,0x60,0xF2,0x08,0xA0,0xDF,0x48,0x34,0x61,0x21,0xD4,0xBB,0x02,0x8B,0xFB,0xA6,0x91,0x66,0x49,0x86,0xC6,0x34,0x4B,0x89,0xD9,0x1F,0x8F,0x24,0x49,0x7F,0x48,0xD3,
  0xA2,0xD5,0xFD,0xEE,0xEE,0xF6,0xEA,0x72,0x7A,0xFA,0xAE,0x22,0x30,0x59,0xCC,0x12,0x87,0x72,0xAA,0x51,0xD0,0xB7,0x50,0x13,0x33,0x5E,0xAA,0x43,0x12,0xF8,0x7A,0x23,
  0x79,0x93,0xAE,0xAC,0x07,0x73,0x89,0xBE,0x88,0x68,0x7E,0x5C,0x9E,0x28,0x53,0xA9,0x88,0x2A,0x3E,0x92,0x44,0x1A,0x16,0x01,0x41,0x1F,0x81,0x2B,0x9C,0x65,0xD0,0x1F,
  0xD3,0x96,0xB1,0x57,0xB8,0xD5,0x4C,0xD2,0x4C,0x58,0x16,0x71,0xD4,0x11,0xBC,0xF0,0xB2,0x2C,0xF3,0xBA,0x7C,0x2F,0xBC,0x14,0x3C,0x22,0xA2,0x22,0xFE,0xE1,0xBA,0x47,
  0x7A,0x6F,0xAC,0x32,0x81,0xF0,0x94,0xB1,0xB7,0xC4,0x2F,0xEA,0x79,0x75,0xA7,0x7A,0x21,0x4D,0x23,0xD3,0x58,0x58,0xC0,0x11,0x3F,0x5F,0x90,0x3F,0xFE,0xE5,0x34,0x95,
  0x4C,0x2B,0x32,0x44,0x98,0x61,0x27,0xD1,0x37,0x9D,0x4C,0x0B,0x97,0x01,0x7B,0x7F,0x62,0x28,0xAB,0xDE,0x58,0x92,0xD6,0x21,0xD3,0xC4,0xB6,0xC6,0xFA,0x95,0x9A,0x2A,
  0x13,0xA3,0xE2,0xA6,0x1A,0xA7,0x75,0x29,0xB4,0x6B,0xE3,0x11,0x2F,0x6C,0x2B,0x3F,0xEF,0x61,0xE4,0x60,0x35,0x6C,0x8D,0xDA,0x8C,0x6F,0x29,0xDA,0x84,0xB4,0x77,0x5F,
  0xE3,0x8E,0x73,0xE1,0x7A,0xD4,0xF0,0xD6,0x90,0xA6,0x92,0xA2,0xD2,0xB8,0x3F,0x9A,0xD5,0x52,0x89,0x4E,0x96,0x25,0xD7,0x37,0x5F,0xDD,0x24,0xA9,0x7C,0x6D,0xBC,0x18,
  0xB1,0x2E,0x77,0xA4,0x88,0x8C,0x43,0xE2,0x4D,0x7E,0xAF,0xDC,0x18,0x9F,0xCD,0x92,0x60,0x16,0x2E,0x27,0x49,0x36,0xD5,0xB5,0xB9,0x36,0x6C,0x1B,0x5E,0x58,0x22,0xCC,
  0x3B,0xBC,0x14,0x2B,0x02,0x9F,0xAA,0x74,0xE5,0x9D,0x4E,0x8A,0xA7,0xBD,0x76,0xD7,0xD0,0x12,0x3B,0x96,0x79,0x10,0xA7,0x32,0x22,0xA9,0xAA,0xD4,0xEA,0xDE,0x0D,0x48,
  0x9E,0x86,0x32,0x9A,0xC4,0x6D,0x26,0x4E,0x23,0xED,0xDD,0xD7,0x0B,0x34,0xE1,0xE8,0x17,0xCF,0xC2,0xF7,0xD6,0x27,0xD1,0x52,0x2E,0x70,0xBE,0xE3,0xFC,0x06,0x73,0x53,
  0x26,0xE8,0x88,0x9F,0x28,0x90,0xAC,0xD3,0x1B,0x13,0xBA,0x96,0xBA,0x02,0xE9,0x83,0x78,0x36,0xD6,0x96,0x5B,0xAB,0xA3,0xF0,0xDD,0xF4,0x23,0x89,0x66,0x39,0xFF,0x32,
  0x58,0x09,0x5F,0x71,0xB1,0x68,0xBE,0xD9,0x7B,0x16,0xE6,0x13,0xFB,0xBE,0x2E,0xD6,0x89,0xD1,0x6E,0x48,0xB2,0xA4,0x8A,0x76,0x62,0x3C,0x3E,0x56,0x78,0x71,0x38,0x8D,
  0x34,0x27,0x93,0x34,0xB1,0xCE,0x64,0x79,0x9C,0x46,0xB2,0xBB,0x6F,0x57,0x01,0xC8,0x92,0xDB,0xCB,0x2B,0x69,0x35,0x32,0x4D,0x1B,0x92,0x7C,0xD0,0x9C,0xD6,0x7C,0x05,
  0x2C,0x48,0x67,0x33,0x18,0x8B,0x79,0xBB,0xB4,0xDA,0xF7,0xC4,0xB4,0xA6,0x21,0x6D,0x4E,0x9A,0x25,0xC9,0x78,0x00,0x6E,0x56,0x89,0xE8,0x72,0x49,0x4D,0x41,0x7F,0xF5,
  0x1D,0x68,0x9E,0x3F,0x1F,0x1D,0x42,0x33,0xF3,0xB3,0x69,0xB0,0x34,0xFA,0xF3,0xFD,0xCE,0xF4,0xB6,0xB5,0x83,0xCE,0x77,0x58,0x8A,0x95,0x05,0xBC,0x3B,0xC3,0xDE,0xC2,
  0xE6,0x43,0xBD,0xAF,0x12,0xF1,0xB4,0x0B,0x8A,0xFE,0x10,0xD3,0x98,0x1E,0xE6,0xDA,0xBB,0x8D,0xEC,0x25,0x3F,0x4E,0xFB,0xB1,0x39,0x8D,0x9F,0x2F,0x50,0x4E,0xB9,0xB4,
  0x9F,0x68,0x34,0x56,0x65,0x84,0x72,0xD3,0x3A,0x4D,0x23,0xCD,0xD4,0xBB,0x8D,0xE1,0x19,0xEE,0xA6,0x49,0x50,0x2F,0xD7,0x1F,0x48,0xAB,0x50,0x84,0xE8,0x4C,0x8D,0x5D,
  0x50,0x96,0x82,0xA9,0x92,0xA6,0xD3,0xFA,0xC6,0x69,0xDC,0xBB,0xC6,0x3D,0x6D,0x09,0xC7,0x4D,0xA5,0x99,0xC0,0x69,0x24,0xDD,0x48,0xD0,0x72,0x4B,0x3F,0x8E,0x3F,0xAF,
  0xA1,0x91,0x6C,0xC8,0x30,0xD8,0x89,0x87,0xC7,0x44,0x27,0x4B,0xE2,0x92,0xF9,0x02,0x40,0x6E,0xD9,0x12,0xE7,0x34,0xD2,0x09,0x9E,0xA0,0xCD,0x70,0xC3,0x59,0x27,0xEF,
  0x58,0x54,0xEF,0x78,0x31,0x8D,0x14,0x91,0x20,0x68,0x19,0xCF,0x93,0xF2,0x03,0x0B,0xDC,0x9C,0xC2,0x44,0xDD,0x96,0x57,0xD9,0x62,0xB4,0x26,0x73,0x32,0x47,0xC3,0x98,
  0x04,0x16,0x37,0x53,0x51,0x65,0x8B,0xD1,0x48,0x1E,0xD9,0x2A,0x5A,0x75,0xD7,0x04,0x8D,0xB4,0xC7,0x0A,0x9A,0xB8,0x6A,0x91,0x9C,0x1B,0xC2,0x5E,0x2E,0xBF,0x50,0xCE,
  0x69,0x24,0x4D,0x8C,0xE7,0x55,0x4B,0x58,0xFD,0xB4,0x3B,0xD0,0x77,0x03,0x52,0x9C,0x39,0xF7,0x4F,0x8A,0xB3,0xC7,0x77,0xBD,0x8E,0x3E,0xEC,0xC8,0xF8,0x10,0x63,0x1A,
  0xC9,0xAA,0x13,0x0B,0x0D,0x64,0x09,0x88,0x67,0xD7,0xA0,0x48,0x66,0x7E,0x32,0x48,0xBA,0x71,0x2D,0x92,0xC3,0x24,0x7C,0x0D,0x8B,0x67,0x97,0xDD,0xDA,0x92,0xBA,0xDD,
  0x7A,0xA7,0x92,0xEE,0x3E,0x54,0xD1,0x66,0x66,0x75,0x8D,0x2D,0x46,0x23,0xDD,0x24,0xC4,0x16,0xD9,0xC5,0x07,0x71,0x0D,0xC7,0x0C,0x36,0xAE,0xBF,0x72,0x65,0xAA,0xB7,
  0xF0,0xFD,0x8D,0xA4,0xD3,0xC6,0xB4,0x86,0x7A,0x09,0x29,0x72,0x6B,0x96,0xB8,0x40,0xD8,0x64,0xEF,0x56,0x49,0x3B,0x0E,0xD2,0x9A,0x5D,0xDC,0x15,0x36,0x24,0xE9,0x4E,
  0x26,0xAB,0xE8,0xDB,0xE8,0x2A,0xAD,0xF0,0xA4,0x93,0x6C,0x48,0xA4,0x35,0xBB,0x4A,0x2B,0x24,0x17,0x69,0x75,0x17,0xD0,0x48,0xD1,0x37,0x3A,0xE9,0xE4,0x0A,0x69,0x79,
  0x8B,0xBC,0x3E,0x24,0x2D,0xA4,0x0D,0x48,0x7B,0x00,0xD2,0x50,0xCC,0xBB,0x20,0xF6,0xB7,0x22,0x09,0xB5,0x55,0x5E,0x3D,0x2B,0xF7,0xDE,0x9E,0xD7,0x14,0xED,0x75,0x96,
  0xD2,0x0F,0xA4,0x4E,0xA4,0x53,0x7D,0xD3,0x48,0x7B,0x37,0xD2,0x12,0xE3,0x46,0xE9,0x1C,0xF7,0x6B,0x90,0xAC,0x71,0xE6,0xEA,0x6D,0xB3,0xD0,0x16,0xF6,0xD6,0x6A,0x3C,
  0x5E,0x39,0x9A,0x4A,0xA7,0x85,0x7A,0x9D,0x5C,0xAC,0x69,0x8A,0x36,0x24,0x8F,0xE4,0xF7,0x89,0xC3,0x15,0x3C,0xC5,0x0D,0x50,0x47,0xB6,0x5F,0x8E,0x6A,0x8E,0xB3,0xB8,
  0x1D,0x40,0x3A,0x93,0x40,0x6D,0xE7,0xCE,0x34,0xC0,0xCE,0xA1,0xBA,0x48,0x85,0x8F,0x94,0x12,0x5B,0x97,0xB7,0x8F,0x15,0xF1,0x08,0xFC,0x30,0xF7,0xDE,0xB0,0x50,0x3D,
  0xFA,0x9B,0xB5,0xDB,0x09,0x6D,0x42,0x1C,0xF2,0x96,0x5D,0x92,0xE6,0xC1,0x9A,0x36,0xCD,0x40,0x9E,0x9D,0xCE,0xDB,0x3F,0x87,0xC7,0xFE,0xA1,0x62,0x14,0x1D,0x49,0xD6,
  0xBB,0x04,0x86,0xA4,0xCB,0x25,0x33,0x6B,0x9D,0xD8,0xD2,0xE9,0x57,0x22,0x54,0xDA,0xE4,0x69,0x50,0x57,0x2B,0x49,0xEB,0x93,0x54,0xE8,0x19,0x0C,0x9E,0xA8,0x15,0xE0,
  0x2B,0x3F,0x92,0xBA,0xC7,0xA7,0x2A,0x29,0x0C,0x74,0xE6,0xBE,0xC0,0x9E,0xF0,0x93,0x83,0x2E,0x61,0x9F,0x47,0x2E,0xB3,0xD8,0xC2,0xEF,0x79,0xBC,0x06,0xBB,0x30,0x5A,
  0x65,0x68,0x75,0x69,0xDB,0x5E,0x8E,0xD6,0xE6,0x59,0x7E,0xEB,0x57,0x07,0xA7,0xD1,0xB6,0xF4,0xFD,0x16,0x94,0xDA,0x75,0xB8,0xE2,0x35,0xF4,0x15,0xB9,0xE8,0x65,0xF4,
  0x15,0xCB,0x91,0x30,0x90,0xC7,0x24,0xB3,0x6E,0x6E,0x3C,0x18,0x9E,0x15,0xC2,0xF8,0x95,0x84,0x05,0x96,0x99,0xE3,0x5E,0x15,0xDB,0x2F,0x8F,0xE5,0xE3,0x34,0x92,0xF8,
  0xCC,0xD2,0x30,0x06,0x05,0x94,0xB2,0xEF,0x99,0x46,0xCB,0x32,0x51,0x39,0x46,0x25,0x8D,0xE4,0x6A,0x48,0xD3,0x30,0x89,0x83,0x0C,0x28,0x41,0x23,0xAD,0x80,0x34,0x0D,
  0x4B,0x5A,0x84,0x9C,0xEF,0x31,0xD2,0x61,0x67,0x94,0xAB,0xBB,0x8C,0xF6,0x33,0x71,0x24,0xB7,0x7B,0xD8,0x7E,0x14,0x71,0x3D,0x0E,0x16,0x3B,0xCD,0x45,0x74,0x43,0x72,
  0x35,0x84,0x34,0xC4,0x1C,0x29,0x73,0xC3,0xDF,0xC8,0x7A,0x1A,0x04,0x8D,0xA4,0x1C,0xCD,0xCD,0xD5,0xDE,0xB3,0x82,0x17,0xA2,0xD2,0x17,0xD1,0x26,0x24,0xF3,0x60,0xBE,
  0x81,0xFD,0xF4,0x35,0x87,0x3E,0xB4,0x91,0xDC,0x80,0x3E,0xFB,0xD0,0xE8,0xBE,0x32,0x57,0x8E,0x88,0x7D,0xE3,0x0B,0x2D,0x1D,0xF3,0x25,0x15,0x1F,0xC2,0x95,0xDA,0x6B,
  0x12,0x8D,0x1F,0x86,0xF0,0x63,0xF1,0x33,0xAC,0x59,0x24,0x8E,0x96,0x84,0x6E,0x56,0x91,0xFC,0x83,0xAF,0x37,0x92,0x63,0x43,0xD0,0x9A,0x5C,0x92,0xE1,0xEF,0x8D,0xB4,
  0x9B,0xCE,0xAD,0x2F,0xB9,0xBB,0x46,0x51,0xAA,0x4A,0x89,0xC0,0xB6,0x0E,0xE9,0x28,0xBE,0x90,0xC6,0x3D,0x45,0x32,0x86,0xD6,0xAE,0x43,0x32,0xC7,0xE7,0xF6,0x0B,0xC6,
  0x33,0xC0,0xEE,0x42,0xBE,0x79,0xC0,0x43,0xE3,0x69,0x23,0xE9,0xAE,0x56,0x51,0x4C,0xDB,0x3B,0xB5,0xF3,0x8E,0xFB,0x8A,0xFE,0x76,0x79,0x32,0xBE,0x39,0xAD,0x76,0x16,
  0x31,0xDA,0x39,0x6D,0xBD,0xF1,0x6B,0xFA,0x3C,0x0C,0xF1,0xF2,0x92,0x07,0xAE,0xB2,0x53,0x4F,0x39,0xA5,0xB6,0x4F,0x72,0x00,0x67,0x69,0x53,0x0C,0x1C,0x25,0x68,0x78,
  0x7D,0xDA,0xDE,0xBD,0x03,0xF3,0x11,0x35,0x05,0xD0,0x2A,0x6D,0x93,0x94,0xDF,0x8D,0xCD,0x12,0xED,0x81,0x34,0x27,0x77,0x2F,0x9E,0xB5,0x6F,0xE0,0xB2,0x09,0xFB,0x46,
  0xDB,0xBB,0x13,0x2E,0xA8,0x44,0x16,0x45,0xEE,0xC1,0x34,0x2B,0x0D,0x3C,0xAE,0x99,0x13,0x69,0xB0,0xBB,0x61,0x20,0x9B,0xB0,0x37,0x08,0x2A,0x3A,0xD7,0xCC,0x69,0x9A,
  0x02,0x5E,0x55,0xB2,0x31,0x70,0x7B,0xBE,0x77,0x02,0xB7,0xF2,0xD6,0x52,0x11,0x4D,0x23,0x39,0xA4,0xC2,0x53,0xCE,0x84,0x03,0x40,0x2E,0x38,0x24,0x74,0xA3,0x90,0x8C,
  0x48,0xCC,0x45,0x8F,0xF7,0x8A,0xF8,0x26,0x40,0xB7,0x71,0xBA,0x34,0xC9,0x05,0x34,0xCB,0xF5,0x95,0x13,0xCB,0x33,0x25,0xAE,0xD3,0xE5,0x68,0x27,0x34,0x59,0x12,0x5D,
  0x32,0x95,0x89,0x7A,0xCF,0xD3,0x54,0x52,0x78,0x48,0x8A,0xC6,0xE6,0x3D,0xF7,0x37,0x48,0xBB,0x1A,0x68,0x73,0x12,0x69,0x89,0xF3,0x81,0xA3,0x30,0xBC,0xFF,0xA8,0x16,
  0xCB,0x69,0x24,0xE7,0x76,0xFA,0xD0,0x3B,0x0A,0xDB,0x4B,0xE5,0xCC,0xA8,0xBA,0x40,0xB4,0xA4,0x49,0xE5,0xBD,0xBF,0x33,0x99,0x43,0x2A,0xBA,0xB7,0x50,0x99,0x61,0x2A,
  0xDB,0xB7,0x31,0x4D,0x7B,0xBD,0x17,0x46,0x5A,0xC2,0x9D,0x10,0x49,0xE5,0x89,0x6D,0xF9,0xBE,0xAD,0x9C,0xD9,0x85,0xA9,0x8B,0x19,0x6D,0x46,0x3A,0x70,0x89,0x4A,0x9A,
  0x32,0xAF,0xD4,0xF7,0xA9,0xD4,0xE3,0x32,0x87,0x12,0x73,0xDA,0x7A,0x63,0x34,0x3F,0x10,0xCB,0xFB,0x07,0x7E,0x8A,0x7B,0x87,0x07,0xD4,0xFE,0x1F,0xF9,0x7D,0xAC,0x4A,
  0xDB,0x74,0x4E,0xF2,0x97,0x54,0xD3,0x26,0xF6,0x71,0x39,0x90,0x8F,0xE4,0xAB,0x68,0x42,0x4A,0x86,0xB8,0x5A,0xBD,0x64,0x4E,0xF2,0x60,0x64,0x69,0x1F,0x9C,0x95,0x6B,
  0xBB,0x78,0x61,0xA8,0x16,0xC8,0xFB,0x46,0xDB,0x03,0xEE,0x95,0xA9,0xC1,0x0C,0x5F,0x72,0x28,0x08,0xEF,0xDB,0x3D,0x49,0x53,0x40,0xDA,0xD6,0xDD,0x3F,0xD8,0x98,0xC6,
  0x7A,0xBE,0x75,0xA5,0x6B,0x0D,0x08,0x1A,0xCD,0xEA,0xB8,0xC7,0x60,0x63,0x3F,0xB5,0xC3,0x25,0xE2,0x64,0x6B,0xDF,0xDB,0x8C,0xB6,0x07,0xDC,0xC7,0x11,0xC6,0x14,0xA3,
  0x3B,0xEA,0xDB,0x2F,0xC4,0x91,0xE4,0x65,0x76,0x3F,0x1A,0x58,0x84,0xB3,0x72,0x81,0x15,0xD2,0x68,0x3E,0x85,0x34,0x0D,0xA4,0x31,0x26,0x80,0x92,0x82,0xF2,0x91,0xA4,
  0x69,0xAF,0x69,0xDA,0x09,0x06,0x55,0xCB,0xE5,0xC0,0x14,0x7D,0xFB,0x1B,0x71,0x24,0xF9,0x75,0x51,0x61,0x11,0xE3,0xD4,0x08,0xF3,0x5C,0xD5,0x44,0x6F,0xF3,0xBE,0x51,
  0x47,0xF2,0x1C,0x4F,0x1C,0x79,0x6E,0x2B,0xE6,0xC1,0x7F,0xCF,0xBE,0x42,0xB7,0x10,0x7B,0x84,0x6A,0x5F,0xD0,0x8C,0xA6,0xBD,0xDE,0x2B,0x17,0x2E,0xD3,0x0F,0x78,0xD5,
  0x5B,0x6A,0x88,0xE0,0x9C,0xB6,0x77,0xDF,0x27,0x4E,0xE5,0x3C,0x5E,0x7E,0x53,0xD2,0xA1,0xC1,0xFB,0x46,0xDB,0xBB,0x13,0x34,0xD9,0xB3,0xC6,0x54,0xDF,0x48,0x87,0x80,
  0x49,0xDA,0x7C,0xB3,0x67,0x15,0xDC,0xEE,0x2C,0x5B,0xC6,0x8F,0xCE,0x69,0xA4,0x43,0x77,0xA0,0xFD,0x68,0x3C,0x57,0xFA,0x21,0xAB,0x69,0xA4,0xE3,0x54,0xA4,0x99,0x6B,
  0xEE,0xC3,0x13,0xC7,0xFC,0xE8,0xC7,0x93,0x7E,0x6F,0x73,0x9A,0x95,0x7F,0xAF,0x5C,0x19,0x2F,0xA6,0x17,0x3B,0xB2,0x25,0x65,0x72,0x38,0x4B,0x68,0xDA,0x6B,0x05,0x0D,
  0xBF,0xC6,0x0C,0xC9,0x95,0xEB,0x8D,0xE6,0x55,0xCB,0xD1,0xD8,0x69,0x95,0xCC,0x78,0xF2,0x91,0xA4,0xD9,0x01,0x40,0x33,0x2D,0x83,0x2F,0x71,0xDA,0xD9,0x11,0xEF,0x1B,
  0xE9,0xF4,0x01,0x69,0x2E,0x96,0xCE,0xE2,0x37,0x8B,0xF9,0xF5,0xAE,0xE4,0x4E,0x70,0xE6,0xDA,0xEB,0xB2,0x0A,0xA2,0xD8,0x37,0x52,0xA2,0xA7,0x42,0x5A,0x0D,0x26,0xD5,
  0x37,0x2A,0xED,0xDA,0x85,0x17,0xB5,0xC7,0x8C,0x52,0x86,0xB7,0x25,0x88,0x4A,0xDE,0x37,0x9A,0x7F,0xF2,0x5E,0x98,0x00,0xED,0xF8,0xC0,0xD8,0x5C,0x6D,0x1C,0xB7,0x5D,
  0x7B,0x59,0x88,0xD3,0xA8,0x1A,0x5E,0xBA,0x42,0x22,0xCD,0x87,0xB7,0xF3,0x3D,0xE2,0x6E,0x3A,0xC3,0xBB,0x79,0xCA,0xB8,0x7D,0xCF,0x72,0x84,0xC8,0xC9,0xC8,0xB8,0x6F,
  0x54,0x9D,0x8B,0xD3,0xC2,0x32,0x9B,0x44,0xFF,0xE4,0x9C,0xAA,0x97,0x70,0x1A,0xA1,0x53,0x29,0x1A,0xD5,0x5A,0x4C,0xD2,0xE8,0x3A,0x17,0x55,0x96,0x30,0xA5,0x95,0x99,
  0xC1,0x72,0xA9,0xFF,0xD2,0x34,0xEA,0x1E,0x90,0x39,0x30,0x12,0x36,0x15,0x8B,0xD6,0xC0,0x44,0xAA,0xA5,0xAE,0x2F,0x4E,0xA3,0x8E,0xE4,0x7C,0x85,0x95,0x2B,0xE9,0x6A,
  0x10,0x7F,0x6F,0xA4,0x33,0xE1,0x1C,0x4D,0xFE,0xCD,0xF1,0xBE,0x91,0x69,0xCC,0xB8,0xF9,0x81,0x45,0x32,0xF3,0xB4,0x6A,0x47,0xCA,0x8D,0xCB,0xCC,0xFE,0x4A,0xE3,0x94,
  0xF7,0x8D,0xBA,0xBF,0xCD,0x03,0xD7,0xDB,0x06,0x4D,0xF5,0x49,0xD2,0x65,0x70,0xA0,0x81,0x56,0x0C,0xAA,0x31,0xC9,0x11,0x9A,0x18,0xC9,0x33,0xA2,0xE4,0x5A,0xEC,0x51,
  0x84,0x10,0x72,0x12,0xA7,0xFA,0x46,0xA5,0xF1,0x30,0xDF,0xA4,0x5B,0xE6,0x7B,0xCC,0x1E,0x50,0x95,0x91,0x27,0xD1,0x37,0xAA,0x77,0x06,0x6F,0x25,0xB5,0xC7,0x9E,0xBB,
  0xC7,0xDD,0x66,0x2F,0x2F,0x2A,0x79,0xDF,0x48,0x3A,0x57,0xF8,0xD2,0x8E,0xC2,0x7B,0xC4,0xDF,0x47,0xD7,0xCB,0x9E,0x6A,0xDC,0x94,0xFC,0xBC,0x9B,0x34,0x27,0x63,0xDA,
  0x1C,0x6F,0x29,0xF8,0x30,0xA4,0x9E,0xE9,0xAC,0x36,0x3C,0x50,0xA1,0x3E,0xB4,0x7E,0x4C,0xF2,0x05,0x2D,0x4C,0xDB,0xDC,0x6D,0x5C,0xBA,0xB7,0x24,0xF4,0x86,0x92,0x7C,
  0xE6,0xDC,0xC1,0x3A,0xDD,0x98,0x9F,0x9B,0x95,0x3B,0x52,0x49,0x16,0xD5,0xC2,0xB3,0xDA,0x20,0x40,0x44,0x76,0x1A,0x1E,0xC2,0x12,0xE5,0xC7,0x83,0x1F,0x56,0x9C,0xFE,
  0x31,0x4D,0xA1,0xEB,0xBF,0x96,0x76,0x65,0x78,0xD2,0xC1,0x80,0x5D,0x52,0xDA,0x98,0xC5,0xC7,0xD4,0x41,0xBE,0x2C,0x29,0xEA,0x9B,0xBA,0x7D,0x0D,0x6D,0xBE,0x35,0xCA,
  0x8B,0x5B,0x14,0xBD,0x37,0x92,0x9C,0xFC,0x70,0x76,0xAB,0x8C,0x6D,0x4C,0x4D,0x2C,0xE2,0xD5,0x12,0x1B,0xAA,0x8C,0xA7,0xB7,0x47,0x5A,0x6F,0x31,0x0D,0xDE,0x20,0xE0,
  0xF6,0x98,0xEB,0xF2,0xD2,0xF1,0xAD,0x47,0xC7,0xAA,0xB1,0x58,0xF9,0x69,0x1F,0xE9,0xC2,0x74,0x4C,0x13,0x22,0x24,0x24,0x1D,0x29,0xBA,0x48,0xB4,0x52,0x16,0x65,0xCF,
  0x69,0x24,0xCD,0x3C,0xA6,0x4D,0x2D,0x6F,0xB5,0xB7,0x02,0xEF,0x85,0x1F,0x77,0x5C,0x99,0xA5,0xF7,0xB2,0x53,0xB4,0x7B,0x2A,0x4D,0xBC,0xA6,0x68,0x99,0x45,0x5C,0x99,
  0x91,0xFC,0x85,0x44,0x73,0xAC,0xA0,0x41,0xE8,0x79,0x4C,0xA3,0xCD,0x92,0xB9,0x32,0x35,0x3E,0x1B,0x36,0x74,0xE4,0xDC,0x74,0x4C,0xCF,0x90,0x2F,0xD1,0xC0,0xA3,0x59,
  0x48,0x1A,0x5E,0x82,0x46,0x74,0x05,0x09,0x1A,0x49,0x7B,0x4D,0xD0,0xA8,0xA9,0xE0,0x38,0x8D,0xB4,0x9B,0x8A,0x10,0xE6,0x84,0x0B,0x1B,0x67,0xFD,0xED,0x67,0x1C,0xD3,
  0x9A,0xFC,0xB2,0x3C,0x52,0x87,0x34,0x27,0x3F,0x9A,0x5E,0x60,0xAD,0xE0,0x6D,0xB1,0xC8,0xF0,0x64,0xDA,0x9F,0xA9,0xBD,0x0F,0x56,0x1B,0xD3,0xF3,0xCB,0x22,0x31,0x18,
  0x6D,0xAA,0xA7,0x0E,0xA9,0x64,0x69,0xE1,0x51,0x34,0xBB,0x33,0x56,0x73,0x89,0x25,0x41,0xEB,0x90,0xDE,0x5B,0x8E,0xC6,0xEF,0x8C,0xC9,0x54,0x57,0xE6,0x34,0xD2,0x9C,
  0x64,0xB6,0x3D,0x3F,0x37,0x4D,0x5C,0x11,0x95,0x2E,0x66,0x76,0x37,0xA0,0xCD,0x12,0x5E,0x57,0x29,0x45,0x92,0x4C,0xB3,0xC5,0x69,0xA4,0xD5,0x2D,0x6E,0x67,0xE2,0x35,
  0x65,0x7F,0x03,0xC6,0x69,0x5D,0xF8,0x69,0x96,0x36,0x26,0x79,0x9E,0x3E,0xC2,0x22,0x33,0xB7,0xAE,0x17,0x50,0xCF,0x55,0xC2,0x28,0x24,0xD2,0x48,0x32,0x8F,0x1D,0xDE,
  0x19,0xCB,0x57,0x6B,0x8E,0x2A,0xC9,0x57,0x8D,0xE4,0xCF,0x54,0x5A,0x79,0x1C,0xAD,0x44,0xDF,0xB4,0x57,0x27,0x21,0xBE,0x87,0xED,0xFB,0xDA,0x58,0x61,0x49,0x6C,0x62,
  0x6E,0x42,0x11,0x53,0x49,0x79,0x97,0xC8,0xC3,0x41,0xE5,0xCB,0x8E,0x2B,0x10,0x36,0xE6,0x9B,0x60,0x0B,0x9F,0x8F,0xF7,0x78,0xBB,0xB7,0x8B,0x3D,0x99,0x5C,0x7A,0x92,
  0xBC,0x5F,0xC5,0xB4,0xF8,0x36,0x41,0x39,0x4C,0xD0,0x48,0xD6,0x01,0x6F,0x53,0x58,0x3D,0xAC,0x06,0x92,0xE1,0x81,0xAC,0xC1,0xB5,0x57,0xB7,0x3E,0x38,0x8D,0x74,0xBA,
  0x23,0x68,0x55,0x25,0xAC,0xCA,0x8A,0xAA,0x23,0xED,0xA4,0x43,0x9B,0xA9,0x8C,0xF6,0x8A,0x22,0xB6,0x06,0xC5,0x3E,0xE6,0xB4,0x53,0x07,0xD4,0xAE,0x30,0xD0,0x4B,0x44,
  0x60,0xC9,0xCD,0xCA,0x01,0x49,0x37,0xE2,0x34,0xE6,0xF7,0xFA,0x9E,0x0B,0x51,0xBC,0x87,0x28,0x95,0xA2,0x9E,0xF5,0x6D,0xFD,0x28,0x4D,0x53,0x22,0x5C,0x2C,0x57,0xA8,
  0x41,0x65,0x4D,0x5E,0x1C,0xAF,0x3A,0x96,0xB8,0xDD,0x2E,0x13,0xAE,0xC4,0x85,0x35,0x69,0x6B,0xB8,0xB7,0x9C,0xB5,0xBF,0xF7,0x1E,0x96,0x2E,0x35,0x42,0x5B,0x08,0x34,
  0xD2,0xD6,0x70,0xEF,0xDA,0x0F,0xBB,0xF2,0x4C,0x76,0xB5,0xB4,0x2E,0xA9,0x6F,0x61,0x31,0x9B,0xC4,0x8A,0x63,0x5E,0x3D,0xB6,0xB6,0xCB,0x96,0x5A,0x4C,0x3B,0xA1,0xA9,
  0x2B,0x82,0xD6,0xE4,0xCA,0x28,0x57,0xD8,0x49,0x8E,0xC4,0xC4,0x7D,0x2A,0x62,0x21,0x3C,0x61,0xB2,0x92,0x82,0x93,0xD2,0xD1,0x94,0x09,0x45,0x45,0xF2,0x7A,0xD5,0x80,
  0xE4,0xFE,0x6A,0x17,0xFC,0xB9,0x71,0x9D,0xB6,0x1F,0xE0,0x3D,0x0C,0x98,0xA6,0x81,0xEB,0xF9,0x56,0xD1,0x6F,0x15,0xFF,0x89,0xB8,0xAD,0x82,0x47,0xAC,0x79,0x96,0xF0,
  0xA4,0x02,0x44,0x28,0xBB,0x2A,0xC4,0x96,0x21,0xE0,0x5D,0x09,0x37,0x63,0x4F,0x1F,0x0D,0xD3,0x5E,0xFD,0x72,0x5A,0x7B,0x98,0xC5,0x49,0x52,0x62,0x9C,0xDE,0xD1,0x33,
  0xE3,0x5C,0x8E,0xEB,0xE6,0x7A,0xC7,0x70,0x22,0x07,0x1E,0xAB,0x7D,0x2B,0x0C,0xF7,0xD2,0x59,0xC4,0x70,0x69,0x57,0x63,0x33,0x9C,0xF0,0x82,0x54,0x03,0x43,0x9C,0xFA,
  0x6A,0x1C,0x46,0x6E,0xD4,0x75,0x2E,0xC2,0x69,0xAF,0xC6,0x75,0x95,0xB9,0xB5,0x06,0xC5,0x25,0x08,0x40,0x69,0x63,0x29,0x51,0xA7,0x2F,0xA0,0x88,0x63,0x10,0x63,0x4C,
  0x6F,0xF5,0xBA,0x9A,0xF4,0xBB,0x53,0x39,0x6E,0xFE,0x64,0x82,0x2A,0x84,0x45,0x9E,0x89,0x13,0x05,0x70,0x7D,0x2D,0x73,0xD9,0xA5,0xDE,0x25,0x9D,0xA2,0xF1,0xAE,0xCD,
  0x37,0xEE,0xDE,0xC6,0x90,0x9F,0x99,0xBB,0xF6,0xCB,0x1F,0xA0,0xD5,0xEF,0xA8,0xAA,0x6C,0xE7,0x38,0x2D,0x01,0xB9,0x74,0x02,0xF3,0x11,0xFD,0x11,0xA0,0xEC,0x56,0x40,
  0x62,0x5A,0xE6,0x1E,0xB0,0x04,0x4D,0x5E,0x92,0x7C,0x7D,0x79,0x03,0x72,0xCE,0x24,0xBD,0xCB,0x44,0xCF,0xC9,0x34,0xFE,0xBF,0xBF,0x4F,0x6E,0x4F,0x7E,0xD5,0xFE,0xF9,
  0x9D,0x48,0x31,0xD2,0x8C,0xDE,0xD2,0x87,0xD9,0x77,0x5C,0xD7,0xD5,0xD7,0x94,0x44,0x44,0x5A,0xA6,0x26,0x62,0x0D,0x8D,0xE7,0x63,0x0D,0xD3,0x2A,0x86,0x95,0x0A,0x61,
  0x03,0xB3,0x9C,0x95,0xED,0x06,0x55,0xF1,0x1E,0x9C,0xF6,0x73,0x2A,0xE3,0x27,0x89,0x26,0x24,0xDC,0xD4,0x58,0xD6,0xA4,0x16,0x8D,0x69,0x69,0xB7,0xAB,0x0C,0xED,0xB6,
  0x1D,0xF1,0x64,0x3A,0x95,0xEE,0x9B,0x46,0xED,0xDB,0x2F,0x31,0xED,0xC4,0x5C,0xB9,0x98,0x08,0x47,0x82,0x2B,0x68,0x2A,0x81,0x96,0x29,0xCB,0x26,0x52,0x2B,0xCA,0x29,
  0xDF,0x8C,0x36,0x19,0x53,0x68,0xE2,0xA2,0x2C,0xFD,0x50,0x51,0xD0,0xD2,0x99,0x91,0x1B,0xD8,0xF7,0xAF,0x29,0xAC,0xC0,0xFB,0x7B,0x46,0xE8,0xEF,0x6B,0x0A,0x2B,0x70,
  0xDA,0x29,0x95,0x76,0xD7,0xAC,0xB0,0x02,0xA7,0x9D,0xCB,0xD3,0xBE,0xC3,0xF4,0xE4,0x4B,0x9C,0x99,0x2E,0x7A,0x7E,0x29,0xC1,0xCB,0x11,0xEF,0x84,0xD2,0xBB,0x54,0xA1,
  0xCE,0x1F,0xB8,0x43,0x76,0xBF,0xAE,0x89,0x38,0x4F,0xD0,0x76,0xDD,0x87,0x57,0xCE,0x1D,0x96,0x66,0x38,0x8A,0x6A,0x16,0xD9,0x85,0xE7,0xAB,0xB0,0x2E,0x71,0x95,0x71,
  0xCC,0xFB,0x7B,0xAD,0x52,0x9E,0xA0,0x20,0x89,0xB2,0xF4,0xE6,0x21,0x78,0x14,0x99,0xFA,0x9A,0x24,0x51,0x6C,0x7C,0x37,0x4B,0x02,0xED,0x35,0x59,0x17,0x18,0xAD,0xAF,
  0x13,0x68,0xE1,0x4D,0x2E,0x9A,0xC8,0x89,0x69,0x99,0xA3,0x2C,0x02,0x8D,0xC7,0x8F,0xDA,0x5B,0x2C,0xF2,0x27,0xB1,0x3F,0x09,0xDA,0xC7,0x57,0xCE,0xD4,0xF0,0x76,0x59,
  0x83,0x0E,0x8B,0xBD,0x3F,0xE5,0x0A,0xA8,0x9D,0xA9,0x3C,0x8E,0x7B,0xD9,0x60,0x78,0xC5,0xDB,0xF4,0x7B,0x14,0xC9,0xF3,0xC6,0x7E,0x5B,0x2E,0xFB,0x4E,0x48,0xB2,0xAF,
  0x48,0x31,0x4D,0x19,0xD1,0x1B,0x6B,0xE7,0x7F,0x1B,0xA5,0xB6,0xB8,0x8C,0x17,0xE0,0x45,0xDD,0xB7,0x47,0xCC,0x4F,0xE3,0x86,0x69,0xED,0x60,0x0B,0xAE,0xD1,0x80,0x5B,
  0x5D,0x75,0x38,0x18,0xD1,0x0A,0x26,0x95,0xF2,0x30,0xF4,0xAB,0x06,0xC9,0x79,0xA4,0xD8,0x43,0x06,0xB9,0xB5,0xD7,0x0D,0x94,0xE9,0x56,0x4E,0x8F,0xAE,0x77,0x52,0x18,
  0x5E,0x60,0xE1,0x25,0x3C,0xA0,0x12,0x89,0x60,0xE8,0xF6,0x32,0xD9,0x2A,0xCB,0x69,0xDD,0x9C,0x93,0x82,0x4A,0x64,0x76,0x75,0x5F,0x16,0xD7,0xE7,0xD2,0x8A,0xB9,0x94,
  0x27,0x9E,0x05,0x1B,0x78,0xBF,0xA7,0x68,0x5F,0xE0,0x7F,0xD2,0xB2,0xA2,0x3F,0x18,0x1A,0x79,0x5C,0x3B,0xCB,0x6B,0x27,0xA5,0x63,0x01,0x4F,0x94,0x80,0x7B,0x3A,0x77,
  0x2A,0x2B,0x35,0x31,0xDE,0x32,0x5D,0x86,0xFB,0x15,0xBC,0x9F,0xF7,0xA6,0xE9,0xBC,0xF3,0xCB,0x91,0x8C,0xB7,0xEB,0x6E,0xB2,0xD2,0xB8,0x21,0x4F,0x9C,0xB1,0xEC,0x4A,
  0xFD,0x97,0x61,0xFF,0x9E,0xDF,0xA6,0x7F,0xF7,0x56,0xB0,0xDA,0xD4,0xF6,0xCF,0xD8,0x75,0xB2,0x5E,0x9F,0x4A,0xDE,0x1B,0x59,0xF1,0x6F,0x21,0xF9,0xBE,0xBD,0x39,0xCF,
  0x8C,0x79,0xFD,0x9F,0xDF,0x1A,0xDD,0x12,0xB9,0xE0,0xF9,0x1D,0x3E,0xC7,0x8C,0xA2,0x69,0x17,0x86,0xEF,0x9B,0x41,0xE5,0x73,0xB4,0xFA,0xAA,0x3A,0xEA,0xAC,0x48,0xE2,
  0x9C,0x75,0xF5,0xE6,0x74,0xFA,0xD3,0xB7,0xEF,0xE9,0xEF,0x69,0x7A,0x85,0x19,0xF8,0xF1,0xA6,0x29,0x55,0xF0,0x6B,0xBD,0x61,0xD6,0x53,0x26,0xF9,0x8E,0x79,0x0E,0x21,
  0x9A,0xC7,0x51,0xEF,0xA8,0x99,0x98,0x05,0x59,0x9A,0x70,0x32,0x12,0x77,0x19,0x35,0x53,0x3A,0xBC,0xE9,0xFC,0xBD,0x33,0x80,0x0E,0xF2,0xB0,0x4A,0x3D,0x60,0xF3,0x97,
  0x94,0x81,0xF6,0x9B,0xAE,0x96,0x16,0xE6,0xED,0x61,0xA7,0x6E,0x18,0x73,0xCE,0x74,0x7C,0x7E,0xCF,0x56,0xCA,0x70,0xEA,0xA8,0xBD,0xE1,0x2A,0x27,0x80,0x2B,0x69,0x2C,
  0x59,0x56,0x93,0x05,0x89,0xB4,0x4C,0xC2,0xE7,0x5A,0x49,0x50,0xA0,0x5A,0x4E,0xC0,0x36,0xC4,0xDB,0x2C,0x4D,0x94,0xAF,0xD1,0x70,0x90,0x49,0x92,0x59,0xFB,0x04,0xAD,
  0x89,0x89,0xFA,0xF4,0x95,0xEB,0x3C,0x2A,0x67,0xAE,0xF7,0x24,0x35,0xB0,0x21,0xAF,0xDF,0x19,0xF4,0x64,0xD5,0x2F,0x31,0xBE,0x31,0x8D,0x6D,0xA2,0x67,0xD6,0x67,0x93,
  0xDF,0x8C,0xAB,0xD5,0xC4,0x90,0x96,0x29,0x04,0x5F,0x4B,0xF3,0xF8,0x99,0x9F,0xAA,0x7C,0x81,0x7F,0xDA,0xFC,0xBF,0x72,0xFD,0x6B,0x75,0xB5,0x6E,0x57,0x56,0xD7,0xE3,
  0xB4,0xA9,0xB1,0x63,0x93,0x33,0xD8,0x90,0xDF,0x5D,0xAB,0x97,0x7D,0x6F,0x55,0xA7,0x6D,0x1A,0xC3,0x9D,0xEE,0x0C,0x0C,0x27,0x21,0xCB,0x4E,0x85,0x89,0xCF,0x4C,0x29,
  0x80,0x7A,0xDC,0xD8,0xF2,0xC0,0xF8,0x7A,0xA2,0xAA,0xE8,0x0C,0xA7,0x0F,0xF5,0x21,0x15,0xE7,0x79,0xEE,0x33,0xE8,0x90,0x30,0x3F,0x48,0xD2,0x13,0x71,0xDD,0xEE,0xA8,
  0x08,0x57,0xA9,0x77,0x45,0x62,0x06,0xCD,0x4C,0x14,0x35,0xF2,0x4B,0x10,0x47,0xB3,0x4B,0xDB,0x8C,0x70,0xAA,0x34,0xDD,0xF4,0xBB,0x04,0x9A,0x18,0xCC,0x29,0xE6,0x65,
  0xB6,0x30,0x21,0xFA,0x49,0x7B,0x62,0xF8,0x4F,0x35,0x52,0x3A,0x8B,0xD3,0x65,0x71,0xAA,0x70,0x7A,0x5B,0xE8,0x9E,0x81,0x85,0x4E,0x5F,0x07,0x7D,0x55,0xCF,0x2E,0x84,
  0x9A,0xA1,0xE4,0x59,0x3E,0xE1,0xC5,0x31,0x79,0xA2,0x29,0x58,0x3B,0x86,0x47,0x0D,0xDD,0xB8,0xFF,0xFE,0xB7,0x6D,0x56,0x9F,0xED,0xC9,0xF7,0x2D,0xA2,0xB5,0x63,0x1A,
  0x3A,0x82,0x94,0x5B,0x87,0x67,0x99,0xAB,0x95,0x5F,0xDD,0x81,0x2E,0xBD,0xE8,0x38,0x0D,0x6B,0x0F,0x7E,0x36,0x7D,0xF9,0xB7,0x95,0xA0,0x69,0x7D,0x95,0x7A,0x4A,0x0A,
  0xFD,0x6A,0x3A,0x29,0x47,0x5A,0x6F,0x44,0xDB,0x09,0xE6,0x2C,0xF2,0xC9,0x56,0x7E,0x00,0x73,0xCD,0x63,0x37,0x6E,0x7D,0xA1,0x2C,0x95,0x97,0x39,0x08,0x69,0x7D,0x75,
  0x24,0x6D,0x87,0xE7,0x69,0xB6,0xF9,0x40,0x80,0x95,0xD2,0xAA,0xCD,0xC6,0x95,0xB1,0x5C,0xE2,0x56,0xF7,0x80,0x65,0x15,0x30,0x65,0xFE,0xB3,0xEB,0xD5,0xEF,0x71,0x8C,
  0x37,0x1C,0x6A,0xD4,0xB1,0x5C,0xED,0x97,0x06,0xBB,0xBF,0x46,0x5F,0x71,0x7A,0xA7,0x33,0xA2,0x69,0x9B,0xAC,0x2B,0x4A,0xD4,0x43,0xCA,0x0B,0x6C,0x8D,0x7A,0x7A,0x57,
  0x36,0xAA,0xA4,0x94,0x26,0xFB,0x02,0xCB,0x68,0x95,0x6F,0xEE,0x63,0xB3,0xF5,0xC6,0xC7,0x72,0xD8,0x25,0xAE,0xB9,0x38,0x70,0x7B,0xCA,0xA2,0xE5,0x5C,0x91,0xAB,0x83,
  0x57,0x65,0xAE,0x8E,0xF2,0x42,0xDA,0x49,0x87,0x70,0xE8,0x51,0x44,0xFB,0x68,0xB9,0x18,0x93,0x5A,0x8D,0x8A,0x69,0xBD,0x46,0x34,0x9E,0x32,0x49,0x5C,0x2D,0xF3,0x95,
  0x64,0x09,0xB8,0x92,0x90,0x51,0x4E,0xA3,0x54,0xCF,0xAE,0xA7,0x1D,0x5F,0x05,0x3C,0xF9,0x4A,0x16,0x2A,0x68,0x83,0x46,0x34,0xEE,0x76,0xBA,0x36,0xEC,0xC0,0xF4,0x4D,
  0x51,0x4F,0x02,0x53,0xE1,0xB2,0x13,0xB4,0xA2,0xDE,0x09,0x9A,0xF6,0xC6,0xB4,0xF7,0xC5,0xBD,0x13,0xB4,0x7E,0x23,0x9A,0x78,0x4B,0x0B,0xCF,0x7C,0x70,0x2D,0xDB,0x8F,
  0x6B,0xD2,0x96,0xCD,0x16,0x41,0xEB,0xBE,0x15,0xED,0xE4,0xA9,0x8A,0x27,0x68,0x43,0x79,0x9A,0xF0,0xBD,0x5C,0x8D,0x67,0xD7,0xE8,0x7B,0x99,0xA1,0xD8,0x6A,0xB6,0xD8,
  0xF1,0x58,0x43,0x5A,0xA7,0xE5,0x3D,0x9D,0x58,0xAE,0x63,0xAD,0xF8,0x71,0x26,0xDE,0x24,0xF3,0x8C,0x27,0x59,0x3F,0x44,0xAB,0x37,0xE8,0x49,0x47,0xE3,0x75,0xB2,0x7E,
  0x6E,0xE0,0x51,0xFD,0x1D,0x7A,0xA6,0x40,0x26,0x8D,0xA6,0x84,0x99,0x2C,0xA5,0xF6,0xBB,0xDE,0x48,0x93,0x76,0xE2,0x17,0xD2,0xB8,0x44,0xB3,0x45,0x90,0xF8,0xCC,0x5D,
  0x57,0x9C,0x89,0xB0,0xB8,0xC6,0x02,0x2B,0x32,0x24,0xA9,0x7C,0x3B,0xC0,0xBF,0xBE,0x09,0x6E,0xD0,0x57,0xD5,0x02,0xE5,0xA1,0x0A,0x17,0x45,0xAB,0x51,0xDF,0x1B,0x8F,
  0x8D,0x93,0x0C,0x64,0x6A,0xF7,0xF1,0xAB,0xE3,0xDE,0xEF,0xCC,0x29,0xF8,0x5F,0x11,0x42,0x36,0x13,0xE2,0xE0,0x0A,0xF4,0x8A,0xE6,0x5B,0x7F,0xE6,0xFE,0xF3,0x41,0x1C,
  0x1C,0xC4,0x41,0x1E,0xF7,0xBB,0x15,0x07,0x07,0x69,0x10,0x29,0x07,0x17,0xE3,0x9B,0x93,0x7F,0x32,0x3F,0x86,0xD3,0xE4,0x08,0x9C,0xC1,0xF5,0xA1,0x46,0xB4,0x04,0x2E,
  0x78,0xA9,0x0B,0xB7,0x81,0x09,0xDE,0xD2,0x7A,0x99,0xDA,0x7F,0x55,0xB4,0xE3,0xEE,0xEF,0xEE,0x24,0xE8,0xBF,0x44,0xE8,0xFF,0xB7,0x79,0xCD,0x39,0x73,0xF6,0xF0,0x9E,
  0xB3,0xCB,0x79,0xFC,0x75,0x4E,0x5A,0x2B,0xBA,0xFA,0x7B,0x1A,0xF6,0xB1,0x63,0x6D,0xF1,0x26,0xBA,0x63,0x3C,0x91,0x0F,0x5A,0x75,0x76,0xFD,0x21,0x79,0x99,0x92,0xED,
  0x4D,0xC7,0xDD,0xFE,0xA8,0x3B,0xD0,0x70,0xBB,0xEA,0x1C,0xA3,0xC3,0x0A,0xA3,0x6B,0xA2,0x2F,0x52,0x3F,0x57,0xF9,0x66,0xD6,0xEE,0xC2,0xFF,0x13,0x0F,0x13,0x18,0xDE,
  0x83,0xE5,0x93,0x8E,0x4A,0x5A,0xBA,0xAE,0x6A,0x5A,0xEE,0x61,0xA2,0xF9,0x1F,0xEF,0xA1,0xC8,0xD3,0xFA,0xA0,0xE3,0xF2,0x03,0xB5,0xC0,0x36,0x8D,0x2F,0x4D,0xCE,0x49,
  0xC0,0xC0,0x1C,0xA6,0x79,0x29,0x60,0xF1,0x41,0x82,0x87,0x1B,0xE9,0x55,0x78,0x1B,0xC9,0x58,0x9B,0x8A,0x7E,0x25,0xC5,0x6E,0xF5,0x61,0xC8,0x06,0xB9,0xFE,0x15,0x7B,
  0xF6,0x87,0x05,0xB4,0xE9,0xDE,0xFB,0xCC,0x12,0x1B,0x20,0x54,0xAB,0x81,0xB6,0x86,0x83,0x41,0xF7,0x35,0xB4,0x33,0x63,0x65,0xB2,0xC2,0x0F,0x3B,0xEB,0xC9,0x54,0xD4,
  0x6A,0x5C,0x6B,0x38,0xEC,0x8F,0xF2,0x13,0xA9,0x8E,0xA6,0xC6,0x7D,0x03,0x0D,0x8B,0x70,0x6A,0x31,0x1C,0x68,0x23,0x49,0x9A,0x16,0xBF,0x38,0xC9,0x17,0x95,0xEF,0xDC,
  0x60,0x34,0xEA,0x4A,0xE2,0xBA,0x49,0x5C,0xD2,0xAB,0x73,0xEA,0x54,0xE7,0x9A,0xCC,0xE0,0x30,0xB0,0x28,0x26,0xCA,0xE0,0xBA,0x57,0x22,0xB7,0xE5,0xDC,0x58,0x7A,0x26,
  0x9F,0x26,0x12,0xFD,0x65,0xFA,0x7F,0x79,0xEF,0xDA,0xE9,0x55,0xA0,0x6A,0x31,0x0F,0x5F,0x1E,0x45,0xF7,0x17,0xBC,0x81,0xAA,0x0E,0x25,0x47,0x33,0xF1,0xEE,0xBA,0xD1,
  0x54,0xC1,0x3D,0xB6,0x2E,0x0C,0x33,0x39,0x98,0x7D,0x75,0x58,0x2E,0x54,0xDA,0x99,0xA9,0x19,0x03,0xFB,0x02,0xB7,0xD8,0x60,0x70,0xD8,0x3C,0x70,0xE5,0xE6,0x67,0xAB,
  0xAF,0x8F,0xFA,0xF4,0x95,0xD0,0x3F,0x0E,0x79,0xD2,0x24,0x46,0xEB,0x76,0xB2,0xCB,0x4E,0x82,0xB6,0x84,0x65,0x7D,0x6F,0x79,0x78,0xC3,0x88,0xC0,0x62,0x06,0xC7,0xA0,
  0xD3,0xC9,0x6F,0x17,0x7C,0x14,0x13,0x82,0xBA,0x9D,0x3C,0x9E,0x04,0x09,0x6D,0xE0,0x25,0xA3,0x26,0xC7,0x5C,0xBD,0xDE,0xA0,0x33,0x58,0x65,0x6F,0xFB,0xA7,0x2C,0xA9,
  0xC4,0x4A,0xE7,0x38,0x0C,0x5A,0xA9,0x93,0x8E,0x25,0xB8,0x91,0xAE,0xF6,0xF3,0xFD,0xAB,0xB2,0xF2,0x11,0xD6,0x6B,0x08,0xD3,0xFA,0x23,0x95,0x06,0x63,0xB9,0xA2,0xF9,
  0x1D,0x4D,0x0F,0x2D,0x54,0xF9,0x79,0x32,0xEA,0x69,0x5A,0x7E,0x19,0x14,0xCF,0x93,0x70,0x8D,0xE7,0x70,0x62,0xD3,0xE3,0xDF,0x9F,0x6F,0xAC,0x8A,0xCC,0x9A,0x88,0x93,
  0x14,0x61,0x11,0xEE,0x99,0xB7,0xCF,0x62,0x03,0x68,0x2E,0x8C,0x6E,0x77,0x34,0xCA,0xAF,0x82,0x68,0x7D,0xAB,0x11,0x93,0x7F,0xC1,0x62,0x47,0x5C,0x97,0x6A,0x6F,0x47,
  0x34,0x5D,0xD7,0xA4,0xD5,0x86,0xF6,0x80,0x47,0x0A,0x4F,0xF6,0x8F,0xD2,0x42,0x2B,0x0B,0x1C,0xA8,0x7A,0x37,0xAF,0x18,0x55,0xCC,0x94,0xA9,0xB1,0x35,0x3D,0x43,0xB9,
  0x76,0x3F,0x5B,0x4D,0x54,0xC2,0xAC,0x56,0x24,0x05,0x03,0xFD,0x73,0x87,0x19,0x7C,0x68,0x2A,0x5F,0xA7,0x33,0xCC,0x6F,0xE4,0xA8,0x61,0xF6,0x50,0xE1,0xEC,0xF7,0x3B,
  0x5A,0x8F,0xFD,0x55,0x7C,0xD9,0xC6,0x1F,0x84,0x2E,0x94,0x76,0xF7,0xB8,0xD3,0xD7,0x14,0x8D,0x7D,0x6B,0x18,0x3F,0x09,0x17,0xA3,0x78,0xB3,0x79,0x2E,0xBD,0x35,0xC1,
  0x4B,0xCD,0xAE,0xFC,0x70,0x0A,0xE5,0x3D,0x37,0x6D,0xAD,0x0B,0x02,0xBB,0xC7,0x88,0x3E,0xAE,0x85,0x2B,0xC3,0x59,0xD1,0x07,0x7A,0xD8,0x2D,0x98,0xB4,0x69,0x6D,0x37,
  0x54,0xAF,0xC5,0x36,0xCF,0x52,0xBA,0x61,0x26,0x11,0xAE,0x03,0xCE,0x0D,0xF9,0x75,0x82,0xEF,0xB5,0x40,0x89,0x89,0x37,0x42,0x50,0xEA,0x35,0x0D,0xF6,0x4A,0x18,0xEC,
  0x51,0xA7,0xAF,0x77,0xB8,0xA2,0x1F,0x7E,0x19,0xFE,0x10,0x9F,0x0B,0x87,0x7B,0xC0,0xE2,0x4E,0x2C,0x87,0x0F,0xF6,0x3B,0xF5,0x9D,0x72,0xEE,0x06,0xB0,0x53,0x2A,0x8B,
  0x17,0x99,0xD8,0x97,0xD6,0xA8,0x3F,0xEA,0xE4,0x9F,0x26,0xB5,0x78,0xA2,0xD7,0xAC,0x31,0xEB,0x42,0xED,0xA4,0x91,0x5A,0x13,0x64,0x81,0xAD,0x43,0x40,0xF6,0x9A,0x20,
  0xFB,0xAF,0x42,0x62,0xE9,0x3A,0x0A,0x93,0x21,0xF3,0x6A,0x3F,0x15,0x39,0x37,0x1C,0xBF,0xED,0x63,0x15,0xC9,0x7A,0x6C,0x6B,0xD0,0xE9,0x75,0xD4,0x5C,0x4A,0x1E,0xD2,
  0xBB,0x6C,0x84,0x5C,0xBE,0x06,0xA9,0x37,0x42,0x96,0xA8,0x22,0x72,0xC8,0x6E,0x23,0x64,0xAE,0x08,0xBB,0x04,0x72,0xBB,0x6C,0xEC,0xF2,0xEA,0xA8,0xAA,0x96,0x1B,0xD8,
  0x92,0x8D,0x5B,0x44,0x9F,0xB1,0xB2,0xB3,0x8D,0x54,0xA0,0xE1,0x70,0xB4,0xEA,0xA8,0x72,0x34,0x3D,0x8C,0x75,0x63,0x9A,0xC8,0x99,0x6D,0xF8,0x44,0x27,0x5B,0x6B,0x3F,
  0x52,0x87,0x92,0xDA,0x5D,0x5B,0x24,0xB2,0x48,0xE1,0xB0,0x48,0x99,0xE3,0x4F,0x6D,0x13,0x04,0x30,0x37,0x5A,0xC3,0x9C,0xB3,0x13,0xC3,0xCF,0xBD,0x4A,0x8E,0x5B,0x49,
  0xEA,0x40,0x02,0x87,0x27,0xFE,0x4B,0xA2,0xF6,0x23,0x70,0x1A,0xA8,0xCA,0xB2,0x96,0x80,0x18,0xCB,0x3D,0x45,0xF9,0x4F,0xD3,0xF4,0x61,0x91,0xC6,0x55,0xD2,0xB9,0x1E,
  0x5A,0xE1,0x25,0x01,0xD1,0xBC,0xBC,0x6F,0x43,0xBB,0x7C,0xA8,0x0D,0x49,0xAA,0x8A,0xA8,0x25,0x2C,0x0A,0x3C,0x1A,0x9E,0x1D,0x55,0x83,0x30,0x5E,0x6A,0x0C,0x66,0x0E,
  0xBB,0x93,0x7A,0x9D,0x1D,0x11,0x7C,0x7D,0x62,0x39,0x8E,0xD9,0xF0,0x0A,0x44,0x5F,0xEB,0xF5,0x0B,0xF4,0x91,0x63,0xB0,0xF7,0xBA,0x9D,0x2E,0xD3,0x84,0x62,0x9D,0xA8,
  0x3B,0xEA,0x0C,0xD5,0x2E,0x6E,0xD7,0x43,0x15,0x6C,0x34,0xB6,0x73,0xAB,0xF0,0xBD,0xCE,0x08,0x7F,0xAA,0xF6,0x7B,0x5A,0x57,0xE8,0x4E,0xF0,0x29,0x90,0x29,0xF0,0xBB,
  0xCA,0x40,0x69,0xE3,0x7B,0x41,0x1F,0xDA,0xC9,0x8B,0x63,0x6C,0x79,0xE1,0x7B,0xB0,0x75,0x7D,0x65,0xB2,0x97,0xB6,0xB0,0x99,0x53,0x2B,0xFF,0x0E,0x18,0x2A,0xA9,0xC1,
  0x31,0x65,0x26,0xA5,0xD1,0xF5,0xB8,0x26,0x35,0x54,0xDA,0xA3,0x92,0xA9,0x71,0x6A,0x9B,0xAB,0x00,0x0C,0x0F,0xE5,0x7C,0x6F,0x81,0x09,0x49,0x52,0x2C,0x47,0x7A,0xAF,
  0x5F,0xA4,0x5F,0x14,0xA9,0x73,0xDC,0x93,0x9E,0xA1,0x1D,0x85,0xF9,0x74,0x31,0xC3,0xA7,0xF3,0xE8,0x87,0x29,0x1C,0x27,0xEE,0xFA,0x25,0x6F,0xEE,0x20,0x2D,0x37,0x37,
  0x48,0x34,0x91,0x41,0x22,0x84,0x9D,0x3C,0xB1,0x18,0x31,0x36,0x3D,0x33,0xC1,0xCA,0x21,0x4D,0x93,0xA6,0x01,0xEF,0xCC,0x7A,0xC4,0x8A,0x24,0x53,0x7B,0x4F,0xDF,0x1A,
  0x5A,0xFD,0x4E,0xBF,0x27,0xE9,0x6E,0xE3,0x92,0xE5,0xCC,0x75,0xD7,0xCA,0x78,0xB7,0x6B,0x60,0xF1,0xB4,0x74,0xBD,0xD3,0xCB,0x9B,0xC5,0x38,0x6F,0x07,0x6A,0x7F,0x80,
  0x13,0x47,0xED,0x75,0xF4,0x21,0x9F,0x4F,0xE1,0xD7,0xD1,0x4F,0xC3,0x27,0x81,0x19,0xAE,0x27,0x9E,0x65,0x62,0x38,0x0D,0xEE,0x7D,0xE0,0xB3,0x0C,0x8B,0x54,0xC6,0xC8,
  0xAA,0xCC,0x49,0x18,0x46,0x9B,0x1A,0x60,0xC2,0x92,0x63,0x0D,0xD0,0xFF,0x3D,0x90,0x34,0xF3,0xDA,0xBD,0x1C,0x0E,0x13,0xD7,0x53,0xDD,0xED,0x43,0x5D,0x0E,0x27,0x4C,
  0xF4,0x24,0x8D,0xBB,0x02,0x58,0x64,0xE8,0x27,0x1E,0x92,0x77,0x65,0x1A,0x9F,0x4B,0xE3,0xB1,0x79,0xE7,0x56,0xD9,0x49,0x5B,0x4C,0xCB,0xF7,0x2D,0x11,0xF9,0x57,0x89,
  0xC9,0xD0,0x64,0x84,0x75,0x8A,0xB6,0x31,0x3D,0x2F,0xB7,0xBC,0x6B,0x47,0x12,0x4C,0xA3,0xBE,0xAC,0xAB,0x5D,0x55,0x13,0x38,0xCF,0xB5,0x7C,0xDF,0xA8,0x0F,0x2E,0xCF,
  0x75,0x4E,0x2B,0x33,0x64,0x50,0xC6,0xAA,0x23,0xB5,0xA7,0x71,0x19,0x3B,0xD0,0x7B,0xE8,0x7F,0x88,0xBE,0x50,0xA2,0x1F,0x83,0x64,0x68,0xC3,0x4E,0x81,0xC2,0x97,0x3F,
  0xCC,0x19,0x2B,0x75,0x00,0xAF,0xD4,0x34,0x28,0x97,0x84,0xBA,0x39,0xD7,0x84,0x58,0x22,0x9D,0x63,0x6D,0xA4,0xE9,0x78,0x48,0x74,0x3C,0xEA,0x81,0x11,0xD9,0x8B,0x17,
  0x4C,0xF8,0x8D,0xE8,0x57,0xD0,0xBB,0x0B,0x3F,0xE8,0x85,0xCF,0x82,0xF5,0xD6,0xA7,0xF0,0x20,0x5B,0x50,0xB1,0xE4,0x4F,0xF5,0xD8,0xC0,0xC8,0x2A,0x78,0x89,0x19,0x7D,
  0xE7,0xEE,0x7C,0x0C,0xD5,0x21,0xAA,0x93,0x7A,0x47,0x2B,0x38,0xAE,0xAA,0x52,0xB8,0x18,0x6D,0x6E,0xEC,0x7D,0xE3,0x91,0xEE,0x2D,0xD0,0x3B,0x83,0x82,0x7D,0xB6,0x4E,
  0x14,0x2D,0xF6,0xDE,0x93,0xF9,0x82,0x77,0xE1,0x89,0xB2,0xA1,0xD3,0x2B,0xB2,0x22,0x51,0xC3,0x60,0x9A,0x84,0x3A,0xE8,0xB2,0xBF,0xB2,0xFF,0xB2,0x6F,0x8A,0x2D,0x67,
  0xC4,0xBC,0x23,0x6D,0x15,0x1F,0xC0,0x7B,0xD9,0x19,0xCD,0x72,0x76,0xE1,0xBD,0x94,0x82,0xA3,0xB9,0xE4,0xB0,0x46,0x4E,0x20,0x06,0xC4,0x0E,0x9F,0xBB,0x4B,0x9B,0x70,
  0xF7,0x25,0xC5,0xD3,0xF4,0xAE,0x2E,0xAB,0xCF,0x6A,0xFD,0xD2,0xEB,0x7D,0xFC,0x11,0xA2,0x64,0x11,0x3C,0x08,0xDA,0x94,0x72,0x34,0x62,0x34,0x8F,0xB4,0x4A,0x1D,0x3E,
  0x42,0xEB,0x7C,0xEF,0x80,0x71,0x62,0x39,0x81,0xCD,0x72,0x08,0x59,0x7E,0xE0,0xCA,0x7A,0x85,0xC1,0x62,0xE8,0x17,0x2C,0xDD,0x2A,0x5B,0x0F,0x69,0x57,0x60,0xEB,0x78,
  0x34,0x12,0xA3,0xE1,0xA9,0x96,0xE4,0x76,0xD3,0xEE,0xC6,0x34,0xBC,0x4B,0xC8,0x8A,0xD8,0x92,0x8C,0x84,0x56,0x6F,0x90,0x33,0x50,0xEA,0x4E,0x08,0x11,0x77,0xBD,0x27,
  0x5D,0x9F,0x8A,0x70,0x30,0x94,0x6A,0xD1,0x74,0xED,0x1C,0x0F,0x3A,0x83,0xF0,0xDF,0xE2,0xBF,0x6D,0xF1,0x9F,0xC8,0x72,0xEF,0x1D,0x83,0x1D,0xAF,0xEB,0xC7,0x83,0xE8,
  0x31,0x66,0xE6,0x67,0xD7,0x6E,0x70,0x35,0x0E,0xEF,0xA8,0xD2,0x44,0x12,0xA3,0x59,0x0F,0x4D,0x5C,0xD3,0xCC,0x53,0x5C,0xA0,0xA9,0x29,0x85,0x2E,0xD3,0x61,0x84,0x9B,
  0x9B,0x5B,0xCB,0xD8,0x07,0xEE,0xD6,0x08,0xB0,0x74,0x90,0xEC,0x44,0xE2,0x67,0x41,0x39,0x37,0x53,0xED,0x2B,0x65,0x65,0xAD,0x30,0xA3,0x0A,0x6D,0x16,0xB5,0x7A,0x43,
  0x4D,0xFA,0xFC,0x5C,0x4F,0xD1,0x58,0x85,0x16,0x41,0x53,0x4E,0xA6,0x6D,0x75,0x50,0xEF,0xB6,0x63,0x37,0xA7,0x25,0x3B,0xA7,0x47,0xF7,0xF0,0x96,0xDE,0x9E,0x16,0x63,
  0x21,0x68,0xFA,0xB0,0x27,0x7B,0x82,0xA1,0xC1,0xB4,0x14,0x2F,0x8F,0x05,0x37,0x9D,0x35,0x92,0xE8,0x68,0xB3,0xF4,0x24,0x57,0xBF,0x16,0xC3,0x16,0xDE,0x1E,0xA4,0xDA,
  0x0F,0xEC,0xFD,0xAD,0xF6,0x41,0xFD,0x6D,0x2E,0x0E,0xD3,0xBA,0xA3,0x5E,0xC6,0xAF,0x54,0xE2,0x59,0xD7,0xB8,0xDB,0xAC,0x37,0x14,0xC4,0xD5,0xFE,0xE1,0xA1,0x81,0x2B,
  0x0B,0x5E,0x5F,0x77,0x28,0xB5,0xF0,0x60,0xAB,0x52,0xFB,0xA0,0x4F,0x33,0x9E,0xB7,0x73,0x2B,0x6F,0xEF,0x97,0xF3,0x7A,0x83,0xAE,0xAC,0xC6,0xA9,0x89,0x97,0x87,0x15,
  0x30,0xF9,0x9D,0xC9,0xE4,0x01,0x09,0xB3,0x37,0x6B,0x92,0x0C,0xC1,0x52,0xD0,0xA5,0xF5,0x5B,0x4D,0x8E,0x06,0xDF,0xD8,0xEE,0x6C,0xEB,0xC1,0xCA,0xDD,0x48,0x07,0x6B,
  0x33,0x77,0x30,0x52,0x43,0x43,0x75,0x71,0xDC,0x24,0x02,0x48,0x1C,0x8B,0x48,0x4E,0x4C,0x7E,0x90,0x87,0x89,0xA6,0x37,0xC6,0x76,0xDB,0xC0,0x69,0xC5,0x54,0xC6,0x22,
  0x67,0x89,0xAE,0x71,0xDD,0x7C,0xD4,0xED,0x33,0x0D,0x7E,0xC4,0xFC,0x36,0x7A,0x67,0x84,0x3F,0x53,0xB9,0x9E,0x8C,0xDF,0x19,0xF5,0xF0,0x2F,0x6A,0x87,0xAD,0x4B,0x76,
  0xEA,0x05,0xFF,0x56,0x51,0xD7,0xFA,0xC9,0xB1,0x1E,0x9A,0x1E,0x2F,0xEA,0x99,0x77,0x5B,0x31,0x04,0x5C,0xAC,0x5E,0x19,0xF2,0x01,0x18,0x59,0x58,0x57,0xCF,0xE1,0xCA,
  0x05,0x5D,0x3F,0xBA,0x27,0x0B,0x9B,0x54,0x93,0x08,0x02,0x0C,0x6E,0xE9,0x16,0x45,0x2C,0x14,0xE9,0x91,0xB0,0x30,0xDB,0x9A,0xCA,0x80,0x79,0xAF,0x8B,0x2C,0x10,0xE3,
  0xDB,0x65,0xD5,0x1C,0xAD,0x54,0x8F,0x64,0x4F,0xE0,0x1B,0x4B,0xD8,0x40,0xA6,0x1B,0xCF,0xDD,0x9A,0xA1,0x37,0x0A,0xB3,0x1C,0xB0,0xB5,0x74,0x5B,0x9A,0x05,0xAF,0x37,
  0x18,0x4C,0xCA,0xA5,0x5F,0xE1,0x3E,0x59,0x81,0xD3,0x18,0xCE,0x2F,0xE5,0x09,0x5C,0x36,0x49,0xAB,0x2C,0xEE,0xC2,0x0A,0x6B,0xA4,0x63,0x58,0x81,0xBB,0xAD,0x7B,0xCF,
  0x0C,0x27,0xAD,0x25,0x77,0x84,0x96,0xCC,0xB5,0xC8,0x46,0x01,0x06,0xB0,0x73,0x69,0x7A,0x91,0x3F,0x6A,0xD4,0xC7,0x35,0x8B,0x66,0x6E,0x6F,0x14,0x92,0xC5,0xD7,0xFC,
  0x87,0x4A,0x6C,0xED,0x5F,0xB9,0xFB,0xF5,0xC6,0xB0,0xEC,0x26,0x32,0x03,0x0C,0x6C,0x79,0x4F,0x3B,0x5F,0x30,0x61,0x2E,0x3F,0x54,0x48,0x78,0x72,0x30,0x6F,0xBF,0x55,
  0xAE,0x8D,0x47,0xE3,0xDF,0x56,0x8D,0x39,0xCD,0xB5,0x2C,0xD9,0x03,0xA0,0x10,0xF7,0x08,0x8A,0xDC,0x7D,0x93,0x40,0x6B,0xD8,0x38,0xB5,0xAE,0x64,0xEF,0x44,0x82,0x37,
  0xC3,0x33,0x56,0x46,0xB3,0xE3,0xA6,0x51,0xA7,0xD7,0x21,0x9D,0x17,0x08,0x58,0xD2,0xFD,0x34,0x71,0x3D,0xA9,0x8C,0x3F,0x1C,0x46,0x38,0x2F,0x68,0x5D,0x9B,0x81,0x61,
  0x2B,0x27,0x66,0x60,0xAE,0x02,0x42,0xB6,0x52,0x06,0xEB,0x76,0x07,0xF2,0xB6,0x23,0xB7,0xAE,0xAE,0xAD,0x95,0xE7,0xB2,0xFA,0x93,0xF4,0xB7,0x36,0xEA,0xE8,0xD9,0xC3,
  0xA6,0x9A,0xA8,0xB3,0x98,0xC6,0x07,0x93,0x75,0xD6,0x86,0x69,0x23,0x04,0x4D,0x85,0xF3,0x92,0xD3,0x24,0x83,0x89,0x04,0x6D,0xDF,0x24,0xDA,0x8C,0xD3,0xD0,0xF5,0x21,
  0x1B,0xEC,0xA9,0x6A,0xFC,0x64,0xAB,0x75,0xB7,0x81,0x99,0xE2,0x62,0xBE,0xB8,0x79,0x60,0x3C,0x3C,0x88,0x08,0x5A,0x96,0x70,0x07,0x03,0x3F,0xAB,0x1E,0x06,0x05,0x4C,
  0x56,0x1B,0x2F,0x37,0x8C,0xCB,0xB7,0x8C,0x3B,0xC3,0x72,0xC0,0xC8,0x69,0x62,0x11,0x30,0xED,0x5C,0xF2,0x11,0xC4,0x9A,0x4F,0xD0,0x94,0xE7,0xE3,0xF0,0x2D,0xA2,0xF0,
  0x3E,0x12,0x0B,0x65,0x51,0x16,0xD0,0xCB,0x69,0x72,0x2B,0x23,0x45,0xBB,0x33,0x1A,0x24,0xC4,0x61,0x34,0x52,0x98,0x5D,0x0A,0x16,0x96,0x5D,0xC3,0x6F,0x9D,0xC0,0x0C,
  0xAE,0xAB,0x92,0x87,0x30,0xCA,0xA2,0xE7,0x2D,0xCF,0x5C,0xDB,0xC6,0xA4,0xB7,0x6C,0x38,0x65,0xE3,0x5B,0x5B,0xAA,0x36,0x1C,0xCA,0xD6,0x2E,0x18,0x8A,0x9D,0xF0,0x0E,
  0x83,0xB9,0xDF,0x2B,0xF3,0x1D,0x1E,0x62,0x9F,0xDA,0x3C,0x09,0x75,0xC9,0x9A,0xBC,0x48,0x7B,0x82,0x71,0x1D,0x8E,0x68,0x9D,0xAB,0x80,0x9D,0xD9,0x46,0x50,0x02,0x4A,
  0xC2,0x64,0xCE,0x0B,0x42,0xD8,0xCE,0x14,0xF5,0x7A,0xC9,0xF3,0xBF,0xAB,0x17,0x79,0x1B,0x2B,0x61,0xC1,0x6A,0xF3,0x00,0xEB,0xBB,0x81,0x86,0xD8,0xED,0x8E,0x0A,0x4E,
  0x76,0x4B,0x05,0x0C,0xC3,0xB9,0x18,0x74,0xB0,0x85,0xA9,0x61,0x83,0xD2,0x44,0xDA,0x66,0x71,0x87,0x95,0xF5,0x6C,0xF2,0xBE,0xCD,0x8C,0xB5,0x25,0x0A,0x5C,0x30,0xBD,
  0x89,0x10,0x6F,0xDD,0xD2,0x47,0xFD,0x4C,0xF4,0x88,0x52,0x1A,0x88,0x29,0x7C,0x8A,0x09,0x1C,0xF7,0xD3,0xC8,0xF3,0x18,0xCE,0x20,0xE2,0xD0,0x02,0x25,0x64,0x0A,0x4B,
  0xE2,0x54,0xB0,0xBC,0x64,0xC3,0x9F,0x99,0x5F,0x9A,0x5F,0x51,0x61,0x48,0x1E,0x4B,0x2E,0xEA,0xC6,0x49,0xA3,0xD9,0x2D,0x8E,0x22,0xB7,0x7F,0x78,0xD6,0xD3,0x17,0x37,
  0x3B,0x93,0x27,0xEE,0xC2,0xB6,0x68,0x6B,0xBD,0x42,0xB8,0xD0,0x66,0x58,0x15,0x08,0x03,0x2F,0x25,0xB0,0xEA,0x72,0x9E,0xB1,0xCC,0x8A,0x36,0x0E,0x2F,0x38,0xD6,0x7E,
  0x6B,0xF8,0xB5,0xE1,0x04,0x86,0x32,0x33,0x92,0x95,0x6A,0x43,0x78,0xEF,0x6B,0xC3,0xE7,0x1B,0x96,0x91,0x25,0xD5,0xF5,0x10,0xAE,0x7F,0x75,0xF8,0x6F,0x7B,0x2B,0x5B,
  0xDA,0x2C,0x84,0x77,0xBF,0x36,0x3C,0xFA,0x61,0x82,0x1F,0xC2,0xFB,0x5F,0x1D,0xBE,0xF7,0x82,0x6C,0x46,0x77,0x0E,0xDF,0xE5,0x23,0x1B,0xE4,0xE1,0x78,0x0A,0xC2,0x96,
  0x37,0xFC,0xEB,0xDC,0xDC,0xF2,0x5B,0x4C,0x81,0x4C,0xDA,0x43,0x96,0x4E,0x52,0xD6,0x72,0xE7,0x6A,0xE6,0xDC,0xD8,0xAF,0xCC,0x66,0x47,0x5C,0x78,0xC0,0x55,0x18,0xB2,
  0x9E,0x77,0x4C,0xF4,0x23,0x95,0x7D,0x6E,0x7E,0x09,0xA8,0xA7,0xC5,0xC9,0xDE,0xC9,0x06,0xC4,0xB4,0xF5,0x1E,0xE7,0xF1,0x52,0xEA,0x13,0xCF,0x35,0xD6,0x42,0x42,0xE3,
  0x65,0xB0,0x75,0x68,0xAB,0x33,0xC1,0xB1,0x0F,0x30,0x4D,0xF9,0xD4,0xF5,0x9C,0x54,0xD2,0x1D,0xB5,0xD3,0x29,0xF0,0xE2,0x71,0x5E,0xFA,0xF6,0x0D,0x0F,0x5C,0x2C,0x00,
  0x1E,0xA7,0x71,0x47,0x69,0xD6,0x11,0xDB,0x28,0xE2,0x09,0xC4,0x89,0x29,0x69,0x25,0x0D,0x8C,0xB3,0xCA,0x45,0x89,0xDF,0xEA,0x5D,0xF6,0xDD,0x61,0xB7,0x20,0xA0,0xBA,
  0x10,0x18,0x79,0x2A,0x0B,0x79,0xD8,0xA7,0x7A,0x24,0x6C,0xE4,0xC3,0x6C,0x48,0x58,0x33,0x1E,0xA6,0x74,0xB5,0x6D,0x65,0xFE,0xB4,0x87,0x7F,0x87,0x29,0xA9,0x72,0x95,
  0x92,0x39,0xEF,0x2E,0xE5,0x3D,0x93,0xE6,0x7D,0x26,0xDC,0x4D,0x09,0xFB,0x37,0xD2,0x8A,0x2E,0x2C,0x4A,0xBE,0xC0,0xCF,0xD1,0xBB,0x63,0xD5,0x14,0x1E,0x0D,0x5E,0xCC,
  0xC5,0xB5,0x15,0xFE,0x1B,0x05,0x4F,0xC3,0x81,0x39,0xBB,0x52,0x16,0xE8,0x5A,0x54,0x77,0x07,0xA6,0x35,0x2E,0x8A,0xE9,0x93,0x07,0x0A,0xFF,0xD5,0xD6,0xC4,0xEB,0x38,
  0x58,0x2A,0x6E,0x6D,0x19,0x15,0xE5,0x1C,0x19,0x10,0xEB,0x9F,0xA7,0x7D,0x73,0x64,0xE0,0xC4,0x08,0x6C,0x57,0xA6,0x04,0x27,0x07,0x76,0xB3,0x55,0x7E,0xE8,0x40,0x4C,
  0x0B,0x75,0xE2,0xE1,0x9C,0xAD,0xA9,0xE0,0xC8,0x81,0xD3,0x57,0x03,0x71,0x29,0xB0,0x22,0x8A,0x75,0x05,0x2A,0x39,0x30,0x5B,0x99,0x9C,0x0C,0x4C,0xE5,0x83,0x7B,0x7F,
  0x2D,0xEA,0x95,0x2B,0x3F,0xEF,0x0D,0x0F,0xF0,0x09,0x2B,0x53,0x00,0x7F,0x7C,0x2D,0xF0,0xE4,0x89,0x9B,0xE5,0x62,0x54,0xB1,0xB4,0xD2,0xFA,0xE4,0xE9,0xCC,0x36,0xFD,
  0xCD,0xFB,0x45,0x72,0x12,0x09,0xE0,0x4F,0xAF,0x05,0xE2,0x7E,0x8F,0xE1,0x5A,0x96,0xDC,0x3B,0xBC,0xC8,0x66,0xBA,0x6B,0x04,0xE4,0x38,0x91,0x32,0x8D,0x07,0x6C,0x96,
  0x0E,0xE9,0xD5,0xAB,0x81,0xC9,0x01,0xAD,0x74,0x0B,0x70,0xE0,0xE4,0xB5,0xB3,0x14,0xD7,0xFB,0xA3,0xAB,0x5C,0xFA,0xB6,0xC1,0x8A,0x34,0x96,0x42,0x39,0x50,0xCF,0x56,
  0x30,0x22,0x03,0x67,0xEE,0x0B,0xC8,0xD5,0x9F,0x1C,0xE6,0xAF,0xAF,0x7A,0x95,0xA2,0x87,0xD9,0x32,0x30,0x64,0x60,0x18,0x73,0x5B,0xBD,0x35,0xC5,0xC0,0x8B,0xD7,0xBE,
  0xC3,0x10,0x88,0xC9,0x13,0x24,0xDE,0xE1,0x45,0x36,0xAF,0x1F,0x1D,0x18,0xEE,0x4F,0x7E,0xB8,0x41,0x95,0xDD,0xA1,0x64,0xC0,0x79,0xB3,0x65,0x31,0x73,0xF7,0x64,0x6F,
  0x7C,0x4B,0x1F,0x0E,0x4A,0xB7,0xA7,0x9C,0x8A,0xA8,0x6A,0x39,0x1E,0x9E,0xB0,0x10,0x12,0x8C,0xB7,0x06,0xBD,0x51,0x27,0xEF,0x75,0xAC,0xEE,0x60,0x71,0xC5,0xA6,0xDC,
  0x43,0xC4,0x52,0xDD,0x37,0x5F,0xC2,0x23,0xE8,0xA0,0xA0,0x04,0x37,0x7F,0x88,0x92,0x60,0xEA,0xF2,0x87,0x28,0x45,0x86,0x62,0x96,0x15,0x74,0x76,0xD9,0x6F,0x6C,0x32,
  0x06,0x42,0x88,0x6C,0xA4,0x77,0x70,0x20,0x3A,0xCF,0xE4,0xDF,0x2E,0x3B,0x93,0x94,0x0B,0xD4,0xC1,0x8B,0x28,0x85,0xAF,0x96,0xB9,0xEB,0xA4,0x97,0x28,0x27,0xE2,0xF2,
  0xAC,0x0D,0x51,0x2F,0x20,0xCE,0x57,0x86,0x67,0x10,0xC3,0xD4,0x99,0x17,0xBD,0xAC,0x8F,0xD9,0x41,0x1D,0xF1,0x9B,0x53,0x31,0x91,0x5B,0xAA,0x78,0xB3,0x92,0x30,0xAA,
  0xFA,0xB0,0xDB,0x74,0xB9,0xC4,0x3C,0x79,0x05,0x8B,0xF1,0xB0,0x0E,0x5F,0x91,0x88,0xA5,0xF2,0xD8,0x65,0x83,0x33,0xC3,0x5E,0x85,0x39,0x3F,0xF9,0xB1,0x56,0xEA,0x1D,
  0x72,0x5E,0xB6,0xB6,0xD8,0xEB,0x79,0x61,0xE9,0xF3,0x0C,0x51,0xF0,0xFA,0x6F,0xC3,0xAB,0xD7,0x1F,0x05,0x6F,0xF5,0x66,0xBC,0x50,0xF5,0x08,0xFB,0x07,0x5D,0x7E,0xF4,
  0x62,0x39,0x2C,0x78,0x8F,0x6F,0xC1,0xAB,0xD1,0x1E,0x5B,0x11,0x0F,0x15,0xC7,0xB7,0xE6,0xB5,0x8B,0xB3,0x17,0x33,0xDE,0x3A,0x17,0x77,0xF0,0x3A,0x5E,0x45,0xFE,0x62,
  0xC1,0x7B,0x93,0xF9,0x59,0xAB,0x14,0xC7,0xE3,0xF9,0xD3,0x5B,0xF0,0xCE,0x5C,0xCF,0xF4,0x83,0x6D,0x95,0xED,0x16,0xCE,0x97,0xE1,0x6B,0x79,0xC7,0x95,0x8A,0xF1,0x31,
  0x7B,0x82,0xE3,0x56,0xD4,0xBF,0xAB,0xB7,0xE8,0x9F,0x4C,0x46,0x68,0xF1,0xFE,0xB2,0x95,0x28,0xDF,0x94,0xC7,0x72,0x42,0x1B,0x2F,0xF1,0xFB,0x5B,0x77,0xDE,0x44,0xBE,
  0xB0,0xC1,0x44,0x73,0xF1,0x88,0x2F,0xBC,0xEF,0xC3,0xFE,0xE5,0xE5,0xA7,0xF9,0x16,0xBC,0x6B,0xC3,0x73,0x5D,0xE7,0x3D,0xEE,0xB2,0x79,0x73,0x26,0x3D,0x5F,0xF6,0x6F,
  0xC1,0x43,0x10,0xD3,0x60,0xBC,0xD8,0x27,0x2F,0xBA,0x7A,0xE6,0x19,0x5B,0x33,0xD1,0xBF,0xC1,0x5B,0xF1,0x78,0xB6,0x6B,0x96,0x3F,0xCF,0xB4,0xB7,0xF9,0x20,0x6C,0xCE,
  0x7B,0x1B,0xF9,0x82,0x8B,0xE0,0xCE,0x34,0x56,0x9B,0xF2,0xE1,0x0C,0xFB,0x17,0xBC,0x09,0x4F,0xC2,0x8E,0x12,0xBC,0xF5,0x5B,0xF0,0x64,0xB2,0x96,0x8B,0xF5,0x90,0x0D,
  0xDC,0x6A,0xC6,0x73,0xED,0x07,0x56,0x5E,0xA5,0x42,0x81,0x11,0xFD,0xEB,0xBE,0x05,0x4F,0xAC,0xB6,0x50,0xA6,0x71,0x0D,0xA6,0x78,0xBF,0xDD,0xBC,0x21,0xAF,0x32,0x53,
  0xBA,0x18,0xCF,0xB7,0xEC,0x5F,0x65,0xAE,0x74,0xC1,0xA3,0xAE,0x3F,0xF7,0xB3,0x49,0x76,0xCD,0x86,0xE3,0x29,0x1F,0xB9,0x19,0xE2,0xAC,0x47,0x74,0x3A,0x5F,0xB8,0xD4,
  0x2A,0x69,0xEC,0x6C,0x37,0x9B,0x6A,0x2A,0x89,0x4B,0x9C,0xF0,0x2A,0x3C,0x52,0xB4,0xAD,0x65,0x81,0xA9,0xBD,0xC1,0xF2,0x30,0x19,0x33,0x0C,0x24,0x5F,0x1B,0x79,0x8D,
  0x82,0x01,0xF3,0xFA,0x4B,0x1D,0xF0,0xC9,0x52,0xEE,0x6A,0xAB,0xC2,0x16,0xF7,0x70,0xD4,0xE9,0x15,0xC4,0xA6,0x16,0x0F,0xA8,0x38,0x70,0xB2,0xCD,0xF5,0xA3,0xD9,0x28,
  0xFA,0x98,0x59,0x9D,0xD2,0x07,0x40,0xAA,0x38,0x70,0x82,0x45,0x6D,0xA2,0x3D,0xC6,0xEE,0xB1,0x2F,0x5C,0xC2,0x8D,0x1F,0x4C,0xED,0xA3,0xCB,0xE6,0x41,0x53,0xD1,0x22,
  0xE3,0x40,0x93,0x76,0xD1,0x3B,0x01,0xEC,0x76,0x47,0xD2,0xF3,0x53,0xE4,0xD3,0xE1,0x91,0x29,0x42,0x25,0xC3,0xA2,0x77,0x18,0x59,0xCB,0xF2,0x00,0xD4,0xD7,0x2B,0xEB,
  0xE6,0x53,0x20,0x94,0xF7,0xAF,0xDB,0x8D,0x79,0x8F,0xFB,0x46,0x07,0x86,0x98,0x2A,0x49,0x3A,0x83,0x17,0xBF,0x22,0x32,0x0F,0x4C,0xE3,0x89,0x09,0x2B,0x72,0x94,0x5F,
  0x6B,0x04,0xAB,0x5D,0x36,0x2A,0x4D,0xCB,0xD3,0xE2,0x7D,0xFD,0xDA,0xAC,0xF7,0x55,0x70,0x9A,0x5C,0x68,0x51,0x44,0x33,0x82,0x7D,0xC3,0xFA,0x68,0x18,0x5B,0x24,0x3D,
  0x94,0x9C,0xB6,0xB7,0x82,0x55,0x41,0x92,0x0F,0x19,0x5A,0xB7,0x5B,0x14,0xC0,0x2B,0x24,0x4A,0xDA,0x33,0xC1,0xBE,0xFE,0x2E,0xAC,0x8A,0x33,0xDD,0x07,0x36,0x39,0xB3,
  0x0A,0xA6,0x11,0x96,0xCE,0x03,0xA2,0x25,0x68,0xAC,0x76,0xBD,0x8F,0x5F,0x12,0x80,0xAD,0x6C,0x5E,0x80,0x0A,0x5A,0xB2,0x6B,0x3F,0x19,0x81,0xE1,0x18,0x2C,0x05,0x0E,
  0xFC,0xF0,0x87,0xDB,0x55,0xE0,0xF2,0xF3,0xC9,0x73,0xD0,0xC7,0xD6,0x25,0xF7,0x7C,0x58,0xA1,0x4E,0x5D,0xEE,0x92,0x54,0xBF,0x04,0xA6,0x29,0x3F,0xCC,0x7F,0x03,0x86,
  0x59,0x49,0x8A,0x60,0x72,0x81,0xD0,0x29,0xD8,0xC6,0xDD,0x99,0xD4,0x10,0x4C,0xF4,0x5E,0x11,0x93,0xB5,0x72,0x1A,0x06,0x68,0x51,0xDF,0x19,0x5F,0x6D,0xC4,0x8D,0x87,
  0xD1,0x66,0xC6,0xCE,0xA2,0x6F,0x3C,0x18,0x13,0x49,0xBB,0x95,0x2D,0x68,0x2E,0x1A,0xC8,0xE7,0x20,0x8D,0xAD,0xBD,0xF4,0x22,0x68,0x8D,0x7A,0xFD,0x01,0x31,0x8A,0x83,
  0x97,0xA0,0x62,0xD7,0x11,0xE2,0x6C,0xFF,0x77,0x2E,0x6C,0xB2,0x75,0xDB,0x1D,0xFA,0x39,0xE5,0x13,0xD1,0x26,0x69,0x2B,0x6B,0x4B,0xCD,0x69,0xC2,0xB6,0x9C,0xA1,0x74,
  0x9E,0x81,0x61,0xB9,0xBB,0x3C,0xF5,0x08,0xBC,0xCF,0x3F,0x62,0x66,0x9C,0xB5,0x72,0xBA,0xAE,0xBE,0x99,0xCE,0x6A,0x82,0x52,0x52,0x11,0xC6,0x38,0x8C,0xED,0x23,0x8B,
  0x17,0xD0,0x71,0xC9,0x3A,0x27,0xC3,0x7D,0xF0,0xF6,0x4F,0xED,0x0B,0x6A,0x25,0x60,0xB5,0xD3,0x29,0x98,0xAA,0x85,0xF7,0x22,0xC3,0x44,0x2E,0xA2,0x77,0xEC,0xDF,0xFC,
  0x74,0x5E,0x28,0xF2,0x78,0xB3,0xA5,0x9A,0xCE,0x22,0x48,0x8A,0x12,0x39,0x24,0x74,0xCD,0x84,0x4A,0x26,0xE4,0xE7,0x0B,0xDE,0xA1,0x6B,0x76,0xD7,0x6D,0x38,0x18,0x15,
  0x64,0x5B,0xAC,0x10,0xD6,0x0B,0xD3,0x36,0xFD,0x95,0xDB,0xA4,0x9A,0x65,0xAB,0xDF,0xED,0x77,0xA5,0xE3,0xE8,0x55,0x81,0x73,0x1C,0xCB,0x07,0x31,0xB3,0x22,0x5F,0xC2,
  0x46,0x09,0xAA,0xE6,0xA3,0x63,0x8A,0x71,0x7A,0xE9,0xD2,0x58,0x80,0xCC,0xD9,0x18,0xCF,0x4F,0x71,0x8C,0x72,0x5B,0x9C,0x77,0xD4,0xA6,0x53,0x6E,0xA9,0x7A,0x6F,0x40,
  0x09,0x34,0x67,0x38,0xD7,0x56,0x26,0x96,0xE3,0xB2,0xAC,0x8E,0xBE,0xC2,0xF4,0x6D,0xB9,0x8E,0xE3,0xCD,0xB6,0x02,0x7D,0xBE,0xC8,0x5C,0x69,0xF7,0x42,0x35,0x26,0xCB,
  0x5B,0xB8,0xCF,0xB2,0xBA,0x28,0xEE,0x87,0xD9,0x74,0x01,0x55,0xBC,0xE3,0x7E,0x82,0xE8,0x7E,0x69,0x10,0x99,0xDD,0xEA,0x81,0x26,0x43,0xCA,0xC6,0xCB,0x60,0x67,0x96,
  0xBF,0xC1,0x10,0xC4,0x99,0x4B,0x92,0x34,0x5A,0x5F,0x95,0xBD,0x88,0xD4,0xA9,0x98,0x3E,0xF0,0x00,0xE7,0x9E,0xB1,0xDB,0xD9,0xFC,0xA2,0xAB,0x7C,0x21,0x08,0x76,0x11,
  0xB5,0x22,0x1D,0x43,0x3B,0x2D,0x7C,0x46,0xC9,0x19,0x74,0xD1,0xE8,0x3A,0x2A,0x8C,0xAF,0x26,0x9B,0xB3,0x3D,0x31,0xBE,0x18,0x75,0x47,0x4F,0xB7,0x8F,0xDE,0x03,0xE9,
  0x44,0xD5,0x6A,0x62,0xEE,0xE4,0x6E,0x12,0x4B,0x85,0x87,0xB7,0xBA,0x9A,0xDA,0xC9,0x47,0x86,0x97,0x48,0xF2,0x70,0xEB,0x60,0xC0,0x6B,0xE3,0xD1,0xB1,0x1E,0x5E,0xF0,
  0xFD,0x9D,0xCB,0xAB,0xDF,0x2C,0xBE,0x52,0x3A,0x79,0x53,0x0A,0x67,0x37,0x48,0x5A,0x82,0xE1,0xA3,0x85,0x69,0x77,0x0A,0xAD,0x79,0x71,0x05,0x9C,0xF1,0x6E,0x1B,0xD9,
  0xD7,0x60,0x55,0x14,0xA5,0xF9,0x69,0xE7,0x66,0x27,0xDF,0x19,0x13,0xD3,0xE5,0xD6,0xB2,0x57,0xF4,0x08,0x59,0x36,0x37,0xF3,0x95,0x94,0x8A,0x87,0x33,0x31,0x5B,0xB0,
  0xB4,0x33,0x5E,0xB8,0xA2,0x89,0x1B,0x46,0xA3,0x6D,0x8C,0x08,0xBB,0xB3,0x56,0x4F,0x8D,0x56,0x42,0x36,0x6B,0x46,0xC5,0x4A,0x48,0xCC,0x94,0x3B,0xF7,0x19,0xF3,0x49,
  0x78,0x96,0x4D,0xCA,0xBB,0x82,0x7D,0x93,0x55,0x1A,0x13,0x23,0x39,0x5F,0x79,0xE6,0xF3,0xDA,0x23,0x16,0xE8,0x66,0x34,0xD2,0x15,0x4B,0x0E,0xDB,0x31,0x0F,0xD3,0x7B,
  0x1A,0xB4,0xD5,0xED,0x64,0xB3,0xEB,0x2A,0x15,0xFA,0x53,0x37,0x31,0x94,0x7B,0x7F,0xB3,0x24,0x67,0x00,0x47,0x19,0x56,0xC5,0x6B,0xA7,0x97,0x5D,0xB7,0x5B,0xB9,0x4F,
  0x2C,0x5D,0xAC,0x5A,0xFF,0x45,0xD1,0x69,0x55,0x0D,0xD0,0x78,0xEB,0x17,0xDD,0x08,0xC1,0xBE,0x96,0x84,0xE5,0x32,0xA2,0x47,0xBF,0x17,0x15,0x76,0x7B,0x94,0xB3,0xF2,
  0xEB,0x3C,0x4F,0x0C,0x17,0x05,0x37,0x9F,0xC3,0x50,0xD7,0xE6,0x6C,0x8B,0x70,0xC3,0xBE,0x26,0x7B,0x4B,0x37,0xC6,0xBD,0x28,0xF7,0x16,0xC6,0xC4,0x29,0x3F,0x99,0xB4,
  0xFC,0x6D,0xCC,0x18,0x2E,0x55,0xC2,0x0B,0xC6,0x93,0x5F,0xF8,0x5C,0xE0,0xC9,0x58,0x93,0x30,0x67,0x76,0x8D,0xA8,0xE8,0xC2,0x67,0x62,0xD2,0x86,0x3D,0xC4,0xD0,0x7F,
  0x1D,0xB7,0x43,0x00,0x7E,0xC0,0xDE,0x3D,0x1B,0x98,0x52,0x66,0xBE,0x72,0x5D,0x4A,0x3A,0x24,0x56,0x04,0xBA,0xA2,0xB0,0x4E,0x72,0x33,0xD4,0xB0,0x8F,0xD0,0xC9,0x21,
  0x4B,0x6F,0x7E,0x6F,0x1A,0x3B,0x76,0xD6,0x01,0xBA,0xEF,0x1A,0xEC,0x62,0x4A,0xBE,0xF1,0xE1,0x70,0xA8,0x4A,0xAA,0xC3,0x5C,0xC8,0x09,0xD8,0xD4,0x03,0x93,0xC3,0x74,
  0x82,0x30,0xC7,0xB9,0xE9,0xE1,0xA5,0xC1,0x28,0x12,0x99,0x97,0xA8,0xC9,0x3C,0x06,0xBC,0xC4,0xA2,0x54,0x44,0x12,0xB0,0x64,0x49,0x9D,0x61,0x5C,0xD7,0x47,0xD4,0xA6,
  0x29,0xEC,0x2D,0xC2,0xB2,0x27,0x21,0x65,0x30,0x35,0x45,0x63,0x17,0x16,0x88,0x09,0x6F,0xD9,0x38,0x4A,0x2A,0x16,0x29,0xD8,0xC2,0xB3,0xD6,0x26,0x35,0xB5,0x20,0xBA,
  0x33,0x24,0x55,0x6E,0x71,0x27,0xE5,0x7E,0x43,0x28,0xDC,0x93,0xA1,0x69,0xDD,0xAC,0x47,0xBB,0x7C,0xA5,0x0F,0x23,0x9A,0x62,0x61,0x12,0x32,0x2C,0xF8,0x8E,0xA9,0xFB,
  0x7C,0x2B,0xC0,0x53,0xC0,0xFA,0x1C,0x41,0x8C,0x26,0x9B,0x17,0x23,0x41,0x9B,0xBA,0x96,0x4D,0x88,0x6A,0x0C,0x69,0x58,0x56,0x5E,0xDA,0xB6,0x17,0x38,0x96,0xB3,0x81,
  0xEE,0xF2,0x45,0x9C,0xAE,0x77,0xB2,0x19,0xC8,0xCA,0xCD,0x5F,0x3E,0x4F,0xFE,0x06,0x9D,0xBB,0x42,0x24,0xA9,0xA0,0x8E,0xC0,0x75,0xE4,0xFD,0x5E,0xAA,0xD8,0x83,0xE2,
  0xBA,0x7C,0x87,0x7A,0x6D,0x6F,0x5B,0xAF,0xAD,0x9D,0x28,0xC8,0x56,0x53,0xAF,0x2D,0xDC,0xC7,0xBA,0xCA,0xA1,0x5A,0x5B,0x35,0xEE,0x50,0xAD,0x2D,0x4B,0x3B,0x54,0x6B,
  0x2B,0xC5,0x1D,0xAA,0xB5,0x29,0x87,0x6A,0x6D,0xF5,0xB4,0x43,0xB5,0xB6,0xC4,0x4A,0xE7,0xB8,0x43,0xB5,0xB6,0x22,0xD8,0xA1,0x5A,0x5B,0x27,0x9A,0x3A,0xDF,0x1D,0xAA,
  0xB5,0x95,0xC3,0x0E,0xD5,0xDA,0xD2,0x4F,0x52,0xE8,0xFE,0x3E,0x54,0x6B,0xFB,0xEE,0x50,0xAD,0x4D,0x0E,0x79,0xA8,0xD6,0x26,0xF1,0x2E,0x0F,0xD5,0xDA,0x4A,0x91,0x4D,
  0xAA,0xB5,0xFD,0xB7,0xAE,0x68,0xF6,0xDF,0xB9,0x16,0xDD,0xA1,0x5A,0x1B,0xE5,0x21,0xFE,0xE7,0x55,0x6B,0x6B,0xC7,0xE5,0xDA,0x62,0xF5,0x28,0x2C,0xD6,0xD6,0x4E,0x54,
  0x6B,0x6B,0xD7,0x97,0x6B,0x6B,0xFF,0x4F,0xAD,0xD7,0x96,0xB7,0x09,0xBE,0x66,0xBD,0x36,0x69,0xDA,0x9B,0xD4,0x6B,0x2B,0xA1,0x7D,0x77,0xA8,0xD7,0x76,0xA8,0xD7,0x56,
  0x84,0x3B,0xD4,0x6B,0xEB,0x1C,0xEA,0xB5,0x7D,0x9D,0x7A,0x6D,0x12,0xE5,0xDA,0xE2,0x92,0x6E,0x68,0xCC,0x1F,0x0A,0xB6,0xD5,0xF5,0xED,0xF7,0x50,0xB0,0xAD,0xCD,0x8B,
  0xB3,0x15,0x15,0x6C,0x8B,0x8C,0x91,0x43,0xC9,0xB6,0x43,0xC9,0xB6,0x42,0xDA,0xA1,0x64,0xDB,0xA1,0x64,0xDB,0xA1,0x64,0x5B,0x19,0xED,0x50,0xB2,0x2D,0xEA,0xDF,0xB7,
  0x2C,0xD9,0xD6,0xFE,0xE6,0x35,0xDB,0xDA,0x5F,0xAF,0x68,0x5B,0x29,0xF3,0x50,0xB7,0xAD,0x66,0x30,0x7F,0x47,0x75,0xDB,0xDA,0xBC,0x70,0x5B,0xBE,0x6E,0x5B,0x3B,0x55,
  0xB8,0xAD,0x2D,0x2A,0xB7,0xB5,0x0F,0xA5,0xDB,0xE4,0xFA,0x56,0x52,0xBA,0x2D,0x21,0xF3,0xC2,0xCD,0xEA,0x50,0xBB,0xED,0x50,0xBB,0xAD,0x08,0x58,0x5D,0xBB,0x2D,0x59,
  0xBA,0xAD,0x7D,0xA8,0xDD,0x46,0xEE,0xDD,0xA1,0x76,0x5B,0x0C,0x3B,0xD4,0x6E,0xAB,0xA0,0x1D,0x6A,0xB7,0x21,0xF0,0x50,0xBB,0xED,0x50,0xBB,0x2D,0x82,0xF1,0xDA,0x6D,
  0x52,0x3D,0x3B,0x94,0x6E,0xAB,0x1A,0xC8,0x43,0xE9,0xB6,0x44,0xDF,0x0E,0xA5,0xDB,0xCA,0x70,0xBF,0xA3,0xD2,0x6D,0x9C,0x16,0x1F,0xAD,0xB7,0x33,0x05,0xAD,0x3A,0xDA,
  0xD7,0xAF,0xE0,0xF6,0x95,0x9E,0x81,0x54,0xC8,0xED,0x2B,0x3D,0x03,0xA9,0x9E,0xDB,0xD7,0x7A,0x06,0x4A,0x59,0xB7,0xAF,0xF4,0x0C,0xA4,0xEA,0x6E,0x5F,0xEB,0x19,0x28,
  0x45,0xDE,0xC8,0xCF,0x70,0xA8,0xF5,0x56,0xD1,0xBB,0xDF,0x47,0xAD,0xB7,0xDC,0x15,0xFA,0xAF,0x5C,0xEA,0xAD,0x96,0xF7,0xC6,0x95,0xDE,0x8A,0x53,0x04,0x94,0xF2,0x5E,
  0x5D,0xE9,0x8D,0xC8,0x7B,0x75,0xA5,0xB7,0x7A,0xDE,0xDB,0x56,0x7A,0xAB,0x7F,0x7F,0x6F,0x5B,0xE8,0x4D,0x82,0xF7,0xA6,0x75,0xDE,0xE4,0x78,0x4D,0xCA,0xBC,0xED,0x9E,
  0x8B,0x32,0xA3,0x53,0x78,0x6F,0x51,0xE5,0x8D,0xC4,0x23,0x15,0x79,0x2B,0xAE,0xD4,0x41,0xE2,0xBD,0x41,0x8D,0x37,0x0A,0xEF,0x2D,0x4A,0xBC,0x51,0x78,0x6F,0x51,0xE1,
  0x8D,0xC2,0xA3,0x15,0x78,0xDB,0x6D,0x8A,0x2A,0x59,0x51,0x79,0xAF,0xAD,0xEF,0x46,0xE2,0x91,0xCA,0xBB,0xED,0xBA,0xCB,0x57,0xCE,0xCF,0xB7,0xA8,0xEE,0x46,0xE1,0xD1,
  0x8A,0xBB,0x15,0x57,0x26,0xA0,0xF0,0xDE,0xA2,0xB6,0x5B,0x13,0xDE,0x6B,0x4A,0xBB,0x91,0x78,0xA4,0xCA,0x6E,0x3B,0xBF,0xD1,0x7A,0x78,0xE3,0xC2,0x6E,0x45,0xB6,0xF6,
  0xD7,0x2C,0xEC,0x56,0xDA,0xBF,0x6F,0x58,0xD7,0xAD,0xE2,0x19,0xBE,0x52,0x59,0x37,0xB9,0xB7,0xFA,0x76,0x55,0xDD,0xB2,0x6F,0xF5,0xAB,0x17,0x75,0xAB,0x07,0xBE,0x71,
  0x4D,0xB7,0xDC,0x88,0x7E,0xED,0x92,0x6E,0xB5,0x0B,0xE5,0x8D,0x4B,0xBA,0xD1,0x79,0xAF,0x2B,0xE9,0xF6,0x3A,0x1E,0xBD,0xA4,0x5B,0x03,0xDE,0xAB,0x4A,0xBA,0x35,0xE3,
  0x35,0x2F,0xE9,0x46,0xE6,0xBD,0xB2,0xA4,0xDB,0xEB,0x78,0xF4,0x92,0x6E,0xCD,0x79,0xCD,0x4A,0xBA,0x91,0x79,0xAF,0x2C,0xE9,0x46,0xE6,0xBD,0xB2,0xA4,0x1B,0x89,0xF7,
  0x06,0x25,0xDD,0xC8,0xFD,0x7B,0x65,0x49,0xB7,0x37,0xE3,0x49,0x96,0x74,0x23,0xF3,0x5E,0x59,0xD2,0x8D,0xCC,0x7B,0x65,0x49,0x37,0x32,0xEF,0x95,0x25,0xDD,0x1A,0xF1,
  0x5E,0x51,0xD2,0xAD,0x09,0xEF,0x35,0x25,0xDD,0xE8,0xBC,0xD7,0x95,0x74,0x23,0xF3,0x5E,0x59,0xD2,0x8D,0xCE,0x7B,0x5D,0x49,0x37,0x32,0xEF,0x95,0x25,0xDD,0x9A,0xF2,
  0x9A,0x96,0x74,0x7B,0x0B,0x1E,0xA5,0xA4,0x5B,0x15,0xEF,0x50,0xD2,0xED,0x50,0xD2,0x2D,0x41,0x0B,0x49,0x6A,0xD8,0x41,0x31,0x5D,0x0E,0x25,0xDD,0x6A,0x71,0x87,0x92,
  0x6E,0x51,0xA0,0x61,0x9E,0x76,0x28,0xE9,0x16,0xD1,0x0E,0x25,0xDD,0x14,0x35,0xDB,0xB5,0x43,0x49,0xB7,0x34,0xEC,0x50,0xD2,0x2D,0x3F,0x21,0x0F,0x25,0xDD,0xB2,0xB4,
  0x43,0x49,0xB7,0xCA,0x1E,0x1F,0x4A,0xBA,0xD5,0x74,0xEF,0x50,0xD2,0x2D,0x71,0xC1,0xF6,0x50,0xD2,0xED,0x50,0xD2,0x2D,0x01,0x3B,0x94,0x74,0xAB,0xED,0xF2,0xA1,0xA4,
  0x5B,0x55,0xFF,0x0E,0x25,0xDD,0xA2,0x0E,0x1E,0x4A,0xBA,0x55,0xC1,0x0E,0x25,0xDD,0x72,0x23,0x79,0x28,0xE9,0x76,0x28,0xE9,0x16,0xE1,0xFE,0xC7,0x96,0x74,0x4B,0x4C,
  0x1F,0xDE,0xC3,0x6F,0x5F,0xD1,0xAD,0x7D,0x28,0xE9,0x76,0x28,0xE9,0x26,0x09,0x3B,0x94,0x74,0xAB,0xEA,0xDB,0xA1,0xA4,0x5B,0x5A,0x87,0x11,0x25,0xDD,0xAE,0xAE,0x4E,
  0xCF,0xB1,0xA0,0xDB,0x9D,0x6D,0xE0,0x6B,0xA4,0x25,0x2E,0x0C,0xE1,0x43,0x35,0xA3,0x1A,0x22,0x9C,0x6A,0xAB,0xE9,0x22,0x2A,0xED,0xC4,0x32,0xB6,0xAE,0x6C,0x01,0xA7,
  0xC4,0x13,0xEC,0x96,0x49,0xFB,0xA2,0xEE,0x01,0x5A,0x63,0x3F,0xF0,0x5C,0x02,0x23,0x8B,0xBB,0xEB,0x9F,0x65,0x42,0x80,0xAB,0xB4,0xAA,0xC9,0x3E,0x08,0x5C,0x87,0x2D,
  0x10,0xF4,0xA5,0x50,0xB8,0x9C,0x36,0xD6,0xE5,0x69,0x85,0xC3,0x3B,0xDD,0xC0,0x0B,0xB6,0x31,0x52,0x0C,0x85,0x9E,0xAE,0xCC,0x8D,0x07,0x33,0x78,0x01,0x9D,0xD9,0x21,
  0x8F,0xF4,0xDD,0xB4,0xDB,0x4D,0x3C,0x4D,0xED,0x50,0x4F,0x31,0x57,0xE2,0xB3,0x8B,0x41,0xA9,0xEE,0xD2,0x6D,0xD0,0xF9,0x69,0x7F,0x20,0xCD,0x6B,0x61,0x48,0x1C,0x8F,
  0xFF,0x73,0x2D,0x67,0x65,0xBB,0x2C,0x8B,0x80,0x1C,0x90,0xD3,0x7E,0xCE,0xC6,0xE6,0x4B,0xD1,0xA2,0xE0,0x62,0x69,0xAC,0xA0,0x65,0x05,0x60,0x15,0x4D,0xDC,0xDA,0x60,
  0xB5,0x49,0x2C,0xD2,0x40,0x86,0x93,0xF6,0x9E,0x30,0x69,0xCF,0x3D,0x10,0x7D,0xCA,0xFC,0xC9,0xF2,0x68,0xA8,0x90,0xB6,0xD3,0xFF,0x45,0xA2,0x61,0x5C,0xC0,0x4F,0x98,
  0x96,0x88,0xDD,0x3E,0x75,0x4D,0xE9,0x89,0xC9,0x69,0x46,0xF6,0x0E,0x40,0x15,0xED,0xC2,0xB5,0x59,0xBA,0x40,0x44,0x4D,0x4C,0x9B,0xD2,0x41,0xB1,0x20,0x47,0xAF,0x5C,
  0x90,0x97,0x1E,0x86,0x37,0x1A,0x8E,0x32,0xF6,0xB6,0xBC,0x6C,0x03,0x1E,0x6A,0x62,0x68,0xD9,0x93,0xF2,0xF1,0xB2,0x2E,0xF4,0x18,0x9E,0x60,0x32,0x21,0xF4,0xB7,0x9A,
  0x56,0x89,0x13,0xB4,0xE9,0x1B,0xD1,0x7E,0xB9,0xAA,0xC4,0x09,0x1A,0x45,0xB8,0x56,0xD2,0xAA,0x3B,0x27,0x68,0xA7,0x54,0x1A,0xDE,0x11,0xB1,0x40,0x94,0xA5,0x89,0x3F,
  0x39,0xA6,0xB9,0xAB,0xB8,0xA2,0x26,0x68,0xD9,0xBB,0x69,0xD5,0xD2,0xF3,0x8A,0xA7,0xEF,0x70,0xBD,0x17,0x65,0xBE,0x75,0xAB,0x63,0xBA,0x0A,0x79,0x27,0x94,0xDE,0x5D,
  0x99,0x46,0xB0,0xE1,0x89,0xF8,0x8D,0x9D,0xAF,0xFC,0xC0,0x43,0xD4,0xF6,0x6B,0xFF,0x8F,0xB5,0x5C,0xBE,0x0A,0xBB,0x0F,0x14,0xDA,0xED,0x62,0xA6,0x84,0x48,0x1C,0xCB,
  0xFC,0x5D,0x90,0xEA,0xBE,0x5D,0x13,0x64,0x75,0x71,0xBE,0x37,0x7C,0x82,0xF9,0xCA,0xB0,0x4D,0x22,0x3F,0x7A,0x02,0x82,0xFC,0x06,0xDE,0x2D,0x96,0xE7,0x33,0x95,0xA9,
  0xB1,0xCC,0x5E,0xAD,0x97,0xE4,0xF5,0xF7,0x84,0xF1,0xBD,0xDB,0x7B,0x3B,0xE0,0xB0,0x50,0x82,0x95,0x6B,0x90,0xA5,0xDC,0x6E,0x93,0xBD,0x17,0x57,0x45,0x23,0xEF,0xEE,
  0xB9,0xBE,0x11,0x94,0x9C,0xD6,0xDC,0xB0,0xB7,0x68,0x31,0x36,0x1F,0xC9,0x8F,0x14,0x1A,0xBB,0x1F,0xB6,0xA4,0xED,0x14,0x09,0xDA,0xCE,0xEF,0xD1,0x68,0x3C,0x2C,0x0E,
  0x14,0xF2,0x47,0xAC,0x51,0x21,0x0F,0xE5,0x7D,0x9B,0xBF,0x76,0x5D,0xDC,0x83,0xC5,0x1D,0x66,0xB3,0xA3,0x09,0xB9,0x50,0xCA,0x9D,0x10,0xFA,0x5B,0x54,0xA5,0xF9,0xC6,
  0x75,0xDA,0x7E,0x80,0x87,0x1B,0xDE,0x5A,0xB1,0xCD,0x47,0xFF,0x1B,0x55,0x78,0x86,0x21,0x07,0x9D,0xC7,0xB4,0xCD,0x80,0x9C,0x29,0x16,0x53,0x8A,0x4B,0x5A,0x42,0xEC,
  0xF8,0x38,0xE2,0xDD,0xBB,0x2E,0xE8,0x75,0x74,0x2B,0x53,0xEB,0xE9,0x1A,0xC9,0xF2,0x6A,0x5D,0x9B,0xAB,0x8D,0xC1,0x8B,0x48,0x51,0x8D,0xBD,0x56,0x4F,0x1F,0x0D,0xBB,
  0xB9,0x33,0x80,0xB2,0xDE,0x75,0xC3,0x1A,0x59,0x6F,0x52,0xB3,0xFB,0x8D,0x5E,0xEE,0x85,0xB5,0xE3,0x31,0xED,0xD0,0x79,0x5F,0xE4,0x3D,0x6A,0xFF,0x55,0xC1,0x6F,0xFF,
  0xA9,0xEE,0x08,0xAB,0xD1,0x54,0xF2,0x95,0x5B,0xB0,0x09,0x24,0x11,0xAF,0xA3,0xA5,0x5F,0xAD,0x4F,0x81,0x36,0xA0,0x31,0xB3,0x00,0x14,0x84,0xB9,0xED,0xEE,0x4C,0xAC,
  0x4D,0x02,0x9A,0x49,0xBF,0xA7,0x68,0xCA,0x17,0xFE,0xCF,0x1F,0xCB,0xF9,0x0D,0x68,0xBF,0xA7,0x39,0x74,0xD3,0x24,0x73,0x63,0x53,0x9A,0x70,0xD3,0xCC,0xDE,0xC6,0x4D,
  0x33,0xA0,0x09,0x0B,0x8D,0x05,0x8C,0x36,0x70,0xC8,0x08,0xDA,0xDD,0x64,0xFC,0x4A,0x23,0x49,0x6B,0xE8,0xA7,0x88,0x9E,0x80,0xE8,0xAA,0x78,0xA5,0x57,0x68,0xF0,0x4D,
  0xBD,0x42,0x03,0x92,0x57,0xE8,0xB5,0x6E,0x98,0xC1,0x37,0x75,0xC3,0x0C,0xBE,0xA9,0x1B,0x66,0xF0,0x4D,0xDD,0x30,0x83,0x6F,0xEA,0x86,0x19,0x7C,0x53,0x37,0xCC,0xE0,
  0x9B,0xBA,0x61,0x06,0xFF,0xE5,0x6E,0x98,0xC1,0x37,0x75,0xC3,0x0C,0xBE,0xA9,0x1B,0x66,0xF0,0x4D,0xDD,0x30,0x83,0x6F,0xEA,0x86,0x19,0x7C,0x63,0x37,0xCC,0xE0,0x9B,
  0xBA,0x61,0x06,0xDF,0xD4,0x0D,0x33,0x20,0xB9,0x61,0x5E,0xEB,0x72,0x19,0x90,0x5C,0x2E,0xAF,0x75,0xB8,0x0C,0xBE,0xA9,0xC3,0x65,0xF0,0x4D,0x1D,0x2E,0x83,0x6F,0xEA,
  0x70,0x19,0x90,0x1D,0x2E,0xAF,0x71,0x81,0x0C,0xFE,0xCB,0x5D,0x20,0x03,0x92,0x0B,0xE4,0x77,0xE8,0x04,0x79,0x63,0xA7,0x44,0x61,0x7C,0x4B,0x0A,0xF8,0xF5,0xBD,0x2E,
  0x91,0xD3,0xE5,0xDB,0xB8,0x41,0x0E,0x5E,0x90,0x83,0x17,0xE4,0xE0,0x05,0x79,0x83,0x71,0x4E,0x04,0xAB,0x8C,0xFF,0xF9,0xAD,0xE1,0xBF,0xAB,0x61,0x3F,0xB3,0xAD,0xDD,
  0x0E,0xB4,0xB4,0x1F,0x6E,0x4C,0x73,0xED,0x83,0x8C,0xF6,0x9E,0x24,0xAB,0xB4,0xA1,0x60,0x1E,0x8D,0x0A,0xE4,0x64,0xE7,0x78,0x34,0xE2,0x15,0x75,0x3A,0xC3,0x81,0xA0,
  0xB6,0xC3,0xBF,0xF0,0x1F,0x32,0x87,0x2E,0x56,0x0F,0x57,0x99,0xD6,0xC1,0x6A,0x26,0xCC,0x9F,0x1A,0x94,0x5A,0xC7,0x50,0x4B,0x5D,0xDA,0x85,0x1C,0x12,0x9B,0xA0,0x42,
  0x22,0xDE,0x76,0xEC,0x35,0x23,0x2E,0x5D,0xC3,0x8B,0xD2,0x9D,0x62,0x68,0xD2,0xFD,0xC6,0x34,0x6D,0xBF,0x26,0xB6,0xAD,0xD5,0xD5,0x7A,0xAA,0x8A,0x81,0x6D,0x12,0xBE,
  0x12,0xE0,0x31,0x9C,0xE3,0x3E,0xFB,0x1B,0xB7,0xD1,0x75,0x66,0xBD,0xA3,0x11,0xBC,0xF2,0x71,0x07,0x69,0x57,0xF1,0x92,0xC4,0x3E,0xD6,0xFD,0x95,0x3E,0xE5,0x08,0xBB,
  0xF8,0x64,0x29,0xFD,0xE2,0x00,0xCE,0x5A,0x20,0x56,0xF4,0x19,0x91,0xBB,0x58,0xB4,0xF4,0x52,0xFA,0x94,0xB1,0x5A,0x99,0xBE,0xEF,0x7A,0x96,0x29,0xA5,0x56,0xBD,0x66,
  0xD9,0xDE,0xD9,0x4C,0xB7,0xFC,0xD2,0x15,0x37,0x5A,0x45,0x98,0xAB,0xF9,0x19,0x34,0x9E,0x35,0x2F,0xF4,0x55,0xEA,0x9F,0x1A,0x0E,0x3B,0x9D,0x8E,0x54,0xEF,0xA3,0xBA,
  0x83,0xF3,0xBD,0xF7,0xA0,0x4C,0xD8,0xF4,0xC5,0x6D,0xA8,0x7F,0xDC,0x93,0x3F,0xAD,0xC4,0xCB,0xF8,0x83,0x3C,0x2E,0x44,0x31,0xE9,0xC0,0x99,0x4A,0x62,0x3A,0xE5,0x80,
  0xA2,0x7E,0x0B,0x06,0x9C,0x9D,0xD9,0xC6,0xB6,0xDC,0x8B,0xC4,0x81,0x98,0xEC,0x31,0xBD,0x5E,0x2A,0x81,0xC5,0xF7,0x68,0xD3,0x0F,0xA1,0x76,0x28,0xB3,0x8D,0xDD,0xA4,
  0x95,0x55,0x5B,0x13,0xCF,0x21,0x9C,0xF3,0xE3,0x7F,0xC6,0x1F,0x3B,0x6C,0x50,0x5F,0x67,0x83,0x6A,0x27,0x77,0xA8,0xCC,0x06,0xF5,0xCD,0xF7,0xA7,0x6F,0xBE,0x3D,0xFD,
  0x77,0xDF,0x9D,0xDE,0x72,0x73,0xCA,0xC5,0xB0,0x97,0x03,0xBF,0xDD,0xDE,0x74,0xD8,0x9A,0xBE,0xE2,0xD6,0x94,0x0F,0xE2,0xFF,0xCA,0x5B,0x53,0x29,0xF0,0xAD,0xB7,0xA6,
  0xE6,0x1B,0x93,0xD8,0x9E,0xE6,0xD3,0xF1,0xCD,0xA7,0xDB,0xD9,0xC9,0xE9,0x0C,0x4C,0x27,0x55,0xF9,0x4F,0x65,0x7E,0x71,0x7B,0xAF,0xFC,0xE5,0xEA,0x64,0x36,0xBE,0x3F,
  0xB9,0x9C,0xFD,0xF5,0xCE,0x00,0x13,0xF6,0xBB,0x3F,0x68,0xF0,0x93,0x8B,0xCB,0x93,0xD3,0xE4,0x4F,0xB0,0x2F,0x7A,0xFE,0x13,0x1F,0x1C,0xF7,0xE1,0xC1,0x5A,0x59,0x86,
  0xFD,0x8F,0xAB,0xF9,0x8B,0x13,0x6C,0xF0,0xF7,0xBA,0x95,0xBF,0x27,0x20,0x7F,0x56,0x7A,0x79,0x4C,0xF2,0xD7,0xF0,0x57,0xFA,0x95,0x2D,0x5D,0x98,0x36,0xEC,0x2F,0xF8,
  0x7B,0x83,0xCA,0xDF,0x9B,0xEE,0xFD,0xC0,0xDD,0x86,0x96,0xE3,0xFC,0xD7,0x9B,0xC5,0x05,0xF4,0xFF,0xFF,0xDC,0x8D,0x17,0x17,0xF0,0xB9,0xD6,0x89,0xF9,0x80,0x8E,0x3D,
  0x63,0xE9,0xBB,0xF6,0x1E,0xDE,0xD5,0xCE,0x80,0x39,0x11,0xB8,0x0A,0xEF,0x50,0x0B,0xDB,0x1F,0x7F,0xB1,0xCD,0x23,0x65,0xC5,0xFC,0x9D,0x1B,0xBC,0xF6,0x8C,0x2E,0x13,
  0x9F,0x97,0x53,0x0E,0x5E,0x76,0x30,0x6F,0xF8,0x2F,0x2B,0x4F,0x28,0x20,0xA1,0x29,0x77,0x1F,0xFC,0xE9,0xBB,0x3F,0x74,0xE0,0x55,0x28,0x1F,0x4F,0x67,0xF3,0xCB,0xDB,
  0x1B,0x45,0x3F,0x56,0xCB,0x5F,0xED,0x7F,0x26,0x7F,0x0D,0x3E,0xA8,0xC2,0x07,0x27,0xB3,0xCB,0xE9,0x4F,0x9F,0xC6,0xB3,0x69,0xD5,0x9C,0x80,0x7E,0x63,0x7F,0x94,0xC9,
  0xE9,0xF9,0xE5,0x4D,0xE2,0x23,0x78,0x35,0xAD,0xA3,0x41,0x2B,0xA7,0x57,0xA7,0xD3,0x05,0x7C,0xFB,0xD3,0xCD,0x2F,0x8B,0x4F,0xD3,0xF1,0xE4,0xEA,0xB4,0xB6,0x95,0x82,
  0x8F,0xB0,0xE6,0xF4,0x64,0x73,0x77,0xB7,0xF7,0xA7,0xB3,0x4F,0x67,0x1F,0x6E,0xA6,0x0B,0x78,0xEC,0x79,0xAA,0xE9,0x92,0xE6,0x8A,0x3F,0xC2,0x9A,0xEE,0xD6,0x36,0xFD,
  0xE9,0x62,0x7C,0x75,0x46,0x6B,0x9A,0x7F,0x84,0xB5,0xDF,0x4B,0xB6,0x3F,0x9B,0xFE,0x42,0x1D,0x89,0xF8,0x23,0xAC,0xB9,0x3E,0x34,0x77,0x76,0x39,0x01,0xE4,0xED,0xDD,
  0xE2,0x72,0x3A,0x97,0x6C,0xAE,0xE0,0x23,0xAC,0xB9,0x41,0x61,0x73,0x9F,0xEE,0x71,0x71,0x90,0x9A,0xE3,0x1F,0x61,0x6D,0xC2,0xE2,0x57,0x2E,0x6E,0xE7,0xA7,0x9F,0xCE,
  0xAE,0x4E,0x7F,0xB9,0xC4,0x9F,0xB1,0x4B,0x74,0x75,0x8F,0x58,0xF0,0x11,0xD6,0xDC,0x28,0xD7,0x9C,0xAA,0x15,0xB5,0x56,0xD9,0x1C,0x7E,0x04,0x5B,0xC3,0xBC,0xE2,0xD9,
  0x1F,0x8D,0xE8,0xAD,0x8D,0x44,0x6B,0xB8,0x58,0xAE,0x2F,0x6F,0x2E,0xCF,0x2E,0xCF,0x3F,0x4D,0x2F,0xC6,0x97,0x37,0x9F,0xD4,0xBE,0x44,0x6B,0xF9,0x8F,0xB0,0xD6,0x70,
  0xD1,0xCC,0xE1,0xA5,0xDF,0x9C,0x7F,0x42,0x5E,0x51,0x3B,0x45,0xAD,0x25,0x3F,0xC2,0xDA,0xD1,0xE3,0x76,0x54,0xB5,0xF0,0x71,0xAA,0xDA,0xC1,0x8F,0xB0,0x66,0xBA,0x71,
  0x33,0x1A,0xBD,0x19,0x2D,0x6C,0xA6,0x17,0x37,0xA3,0xD3,0x9B,0xD1,0xC3,0x66,0xFA,0x71,0x33,0x5D,0x7A,0x33,0xDD,0xB0,0x99,0x41,0xDC,0xCC,0xFD,0xE5,0xE2,0xE2,0xD3,
  0xF9,0xEC,0xF2,0x6E,0x5E,0xD4,0xBF,0xC2,0x66,0x32,0x1F,0x61,0x2D,0xE2,0x74,0x5F,0x9C,0x4E,0x2F,0x6E,0x60,0xB1,0x8E,0x7F,0xB9,0x8A,0xA7,0x49,0x75,0x8B,0xC5,0x1F,
  0x61,0x2D,0x8E,0x12,0x2D,0xE2,0x4F,0xDA,0xF3,0x5F,0xE7,0x8B,0xD3,0xEB,0xFC,0x52,0x2F,0x6E,0x31,0xFF,0x11,0x6C,0x15,0x2F,0xF1,0x16,0xFE,0x4A,0x6E,0xAA,0xD5,0xB7,
  0x1A,0x4D,0x35,0x4D,0x4D,0x34,0x7A,0x77,0x73,0xFA,0xE1,0x7A,0x0C,0x22,0x81,0xFD,0xFC,0xD3,0xE4,0xF4,0x23,0x08,0xB1,0x93,0xCA,0x46,0x4B,0x3E,0xC2,0x9A,0xD6,0x12,
  0x4D,0xCF,0x2E,0x27,0x93,0xD3,0x93,0x92,0x55,0x51,0xDC,0x74,0xF2,0x23,0xD8,0xDE,0x9F,0x59,0x55,0xB9,0x23,0x85,0x85,0x4F,0xE3,0x26,0x1A,0x78,0x58,0xC9,0xA7,0x62,
  0x0F,0xD5,0x70,0x1D,0xCD,0x3E,0x4C,0x50,0xD4,0x4D,0xC6,0x37,0x27,0x79,0x72,0xF1,0x13,0x24,0x3F,0xC2,0x7A,0xD2,0x4D,0xB4,0x73,0x7A,0xB5,0xA0,0xB6,0x83,0x1F,0xE1,
  0x3D,0x10,0xB3,0x90,0xF2,0x30,0xC9,0x8F,0xB0,0x87,0xE9,0x25,0x86,0x95,0xCB,0x9F,0xAB,0xCB,0x9B,0x9F,0x6A,0xDB,0x29,0xF8,0x08,0x6B,0xAE,0x5F,0xD8,0x1C,0x5F,0x28,
  0x8B,0xFB,0xDB,0x4F,0xF3,0xC5,0x87,0x93,0xB9,0x4C,0x73,0xD9,0x8F,0xB0,0xD6,0x07,0xB9,0xD6,0x17,0xB3,0xD3,0x71,0x41,0xE7,0xAB,0x5A,0xE7,0x1F,0x61,0xED,0x0D,0x8B,
  0xDB,0xFB,0xA4,0x0F,0xA9,0xED,0xE1,0x47,0x58,0x93,0xC9,0xC5,0x5A,0xF2,0x70,0x55,0x4D,0xC6,0x0F,0xA7,0x77,0xB2,0x2D,0x7D,0x9A,0x82,0x46,0x79,0x75,0x3A,0x23,0xB4,
  0x14,0x7D,0x84,0x4F,0x98,0xA9,0xBB,0xDD,0xD9,0x26,0xD3,0x2C,0xF1,0x88,0xA8,0x70,0x9A,0x77,0x91,0x7B,0x77,0x75,0xF9,0x29,0xAF,0x7C,0x7D,0xD2,0x3A,0xD3,0xEB,0x32,
  0x6E,0xD5,0x47,0x90,0xDE,0x55,0xCB,0xDB,0xD5,0x7B,0xE4,0x76,0xD9,0x47,0x58,0xBB,0x5A,0x79,0xBB,0x3D,0xFA,0xF3,0xF6,0xA2,0xE7,0xD5,0xB3,0xED,0xA2,0xEA,0x35,0xBB,
  0x5D,0x7C,0x9A,0x9F,0xDE,0xCC,0x6F,0x67,0x52,0xED,0x66,0x3E,0xC2,0xDA,0xED,0x16,0xB5,0x7B,0x75,0x79,0x7E,0x91,0x6D,0xB9,0xA6,0xDD,0xD4,0x47,0x58,0xCB,0xBD,0xA2,
  0x96,0x79,0xB7,0x54,0x5D,0x72,0x24,0x32,0x1F,0x61,0xED,0xF6,0x2B,0xDA,0x1D,0xD0,0xDB,0x1D,0x84,0xED,0x0E,0xCA,0xDB,0xD5,0xE8,0xCF,0xAB,0x45,0xCF,0x3B,0x2C,0x6F,
  0xB7,0x2B,0x3B,0x23,0x32,0x1F,0x61,0xED,0x8E,0xCA,0xDB,0xED,0xD3,0xDB,0xED,0x87,0xED,0xF6,0x72,0x2B,0x2E,0x31,0x58,0xA9,0x07,0x96,0x1B,0xDF,0xE8,0x81,0x7B,0xB9,
  0x25,0x17,0xFF,0x96,0xAE,0x0D,0xA9,0x0D,0xF3,0x8F,0xB0,0x86,0xC3,0x35,0x97,0x57,0xD2,0x85,0xDC,0x1E,0x4F,0xE6,0x25,0x0D,0x57,0x7E,0x84,0x35,0xAE,0x57,0x37,0x7E,
  0xFB,0x61,0x21,0xDA,0x97,0x6E,0x3C,0xFA,0x08,0x6B,0xBF,0x5B,0xD8,0x7E,0x81,0x15,0x51,0xD7,0x7E,0x68,0x45,0xF4,0x7A,0xC5,0x2D,0xE6,0x2D,0x89,0xDA,0x16,0x85,0x25,
  0xD1,0x0B,0x97,0x5C,0xAD,0x35,0x91,0x6F,0xB1,0xD8,0x9A,0xE8,0x85,0x8B,0xAD,0xD6,0x12,0xC8,0xB7,0x98,0xB1,0x04,0x7A,0xC3,0x74,0x53,0xE5,0xD6,0x40,0x69,0x53,0xA1,
  0xB6,0xDC,0x1B,0xA5,0x9B,0x2A,0xD7,0xC1,0x4B,0x9B,0x2A,0xD0,0xC1,0xFB,0x9D,0x74,0xAB,0xE5,0x06,0x42,0x69,0xAB,0xA1,0x81,0xD0,0x0F,0x97,0x50,0xA1,0x7E,0xFE,0x69,
  0x50,0xD5,0x54,0xD9,0x47,0x58,0xBB,0x5A,0x65,0xBB,0xAA,0x4A,0x6E,0x17,0x3E,0xC2,0x1A,0xD6,0xAB,0x1B,0xD6,0xE8,0x0D,0x6B,0xBC,0xE1,0x6E,0x75,0xC3,0x5D,0x7A,0xC3,
  0x5D,0xDE,0x70,0xAF,0xBA,0xE1,0x3E,0xBD,0xE1,0x3E,0x6F,0xB8,0x5F,0xDD,0xF0,0x88,0xDE,0xF0,0x88,0x37,0x3C,0xC8,0x34,0x5C,0xAA,0xE8,0x95,0x37,0x1C,0x2B,0x7A,0xFD,
  0x61,0x51,0x6B,0x45,0xCA,0x5E,0x79,0x6B,0x49,0x35,0x6F,0x81,0xC1,0xA5,0x0E,0x16,0x44,0x32,0x02,0x73,0x0B,0x5F,0xFD,0x49,0xB9,0xBC,0x99,0xE7,0x3C,0x38,0x89,0xF6,
  0xF8,0x8F,0x0B,0x3F,0x09,0x92,0xB3,0xE8,0xA3,0xE1,0x27,0xC5,0x8F,0x0B,0x3F,0x3A,0x9D,0xDD,0xCE,0xE7,0xE5,0x43,0xC2,0x7E,0xFC,0xDD,0x1F,0x3E,0x5A,0xBE,0xB5,0xB4,
  0x6C,0x2B,0x78,0x49,0x7E,0x96,0xB9,0x50,0x4B,0x3E,0x88,0x3F,0x2B,0xFB,0xDC,0x45,0xC5,0xB3,0x5E,0xB0,0x07,0x45,0x35,0x18,0x93,0xFF,0xB9,0x0F,0xCA,0x83,0x65,0x9B,
  0xF8,0x8D,0xFF,0x0F,0x51,0x19,0xD5,0x81,
};

static int lcGetMinifigSettings(lcMemFile& File)
{
	const size_t CHUNK = 16384;
	int ret;
	unsigned have;
	z_stream strm;
	unsigned char in[CHUNK];
	unsigned char out[CHUNK];
	int pos;

	strm.zalloc = Z_NULL;
	strm.zfree = Z_NULL;
	strm.opaque = Z_NULL;
	strm.avail_in = 0;
	strm.next_in = Z_NULL;
	pos = 0;

	ret = inflateInit(&strm);
	if (ret != Z_OK)
		return ret;

	do
	{
		strm.avail_in = lcMin(sizeof(sDefaultSettings) - pos, CHUNK);
		strm.next_in = in;

		if (strm.avail_in == 0)
			break;

		memcpy(in, sDefaultSettings + pos, strm.avail_in);
		pos += strm.avail_in;

		do
		{
			strm.avail_out = CHUNK;
			strm.next_out = out;
			ret = inflate(&strm, Z_NO_FLUSH);

			switch (ret)
			{
			case Z_NEED_DICT:
				ret = Z_DATA_ERROR;
			case Z_DATA_ERROR:
			case Z_MEM_ERROR:
				(void)inflateEnd(&strm);
				return ret;
			}

			have = CHUNK - strm.avail_out;
			File.WriteBuffer(out, have);
		} while (strm.avail_out == 0);
	} while (ret != Z_STREAM_END);

	(void)inflateEnd(&strm);

	return ret == Z_STREAM_END ? Z_OK : Z_DATA_ERROR;
}

// =============================================================================
// MinifigWizard class

MinifigWizard::MinifigWizard(lcMinifig* Minifig)
{
	char Filename[LC_MAXPATH];
	strcpy(Filename, lcGetPiecesLibrary()->mLibraryPath);
	strcat(Filename, "mlcad.ini");

	lcDiskFile DiskSettings;
	if (DiskSettings.Open(Filename, "rt"))
	{
		ParseSettings(DiskSettings);
	}
	else
	{
		lcMemFile MemSettings;
		lcGetMinifigSettings(MemSettings);
		ParseSettings(MemSettings);
	}

	mMinifig = Minifig;

	m_RotateX = 75.0f;
	m_RotateZ = 180.0f;
	m_Distance = 10.0f;
	m_AutoZoom = true;
	m_Tracking = LC_TRACK_NONE;
}

void MinifigWizard::OnInitialUpdate()
{
	MakeCurrent();

	memset(mMinifig, 0, sizeof(lcMinifig));

	const int ColorCodes[LC_MFW_NUMITEMS] = { 4, 7, 14, 7, 1, 0, 7, 4, 4, 14, 14, 7, 7, 0, 0, 7, 7 };
	const char* Pieces[LC_MFW_NUMITEMS] = { "3624", "None", "3626BP01", "None", "973", "3815", "None", "3819", "3818", "3820", "3820", "None", "None", "3817", "3816", "None", "None" };

	for (int i = 0; i < LC_MFW_NUMITEMS; i++)
	{
		mMinifig->Colors[i] = lcGetColorIndex(ColorCodes[i]);

		PieceInfo* Info = lcGetPiecesLibrary()->FindPiece(Pieces[i], false);
		if (Info)
		{
			mMinifig->Parts[i] = Info;
			Info->AddRef();
		}
	}

	Calculate();
}

MinifigWizard::~MinifigWizard ()
{
	for (int i = 0; i < LC_MFW_NUMITEMS; i++)
		if (mMinifig->Parts[i])
			mMinifig->Parts[i]->Release();
}

void MinifigWizard::ParseSettings(lcFile& Settings)
{
	const char* SectionNames[LC_MFW_NUMITEMS] =
	{
		"[HATS]",   // LC_MFW_HATS
		"[HATS2]",  // LC_MFW_HATS2
		"[HEAD]",   // LC_MFW_HEAD
		"[NECK]",   // LC_MFW_NECK
		"[BODY]",   // LC_MFW_BODY
		"[BODY2]",  // LC_MFW_BODY2
		"[BODY3]",  // LC_MFW_BODY3
		"[RARM]",   // LC_MFW_RARM
		"[LARM]",   // LC_MFW_LARM
		"[RHAND]",  // LC_MFW_RHAND
		"[LHAND]",  // LC_MFW_LHAND
		"[RHANDA]", // LC_MFW_RHANDA
		"[LHANDA]", // LC_MFW_LHANDA
		"[RLEG]",   // LC_MFW_RLEG
		"[LLEG]",   // LC_MFW_LLEG
		"[RLEGA]",  // LC_MFW_RLEGA
		"[LLEGA]",  // LC_MFW_LLEGA
	};

	for (int SectionIndex = 0; SectionIndex < LC_MFW_NUMITEMS; SectionIndex++)
	{
		lcArray<lcMinifigPieceInfo>& InfoArray = mSettings[SectionIndex];

		InfoArray.RemoveAll();
		Settings.Seek(0, SEEK_SET);

		char Line[1024];
		bool FoundSection = false;
		const char* SectionName = SectionNames[SectionIndex];
		int SectionNameLength = strlen(SectionName);

		// Find start of section
		while (Settings.ReadLine(Line, sizeof(Line)))
		{
			if (!strncmp(Line, SectionName, SectionNameLength))
			{
				FoundSection = true;
				break;
			}
		}

		if (!FoundSection)
		{

			lcMinifigPieceInfo MinifigInfo;
			strncpy(MinifigInfo.Description, "None", sizeof(MinifigInfo.Description));
			MinifigInfo.Description[sizeof(MinifigInfo.Description)-1] = 0;
			MinifigInfo.Offset = lcMatrix44Identity();
			MinifigInfo.Info = NULL;

			InfoArray.Add(MinifigInfo);
			continue;
		}

		// Parse section.
		while (Settings.ReadLine(Line, sizeof(Line)))
		{
			if (Line[0] == '[')
				break;

			char* DescriptionStart = strchr(Line, '"');
			if (!DescriptionStart)
				continue;
			DescriptionStart++;
			char* DescriptionEnd = strchr(DescriptionStart, '"');
			if (!DescriptionEnd)
				continue;
			*DescriptionEnd = 0;
			DescriptionEnd++;

			char* NameStart = strchr(DescriptionEnd, '"');
			if (!NameStart)
				continue;
			NameStart++;
			char* NameEnd = strchr(NameStart, '"');
			if (!NameEnd)
				continue;
			*NameEnd = 0;
			NameEnd++;

			strupr(NameStart);
			char* Ext = strrchr(NameStart, '.');
			if (Ext != NULL)
			{
				if (!strcmp(Ext, ".DAT"))
					*Ext = 0;
			}

			PieceInfo* Info = lcGetPiecesLibrary()->FindPiece(NameStart, false);
			if (!Info && *NameStart)
				continue;

			float Mat[12];
			int Flags;

			if (sscanf(NameEnd, "%d %g %g %g %g %g %g %g %g %g %g %g %g",
					   &Flags, &Mat[0], &Mat[1], &Mat[2], &Mat[3], &Mat[4], &Mat[5], &Mat[6], 
					   &Mat[7], &Mat[8], &Mat[9], &Mat[10], &Mat[11]) != 13)
				continue;

			lcMatrix44 Offset = lcMatrix44Identity();
			float* OffsetMatrix = &Offset[0][0];

			OffsetMatrix[0] =  Mat[0];
			OffsetMatrix[8] = -Mat[1];
			OffsetMatrix[4] =  Mat[2];
			OffsetMatrix[2] = -Mat[3];
			OffsetMatrix[10] = Mat[4];
			OffsetMatrix[6] = -Mat[5];
			OffsetMatrix[1] =  Mat[6];
			OffsetMatrix[9] = -Mat[7];
			OffsetMatrix[5] =  Mat[8];
			OffsetMatrix[12] =  Mat[9] / 25.0f;
			OffsetMatrix[14] = -Mat[10] / 25.0f;
			OffsetMatrix[13] =  Mat[11] / 25.0f;

			lcMinifigPieceInfo MinifigInfo;
			strncpy(MinifigInfo.Description, DescriptionStart, sizeof(MinifigInfo.Description));
			MinifigInfo.Description[sizeof(MinifigInfo.Description)-1] = 0;
			MinifigInfo.Offset = Offset;
			MinifigInfo.Info = Info;

			InfoArray.Add(MinifigInfo);
		}
	}
}

void MinifigWizard::OnDraw()
{
	float Aspect = (float)mWidth/(float)mHeight;
	glViewport(0, 0, mWidth, mHeight);
	glEnableClientState(GL_VERTEX_ARRAY);

	float Box[6] = { 10000, 10000, 10000, -10000, -10000, -10000 };

	for (int InfoIdx = 0; InfoIdx < LC_MFW_NUMITEMS; InfoIdx++)
	{
		PieceInfo* Info = mMinifig->Parts[InfoIdx];

		if (!Info)
			continue;

		lcVector3 Points[8] =
		{
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[1], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[1], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[1], Info->m_fDimensions[2]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[4], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[4], Info->m_fDimensions[2]),
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[4], Info->m_fDimensions[2]),
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[4], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[1], Info->m_fDimensions[2])
		};

		for (int PointIdx = 0; PointIdx < 8; PointIdx++)
		{
			lcVector3 Point = lcMul31(Points[PointIdx], mMinifig->Matrices[InfoIdx]);

			if (Point[0] < Box[0]) Box[0] = Point[0];
			if (Point[1] < Box[1]) Box[1] = Point[1];
			if (Point[2] < Box[2]) Box[2] = Point[2];
			if (Point[0] > Box[3]) Box[3] = Point[0];
			if (Point[1] > Box[4]) Box[4] = Point[1];
			if (Point[2] > Box[5]) Box[5] = Point[2];
		}
	}

	lcVector3 Center((Box[0] + Box[3]) / 2, (Box[1] + Box[4]) / 2, (Box[2] + Box[5]) / 2);

	lcVector3 Eye(0.0f, 0.0f, 1.0f);

	Eye = lcMul30(Eye, lcMatrix44RotationX(-m_RotateX * LC_DTOR));
	Eye = lcMul30(Eye, lcMatrix44RotationZ(-m_RotateZ * LC_DTOR));

	lcMatrix44 Projection = lcMatrix44Perspective(30.0f, Aspect, 1.0f, 100.0f);
	glMatrixMode(GL_PROJECTION);
	glLoadMatrixf(Projection);

	lcMatrix44 ViewMatrix;

	if (m_AutoZoom)
	{
		lcVector3 Points[8] =
		{
			lcVector3(Box[0], Box[1], Box[5]),
			lcVector3(Box[3], Box[1], Box[5]),
			lcVector3(Box[0], Box[1], Box[2]),
			lcVector3(Box[3], Box[4], Box[5]),
			lcVector3(Box[3], Box[4], Box[2]),
			lcVector3(Box[0], Box[4], Box[2]),
			lcVector3(Box[0], Box[4], Box[5]),
			lcVector3(Box[3], Box[1], Box[2])
		};

		Eye += Center;

		lcMatrix44 ModelView = lcMatrix44LookAt(Eye, Center, lcVector3(0, 0, 1));
		Eye = lcZoomExtents(Eye, ModelView, Projection, Points, 8);

		ViewMatrix = lcMatrix44LookAt(Eye, Center, lcVector3(0, 0, 1));

		// Update the new camera distance.
		lcVector3 d = Eye - Center;
		m_Distance = d.Length();
	}
	else
	{
		ViewMatrix = lcMatrix44LookAt(Eye * m_Distance, Center, lcVector3(0, 0, 1));
	}

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glEnable(GL_POLYGON_OFFSET_FILL);
	glPolygonOffset(0.5f, 0.1f);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glMatrixMode(GL_MODELVIEW);

	float *bg = lcGetActiveProject()->GetBackgroundColor();
	glClearColor(bg[0], bg[1], bg[2], bg[3]);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	Calculate();

	for (int PieceIdx = 0; PieceIdx < LC_MFW_NUMITEMS; PieceIdx++)
	{
		if (!mMinifig->Parts[PieceIdx])
			continue;

		glLoadMatrixf(lcMul(mMinifig->Matrices[PieceIdx], ViewMatrix));
		mMinifig->Parts[PieceIdx]->RenderPiece(mMinifig->Colors[PieceIdx]);
	}

	glDisableClientState(GL_VERTEX_ARRAY);
}

void MinifigWizard::OnLeftButtonDown()
{
	if (m_Tracking == LC_TRACK_NONE)
	{
		m_DownX = mInputState.x;
		m_DownY = mInputState.y;
		m_Tracking = LC_TRACK_LEFT;
		CaptureMouse();
	}
}

void MinifigWizard::OnLeftButtonUp()
{
	if (m_Tracking == LC_TRACK_LEFT)
	{
		m_Tracking = LC_TRACK_NONE;
		ReleaseMouse();
	}
}

void MinifigWizard::OnLeftButtonDoubleClick()
{
	m_AutoZoom = true;
	Redraw();
}

void MinifigWizard::OnRightButtonDown()
{
	if (m_Tracking == LC_TRACK_NONE)
	{
		m_DownX = mInputState.x;
		m_DownY = mInputState.y;
		m_Tracking = LC_TRACK_RIGHT;
		CaptureMouse();
	}
}

void MinifigWizard::OnRightButtonUp()
{
	if (m_Tracking == LC_TRACK_RIGHT)
	{
		m_Tracking = LC_TRACK_NONE;
		ReleaseMouse();
	}
}

void MinifigWizard::OnMouseMove()
{
	if (m_Tracking == LC_TRACK_LEFT)
	{
		// Rotate.
		m_RotateZ += mInputState.x - m_DownX;
		m_RotateX += mInputState.y - m_DownY;

		if (m_RotateX > 179.5f)
			m_RotateX = 179.5f;
		else if (m_RotateX < 0.5f)
			m_RotateX = 0.5f;

		m_DownX = mInputState.x;
		m_DownY = mInputState.y;

		Redraw();
	}
	else if (m_Tracking == LC_TRACK_RIGHT)
	{
		// Zoom.
		m_Distance += (float)(m_DownY - mInputState.y) * 0.2f;
		m_AutoZoom = false;

		if (m_Distance < 0.5f)
			m_Distance = 0.5f;

		m_DownX = mInputState.x;
		m_DownY = mInputState.y;

		Redraw();
	}
}

void MinifigWizard::Calculate()
{
	float HeadOffset = 0.0f;
	lcMatrix44 Root, Mat, Mat2;

	PieceInfo** Parts = mMinifig->Parts;
	float* Angles = mMinifig->Angles;
	lcMatrix44* Matrices = mMinifig->Matrices;

	bool DroidTorso = Parts[LC_MFW_BODY] && !strcmp(Parts[LC_MFW_BODY]->m_strName, "30375");
	bool SkeletonTorso = Parts[LC_MFW_BODY] && !strcmp(Parts[LC_MFW_BODY]->m_strName, "6260");

	if (Parts[LC_MFW_BODY3])
		Root = lcMatrix44Translation(lcVector3(0, 0, 2.96f));
	else
		Root = lcMatrix44Translation(lcVector3(0, 0, 2.88f));
	Matrices[LC_MFW_BODY] = lcMul(mSettings[LC_MFW_BODY][GetSelectionIndex(LC_MFW_BODY)].Offset, Root);

	if (Parts[LC_MFW_NECK])
	{
		Matrices[LC_MFW_NECK] = lcMul(mSettings[LC_MFW_NECK][GetSelectionIndex(LC_MFW_NECK)].Offset, Root);
		HeadOffset = 0.08f;
	}

	if (Parts[LC_MFW_HEAD])
	{
		Mat = lcMatrix44RotationZ(-LC_DTOR * Angles[LC_MFW_HEAD]);
		Mat.SetTranslation(lcVector3(0.0f, 0.0f, 0.96f + HeadOffset));
		Mat = lcMul(mSettings[LC_MFW_HEAD][GetSelectionIndex(LC_MFW_HEAD)].Offset, Mat);
		Matrices[LC_MFW_HEAD] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_HATS])
	{
		Mat = lcMatrix44RotationZ(-LC_DTOR * Angles[LC_MFW_HATS]);
		Mat = lcMul(mSettings[LC_MFW_HATS][GetSelectionIndex(LC_MFW_HATS)].Offset, Mat);
		Matrices[LC_MFW_HATS] = lcMul(Mat, Matrices[LC_MFW_HEAD]);
	}

	if (Parts[LC_MFW_HATS2])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_HATS2]);
		Mat = lcMul(mSettings[LC_MFW_HATS2][GetSelectionIndex(LC_MFW_HATS2)].Offset, Mat);
		Matrices[LC_MFW_HATS2] = lcMul(Mat, Matrices[LC_MFW_HATS]);
	}

	if (Parts[LC_MFW_RARM])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_RARM]);

		if (DroidTorso || SkeletonTorso)
			Mat2 = lcMatrix44Identity();
		else
			Mat2 = lcMatrix44RotationY(-LC_DTOR * 9.791f);
		Mat2.SetTranslation(lcVector3(0.62f, 0, -0.32f));

		Mat = lcMul(mSettings[LC_MFW_RARM][GetSelectionIndex(LC_MFW_RARM)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Matrices[LC_MFW_RARM] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_RHAND])
	{
		Mat = lcMatrix44RotationY(-LC_DTOR * Angles[LC_MFW_RHAND]);
		Mat2 = lcMatrix44RotationX(LC_DTOR * 45);
		Mat = lcMul(mSettings[LC_MFW_RHAND][GetSelectionIndex(LC_MFW_RHAND)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Mat.SetTranslation(lcVector3(0.2f, -0.4f, -0.76f));
		Matrices[LC_MFW_RHAND] = lcMul(Mat, Matrices[LC_MFW_RARM]);
	}

	if (Parts[LC_MFW_RHANDA])
	{
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_RHANDA]);
		Mat.SetTranslation(lcVector3(0, -0.4f, 0));
		Mat = lcMul(mSettings[LC_MFW_RHANDA][GetSelectionIndex(LC_MFW_RHANDA)].Offset, Mat);
		Matrices[LC_MFW_RHANDA] = lcMul(Mat, Matrices[LC_MFW_RHAND]);
	}

	if (Parts[LC_MFW_LARM])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_LARM]);

		if (DroidTorso || SkeletonTorso)
			Mat2 = lcMatrix44Identity();
		else
			Mat2 = lcMatrix44RotationY(LC_DTOR * 9.791f);
		Mat2.SetTranslation(lcVector3(-0.62f, 0.0f, -0.32f));

		Mat = lcMul(mSettings[LC_MFW_LARM][GetSelectionIndex(LC_MFW_LARM)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Matrices[LC_MFW_LARM] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_LHAND])
	{
		Mat = lcMatrix44RotationY(-LC_DTOR * Angles[LC_MFW_LHAND]);
		Mat2 = lcMatrix44RotationX(LC_DTOR * 45);
		Mat = lcMul(mSettings[LC_MFW_LHAND][GetSelectionIndex(LC_MFW_LHAND)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Mat.SetTranslation(lcVector3(-0.2f, -0.4f, -0.76f));
		Matrices[LC_MFW_LHAND] = lcMul(Mat, Matrices[LC_MFW_LARM]);
	}

	if (Parts[LC_MFW_LHANDA])
	{
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_LHANDA]);
		Mat.SetTranslation(lcVector3(0, -0.4f, 0));
		Mat = lcMul(mSettings[LC_MFW_LHANDA][GetSelectionIndex(LC_MFW_LHANDA)].Offset, Mat);
		Matrices[LC_MFW_LHANDA] = lcMul(Mat, Matrices[LC_MFW_LHAND]);
	}

	if (Parts[LC_MFW_BODY2])
	{
		Mat = lcMatrix44Identity();
		Mat.SetTranslation(lcVector3(0, 0, -1.28f));
		Mat = lcMul(mSettings[LC_MFW_BODY2][GetSelectionIndex(LC_MFW_BODY2)].Offset, Mat);
		Matrices[LC_MFW_BODY2] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_BODY3])
	{
		Mat = lcMatrix44Identity();
		Mat.SetTranslation(lcVector3(0, 0, -1.28f));
		Mat = lcMul(mSettings[LC_MFW_BODY3][GetSelectionIndex(LC_MFW_BODY3)].Offset, Mat);
		Matrices[LC_MFW_BODY3] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_RLEG])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_RLEG]);
		Mat.SetTranslation(lcVector3(0, 0, -1.76f));
		Mat = lcMul(mSettings[LC_MFW_RLEG][GetSelectionIndex(LC_MFW_RLEG)].Offset, Mat);
		Matrices[LC_MFW_RLEG] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_RLEGA])
	{
		lcVector3 Center(-0.4f, -0.04f, -1.12f);
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_RLEGA]);
		Mat2 = mSettings[LC_MFW_RLEGA][GetSelectionIndex(LC_MFW_RLEGA)].Offset;
		Mat2.SetTranslation(lcMul31(-Center, Mat2));
		Mat = lcMul(Mat2, Mat);
		Mat.SetTranslation(lcMul31(Center, Mat2));
		Matrices[LC_MFW_RLEGA] = lcMul(Mat, Matrices[LC_MFW_RLEG]);
	}

	if (Parts[LC_MFW_LLEG])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_LLEG]);
		Mat.SetTranslation(lcVector3(0, 0, -1.76f));
		Mat = lcMul(mSettings[LC_MFW_LLEG][GetSelectionIndex(LC_MFW_LLEG)].Offset, Mat);
		Matrices[LC_MFW_LLEG] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_LLEGA])
	{
		lcVector3 Center(0.4f, -0.04f, -1.12f);
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_LLEGA]);
		Mat2 = mSettings[LC_MFW_LLEGA][GetSelectionIndex(LC_MFW_LLEGA)].Offset;
		Mat2.SetTranslation(lcMul31(-Center, Mat2));
		Mat = lcMul(Mat2, Mat);
		Mat.SetTranslation(lcMul31(Center, Mat2));
		Matrices[LC_MFW_LLEGA] = lcMul(Mat, Matrices[LC_MFW_LLEG]);
	}
}

int MinifigWizard::GetSelectionIndex(int Type) const
{
	const lcArray<lcMinifigPieceInfo>& InfoArray = mSettings[Type];

	for (int Index = 0; Index < InfoArray.GetSize(); Index++)
		if (InfoArray[Index].Info == mMinifig->Parts[Type])
			return Index;

	return 0;
}

void MinifigWizard::SetSelectionIndex(int Type, int Index)
{
	if (mMinifig->Parts[Type])
		mMinifig->Parts[Type]->Release();

	mMinifig->Parts[Type] = mSettings[Type][Index].Info;

	if (mMinifig->Parts[Type])
		mMinifig->Parts[Type]->AddRef();

	Calculate();
}

void MinifigWizard::SetColor(int Type, int Color)
{
	mMinifig->Colors[Type] = Color;
}

void MinifigWizard::SetAngle(int Type, float Angle)
{
	mMinifig->Angles[Type] = Angle;
}
