#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
# Copyright (c) 2011 John S Gruber <johnsgruber@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gtk
import gobject
import pango
import time

from lernid.LernidPreferences import Preferences
from lernid.widgets.IrcWidget import IrcWidget

from lernid import IrcBackend
from lernid.LernidOptions import Options
from lernid.Statusbar import Statusbar

class Classroom(IrcWidget):

    __gtype_name__ = 'LernidClassroom'

    __gsignals__ = {
        'message-received': (
            gobject.SIGNAL_RUN_LAST, None, (object, str, str)
        ),
    }

    def __init__(self):
        IrcWidget.__init__(self, 'classroom')
        viewport = gtk.Viewport()
        scroll = gtk.ScrolledWindow()
        scroll.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self._adjust = scroll.get_vadjustment()
        viewport.add(scroll)
        self.add(viewport)

        self._textview = gtk.TextView()
        self._textview.set_editable(False)
        self._textview.set_cursor_visible(False)
        self._textview.set_wrap_mode(gtk.WRAP_WORD)
        self._textview.set_left_margin(6)
        self._textview.set_right_margin(6)
        self._textview.modify_font(pango.FontDescription('Monospace'))
        self._textview.set_sensitive(False)
        self._textview.connect('size-allocate', self._scroll)
        self._at_bottom = None
        scroll.add(self._textview)

        self._buffer = self._textview.get_buffer()
        text_color = self._textview.get_style().text[gtk.STATE_INSENSITIVE]
        self._buffer.create_tag('gray', foreground_gdk=text_color)
        self._buffer.create_tag('highlight', weight=700)
        self._buffer.create_tag('italicize', style=pango.STYLE_ITALIC)
        self._init_hyperlinks()

        self.show_all()

    def do_event_connect(self, event_man, event):
        IrcWidget.do_event_connect(self, event_man, event)
        self._server = IrcBackend.Server.get_server('irc.freenode.net', event.nick, event_man)
        self._nick = event.nick
        channelname = Options.get('classroom', event.classroom)
        if channelname[0] not in '#&!+':
            channelname = '#' + channelname
        classchan = self._server.get_channel(channelname)
        self._chan = classchan  # Save for IRC widget use
        def joined(server):
            Statusbar.push_message(_('Joined classroom'),  duration=10)
            self._textview.set_sensitive(True)
        self.event_connect_signal(classchan, 'joined', joined)
        self.event_connect_signal(classchan, 'message-received', self._message_received)
        self._browser = event_man.get_widget_by_name('browser')

    def do_event_disconnect(self, event_man, event):
        self._textview.set_sensitive(False)
        istart, iend = self._buffer.get_bounds()
        self._buffer.delete(istart, iend)
        self._server.disconnect()
        self.event_disconnect_signals()

    def _message_received(self, chan, sender, text, msgtype):
        self._append_to_buffer(text, sender, msgtype)
        self.emit('message-received', chan, sender, text)

    def _scroll(self, textview, alloc):
        if self._at_bottom is None:
            self._at_bottom = True
        if self._at_bottom:
            self._adjust.value = self._adjust.upper - self._adjust.page_size

