#!/usr/bin/python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import os.path
import gtk

from lernid.lernidconfig import get_data_path
from lernid.EventManager import EventManager

class Widget(gtk.Bin):

    __gtype_name__ = 'LernidWidget'

    def __init__(self, name):
        gtk.Bin.__init__(self)
        self._name = name
        self._connected_signals = []
        event_man = EventManager.get_instance()
        event_man.register_widget(self)
        event_man.connect('event-connect', self.do_event_connect)
        event_man.connect('event-disconnect', self.do_event_disconnect)

    @property
    def name(self):
        return self._name

    def builder_with_file(self, filename):
        path = get_data_path('ui', filename)
        builder = gtk.Builder()
        builder.add_from_file(path)
        return builder

    def do_size_request(self, req):
        child = self.get_child()
        if child:
            child.size_request()

    def do_size_allocate(self, alloc):
        child = self.get_child()
        if child:
            child.size_allocate(alloc)

    def event_connect_signal(self, obj, signal, callback):
        hid = obj.connect(signal, callback)
        self._connected_signals.append((obj, hid))

    def event_disconnect_signals(self):
        for obj, hid in self._connected_signals:
            if obj.handler_is_connected(hid):
                obj.disconnect(hid)
        self._connected_signals = []

    def do_event_connect(self, eventman, event):
        pass

    def do_event_disconnect(self, eventman, event):
        pass
